/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.batch.acctext;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.eas.fi.gr.cslrpt.util.CslConstant;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.rpt.app.AccountItem;
import com.kingdee.eas.fi.rpt.app.AssistantItem;
import com.kingdee.eas.fi.rpt.app.AsstActType;
import com.kingdee.eas.fi.rpt.batch.BatchHelper;
import com.kingdee.eas.fi.rpt.batch.acctext.Acctext;
import com.kingdee.eas.fi.rpt.batch.acctext.AcctextBatchCalculator;
import com.kingdee.eas.fi.rpt.batch.acctext.IAcctextCalculateProcessor;
import com.kingdee.eas.fi.rpt.batch.acctext.VoucherResposit;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AccrualWithOppAccountNOAsstactProcessor
implements IAcctextCalculateProcessor {
    private List formulaList = new ArrayList();
    private Set nullFields = new HashSet();
    private VoucherResposit voucherResposit;

    public AccrualWithOppAccountNOAsstactProcessor() {
        this.nullFields.add("currency");
        this.nullFields.add("isincludingUnPosted");
        this.voucherResposit = new VoucherResposit();
    }

    @Override
    public void calculate(BatchHelper batchHelper) throws BOSException {
        for (Acctext acctext : this.formulaList) {
            this.calculateEachAcctext(batchHelper.getServerContext(), acctext);
        }
    }

    private void buildAssistantItemSql(StringBuffer fromSql, StringBuffer whereSql, Acctext acctext, List params, boolean isAccountItem) {
        AccountItem accountItem = null;
        String asstTypeAlias = null;
        String assistantHGAlias = null;
        String voucherAssistRecordAlias = null;
        String voucherEntryAlias = null;
        if (isAccountItem) {
            accountItem = acctext.accountItem;
            asstTypeAlias = "A_AsstType";
            assistantHGAlias = "A_Hg";
            voucherAssistRecordAlias = "A_Record";
            voucherEntryAlias = "voucherEntry";
        } else {
            accountItem = acctext.oppAccountItem;
            asstTypeAlias = "B_AsstType";
            assistantHGAlias = "B_Hg";
            voucherAssistRecordAlias = "B_Record";
            voucherEntryAlias = "veB";
        }
        fromSql.append(",T_BD_AssistantHG ").append(assistantHGAlias).append("," + this.voucherResposit.getTableName(acctext.orgType, "VoucherAssistRecord") + " ").append(voucherAssistRecordAlias);
        whereSql.append(" and ").append(voucherEntryAlias).append(".fid = ").append(voucherAssistRecordAlias).append(".FEntryID        \n");
        whereSql.append(" and ").append(voucherAssistRecordAlias).append(".FAssGrpID = ").append(assistantHGAlias).append(".fid        \n");
        for (AssistantItem asstItem : accountItem.getItemTypes().values()) {
            String numberField;
            boolean isNotBlankForEndNumber;
            boolean isUseLongNumber;
            AsstActType itemType = asstItem.itemType;
            fromSql.append(",").append(itemType.realtionDataObject).append(" ").append(asstTypeAlias).append(itemType.number);
            whereSql.append(" and ").append(assistantHGAlias).append(".").append(itemType.mappingFieldName).append(" = ").append(asstTypeAlias).append(itemType.number).append(".FID     \n");
            if (itemType.realtionDataObject.equalsIgnoreCase("T_BD_GeneralAsstActType")) {
                whereSql.append(" and ").append(asstTypeAlias).append(itemType.number).append(".FGroupID=? ");
                params.add(itemType.glAsstActTypeGrpID);
            }
            String startNumber = (isUseLongNumber = RptUtil.isUseLongNumber(itemType.useLongNumber, itemType.realtionDataObject)) ? asstItem.startItem.longNumber : asstItem.startItem.number;
            String endNumber = isUseLongNumber ? asstItem.endItem.longNumber : asstItem.endItem.number;
            String asstTypeTableName = asstTypeAlias + itemType.number;
            boolean isNotBlankForStartNumber = !StringUtils.isEmpty((String)startNumber);
            boolean bl = isNotBlankForEndNumber = !StringUtils.isEmpty((String)endNumber);
            if (isNotBlankForStartNumber && isNotBlankForEndNumber && startNumber.equals(endNumber)) {
                if (isUseLongNumber) {
                    whereSql.append(" and ( ").append(asstTypeTableName).append(".FLongNumber = ? or ").append(asstTypeTableName).append(".FLongNumber like ? ) ");
                    params.add(startNumber);
                    params.add(startNumber + "!");
                    continue;
                }
                whereSql.append(" and ").append(asstTypeTableName).append(".FNumber = ? ");
                params.add(asstItem.startItem.number);
                continue;
            }
            String string = numberField = isUseLongNumber ? "FLongNumber" : "FNumber";
            if (isNotBlankForStartNumber) {
                whereSql.append(" and ");
                whereSql.append(asstTypeTableName).append(".").append(numberField).append(" >= ? ");
                params.add(startNumber);
            }
            if (!isNotBlankForEndNumber) continue;
            whereSql.append(" and ");
            whereSql.append(asstTypeTableName).append(".").append(numberField).append(" <= ? ");
            params.add(endNumber);
        }
    }

    private void innerBuildSelectPart(StringBuffer sql, Acctext acctext) {
        String accountItemTableAlias = null;
        String oppAccountItemTableAlias = null;
        accountItemTableAlias = acctext.accountItem != null && acctext.accountItem.hasItem() ? "A_Record" : "voucherEntry";
        oppAccountItemTableAlias = acctext.oppAccountItem != null && acctext.oppAccountItem.hasItem() ? "B_Record" : "veB";
        if ("GRC".equals(acctext.currency.getNumber()) || AcctextBatchCalculator.reportingSet.contains((Object)acctext.vchGetType)) {
            sql.append(" select sum(").append(accountItemTableAlias).append(".FReportingAmount) A_Value, voucherEntry.FEntryDc A_DC,                     \n");
            sql.append(" sum(").append(oppAccountItemTableAlias).append(".FReportingAmount) B_Value,veB.FEntryDc B_DC,voucher.FID VoucherID,").append(accountItemTableAlias).append(".FID entryId,").append(oppAccountItemTableAlias).append(".FID oppEntryId  \n");
        } else if ("GLC".equals(acctext.currency.getNumber()) || AcctextBatchCalculator.localSet.contains((Object)acctext.vchGetType)) {
            sql.append(" select sum(").append(accountItemTableAlias).append(".FLocalAmount) A_Value,voucherEntry.FEntryDc A_DC,                          \n");
            sql.append(" sum(").append(oppAccountItemTableAlias).append(".FLocalAmount) B_Value,veB.FEntryDc B_DC,voucher.FID VoucherID,").append(accountItemTableAlias).append(".FID entryId,").append(oppAccountItemTableAlias).append(".FID oppEntryId  \n");
        } else {
            sql.append(" select sum(").append(accountItemTableAlias).append(".FOriginalAmount) A_Value, voucherEntry.FEntryDc A_DC,                     \n");
            sql.append(" sum(").append(oppAccountItemTableAlias).append(".FOriginalAmount) B_Value,veB.FEntryDc B_DC,voucher.FID VoucherID,").append(accountItemTableAlias).append(".FID entryId,").append(oppAccountItemTableAlias).append(".FID oppEntryId  \n");
        }
    }

    private void calculateEachAcctext(Context ctx, Acctext acctext) throws BOSException {
        StringBuffer sql = new StringBuffer();
        StringBuffer fromSql = new StringBuffer();
        StringBuffer whereSql = new StringBuffer();
        ArrayList<Object> params = new ArrayList<Object>();
        if (acctext.accountItem.hasItem()) {
            this.buildAssistantItemSql(fromSql, whereSql, acctext, params, true);
        }
        if (acctext.oppAccountItem.hasItem()) {
            this.buildAssistantItemSql(fromSql, whereSql, acctext, params, false);
        }
        this.innerBuildSelectPart(sql, acctext);
        sql.append(" From " + this.voucherResposit.getTableName(acctext.orgType, "Voucher") + " voucher," + this.voucherResposit.getTableName(acctext.orgType, "VoucherEntry") + " voucherEntry,   \n");
        sql.append(" T_BD_AccountView A_Account ," + this.voucherResposit.getTableName(acctext.orgType, "VoucherEntry") + " veB ,T_BD_AccountView B_Account     \n");
        if (!StringUtils.isEmpty((String)acctext.userDefineFiter) && acctext.userDefineFiter.indexOf("VoucherType") > -1) {
            sql.append(" ,T_BD_VoucherTypes VoucherType \t\t    \n");
        }
        if (fromSql.length() > 0) {
            sql.append(fromSql);
        }
        sql.append(" where  A_Account.FIsLeaf = 1 \t\t\t\t    \n");
        sql.append(" and B_Account.FIsLeaf = 1 \t\t\t\t\t    \n");
        sql.append(" and voucher.FID = voucherEntry.FBillID  \t    \n");
        sql.append(" and voucherEntry.FAccountID = A_Account.Fid    \n");
        sql.append(" and veB.FAccountID = B_Account.Fid  \t\t    \n");
        sql.append(" and veB.FBillId = voucherEntry.FBillId  \t    \n");
        if (acctext.currencyString == null || !acctext.currencyString.toUpperCase().equalsIgnoreCase("GLC") && !acctext.currencyString.toUpperCase().equalsIgnoreCase("GRC")) {
            sql.append(" and veB.FCurrencyID = voucherEntry.FCurrencyID \n");
        }
        if (!StringUtils.isEmpty((String)acctext.userDefineFiter) && acctext.userDefineFiter.indexOf("VoucherType") > -1) {
            sql.append("and VoucherType.FID = voucher.FVoucherTypeID \n");
        }
        if (whereSql.length() > 0) {
            sql.append(whereSql);
        }
        sql.append(" and voucher.FBizStatus <>0 and voucher.FBizStatus <>2  \n");
        if (!acctext.isincludingUnPosted) {
            sql.append(" and voucher.FBizStatus=5  \t\t\t\t    \n");
        }
        sql.append(" and voucher.").append(this.voucherResposit.getFieldName(acctext.orgType, "Voucher")).append(" = ?  \t\t\t\t    \n");
        params.add(acctext.company.getId().toString());
        if (!acctext.getNullFields().contains("currency")) {
            sql.append(" and voucherEntry.FCurrencyID=  ?           \n");
            params.add(acctext.currency.getId().toString());
        }
        sql.append(" and voucherEntry.FEntryDC= ?                \n");
        params.add(acctext.DC);
        sql.append(" and voucher.FBookedDate>= ?                    \n");
        params.add(new Timestamp(acctext.startDate.getTimeInMillis()));
        sql.append(" and voucher.FBookedDate <= ?                   \n");
        params.add(new Timestamp(acctext.endDate.getTimeInMillis()));
        if (!StringUtils.isEmpty((String)acctext.userDefineFiter)) {
            sql.append(" and (" + this.reviseFilter(acctext.userDefineFiter, ctx) + ")\n");
        }
        if (acctext.accountItem.isSingleAccount()) {
            sql.append(" and A_Account.Fnumber like ?");
            params.add(acctext.accountItem.startAccount.number + "%");
        } else {
            if (acctext.accountItem.startAccount.number.length() > 0) {
                sql.append(" and A_Account.Fnumber >= ? ");
                params.add(acctext.accountItem.startAccount.number);
            }
            if (!StringUtils.isEmpty((String)acctext.accountItem.endAccount.number)) {
                sql.append(" and (A_Account.Fnumber <= ? or A_Account.Fnumber like ?) ");
                params.add(acctext.accountItem.endAccount.number);
                params.add(acctext.accountItem.endAccount.number + "%");
            }
        }
        if (acctext.oppAccountItem.isSingleAccount()) {
            sql.append(" and B_Account.Fnumber like ?");
            params.add(acctext.oppAccountItem.startAccount.number + "%");
        } else {
            sql.append(" and (B_Account.Fnumber >= ? and B_Account.Fnumber <= ? or B_Account.Fnumber like ?)");
            params.add(acctext.oppAccountItem.startAccount.number);
            params.add(acctext.oppAccountItem.endAccount.number);
            params.add(acctext.oppAccountItem.endAccount.number + "%");
        }
        sql.append(" group by voucher.FID");
        if (acctext.accountItem != null && acctext.accountItem.hasItem()) {
            sql.append(",A_Record.FID");
        } else {
            sql.append(",voucherEntry.FID");
        }
        if (acctext.oppAccountItem != null && acctext.oppAccountItem.hasItem()) {
            sql.append(",B_Record.FID");
        } else {
            sql.append(",veB.FID");
        }
        sql.append(",voucherEntry.FEntryDc");
        sql.append(",veB.FEntryDc");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params.toArray());
        BigDecimal result = CslConstant.BGZERO;
        ArrayList voucherList = new ArrayList();
        try {
            while (rowSet.next()) {
                String voucherId = rowSet.getString("VoucherID");
                BigDecimal bigDecimal = rowSet.getBigDecimal("A_Value");
                int entrydc = rowSet.getInt("A_DC");
                BigDecimal B_Value = rowSet.getBigDecimal("B_Value");
                int oppentrydc = rowSet.getInt("B_DC");
                HashMap voucherMap = new HashMap();
                HashMap<String, Number> valueMap = new HashMap<String, Number>();
                voucherMap.put(voucherId, valueMap);
                valueMap.put("A_Value", bigDecimal);
                valueMap.put("A_DC", entrydc);
                valueMap.put("B_Value", B_Value);
                valueMap.put("B_DC", oppentrydc);
                voucherList.add(voucherMap);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        for (Map map : voucherList) {
            for (String voucherId : map.keySet()) {
                int B_DC;
                Map valueMap = (Map)map.get(voucherId);
                BigDecimal A_Value = (BigDecimal)valueMap.get("A_Value");
                BigDecimal B_Value = (BigDecimal)valueMap.get("B_Value");
                int A_DC = (Integer)valueMap.get("A_DC");
                if (A_DC != (B_DC = ((Integer)valueMap.get("B_DC")).intValue())) {
                    if (A_Value.compareTo(B_Value) < 0) {
                        result = result.add(A_Value);
                        continue;
                    }
                    result = result.add(B_Value);
                    continue;
                }
                if (A_Value.abs().compareTo(B_Value.abs()) < 0) {
                    result = result.add(A_Value.abs());
                    continue;
                }
                result = result.add(B_Value.abs());
            }
        }
        if (acctext.getParameter().getValue() != null) {
            BigDecimal oldValue = null;
            try {
                oldValue = new BigDecimal(acctext.getParameter().getValue().toString());
            }
            catch (Exception exception) {
                oldValue = CslConstant.BGZERO;
            }
            result = result.add(oldValue);
        }
        acctext.getParameter().setValue((Object)result);
    }

    @Override
    public boolean submitFormula(Acctext acctext) {
        this.formulaList.add(acctext);
        return true;
    }

    private String reviseFilter(String filter, Context ctx) {
        filter = filter.replaceAll("VoucherNumber", "voucher.FNumber").replaceAll("AttachementNumber", "voucher.FAttachments").replaceAll("CountAmount", "voucher.FLocalDebitAmount").replaceAll("RecNum", "voucher.FEntryCount").replaceAll("RecSrcNumber", "voucherEntry.FOriginalAmount").replaceAll("VoucherType", "VoucherType.FNumber").replaceAll("RefInformation", "voucher.FDescription").replaceAll("Summary", "voucherEntry.FDescription");
        return filter;
    }
}

