/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.batch.acctext;

import com.kingdee.eas.fi.gr.cslrpt.util.CslConstant;
import com.kingdee.eas.fi.rpt.app.AssistantItem;
import com.kingdee.eas.fi.rpt.batch.IFormulaCalculator;
import com.kingdee.eas.fi.rpt.batch.IFormulaCombinationPreparedState;
import com.kingdee.eas.fi.rpt.batch.acctext.Acctext;
import com.kingdee.eas.fi.rpt.batch.acctext.AcctextBatchCalculator;
import com.kingdee.eas.fi.rpt.batch.acctext.AcctextRootBuilder;
import com.kingdee.eas.fi.rpt.util.AcctountAsstItemParser;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;

public class AcctextAccrualCombinaState
implements IFormulaCombinationPreparedState {
    private BigDecimal reporting;
    private BigDecimal local;
    private BigDecimal original;
    private String accountNumber;
    private String accountNumberByDC;
    private Map longNumberMap = new HashMap();

    @Override
    public Object getFormulaResultValue(IFormulaCalculator formula) {
        Acctext acctext = (Acctext)formula;
        BigDecimal returnVal = null;
        returnVal = "GLC".equals(acctext.currency.getNumber()) ? this.local : ("GRC".equals(acctext.currency.getNumber()) ? this.reporting : (AcctextBatchCalculator.originalSet.contains((Object)acctext.vchGetType) ? this.original : (AcctextBatchCalculator.localSet.contains((Object)acctext.vchGetType) ? this.local : (AcctextBatchCalculator.reportingSet.contains((Object)acctext.vchGetType) ? this.reporting : this.original))));
        if (!AcctextRootBuilder.isGetAccrualAmount(acctext.vchGetType)) {
            returnVal = this.getReturnValueWithDC(acctext, returnVal);
        }
        return returnVal;
    }

    private BigDecimal getReturnValueWithDC(Acctext acctext, BigDecimal returnVal) {
        String startAccount = null;
        String endAccount = null;
        String acountDC = null;
        AcctountAsstItemParser.AccountAsstItem acctitem = acctext.accountItem.getAccountAsstItem();
        if (acctitem.accounts != null) {
            for (int i = 0; i < acctitem.accounts.length; ++i) {
                startAccount = acctitem.accounts[i].startNumber;
                endAccount = acctitem.accounts[i].endNumber;
                acountDC = !startAccount.equals(endAccount) ? this.getAccountsDC(acctext, startAccount, endAccount) : this.getAccountDC(acctext, startAccount);
            }
        }
        if (!StringUtils.isEmpty((String)acctext.opposingAccount) && (StringUtils.isEmpty(acountDC) || "null".equalsIgnoreCase(acountDC))) {
            AcctountAsstItemParser.AccountAsstItem oppAcctitem = acctext.oppAccountItem.getAccountAsstItem();
            String oppStartAccount = oppAcctitem.startNumber;
            String oppEndAccount = oppAcctitem.endNumber;
            acountDC = !oppStartAccount.equals(oppEndAccount) ? this.getAccountsDC(acctext, oppStartAccount, oppEndAccount) : this.getAccountDC(acctext, oppStartAccount);
        }
        if (acountDC != null) {
            returnVal = returnVal.multiply(new BigDecimal(acountDC));
        }
        return returnVal;
    }

    private String getAccountsDC(Acctext acctext, String startAccount, String endAccount) {
        String companyId;
        String acountDC = null;
        if (this.accountNumberByDC.substring(0, startAccount.length()).compareTo(startAccount) >= 0 && this.accountNumberByDC.substring(0, endAccount.length()).compareTo(endAccount) <= 0 && (StringUtils.isEmpty((String)(acountDC = String.valueOf(acctext.accountDC.get((companyId = acctext.company.getId().toString()) + "!" + this.accountNumberByDC)))) || "null".equalsIgnoreCase(acountDC))) {
            for (int j = 0; j < acctext.accountNumbers.size(); ++j) {
                String accountHeader = this.accountNumberByDC.substring(0, acctext.accountNumbers.get(j).toString().length());
                if (!accountHeader.equals(acctext.accountNumbers.get(j))) continue;
                acountDC = String.valueOf(acctext.accountDC.get(companyId + "!" + accountHeader));
            }
        }
        return acountDC;
    }

    private String getAccountDC(Acctext acctext, String account) {
        String acountDC = null;
        if (this.accountNumberByDC.substring(0, account.length()).equals(account)) {
            String key = acctext.company.getId().toString() + "!" + account;
            acountDC = String.valueOf(acctext.accountDC.get(key));
        }
        return acountDC;
    }

    @Override
    public boolean isFormulaResultNumberValue(IFormulaCalculator formula) {
        return true;
    }

    @Override
    public boolean isPrepared(IFormulaCalculator formula) {
        Acctext acctext = (Acctext)formula;
        if (this.accountNumber != null && !this.accountNumber.startsWith(acctext.accountItem.getAccountAsstItem().startNumber)) {
            return false;
        }
        if (this.longNumberMap.size() > 0) {
            for (Map.Entry entry : this.longNumberMap.entrySet()) {
                String typeNumber = (String)entry.getKey();
                String longNumber = (String)entry.getValue();
                AssistantItem item = acctext.accountItem.getItem(typeNumber);
                if (item.startItem.longNumber.equals(longNumber) || longNumber.startsWith(item.startItem.longNumber + "!")) continue;
                return false;
            }
        }
        return true;
    }

    public void setReporting(BigDecimal bigDecimal) {
        this.reporting = bigDecimal == null ? CslConstant.BGZERO : bigDecimal;
    }

    public void setLocal(BigDecimal bigDecimal) {
        this.local = bigDecimal == null ? CslConstant.BGZERO : bigDecimal;
    }

    public void setOriginal(BigDecimal bigDecimal) {
        this.original = bigDecimal == null ? CslConstant.BGZERO : bigDecimal;
    }

    public void setAccountNumber(String string) {
        this.accountNumber = string;
    }

    public void setAccountNumberByDC(String accountNumber) {
        this.accountNumberByDC = accountNumber;
    }

    public Map getLongNumberMap() {
        return this.longNumberMap;
    }
}

