/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.batch.acctext;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.fi.gr.cslrpt.app.paramhandle.ColumnInfo;
import com.kingdee.eas.fi.gr.cslrpt.app.paramhandle.ParamTempTblService;
import com.kingdee.eas.fi.gr.cslrpt.app.paramhandle.TableInfo;
import com.kingdee.eas.fi.rpt.batch.acctext.Acctext;
import com.kingdee.eas.fi.rpt.util.AcctountAsstItemParser;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.JdbcRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class AcctextDCSetting {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.rpt.batch.acctext.AcctextDCSetting");
    private List acctextList = null;
    private Context serverContext = null;
    private static final int BATCH_IN_SIZE = 100;
    private Set companySet = null;
    private Set accountSet = null;

    public AcctextDCSetting(List formulaList, Context serverContext) {
        this.acctextList = formulaList;
        this.serverContext = serverContext;
    }

    private void getAccountAndCompanyInfo() {
        this.companySet = new HashSet();
        this.accountSet = new HashSet();
        for (Acctext acctext : this.acctextList) {
            if (!StringUtils.isEmpty((String)acctext.opposingAccount)) {
                AcctountAsstItemParser.AccountAsstItem oppAcctitem = acctext.oppAccountItem.getAccountAsstItem();
                this.getAccounts(oppAcctitem);
            }
            AcctountAsstItemParser.AccountAsstItem acctitem = acctext.accountItem.getAccountAsstItem();
            this.getAccounts(acctitem);
            String companyid = acctext.company.getId().toString();
            if (this.companySet.contains(companyid)) continue;
            this.companySet.add(companyid);
        }
    }

    private void getAccounts(AcctountAsstItemParser.AccountAsstItem acctitem) {
        String startAccount = null;
        String endAccount = null;
        if (acctitem.accounts != null) {
            for (int i = 0; i < acctitem.accounts.length; ++i) {
                StringBuffer sqlCondition = new StringBuffer();
                startAccount = acctitem.accounts[i].startNumber;
                endAccount = acctitem.accounts[i].endNumber;
                sqlCondition.append(" (A_Account.fnumber >= '").append(startAccount).append("'").append(" AND A_Account.fnumber <= '").append(endAccount).append("' ) ");
                if (this.accountSet.contains(sqlCondition.toString())) continue;
                this.accountSet.add(sqlCondition.toString());
            }
        }
    }

    public void getAcctextDC() {
        this.getAccountAndCompanyInfo();
        this.getAccountDC();
    }

    private void getAccountDC() {
        try {
            IRowSet rowSet = this.getParentAccountNumber(this.accountSet, this.companySet);
            while (rowSet.next()) {
                String rowsetAccount = rowSet.getString("accountNumber");
                String rowsetAccountDC = String.valueOf(rowSet.getObject("accountDC"));
                String rowsetAccountLevel = String.valueOf(rowSet.getObject("accountLevel"));
                String rowsetCompanyId = rowSet.getString("companyId");
                String key = rowsetCompanyId + "!" + rowsetAccount;
                Iterator iterator = this.acctextList.iterator();
                while (iterator.hasNext()) {
                    String startAccount = null;
                    String endAccount = null;
                    Acctext acctext = (Acctext)iterator.next();
                    if (acctext.accountDC == null) {
                        acctext.accountDC = new HashMap();
                    }
                    if (acctext.accountNumbers == null) {
                        acctext.accountNumbers = new ArrayList();
                    }
                    AcctountAsstItemParser.AccountAsstItem acctitem = acctext.accountItem.getAccountAsstItem();
                    if (acctitem.accounts == null) continue;
                    for (int i = 0; i < acctitem.accounts.length; ++i) {
                        startAccount = acctitem.accounts[i].startNumber;
                        endAccount = acctitem.accounts[i].endNumber;
                        if (!startAccount.equals(endAccount)) {
                            if (!rowsetAccountLevel.equals(String.valueOf(acctext.accountLevel)) || rowsetAccount.compareTo(startAccount) < 0 || rowsetAccount.compareTo(endAccount) > 0) continue;
                            acctext.accountDC.put(key, rowsetAccountDC);
                            acctext.accountNumbers.add(rowsetAccount);
                            continue;
                        }
                        if (!rowsetAccount.equals(startAccount)) continue;
                        acctext.accountDC.put(key, rowsetAccountDC);
                        acctext.accountNumbers.add(rowsetAccount);
                    }
                    if (StringUtils.isEmpty((String)acctext.opposingAccount)) continue;
                    AcctountAsstItemParser.AccountAsstItem oppAcctitem = acctext.oppAccountItem.getAccountAsstItem();
                    String oppStartAccount = oppAcctitem.startNumber;
                    String oppEndAccount = oppAcctitem.endNumber;
                    if (!oppStartAccount.equals(oppEndAccount)) {
                        if (rowsetAccount.compareTo(oppStartAccount) < 0 || rowsetAccount.compareTo(oppEndAccount) > 0) continue;
                        acctext.accountDC.put(key, rowsetAccountDC);
                        acctext.accountNumbers.add(rowsetAccount);
                        continue;
                    }
                    if (!rowsetAccount.equals(oppStartAccount)) continue;
                    acctext.accountDC.put(key, rowsetAccountDC);
                    acctext.accountNumbers.add(rowsetAccount);
                }
            }
        }
        catch (SQLException e) {
            logger.error((Object)"acctext.getParentAccountNumberResultSet", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IRowSet getParentAccountNumber(Set accountNumber, Set companyid) {
        JdbcRowSet rowset;
        block9: {
            ResultSet resultSet;
            PreparedStatement ps;
            Connection conn;
            block8: {
                ParamTempTblService companyService = null;
                StringBuffer accountBuf = new StringBuffer();
                StringBuffer executeSQL = new StringBuffer();
                ArrayList<String> accountList = new ArrayList<String>();
                conn = null;
                ps = null;
                rowset = null;
                resultSet = null;
                try {
                    companyService = this.getCompanyTempTable(companyid);
                    String companyTempTable = companyService.getTmpTableName();
                    StringBuffer newSqlBuf = new StringBuffer();
                    newSqlBuf.append("SELECT  distinct   A_Account.fnumber accountNumber,A_Account.fdc accountDC,A_Account.flevel accountLevel,A_Account.fcompanyid companyId \r\n");
                    newSqlBuf.append(" FROM T_BD_AccountView  A_Account \r\n");
                    newSqlBuf.append(" INNER JOIN T_BD_AccountView A_Acct on  A_Acct.FCompanyID = A_Account.FCompanyID and ");
                    newSqlBuf.append(" A_Acct.FAccountTableID = A_Account.FAccountTableID and A_Account.flevel = A_Acct.flevel \r\n");
                    newSqlBuf.append(" INNER JOIN  " + companyTempTable + " company ON  A_Account.fcompanyid = company.FID \r\n");
                    conn = EJBFactory.getConnection((Context)this.serverContext);
                    rowset = new JdbcRowSet();
                    accountBuf.append(" WHERE ");
                    Iterator itAccount = accountNumber.iterator();
                    while (itAccount.hasNext()) {
                        String temId = (String)itAccount.next();
                        accountBuf.append(temId).append("\r\n");
                        accountList.add(temId);
                        if (itAccount.hasNext() && accountList.size() <= 100) {
                            accountBuf.append(" OR ");
                        }
                        if (accountList.size() <= 100 && itAccount.hasNext()) continue;
                        executeSQL.append(newSqlBuf).append(accountBuf);
                        ps = conn.prepareStatement(executeSQL.toString());
                        resultSet = ps.executeQuery();
                        rowset.populate(resultSet);
                        accountList.clear();
                        accountBuf.setLength(0);
                        accountBuf.append(" WHERE ");
                        executeSQL.setLength(0);
                    }
                    if (companyService == null) break block8;
                }
                catch (Exception e) {
                    logger.error((Object)"acctext.getParentAccountNumber", (Throwable)e);
                    break block9;
                }
                finally {
                    if (companyService != null) {
                        companyService.release();
                    }
                    SQLUtils.cleanup(resultSet, ps, conn);
                }
                companyService.release();
            }
            SQLUtils.cleanup(resultSet, ps, (Connection)conn);
        }
        return rowset;
    }

    private ParamTempTblService getCompanyTempTable(Set companyid) throws BOSException {
        TableInfo table = new TableInfo("t_temp_company");
        table.addColumn(new ColumnInfo("fid", "varchar(44)"));
        ParamTempTblService service = ParamTempTblService.getInstance((Context)this.serverContext, (TableInfo)table, (Collection)companyid, null);
        return service;
    }
}

