/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.batch.acctext;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.fi.rpt.app.AssistantItem;
import com.kingdee.eas.fi.rpt.batch.BatchHelper;
import com.kingdee.eas.fi.rpt.batch.IFormulaCalculator;
import com.kingdee.eas.fi.rpt.batch.IFormulaCombinationPreparedState;
import com.kingdee.eas.fi.rpt.batch.OneToManyMap;
import com.kingdee.eas.fi.rpt.batch.acctext.Acctext;
import com.kingdee.eas.fi.rpt.batch.acctext.AcctextCombinestate;
import com.kingdee.eas.fi.rpt.batch.acctext.BalanceNullAsstBatchProcessor;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BalanceWithlAssDetailBatchProcessor
extends BalanceNullAsstBatchProcessor {
    private Map table2Column;
    private List typeOrder;
    private List singleList;
    private Map asstActWithDetailMap = new OneToManyMap();
    private Map tableColumnCache;
    private List tableColumnList;
    private boolean isSingle = false;

    public BalanceWithlAssDetailBatchProcessor() {
        this.singleList = new ArrayList();
        this.typeOrder = new ArrayList();
        this.tableColumnCache = new HashMap();
    }

    public void setTable2Column(Map table2Column) {
        this.table2Column = table2Column;
        this.tableColumnList = (List)this.tableColumnCache.get(table2Column.keySet());
        if (this.tableColumnList == null) {
            this.tableColumnList = new ArrayList();
            this.tableColumnList.addAll(table2Column.keySet());
            this.tableColumnCache.put(table2Column.keySet(), this.tableColumnList);
        }
    }

    @Override
    protected void buildSumPart(StringBuffer sql) {
        sql.append(" Select Out_Account.FDc*(sum(A_Record.FOriginalAmount * (voucherEntry.FEntryDC * 2 -1))) OriginalValue ,  \n");
        sql.append(" Out_Account.FDc*(sum(A_Record.FLocalAmount*(voucherEntry.FEntryDC * 2 -1))) LocalValue, \t\n");
        sql.append(" Out_Account.FDc*(sum(A_Record.FReportingAmount * (voucherEntry.FEntryDC * 2 -1))) ReportingValue,  \n");
    }

    @Override
    public void buildSelectPart(Set nullSet, StringBuffer sql) {
        super.buildSelectPart(nullSet, sql);
        if (!this.isSingle) {
            int i = 0;
            for (String tableName : this.tableColumnList) {
                sql.append(" ,").append(tableName).append(".FNumber  AsstActNumber").append(i++).append(" \n");
            }
        }
    }

    @Override
    public void buildGroupByPart(Set nullSet, StringBuffer sql) {
        super.buildGroupByPart(nullSet, sql);
        if (!this.isSingle) {
            for (String tableName : this.tableColumnList) {
                sql.append(" ,").append(tableName).append(".FNumber  \n");
            }
        }
    }

    @Override
    public void buildFromPart(Set nullSet, StringBuffer sql) {
        super.buildFromPart(nullSet, sql);
        sql.append(" inner join T_GL_VoucherAssistRecord A_Record on voucherEntry.fid = A_Record.FEntryID  \n");
        sql.append(" inner join T_BD_AssistantHG A_Hg on A_Record.FAssGrpID = A_Hg.fid   \n");
        for (String tableName : this.tableColumnList) {
            sql.append(" inner join ").append(tableName).append(" on A_Hg.").append(this.table2Column.get(tableName)).append("=").append(tableName).append(".FID   \n");
        }
    }

    @Override
    protected void buildRealVariableWherePart(StringBuffer sql, List params, Acctext acctext) {
        super.buildRealVariableWherePart(sql, params, acctext);
        for (String typeNumber : this.typeOrder) {
            AssistantItem item = acctext.accountItem.getItem(typeNumber);
            if (acctext.isAsstActNeedLongNumber) {
                if (!StringUtils.isEmpty((String)item.getStartItem().getLongNumber())) {
                    sql.append(" and ").append(item.itemType.realtionDataObject).append(".FLongNumber >= ?");
                    params.add(item.getStartItem().getLongNumber());
                }
                if (!StringUtils.isEmpty((String)item.getEndItem().getLongNumber())) {
                    sql.append(" and ").append(item.itemType.realtionDataObject).append(".FLongNumber <= ?");
                    params.add(item.getEndItem().getLongNumber());
                }
            } else {
                if (!StringUtils.isEmpty((String)item.getStartItem().getNumber())) {
                    sql.append(" and ").append(item.itemType.realtionDataObject).append(".FNumber >= ?");
                    params.add(item.getStartItem().getNumber());
                }
                if (!StringUtils.isEmpty((String)item.getEndItem().getNumber())) {
                    sql.append(" and ").append(item.itemType.realtionDataObject).append(".FNumber <= ?");
                    params.add(item.getEndItem().getNumber());
                }
            }
            if (!"T_BD_GeneralAsstActType".equalsIgnoreCase(item.itemType.realtionDataObject)) continue;
            sql.append(" and ").append(item.itemType.realtionDataObject).append(".FGroupID = ?");
            params.add(item.itemType.glAsstActTypeGrpID);
        }
    }

    @Override
    public void prepareStateForCombine(IRowSet rs, IFormulaCombinationPreparedState combineState) throws SQLException {
        super.prepareStateForCombine(rs, combineState);
        AcctextCombinestate state = (AcctextCombinestate)combineState;
        state.getItemTypeNumberMap().clear();
        int i = 0;
        for (String tableName : this.tableColumnList) {
            String number = rs.getString("AsstActNumber" + i++);
            state.getItemTypeNumberMap().put(tableName, number);
        }
    }

    @Override
    public void calculate(BatchHelper batchHelper) throws BOSException {
        this.calculateBatch(batchHelper);
        this.calculateSingle(batchHelper);
    }

    private void calculateSingle(BatchHelper batchHelper) throws BOSException {
        this.setFormulaList(this.singleList);
        batchHelper.singleCalculateBigDecimal(this);
    }

    private void calculateBatch(BatchHelper batchHelper) throws BOSException {
        for (Map.Entry entry : this.asstActWithDetailMap.entrySet()) {
            List formulaList = (List)entry.getValue();
            if (formulaList == null || formulaList.size() <= 0) continue;
            HashMap<String, String> map = new HashMap<String, String>();
            Acctext acctext = (Acctext)formulaList.get(0);
            this.typeOrder.clear();
            this.typeOrder.addAll(acctext.accountItem.getItemTypes().keySet());
            for (AssistantItem item : acctext.accountItem.getItemTypes().values()) {
                map.put(item.itemType.realtionDataObject.toLowerCase(), item.itemType.mappingFieldName);
            }
            this.setTable2Column(map);
            this.setFormulaList(formulaList);
            batchHelper.batchCalculateBigDecimal(this);
        }
    }

    @Override
    public boolean submitFormula(Acctext acctext) {
        if (acctext.isAsstActNeedLongNumber) {
            this.singleList.add(acctext);
        } else {
            boolean isSingle = false;
            for (AssistantItem item : acctext.accountItem.getItemTypes().values()) {
                if (!StringUtils.isEmpty((String)item.startItem.number) && !StringUtils.isEmpty((String)item.endItem.number)) continue;
                isSingle = true;
                break;
            }
            if (isSingle) {
                this.singleList.add(acctext);
            } else {
                this.asstActWithDetailMap.put(acctext.accountItem.getItemTypes().keySet(), acctext);
            }
        }
        return true;
    }

    @Override
    public void preparedBuildSQL(IFormulaCalculator formula) {
        HashMap<String, String> map = new HashMap<String, String>();
        Acctext acctext = (Acctext)formula;
        for (AssistantItem item : acctext.accountItem.getItemTypes().values()) {
            map.put(item.itemType.realtionDataObject.toLowerCase(), item.itemType.mappingFieldName);
        }
        this.isSingle = true;
        this.setTable2Column(map);
        this.typeOrder.clear();
        this.typeOrder.addAll(acctext.accountItem.getItemTypes().keySet());
        for (AssistantItem item : acctext.accountItem.getItemTypes().values()) {
            map.put(item.itemType.realtionDataObject.toLowerCase(), item.itemType.mappingFieldName);
        }
    }

    @Override
    public String[] getIndexResultSetFields() {
        return super.getIndexResultSetFields();
    }
}

