/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.batch.acctext;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.fi.rpt.app.AssistantItem;
import com.kingdee.eas.fi.rpt.batch.BatchHelper;
import com.kingdee.eas.fi.rpt.batch.OneToManyMap;
import com.kingdee.eas.fi.rpt.batch.acctext.Acctext;
import com.kingdee.eas.fi.rpt.batch.acctext.BalanceNullAsstBatchProcessor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BalanceWithlAsstTypeBatchProcessor
extends BalanceNullAsstBatchProcessor {
    private Map table2Column;
    private Map asstActTypeMap = new OneToManyMap();
    private List singleList = new ArrayList();
    private Map tableCache = new HashMap();

    @Override
    protected void buildSumPart(StringBuffer sql) {
        sql.append(" Select Out_Account.FDc*(sum(A_Record.FOriginalAmount * (voucherEntry.FEntryDC * 2 -1))) OriginalValue ,  \n");
        sql.append(" Out_Account.FDc*(sum(A_Record.FLocalAmount*(voucherEntry.FEntryDC * 2 -1))) LocalValue, \t\n");
        sql.append(" Out_Account.FDc*(sum(A_Record.FReportingAmount * (voucherEntry.FEntryDC * 2 -1))) ReportingValue,  \n");
    }

    @Override
    public void buildFromPart(Set nullSet, StringBuffer sql) {
        super.buildFromPart(nullSet, sql);
        sql.append(" inner join T_GL_VoucherAssistRecord A_Record on voucherEntry.fid = A_Record.FEntryID  \n");
        sql.append(" inner join T_BD_AssistantHG A_Hg on A_Record.FAssGrpID = A_Hg.fid   \n");
    }

    @Override
    protected void buildRealConstantPart(Set nullSet, StringBuffer sql, List params) {
        boolean isFirst = true;
        ArrayList tableList = (ArrayList)this.tableCache.get(this.table2Column.keySet());
        if (tableList == null) {
            tableList = new ArrayList();
            this.tableCache.put(this.table2Column.keySet(), tableList);
            tableList.addAll(this.table2Column.keySet());
        }
        for (String tableName : tableList) {
            if (!isFirst) {
                sql.append(" and ");
            } else {
                isFirst = false;
            }
            sql.append(" exists (select * from ").append(tableName).append("  where ").append(tableName).append(".Fid = A_Hg.").append(this.table2Column.get(tableName));
            if ("T_BD_GeneralAsstActType".equalsIgnoreCase(tableName)) {
                sql.append(" and ").append(tableName).append(".FGroupID = ? ");
            }
            sql.append(")  \n");
        }
        sql.append(" and ");
        super.buildRealConstantPart(nullSet, sql, params);
    }

    @Override
    protected void buildRealVariableWherePart(StringBuffer sql, List params, Acctext acctext) {
        if (acctext.isAsstActNeedLongNumber) {
            for (Map.Entry entry : acctext.accountItem.getItemTypes().entrySet()) {
                AssistantItem item = (AssistantItem)entry.getValue();
                if (!"T_BD_GeneralAsstActType".equalsIgnoreCase(item.itemType.realtionDataObject)) continue;
                params.add(item.itemType.glAsstActTypeGrpID);
            }
        }
        super.buildRealVariableWherePart(sql, params, acctext);
    }

    public void setTable2Column(Map table2Column) {
        this.table2Column = table2Column;
    }

    @Override
    public void calculate(BatchHelper batchHelper) throws BOSException {
        this.calculateBatch(batchHelper);
        this.calculateSingle(batchHelper);
    }

    private void calculateSingle(BatchHelper batchHelper) throws BOSException {
        this.setFormulaList(this.singleList);
        batchHelper.singleCalculateBigDecimal(this);
    }

    private void calculateBatch(BatchHelper batchHelper) throws BOSException {
        for (Map.Entry entry : this.asstActTypeMap.entrySet()) {
            List formulaList = (List)entry.getValue();
            if (formulaList == null || formulaList.size() <= 0) continue;
            HashMap<String, String> map = new HashMap<String, String>();
            Acctext acctext = (Acctext)formulaList.get(0);
            for (AssistantItem item : acctext.accountItem.getItemTypes().values()) {
                map.put(item.itemType.realtionDataObject.toLowerCase(), item.itemType.mappingFieldName);
            }
            this.setTable2Column(map);
            this.setFormulaList(formulaList);
            batchHelper.batchCalculateBigDecimal(this);
        }
    }

    @Override
    public boolean submitFormula(Acctext acctext) {
        if (acctext.hasGeneralAsstActType) {
            this.singleList.add(acctext);
        } else {
            this.asstActTypeMap.put(acctext.accountItem.getItemTypes().keySet(), acctext);
        }
        return true;
    }
}

