/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.batch.acctitem;

import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.rpt.batch.BatchHelper;
import com.kingdee.eas.fi.rpt.batch.IBatchSQLSortState;
import com.kingdee.eas.fi.rpt.batch.IFormulaCalculator;
import com.kingdee.eas.fi.rpt.batch.IFormulaCombinationPreparedState;
import com.kingdee.eas.fi.rpt.batch.IMutiReturnValueSQLProcessor;
import com.kingdee.eas.fi.rpt.batch.acctitem.AcctItem;
import com.kingdee.eas.fi.rpt.batch.acctitem.AcctItemCombinestate;
import com.kingdee.eas.fi.rpt.batch.acctitem.AcctItemSortState;
import com.kingdee.eas.fi.rpt.batch.esp.EspBatchSQLProcessor;
import com.kingdee.eas.fi.rpt.batch.temptablescheme.DefaultTempTableValueInsertProcessor;
import com.kingdee.eas.fi.rpt.batch.temptablescheme.ITempTableField;
import com.kingdee.eas.fi.rpt.batch.temptablescheme.ITempTableSQLProcessor;
import com.kingdee.eas.fi.rpt.batch.temptablescheme.ITempTableValue;
import com.kingdee.eas.fi.rpt.batch.temptablescheme.ITempTableValueInsertProcessor;
import com.kingdee.eas.fi.rpt.batch.temptablescheme.TempTableField;
import com.kingdee.eas.fi.rpt.batch.temptablescheme.TempTableFieldItem;
import com.kingdee.eas.fi.rpt.batch.temptablescheme.TempTableValue;
import com.kingdee.eas.fi.rpt.batch.temptablescheme.TempTableValueItem;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class AcctItemBatchProcessor
implements ITempTableSQLProcessor,
IMutiReturnValueSQLProcessor {
    public static final Logger logger = Logger.getLogger(EspBatchSQLProcessor.class);
    private int maxsqlvar = 100;
    protected Set nullFields = new HashSet();
    protected AcctItemCombinestate combinestate;
    private AcctItemSortState sortState;
    private List selectItemList;
    private Map tableAliasMap;
    protected String[] IndexResultSetFields;
    private ITempTableValueInsertProcessor tempTableValueInsertProcessor;
    private boolean isUseTempTableScheme;
    private TempTableField tempTableField;

    public AcctItemBatchProcessor(boolean isUseTempTableScheme) {
        this.nullFields.add("sourceCurrencyNumber");
        this.combinestate = new AcctItemCombinestate();
        this.tableAliasMap = new HashMap();
        this.selectItemList = new ArrayList();
        this.isUseTempTableScheme = isUseTempTableScheme;
    }

    private void addToSelectItemList(AcctItem acctItem) {
        for (Object itemData : acctItem.itemFromToList) {
            if (this.selectItemList.contains(itemData)) continue;
            this.selectItemList.add(itemData);
        }
    }

    @Override
    public void builderConstantWherePart(Set nullSet, StringBuffer sql, List params) {
        sql.append(" WHERE ((entry.FDataSource = 100 and received.FOrgTreeID is null)").append("  or (entry.FDataSource <> 100 and received.FOrgTreeID IN  \n").append(this.createInSql(this.sortState.getOrgBoundIDSet().iterator()));
        sql.append(")");
        if (this.sortState.getBaseOrgTreeIdSet() != null && this.sortState.getBaseOrgTreeIdSet().size() > 0) {
            sql.append(" OR received.FOrgTreeID IN \n").append(this.createInSql(this.sortState.getBaseOrgTreeIdSet().iterator())).append(" OR entry.FIsAdjusted = 2 ");
        }
        sql.append(")");
        sql.append(CslRptUtil.getRptAddPerportySql((int)0, (String)"entry", (boolean)false));
        sql.append(" AND entry.FPeriodType = ?          \n");
        params.add(new Integer(this.sortState.getPeriodType()));
        this.innerBuildPeriodCondition(sql, params);
        if (!StringUtils.isEmpty((String)this.sortState.getMergeSchmNum())) {
            sql.append(" AND mergeSchm.FNumber = ?          \n");
            params.add(this.sortState.getMergeSchmNum());
        }
        if (this.sortState.getDataSourceArray().length > 1) {
            sql.append(" AND (");
            for (int i = 0; i < this.sortState.getDataSourceArray().length; ++i) {
                if (i > 0) {
                    sql.append(" OR ");
                }
                sql.append(" entry.FDataSource = ?");
                params.add(new Integer(this.sortState.getDataSourceArray()[i]));
            }
            sql.append(" OR entry.FDataSource = ?");
            params.add(new Integer(100));
            sql.append(")\n");
        } else if (this.sortState.getDataSourceArray()[0] == 1 || this.sortState.getDataSourceArray()[0] == 7) {
            sql.append(" AND (entry.FDataSource = ?  OR entry.FDataSource = ? OR entry.FDataSource = ? )");
            params.add(new Integer(1));
            params.add(new Integer(7));
            params.add(new Integer(100));
        }
        if (!this.sortState.isAdjusted() && !this.sortState.isCaliber()) {
            sql.append(" AND entry.FIsAdjusted = ?      \n");
            params.add(new Integer(0));
        }
        if (this.sortState.getDataSourceArray()[0] != 4) {
            if (this.sortState.isGroupUnCommited()) {
                if (this.sortState.isCaliber() || this.sortState.isAdjusted()) {
                    if (this.sortState.isParamadjustSeparate()) {
                        sql.append(" AND (entry.FIsAdjusted = ? OR (entry.FIsAdjusted = ? AND received.FORGTREEID = report.FORGTREEID) ");
                    } else {
                        sql.append(" AND (entry.FIsAdjusted = ? OR entry.FIsAdjusted = ? ");
                    }
                    sql.append(" OR (entry.FIsAdjusted IN (?, ?, ?) AND entry.FCommitStatus IN (?, ?, ?)))  \n");
                    params.add(new Integer(12));
                    params.add(new Integer(2));
                    params.add(new Integer(0));
                    params.add(new Integer(1));
                    params.add(new Integer(11));
                    params.add(new Integer(1));
                    params.add(new Integer(2));
                    params.add(new Integer(3));
                } else {
                    sql.append(" AND entry.FCommitStatus IN (?, ?, ?)   \n");
                    params.add(new Integer(1));
                    params.add(new Integer(2));
                    params.add(new Integer(3));
                }
            } else if (this.sortState.isCaliber() || this.sortState.isAdjusted()) {
                if (this.sortState.isParamadjustSeparate()) {
                    sql.append(" AND (entry.FIsAdjusted = ? OR (entry.FIsAdjusted = ? AND received.FORGTREEID = report.FORGTREEID) ");
                } else {
                    sql.append(" AND (entry.FIsAdjusted = ? OR entry.FIsAdjusted = ? ");
                }
                sql.append(" OR (entry.FIsAdjusted IN (?, ?, ?) AND entry.FCommitStatus = ?))  \n");
                params.add(new Integer(12));
                params.add(new Integer(2));
                params.add(new Integer(0));
                params.add(new Integer(1));
                params.add(new Integer(11));
                params.add(new Integer(3));
            } else {
                sql.append(" AND entry.FCommitStatus = ?        \n");
                params.add(new Integer(3));
            }
        }
        sql.append(" AND entry.FDataCollectNumber = ?  \n");
        params.add(this.sortState.getDataCollectNumber());
        if (!this.isUseTempTableScheme()) {
            sql.append(" AND (");
        }
    }

    private void innerBuildPeriodCondition(StringBuffer sql, List params) {
        if (this.sortState.isSamePeriod()) {
            sql.append(" AND entry.FYear = ? AND entry.FPeriod = ?                          \n");
            params.add(new Integer(this.sortState.getStartYear()));
            params.add(new Integer(this.sortState.getStartPeriod()));
        } else if (this.sortState.isSameYear()) {
            sql.append(" AND entry.FYear = ? AND entry.FPeriod >= ? AND entry.FPeriod <= ?  \n");
            params.add(new Integer(this.sortState.getStartYear()));
            params.add(new Integer(this.sortState.getStartPeriod()));
            params.add(new Integer(this.sortState.getEndPeriod()));
        } else {
            sql.append(" AND ((entry.FYear = ? AND entry.FPeriod >= ?)                      \n");
            params.add(new Integer(this.sortState.getStartYear()));
            params.add(new Integer(this.sortState.getStartPeriod()));
            sql.append(" OR (entry.FYear > ? AND entry.FYear < ?)                           \n");
            params.add(new Integer(this.sortState.getStartYear()));
            params.add(new Integer(this.sortState.getEndYear()));
            sql.append(" OR (entry.FYear = ? AND entry.FPeriod <= ?))                       \n");
            params.add(new Integer(this.sortState.getEndYear()));
            params.add(new Integer(this.sortState.getEndPeriod()));
        }
    }

    @Override
    public void buildFromPart(Set nullSet, StringBuffer sql) {
        sql.append(" FROM T_CSL_ItemDataEntry entry                                                    \n").append(" LEFT OUTER JOIN T_CSL_RptReceived received ON received.FReportID = entry.FReportID     \n");
        if ((this.sortState.isCaliber() || this.sortState.isAdjusted()) && this.sortState.isParamadjustSeparate()) {
            sql.append("  left join T_Csl_CSLREPORT report on received.FReportID = report.FID \n");
        }
        sql.append(" LEFT OUTER JOIN T_ORG_BaseUnit company ON entry.FCompanyID = company.FID          \n").append(" LEFT OUTER JOIN T_BD_Currency srcCurrency ON entry.FCurrencyID = srcCurrency.FID  \n").append(" LEFT OUTER JOIN T_BD_Currency currency ON entry.FTargetCurrencyID = currency.FID  \n").append(" LEFT OUTER JOIN T_CSL_FastMergeSolu mergeSchm ON entry.FFastMergeSoluID = mergeSchm.FID \n").append(this.buildItemDataEntryTable());
    }

    @Override
    public void buildGroupByPart(Set nullSet, StringBuffer sql) {
        String selectItemField;
        if (!this.isUseTempTableScheme()) {
            sql.append(")");
        }
        if ((selectItemField = this.buildSelectField()).indexOf("FROM") != -1) {
            String kql = sql.toString().replaceAll("\\sFROM\\s", this.buildSelectField());
            sql.delete(0, sql.length());
            sql.append(kql);
        }
    }

    private String buildItemDataEntryTable() {
        List tableList = this.sortState.getTableList();
        StringBuffer entryTableBuffer = new StringBuffer();
        int index = 0;
        for (String tableName : tableList) {
            String tableAlias = "entry" + index++;
            this.tableAliasMap.put(tableName, tableAlias);
            entryTableBuffer.append(" left JOIN ").append(tableName).append(" ").append(tableAlias).append(" ON entry.FID = ").append(tableAlias).append(".FID \n");
        }
        return entryTableBuffer.toString();
    }

    private String buildSelectField() {
        StringBuffer selectField = new StringBuffer();
        selectField.append(",");
        Iterator it = this.selectItemList.iterator();
        while (it.hasNext()) {
            AcctItem.ItemFieldMapped itemFieldMapped = (AcctItem.ItemFieldMapped)it.next();
            String tableAlias = (String)this.tableAliasMap.get(itemFieldMapped.tableName);
            selectField.append(tableAlias).append(".").append(itemFieldMapped.fieldName);
            if (it.hasNext()) {
                selectField.append(",");
                continue;
            }
            selectField.append(" FROM ");
        }
        return selectField.toString();
    }

    @Override
    public void buildSelectPart(Set nullSet, StringBuffer sql) {
        this.selectItemList.clear();
        sql.append("SELECT received.FOrgTreeID orgTreeId,           \n").append("company.FNumber companyNumber,                     \n");
        if (!nullSet.contains("sourceCurrencyNumber")) {
            sql.append("srcCurrency.FNumber sourceCurrencyNumber,   \n");
        }
        sql.append("currency.FNumber convertCurrencyNumber,         \n").append("entry.FDataElement dataElement,                    \n").append("entry.FDataSource dataSource,                   \n").append("entry.FValueType valueType,                        \n").append("entry.FIsAdjusted isAdjusted,                   \n").append("entry.FDataCollectNumber dataCollectNumber,     \n").append("entry.FCommitStatus commitStatus                \n");
    }

    @Override
    public void buildVariableWherePart(StringBuffer sql, List params, IFormulaCalculator formula) {
        AcctItem acctItem = (AcctItem)formula;
        this.addToSelectItemList(acctItem);
        sql.append("(currency.FNumber = ?                 \n");
        params.add(acctItem.convertCurrencyNumber);
        if (!acctItem.getNullFields().contains("sourceCurrencyNumber")) {
            sql.append(" AND srcCurrency.FNumber = ?      \n");
            params.add(acctItem.sourceCurrencyNumber);
        }
        sql.append(" AND company.FNumber IN ").append(BatchHelper.buildInSql(acctItem.orgUnitNumbers.split("\\||\\,|\\;"))).append(" \n");
        if (this.sortState.getDataSourceArray().length == 1 && this.sortState.getDataSourceArray()[0] != 1 && this.sortState.getDataSourceArray()[0] != 7) {
            sql.append(" AND entry.FDataSource = ?         \n");
            params.add(new Integer(this.sortState.getDataSourceArray()[0]));
        }
        sql.append(" AND entry.FDataElement = ?           \n");
        params.add(new Integer(acctItem.int_dataElement));
        sql.append(" AND entry.FValueType = ?             \n");
        params.add(new Integer(acctItem.int_valueType));
        sql.append(")");
    }

    public String createInSql(Iterator iterator) {
        boolean first = true;
        StringBuffer sql = new StringBuffer("(");
        while (iterator.hasNext()) {
            if (first) {
                sql.append(" '").append(iterator.next()).append("' ");
                first = false;
                continue;
            }
            sql.append(" ,'").append(iterator.next()).append("' ");
        }
        sql.append(")\n");
        return sql.toString();
    }

    @Override
    public Set getAllowedNullFields() {
        return this.nullFields;
    }

    @Override
    public IFormulaCombinationPreparedState getCombineState() {
        return this.combinestate;
    }

    @Override
    public List getFormulaCalculators() {
        return this.sortState.getFormulaList();
    }

    @Override
    public Object[][] getIndexFormulaFields(IFormulaCalculator formula) {
        AcctItem acctItem = (AcctItem)formula;
        ArrayList<Object> fileds = new ArrayList<Object>();
        if (!acctItem.getNullFields().contains("sourceCurrencyNumber")) {
            fileds.add(acctItem.sourceCurrencyNumber);
        }
        fileds.add(acctItem.convertCurrencyNumber);
        if (this.sortState.getDataSourceArray().length == 1 && this.sortState.getDataSourceArray()[0] != 1 && this.sortState.getDataSourceArray()[0] != 7) {
            fileds.add(new Integer(acctItem.dataSourceArray[0]));
        }
        fileds.add(new Integer(acctItem.int_dataElement));
        fileds.add(new Integer(acctItem.int_valueType));
        fileds.add(acctItem.dataCollectNumber);
        String[] multiCompanyNum = acctItem.orgUnitNumbers.split("\\||\\,|\\;");
        fileds.add(multiCompanyNum[0]);
        int fieldLen = fileds.size();
        Object[][] result = new Object[multiCompanyNum.length][fieldLen];
        result[0] = fileds.toArray();
        for (int i = 1; i < multiCompanyNum.length; ++i) {
            fileds.set(fieldLen - 1, multiCompanyNum[i]);
            result[i] = fileds.toArray();
        }
        return result;
    }

    @Override
    public String[] getIndexResultSetFields() {
        this.initIndexResultSetFields();
        return this.IndexResultSetFields;
    }

    @Override
    public int getMaxSQLVaribleSize() {
        return this.maxsqlvar;
    }

    public void setMaxSQLVaribleSize(int size) {
        this.maxsqlvar = size;
    }

    public IBatchSQLSortState getSortState() {
        return this.sortState;
    }

    private void initIndexResultSetFields() {
        ArrayList<String> FieldIndexList = new ArrayList<String>();
        FieldIndexList.add("sourceCurrencyNumber");
        FieldIndexList.add("convertCurrencyNumber");
        if (this.sortState.getDataSourceArray().length == 1 && this.sortState.getDataSourceArray()[0] != 1 && this.sortState.getDataSourceArray()[0] != 7) {
            FieldIndexList.add("dataSource");
        }
        FieldIndexList.add("dataElement");
        FieldIndexList.add("valueType");
        FieldIndexList.add("dataCollectNumber");
        FieldIndexList.add("companyNumber");
        this.IndexResultSetFields = new String[FieldIndexList.size()];
        FieldIndexList.toArray(this.IndexResultSetFields);
    }

    @Override
    public void prepareStateForCombine(IRowSet rs, IFormulaCombinationPreparedState combineState) throws SQLException {
        HashMap<String, BigDecimal> result = new HashMap<String, BigDecimal>();
        for (AcctItem.ItemFieldMapped itemFieldMapped : this.selectItemList) {
            result.put(itemFieldMapped.number, rs.getBigDecimal(itemFieldMapped.fieldName));
        }
        AcctItemCombinestate acctItemCombinestate = (AcctItemCombinestate)combineState;
        acctItemCombinestate.setValueResult(result);
        acctItemCombinestate.setOrgBoundId(rs.getString("orgTreeId"));
        acctItemCombinestate.setDataSource(rs.getInt("dataSource"));
        acctItemCombinestate.setAdjustStatus(rs.getInt("isAdjusted"));
        acctItemCombinestate.setCommitedStatus(rs.getInt("commitStatus"));
    }

    @Override
    public void setSortState(IBatchSQLSortState sortState) {
        this.sortState = (AcctItemSortState)sortState;
        this.sortState.setUseTempTableScheme(this.isUseTempTableScheme);
        if (this.isUseTempTableScheme()) {
            this.tempTableField = this.innerGetTempTableField();
            this.tempTableValueInsertProcessor = new DefaultTempTableValueInsertProcessor();
        }
    }

    @Override
    public boolean isMutiReturnValue() {
        return this.sortState.isAdjusted() || this.sortState.isCaliber();
    }

    private TempTableField innerGetTempTableField() {
        TempTableField tempTableField = new TempTableField();
        tempTableField.addTempTableItem(new TempTableFieldItem("company.FNumber"));
        tempTableField.addTempTableItem(new TempTableFieldItem("currency.FNumber"));
        if (!StringUtils.isEmpty((String)this.sortState.getSourceCurrencyNumber())) {
            tempTableField.addTempTableItem(new TempTableFieldItem("srcCurrency.FNumber"));
        }
        if (this.sortState.getDataSourceArray().length == 1 && this.sortState.getDataSourceArray()[0] != 1 && this.sortState.getDataSourceArray()[0] != 7) {
            tempTableField.addTempTableItem(new TempTableFieldItem("entry.FDataSource"));
        }
        tempTableField.addTempTableItem(new TempTableFieldItem("entry.FDataElement"));
        tempTableField.addTempTableItem(new TempTableFieldItem("entry.FValueType"));
        return tempTableField;
    }

    @Override
    public boolean isUseTempTableScheme() {
        return this.isUseTempTableScheme;
    }

    @Override
    public ITempTableValue insertTempTableValues(IFormulaCalculator formula) {
        AcctItem acctItem = (AcctItem)formula;
        this.addToSelectItemList(acctItem);
        TempTableValue tempTableValue = new TempTableValue();
        tempTableValue.addTempTableItem(new TempTableValueItem("company.FNumber", acctItem.orgUnitNumbers));
        tempTableValue.addTempTableItem(new TempTableValueItem("currency.FNumber", acctItem.convertCurrencyNumber));
        if (!StringUtils.isEmpty((String)this.sortState.getSourceCurrencyNumber())) {
            tempTableValue.addTempTableItem(new TempTableValueItem("srcCurrency.FNumber", acctItem.sourceCurrencyNumber));
        }
        if (this.sortState.getDataSourceArray().length == 1 && this.sortState.getDataSourceArray()[0] != 1 && this.sortState.getDataSourceArray()[0] != 7) {
            tempTableValue.addTempTableItem(new TempTableValueItem("entry.FDataSource", new Integer(this.sortState.getDataSourceArray()[0])));
        }
        tempTableValue.addTempTableItem(new TempTableValueItem("entry.FDataElement", new Integer(acctItem.int_dataElement)));
        tempTableValue.addTempTableItem(new TempTableValueItem("entry.FValueType", new Integer(acctItem.int_valueType)));
        return tempTableValue;
    }

    @Override
    public void buildInnerJoinTempTable(StringBuffer sql, String tempTableName, ITempTableField tempTableField) {
        sql.append("\n inner join ");
        sql.append(tempTableName).append(" tempTable");
        sql.append(" on ");
        Iterator it = tempTableField.getTempTableFieldItems().iterator();
        while (it.hasNext()) {
            TempTableFieldItem tempTableFieldItem = (TempTableFieldItem)it.next();
            Boolean join = (Boolean)tempTableFieldItem.getProperty("join");
            if (join != null && !join.booleanValue()) continue;
            String fieldName = tempTableFieldItem.getField();
            String tempTableFieldName = tempTableFieldItem.getTempTableField();
            tempTableFieldName = "tempTable." + tempTableFieldName;
            sql.append("(");
            sql.append(fieldName).append(" = ").append(tempTableFieldName);
            sql.append(")");
            if (!it.hasNext()) continue;
            sql.append(" and ");
        }
    }

    @Override
    public ITempTableField getTempTableField() {
        return this.innerGetTempTableField();
    }

    @Override
    public void buildDivisionalVariableWherePart(Set nullSet, StringBuffer sql, List params) {
    }

    @Override
    public ITempTableValueInsertProcessor getTempTableValueInsertProcessor() {
        return this.tempTableValueInsertProcessor;
    }
}

