/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.batch.acctitem;

import com.kingdee.eas.fi.rpt.batch.IFormulaCalculator;
import com.kingdee.eas.fi.rpt.batch.IFormulaCombinationPreparedState;
import com.kingdee.eas.fi.rpt.batch.acctitem.AcctItem;
import java.math.BigDecimal;
import java.util.Map;

public class AcctItemCombinestate
implements IFormulaCombinationPreparedState {
    private Map valueMap;
    private String orgBoundId;
    private int dataSource;
    private int adjustStatus;
    private int commitedStatus;

    @Override
    public Object getFormulaResultValue(IFormulaCalculator formula) {
        BigDecimal returnValue = null;
        AcctItem acctItem = (AcctItem)formula;
        for (String itemNumber : this.valueMap.keySet()) {
            if (acctItem.startItemNumber.compareTo(itemNumber) > 0 || acctItem.endItemNumber.compareTo(itemNumber) < 0 || this.valueMap.get(itemNumber) == null) continue;
            if (returnValue == null) {
                returnValue = new BigDecimal("0");
            }
            returnValue = returnValue.add((BigDecimal)this.valueMap.get(itemNumber));
        }
        return returnValue;
    }

    @Override
    public boolean isFormulaResultNumberValue(IFormulaCalculator formula) {
        return true;
    }

    @Override
    public boolean isPrepared(IFormulaCalculator formula) {
        AcctItem acctItem = (AcctItem)formula;
        if (this.orgBoundId != null && !acctItem.orgBoundIDSet.contains(this.orgBoundId)) {
            return false;
        }
        boolean isItemNumberPrepared = true;
        for (String itemNumber : this.valueMap.keySet()) {
            if (acctItem.startItemNumber.compareTo(itemNumber) > 0) {
                isItemNumberPrepared = false;
                continue;
            }
            if (acctItem.endItemNumber.compareTo(itemNumber) < 0) {
                isItemNumberPrepared = false;
                continue;
            }
            isItemNumberPrepared = true;
            break;
        }
        return isItemNumberPrepared;
    }

    public void refresh() {
        this.valueMap.clear();
    }

    public Map getValueResult() {
        return this.valueMap;
    }

    public void setValueResult(Map valueMap) {
        this.valueMap = valueMap;
    }

    public int getAdjustStatus() {
        return this.adjustStatus;
    }

    public void setAdjustStatus(int adjustStatus) {
        this.adjustStatus = adjustStatus;
    }

    public String getOrgBoundId() {
        return this.orgBoundId;
    }

    public void setOrgBoundId(String orgBoundId) {
        this.orgBoundId = orgBoundId;
    }

    public int getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(int dataSource) {
        this.dataSource = dataSource;
    }

    public int getCommitedStatus() {
        return this.commitedStatus;
    }

    public void setCommitedStatus(int commitedStatus) {
        this.commitedStatus = commitedStatus;
    }
}

