/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.batch.age;

import com.kingdee.eas.fi.rpt.app.AssistantItem;
import com.kingdee.eas.fi.rpt.batch.IFormulaCalculator;
import com.kingdee.eas.fi.rpt.batch.IFormulaCombinationPreparedState;
import com.kingdee.eas.fi.rpt.batch.age.Age;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;

public class AgeComBineState
implements IFormulaCombinationPreparedState {
    private BigDecimal amount;
    private String accountNumber;
    private Map asstItems = new HashMap(0);

    @Override
    public Object getFormulaResultValue(IFormulaCalculator formula) {
        return this.amount;
    }

    @Override
    public boolean isFormulaResultNumberValue(IFormulaCalculator formula) {
        return true;
    }

    @Override
    public boolean isPrepared(IFormulaCalculator formula) {
        Age age = (Age)formula;
        if (age.accountItem.startAccount.getAccountNumber().equals(age.accountItem.endAccount.getAccountNumber()) && (this.accountNumber == null || !this.accountNumber.startsWith(age.accountItem.startAccount.getAccountNumber()))) {
            return false;
        }
        return this.checkAsstItem(age);
    }

    private boolean checkAsstItem(Age age) {
        for (Map.Entry asstItem : this.asstItems.entrySet()) {
            AssistantItem formulaAsstItem = age.accountItem.getItem((String)asstItem.getKey());
            String asstItemVal = (String)asstItem.getValue();
            if (formulaAsstItem.getStartItem() != null && asstItemVal.compareTo(formulaAsstItem.getStartItem().getNumber()) < 0) {
                return false;
            }
            if (formulaAsstItem.getEndItem() == null || asstItemVal.compareTo(formulaAsstItem.getEndItem().getNumber()) <= 0) continue;
            return false;
        }
        return true;
    }

    public void clearValue() {
        this.asstItems.clear();
        this.amount = null;
        this.accountNumber = null;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public String getAccountNumber() {
        return this.accountNumber;
    }

    public void setAccountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
    }

    public void addAsstItem(String asstItemNum, Object asstItemVal) {
        this.asstItems.put(asstItemNum, asstItemVal);
    }
}

