/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.batch.age.balance.facade;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.rpt.batch.age.balance.AgeQueryParam;
import java.util.HashMap;
import java.util.Map;

public class AgeQueryParamConvertor {
    private Context ctx;

    public AgeQueryParamConvertor(Context ctx) {
        this.ctx = ctx;
    }

    public Map exec(AgeQueryParam param) throws EASBizException, BOSException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("days", param.getAgeRange());
        params.put("includeVerifyVch", param.isIncludeVerifyVch());
        params.put("dateType", param.isByBusinessDate() ? new Integer(1) : new Integer(0));
        params.put("ageType", param.isByOverDue());
        String company = param.getCompany();
        params.put("curCompanyid", company);
        params.put("companyid", company);
        params.put("curLevel", new Integer(1));
        params.put("currencyid", param.getCurrency());
        params.put("accountFrom", param.getAccountStartNumber());
        params.put("accountTo", param.getAccountEndNumber());
        CompanyOrgUnitInfo companyInfo = param.getCompanyInfo();
        params.put("companyInfo", companyInfo);
        params.put("accountTable", companyInfo.getAccountTable().getId().toString());
        params.put("includeInit", Boolean.TRUE);
        params.put("queryHistory", Boolean.TRUE);
        params.put("hmItems", new HashMap());
        String[] asstItems = param.getAsstItems();
        if (asstItems.length != 0) {
            params.put("asstTypes", asstItems);
        }
        params.put("endDate", param.getEndDate());
        params.put("historyDate", param.getBusinessDate());
        params.put("indexType", new Integer(1));
        params.put("isBizCode", Boolean.FALSE);
        params.put("includeUnPosted", param.isIncludeUnPosted());
        params.put("firstLoad", Boolean.TRUE);
        params.put("companyIsOnlyUnion", !companyInfo.isIsBizUnit());
        if (!companyInfo.isIsBizUnit()) {
            params.put("companyIdsForOnlyUnion", param.getCompanyIdsForOnlyUnion());
        }
        params.put("OnlyUnitCaseTest", Boolean.TRUE);
        return params;
    }

    private ICompanyOrgUnit getCompanyOrgUnitInstance() throws BOSException {
        if (this.ctx == null || this.ctx.get((Object)"isBVTTestCase") != null) {
            return CompanyOrgUnitFactory.getRemoteInstance();
        }
        return CompanyOrgUnitFactory.getLocalInstance((Context)this.ctx);
    }
}

