/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.batch.age.balance.facade;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.ormapping.SQLAccessException;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeTableInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.master.account.AccountTools;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.cssp.BizAnalysisCodeFactory;
import com.kingdee.eas.basedata.master.cssp.BizAnalysisCodeInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.TableManagerFacadeFactory;
import com.kingdee.eas.fi.gl.AccountAgeFacadeFactory;
import com.kingdee.eas.fi.gl.GLException;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.IAccountAgeFacade;
import com.kingdee.eas.fi.gl.ItemStructureInfo;
import com.kingdee.eas.fi.gl.app.InitHelp;
import com.kingdee.eas.fi.gl.app.PsSql;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.rpt.batch.age.DebugModel;
import com.kingdee.eas.fi.rpt.batch.age.balance.AgeQueryParam;
import com.kingdee.eas.fi.rpt.batch.age.balance.facade.AgeQueryParamConvertor;
import com.kingdee.eas.fi.rpt.batch.age.balance.facade.BalanceInfoByAge;
import com.kingdee.eas.fi.rpt.batch.age.balance.facade.ConvertAssistHGID2Number;
import com.kingdee.eas.fi.rpt.batch.age.balance.facade.SimpleAssistantHG;
import com.kingdee.eas.fi.rpt.batch.age.balance.gl.GetConnection;
import com.kingdee.eas.fi.rpt.batch.age.balance.gl.QueryAsstItems;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.eas.framework.report.util.DBUtil;
import com.kingdee.eas.framework.report.util.SqlParams;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.LowTimer;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public class QueryBalanceByAge {
    private static Logger logger = Logger.getLogger((String)QueryBalanceByAge.class.getClass().getName());
    private String strDateType = "fenddate";
    private String strSeperatorNumName = "@_@";
    private DebugModel debugModel;

    public List exec(Context ctx, AgeQueryParam param) throws BOSException, EASBizException {
        Map params = new AgeQueryParamConvertor(ctx).exec(param);
        List balances = this.exec(ctx, params);
        Set hgs = this.togetherAssistantHG(balances);
        ConvertAssistHGID2Number convertHg = new ConvertAssistHGID2Number(ctx);
        convertHg.exec(hgs);
        return balances;
    }

    private Set togetherAssistantHG(List balances) {
        BalanceInfoByAge balance = null;
        HashSet<SimpleAssistantHG> hgs = new HashSet<SimpleAssistantHG>(balances.size());
        HashMap<String, SimpleAssistantHG> noDuplicatHG = new HashMap<String, SimpleAssistantHG>();
        int size = balances.size();
        for (int i = 0; i < size; ++i) {
            balance = (BalanceInfoByAge)balances.get(i);
            if (balance.getCurrentHG() == null || balance.getCurrentHG().getHgId() == null) continue;
            if (!noDuplicatHG.containsKey(balance.getCurrentHG().getHgId())) {
                hgs.add(balance.getCurrentHG());
                noDuplicatHG.put(balance.getCurrentHG().getHgId(), balance.getCurrentHG());
                continue;
            }
            balance.setCurrentHG((SimpleAssistantHG)noDuplicatHG.get(balance.getCurrentHG().getHgId()));
        }
        return hgs;
    }

    private void enterDateType(int type) {
        if (type == 1) {
            this.strDateType = "fbizdate";
        }
    }

    protected HashMap _getAsstItems(Context ctx, String accountFrom, String accountTo, String companyId, int indexType, java.util.Date bizDate, HashMap othersParam) throws BOSException, EASBizException {
        CompanyOrgUnitInfo _company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId));
        boolean isIsOnlyUnion = GlUtils.isCompanyUnion((CompanyOrgUnitInfo)_company);
        String acctTableId = null;
        if (bizDate == null) {
            acctTableId = _company.getAccountTable().getId().toString();
        } else {
            PeriodInfo _period = PeriodUtils.getPeriodInfo((Context)ctx, (java.util.Date)bizDate, (CompanyOrgUnitInfo)_company);
            int _periodYear = _period == null ? bizDate.getYear() + 1900 : _period.getPeriodYear();
            int _periodNumber = _period == null ? (bizDate.getMonth() + 3) / 3 : _period.getPeriodNumber();
            acctTableId = AccountTools.getCurrentAcctTable((Context)ctx, (String)_company.getCU().getId().toString(), (String)_company.getAccountTable().getId().toString(), (int)_periodYear, (int)_periodNumber);
        }
        Map accountParams = this.getAccountParam(accountFrom, accountTo);
        accountFrom = (String)accountParams.get("accountFrom");
        accountTo = (String)accountParams.get("accountTo");
        HashMap allItems = new HashMap();
        String loc = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        StringBuffer sql = new StringBuffer("select fid id,fnumber fnumber,fname_").append(loc).append(" fname from T_BD_AccountView---\r\n account where fisleaf=1 and fac=1 and fcaa is not null");
        if (isIsOnlyUnion) {
            acctTableId = othersParam.get("accountTableid").toString();
            String companyIds = othersParam.get("companyIds").toString();
            sql.append(" and fcompanyid is not null and  fcompanyid in (").append(companyIds).append(") ");
        } else {
            sql.append(" and fcompanyid=? ");
        }
        this.buildAccountSql(sql, accountParams, "fnumber");
        sql.append(" and faccounttableid='" + acctTableId + "'");
        AccountViewCollection accounts = new AccountViewCollection();
        ArrayList crossItems = new ArrayList();
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            String key;
            con = GetConnection.exec(ctx);
            int index = 1;
            ps = con.prepareStatement(sql.toString());
            if (!isIsOnlyUnion) {
                ps.setString(index++, companyId);
            }
            if (accountFrom != null && !accountFrom.equals("")) {
                ps.setString(index++, accountFrom);
            }
            if (accountTo != null && !accountTo.equals("")) {
                ps.setString(index++, accountTo + "zzzzzz");
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                AccountViewInfo account = new AccountViewInfo();
                account.put("id", (Object)rs.getString("id"));
                account.put("number", (Object)rs.getString("fnumber"));
                account.put("name", (Object)rs.getString("fname"));
                accounts.add(account);
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)ps);
            sql = new StringBuffer("select distinct rel.fid relid,item.fid id,item.fisforcompany fisforcompany,item.fnumber fnumber,item.fdefaultqueryname queryname,item.frealtiondataobject tablename, item.fassthgattribute propname, item.fmappingfieldname fieldname,item.fname_");
            sql.append(loc);
            sql.append(" fname, item.FGLAsstActTypeGrpID,item.FUseLongNumber useLongNUmber from T_BD_AccountView account").append(" inner join T_BD_AsstAccount book on account.fcaa = book.fid").append(" inner join T_BD_AsstActGroupDetail rel on book.fid = rel.fasstaccountid").append(" inner join T_BD_AsstActType item on item.fid = rel.fasstacttypeid").append(" and account.fid=? ");
            HashMap<String, Integer> hmCount = new HashMap<String, Integer>();
            ps = con.prepareStatement(sql.toString());
            Iterator iter = accounts.iterator();
            int count = 0;
            while (iter.hasNext()) {
                ++count;
                AccountViewInfo account = (AccountViewInfo)iter.next();
                ps.clearParameters();
                ps.setString(1, (String)account.get("id"));
                rs = ps.executeQuery();
                while (rs.next()) {
                    HashMap<String, Object> item = new HashMap<String, Object>();
                    item.put("relid", rs.getString("relid"));
                    String id = rs.getString("id");
                    item.put("id", id);
                    item.put("isforcompany", rs.getBoolean("fisforcompany"));
                    item.put("number", rs.getString("fnumber"));
                    item.put("name", rs.getString("fname"));
                    item.put("queryname", rs.getString("queryname"));
                    item.put("propname", rs.getString("propname"));
                    item.put("fieldname", rs.getString("fieldname"));
                    item.put("tablename", rs.getString("tablename"));
                    item.put("FGLAsstActTypeGrpID", rs.getString("FGLAsstActTypeGrpID"));
                    item.put("useLongNUmber", rs.getBoolean("useLongNUmber"));
                    if (hmCount.containsKey(id)) {
                        Integer i = (Integer)hmCount.get(id);
                        Integer i2 = new Integer(i + 1);
                        hmCount.put(id, i2);
                        continue;
                    }
                    hmCount.put(id, new Integer(1));
                    allItems.put(id, item);
                }
            }
            Iterator iter2 = hmCount.keySet().iterator();
            if (indexType == 0) {
                while (iter2.hasNext()) {
                    key = (String)iter2.next();
                    Integer i = (Integer)hmCount.get(key);
                    if (i != count) continue;
                    crossItems.add(allItems.get(key));
                }
            } else {
                while (iter2.hasNext()) {
                    key = (String)iter2.next();
                    crossItems.add(allItems.get(key));
                }
            }
        }
        catch (SQLException sqle) {
            try {
                throw new SQLAccessException(sqle);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)con);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("accounts", accounts);
        result.put("items", crossItems);
        return result;
    }

    private void buildAccountSql(StringBuffer sql, Map accountParams, String columnName) {
        String accountFrom = (String)accountParams.get("accountFrom");
        String accountTo = (String)accountParams.get("accountTo");
        String accountIns = (String)accountParams.get("accountIns");
        if (accountIns != null && accountIns.length() > 0) {
            sql.append(" and (" + columnName + " in (" + accountIns + ") ");
            if (accountFrom != null && accountFrom.length() > 0 || accountTo != null && accountTo.length() > 0) {
                sql.append("or 1=1 ");
                if (accountFrom != null && accountFrom.length() > 0) {
                    sql.append(" and " + columnName + ">=? ");
                }
                if (accountTo != null && accountTo.length() > 0) {
                    sql.append(" and " + columnName + "<=? ");
                }
            }
            sql.append(")");
        } else {
            if (accountFrom != null && !accountFrom.equals("")) {
                sql.append(" and " + columnName + ">=? ");
            }
            if (accountTo != null && !accountTo.equals("")) {
                sql.append(" and " + columnName + "<=? ");
            }
        }
    }

    private void buildAccountSqlInTimeVerify(StringBuffer sql, List sqlParams, Map accountParams, String columnName) {
        String accountFrom = (String)accountParams.get("accountFrom");
        String accountTo = (String)accountParams.get("accountTo");
        String accountIns = (String)accountParams.get("accountIns");
        if (accountIns != null && accountIns.length() > 0) {
            sql.append(" and (" + columnName + " in (" + accountIns + ") ");
            if (accountFrom != null && accountFrom.length() > 0 || accountTo != null && accountTo.length() > 0) {
                String subSql = null;
                if (accountFrom != null && accountFrom.length() > 0) {
                    subSql = columnName + " >= ?";
                    sqlParams.add(accountFrom);
                }
                if (accountTo != null && accountTo.length() > 0) {
                    subSql = subSql != null ? subSql + " and " + columnName + " <=? " : columnName + " <=? ";
                    sqlParams.add(accountTo + "zzzzzz");
                }
                sql.append(" or (").append(subSql).append(" )");
            }
            sql.append(")");
        } else {
            if (accountFrom != null && !accountFrom.equals("")) {
                sql.append(" and " + columnName + ">=? ");
                sqlParams.add(accountFrom);
            }
            if (accountTo != null && !accountTo.equals("")) {
                sql.append(" and " + columnName + "<=? ");
                sqlParams.add(accountTo + "zzzzzz");
            }
        }
    }

    private Map getAccountParam(String accountFrom, String accountTo) {
        HashMap<String, String> result = new HashMap<String, String>();
        String[] acctFroms = new String[]{};
        if (accountFrom != null) {
            acctFroms = accountFrom.split(";");
        }
        String[] acctTos = new String[]{};
        if (accountTo != null) {
            acctTos = accountTo.split(";");
        }
        String acctIns = "";
        if (acctFroms.length > 0 && acctTos.length > 0) {
            if (acctFroms[acctFroms.length - 1].compareTo(acctTos[0]) > 0) {
                int i;
                for (i = 0; i < acctFroms.length; ++i) {
                    acctIns = acctIns + "'" + acctFroms[i] + "',";
                }
                for (i = 0; i < acctTos.length; ++i) {
                    acctIns = acctIns + "'" + acctTos[i] + "',";
                }
                accountFrom = null;
                accountTo = null;
            } else {
                int i;
                for (i = 0; i < acctFroms.length - 1; ++i) {
                    acctIns = acctIns + "'" + acctFroms[i] + "',";
                }
                for (i = 1; i < acctTos.length; ++i) {
                    acctIns = acctIns + "'" + acctTos[i] + "',";
                }
                accountFrom = acctFroms[acctFroms.length - 1];
                accountTo = acctTos[0];
            }
        } else if (acctFroms.length > 0) {
            for (int i = 0; i < acctFroms.length - 1; ++i) {
                acctIns = acctIns + "'" + acctFroms[i] + "',";
            }
            accountFrom = acctFroms[acctFroms.length - 1];
        } else if (acctTos.length > 0) {
            for (int i = 1; i < acctTos.length; ++i) {
                acctIns = acctIns + "'" + acctTos[i] + "',";
            }
            accountTo = acctTos[0];
        }
        result.put("accountFrom", accountFrom);
        result.put("accountTo", accountTo);
        result.put("accountIns", acctIns.length() > 0 ? acctIns.substring(0, acctIns.length() - 1) : "");
        return result;
    }

    public List exec(Context ctx, Map param) throws BOSException, EASBizException {
        String accountid = (String)param.get("accountid");
        String currencyid = (String)param.get("currencyid");
        int[] days = (int[])param.get("days");
        if (days != null && days.length > 0 && days[days.length - 1] == Integer.MAX_VALUE) {
            int[] daysForRemoveMaxNumber = new int[days.length - 1];
            System.arraycopy(days, 0, daysForRemoveMaxNumber, 0, days.length - 1);
            days = daysForRemoveMaxNumber;
        }
        HashMap hmItems = (HashMap)param.get("hmItems");
        String[] asstTypes = (String[])param.get("asstTypes");
        java.util.Date endDate = (java.util.Date)param.get("endDate");
        java.util.Date historyDate = (java.util.Date)param.get("historyDate");
        boolean includeUnPosted = (Boolean)param.get("includeUnPosted");
        boolean includeInit = (Boolean)param.get("includeInit");
        boolean includeVerifyVch = param.get("includeVerifyVch") == null ? false : (Boolean)param.get("includeVerifyVch");
        boolean isBizCode = param.get("isBizCode") != null && (Boolean)param.get("isBizCode") != false;
        String companyid = (String)param.get("companyid");
        int dateType = (Integer)param.get("dateType");
        int indexType = (Integer)param.get("indexType");
        Object accountFrom = param.get("accountFrom");
        Object accountTo = param.get("accountTo");
        CompanyOrgUnitInfo _company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyid));
        boolean isIsOnlyUnion = GlUtils.isCompanyUnion((CompanyOrgUnitInfo)_company);
        String acctTableId = null;
        if (param.get("accountTable") instanceof String) {
            acctTableId = (String)param.get("accountTable");
        } else if (param.get("accountTable") instanceof BOSUuid) {
            acctTableId = ((BOSUuid)param.get("accountTable")).toString();
        }
        if (acctTableId == null) {
            acctTableId = _company.getAccountTable().getId().toString();
        }
        String companyIdsForOnlyUnion = (String)param.get("companyIdsForOnlyUnion");
        if (asstTypes != null) {
            HashMap<String, String> othersParam = null;
            if (isIsOnlyUnion) {
                othersParam = new HashMap<String, String>();
                othersParam.put("companyIds", companyIdsForOnlyUnion);
                othersParam.put("accountTableid", acctTableId);
            }
            IAccountAgeFacade facade = AccountAgeFacadeFactory.getLocalInstance((Context)ctx);
            hmItems = QueryAsstItems.exec(ctx, (String)accountFrom, (String)accountTo, companyid, indexType, historyDate, othersParam, asstTypes);
        }
        if (isIsOnlyUnion) {
            int companyLevel = (Integer)param.get("curLevel");
            String curCompanyid = (String)param.get("curCompanyid");
            if (param.get("companyIds") != null) {
                curCompanyid = (String)param.get("companyIds");
            }
            HashMap otherInfo = (HashMap)param.get("otherInfo");
            boolean isfirstload = param.get("firstLoad").toString().equals("true");
            if (param.get("accountViewNumber") != null) {
                return this.queryAgeByAcctOnlyUnion(ctx, null, currencyid, days, hmItems, endDate, includeUnPosted, includeInit, companyIdsForOnlyUnion, dateType, indexType, accountFrom, accountTo, companyLevel, curCompanyid, (String)param.get("accountViewNumber"), otherInfo, acctTableId, isfirstload, includeVerifyVch, isBizCode, companyid);
            }
            String accountViewNumber = null;
            if (otherInfo != null && otherInfo.get("accountViewNumber") != null) {
                accountViewNumber = otherInfo.get("accountViewNumber").toString();
            }
            return this.queryAgeByAcctOnlyUnion(ctx, accountid, currencyid, days, hmItems, endDate, includeUnPosted, includeInit, companyIdsForOnlyUnion, dateType, indexType, accountFrom, accountTo, companyLevel, curCompanyid, accountViewNumber, null, acctTableId, isfirstload, includeVerifyVch, isBizCode, companyid);
        }
        if (!isBizCode || indexType != 1) {
            String string = accountid = accountid != null && accountid.indexOf("'") == -1 ? "'" + accountid + "'" : accountid;
        }
        if (GlUtils.getVerifyMode((Context)ctx, (String)companyid) == 0 && historyDate != null) {
            return this.queryAgeByAcctIntimeHistory(ctx, accountid, currencyid, days, hmItems, endDate, includeUnPosted, includeInit, companyid, dateType, indexType, accountFrom, accountTo, includeVerifyVch, isBizCode, historyDate);
        }
        return this.queryAgeByAcct(ctx, accountid, currencyid, days, hmItems, endDate, includeUnPosted, includeInit, companyid, dateType, indexType, accountFrom, accountTo, includeVerifyVch, isBizCode, historyDate);
    }

    protected ArrayList _getInitData(Context ctx, HashMap otherCtx) throws BOSException, EASBizException {
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)otherCtx.get("COMPANY");
        if (company == null) {
            throw new GLException(GLException.NOCOMPANY);
        }
        if (company.getAccountPeriodType() == null) {
            throw new GLException(GLException.NOPERIODTYPE);
        }
        ArrayList<Object> result = new ArrayList<Object>();
        ICurrency curCtrl = CurrencyFactory.getLocalInstance((Context)ctx);
        CurrencyCollection curCol = curCtrl.getCurrencyCollection(false);
        if (curCol.size() == 0) {
            throw new GLException(GLException.NOCURRENCY);
        }
        result.add(curCol);
        Map hmParamValue = InitHelp.getInitParam((Context)ctx, (CompanyOrgUnitInfo)company);
        result.add(hmParamValue.get("GL_008"));
        result.add(hmParamValue.get("G001"));
        return result;
    }

    protected ArrayList queryAcctIndex(Context ctx, String[] accountIds, String currencyId, HashMap hmItems, java.util.Date endDate, boolean includeUnPosted, boolean includeInit, String companyId, int dateType, boolean isBizCode) throws BOSException, EASBizException {
        CompanyOrgUnitInfo _company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId));
        boolean isIsOnlyUnion = GlUtils.isCompanyUnion((CompanyOrgUnitInfo)_company);
        if (isIsOnlyUnion) {
            includeUnPosted = true;
        } else {
            int verifyMode = GlUtils.getVerifyMode((Context)ctx, (String)companyId);
            if (verifyMode == 2) {
                includeUnPosted = true;
            }
        }
        this.enterDateType(dateType);
        ArrayList<AccountViewInfo> result = new ArrayList<AccountViewInfo>();
        String loc = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        boolean allCurr = false;
        if (currencyId.equals("all")) {
            allCurr = true;
        }
        boolean general = false;
        if (CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString().equals(currencyId) || CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString().equals(currencyId)) {
            general = true;
        }
        StringBuffer inAccount = null;
        if (accountIds != null) {
            inAccount = new StringBuffer("(");
            for (int i = 0; i < accountIds.length; ++i) {
                inAccount.append("'").append(accountIds[i]).append("',");
            }
            inAccount.deleteCharAt(inAccount.length() - 1);
            inAccount.append(")");
        }
        StringBuffer from = new StringBuffer();
        StringBuffer initFrom = new StringBuffer();
        from.append(" from t_gl_voucherassistrecord assist,t_gl_voucherentry entry,t_gl_voucher voucher,t_bd_accountview account");
        if (hmItems.size() > 0) {
            from.append(",t_bd_assistanthg hg ");
        }
        if (includeInit) {
            initFrom.append(" from t_gl_voucherassistrecord assist,t_gl_acctcussent cussent,t_bd_accountview account,t_bd_assistanthg hg ");
        }
        StringBuffer innerJoin = new StringBuffer();
        StringBuffer groupby = new StringBuffer();
        ArrayList<String> alNumbers = new ArrayList<String>();
        ArrayList<String> alTables = new ArrayList<String>();
        ArrayList<String> alFields = new ArrayList<String>();
        Iterator itemkeyit = hmItems.keySet().iterator();
        HashMap[] itemList = new HashMap[hmItems.keySet().size()];
        int k = 0;
        while (itemkeyit.hasNext()) {
            HashMap item = (HashMap)itemkeyit.next();
            Integer seq = (Integer)item.get("seq");
            if (seq != null) {
                itemList[seq.intValue()] = item;
            } else {
                itemList[k] = item;
            }
            ++k;
        }
        if (isBizCode) {
            if (hmItems.size() > 0) {
                innerJoin.append(" left join ").append("t_bd_customer").append(" cst").append(" on hg.").append("fcustomerid").append("=").append("cst").append(".fid");
                innerJoin.append(" left join T_BD_BizAnaylysisCode bac1 on bac1.fid = cst.FBizAnalysisCodeID ");
                innerJoin.append(" left join ").append("T_BD_Supplier").append(" sup").append(" on hg.").append("FProviderID").append("=").append("sup").append(".fid");
                innerJoin.append(" left join T_BD_BizAnaylysisCode bac on bac.fid = sup.FBizAnalysisCodeID ");
            }
        } else {
            for (int i = 0; i < itemList.length; ++i) {
                HashMap item = itemList[i];
                String[] numbers = (String[])hmItems.get(item);
                String table = (String)item.get("tablename");
                String field = (String)item.get("fieldname");
                boolean isGeneralActType = item.get("FGLAsstActTypeGrpID") != null && item.get("propname").toString().startsWith("generalAssActType");
                boolean isUseLongNumber = (Boolean)item.get("useLongNUmber");
                alTables.add(table);
                alFields.add(field);
                innerJoin.append(" inner join ").append(table).append(" as ").append("t").append(i).append(" on hg.").append(field).append("=").append("t").append(i).append(".fid");
                if (numbers[0] != null) {
                    innerJoin.append(" and ").append("t").append(i);
                    if (!isGeneralActType || !isUseLongNumber) {
                        innerJoin.append(".fnumber>=?");
                        alNumbers.add(numbers[0]);
                    } else {
                        innerJoin.append(".flongnumber>=?");
                        alNumbers.add(numbers[0].replace('.', '!'));
                    }
                }
                if (numbers[1] != null) {
                    innerJoin.append(" and ").append("t").append(i);
                    if (!isGeneralActType || !isUseLongNumber) {
                        innerJoin.append(".fnumber<=?");
                        alNumbers.add(numbers[1]);
                    } else {
                        innerJoin.append(".flongnumber<=?");
                        alNumbers.add(numbers[1].replace('.', '!'));
                    }
                }
                ++i;
            }
        }
        StringBuffer where = new StringBuffer();
        StringBuffer initWhere = new StringBuffer();
        if (isIsOnlyUnion) {
            where.append(" where voucher.fcompanyid in (").append(companyId).append(")");
        } else {
            where.append(" where voucher.fcompanyid=? ");
        }
        if (hmItems.size() > 0) {
            where.append(" and assist.fassgrpid=hg.fid ");
        }
        where.append(" and assist.fentryid=entry.fid and entry.fbillid=voucher.fid and entry.faccountid=account.fid and account.fac=1 ");
        if (inAccount != null) {
            where.append(" and entry.faccountid in ").append(inAccount);
        }
        if (!includeUnPosted) {
            where.append(" and voucher.FBizStatus=?");
        } else {
            where.append(" and voucher.fbizstatus <> ? and voucher.fbizstatus<>? ");
        }
        if (!general && !allCurr) {
            where.append(" and entry.fcurrencyid=? ");
        }
        if (includeInit) {
            if (isIsOnlyUnion) {
                initWhere.append(" where cussent.fcompanyid in (").append(companyId).append(") and assist.fassgrpid=hg.fid and cussent.faccountid=account.fid ");
            } else {
                initWhere.append(" where cussent.fcompanyid=? and assist.fassgrpid=hg.fid and cussent.faccountid=account.fid ");
            }
            initWhere.append(" and assist.fentryid is null and cussent.fvchassistrecordid=assist.fid and cussent.fisinit=1 and cussent.fisinitclosed=1 and account.fac=1 ");
            if (inAccount != null) {
                initWhere.append(" and cussent.faccountid in ").append(inAccount);
            }
            if (!general && !allCurr) {
                initWhere.append(" and cussent.fcurrencyid=? ");
            }
        }
        ArrayList<String> bizParams = new ArrayList<String>();
        if (isBizCode && hmItems.size() > 0) {
            HashMap item = itemList[0];
            String[] numbers = (String[])hmItems.get(item);
            where.append(" and (");
            if (includeInit) {
                initWhere.append(" and (");
            }
            where.append(" (bac1.fid is not null ");
            if (includeInit) {
                initWhere.append(" (bac1.fid is not null ");
            }
            if (numbers != null && numbers[0] != null) {
                bizParams.add(numbers[0]);
                where.append(" and ").append("bac1").append(".fnumber>=?");
                if (includeInit) {
                    initWhere.append(" and ").append("bac1").append(".fnumber>=?");
                }
            }
            if (numbers != null && numbers[1] != null) {
                bizParams.add(numbers[1] + "~");
                where.append(" and ").append("bac1").append(".fnumber<=?");
                if (includeInit) {
                    initWhere.append(" and ").append("bac1").append(".fnumber<=?");
                }
            }
            where.append(") or (bac.fid is not null ");
            if (includeInit) {
                initWhere.append(") or (bac.fid is not null ");
            }
            if (numbers != null && numbers[0] != null) {
                bizParams.add(numbers[0]);
                where.append(" and ").append("bac").append(".fnumber>=?");
                if (includeInit) {
                    initWhere.append(" and ").append("bac").append(".fnumber>=?");
                }
            }
            if (numbers != null && numbers[1] != null) {
                bizParams.add(numbers[1] + "~");
                where.append(" and ").append("bac").append(".fnumber<=?");
                if (includeInit) {
                    initWhere.append(" and ").append("bac").append(".fnumber<=?");
                }
            }
            where.append("))");
            if (includeInit) {
                initWhere.append("))");
            }
        }
        String accountname = GlUtils.isAccountShowLongName((Context)ctx, (String)_company.getId().toString()) ? "Flongname_" : "Fname_";
        StringBuffer selectAccount = new StringBuffer(" distinct account.fid id,account.fnumber fnumber,account.").append(accountname).append(loc).append(" fname,account.FParentID parentId,account.FLongNumber longNumber,account.FIsLeaf isLeaf ");
        if (isIsOnlyUnion) {
            selectAccount = new StringBuffer(" distinct account.fnumber fnumber,account.fname_").append(loc).append(" fname ");
        }
        String orderBy = " order by fnumber";
        StringBuffer merge = new StringBuffer();
        if (!includeInit) {
            merge.append("select ").append(selectAccount).append(from).append(innerJoin).append(where).append(groupby).append(orderBy);
        } else {
            StringBuffer sql1 = new StringBuffer();
            StringBuffer sql2 = new StringBuffer();
            sql1.append("select ").append(selectAccount).append(from).append(innerJoin).append(where).append(groupby);
            sql2.append("select ").append(selectAccount).append(initFrom).append(innerJoin).append(initWhere).append(groupby);
            merge.append("select distinct * from (").append(sql1).append(" union all ").append(sql2).append(") as t ").append(orderBy);
        }
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = GetConnection.exec(ctx);
            ps = con.prepareStatement(merge.toString());
            int index = 1;
            for (String number : alNumbers) {
                ps.setString(index++, number);
            }
            if (!isIsOnlyUnion) {
                ps.setString(index++, companyId);
            }
            if (!includeUnPosted) {
                ps.setInt(index++, 5);
            } else {
                ps.setInt(index++, 0);
                ps.setInt(index++, 2);
            }
            if (!general && !allCurr) {
                ps.setString(index++, currencyId);
            }
            for (String number : bizParams) {
                ps.setString(index++, number);
            }
            if (includeInit) {
                for (String number : alNumbers) {
                    ps.setString(index++, number);
                }
                if (!isIsOnlyUnion) {
                    ps.setString(index++, companyId);
                }
                if (!general && !allCurr) {
                    ps.setString(index++, currencyId);
                }
            }
            if (includeInit) {
                for (String number : bizParams) {
                    ps.setString(index++, number);
                }
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                AccountViewInfo account = new AccountViewInfo();
                if (!isIsOnlyUnion && rs.getString("id") != null) {
                    account.put("id", (Object)rs.getString("id"));
                }
                account.put("number", (Object)rs.getString("fnumber"));
                account.put("name", (Object)rs.getString("fname"));
                if (!isIsOnlyUnion) {
                    if (rs.getString("parentId") != null && rs.getString("parentId").length() > 0) {
                        AccountViewInfo parent = new AccountViewInfo();
                        parent.setId(BOSUuid.read((String)rs.getString("parentId")));
                        account.setParent(parent);
                    }
                    account.setLongNumber(rs.getString("longNumber"));
                    account.setIsLeaf(rs.getBoolean("isLeaf"));
                }
                result.add(account);
            }
        }
        catch (SQLException sqle) {
            try {
                throw new SQLAccessException(sqle);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)con);
        return result;
    }

    protected ArrayList queryItemIndex(Context ctx, String[] accountIds, String currencyId, HashMap hmItems, java.util.Date endDate, boolean includeUnPosted, boolean includeInit, String companyId, int dateType) throws BOSException, EASBizException {
        int start;
        CompanyOrgUnitInfo _company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId));
        boolean isIsOnlyUnion = GlUtils.isCompanyUnion((CompanyOrgUnitInfo)_company);
        ArrayList result = new ArrayList();
        String loc = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        StringBuffer innerJoin = new StringBuffer();
        HashMap<String, Object> hmParamIn = new HashMap<String, Object>();
        hmParamIn.put("GL_064", null);
        HashMap hmAllParam = ParamControlFactory.getLocalInstance((Context)ctx).getParamHashMap(hmParamIn);
        Object isShowLongNumberObj = hmAllParam.get("GL_064");
        boolean isShowLongNumber = false;
        if (isShowLongNumberObj != null) {
            isShowLongNumber = Boolean.valueOf(isShowLongNumberObj.toString());
        }
        ArrayList<String> asstact = new ArrayList<String>();
        StringBuffer itemselect = new StringBuffer();
        ArrayList<Object> param = new ArrayList<Object>();
        ArrayList<String> initparam = new ArrayList<String>();
        Iterator itemkeyit = hmItems.keySet().iterator();
        HashMap[] itemList = new HashMap[hmItems.keySet().size()];
        int k = 0;
        while (itemkeyit.hasNext()) {
            HashMap item = (HashMap)itemkeyit.next();
            Integer seq = (Integer)item.get("seq");
            if (seq != null) {
                itemList[seq.intValue()] = item;
            } else {
                itemList[k] = item;
            }
            ++k;
        }
        int j = 0;
        for (int i = 0; i < itemList.length; ++i) {
            HashMap item = itemList[i];
            String[] numbers = (String[])hmItems.get(item);
            String table = (String)item.get("tablename");
            String field = (String)item.get("fieldname");
            String itemTypeid = (String)item.get("id");
            boolean useLongNumber = (Boolean)item.get("useLongNUmber");
            asstact.add(itemTypeid);
            itemselect.append(",t").append(j).append(".").append("fid").append(" as t").append(j).append("fid");
            itemselect.append(",").append(useLongNumber ? "replace(t" + j + ".FLongNumber,'!','.') as t" : "t" + j + ".Fnumber as t").append(j).append("Fnumber");
            itemselect.append(",t").append(j).append(".").append("Fname_").append(loc).append(" as t").append(j).append("Fname");
            innerJoin.append(" inner join ").append(table).append(" t").append(j).append(" on hg.").append(field).append("=").append("t").append(j).append(".fid");
            if (numbers[0] != null) {
                if (!useLongNumber) {
                    innerJoin.append(" and ").append("t").append(j).append(".fnumber>=?");
                    param.add(numbers[0]);
                    if (includeInit) {
                        initparam.add(numbers[0]);
                    }
                } else {
                    innerJoin.append(" and ").append("t").append(j).append(".flongnumber>=?");
                    numbers[0] = numbers[0].replace('.', '!');
                    param.add(numbers[0]);
                    if (includeInit) {
                        initparam.add(numbers[0]);
                    }
                }
            }
            if (numbers[1] != null) {
                if (!useLongNumber) {
                    innerJoin.append(" and ").append("t").append(j).append(".fnumber<=?");
                    param.add(numbers[1]);
                    if (includeInit) {
                        initparam.add(numbers[1]);
                    }
                } else {
                    innerJoin.append(" and ").append("t").append(j).append(".flongnumber<=?");
                    numbers[1] = numbers[1].replace('.', '!');
                    param.add(numbers[1]);
                    if (includeInit) {
                        initparam.add(numbers[1]);
                    }
                }
            }
            ++j;
        }
        StringBuffer sql = new StringBuffer();
        StringBuffer select = new StringBuffer();
        StringBuffer initfrom = new StringBuffer();
        StringBuffer noinitfrom = new StringBuffer();
        StringBuffer noinitwhere = new StringBuffer();
        StringBuffer initwhere = new StringBuffer();
        select.append("select distinct hg.fid as hgfid ");
        select.append(itemselect);
        if (includeInit) {
            initfrom.append(" from t_gl_voucherassistrecord assist");
            initfrom.append(" inner join t_gl_acctcussent  cussent on cussent.fvchassistrecordid = assist.fid");
            initfrom.append(" inner join t_bd_assistanthg hg on assist.fassgrpid = hg.fid");
            initfrom.append(innerJoin);
        }
        noinitfrom.append(" from t_gl_voucherassistrecord assist");
        noinitfrom.append(" inner join t_gl_voucherentry entry  on assist.fentryid = entry.fid");
        noinitfrom.append(" inner join t_gl_voucher  voucher on entry.fbillid = voucher.fid");
        noinitfrom.append(" inner join t_bd_assistanthg hg on assist.fassgrpid = hg.fid");
        noinitfrom.append(innerJoin);
        if (isIsOnlyUnion) {
            noinitwhere.append(" where  voucher.fcompanyid in (").append(companyId).append(") ");
        } else {
            noinitwhere.append(" where  voucher.fcompanyid = ? ");
            param.add(companyId);
        }
        if (includeInit) {
            if (isIsOnlyUnion) {
                initwhere.append(" where  cussent.fcompanyid in (").append(companyId).append(") ");
            } else {
                initwhere.append(" where  cussent.fcompanyid = ? ");
                initparam.add(companyId);
            }
        }
        StringBuffer inAccount = null;
        if (accountIds != null) {
            inAccount = new StringBuffer("(");
            for (int i = 0; i < accountIds.length; ++i) {
                inAccount.append("'").append(accountIds[i]).append("',");
            }
            inAccount.deleteCharAt(inAccount.length() - 1);
            inAccount.append(")");
        }
        if (inAccount != null) {
            noinitwhere.append(" and entry.faccountid in ").append(inAccount);
            if (includeInit) {
                initwhere.append(" and cussent.faccountid in ").append(inAccount);
            }
        }
        boolean allCurr = false;
        if (currencyId.equals("all")) {
            allCurr = true;
        }
        boolean localCurrency = false;
        if (CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString().equals(currencyId)) {
            localCurrency = true;
        }
        if (!allCurr && !localCurrency) {
            noinitwhere.append(" and entry.fcurrencyid=? ");
            param.add(currencyId);
            if (includeInit) {
                initwhere.append(" and cussent.fcurrencyid=? ");
                initparam.add(currencyId);
            }
        }
        if (isIsOnlyUnion) {
            includeUnPosted = true;
        } else {
            int verifyMode = GlUtils.getVerifyMode((Context)ctx, (String)companyId);
            if (verifyMode == 2) {
                includeUnPosted = true;
            }
        }
        if (!includeUnPosted) {
            noinitwhere.append(" and voucher.FBizStatus=?");
            param.add(new Integer(5));
        } else {
            noinitwhere.append(" and voucher.fbizstatus <> ? and voucher.fbizstatus<>? ");
            param.add(new Integer(0));
            param.add(new Integer(2));
        }
        if (asstact.size() > 0) {
            StringBuffer noinitwheresubWhere = new StringBuffer();
            noinitwhere.append(" and hg.fasstaccountid  in ( ");
            noinitwhere.append(" select ass.fid from t_bd_asstaccount ass join t_bd_asstactgroupdetail ast on ast.fasstaccountid=ass.fid ");
            noinitwheresubWhere.append(" where ");
            for (int i = 0; i < asstact.size(); ++i) {
                if (i == 0) {
                    noinitwheresubWhere.append(" ast.fasstacttypeid = ? ");
                } else {
                    noinitwhere.append(" join t_bd_asstactgroupdetail ast" + i + " on ast" + i + ".fasstaccountid=ass.fid");
                    noinitwheresubWhere.append(" and ast" + i + ".fasstacttypeid = ? ");
                }
                param.add(asstact.get(i).toString());
            }
            noinitwhere.append(noinitwheresubWhere);
            noinitwhere.append(" ) ");
            if (includeInit) {
                StringBuffer initwheresubWhere = new StringBuffer();
                initwhere.append(" and hg.fasstaccountid  in ( ");
                initwhere.append(" select ass.fid from t_bd_asstaccount ass join t_bd_asstactgroupdetail ast on ast.fasstaccountid=ass.fid ");
                initwheresubWhere.append(" where ");
                for (int i = 0; i < asstact.size(); ++i) {
                    if (i == 0) {
                        initwheresubWhere.append(" ast.fasstacttypeid = ? ");
                    } else {
                        initwhere.append(" join t_bd_asstactgroupdetail ast" + i + " on ast" + i + ".fasstaccountid=ass.fid");
                        initwheresubWhere.append(" and ast" + i + ".fasstacttypeid = ? ");
                    }
                    initparam.add(asstact.get(i).toString());
                }
                initwhere.append(initwheresubWhere);
                initwhere.append(" ) ");
            }
        }
        if (includeInit) {
            sql.append("select hgfid ");
            for (start = 0; start < j; ++start) {
                sql.append(" ,t" + start + "fid");
                sql.append(" ,t" + start + "fnumber");
                sql.append(" ,t" + start + "fname");
            }
            sql.append(" from ( ");
            sql.append(select).append(noinitfrom).append(noinitwhere);
            sql.append(" UNION ");
            sql.append(select).append(initfrom).append(initwhere);
            sql.append(" )a");
            for (int i = 0; i < initparam.size(); ++i) {
                param.add(initparam.get(i));
            }
        } else {
            sql.append(select).append(noinitfrom).append(noinitwhere);
        }
        sql.append(" order by");
        for (start = 0; start < j; ++start) {
            if (start == 0) {
                sql.append(" t" + start + "fnumber");
                continue;
            }
            sql.append(" ,t" + start + "fnumber");
        }
        TreeMap<String, ItemStructureInfo> resultMap = new TreeMap<String, ItemStructureInfo>();
        IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])param.toArray());
        try {
            while (rowset.next()) {
                ItemStructureInfo itemStructureInfo = new ItemStructureInfo();
                String hgfid = rowset.getString("hgfid");
                StringBuffer itemNumbers = new StringBuffer();
                for (int start2 = 0; start2 < j; ++start2) {
                    HashMap<String, String> item = new HashMap<String, String>();
                    String itemNumber = rowset.getString("t" + start2 + "fnumber");
                    itemNumbers.append(itemNumber);
                    item.put("hgfid", hgfid);
                    item.put("id", rowset.getString("t" + start2 + "fid"));
                    item.put("number", itemNumber);
                    item.put("name", rowset.getString("t" + start2 + "fname"));
                    itemStructureInfo.getItem().add(item);
                }
                hgfid = "'" + hgfid + "'";
                itemStructureInfo.setHgid(hgfid);
                if (resultMap.containsKey(itemNumbers.toString())) {
                    itemStructureInfo = (ItemStructureInfo)resultMap.get(itemNumbers.toString());
                    itemStructureInfo.setHgid(itemStructureInfo.getHgid() + "," + hgfid + "");
                    continue;
                }
                resultMap.put(itemNumbers.toString(), itemStructureInfo);
            }
        }
        catch (SQLException sqle) {
            throw new SQLAccessException(sqle);
        }
        result.addAll(resultMap.values());
        return result;
    }

    private ArrayList queryBizCodeIndex(Context ctx, String[] accountIds, String currencyId, HashMap hmItems, java.util.Date endDate, boolean includeUnPosted, boolean includeInit, String companyId, int dateType) throws BOSException, EASBizException {
        CompanyOrgUnitInfo _company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId));
        boolean isIsOnlyUnion = GlUtils.isCompanyUnion((CompanyOrgUnitInfo)_company);
        ArrayList<BizAnalysisCodeInfo> result = new ArrayList<BizAnalysisCodeInfo>();
        String loc = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        StringBuffer sql = new StringBuffer();
        sql.append(" select bc.fid,bc.fnumber fbiznumber,bc.fname_").append(loc).append(" fbizname\r\nfrom T_BD_BizAnaylysisCode bc \r\nwhere ");
        Iterator itemkeyit = hmItems.keySet().iterator();
        int j = 0;
        while (itemkeyit.hasNext()) {
            HashMap item = (HashMap)itemkeyit.next();
            String[] numbers = (String[])hmItems.get(item);
            if (numbers[0] != null) {
                sql.append("bc.fnumber >='").append(numbers[0]).append("' and ");
            }
            if (numbers[1] != null) {
                sql.append("bc.fnumber <'").append(numbers[1]).append("~' and ");
            }
            ++j;
        }
        if (isIsOnlyUnion) {
            sql.append("   bc.fadmincuid in (").append(companyId).append(") or bc.fadmincuid = ").append("'").append(_company.getId()).append("'");
        } else {
            sql.append(BizAnalysisCodeFactory.getLocalInstance((Context)ctx).getDatabaseDFilter((IObjectPK)new ObjectUuidPK(companyId), "bc.fid", "bc.fadmincuid"));
        }
        sql.append(" order by bc.fnumber ");
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = GetConnection.exec(ctx);
            ps = con.prepareStatement(sql.toString());
            rs = ps.executeQuery();
            while (rs.next()) {
                BizAnalysisCodeInfo account = new BizAnalysisCodeInfo();
                if (!isIsOnlyUnion && rs.getString("fid") != null) {
                    account.put("id", (Object)rs.getString("fid"));
                }
                account.put("number", (Object)rs.getString("fbiznumber"));
                account.put("name", (Object)rs.getString("fbizname"));
                result.add(account);
            }
        }
        catch (SQLException sqle) {
            try {
                throw new SQLAccessException(sqle);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)con);
        return result;
    }

    private CompanyOrgUnitInfo getCurrentCompany(Context ctx) throws BOSException, EASBizException {
        String curCompanyID = ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.addObjectCollection((IObjectCollection)GlUtils.getCompanySic());
        ICompanyOrgUnit comCtrl = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
        CompanyOrgUnitInfo com = null;
        ObjectUuidPK comPK = null;
        try {
            comPK = new ObjectUuidPK(BOSUuid.read((String)curCompanyID));
            com = (CompanyOrgUnitInfo)comCtrl.getValue((IObjectPK)comPK, sic);
        }
        catch (Exception ex) {
            throw new GLException(GLException.NOCOMPANY, (Throwable)ex);
        }
        return com;
    }

    public String creatAdjexchTempTable(Context ctx, java.util.Date endData) throws BOSException, EASBizException {
        CompanyOrgUnitInfo company = this.getCurrentCompany(ctx);
        ExchangeTableInfo adjTable = company.getAdjustExchangeTable();
        String localCurrencyID = company.getBaseCurrency().getId().toString();
        String tempateTable = "AccountAgeFacadeControllerBean";
        String craeteTableSQL = "CREATE TABLE " + tempateTable + " (\tFID varchar (44) NOT NULL,FConvertRateA  NUMERIC(28,10))";
        try {
            tempateTable = TempTablePool.getInstance((Context)ctx).createTempTable(craeteTableSQL);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        if (adjTable == null) {
            return tempateTable;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("insert into " + tempateTable);
        sql.append(" select distinct aux.FSourceCurrencyID fid, exch.FConvertRate FConvertRateA ");
        sql.append(" from T_BD_ExchangeAux aux  ");
        sql.append(" inner join T_BD_ExchangeRate exch on exch.FExchangeAuxID = aux.FID ");
        sql.append(" inner join  ( ");
        sql.append(" select aux.FSourceCurrencyID, aux.FTargetCurrencyID,max(exch.FAvailTime) FAvailTime ");
        sql.append(" from T_BD_ExchangeAux aux ");
        sql.append(" inner join T_BD_ExchangeRate exch on exch.FExchangeAuxID = aux.FID ");
        sql.append(" where aux.FExchangeTableId = ? ");
        sql.append(" and exch.FIsUsedBG = 0  ");
        sql.append(" and exch.FAvailTime <= ? ");
        sql.append(" group by aux.FExchangeTableId,aux.FSourceCurrencyID, aux.FTargetCurrencyID    )   extemp ");
        sql.append(" on extemp.FSourceCurrencyID=aux.FSourceCurrencyID ");
        sql.append(" and  extemp.FTargetCurrencyID=aux.FTargetCurrencyID and extemp.FAvailTime=exch.FAvailTime ");
        sql.append(" where aux.FExchangeTableId = ?  ");
        sql.append(" and exch.FIsUsedBG = 0 ");
        sql.append(" and exch.FAvailTime <= ?  ");
        sql.append(" and aux.FTargetCurrencyID = ? ");
        Object[] params = new Object[5];
        String adjustTableID = adjTable.getId().toString();
        params[0] = adjustTableID;
        params[1] = new Timestamp(endData.getTime());
        params[2] = adjustTableID;
        params[3] = new Timestamp(endData.getTime());
        params[4] = localCurrencyID;
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])params);
        return tempateTable;
    }

    public String creatAdjexchTempTable1(Context ctx) throws BOSException, EASBizException {
        CompanyOrgUnitInfo company = this.getCurrentCompany(ctx);
        String curCompanyID = company.getId().toString();
        PeriodInfo periodInfo = GlUtils.getCurrentPeriod((Context)ctx, (String)curCompanyID);
        int year = periodInfo.getPeriodYear();
        int periodNum = periodInfo.getPeriodNumber();
        String period = RptUtil.getYearPeriod(year, periodNum, year, periodNum);
        String localCurrencyID = company.getBaseCurrency().getId().toString();
        String localTableID = null;
        if (company.getBaseExchangeTable() == null) {
            throw new GLException(GLException.NOLOCALEXTABLE);
        }
        localTableID = company.getBaseExchangeTable().getId().toString();
        ExchangeTableInfo adjTable = company.getAdjustExchangeTable();
        if (adjTable == null) {
            throw new GLException(GLException.NOADJEXTABLE);
        }
        String adjustTableID = adjTable.getId().toString();
        Date prdEnd = new Date(periodInfo.getEndDate().getTime());
        Object[] params = new Object[]{localTableID, localCurrencyID, prdEnd, localTableID, localCurrencyID, prdEnd, adjustTableID, localCurrencyID, prdEnd, adjustTableID, localCurrencyID, prdEnd, curCompanyID, period, localCurrencyID};
        String tempateTable = "AccountAgeFacadeControllerBean";
        String craeteTableSQL = "CREATE TABLE " + tempateTable + " (\tFID varchar (44) NOT NULL,FConvertRateA  NUMERIC(19,4))";
        try {
            tempateTable = TempTablePool.getInstance((Context)ctx).createTempTable(craeteTableSQL);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        StringBuffer sql = new StringBuffer();
        sql.append("insert into " + tempateTable);
        sql.append(" select distinct src.FID FID,auxva.FConvertRate as FConvertRateA              \r\n");
        sql.append("from t_GL_AccountBalance_5L bal                                                         \t\t\t\t\r\n");
        sql.append("\tinner join t_BD_AccountView act on bal.FAccountID = act.FID                                     \r\n");
        sql.append("\tinner join T_BD_Currency src on bal.FCurrencyID = src.FID                                       \r\n");
        sql.append("                                                                                                    \r\n");
        sql.append("\tleft join                                                                                       \r\n");
        sql.append("(select aux.FExchangeTableId,aux.FSourceCurrencyID, aux.FTargetCurrencyID,               \t\r\n");
        sql.append("\t\t\taux.FConvertMode,aux.FPrecision,aux.FExchangeRateType, exch.FConvertRate,exch.FAvailTime \r\n");
        sql.append("      from T_BD_ExchangeAux aux                                                               \t\r\n");
        sql.append("\t\t\tinner join T_BD_ExchangeRate exch on exch.FExchangeAuxID = aux.FID \r\n");
        sql.append("      where exch.FAvailTime in (\r\n");
        sql.append("  select max(exch.FAvailTime)\r\n");
        sql.append("\t\tfrom T_BD_ExchangeAux aux                                                               \t\r\n");
        sql.append("\t\t\tinner join T_BD_ExchangeRate exch on exch.FExchangeAuxID = aux.FID      \r\n");
        sql.append("\t\twhere aux.FExchangeTableId = ?                                                          \t\r");
        sql.append("\t\t\tand aux.FTargetCurrencyID = ?                                                  \t\t\r");
        sql.append("\t\t\tand exch.FIsUsedBG = 0\t\t                                                    \t\t\r");
        sql.append("\t\t\t and exch.FAvailTime <= ? \r");
        sql.append("       group by aux.FExchangeTableId,aux.FSourceCurrencyID, aux.FTargetCurrencyID,               \t\r");
        sql.append("\t\t\taux.FConvertMode,aux.FPrecision,aux.FExchangeRateType)    \r");
        sql.append("      \t\tand aux.FExchangeTableId = ?                                                          \t\r");
        sql.append("\t\t\tand aux.FTargetCurrencyID = ?                                                  \t\t\r");
        sql.append("\t\t\tand exch.FIsUsedBG = 0\t\t                                                    \t\t\r");
        sql.append("\t\t\t and exch.FAvailTime <= ?                                               \t\t\r");
        sql.append("\t) auxv on auxv.FSourceCurrencyID = src.FID    \r");
        sql.append("                                                                                                    \r\n");
        sql.append("\tleft join                                                                                       \r\n");
        sql.append("(select aux.FExchangeTableId,aux.FSourceCurrencyID, aux.FTargetCurrencyID,               \t\r\n");
        sql.append("\t\t\taux.FConvertMode,aux.FPrecision,aux.FExchangeRateType, exch.FConvertRate,exch.FAvailTime \r\n");
        sql.append("      from T_BD_ExchangeAux aux                                                               \t\r\n");
        sql.append("\t\t\tinner join T_BD_ExchangeRate exch on exch.FExchangeAuxID = aux.FID \r\n");
        sql.append("      where exch.FAvailTime in (\r\n");
        sql.append("  select max(exch.FAvailTime)\r\n");
        sql.append("\t\tfrom T_BD_ExchangeAux aux                                                               \t\r\n");
        sql.append("\t\t\tinner join T_BD_ExchangeRate exch on exch.FExchangeAuxID = aux.FID      \r\n");
        sql.append("\t\twhere aux.FExchangeTableId = ?                                                          \t\r");
        sql.append("\t\t\tand aux.FTargetCurrencyID = ?                                                  \t\t\r");
        sql.append("\t\t\tand exch.FIsUsedBG = 0\t\t                                                    \t\t\r");
        sql.append("\t\t\t and exch.FAvailTime <= ? \r");
        sql.append("       group by aux.FExchangeTableId,aux.FSourceCurrencyID, aux.FTargetCurrencyID,               \t\r");
        sql.append("\t\t\taux.FConvertMode,aux.FPrecision,aux.FExchangeRateType)    \r");
        sql.append("      \t\tand aux.FExchangeTableId = ?                                                          \t\r");
        sql.append("\t\t\tand aux.FTargetCurrencyID = ?                                                  \t\t\r");
        sql.append("\t\t\tand exch.FIsUsedBG = 0\t\t                                                    \t\t\r");
        sql.append("\t\t\t and exch.FAvailTime <= ?                                               \t\t\r");
        sql.append("\t) auxva on auxva.FSourceCurrencyID = src.FID                                                    \r\n");
        sql.append("\t                                                                                                \r\n");
        sql.append("where                                                                                               \r\n");
        sql.append("\tand (bal.FEndBalanceFor <> 0 or bal.FEndBalanceLocal <> 0 or act.FCAA is not null)              \r\n");
        sql.append("\tand bal.FOrgUnitID = ?                                                                          \r\n");
        sql.append("\tand bal.FPeriod in ( ? )                                                                      \r\n");
        sql.append("\tand bal.FCurrencyID <> '11111111-1111-1111-1111-111111111111DEB58FDC'\t\t\t\t\t\t\t\r\n");
        sql.append("\tand bal.FCurrencyID <> '22222222-2222-2222-2222-222222222222DEB58FDC'\t\t\t\t\t\t\t\r\n");
        sql.append("\tand bal.FCurrencyID <> ?\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n");
        sql.append("\tand act.FIsLeaf = 1                                                                             \r\n");
        sql.append("\tand act.FIsChangeCurrency = 1     \r\n");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])params);
        return tempateTable;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected ArrayList queryAgeByAcctOnlyUnion(Context ctx, String accountid, String currencyid, int[] days, HashMap hmItems, java.util.Date endDate, boolean includeUnPosted, boolean includeInit, String companyids, int dateType, int indexType, Object accountFrom, Object accountTo, int companyLevel, String curCompanyid, String accountViewNumber, HashMap hmInfo, String acctTableId, boolean isfirstload, boolean includeVerifyVch, boolean isBizCode, String companyId) throws BOSException, EASBizException {
        int i;
        int i2;
        CompanyOrgUnitInfo _company;
        boolean allCurr;
        StringBuffer createTable;
        String tempageTable;
        StringBuffer selecthgoutside;
        boolean general;
        String amountField;
        String loc;
        ArrayList<BalanceInfoByAge> result;
        Map accountParams;
        String bizCodeToNumber;
        String bizCodeFromNumber;
        String accountToNumber;
        String accountFromNumber;
        boolean isAccountNoBC;
        boolean isAccountBC;
        boolean isAccountList;
        String tempTable;
        boolean isIsOnlyUnion;
        String maxChar;
        block178: {
            block181: {
                int _periodNumber;
                PeriodInfo _period;
                int i3;
                Object[] v;
                maxChar = GlUtils.getMaxChar();
                isIsOnlyUnion = GlUtils.isCompanyUnion((CompanyOrgUnitInfo)CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId)));
                tempTable = this.creatAdjexchTempTable(ctx, endDate);
                isAccountList = indexType == 1;
                isAccountBC = !isAccountList && isBizCode;
                isAccountNoBC = isAccountBC && hmItems.size() == 0;
                accountFromNumber = "";
                accountToNumber = "";
                bizCodeFromNumber = null;
                bizCodeToNumber = null;
                if (accountFrom instanceof AccountViewInfo) {
                    accountFromNumber = ((AccountViewInfo)accountFrom).getNumber();
                } else if (accountFrom instanceof Object[]) {
                    v = (Object[])accountFrom;
                    accountFromNumber = "";
                    for (i3 = 0; i3 < v.length; ++i3) {
                        accountFromNumber = accountFromNumber + ((AccountViewInfo)v[i3]).getNumber() + ";";
                    }
                } else {
                    accountFromNumber = (String)accountFrom;
                }
                if (accountTo instanceof AccountViewInfo) {
                    accountToNumber = ((AccountViewInfo)accountTo).getNumber();
                } else if (accountTo instanceof Object[]) {
                    v = (Object[])accountTo;
                    accountToNumber = "";
                    for (i3 = 0; i3 < v.length; ++i3) {
                        accountToNumber = accountToNumber + ((AccountViewInfo)v[i3]).getNumber() + ";";
                    }
                } else {
                    accountToNumber = (String)accountTo;
                }
                accountParams = this.getAccountParam(accountFromNumber, accountToNumber);
                accountFromNumber = (String)accountParams.get("accountFrom");
                accountToNumber = (String)accountParams.get("accountTo");
                endDate = DateTimeUtils.truncateDate((java.util.Date)endDate);
                this.enterDateType(dateType);
                result = new ArrayList<BalanceInfoByAge>();
                loc = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
                amountField = null;
                general = true;
                selecthgoutside = new StringBuffer();
                tempageTable = "AccountAgeFacadeControllerBean";
                createTable = new StringBuffer();
                createTable.append("create table " + tempageTable + " (");
                allCurr = false;
                if (currencyid.equals("all")) {
                    allCurr = true;
                }
                int _periodYear = (_period = PeriodUtils.getPeriodInfo((Context)ctx, (java.util.Date)endDate, (CompanyOrgUnitInfo)(_company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId))))) == null ? endDate.getYear() + 1900 : _period.getPeriodYear();
                int n = _periodNumber = _period == null ? (endDate.getMonth() + 3) / 3 : _period.getPeriodNumber();
                if (acctTableId == null) {
                    acctTableId = AccountTools.getCurrentAcctTable((Context)ctx, (String)_company.getCU().getId().toString(), (String)_company.getAccountTable().getId().toString(), (int)_periodYear, (int)_periodNumber);
                }
                boolean isInTimeVerify = true;
                includeUnPosted = true;
                isInTimeVerify = false;
                if (!includeUnPosted || !isInTimeVerify) break block181;
                amountField = "cussent.funholdedAmtFor";
                if (CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString().equals(currencyid)) {
                    amountField = "cussent.funholdedAmtfor * (case when( " + tempTable + ".FCONVERTRATEA is null ) then 1 else " + tempTable + ".FCONVERTRATEA end )";
                    break block178;
                } else if (CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString().equals(currencyid)) {
                    amountField = "cussent.funholdedAmtRpt";
                    break block178;
                } else {
                    general = false;
                }
                break block178;
            }
            amountField = "cussent.funVerifiedAmtFor";
            if (CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString().equals(currencyid)) {
                amountField = "cussent.funVerifiedAmtFor * (case when( " + tempTable + ".FCONVERTRATEA is null ) then 1 else " + tempTable + ".FCONVERTRATEA end )";
            } else if (CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString().equals(currencyid)) {
                amountField = "cussent.funVerifiedAmtRpt";
            } else {
                general = false;
            }
        }
        if (days == null) return null;
        if (days.length < 1) {
            return null;
        }
        Iterator itemkeyit = hmItems.keySet().iterator();
        if (isBizCode) {
            while (itemkeyit.hasNext()) {
                HashMap item = (HashMap)itemkeyit.next();
                String[] numbers = (String[])hmItems.get(item);
                bizCodeFromNumber = numbers[0];
                bizCodeToNumber = numbers[1];
            }
        }
        if (isAccountBC && hmInfo != null && hmInfo.get("BizCodeNumber") != null) {
            bizCodeToNumber = bizCodeFromNumber = hmInfo.get("BizCodeNumber").toString();
        }
        StringBuffer selecthg = new StringBuffer();
        String accountname = GlUtils.isAccountShowLongName((Context)ctx, (String)_company.getId().toString()) ? "Flongname_" : "Fname_";
        StringBuffer sum = new StringBuffer("0 as leftamount, sum((entry.fentrydc*2-1)*account.fdc*").append(amountField).append(") as sumall");
        StringBuffer initsum = new StringBuffer("0 as leftamount, sum(").append(amountField).append(") as sumall");
        StringBuffer leftsum = new StringBuffer("sum(").append(amountField).append(") as leftamount, 0 as sumall");
        int daylen = days.length;
        ArrayList<Date> alDates = new ArrayList<Date>(daylen * 2);
        Calendar cal = Calendar.getInstance();
        sum.append(" ,sum(case when assist." + this.strDateType + ">? then (entry.fentrydc*2-1)*account.fdc*").append(amountField).append(" else 0 end) as sum0");
        initsum.append(" ,sum(case when assist." + this.strDateType + ">? then ").append(amountField).append(" else 0 end) as sum0");
        leftsum.append(" ,0 as sum0");
        cal.setTime(endDate);
        cal.add(14, -1);
        cal.add(5, -1 * days[0]);
        alDates.add(new Date(cal.getTimeInMillis()));
        for (int i4 = 1; i4 < daylen; ++i4) {
            sum.append(" ,sum(case when assist." + this.strDateType + "<=? and assist." + this.strDateType + ">? then (entry.fentrydc*2-1)*account.fdc*").append(amountField).append(" else 0 end) as sum").append(i4);
            initsum.append(" ,sum(case when assist." + this.strDateType + "<=? and assist." + this.strDateType + ">? then ").append(amountField).append(" else 0 end) as sum").append(i4);
            leftsum.append(" ,0 as sum").append(i4);
            cal.setTime(endDate);
            cal.add(14, -1);
            cal.add(5, -1 * days[i4 - 1]);
            alDates.add(new Date(cal.getTimeInMillis()));
            cal.setTime(endDate);
            cal.add(14, -1);
            cal.add(5, -1 * days[i4]);
            alDates.add(new Date(cal.getTimeInMillis()));
        }
        sum.append(" ,sum(case when assist." + this.strDateType + "<=? then (entry.fentrydc*2-1)*account.fdc*").append(amountField).append(" else 0 end) as sum").append(daylen);
        initsum.append(" ,sum(case when assist." + this.strDateType + "<=? then ").append(amountField).append(" else 0 end) as sum").append(daylen);
        leftsum.append(" ,0 as sum").append(daylen);
        cal.setTime(endDate);
        cal.add(14, -1);
        cal.add(5, -1 * days[daylen - 1]);
        alDates.add(new Date(cal.getTimeInMillis()));
        StringBuffer from = new StringBuffer();
        StringBuffer initFrom = new StringBuffer();
        StringBuffer leftFrom = new StringBuffer();
        from.append(" from t_gl_voucherassistrecord assist \r\n join t_gl_acctcussent cussent on cussent.fvchassistrecordid=assist.fid \r\n join t_gl_voucherentry entry on assist.fentryid=entry.fid");
        from.append("  \r\n join t_gl_voucher voucher on entry.fbillid=voucher.fid \r\n join t_bd_accountview account on cussent.faccountid=account.fid ");
        if (isIsOnlyUnion) {
            from.append(" \r\n inner join t_org_company company on cussent.fcompanyid = company.fid ");
            from.append(" \r\n inner join t_org_company sumcompany on charindex(sumcompany.FLongNumber ||'!',company.FLongNumber || '!') = 1");
            if (accountViewNumber != null) {
                from.append(" \r\n inner join T_bd_accountview acctview on acctview.fid = cussent.FAccountID ");
            }
        }
        from.append(" \r\n join t_bd_Currency currency on entry.fcurrencyid=currency.fid");
        from.append(" left join " + tempTable + " on " + tempTable + ".fid = currency.fid ");
        from.append(" \r\n join t_bd_assistanthg hg on assist.fassgrpid=hg.fid ");
        if (isBizCode && isAccountList) {
            from.append("\r\n inner join ").append(this.queryBizCodeHgid(ctx, accountid, bizCodeFromNumber, bizCodeToNumber, true, companyids)).append(" on hg.fid = T_Hgid.fid ");
        }
        if (isAccountBC && !isAccountNoBC) {
            from.append("\r\n inner join ").append(this.queryBizCodeHgid(ctx, accountid, bizCodeFromNumber, bizCodeToNumber, true, companyids)).append(" on hg.fid = T_Hgid.fid ");
        }
        initFrom.append(" \r\n from t_gl_voucherassistrecord assist \r\n join t_gl_acctcussent cussent on cussent.fvchassistrecordid = assist.fid ");
        if (isIsOnlyUnion) {
            initFrom.append(" \r\n inner join t_org_company company on cussent.fcompanyid = company.fid ");
            initFrom.append(" \r\n inner join t_org_company sumcompany on charindex(sumcompany.FLongNumber ||'!',company.FLongNumber || '!') = 1");
            if (accountViewNumber != null) {
                initFrom.append(" \r\n inner join T_bd_accountview acctview on acctview.fid = cussent.FAccountID ");
            }
        }
        initFrom.append(" \r\n join t_bd_Currency currency on cussent.fcurrencyid = currency.fid");
        initFrom.append(" left join " + tempTable + " on " + tempTable + ".fid = currency.fid ");
        initFrom.append(" \r\n join t_bd_assistanthg hg on assist.fassgrpid = hg.fid");
        if (isBizCode && isAccountList) {
            initFrom.append("\r\n  join ").append(this.queryBizCodeHgid(ctx, accountid, bizCodeFromNumber, bizCodeToNumber, true, companyids)).append(" on hg.fid = T_Hgid.fid ");
        }
        if (isAccountBC && !isAccountNoBC) {
            initFrom.append("\r\n  join ").append(this.queryBizCodeHgid(ctx, accountid, bizCodeFromNumber, bizCodeToNumber, true, companyids)).append(" on hg.fid = T_Hgid.fid ");
        }
        initFrom.append(" \r\n join t_bd_accountview account on cussent.faccountid=account.fid ");
        leftFrom.append(" \r\n from t_gl_voucherassistrecord assist \r\n inner join t_gl_acctcussent cussent on assist.fid=cussent.fvchassistrecordid ");
        if (isIsOnlyUnion) {
            leftFrom.append(" \r\n inner join t_org_company company on cussent.fcompanyid = company.fid ");
            leftFrom.append(" \r\n inner join t_org_company sumcompany on charindex(sumcompany.FLongNumber ||'!',company.FLongNumber || '!') = 1");
            if (accountViewNumber != null) {
                leftFrom.append(" \r\n inner join T_bd_accountview acctview on acctview.fid = cussent.FAccountID ");
            }
        }
        leftFrom.append(" \r\n inner join t_bd_Currency currency on currency.fid = cussent.fcurrencyid \r\n inner join t_bd_assistanthg hg on assist.fassgrpid=hg.fid ");
        if (isBizCode && isAccountList) {
            leftFrom.append("\r\n inner join ").append(this.queryBizCodeHgid(ctx, accountid, bizCodeFromNumber, bizCodeToNumber, true, companyids)).append(" on hg.fid = T_Hgid.fid ");
        }
        if (isAccountBC && !isAccountNoBC) {
            leftFrom.append("\r\n inner join ").append(this.queryBizCodeHgid(ctx, accountid, bizCodeFromNumber, bizCodeToNumber, true, companyids)).append(" on hg.fid = T_Hgid.fid ");
        }
        leftFrom.append(" left join " + tempTable + " on " + tempTable + ".fid = currency.fid ");
        leftFrom.append(" \r\n left outer join t_gl_voucher voucher on voucher.fid = assist.fbillid ");
        leftFrom.append(" \r\n join t_bd_accountview account on cussent.faccountid=account.fid ");
        StringBuffer innerJoin = new StringBuffer();
        StringBuffer groupby = new StringBuffer();
        int gi = 0;
        ArrayList<String> alNumbers = new ArrayList<String>();
        ArrayList<String> alTables = new ArrayList<String>();
        ArrayList<String> alFields = new ArrayList<String>();
        int tablei = 0;
        if (isAccountList) {
            groupby.append(" group by ");
            groupby.append("account.FID ,account.Fnumber ,account.").append(accountname).append(loc);
        }
        if (isAccountBC && !isAccountNoBC) {
            groupby.append(" group by ");
            groupby.append("bacid ").append(",bacnumber , bacname");
        }
        if (!isBizCode) {
            HashMap<String, Object> hmParamIn = new HashMap<String, Object>();
            hmParamIn.put("GL_064", null);
            HashMap hmAllParam = ParamControlFactory.getLocalInstance((Context)ctx).getParamHashMap(hmParamIn);
            Object isShowLongNumberObj = hmAllParam.get("GL_064");
            boolean isShowLongNumber = false;
            if (isShowLongNumberObj != null) {
                isShowLongNumber = Boolean.valueOf(isShowLongNumberObj.toString());
            }
            HashMap[] itemList = new HashMap[hmItems.keySet().size()];
            int k = 0;
            while (itemkeyit.hasNext()) {
                HashMap item = (HashMap)itemkeyit.next();
                Integer seq = (Integer)item.get("seq");
                if (seq != null) {
                    itemList[seq.intValue()] = item;
                } else {
                    itemList[k] = item;
                }
                ++k;
            }
            for (int i5 = 0; i5 < itemList.length; ++tablei, ++gi, ++i5) {
                HashMap item = itemList[i5];
                String[] numbers = (String[])hmItems.get(item);
                String table = (String)item.get("tablename");
                String field = (String)item.get("fieldname");
                boolean isGeneralActType = item.get("FGLAsstActTypeGrpID") != null && item.get("propname").toString().startsWith("generalAssActType");
                boolean isUseLongNumber = (Boolean)item.get("useLongNUmber");
                alTables.add(table);
                alFields.add(field);
                innerJoin.append(" inner join ").append(table).append(" ").append("T").append(tablei).append(" on hg.").append(field).append("=").append("T").append(tablei).append(".fid");
                if (hmInfo != null && hmInfo.get(field) != null) {
                    innerJoin.append(" and hg.").append(field).append(" = '").append(hmInfo.get(field).toString()).append("' ");
                }
                if (numbers[0] != null) {
                    innerJoin.append(" and ").append("T").append(tablei);
                    if (!isGeneralActType || !isUseLongNumber) {
                        innerJoin.append(".fnumber>=?");
                        alNumbers.add(numbers[0]);
                    } else {
                        innerJoin.append(".flongnumber>=?");
                        alNumbers.add(numbers[0].replace('.', '!'));
                    }
                }
                if (numbers[1] != null) {
                    innerJoin.append(" and ").append("T").append(tablei);
                    if (!isGeneralActType || !isUseLongNumber) {
                        innerJoin.append(".fnumber<=?");
                        alNumbers.add(numbers[1]);
                    } else {
                        innerJoin.append(".flongnumber<=?");
                        alNumbers.add(numbers[1].replace('.', '!'));
                    }
                }
                if (!isAccountList) {
                    if (gi == 0) {
                        groupby.append(" group by ");
                    } else {
                        groupby.append(" ,");
                    }
                    selecthg.append("hg.").append(field).append(" as ").append("T").append(tablei).append(field).append(",");
                    groupby.append("hg.").append(field).append(",");
                    if (isShowLongNumber && item.get("propname") != null && item.get("propname").toString().startsWith("general")) {
                        selecthg.append("replace(T").append(tablei).append(".flongnumber,'!','.') as ").append("T").append(tablei).append("fnumber,");
                        groupby.append("T").append(tablei).append(".flongnumber,");
                    } else {
                        selecthg.append("T").append(tablei).append(".fnumber as ").append("T").append(tablei).append("fnumber,");
                        groupby.append("T").append(tablei).append(".fnumber,");
                    }
                    selecthg.append("T").append(tablei).append(".fname_").append(loc).append(" as ").append("T").append(tablei).append("fname,");
                    groupby.append("T").append(tablei).append(".fname_").append(loc);
                    selecthgoutside.append("T").append(tablei).append(field).append(",T").append(tablei).append("fnumber,").append("T").append(tablei).append("fname,");
                    createTable.append("T").append(tablei).append(field).append(" varchar(44),").append("T").append(tablei).append("fnumber varchar(44),").append("T").append(tablei).append("fname nvarchar(80),");
                    continue;
                }
                if (tablei != 0) continue;
                selecthgoutside.append("T").append(tablei).append(field).append(",");
                selecthgoutside.append("T").append(tablei).append("fnumber,");
                selecthgoutside.append("T").append(tablei).append("fname,");
                createTable.append("T").append(tablei).append(field).append(" varchar(44),").append("T").append(tablei).append("fnumber varchar(44),").append("T").append(tablei).append("fname nvarchar(80),");
                selecthg.append("' ' as T0").append(field).append(",account.Fnumber as T0fnumber,account.").append(accountname).append(loc).append(" as T0fname,");
            }
        } else if (!isAccountBC) {
            selecthgoutside.append("Taccountid").append(",T0fnumber").append(",T0fname,");
            selecthg.append("account.FID as Taccountid").append(",account.Fnumber as T0fnumber,account.").append(accountname).append(loc).append(" as T0fname,");
            createTable.append("Taccountid").append(" varchar(44),").append("T0fnumber varchar(44),").append("T0fname nvarchar(80),");
        } else if (!isAccountNoBC) {
            selecthgoutside.append("Taccountid").append(",T0fnumber").append(",T0fname,");
            selecthg.append("T_Hgid.bacid as Taccountid").append(",T_Hgid.bacnumber as T0fnumber, T_Hgid.bacname as T0fname,");
            createTable.append("Taccountid").append(" varchar(44),").append("T0fnumber varchar(44),").append("T0fname nvarchar(80),");
        }
        if (allCurr) {
            selecthg.append("currency.fid fcurrid,currency.Fname_" + loc + " fcurrname,");
        } else {
            ICurrency icurrency = CurrencyFactory.getLocalInstance((Context)ctx);
            CurrencyInfo currency = icurrency.getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyid));
            selecthg.append("'" + currency.getId() + "' fcurrid,'" + currency.getName() + "' fcurrname,");
        }
        if (isIsOnlyUnion) {
            selecthg.append(" sumcompany.fid  fsumcompanyid,sumcompany.FLONGNUMBER fsumcompanynumber,sumcompany.Fname_" + loc + " fsumcompanyname,sumcompany.flevel fsumcompanylevel,sumcompany.fisleaf fsumcompanyisleaf, ");
            selecthgoutside.append("fcurrid,fcurrname,fsumcompanynumber,fsumcompanyid,fsumcompanyname,fsumcompanylevel,fsumcompanyisleaf,");
        } else {
            selecthgoutside.append("fcurrid,fcurrname,");
        }
        if (isAccountList) {
            if (isBizCode) {
                selecthg.append("T_Hgid.bacid as hgid,");
            } else {
                selecthg.append("hg.FID as hgid,");
            }
            selecthgoutside.append("hgid,");
        }
        selecthg.append("account.fid as acct_id,account.fnumber as acct_number,");
        selecthgoutside.append("acct_id,acct_number,");
        StringBuffer where = new StringBuffer();
        StringBuffer initWhere = new StringBuffer();
        StringBuffer leftWhere = new StringBuffer();
        where.append(" where assist." + this.strDateType + "<? ");
        where.append(" and cussent.fisinit<>1 ");
        if (isAccountList) {
            where.append(" and account.FAccountTableID='" + acctTableId + "' ");
            if (isBizCode) {
                // empty if block
            }
        } else if (accountViewNumber == null) {
            where.append(" and cussent.faccountid=? ");
        } else {
            where.append(" and acctview.fnumber = '").append(accountViewNumber).append("' ");
        }
        if (isIsOnlyUnion) {
            if (accountViewNumber != null) {
                where.append(" and acctview.FACCOUNTTABLEID = '").append(acctTableId).append("' ");
                where.append(" and acctview.fcompanyid = cussent.fcompanyid");
            }
            where.append(" \r\n and company.fid in ( ").append(companyids).append(" ) and sumcompany");
            if (isfirstload) {
                where.append(".fid in (");
            } else {
                where.append(".fparentid in (");
            }
            where.append(curCompanyid).append(" )");
        } else {
            where.append(" and cussent.fcompanyid=? ");
        }
        if (!includeUnPosted) {
            where.append("and voucher.FBizStatus=5");
        } else {
            where.append(" and voucher.fbizstatus <> 0 and voucher.fbizstatus<>2 ");
        }
        where.append(" and voucher.fperiodid in (select fperiodid from v_gl_acperiod where fcompanyid=voucher.fcompanyid) ");
        if (!general && !allCurr) {
            where.append(" and entry.fcurrencyid=? ");
        }
        if (isAccountList) {
            this.buildAccountSql(where, accountParams, "account.fnumber");
        }
        initWhere.append(" where  assist." + this.strDateType + "<? ");
        initWhere.append(" and assist.fentryid is null and cussent.fisinit=1 and cussent.fisinitclosed=1");
        if (isAccountList) {
            initWhere.append(" and account.FAccountTableID='" + acctTableId + "' ");
            if (isBizCode) {
                // empty if block
            }
        } else if (accountViewNumber == null) {
            initWhere.append(" and cussent.faccountid=? ");
        } else {
            initWhere.append(" and acctview.fnumber = '").append(accountViewNumber).append("' ");
        }
        if (isIsOnlyUnion) {
            if (accountViewNumber != null) {
                initWhere.append(" and acctview.FACCOUNTTABLEID = '").append(acctTableId).append("' ");
                initWhere.append(" and acctview.fcompanyid = cussent.fcompanyid");
            }
            initWhere.append(" \r\n and company.fid in ( ").append(companyids).append(" ) and sumcompany");
            if (isfirstload) {
                initWhere.append(".fid in (");
            } else {
                initWhere.append(".fparentid in (");
            }
            initWhere.append(curCompanyid).append(")");
        } else {
            initWhere.append(" and cussent.fcompanyid=?  ");
        }
        if (!general && !allCurr) {
            initWhere.append(" and cussent.fcurrencyid=? ");
        }
        if (isAccountList) {
            this.buildAccountSql(initWhere, accountParams, "account.fnumber");
        }
        leftWhere.append(" where 1=1 ");
        if (!includeInit) {
            leftWhere.append(" and cussent.fisinit<>1");
            if (!includeUnPosted) {
                leftWhere.append(" and voucher.FBizStatus=5");
            } else {
                leftWhere.append(" and voucher.fbizstatus <> 0 and voucher.fbizstatus<>2 ");
            }
            leftWhere.append(" and voucher.fperiodid in (select fperiodid from v_gl_acperiod where fcompanyid=voucher.fcompanyid) ");
        } else {
            leftWhere.append(" and (cussent.fisinit<>1 ");
            if (!includeUnPosted) {
                leftWhere.append(" and voucher.FBizStatus=5 ");
            } else {
                leftWhere.append(" and voucher.fbizstatus <> 0 and voucher.fbizstatus<>2 ");
            }
            leftWhere.append(" and voucher.fperiodid in (select fperiodid from v_gl_acperiod where fcompanyid=voucher.fcompanyid) ");
            leftWhere.append(" or voucher.fid is null and cussent.fisinit=1 and cussent.fisinitclosed=1)");
        }
        if (isAccountList) {
            if (isBizCode) {
                leftWhere.append(" and account.FAccountTableID='" + acctTableId + "' ");
            } else {
                leftWhere.append(" /*and hg.FID in (" + accountid + ")*/ and account.FAccountTableID='" + acctTableId + "' ");
            }
        } else if (accountViewNumber == null) {
            leftWhere.append(" and cussent.faccountid=? ");
        } else {
            leftWhere.append(" and acctview.fnumber = '").append(accountViewNumber).append("' ");
        }
        if (isIsOnlyUnion) {
            if (accountViewNumber != null) {
                leftWhere.append(" and acctview.FACCOUNTTABLEID = '").append(acctTableId).append("' ");
                leftWhere.append(" and acctview.fcompanyid = cussent.fcompanyid");
            }
            leftWhere.append(" \r\n and company.fid in ( ").append(companyids).append(" ) and sumcompany");
            if (isfirstload) {
                leftWhere.append(".fid in (");
            } else {
                leftWhere.append(".fparentid in (");
            }
            leftWhere.append(curCompanyid).append(") ");
        } else {
            leftWhere.append(" and cussent.fcompanyid=?  ");
        }
        if (!general && !allCurr) {
            leftWhere.append(" and cussent.fcurrencyid=? ");
        }
        if (isAccountList) {
            this.buildAccountSql(leftWhere, accountParams, "account.fnumber");
        }
        StringBuffer merge = new StringBuffer().append(selecthgoutside);
        merge.append(" leftamount as sumall");
        merge.append(",leftamount-(sum0");
        for (int i22 = 1; i22 <= daylen; ++i22) {
            merge.append("+sum" + i22);
        }
        merge.append(") sumunoverdue");
        merge.append(",sum0");
        for (i2 = 1; i2 <= daylen; ++i2) {
            merge.append("+sum" + i2);
        }
        merge.append(" sumoverdue,sum0");
        for (i2 = 1; i2 <= daylen; ++i2) {
            merge.append(",sum" + i2);
        }
        merge.append(" from ");
        if (allCurr) {
            groupby.append(",currency.fid, currency.Fname_" + loc);
        }
        if (isIsOnlyUnion) {
            groupby.append(", sumcompany.flongnumber, sumcompany.fid  ,sumcompany.Fname_" + loc + " ,sumcompany.flevel ,sumcompany.fisleaf  ");
        }
        if (isAccountList) {
            groupby.append(",hg.fid");
        }
        if (groupby.toString().trim().startsWith(",")) {
            groupby = new StringBuffer(" group by ").append(groupby.substring(groupby.indexOf(",") + 1));
        }
        StringBuffer sql1 = new StringBuffer();
        StringBuffer sql2 = new StringBuffer();
        StringBuffer sql3 = new StringBuffer();
        sql1.append("select ").append(selecthg).append(sum).append(from).append(innerJoin).append(where).append(groupby);
        sql2.append("select ").append(selecthg).append(initsum).append(initFrom).append(innerJoin).append(initWhere).append(groupby);
        sql3.append("select ").append(selecthg).append(leftsum).append(leftFrom).append(innerJoin).append(leftWhere).append(groupby);
        StringBuffer includeVerifyVoucher = includeVerifyVch ? this.queryVerifyVoucherOnlyUnion(ctx, allCurr, days, isAccountList, accountid, acctTableId, accountParams, selecthg, innerJoin, groupby, curCompanyid, isfirstload, companyids, accountViewNumber, tempTable, currencyid, isBizCode, isAccountBC, bizCodeFromNumber, bizCodeToNumber) : new StringBuffer();
        sum = new StringBuffer();
        selecthg = new StringBuffer();
        groupby = new StringBuffer();
        StringBuffer orderby = new StringBuffer();
        sum.append("sum(leftamount) as leftamount ,sum(sumall) as sumall");
        String _whereCause = "t.sum0";
        for (i = 0; i < daylen + 1; ++i) {
            sum.append(",sum(sum" + i + ") as sum" + i);
            if (i == 0) continue;
            _whereCause = _whereCause + "+t.sum" + i;
        }
        for (i = 0; i < alTables.size(); ++i) {
            String numkey = "T" + i + "fnumber";
            String namekey = "T" + i + "fname";
            selecthg.append(",").append(numkey);
            selecthg.append(",").append(namekey);
            groupby.append(",").append(numkey);
            groupby.append(",").append(namekey);
            if (isAccountList && i != 0) continue;
            orderby.append(numkey).append(",");
            orderby.append(namekey).append(",");
        }
        if (groupby.length() > 0) {
            groupby = new StringBuffer(" group by ").append(selecthgoutside.deleteCharAt(selecthgoutside.length() - 1));
        }
        if (selecthgoutside.toString().endsWith(",")) {
            int delimiterIdx = selecthgoutside.lastIndexOf(",");
            selecthgoutside = new StringBuffer(selecthgoutside.toString().substring(0, delimiterIdx));
        }
        if (!includeInit) {
            merge.append("(select ").append(sum).append(",").append(selecthgoutside).append(" from (").append(sql1).append(" union all ").append(sql3).append(includeVerifyVoucher).append(") t  group by " + selecthgoutside + ") ");
        } else {
            merge.append("(select ").append(sum).append(",").append(selecthgoutside).append(" from (").append(sql1).append(" union all ").append(sql2).append(" union all ").append(sql3).append(includeVerifyVoucher).append(") t  group by " + selecthgoutside + ") ");
        }
        merge.append(" tempa");
        BigDecimal zero = new BigDecimal("0");
        Connection con = null;
        PreparedStatement ps = null;
        IRowSet rs = null;
        SqlParams spp = new SqlParams();
        ArrayList params = new ArrayList();
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        try {
            createTable.append(" FCURRID varchar(44),");
            createTable.append(" FCURRNAME   nvarchar(80),");
            createTable.append(" FSUMCOMPANYNUMBER nvarchar(255),");
            createTable.append(" FSUMCOMPANYID   nvarchar(44),");
            createTable.append(" FSUMCOMPANYNAME nvarchar(255),");
            createTable.append(" FSUMCOMPANYLEVEL    INT,");
            createTable.append(" FSUMCOMPANYISLEAF   INT,");
            createTable.append(" HGID varchar(44),");
            createTable.append(" acct_id varchar(44),acct_number nvarchar(44), ");
            createTable.append(" SUMALL  decimal(28,10),");
            createTable.append(" SUMUNOVERDUE    decimal(28,10),");
            createTable.append(" SUMOVERDUE  decimal(28,10), ");
            for (int i6 = 0; i6 <= daylen; ++i6) {
                if (i6 == daylen) {
                    createTable.append(" SUM" + i6 + "    decimal(28,10) ");
                    continue;
                }
                createTable.append(" SUM" + i6 + "    decimal(28,10),");
            }
            createTable.append(" )");
            try {
                tempageTable = pool.createTempTable(createTable.toString());
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
            merge = new StringBuffer().append("insert into " + tempageTable + " select ").append(merge);
            con = GetConnection.exec(ctx);
            ps = con.prepareStatement(merge.toString());
            int index = 1;
            boolean setCurrency = !general && !allCurr;
            index = this.setupParams(false, accountid, currencyid, endDate, null, isAccountList, accountFromNumber, accountToNumber, setCurrency, alDates, cal, alNumbers, ps, params, index, accountViewNumber, spp);
            if (includeInit) {
                index = this.setupParams(true, accountid, currencyid, endDate, null, isAccountList, accountFromNumber, accountToNumber, setCurrency, alDates, cal, alNumbers, ps, params, index, accountViewNumber, spp);
            }
            index = this.setupLeftParam(accountid, currencyid, null, isAccountList, accountFromNumber, accountToNumber, setCurrency, alNumbers, ps, params, index, accountViewNumber, spp);
            if (includeVerifyVch) {
                index = this.setupParams(false, accountid, currencyid, endDate, null, isAccountList, accountFromNumber, accountToNumber, setCurrency, alDates, cal, alNumbers, ps, params, index, accountViewNumber, spp);
                index = this.setupLeftParam(accountid, currencyid, null, isAccountList, accountFromNumber, accountToNumber, setCurrency, alNumbers, ps, params, index, accountViewNumber, spp);
            }
            LowTimer low = new LowTimer();
            low.reset();
            DbUtil.execute((Context)ctx, (String)merge.toString(), (Object[])params.toArray());
            if (this.debugModel != null && this.debugModel.meet()) {
                this.debugModel.record(merge.toString(), params.toArray());
            }
            StringBuffer totalSum = new StringBuffer();
            totalSum.append(" insert into ").append(tempageTable).append("\r\n");
            if (isIsOnlyUnion) {
                totalSum.append("select  top 1 * from(");
            }
            totalSum.append(" select  ");
            for (int i7 = 0; i7 < alFields.size(); ++i7) {
                totalSum.append(" '").append(maxChar).append("' ");
                totalSum.append("T" + i7 + alFields.get(i7).toString());
                totalSum.append(",");
                totalSum.append(" N'").append(maxChar).append("' ");
                totalSum.append("T" + i7 + "fnumber ");
                totalSum.append(",");
                totalSum.append(" N'").append(maxChar).append("' ");
                totalSum.append("T" + i7 + "fname ");
                totalSum.append(",");
                if (isAccountList) break;
            }
            if (isAccountBC && !isAccountNoBC) {
                totalSum.append(" '").append(maxChar).append("' ");
                totalSum.append("Taccountid");
                totalSum.append(",");
                totalSum.append(" N'").append(maxChar).append("' ");
                totalSum.append("T0fnumber ");
                totalSum.append(",");
                totalSum.append(" N'").append(maxChar).append("' ");
                totalSum.append("T0fname ");
                totalSum.append(",");
            }
            if (isIsOnlyUnion) {
                totalSum.append(" '").append(maxChar).append("' fcurrid, '' fcurrname,N'' fsumcompanynumber,'' fsumcompanyid,N'' fsumcompanyname,to_integer(null) fsumcompanylevel,to_integer(null) fsumcompanyisleaf, ");
            } else {
                totalSum.append(" '").append(maxChar).append("' fcurrid, '' fcurrname, ");
            }
            StringBuffer _tempSum = new StringBuffer("sum(sum1) sum1");
            for (int i8 = 1; i8 < daylen; ++i8) {
                _tempSum.append(",sum(sum" + (i8 + 1) + ") as sum" + (i8 + 1));
            }
            totalSum.append("sum(sumall) sumall,sum(sumunoverdue) sumunoverdue,sum(sumoverdue) sumoverdue,sum(sum0) sum0," + _tempSum + " from ");
            totalSum.append(tempageTable);
            if (isIsOnlyUnion) {
                totalSum.append(" group by fcurrid, fcurrname,fsumcompanynumber,fsumcompanyid,fsumcompanyname,fsumcompanylevel,fsumcompanyisleaf ) sumtable");
            } else {
                totalSum.append("  group by fcurrid, fcurrname ");
            }
            if (!isAccountList && !allCurr) {
                DBUtil.execute((String)totalSum.toString(), (Connection)con);
                if (this.debugModel != null && this.debugModel.meet()) {
                    this.debugModel.record(totalSum.toString(), new Object[0]);
                }
            }
            orderby = new StringBuffer(" order by ").append(orderby);
            if ((isAccountBC || isBizCode) && !isAccountNoBC) {
                orderby.append(" T0fnumber,");
            }
            orderby.append(" fcurrid,fsumcompanynumber");
            StringBuffer resultsql = new StringBuffer();
            resultsql.append(" select * from ").append(tempageTable).append(" ").append(orderby);
            rs = DbUtil.executeQuery((Context)ctx, (String)resultsql.toString());
            if (this.debugModel != null && this.debugModel.meet()) {
                this.debugModel.record(resultsql.toString(), new Object[0]);
            }
            String curreName = "";
            while (rs.next()) {
                int length;
                ArrayList<Object> line = new ArrayList<Object>();
                BalanceInfoByAge balance = new BalanceInfoByAge();
                int size = alTables.size();
                if (isAccountList && !isBizCode) {
                    size = 1;
                } else if (isBizCode && !hmItems.isEmpty()) {
                    if (rs.getString("fcurrid").equals(maxChar)) {
                        line.add(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"35_RptAsstactGGUI", (Locale)ctx.getLocale()));
                    } else {
                        line.add(rs.getString("T0fnumber") + this.strSeperatorNumName + rs.getString("T0fname"));
                    }
                }
                for (int i10 = 0; i10 < size; ++i10) {
                    String numkey = "T" + i10 + "fnumber";
                    String namekey = "T" + i10 + "fname";
                    if (!rs.getString("fcurrid").equals(maxChar)) continue;
                    line.add(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"35_RptAsstactGGUI", (Locale)ctx.getLocale()));
                }
                if (rs.getString("fcurrname") == null || rs.getString("fcurrname").length() == 0) {
                    if (hmItems.size() == 0 || isAccountBC) {
                        line.add(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"35_RptAsstactGGUI", (Locale)ctx.getLocale()));
                    } else {
                        line.add(curreName);
                    }
                } else {
                    curreName = rs.getString("fcurrname");
                    line.add(curreName);
                }
                if (isIsOnlyUnion) {
                    line.add(rs.getString("fsumcompanyname"));
                }
                line.add(rs.getBigDecimal("sumall"));
                balance.setBalance(rs.getBigDecimal("sumall"));
                line.add(rs.getBigDecimal("sumunoverdue"));
                balance.setUnOverDueBalance(rs.getBigDecimal("sumunoverdue"));
                BigDecimal sumoverdue = rs.getBigDecimal("sumoverdue");
                line.add(sumoverdue);
                balance.setOverDueBalance(sumoverdue);
                BigDecimal[] itemBigdecimal = new BigDecimal[daylen + 1];
                for (int i9 = 0; i9 < daylen + 1; ++i9) {
                    itemBigdecimal[i9] = rs.getBigDecimal("sum" + i9);
                }
                int i4 = 0;
                int innerlength = length = itemBigdecimal.length;
                while (i4 < length) {
                    innerlength = length - 1;
                    BigDecimal tempate = itemBigdecimal[length - 1];
                    if (sumoverdue != null && tempate != null && tempate.compareTo(zero) != 0) {
                        for (int j = 0; j < innerlength; ++j) {
                            itemBigdecimal[length - 1] = j == 0 ? sumoverdue.subtract(itemBigdecimal[j]) : itemBigdecimal[length - 1].subtract(itemBigdecimal[j]);
                        }
                        break;
                    }
                    --length;
                }
                length = itemBigdecimal.length;
                for (int i5 = 0; i5 < length; ++i5) {
                    line.add(itemBigdecimal[i5]);
                }
                balance.setAgeBalances(itemBigdecimal);
                if (isIsOnlyUnion) {
                    HashMap<String, String> otherInfo = new HashMap<String, String>();
                    CompanyOrgUnitInfo companyUnit = new CompanyOrgUnitInfo();
                    companyUnit.put("id", (Object)rs.getString("fsumcompanyid"));
                    companyUnit.put("level", (Object)rs.getString("fsumcompanylevel"));
                    companyUnit.put("isleaf", (Object)rs.getString("fsumcompanyisleaf"));
                    companyUnit.put("name", (Object)rs.getString("fsumcompanyname"));
                    if (isAccountBC && !isAccountNoBC) {
                        otherInfo.put("BizCodeNumber", rs.getString("T0fnumber"));
                    } else if (isBizCode && !isAccountNoBC) {
                        otherInfo.put("accountViewNumber", rs.getString("T0fnumber"));
                    }
                    if (!rs.getString("fcurrid").equals(maxChar)) {
                        otherInfo.put("currencyid", rs.getString("fcurrid").toString());
                    }
                    companyUnit.put("otherInfo", otherInfo);
                    line.add(companyUnit);
                }
                if (isAccountList) {
                    line.add(rs.getString("hgid"));
                    balance.setCurrentHG(rs.getString("hgid"));
                }
                try {
                    line.add(rs.getString("acct_id"));
                    line.add(rs.getString("acct_number"));
                    balance.setAcctId(rs.getString("acct_id"));
                    balance.setAcctNumber(rs.getString("acct_number"));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                balance.setAgeArea(days);
                result.add(balance);
            }
            System.out.println("msg1: " + low.msValue());
            low.reset();
        }
        catch (SQLException sqle) {
            try {
                throw new SQLAccessException(sqle);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, con);
                try {
                    pool.releaseTable(tempageTable);
                    throw throwable;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)con);
        try {
            pool.releaseTable(tempageTable);
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            return result;
        }
    }

    private String getDay(java.util.Date day) {
        return "TO_DATE('" + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(day) + "')";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected ArrayList queryAgeByAcct(Context ctx, String accountid, String currencyid, int[] days, HashMap hmItems, java.util.Date endDate, boolean includeUnPosted, boolean includeInit, String companyid, int dateType, int indexType, Object accountFrom, Object accountTo, boolean includeVerifyVch, boolean isBizCode, java.util.Date hisUtilDay) throws BOSException, EASBizException {
        String maxChar = GlUtils.getMaxChar();
        ArrayList<BalanceInfoByAge> result = new ArrayList<BalanceInfoByAge>();
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        String tempTable = null;
        StringBuffer totalSum = new StringBuffer();
        String historyTempateTable = null;
        try {
            int i;
            int i2;
            boolean isInTimeVerify;
            String acctTableId;
            CompanyOrgUnitInfo _company;
            boolean allCurr;
            StringBuffer selecthgoutside;
            boolean general;
            String amountField;
            String loc;
            Map accountParams;
            String accountname;
            String bizCodeToNumber;
            String bizCodeFromNumber;
            String accountToNumber;
            String accountFromNumber;
            boolean isAccountNoBC;
            boolean isAccountBC;
            boolean isAccountList;
            block155: {
                block161: {
                    int i3;
                    Object[] v;
                    tempTable = this.creatAdjexchTempTable(ctx, endDate);
                    isAccountList = indexType == 1;
                    isAccountBC = !isAccountList && isBizCode;
                    isAccountNoBC = isAccountBC && hmItems.size() == 0;
                    accountFromNumber = "";
                    accountToNumber = "";
                    bizCodeFromNumber = null;
                    bizCodeToNumber = null;
                    String string = accountname = GlUtils.isAccountShowLongName((Context)ctx, (String)companyid) ? "Flongname_" : "Fname_";
                    if (accountFrom instanceof AccountViewInfo) {
                        accountFromNumber = ((AccountViewInfo)accountFrom).getNumber();
                    } else if (accountFrom instanceof Object[]) {
                        v = (Object[])accountFrom;
                        accountFromNumber = "";
                        for (i3 = 0; i3 < v.length; ++i3) {
                            accountFromNumber = accountFromNumber + ((AccountViewInfo)v[i3]).getNumber() + ";";
                        }
                    } else {
                        accountFromNumber = (String)accountFrom;
                    }
                    if (accountTo instanceof AccountViewInfo) {
                        accountToNumber = ((AccountViewInfo)accountTo).getNumber();
                    } else if (accountTo instanceof Object[]) {
                        v = (Object[])accountTo;
                        accountToNumber = "";
                        for (i3 = 0; i3 < v.length; ++i3) {
                            accountToNumber = accountToNumber + ((AccountViewInfo)v[i3]).getNumber() + ";";
                        }
                    } else {
                        accountToNumber = (String)accountTo;
                    }
                    accountParams = this.getAccountParam(accountFromNumber, accountToNumber);
                    accountFromNumber = (String)accountParams.get("accountFrom");
                    accountToNumber = (String)accountParams.get("accountTo");
                    endDate = DateTimeUtils.truncateDate((java.util.Date)endDate);
                    this.enterDateType(dateType);
                    loc = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
                    amountField = null;
                    general = true;
                    selecthgoutside = new StringBuffer();
                    allCurr = false;
                    if (currencyid.equals("all")) {
                        allCurr = true;
                    }
                    _company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyid));
                    acctTableId = null;
                    if (hisUtilDay == null) {
                        acctTableId = _company.getAccountTable().getId().toString();
                    } else {
                        PeriodInfo _period = PeriodUtils.getPeriodInfo((Context)ctx, (java.util.Date)hisUtilDay, (CompanyOrgUnitInfo)_company);
                        int _periodYear = _period == null ? hisUtilDay.getYear() + 1900 : _period.getPeriodYear();
                        int _periodNumber = _period == null ? (hisUtilDay.getMonth() + 3) / 3 : _period.getPeriodNumber();
                        acctTableId = AccountTools.getCurrentAcctTable((Context)ctx, (String)_company.getCU().getId().toString(), (String)_company.getAccountTable().getId().toString(), (int)_periodYear, (int)_periodNumber);
                    }
                    int verifyMode = GlUtils.getVerifyMode((Context)ctx, (String)companyid);
                    boolean bl = isInTimeVerify = verifyMode == 0;
                    if (verifyMode == 2) {
                        includeUnPosted = true;
                    }
                    if (!includeUnPosted || !isInTimeVerify) break block161;
                    amountField = "cussent.funholdedAmtFor";
                    if (CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString().equals(currencyid)) {
                        amountField = "cussent.funholdedAmtfor * (case when( " + tempTable + ".FCONVERTRATEA is null ) then 1 else " + tempTable + ".FCONVERTRATEA end )";
                        break block155;
                    } else if (CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString().equals(currencyid)) {
                        amountField = "cussent.funholdedAmtRpt";
                        break block155;
                    } else {
                        general = false;
                    }
                    break block155;
                }
                amountField = "cussent.funVerifiedAmtFor";
                if (CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString().equals(currencyid)) {
                    amountField = "cussent.funVerifiedAmtFor * (case when( " + tempTable + ".FCONVERTRATEA is null ) then 1 else " + tempTable + ".FCONVERTRATEA end )";
                } else if (CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString().equals(currencyid)) {
                    amountField = "cussent.funVerifiedAmtRpt";
                } else {
                    general = false;
                }
            }
            if (days == null || days.length < 1) {
                ArrayList _periodNumber = null;
                return _periodNumber;
            }
            Iterator itemkeyit = hmItems.keySet().iterator();
            if (isBizCode) {
                while (itemkeyit.hasNext()) {
                    HashMap item = (HashMap)itemkeyit.next();
                    String[] numbers = (String[])hmItems.get(item);
                    bizCodeFromNumber = numbers[0];
                    bizCodeToNumber = numbers[1];
                }
            }
            StringBuffer selecthg = new StringBuffer();
            StringBuffer createHgTbl = new StringBuffer();
            StringBuffer sum = new StringBuffer("0 as leftamount, sum((entry.fentrydc*2-1)*account.fdc*").append(amountField).append(") as sumall");
            StringBuffer initsum = new StringBuffer("0 as leftamount, sum(").append(amountField).append(") as sumall");
            StringBuffer leftsum = new StringBuffer("sum(").append(amountField).append(") as leftamount, 0 as sumall");
            int daylen = days.length;
            ArrayList<Date> alDates = new ArrayList<Date>(daylen * 2);
            Calendar cal = Calendar.getInstance();
            sum.append(" ,sum(case when assist." + this.strDateType + ">? then (entry.fentrydc*2-1)*account.fdc*").append(amountField).append(" else 0 end) as sum0");
            initsum.append(" ,sum(case when assist." + this.strDateType + ">? then ").append(amountField).append(" else 0 end) as sum0");
            leftsum.append(" ,0 as sum0");
            cal.setTime(endDate);
            cal.add(5, -1 * days[0]);
            alDates.add(new Date(cal.getTimeInMillis()));
            for (int i4 = 1; i4 < daylen; ++i4) {
                sum.append(" ,sum(case when assist." + this.strDateType + "<=? and assist." + this.strDateType + ">? then (entry.fentrydc*2-1)*account.fdc*").append(amountField).append(" else 0 end) as sum").append(i4);
                initsum.append(" ,sum(case when assist." + this.strDateType + "<=? and assist." + this.strDateType + ">? then ").append(amountField).append(" else 0 end) as sum").append(i4);
                leftsum.append(" ,0 as sum").append(i4);
                cal.setTime(endDate);
                cal.add(5, -1 * days[i4 - 1]);
                alDates.add(new Date(cal.getTimeInMillis()));
                cal.setTime(endDate);
                cal.add(5, -1 * days[i4]);
                alDates.add(new Date(cal.getTimeInMillis()));
            }
            sum.append(" ,sum(case when assist." + this.strDateType + "<=? then (entry.fentrydc*2-1)*account.fdc*").append(amountField).append(" else 0 end) as sum").append(daylen);
            initsum.append(" ,sum(case when assist." + this.strDateType + "<=? then ").append(amountField).append(" else 0 end) as sum").append(daylen);
            leftsum.append(" ,0 as sum").append(daylen);
            cal.setTime(endDate);
            cal.add(5, -1 * days[daylen - 1]);
            alDates.add(new Date(cal.getTimeInMillis()));
            StringBuffer from = new StringBuffer();
            StringBuffer initFrom = new StringBuffer();
            StringBuffer leftFrom = new StringBuffer();
            from.append(" from t_gl_voucherassistrecord assist \r\n join t_gl_acctcussent cussent on cussent.fvchassistrecordid=assist.fid \r\n join t_gl_voucherentry entry on assist.fentryid=entry.fid");
            from.append("  \r\n join t_gl_voucher voucher on entry.fbillid=voucher.fid \r\n join t_bd_accountview account on cussent.faccountid=account.fid ");
            from.append(" \r\n join t_bd_Currency currency on entry.fcurrencyid=currency.fid");
            from.append(" left join " + tempTable + " on " + tempTable + ".fid = currency.fid ");
            from.append(" \r\n join t_bd_assistanthg hg on assist.fassgrpid=hg.fid ");
            if (isBizCode && isAccountList) {
                from.append("\r\n inner join ").append(this.queryBizCodeHgid(ctx, accountid, bizCodeFromNumber, bizCodeToNumber, false, companyid)).append(" on hg.fid = T_Hgid.fid ");
            }
            if (isAccountBC && !isAccountNoBC) {
                from.append("\r\n inner join ").append(this.queryBizCodeHgid(ctx, null, bizCodeFromNumber, bizCodeToNumber, false, companyid)).append(" on hg.fid = T_Hgid.fid ");
            }
            initFrom.append(" \r\n from t_gl_voucherassistrecord assist \r\n join t_gl_acctcussent cussent on cussent.fvchassistrecordid = assist.fid ");
            initFrom.append(" \r\n join t_bd_Currency currency on cussent.fcurrencyid = currency.fid");
            initFrom.append(" left join " + tempTable + " on " + tempTable + ".fid = currency.fid ");
            initFrom.append(" \r\n join t_bd_assistanthg hg on assist.fassgrpid = hg.fid");
            if (isBizCode && isAccountList) {
                initFrom.append("\r\n inner join ").append(this.queryBizCodeHgid(ctx, accountid, bizCodeFromNumber, bizCodeToNumber, false, companyid)).append(" on hg.fid = T_Hgid.fid ");
            }
            if (isAccountBC && !isAccountNoBC) {
                initFrom.append("\r\n inner join ").append(this.queryBizCodeHgid(ctx, null, bizCodeFromNumber, bizCodeToNumber, false, companyid)).append(" on hg.fid = T_Hgid.fid ");
            }
            initFrom.append(" \r\n join t_bd_accountview account on cussent.faccountid=account.fid ");
            leftFrom.append(" \r\n from t_gl_voucherassistrecord assist \r\n inner join t_gl_acctcussent cussent on assist.fid=cussent.fvchassistrecordid ");
            leftFrom.append(" \r\n inner join t_bd_Currency currency on currency.fid = cussent.fcurrencyid \r\n inner join t_bd_assistanthg hg on assist.fassgrpid=hg.fid ");
            if (isBizCode && isAccountList) {
                leftFrom.append("\r\n inner join ").append(this.queryBizCodeHgid(ctx, accountid, bizCodeFromNumber, bizCodeToNumber, false, companyid)).append(" on hg.fid = T_Hgid.fid ");
            }
            if (isAccountBC && !isAccountNoBC) {
                leftFrom.append("\r\n inner join ").append(this.queryBizCodeHgid(ctx, null, bizCodeFromNumber, bizCodeToNumber, false, companyid)).append(" on hg.fid = T_Hgid.fid ");
            }
            leftFrom.append(" left join " + tempTable + " on " + tempTable + ".fid = currency.fid ");
            leftFrom.append(" \r\n left outer join t_gl_voucher voucher on voucher.fid = assist.fbillid ");
            leftFrom.append(" \r\n join t_bd_accountview account on cussent.faccountid=account.fid ");
            StringBuffer innerJoin = new StringBuffer();
            StringBuffer groupby = new StringBuffer();
            int gi = 0;
            ArrayList<String> alNumbers = new ArrayList<String>();
            ArrayList<String> alTables = new ArrayList<String>();
            ArrayList<String> alFields = new ArrayList<String>();
            int tablei = 0;
            if (isAccountList) {
                groupby.append(" group by ");
                groupby.append("account.FID ,account.Fnumber ,account.").append(accountname).append(loc);
                if (isBizCode) {
                    groupby.append(",bacid");
                }
            }
            if (isAccountBC && !isAccountNoBC) {
                groupby.append(" group by ");
                groupby.append("bacid ").append(",bacnumber , bacname");
            }
            if (!isBizCode) {
                HashMap<String, Object> hmParamIn = new HashMap<String, Object>();
                hmParamIn.put("GL_064", null);
                HashMap hmAllParam = ParamControlFactory.getLocalInstance((Context)ctx).getParamHashMap(hmParamIn);
                Object isShowLongNumberObj = hmAllParam.get("GL_064");
                boolean isShowLongNumber = false;
                if (isShowLongNumberObj != null) {
                    isShowLongNumber = Boolean.valueOf(isShowLongNumberObj.toString());
                }
                itemkeyit = hmItems.keySet().iterator();
                HashMap[] itemList = new HashMap[hmItems.keySet().size()];
                int k = 0;
                while (itemkeyit.hasNext()) {
                    HashMap item = (HashMap)itemkeyit.next();
                    Integer seq = (Integer)item.get("seq");
                    if (seq != null) {
                        itemList[seq.intValue()] = item;
                    } else {
                        itemList[k] = item;
                    }
                    ++k;
                }
                for (int i5 = 0; i5 < itemList.length; ++tablei, ++gi, ++i5) {
                    HashMap item = itemList[i5];
                    String[] numbers = (String[])hmItems.get(item);
                    String table = (String)item.get("tablename");
                    String field = (String)item.get("fieldname");
                    boolean isGeneralActType = item.get("FGLAsstActTypeGrpID") != null && item.get("propname").toString().startsWith("generalAssActType");
                    boolean isUseLongNumber = (Boolean)item.get("useLongNUmber");
                    alTables.add(table);
                    alFields.add(field);
                    innerJoin.append(" inner join ").append(table).append(" ").append("T").append(tablei).append(" on hg.").append(field).append("=").append("T").append(tablei).append(".fid");
                    if (numbers[0] != null) {
                        innerJoin.append(" and ").append("T").append(tablei);
                        if (!isGeneralActType || !isUseLongNumber) {
                            innerJoin.append(".fnumber>=?");
                            alNumbers.add(numbers[0]);
                        } else {
                            innerJoin.append(".flongnumber>=?");
                            alNumbers.add(numbers[0].replace('.', '!'));
                        }
                    }
                    if (numbers[1] != null) {
                        innerJoin.append(" and ").append("T").append(tablei);
                        if (!isGeneralActType || !isUseLongNumber) {
                            innerJoin.append(".fnumber<=?");
                            alNumbers.add(numbers[1]);
                        } else {
                            innerJoin.append(".flongnumber<=?");
                            alNumbers.add(numbers[1].replace('.', '!'));
                        }
                    }
                    if (!isAccountList) {
                        if (gi == 0) {
                            groupby.append(" group by ");
                        } else {
                            groupby.append(" ,");
                        }
                        selecthg.append("hg.").append(field).append(" as ").append("T").append(tablei).append(field).append(",");
                        groupby.append("hg.").append(field).append(",");
                        if (isShowLongNumber && item.get("propname") != null && item.get("propname").toString().startsWith("general")) {
                            selecthg.append("replace(T").append(tablei).append(".flongnumber,'!','.') as ").append("T").append(tablei).append("fnumber,");
                            groupby.append("T").append(tablei).append(".flongnumber,");
                        } else {
                            selecthg.append("T").append(tablei).append(".fnumber as ").append("T").append(tablei).append("fnumber,");
                            groupby.append("T").append(tablei).append(".fnumber,");
                        }
                        selecthg.append("T").append(tablei).append(".fname_").append(loc).append(" as ").append("T").append(tablei).append("fname,");
                        groupby.append("T").append(tablei).append(".fname_").append(loc);
                        selecthgoutside.append("T").append(tablei).append(field).append(",T").append(tablei).append("fnumber,").append("T").append(tablei).append("fname,");
                        createHgTbl.append("T").append(tablei).append(field).append(" varchar(44),").append("T").append(tablei).append("fnumber nvarchar(80),").append("T").append(tablei).append("fname nvarchar(255),");
                        continue;
                    }
                    if (tablei != 0) continue;
                    selecthgoutside.append("T").append(tablei).append(field).append(",");
                    selecthgoutside.append("T").append(tablei).append("fnumber,");
                    selecthgoutside.append("T").append(tablei).append("fname,");
                    selecthg.append("account.FID as T0").append(field).append(",account.Fnumber as T0fnumber,account.").append(accountname).append(loc).append(" as T0fname,");
                    createHgTbl.append("T0").append(field).append(" varchar(44),T0fnumber nvarchar(80),T0fname nvarchar(255),");
                }
            } else if (!isAccountBC) {
                selecthgoutside.append("Taccountid").append(",T0fnumber").append(",T0fname,");
                selecthg.append("account.FID as Taccountid").append(",account.Fnumber as T0fnumber,account.").append(accountname).append(loc).append(" as T0fname,");
                createHgTbl.append("Taccountid").append(" varchar(44),T0fnumber nvarchar(80),T0fname nvarchar(255),");
            } else if (!isAccountNoBC) {
                selecthgoutside.append("Taccountid").append(",T0fnumber").append(",T0fname,");
                selecthg.append("T_Hgid.bacid as Taccountid").append(",T_Hgid.bacnumber as T0fnumber, T_Hgid.bacname as T0fname,");
                createHgTbl.append("Taccountid").append(" varchar(44),T0fnumber nvarchar(80),T0fname nvarchar(255),");
            }
            if (allCurr) {
                selecthg.append("currency.fid fcurrid,currency.Fname_" + loc + " fcurrname,");
                createHgTbl.append("fcurrid varchar(44),fcurrname nvarchar(100),");
            } else {
                ICurrency icurrency = CurrencyFactory.getLocalInstance((Context)ctx);
                CurrencyInfo currency = icurrency.getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyid));
                selecthg.append("'" + currency.getId() + "' fcurrid,N'" + currency.getName() + "' fcurrname,");
                createHgTbl.append("fcurrid varchar(44),fcurrname nvarchar(100),");
            }
            if (isAccountList) {
                if (isBizCode) {
                    selecthg.append("T_Hgid.bacid as hgid,");
                } else {
                    selecthg.append("hg.FID as hgid,");
                }
                createHgTbl.append("hgid varchar(44),");
            }
            selecthgoutside.append("fcurrid,fcurrname,");
            if (isAccountList) {
                selecthgoutside.append("hgid,");
            }
            createHgTbl.append("acct_id varchar(44),acct_number nvarchar(44) ,");
            selecthg.append(" account.fid as acct_id,account.fnumber as acct_number,");
            selecthgoutside.append(" acct_id,acct_number,");
            StringBuffer where = new StringBuffer();
            StringBuffer initWhere = new StringBuffer();
            StringBuffer leftWhere = new StringBuffer();
            where.append(" where assist." + this.strDateType + "<? ");
            where.append(" and cussent.fisinit<>1 ");
            if (isAccountList) {
                if (isBizCode) {
                    // empty if block
                }
                where.append(" and account.FAccountTableID='" + acctTableId + "' ");
            } else {
                where.append(" and cussent.faccountid in (" + accountid + ") ");
            }
            where.append(" and cussent.fcompanyid=? ");
            where.append(" and (cussent.fperiodid is null or cussent.fperiodid in (select fperiodid from v_gl_acperiod where fcompanyid=cussent.fcompanyid)) ");
            if (!includeUnPosted) {
                where.append("and voucher.FBizStatus=5");
            } else {
                where.append(" and voucher.fbizstatus <> 0 and voucher.fbizstatus<>2 ");
            }
            if (!general && !allCurr) {
                where.append(" and entry.fcurrencyid=? ");
            }
            if (isAccountList) {
                this.buildAccountSql(where, accountParams, "account.fnumber");
            }
            initWhere.append(" where  assist." + this.strDateType + "<? ");
            initWhere.append(" and assist.fentryid is null and cussent.fisinit=1 and cussent.fisinitclosed=1");
            if (isAccountList) {
                if (isBizCode) {
                    initWhere.append(" and account.FAccountTableID='" + acctTableId + "' ");
                } else {
                    initWhere.append(" /*and hg.FID in (" + accountid + ")*/ and account.FAccountTableID='" + acctTableId + "' ");
                }
            } else {
                initWhere.append(" and cussent.faccountid in (" + accountid + ") ");
            }
            initWhere.append(" and cussent.fcompanyid=?  ");
            if (!general && !allCurr) {
                initWhere.append(" and cussent.fcurrencyid=? ");
            }
            if (isAccountList) {
                this.buildAccountSql(initWhere, accountParams, "account.fnumber");
            }
            leftWhere.append(" where 1=1 ");
            if (!includeInit) {
                leftWhere.append(" and cussent.fisinit<>1");
                if (!includeUnPosted) {
                    leftWhere.append(" and voucher.FBizStatus=5");
                } else {
                    leftWhere.append(" and voucher.fbizstatus <> 0 and voucher.fbizstatus<>2 ");
                }
            } else {
                leftWhere.append(" and (cussent.fisinit<>1 ");
                if (!includeUnPosted) {
                    leftWhere.append(" and voucher.FBizStatus=5");
                } else {
                    leftWhere.append(" and voucher.fbizstatus <> 0 and voucher.fbizstatus<>2 ");
                }
                leftWhere.append(" or voucher.fid is null and cussent.fisinit=1 and cussent.fisinitclosed=1)");
            }
            if (isAccountList) {
                if (isBizCode) {
                    leftWhere.append(" and account.FAccountTableID='" + acctTableId + "' ");
                } else {
                    leftWhere.append(" /*and hg.FID in (" + accountid + ")*/ and account.FAccountTableID='" + acctTableId + "' ");
                }
            } else {
                leftWhere.append(" and cussent.faccountid in (" + accountid + ") ");
            }
            leftWhere.append(" and cussent.fcompanyid=?  ");
            leftWhere.append(" and (cussent.fperiodid is null or cussent.fperiodid in (select fperiodid from v_gl_acperiod where fcompanyid=cussent.fcompanyid)) ");
            if (!general && !allCurr) {
                leftWhere.append(" and cussent.fcurrencyid=? ");
            }
            if (isAccountList) {
                this.buildAccountSql(leftWhere, accountParams, "account.fnumber");
            }
            StringBuffer merge = new StringBuffer();
            merge.append("select ").append(selecthgoutside);
            merge.append(" leftamount as sumall");
            merge.append(",leftamount-(sum0");
            for (int i22 = 1; i22 <= daylen; ++i22) {
                merge.append("+sum" + i22);
            }
            merge.append(") sumunoverdue");
            merge.append(",sum0");
            for (i2 = 1; i2 <= daylen; ++i2) {
                merge.append("+sum" + i2);
            }
            merge.append(" sumoverdue,sum0");
            for (i2 = 1; i2 <= daylen; ++i2) {
                merge.append(",sum" + i2);
            }
            merge.append(" from ");
            if (isAccountList) {
                groupby.append(",hg.fid");
            }
            if (allCurr) {
                groupby.append(",currency.fid, currency.Fname_" + loc);
            }
            if (groupby.toString().trim().startsWith(",")) {
                groupby = new StringBuffer(" group by ").append(groupby.substring(groupby.indexOf(",") + 1));
            }
            StringBuffer sql1 = new StringBuffer();
            StringBuffer sql2 = new StringBuffer();
            StringBuffer sql3 = new StringBuffer();
            sql1.append("select ").append(selecthg).append(sum).append(from).append(innerJoin).append(where).append(groupby);
            sql2.append("select ").append(selecthg).append(initsum).append(initFrom).append(innerJoin).append(initWhere).append(groupby);
            sql3.append("select ").append(selecthg).append(leftsum).append(leftFrom).append(innerJoin).append(leftWhere).append(groupby);
            String selectHgString = selecthg.substring(0, selecthg.length() - 1);
            StringBuffer includeVerifyVoucher = !isInTimeVerify && includeVerifyVch ? this.queryVerifyVoucher(ctx, allCurr, days, isAccountList, accountid, acctTableId, accountParams, selecthg, innerJoin, groupby, companyid, tempTable, currencyid, isBizCode, isAccountBC, bizCodeFromNumber, bizCodeToNumber, companyid, hisUtilDay) : new StringBuffer();
            sum = new StringBuffer();
            selecthg = new StringBuffer();
            groupby = new StringBuffer();
            StringBuffer orderby = new StringBuffer();
            sum.append("sum(leftamount) as leftamount ,sum(sumall) as sumall");
            String _whereCause = "t.sum0";
            for (i = 0; i < daylen + 1; ++i) {
                sum.append(",sum(sum" + i + ") as sum" + i);
                if (i == 0) continue;
                _whereCause = _whereCause + "+t.sum" + i;
            }
            for (i = 0; i < alTables.size(); ++i) {
                String numkey = "T" + i + "fnumber";
                String namekey = "T" + i + "fname";
                selecthg.append(",").append(numkey);
                selecthg.append(",").append(namekey);
                groupby.append(",").append(numkey);
                groupby.append(",").append(namekey);
                if (isAccountList && i != 0) continue;
                orderby.append(numkey).append(",");
                orderby.append(namekey).append(",");
            }
            if (groupby.length() > 0) {
                groupby = new StringBuffer(" group by ").append(selecthgoutside.deleteCharAt(selecthgoutside.length() - 1));
            }
            if (selecthgoutside.toString().endsWith(",")) {
                int delimiterIdx = selecthgoutside.lastIndexOf(",");
                selecthgoutside = new StringBuffer(selecthgoutside.toString().substring(0, delimiterIdx));
            }
            StringBuffer historySql = new StringBuffer();
            if (hisUtilDay != null) {
                historyTempateTable = TableManagerFacadeFactory.getLocalInstance((Context)ctx).getTableName("gl_temp");
                String craeteTable = "CREATE TABLE " + historyTempateTable + " ( FCUSSENTID varchar (44) NOT NULL,fdc int, leftamount numeric(28,10) not null default 0,sumall numeric(28,10) not null default 0";
                for (int i6 = 0; i6 < daylen + 1; ++i6) {
                    craeteTable = craeteTable + ",sum" + i6 + " numeric(28,10) not null default 0";
                }
                craeteTable = craeteTable + (createHgTbl.length() > 0 ? "," + createHgTbl.substring(0, createHgTbl.length() - 1) : "") + ")";
                try {
                    historyTempateTable = TempTablePool.getInstance((Context)ctx).createTempTable(craeteTable);
                }
                catch (Exception e) {
                    throw new SQLException(EASResource.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"370_QueryBalanceByAge") + e.getMessage());
                }
                String sumstr = "0 leftamount,0 sumall,";
                for (int i7 = 0; i7 <= daylen; ++i7) {
                    sumstr = sumstr + "0 sum" + i7 + ",";
                }
                String querySql = "insert into " + historyTempateTable + " SELECT distinct cussent.fid fcussentid,(entry.fentrydc * 2 - 1)*ACCOUNT.fdc fdc," + sumstr + selectHgString + from + innerJoin + where;
                con = null;
                ps = null;
                try {
                    con = GetConnection.exec(ctx);
                    ps = con.prepareStatement(querySql);
                    Calendar hiscal = Calendar.getInstance();
                    hiscal.set(1, 2020);
                    this.setupParams(false, null, currencyid, hiscal.getTime(), companyid, isAccountList, accountFromNumber, accountToNumber, !general && !allCurr, new ArrayList(), hiscal, alNumbers, ps, new ArrayList(), 1, null, new SqlParams());
                    ps.execute();
                    querySql = "insert into " + historyTempateTable + " SELECT distinct cussent.fid fcussentid,1 fdc," + sumstr + selectHgString + initFrom + innerJoin + initWhere;
                    querySql = querySql + " and cussent.fid not in (select fcussentid from " + historyTempateTable + ")";
                    ps = con.prepareStatement(querySql);
                    this.setupParams(true, null, currencyid, hiscal.getTime(), companyid, isAccountList, accountFromNumber, accountToNumber, !general && !allCurr, new ArrayList(), hiscal, alNumbers, ps, new ArrayList(), 1, null, new SqlParams());
                    ps.execute();
                    Calendar _cal = Calendar.getInstance();
                    _cal.setTime(DateTimeUtils.truncateDate((java.util.Date)hisUtilDay));
                    _cal.add(5, 1);
                    _cal.add(14, -1);
                    Date _dayIndex = new Date(_cal.getTimeInMillis());
                    Date _day1 = null;
                    Date _day2 = new Date(_cal.getTime().getTime());
                    String sql = "update " + historyTempateTable + " set leftamount = leftamount +                                                                        \r\nISNULL(                                                                                                                             \r\n       (select case when SUM (k.foroginalamount) is null then 0 else SUM (k.foroginalamount)*" + historyTempateTable + ".fdc end           \r\n               FROM t_gl_acctcussenthistory k                                                                                       \r\n              WHERE k.fcussentidid = " + historyTempateTable + ".fcussentid                                                                \r\n                AND ( k.fdc IN (0, 2) AND (k.fvchdate <= " + this.getDay(_day2) + " or k.fvchdate is null)                               \r\n                     AND EXISTS (SELECT 1 FROM t_gl_voucherassistrecord r LEFT OUTER JOIN t_gl_voucher v ON v.fid = r.fbillid       \r\n                             WHERE k.fvoucherasstidid = r.fid AND v.fbookeddate > " + this.getDay(_day2) + " )                           \r\n                    )                                                                                                               \r\n                    GROUP BY k.fcussentidid)                                                                                        \r\n       ,0)                                                                                                                          \r\n+                                                                                                                                   \r\nISNULL(                                                                                                                             \r\n       (SELECT CASE WHEN SUM (k.foroginalamount) IS NULL THEN 0 ELSE SUM (k.foroginalamount)*" + historyTempateTable + ".fdc END           \r\n                  FROM t_gl_acctcussenthistory k                                                                                    \r\n                 WHERE k.fcussentidid = " + historyTempateTable + ".fcussentid                                                             \r\n                   AND ( k.fdc = 1 AND (k.fvchdate <= " + this.getDay(_day2) + " or k.fvchdate is null)                                         \r\n                        AND EXISTS (SELECT 1 FROM t_gl_acctcussenthistory k2                                                        \r\n                                WHERE k2.fvoucherasstidid = k.fcussentidid                                                          \r\n                                  AND k2.fcussentidid = k.fvoucherasstidid                                                          \r\n                                  AND k2.fvchdate > " + this.getDay(_day2) + ")                                                          \r\n                       )                                                                                                            \r\n              GROUP BY k.fcussentidid)                                                                                              \r\n     ,0)                                                                                                                            \r\n";
                    DbUtil.execute((Context)ctx, (String)sql);
                    sql = "UPDATE " + historyTempateTable + "                                                                                                      \r\n   SET leftamount = leftamount + ISNULL((SELECT (SUM (CASE WHEN v.fbookeddate > " + this.getDay(_day2) + "                               \r\n                                     THEN -1 * (e.fentrydc * 2 - 1) * ACCOUNT.fdc * cuss.funverifiedamtfor ELSE 0 END ))            \r\n               FROM t_gl_acctcussent cuss INNER JOIN t_gl_voucherassistrecord ass ON ass.fid = cuss.fvchassistrecordid              \r\n                    INNER JOIN t_gl_voucherentry e ON e.fid = ass.fentryid                                                          \r\n                    INNER JOIN t_gl_voucher v ON v.fid = e.fbillid and v.fid = ass.fbillid                                          \r\n                    INNER JOIN t_bd_accountview ACCOUNT ON ACCOUNT.fid = e.faccountid and ACCOUNT.fcompanyid = v.fcompanyid         \r\n              WHERE cuss.fid = " + historyTempateTable + ".fcussentid " + (isAccountList ? "" : " and cuss.faccountid in ( " + accountid + ")") + " and v.fcompanyid = '" + _company.getId().toString() + "'       \r\n           group by cuss.fid                                                                                                        \r\n           ),0)                                                                                                                     \r\n";
                    DbUtil.execute((Context)ctx, (String)sql);
                    _cal = Calendar.getInstance();
                    _cal.setTime(DateTimeUtils.truncateDate((java.util.Date)endDate));
                    _day1 = new Date(_cal.getTime().getTime());
                    sql = "update " + historyTempateTable + " set sumall = sumall +                                                                                      \r\nISNULL(                                                                                                                            \r\n       (select case when SUM (k.foroginalamount) is null then 0 else SUM (k.foroginalamount)*" + historyTempateTable + ".fdc end          \r\n               FROM t_gl_acctcussenthistory k                                                                                      \r\n              WHERE k.fcussentidid = " + historyTempateTable + ".fcussentid                                                               \r\n                AND ( k.fdc IN (0, 2) AND (k.fvchdate <= " + this.getDay(_dayIndex) + " or k.fvchdate is null)                          \r\n                     AND EXISTS (SELECT 1 FROM t_gl_voucherassistrecord r LEFT OUTER JOIN t_gl_voucher v ON v.fid = r.fbillid      \r\n                             WHERE k.fvoucherasstidid = r.fid AND v.fbookeddate > " + this.getDay(_dayIndex) + " )                      \r\n                     AND EXISTS (SELECT 1 FROM t_gl_acctcussent cuss inner join t_gl_voucherassistrecord r on cuss.FVchAssistRecordID = r.fid       \r\n                             WHERE k.FCussentidID = cuss.fid AND (r." + this.strDateType + " < " + this.getDay(_day1) + "  or r." + this.strDateType + " is null)) \r\n                    )                                                                                                              \r\n                    GROUP BY k.fcussentidid)                                                                                       \r\n       ,0)                                                                                                                         \r\n+                                                                                                                                  \r\nISNULL(                                                                                                                            \r\n    (SELECT CASE WHEN SUM (k.foroginalamount) IS NULL THEN 0 ELSE SUM (k.foroginalamount)*" + historyTempateTable + ".fdc END             \r\n                  FROM t_gl_acctcussenthistory k                                                                                   \r\n                 WHERE k.fcussentidid = " + historyTempateTable + ".fcussentid                                                            \r\n                   AND ( k.fdc = 1 AND (k.fvchdate <= " + this.getDay(_dayIndex) + " or k.fvchdate is null)                                    \r\n                        AND EXISTS (SELECT 1 FROM t_gl_acctcussenthistory k2                                                       \r\n                                WHERE k2.fvoucherasstidid = k.fcussentidid AND k2.fcussentidid = k.fvoucherasstidid                \r\n                                  AND k2.fvchdate > " + this.getDay(_dayIndex) + ")                                                     \r\n                        AND EXISTS (SELECT 1 FROM t_gl_acctcussent cuss inner join t_gl_voucherassistrecord r on cuss.FVchAssistRecordID = r.fid         \r\n                             WHERE k.FCussentidID = cuss.fid AND (r." + this.strDateType + " > " + this.getDay(_day1) + "  or r." + this.strDateType + " is null))      \r\n                       )                                                                                                           \r\n              GROUP BY k.fcussentidid)                                                                                             \r\n     ,0)                                                                                                                           \r\n";
                    DbUtil.execute((Context)ctx, (String)sql);
                    for (int i8 = 0; i8 < daylen; ++i8) {
                        if (i8 == 0) {
                            _cal = Calendar.getInstance();
                            _cal.setTime(DateTimeUtils.truncateDate((java.util.Date)endDate));
                            _cal.add(5, -1 * days[0]);
                            _day1 = new Date(_cal.getTime().getTime());
                            _day2 = new Date(DateTimeUtils.truncateDate((java.util.Date)endDate).getTime());
                        } else {
                            _cal = Calendar.getInstance();
                            _cal.setTime(DateTimeUtils.truncateDate((java.util.Date)endDate));
                            _cal.add(5, -1 * days[i8]);
                            _day1 = new Date(_cal.getTime().getTime());
                            _cal.setTime(DateTimeUtils.truncateDate((java.util.Date)endDate));
                            _cal.add(5, -1 * days[i8 - 1]);
                            _day2 = new Date(_cal.getTime().getTime());
                        }
                        sql = "UPDATE " + historyTempateTable + " SET sum" + i8 + " = sum" + i8 + " +                                                                       \r\nISNULL(                                                                                                                         \r\n       (select case when SUM (k.foroginalamount) is null then 0 else SUM (k.foroginalamount)*" + historyTempateTable + ".fdc end       \r\n               FROM t_gl_acctcussenthistory k                                                                                   \r\n              WHERE k.fcussentidid = " + historyTempateTable + ".fcussentid                                                            \r\n                AND ( k.fdc IN (0, 2) AND (k.fvchdate <= " + this.getDay(_dayIndex) + " or k.fvchdate is null)                       \r\n                     AND EXISTS (SELECT 1 FROM t_gl_voucherassistrecord r LEFT OUTER JOIN t_gl_voucher v ON v.fid = r.fbillid   \r\n                             WHERE k.fvoucherasstidid = r.fid AND v.fbookeddate > " + this.getDay(_dayIndex) + ")                    \r\n                     AND EXISTS (SELECT 1 FROM t_gl_acctcussent cuss inner join t_gl_voucherassistrecord r on cuss.FVchAssistRecordID = r.fid \r\n                             WHERE k.FCussentidID = cuss.fid AND (r." + this.strDateType + " >= " + this.getDay(_day1) + " AND r." + this.strDateType + " < " + this.getDay(_day2) + " or r." + this.strDateType + " is null))                                                                                             \r\n                    )                                                                                                           \r\n                    GROUP BY k.fcussentidid)                                                                                    \r\n       ,0)                                                                                                                      \r\n+                                                                                                                               \r\nISNULL(                                                                                                                         \r\n    (SELECT CASE WHEN SUM (k.foroginalamount) IS NULL THEN 0 ELSE SUM (k.foroginalamount)*" + historyTempateTable + ".fdc END          \r\n                  FROM t_gl_acctcussenthistory k                                                                                \r\n                 WHERE k.fcussentidid = " + historyTempateTable + ".fcussentid                                                         \r\n                   AND ( k.fdc = 1 AND (k.fvchdate <= " + this.getDay(_dayIndex) + " or k.fvchdate is null)                                 \r\n                        AND EXISTS (SELECT 1 FROM t_gl_acctcussenthistory k2                                                    \r\n                                WHERE k2.fvoucherasstidid = k.fcussentidid AND k2.fcussentidid = k.fvoucherasstidid             \r\n                                  AND k2.fvchdate > " + this.getDay(_dayIndex) + ")                                                  \r\n                        AND EXISTS (SELECT 1 FROM t_gl_acctcussent cuss inner join t_gl_voucherassistrecord r on cuss.FVchAssistRecordID = r.fid \r\n                                WHERE k.FCussentidID = cuss.fid AND (r." + this.strDateType + " >= " + this.getDay(_day1) + " AND r." + this.strDateType + " < " + this.getDay(_day2) + " or r." + this.strDateType + " is null))                                                                                             \r\n                       )                                                                                                        \r\n              GROUP BY k.fcussentidid)                                                                                          \r\n     ,0)                                                                                                                        \r\n";
                        DbUtil.execute((Context)ctx, (String)sql);
                        sql = "UPDATE " + historyTempateTable + " set sum" + i8 + " = sum" + i8 + " +                                                                \r\nISNULL((SELECT (SUM (CASE WHEN v.fbookeddate > " + this.getDay(_dayIndex) + "                                                        \r\n                                     THEN -1 * (e.fentrydc * 2 - 1) * ACCOUNT.fdc * cuss.funverifiedamtfor ELSE 0 END ))        \r\n               FROM t_gl_acctcussent cuss INNER JOIN t_gl_voucherassistrecord ass ON ass.fid = cuss.fvchassistrecordid          \r\n                    INNER JOIN t_gl_voucherentry e ON e.fid = ass.fentryid                                                      \r\n                    INNER JOIN t_gl_voucher v ON v.fid = e.fbillid and v.fid = ass.fbillid                                      \r\n                    INNER JOIN t_bd_accountview ACCOUNT ON ACCOUNT.fid = e.faccountid and ACCOUNT.fcompanyid = v.fcompanyid     \r\n              WHERE cuss.fid = " + historyTempateTable + ".fcussentid " + (isAccountList ? "" : " and cuss.faccountid in ( " + accountid + ")") + " and v.fcompanyid = '" + _company.getId().toString() + "' and (ass." + this.strDateType + " >= " + this.getDay(_day1) + " AND ass." + this.strDateType + " < " + this.getDay(_day2) + " or ass." + this.strDateType + " is null)                                                                                            \r\n           group by cuss.fid                                                                                                    \r\n           ),0)                                                                                                                 \r\n";
                        DbUtil.execute((Context)ctx, (String)sql);
                        if (i8 != daylen - 1) continue;
                        _cal = Calendar.getInstance();
                        _cal.setTime(DateTimeUtils.truncateDate((java.util.Date)endDate));
                        _cal.add(5, -1 * days[i8]);
                        _day1 = new Date(_cal.getTime().getTime());
                        sql = "UPDATE " + historyTempateTable + " SET sum" + (i8 + 1) + " = sum" + (i8 + 1) + " +                                                          \r\nISNULL(                                                                                                                         \r\n       (select case when SUM (k.foroginalamount) is null then 0 else SUM (k.foroginalamount)*" + historyTempateTable + ".fdc end       \r\n               FROM t_gl_acctcussenthistory k                                                                                   \r\n              WHERE k.fcussentidid = " + historyTempateTable + ".fcussentid                                                            \r\n                AND ( k.fdc IN (0, 2) AND (k.fvchdate <= " + this.getDay(_dayIndex) + " or k.fvchdate is null)                       \r\n                     AND EXISTS (SELECT 1 FROM t_gl_voucherassistrecord r LEFT OUTER JOIN t_gl_voucher v ON v.fid = r.fbillid   \r\n                             WHERE k.fvoucherasstidid = r.fid AND v.fbookeddate > " + this.getDay(_dayIndex) + "  )                  \r\n                     AND EXISTS (SELECT 1 FROM t_gl_acctcussent cuss inner join t_gl_voucherassistrecord r on cuss.FVchAssistRecordID = r.fid             \r\n                             WHERE k.FCussentidID = cuss.fid AND (r." + this.strDateType + " < " + this.getDay(_day1) + " or r." + this.strDateType + " is null))        \r\n                    )                                                                                                           \r\n                    GROUP BY k.fcussentidid)                                                                                    \r\n       ,0)                                                                                                                      \r\n+                                                                                                                               \r\nISNULL(                                                                                                                         \r\n       (SELECT CASE WHEN SUM (k.foroginalamount) IS NULL THEN 0 ELSE SUM (k.foroginalamount)*" + historyTempateTable + ".fdc END       \r\n                  FROM t_gl_acctcussenthistory k                                                                                \r\n                 WHERE k.fcussentidid = " + historyTempateTable + ".fcussentid                                                         \r\n                   AND ( k.fdc = 1 AND (k.fvchdate <= " + this.getDay(_dayIndex) + " or k.fvchdate is null)                                 \r\n                        AND EXISTS (SELECT 1 FROM t_gl_acctcussenthistory k2                                                    \r\n                                WHERE k2.fvoucherasstidid = k.fcussentidid AND k2.fcussentidid = k.fvoucherasstidid             \r\n                                  AND k2.fvchdate > " + this.getDay(_dayIndex) + ")                                                  \r\n                   AND EXISTS (SELECT 1 FROM t_gl_acctcussent cuss inner join t_gl_voucherassistrecord r on cuss.FVchAssistRecordID = r.fid             \r\n                                WHERE k.FCussentidID = cuss.fid AND (r." + this.strDateType + " < " + this.getDay(_day1) + " or r." + this.strDateType + " is null))   \r\n                       )                                                                                                        \r\n              GROUP BY k.fcussentidid)                                                                                          \r\n     ,0)                                                                                                                        \r\n";
                        DbUtil.execute((Context)ctx, (String)sql);
                        sql = "UPDATE " + historyTempateTable + " SET sum" + (i8 + 1) + " = sum" + (i8 + 1) + "                                                             \r\n + ISNULL((SELECT (SUM (CASE WHEN v.fbookeddate > " + this.getDay(_dayIndex) + "                                                     \r\n                                     THEN -1 * (e.fentrydc * 2 - 1) * ACCOUNT.fdc * cuss.funverifiedamtfor ELSE 0 END ))        \r\n               FROM t_gl_acctcussent cuss INNER JOIN t_gl_voucherassistrecord ass ON ass.fid = cuss.fvchassistrecordid          \r\n                    INNER JOIN t_gl_voucherentry e ON e.fid = ass.fentryid                                                      \r\n                    INNER JOIN t_gl_voucher v ON v.fid = e.fbillid and v.fid = ass.fbillid                                      \r\n                    INNER JOIN t_bd_accountview ACCOUNT ON ACCOUNT.fid = e.faccountid and ACCOUNT.fcompanyid = v.fcompanyid     \r\n              WHERE cuss.fid = " + historyTempateTable + ".fcussentid " + (isAccountList ? "" : " and cuss.faccountid in (" + accountid + ")") + " and v.fcompanyid = '" + _company.getId().toString() + "' and (ass." + this.strDateType + " < " + this.getDay(_day1) + " or ass." + this.strDateType + " is null)   \r\n           group by cuss.fid                                                                                                    \r\n           ),0)                                                                                                                 \r\n";
                        DbUtil.execute((Context)ctx, (String)sql);
                    }
                    sumstr = "leftamount,sumall,";
                    for (int i4 = 0; i4 <= daylen - 1; ++i4) {
                        sumstr = sumstr + "sum" + i4 + ",";
                    }
                    sumstr = sumstr + "sum" + daylen;
                    historySql.append(" union all SELECT " + (selecthgoutside.length() > 0 ? selecthgoutside.toString() + "," : "") + sumstr + " from " + historyTempateTable);
                }
                catch (SQLException ex) {
                    throw new BOSException((Throwable)ex);
                }
                SQLUtils.cleanup((Statement)ps, (Connection)con);
            }
            if (!includeInit) {
                merge.append("(select ").append(sum).append(",").append(selecthgoutside).append(" from (").append(sql1).append(" union all ").append(sql3).append(includeVerifyVoucher).append(historySql).append(") t  group by " + selecthgoutside + ") ");
            } else {
                merge.append("(select ").append(sum).append(",").append(selecthgoutside).append(" from (").append(sql1).append(" union all ").append(sql2).append(" union all ").append(sql3).append(historySql).append(includeVerifyVoucher).append(") t  group by " + selecthgoutside + ") ");
            }
            merge.append(" tempa");
            orderby = new StringBuffer(" order by ").append(orderby);
            orderby.append(" fcurrid");
            if (isAccountList || allCurr) {
                // empty if block
            }
            BigDecimal zero = new BigDecimal("0");
            ArrayList params = new ArrayList();
            SqlParams spp = new SqlParams();
            con = GetConnection.exec(ctx);
            ps = con.prepareStatement(merge.toString());
            int index = 1;
            boolean setCurrency = !general && !allCurr;
            index = this.setupParams(false, null, currencyid, endDate, companyid, isAccountList, accountFromNumber, accountToNumber, setCurrency, alDates, cal, alNumbers, ps, params, index, null, spp);
            if (includeInit) {
                index = this.setupParams(true, null, currencyid, endDate, companyid, isAccountList, accountFromNumber, accountToNumber, setCurrency, alDates, cal, alNumbers, ps, params, index, null, spp);
            }
            index = this.setupLeftParam(null, currencyid, companyid, isAccountList, accountFromNumber, accountToNumber, setCurrency, alNumbers, ps, params, index, null, spp);
            if (!isInTimeVerify && includeVerifyVch) {
                index = this.setupParams(false, null, currencyid, endDate, companyid, isAccountList, accountFromNumber, accountToNumber, setCurrency, alDates, cal, alNumbers, ps, params, index, null, spp);
                index = this.setupLeftParam(null, currencyid, companyid, isAccountList, accountFromNumber, accountToNumber, setCurrency, alNumbers, ps, params, index, null, spp);
            }
            totalSum = new StringBuffer();
            totalSum.append(merge);
            totalSum.append("\r\n union all select  ");
            for (int i9 = 0; i9 < alFields.size(); ++i9) {
                totalSum.append(" '").append(maxChar).append("' ");
                totalSum.append("T" + i9 + alFields.get(i9).toString());
                totalSum.append(",");
                totalSum.append(" N'").append(maxChar).append("' ");
                totalSum.append("T" + i9 + "fnumber ");
                totalSum.append(",");
                totalSum.append(" N'").append(maxChar).append("' ");
                totalSum.append("T" + i9 + "fname ");
                totalSum.append(",");
                if (isAccountList) break;
            }
            if (isAccountBC && !isAccountNoBC) {
                totalSum.append(" '").append(maxChar).append("' ");
                totalSum.append("Taccountid");
                totalSum.append(",");
                totalSum.append(" N'").append(maxChar).append("' ");
                totalSum.append("T0fnumber ");
                totalSum.append(",");
                totalSum.append(" N'").append(maxChar).append("' ");
                totalSum.append("T0fname ");
                totalSum.append(",");
            }
            totalSum.append(" '").append(maxChar).append("' fcurrid, N'' fcurrname, ");
            totalSum.append("hgid,acct_id,acct_number, ");
            StringBuffer _tempSum = new StringBuffer("sum(sum1) sum1");
            for (int i10 = 1; i10 < daylen; ++i10) {
                _tempSum.append(",sum(sum" + (i10 + 1) + ") as sum" + (i10 + 1));
            }
            totalSum.append("sum(sumall) sumall,sum(sumunoverdue) sumunoverdue,sum(sumoverdue) sumoverdue,sum(sum0) sum0," + _tempSum + " from(");
            totalSum.append(merge);
            totalSum.append(") a group by fcurrid, fcurrname ");
            totalSum.append(" ,hgid,acct_id,acct_number ");
            totalSum.append(orderby);
            if (isAccountList || allCurr) {
                rs = ps.executeQuery();
                if (this.debugModel != null && this.debugModel.meet()) {
                    this.debugModel.record(merge.toString(), spp.getParams());
                }
            } else {
                params.addAll(params);
                rs = DbUtil.executeQuery((Context)ctx, (String)totalSum.toString(), (Object[])params.toArray());
                if (this.debugModel != null && this.debugModel.meet()) {
                    this.debugModel.record(totalSum.toString(), params.toArray());
                }
            }
            String curreName = "";
            while (rs.next()) {
                int length;
                ArrayList<Object> line = new ArrayList<Object>();
                BalanceInfoByAge balance = new BalanceInfoByAge();
                int size = alTables.size();
                if (isAccountList && !isBizCode) {
                    size = 1;
                } else if (isBizCode && hmItems.size() != 0) {
                    if (rs.getString("fcurrid").equals(maxChar)) {
                        line.add(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"35_RptAsstactGGUI", (Locale)ctx.getLocale()));
                    } else {
                        line.add(rs.getString("T0fnumber") + this.strSeperatorNumName + rs.getString("T0fname"));
                    }
                }
                for (int i12 = 0; i12 < size; ++i12) {
                    String numkey = "T" + i12 + "fnumber";
                    String namekey = "T" + i12 + "fname";
                    if (!rs.getString("fcurrid").equals(maxChar)) continue;
                    line.add(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"35_RptAsstactGGUI", (Locale)ctx.getLocale()));
                }
                if (rs.getString("fcurrname") == null || rs.getString("fcurrname").length() == 0) {
                    if (hmItems.size() == 0 || isAccountBC) {
                        line.add(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"35_RptAsstactGGUI", (Locale)ctx.getLocale()));
                    } else {
                        line.add(curreName);
                    }
                } else {
                    curreName = rs.getString("fcurrname");
                    line.add(curreName);
                }
                line.add(rs.getBigDecimal("sumall"));
                line.add(rs.getBigDecimal("sumunoverdue"));
                BigDecimal sumoverdue = rs.getBigDecimal("sumoverdue");
                line.add(sumoverdue);
                BigDecimal[] itemBigdecimal = new BigDecimal[daylen + 1];
                for (int i11 = 0; i11 < daylen + 1; ++i11) {
                    itemBigdecimal[i11] = rs.getBigDecimal("sum" + i11);
                }
                int i5 = 0;
                int innerlength = length = itemBigdecimal.length;
                while (i5 < length) {
                    innerlength = length - 1;
                    BigDecimal tempate = itemBigdecimal[length - 1];
                    if (sumoverdue != null && tempate != null && tempate.compareTo(zero) != 0) {
                        for (int j = 0; j < innerlength; ++j) {
                            itemBigdecimal[length - 1] = j == 0 ? sumoverdue.subtract(itemBigdecimal[j]) : itemBigdecimal[length - 1].subtract(itemBigdecimal[j]);
                        }
                        break;
                    }
                    --length;
                }
                length = itemBigdecimal.length;
                for (int i4 = 0; i4 < length; ++i4) {
                    line.add(itemBigdecimal[i4]);
                }
                balance.setBalance(rs.getBigDecimal("sumall"));
                balance.setUnOverDueBalance(rs.getBigDecimal("sumunoverdue"));
                balance.setOverDueBalance(sumoverdue);
                balance.setAgeBalances(itemBigdecimal);
                if (isAccountList) {
                    line.add(rs.getString("hgid"));
                    balance.setCurrentHG(rs.getString("hgid"));
                }
                try {
                    line.add(rs.getString("acct_id"));
                    line.add(rs.getString("acct_number"));
                    balance.setAcctId(rs.getString("acct_id"));
                    balance.setAcctNumber(rs.getString("acct_number"));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                balance.setAgeArea(days);
                result.add(balance);
            }
            if (historyTempateTable != null) {
                DbUtil.execute((Context)ctx, (String)("drop table " + historyTempateTable));
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)con);
        }
        catch (SQLException sqle) {
            throw new SQLAccessException(new SQLException(totalSum.toString() + "======="));
        }
        try {
            TempTablePool.getInstance((Context)ctx).releaseTable(tempTable);
            if (historyTempateTable == null) return result;
            TempTablePool.getInstance((Context)ctx).releaseTable(historyTempateTable);
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            return result;
        }
        finally {
            SQLUtils.cleanup(rs, ps, con);
            try {
                TempTablePool.getInstance((Context)ctx).releaseTable(tempTable);
                if (historyTempateTable != null) {
                    TempTablePool.getInstance((Context)ctx).releaseTable(historyTempateTable);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private StringBuffer queryBizCodeHgid(Context ctx, String accountid, String bizCodeFromNumber, String bizCodeToNumber, boolean isUnion, String companyId) throws EASBizException, BOSException {
        StringBuffer queryBizCodeHgid = new StringBuffer();
        String loc = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        if (isUnion) {
            queryBizCodeHgid.append("(select distinct * from (select hg.fid,bac.fid bacid,bac.fnumber bacnumber,bac.fname_").append(loc).append(" bacname  from t_bd_assistanthg hg inner join t_bd_customer cst on hg.fcustomerid = cst.fid  inner join T_BD_BizAnaylysisCode bac on bac.fid = cst.FBizAnalysisCodeID ");
            queryBizCodeHgid.append(" where bac.fadmincuid in  (select fcontrolunitid from t_org_company where fid in (").append(companyId).append(")) ");
            if (accountid != null) {
                queryBizCodeHgid.append(" and bac.fnumber = '");
                queryBizCodeHgid.append(accountid).append("'");
            }
            if (bizCodeFromNumber != null) {
                queryBizCodeHgid.append(" and bac.fnumber >= '");
                queryBizCodeHgid.append(bizCodeFromNumber).append("'");
            }
            if (bizCodeToNumber != null) {
                queryBizCodeHgid.append(" and bac.fnumber < '");
                queryBizCodeHgid.append(bizCodeToNumber).append("~'");
            }
            queryBizCodeHgid.append("\r\n union all ");
            queryBizCodeHgid.append("select hg1.fid,bac.fid bacid,bac.fnumber bacnumber,bac.fname_").append(loc).append(" bacname  from t_bd_assistanthg hg1 inner join T_BD_Supplier sup on hg1.FProviderID = sup.fid  inner join T_BD_BizAnaylysisCode bac on bac.fid = sup.FBizAnalysisCodeID ");
            queryBizCodeHgid.append(" where bac.fadmincuid in  (select fcontrolunitid from t_org_company where fid in(").append(companyId).append(")) ");
            if (accountid != null) {
                queryBizCodeHgid.append(" and bac.fnumber = '");
                queryBizCodeHgid.append(accountid).append("'\r\n");
            }
            if (bizCodeFromNumber != null) {
                queryBizCodeHgid.append(" and bac.fnumber >= '");
                queryBizCodeHgid.append(bizCodeFromNumber).append("'");
            }
            if (bizCodeToNumber != null) {
                queryBizCodeHgid.append(" and bac.fnumber < '");
                queryBizCodeHgid.append(bizCodeToNumber).append("~'");
            }
            queryBizCodeHgid.append(") T_Hgid0)  T_Hgid ");
        } else {
            String[] accountids = accountid == null ? null : accountid.split(",");
            String id = "";
            companyId = this.getCurrentCompany(ctx).getCU().getId().toString();
            if (accountids != null) {
                for (int i = 0; i < accountids.length; ++i) {
                    id = id + "'" + accountids[i] + "',";
                }
                id = id.substring(0, id.length() - 1);
            }
            queryBizCodeHgid.append("(select distinct * from (select hg.fid fid,bac.fid bacid,bac.fnumber bacnumber,bac.fname_").append(loc).append(" bacname from t_bd_assistanthg hg inner join t_bd_customer cst on hg.fcustomerid = cst.fid inner join T_BD_BizAnaylysisCode bac on bac.fid = cst.FBizAnalysisCodeID ");
            queryBizCodeHgid.append(" where   ").append(BizAnalysisCodeFactory.getLocalInstance((Context)ctx).getDatabaseDFilter((IObjectPK)new ObjectUuidPK(companyId), "bac.fid", "bac.fadmincuid"));
            if (!id.equals("")) {
                queryBizCodeHgid.append("and cst.FBizAnalysisCodeID in (");
                queryBizCodeHgid.append(id).append(")");
            }
            if (bizCodeFromNumber != null) {
                queryBizCodeHgid.append(" and bac.fnumber >= '");
                queryBizCodeHgid.append(bizCodeFromNumber).append("'");
            }
            if (bizCodeToNumber != null) {
                queryBizCodeHgid.append(" and bac.fnumber < '");
                queryBizCodeHgid.append(bizCodeToNumber).append("~'");
            }
            queryBizCodeHgid.append("\r\n union all ");
            queryBizCodeHgid.append("select hg1.fid fid,bac.fid bacid,bac.fnumber bacnumber,bac.fname_").append(loc).append(" bacname  from t_bd_assistanthg hg1 inner join T_BD_Supplier sup on hg1.FProviderID = sup.fid inner join T_BD_BizAnaylysisCode bac on bac.fid = sup.FBizAnalysisCodeID ");
            queryBizCodeHgid.append(" where  ").append(BizAnalysisCodeFactory.getLocalInstance((Context)ctx).getDatabaseDFilter((IObjectPK)new ObjectUuidPK(companyId), "bac.fid", "bac.fadmincuid"));
            if (!id.equals("")) {
                queryBizCodeHgid.append("and sup.FBizAnalysisCodeID in (");
                queryBizCodeHgid.append(id).append(")");
            }
            if (bizCodeFromNumber != null) {
                queryBizCodeHgid.append(" and bac.fnumber >= '");
                queryBizCodeHgid.append(bizCodeFromNumber).append("'");
            }
            if (bizCodeToNumber != null) {
                queryBizCodeHgid.append(" and bac.fnumber < '");
                queryBizCodeHgid.append(bizCodeToNumber).append("~'");
            }
            queryBizCodeHgid.append("\r\n)T_Hgid0) T_Hgid ");
        }
        return queryBizCodeHgid;
    }

    private int setupLeftParam(String accountid, String currencyid, String companyid, boolean isAccountList, String accountFromNumber, String accountToNumber, boolean setCurrency, ArrayList alNumbers, PreparedStatement ps, List params, int index, String accountViewNumber, SqlParams spp) throws SQLException {
        for (String number : alNumbers) {
            spp.setString(index, number);
            ps.setString(index++, number);
            params.add(number);
        }
        if (!isAccountList && accountViewNumber == null && accountid != null) {
            spp.setString(index, accountid);
            ps.setString(index++, accountid);
            params.add(accountid);
        }
        if (companyid != null && companyid.length() > 0) {
            spp.setString(index, companyid);
            ps.setString(index++, companyid);
            params.add(companyid);
        }
        if (setCurrency) {
            spp.setString(index, currencyid);
            ps.setString(index++, currencyid);
            params.add(currencyid);
        }
        if (isAccountList) {
            if (accountFromNumber != null) {
                spp.setString(index, accountFromNumber);
                ps.setString(index++, accountFromNumber);
                params.add(accountFromNumber);
            }
            if (accountToNumber != null) {
                spp.setString(index, accountToNumber + "zzzzzz");
                ps.setString(index++, accountToNumber + "zzzzzz");
                params.add(accountToNumber + "zzzzzz");
            }
        }
        return index;
    }

    private int setupParams(boolean isInitParam, String accountid, String currencyid, java.util.Date endDate, String companyid, boolean isAccountList, String accountFromNumber, String accountToNumber, boolean setCurrency, ArrayList alDates, Calendar cal, ArrayList alNumbers, PreparedStatement ps, List params, int index, String accountViewNumber, SqlParams spp) throws SQLException {
        for (Date date : alDates) {
            spp.setDate(index, date);
            ps.setDate(index++, date);
            params.add(date);
        }
        for (String number : alNumbers) {
            spp.setString(index, number);
            ps.setString(index++, number);
            params.add(number);
        }
        if (isInitParam) {
            cal.add(14, -1);
            cal.add(5, 1);
        }
        cal.setTime(endDate);
        spp.setDate(index, new Date(cal.getTimeInMillis()));
        ps.setDate(index++, new Date(cal.getTimeInMillis()));
        params.add(new Date(cal.getTimeInMillis()));
        if (!isAccountList && accountViewNumber == null && accountid != null) {
            spp.setString(index, accountid);
            ps.setString(index++, accountid);
            params.add(accountid);
        }
        if (companyid != null && companyid.length() > 0) {
            spp.setString(index, companyid);
            ps.setString(index++, companyid);
            params.add(companyid);
        }
        if (setCurrency) {
            spp.setString(index, currencyid);
            ps.setString(index++, currencyid);
            params.add(currencyid);
        }
        if (isAccountList) {
            if (accountFromNumber != null) {
                spp.setString(index, accountFromNumber);
                ps.setString(index++, accountFromNumber);
                params.add(accountFromNumber);
            }
            if (accountToNumber != null) {
                spp.setString(index, accountToNumber + "zzzzzz");
                ps.setString(index++, accountToNumber + "zzzzzz");
                params.add(accountToNumber + "zzzzzz");
            }
        }
        return index;
    }

    private StringBuffer queryVerifyVoucher(Context ctx, boolean allCurr, int[] days, boolean isAccountList, String accountid, String acctTableId, Map accountParams, StringBuffer selecthg, StringBuffer innerJoin, StringBuffer groupby, String curCompanyid, String tempTable, String currencyid, boolean isBizCode, boolean isAccountBC, String bizCodeFromNumber, String bizCodeToNumber, String companyid, java.util.Date historyDate) throws EASBizException, BOSException {
        String _historydate;
        boolean general = false;
        if (CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString().equals(currencyid) || CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString().equals(currencyid)) {
            general = true;
        }
        String amountField = "(CASE WHEN h.foroginalamount IS NULL THEN assist.foriginalamount ELSE (assist.foriginalamount - h.foroginalamount) END )";
        if (CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString().equals(currencyid)) {
            amountField = amountField + "*(case when( " + tempTable + ".FCONVERTRATEA is null ) then 1 else " + tempTable + ".FCONVERTRATEA end )";
        }
        StringBuffer sum = new StringBuffer("0 as leftamount, sum((entry.fentrydc*2-1)*account.fdc*").append(amountField).append(") as sumall");
        StringBuffer leftsum = new StringBuffer("(-1)*sum(").append(amountField).append(") as leftamount, 0 as sumall");
        int daylen = days.length;
        sum.append(" ,sum(case when assist." + this.strDateType + ">? then (entry.fentrydc*2-1)*account.fdc*").append(amountField).append(" else 0 end) as sum0");
        leftsum.append(" ,0 as sum0");
        for (int i = 1; i < daylen; ++i) {
            sum.append(" ,sum(case when assist." + this.strDateType + "<=? and assist." + this.strDateType + ">? then (entry.fentrydc*2-1)*account.fdc*").append(amountField).append(" else 0 end) as sum").append(i);
            leftsum.append(" ,0 as sum").append(i);
        }
        sum.append(" ,sum(case when assist." + this.strDateType + "<=? then (entry.fentrydc*2-1)*account.fdc*").append(amountField).append(" else 0 end) as sum").append(daylen);
        leftsum.append(" ,0 as sum").append(daylen);
        StringBuffer from = new StringBuffer();
        from.append(" from t_gl_voucherassistrecord assist join t_gl_voucherentry entry on assist.fentryid=entry.fid ");
        from.append(" join t_gl_voucher voucher on entry.fbillid=voucher.fid ");
        Calendar _cal = Calendar.getInstance();
        _cal.setTime(historyDate == null ? new java.util.Date() : historyDate);
        _cal.add(5, 1);
        _cal.add(14, -1);
        String string = _historydate = historyDate == null ? null : this.getDay(_cal.getTime());
        if (historyDate == null) {
            from.append(" left outer join (select fvoucherasstidid, sum(foroginalamount) foroginalamount from t_gl_acctcussenthistory group by fvoucherasstidid) h on assist.fid =h.fvoucherasstidid ");
        } else {
            from.append(" left outer join (select ih.fvoucherasstidid fvoucherasstidid, sum(ih.foroginalamount) foroginalamount from t_gl_acctcussenthistory ih ");
            from.append("where (ih.FDC=3 and exists (select 1 from t_gl_acctcussenthistory k where k.FVoucherAsstIDID=ih.FCussentidID and k.FCussentidID=ih.FVoucherAsstIDID and (k.FVchDate is null or k.FVchDate<=" + _historydate + ")) ");
            from.append("OR ih.FDC in (0,2) and (ih.FVchDate is null or ih.FVchDate <=" + _historydate + ")) ");
            from.append("and ih.fcompanyid =  '" + curCompanyid + "' ");
            from.append("group by ih.fvoucherasstidid) h on assist.fid =h.fvoucherasstidid ");
        }
        from.append(" join t_bd_accountview account on entry.faccountid=account.fid ");
        from.append(" join t_bd_Currency currency on entry.fcurrencyid=currency.fid ");
        from.append(" left join " + tempTable + " on " + tempTable + ".fid = currency.fid ");
        from.append(" join t_bd_assistanthg hg on assist.fassgrpid=hg.fid ");
        if (isAccountBC) {
            from.append("\r\n inner join ").append(this.queryBizCodeHgid(ctx, null, bizCodeFromNumber, bizCodeToNumber, false, companyid)).append(" on hg.fid = T_Hgid.fid ");
        } else if (isBizCode) {
            from.append("\r\n inner join ").append(this.queryBizCodeHgid(ctx, accountid, bizCodeFromNumber, bizCodeToNumber, false, companyid)).append(" on hg.fid = T_Hgid.fid ");
        }
        from.append("inner join v_gl_acperiod acperiod on acperiod.fperiodid=voucher.fperiodid and acperiod.fcompanyid=voucher.fcompanyid ");
        StringBuffer where = new StringBuffer();
        where.append(" where assist." + this.strDateType + "<? ");
        if (isAccountList) {
            where.append(" and account.FAccountTableID='" + acctTableId + "' ");
            if (isBizCode) {
                // empty if block
            }
        } else {
            where.append(" and entry.faccountid in (" + accountid + ") ");
        }
        if (historyDate == null) {
            where.append(" and voucher.fcompanyid=? and voucher.FBizStatus<>0 and voucher.FBizStatus<>2 and entry.FIsVerify = 1 and assist.FIsVierified = 0 ");
        } else {
            where.append(" and voucher.fcompanyid=? and voucher.FBizStatus<>0 and voucher.FBizStatus<>2 and entry.FIsVerify = 1 ");
        }
        if (!general && !allCurr) {
            where.append(" and entry.fcurrencyid=? ");
        }
        if (isAccountList) {
            this.buildAccountSql(where, accountParams, "account.fnumber");
        }
        if (_historydate != null) {
            where.append(" and voucher.FBookedDate<=" + _historydate + " ");
        }
        StringBuffer leftWhere = new StringBuffer();
        if (historyDate == null) {
            leftWhere.append(" where voucher.FBizStatus<>0 and voucher.FBizStatus<>2 and entry.FIsVerify = 1 and assist.FIsVierified = 0 ");
        } else {
            leftWhere.append(" where voucher.FBizStatus<>0 and voucher.FBizStatus<>2 and entry.FIsVerify = 1 ");
        }
        if (isAccountList) {
            leftWhere.append(" and account.FAccountTableID='" + acctTableId + "' ");
            if (isBizCode) {
                // empty if block
            }
        } else {
            leftWhere.append(" and entry.faccountid in (" + accountid + ") ");
        }
        leftWhere.append(" and voucher.fcompanyid=?  ");
        if (!general && !allCurr) {
            leftWhere.append(" and entry.fcurrencyid=? ");
        }
        if (isAccountList) {
            this.buildAccountSql(leftWhere, accountParams, "account.fnumber");
        }
        if (_historydate != null) {
            leftWhere.append(" and voucher.FBookedDate<=" + _historydate + " ");
        }
        StringBuffer result = new StringBuffer(" union all select ").append(selecthg).append(sum).append(from).append(innerJoin).append(where).append(groupby);
        result.append(" union all select ").append(selecthg).append(leftsum).append(from).append(innerJoin).append(leftWhere).append(groupby);
        return result;
    }

    private StringBuffer queryVerifyVoucherOnlyUnion(Context ctx, boolean allCurr, int[] days, boolean isAccountList, String accountid, String acctTableId, Map accountParams, StringBuffer selecthg, StringBuffer innerJoin, StringBuffer groupby, String curCompanyid, boolean isfirstload, String companyids, Object accountViewNumber, String tempTable, String currencyid, boolean isBizCode, boolean isAccountBC, String bizCodeFromNumber, String bizCodeToNumber) throws EASBizException, BOSException {
        boolean general = false;
        if (CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString().equals(currencyid) || CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString().equals(currencyid)) {
            general = true;
        }
        String amountField = "(CASE WHEN h.foroginalamount IS NULL THEN assist.foriginalamount ELSE (assist.foriginalamount - h.foroginalamount) END )";
        if (CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString().equals(currencyid)) {
            amountField = amountField + "*(case when( " + tempTable + ".FCONVERTRATEA is null ) then 1 else " + tempTable + ".FCONVERTRATEA end )";
        }
        StringBuffer sum = new StringBuffer("0 as leftamount, sum((entry.fentrydc*2-1)*account.fdc*").append(amountField).append(") as sumall");
        StringBuffer leftsum = new StringBuffer("(-1)*sum(").append(amountField).append(") as leftamount, 0 as sumall");
        int daylen = days.length;
        sum.append(" ,sum(case when assist." + this.strDateType + ">? then (entry.fentrydc*2-1)*account.fdc*").append(amountField).append(" else 0 end) as sum0");
        leftsum.append(" ,0 as sum0");
        for (int i = 1; i < daylen; ++i) {
            sum.append(" ,sum(case when assist." + this.strDateType + "<=? and assist." + this.strDateType + ">? then (entry.fentrydc*2-1)*account.fdc*").append(amountField).append(" else 0 end) as sum").append(i);
            leftsum.append(" ,0 as sum").append(i);
        }
        sum.append(" ,sum(case when assist." + this.strDateType + "<=? then (entry.fentrydc*2-1)*account.fdc*").append(amountField).append(" else 0 end) as sum").append(daylen);
        leftsum.append(" ,0 as sum").append(daylen);
        StringBuffer from = new StringBuffer();
        from.append(" from t_gl_voucherassistrecord assist join t_gl_voucherentry entry on assist.fentryid=entry.fid ");
        from.append(" join t_gl_voucher voucher on entry.fbillid=voucher.fid ");
        from.append(" left outer join (select fvoucherasstidid, sum(foroginalamount) foroginalamount from t_gl_acctcussenthistory group by fvoucherasstidid) h on assist.fid =h.fvoucherasstidid ");
        from.append(" join t_bd_accountview account on entry.faccountid=account.fid ");
        from.append(" join t_bd_Currency currency on entry.fcurrencyid=currency.fid ");
        from.append(" left join " + tempTable + " on " + tempTable + ".fid = currency.fid ");
        from.append(" join t_bd_assistanthg hg on assist.fassgrpid=hg.fid ");
        if (isAccountBC) {
            from.append("\r\n inner join ").append(this.queryBizCodeHgid(ctx, null, bizCodeFromNumber, bizCodeToNumber, false, companyids)).append(" on hg.fid = T_Hgid.fid ");
        } else if (isBizCode) {
            from.append("\r\n inner join ").append(this.queryBizCodeHgid(ctx, accountid, bizCodeFromNumber, bizCodeToNumber, false, companyids)).append(" on hg.fid = T_Hgid.fid ");
        }
        from.append(" inner join t_org_company company on voucher.fcompanyid = company.fid ");
        from.append(" inner join t_org_company sumcompany on charindex(sumcompany.FLongNumber ||'!',company.FLongNumber || '!') = 1");
        from.append("inner join v_gl_acperiod acperiod on acperiod.fperiodid=voucher.fperiodid and acperiod.fcompanyid=voucher.fcompanyid ");
        StringBuffer where = new StringBuffer();
        where.append(" where assist." + this.strDateType + "<? ");
        if (isAccountList) {
            where.append(" and account.FAccountTableID='" + acctTableId + "' ");
            if (isBizCode) {
                // empty if block
            }
        } else if (accountViewNumber == null) {
            where.append(" and entry.faccountid=? ");
        } else {
            where.append(" and account.fnumber = '").append(accountViewNumber).append("' ");
        }
        where.append(" and voucher.FBizStatus<>0 and voucher.FBizStatus<>2 and entry.FIsVerify = 1 and assist.FIsVierified = 0 ");
        if (!general && !allCurr) {
            where.append(" and entry.fcurrencyid=? ");
        }
        where.append(" and company.fid in ( ").append(companyids).append(" ) and sumcompany");
        if (isfirstload) {
            where.append(".fid in (");
        } else {
            where.append(".fparentid in (");
        }
        where.append(curCompanyid).append(") ");
        if (isAccountList) {
            this.buildAccountSql(where, accountParams, "account.fnumber");
        }
        StringBuffer leftWhere = new StringBuffer();
        leftWhere.append(" where voucher.FBizStatus<>0 and voucher.FBizStatus<>2 and entry.FIsVerify = 1 and assist.FIsVierified = 0 ");
        if (isAccountList) {
            leftWhere.append(" and account.FAccountTableID='" + acctTableId + "' ");
            if (isBizCode) {
                // empty if block
            }
        } else if (accountViewNumber == null) {
            leftWhere.append(" and entry.faccountid=? ");
        } else {
            leftWhere.append(" and account.fnumber = '").append(accountViewNumber).append("' ");
        }
        leftWhere.append(" \r\n and company.fid in ( ").append(companyids).append(" ) and sumcompany");
        if (isfirstload) {
            leftWhere.append(".fid in (");
        } else {
            leftWhere.append(".fparentid in (");
        }
        leftWhere.append(curCompanyid).append(") ");
        if (!general && !allCurr) {
            leftWhere.append(" and entry.fcurrencyid=? ");
        }
        if (isAccountList) {
            this.buildAccountSql(leftWhere, accountParams, "account.fnumber");
        }
        StringBuffer result = new StringBuffer(" union all select ").append(selecthg).append(sum).append(from).append(innerJoin).append(where).append(groupby);
        result.append(" union all select ").append(selecthg).append(leftsum).append(from).append(innerJoin).append(leftWhere).append(groupby);
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ArrayList queryAgeByAcctIntimeHistory(Context ctx, String accountid, String currencyid, int[] days, HashMap hmItems, java.util.Date endDate, boolean includeUnPosted, boolean includeInit, String companyid, int dateType, int indexType, Object accountFrom, Object accountTo, boolean includeVerifyVch, boolean isBizCode, java.util.Date historyDate) throws EASBizException, BOSException {
        String acctTableId;
        boolean allCurr;
        StringBuffer selecthgoutside;
        boolean general;
        String amountField;
        String loc;
        Map accountParams;
        String bizCodeToNumber;
        String bizCodeFromNumber;
        boolean isAccountNoBC;
        boolean isAccountBC;
        boolean isAccountList;
        String tempTable;
        ArrayList<BalanceInfoByAge> result;
        String maxChar;
        block119: {
            PeriodInfo _period;
            int i;
            Object[] v;
            maxChar = GlUtils.getMaxChar();
            result = new ArrayList<BalanceInfoByAge>();
            tempTable = null;
            isAccountList = indexType == 1;
            isAccountBC = !isAccountList && isBizCode;
            isAccountNoBC = isAccountBC && hmItems.size() == 0;
            String accountFromNumber = "";
            String accountToNumber = "";
            bizCodeFromNumber = null;
            bizCodeToNumber = null;
            if (accountFrom instanceof AccountViewInfo) {
                accountFromNumber = ((AccountViewInfo)accountFrom).getNumber();
            } else if (accountFrom instanceof Object[]) {
                v = (Object[])accountFrom;
                accountFromNumber = "";
                for (i = 0; i < v.length; ++i) {
                    accountFromNumber = accountFromNumber + ((AccountViewInfo)v[i]).getNumber() + ";";
                }
            } else {
                accountFromNumber = (String)accountFrom;
            }
            if (accountTo instanceof AccountViewInfo) {
                accountToNumber = ((AccountViewInfo)accountTo).getNumber();
            } else if (accountTo instanceof Object[]) {
                v = (Object[])accountTo;
                accountToNumber = "";
                for (i = 0; i < v.length; ++i) {
                    accountToNumber = accountToNumber + ((AccountViewInfo)v[i]).getNumber() + ";";
                }
            } else {
                accountToNumber = (String)accountTo;
            }
            accountParams = this.getAccountParam(accountFromNumber, accountToNumber);
            endDate = DateTimeUtils.truncateDate((java.util.Date)endDate);
            historyDate = DateTimeUtils.truncateDate((java.util.Date)historyDate);
            this.enterDateType(dateType);
            loc = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
            amountField = null;
            general = true;
            selecthgoutside = new StringBuffer();
            allCurr = false;
            if (currencyid.equals("all")) {
                allCurr = true;
            }
            CompanyOrgUnitInfo _company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyid));
            acctTableId = null;
            if (historyDate == null) {
                acctTableId = _company.getAccountTable().getId().toString();
            } else {
                _period = PeriodUtils.getPeriodInfo((Context)ctx, (java.util.Date)historyDate, (CompanyOrgUnitInfo)_company);
                int _periodYear = _period == null ? historyDate.getYear() + 1900 : _period.getPeriodYear();
                int _periodNumber = _period == null ? (historyDate.getMonth() + 3) / 3 : _period.getPeriodNumber();
                acctTableId = AccountTools.getCurrentAcctTable((Context)ctx, (String)_company.getCU().getId().toString(), (String)_company.getAccountTable().getId().toString(), (int)_periodYear, (int)_periodNumber);
            }
            if (CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString().equals(currencyid)) {
                tempTable = this.creatAdjexchTempTable(ctx, historyDate);
            }
            if (includeUnPosted) {
                amountField = "cussent.funholdedAmtFor + case when t.sumoro is null then 0 else t.sumoro end";
                if (CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString().equals(currencyid)) {
                    amountField = "(cussent.funholdedAmtfor + case when t.sumoro is null then 0 else t.sumoro end) * (case when( " + tempTable + ".FCONVERTRATEA is null ) then 1 else " + tempTable + ".FCONVERTRATEA end )";
                } else if (CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString().equals(currencyid)) {
                    amountField = "cussent.funholdedAmtRpt + case when t.sumoro is null then 0 else t.sumoro end";
                } else {
                    general = false;
                }
            } else {
                amountField = "(cussent.funVerifiedAmtFor + case when t.sumoro is null then 0 else t.sumoro end)";
                if (CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString().equals(currencyid)) {
                    amountField = "(cussent.funVerifiedAmtFor + case when t.sumoro is null then 0 else t.sumoro end) * (case when( " + tempTable + ".FCONVERTRATEA is null ) then 1 else " + tempTable + ".FCONVERTRATEA end )";
                } else if (CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString().equals(currencyid)) {
                    amountField = "cussent.funVerifiedAmtRpt + case when t.sumoro is null then 0 else t.sumoro end";
                } else {
                    general = false;
                }
            }
            if (days != null && days.length >= 1) break block119;
            _period = null;
            if (tempTable == null) return _period;
            TempTablePool.getInstance((Context)ctx).releaseTable(tempTable);
            return _period;
        }
        try {
            int i;
            int i2;
            Iterator itemkeyit = hmItems.keySet().iterator();
            if (isBizCode) {
                while (itemkeyit.hasNext()) {
                    HashMap item = (HashMap)itemkeyit.next();
                    String[] numbers = (String[])hmItems.get(item);
                    bizCodeFromNumber = numbers[0];
                    bizCodeToNumber = numbers[1];
                }
            }
            StringBuffer sum = new StringBuffer();
            StringBuffer selecthg = new StringBuffer();
            int daylen = days.length;
            ArrayList<Date> alDates = new ArrayList<Date>(daylen * 2 + 1);
            Calendar cal = Calendar.getInstance();
            sum.append(" sum(").append(amountField).append(") as leftamount");
            sum.append(" ,sum(case when assist." + this.strDateType + ">=?  and assist.").append(this.strDateType).append("<? then (").append(amountField).append(") else 0 end) as sum0");
            cal.setTime(endDate);
            cal.add(14, -1);
            cal.add(5, -1 * days[0]);
            alDates.add(new Date(cal.getTimeInMillis()));
            cal.setTime(endDate);
            alDates.add(new Date(cal.getTimeInMillis()));
            for (int i3 = 1; i3 < daylen; ++i3) {
                sum.append(" ,sum(case when assist.").append(this.strDateType).append("<? and assist.").append(this.strDateType).append(">=? then (").append(amountField).append(") else 0 end) as sum").append(i3);
                cal.setTime(endDate);
                cal.add(14, -1);
                cal.add(5, -1 * days[i3 - 1]);
                alDates.add(new Date(cal.getTimeInMillis()));
                cal.setTime(endDate);
                cal.add(14, -1);
                cal.add(5, -1 * days[i3]);
                alDates.add(new Date(cal.getTimeInMillis()));
            }
            sum.append(" ,sum(case when assist." + this.strDateType + "<? then (").append(amountField).append(") else 0 end) as sum").append(daylen);
            cal.setTime(endDate);
            cal.add(14, -1);
            cal.add(5, -1 * days[daylen - 1]);
            alDates.add(new Date(cal.getTimeInMillis()));
            StringBuffer fromTable = new StringBuffer();
            fromTable.append(" from t_gl_voucherassistrecord assist \r\n");
            fromTable.append(" inner join t_gl_acctcussent cussent on cussent.fvchassistrecordid=assist.fid \r\n");
            fromTable.append(" inner join t_bd_accountview account on cussent.faccountid=account.fid \r\n");
            fromTable.append(" inner join t_bd_Currency currency on cussent.fcurrencyid=currency.fid \r\n");
            if (CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString().equals(currencyid)) {
                fromTable.append(" left join " + tempTable + " on " + tempTable + ".fid = currency.fid \r\n");
            }
            fromTable.append(" inner join t_bd_assistanthg hg on assist.fassgrpid=hg.fid \r\n");
            fromTable.append(" left join t_gl_voucher voucher on assist.fbillid=voucher.fid \r\n");
            if (isBizCode && isAccountList) {
                fromTable.append(" inner join ").append(this.queryBizCodeHgid(ctx, accountid, bizCodeFromNumber, bizCodeToNumber, false, companyid)).append(" on hg.fid = T_Hgid.fid ");
            }
            if (isAccountBC && !isAccountNoBC) {
                fromTable.append(" inner join ").append(this.queryBizCodeHgid(ctx, null, bizCodeFromNumber, bizCodeToNumber, false, companyid)).append(" on hg.fid = T_Hgid.fid ");
            }
            StringBuffer innerJoin = new StringBuffer();
            StringBuffer groupby = new StringBuffer();
            int gi = 0;
            ArrayList<String> alNumbers = new ArrayList<String>();
            ArrayList<String> alTables = new ArrayList<String>();
            ArrayList<String> alFields = new ArrayList<String>();
            int tablei = 0;
            if (isAccountList) {
                groupby.append(" group by ");
                groupby.append("account.FID ,account.Fnumber ,account.fname_").append(loc);
                if (isBizCode) {
                    groupby.append(",bacid");
                }
            }
            if (isAccountBC && !isAccountNoBC) {
                groupby.append(" group by ");
                groupby.append("bacid ").append(",bacnumber , bacname");
            }
            if (!isBizCode) {
                HashMap[] itemList = new HashMap[hmItems.keySet().size()];
                int k = 0;
                while (itemkeyit.hasNext()) {
                    HashMap item = (HashMap)itemkeyit.next();
                    Integer seq = (Integer)item.get("seq");
                    if (seq != null) {
                        itemList[seq.intValue()] = item;
                    } else {
                        itemList[k] = item;
                    }
                    ++k;
                }
                for (int i4 = 0; i4 < itemList.length; ++i4) {
                    HashMap item = itemList[i4];
                    String[] numbers = (String[])hmItems.get(item);
                    String table = (String)item.get("tablename");
                    String field = (String)item.get("fieldname");
                    boolean isGeneralActType = item.get("FGLAsstActTypeGrpID") != null && item.get("propname").toString().startsWith("generalAssActType");
                    boolean isUseLongNumber = (Boolean)item.get("useLongNUmber");
                    alTables.add(table);
                    alFields.add(field);
                    innerJoin.append(" inner join ").append(table).append(" ").append("T").append(tablei).append(" on hg.").append(field).append("=").append("T").append(tablei).append(".fid");
                    if (numbers[0] != null) {
                        innerJoin.append(" and ").append("T").append(tablei);
                        if (!isGeneralActType || !isUseLongNumber) {
                            innerJoin.append(".fnumber>=?");
                            alNumbers.add(numbers[0]);
                        } else {
                            innerJoin.append(".flongnumber>=?");
                            alNumbers.add(numbers[0].replace('.', '!'));
                        }
                    }
                    if (numbers[1] != null) {
                        innerJoin.append(" and ").append("T").append(tablei);
                        if (!isGeneralActType || !isUseLongNumber) {
                            innerJoin.append(".fnumber<=?");
                            alNumbers.add(numbers[1]);
                        } else {
                            innerJoin.append(".flongnumber<=?");
                            alNumbers.add(numbers[1].replace('.', '!'));
                        }
                    }
                    if (!isAccountList) {
                        if (gi == 0) {
                            groupby.append(" group by ");
                        } else {
                            groupby.append(" ,");
                        }
                        selecthg.append("hg.").append(field).append(" as ").append("T").append(tablei).append(field).append(",").append("T").append(tablei).append(".fnumber as ").append("T").append(tablei).append("fnumber,").append("T").append(tablei).append(".fname_").append(loc).append(" as ").append("T").append(tablei).append("fname,");
                        groupby.append("hg.").append(field).append(",").append("T").append(tablei).append(".fnumber,").append("T").append(tablei).append(".fname_").append(loc);
                        selecthgoutside.append("T").append(tablei).append(field).append(",T").append(tablei).append("fnumber,").append("T").append(tablei).append("fname,");
                    } else if (tablei == 0) {
                        selecthgoutside.append("T").append(tablei).append(field).append(",T").append(tablei).append("fnumber,").append("T").append(tablei).append("fname,");
                        selecthg.append("account.FID as T0").append(field).append(",account.Fnumber as T0fnumber,account.fname_").append(loc).append(" as T0fname,");
                    }
                    ++tablei;
                    ++gi;
                }
            } else if (!isAccountBC) {
                selecthgoutside.append("Taccountid").append(",T0fnumber").append(",T0fname,");
                selecthg.append("account.FID as Taccountid").append(",account.Fnumber as T0fnumber,account.fname_").append(loc).append(" as T0fname,");
            } else if (!isAccountNoBC) {
                selecthgoutside.append("Taccountid").append(",T0fnumber").append(",T0fname,");
                selecthg.append("T_Hgid.bacid as Taccountid").append(",T_Hgid.bacnumber as T0fnumber, T_Hgid.bacname as T0fname,");
            }
            if (allCurr) {
                selecthg.append("currency.fid fcurrid,currency.Fname_" + loc + " fcurrname,");
            } else {
                ICurrency icurrency = CurrencyFactory.getLocalInstance((Context)ctx);
                CurrencyInfo currency = icurrency.getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyid));
                selecthg.append("'" + currency.getId() + "' fcurrid,'" + currency.getName() + "' fcurrname,");
            }
            if (isAccountList) {
                if (isBizCode) {
                    selecthg.append("T_Hgid.bacid as hgid,");
                } else {
                    selecthg.append("hg.FID as hgid,");
                }
            }
            selecthgoutside.append("fcurrid,fcurrname,");
            if (isAccountList) {
                selecthgoutside.append("hgid,");
            }
            ArrayList<Object> sqlParams = new ArrayList<Object>();
            for (Date date : alDates) {
                sqlParams.add(date);
            }
            for (String number : alNumbers) {
                sqlParams.add(number);
            }
            StringBuffer hisAgeTableSql = new StringBuffer();
            hisAgeTableSql.append("select cussent.fid as cussentid, sum( \r\n");
            if (CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString().equals(currencyid)) {
                hisAgeTableSql.append("assist.foriginalamount");
            } else if (CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString().equals(currencyid)) {
                hisAgeTableSql.append("assist.freportingamount");
            } else {
                hisAgeTableSql.append("assist.foriginalamount");
            }
            hisAgeTableSql.append(") as sumoro \r\n");
            hisAgeTableSql.append("from t_gl_voucherassistrecord assist \r\n");
            hisAgeTableSql.append("inner join t_gl_voucher voucher on assist.FbillID=voucher.FID \r\n");
            hisAgeTableSql.append("inner join t_gl_acctcussent cussent on assist.FVerifiedCussentID=cussent.fid \r\n");
            hisAgeTableSql.append("inner join t_bd_accountview cussav on cussav.fid=cussent.faccountid \r\n");
            hisAgeTableSql.append("where cussent.fcompanyid=? and cussav.fcompanyid=? \r\n");
            sqlParams.add(companyid);
            sqlParams.add(companyid);
            hisAgeTableSql.append(" and voucher.FBookedDate>? ");
            Date vchDate = new Date(historyDate.getTime());
            sqlParams.add(vchDate);
            if (!isAccountList) {
                hisAgeTableSql.append(" and cussav.fid in (" + accountid + ") ");
            }
            this.buildAccountSqlInTimeVerify(hisAgeTableSql, sqlParams, accountParams, "cussav.fnumber");
            if (!includeUnPosted) {
                hisAgeTableSql.append(" and voucher.FBizStatus=5 ");
            } else {
                hisAgeTableSql.append(" and voucher.fbizstatus <> 0 and voucher.fbizstatus<>2 ");
            }
            hisAgeTableSql.append("\r\n group by cussent.fid");
            StringBuffer where = new StringBuffer();
            where.append(" where cussent.fcompanyid=?  and account.fcompanyid=? ");
            sqlParams.add(companyid);
            sqlParams.add(companyid);
            if (!general && !allCurr) {
                where.append(" and currency.fid=? ");
                sqlParams.add(currencyid);
            }
            if (isAccountList) {
                where.append(" and account.FAccountTableID='" + acctTableId + "' ");
                if (isBizCode) {
                    // empty if block
                }
            }
            if (!isAccountList) {
                where.append(" and account.fid in (" + accountid + ") ");
            }
            this.buildAccountSqlInTimeVerify(where, sqlParams, accountParams, "account.fnumber");
            where.append(" and (");
            where.append(" (cussent.fisinit<>1 and (cussent.fperiodid is null or cussent.fperiodid in (select fperiodid from v_gl_acperiod where fcompanyid=cussent.fcompanyid)) ");
            if (!includeUnPosted) {
                where.append("and voucher.FBizStatus=5");
            } else {
                where.append(" and voucher.fbizstatus <> 0 and voucher.fbizstatus<>2 ");
            }
            where.append(" and  voucher.Fbookeddate<=?) ");
            sqlParams.add(new Date(historyDate.getTime()));
            where.append(" or (cussent.fisinit = 1 AND cussent.fisinitclosed = 1)");
            where.append(")");
            if (includeUnPosted) {
                if (CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString().equals(currencyid)) {
                    where.append(" and (cussent.funholdedAmtRpt<>0 or cussent.funholdedAmtRpt is not null)");
                } else {
                    where.append(" and (cussent.funholdedAmtFor<>0 or cussent.funholdedAmtFor is not null)");
                }
            } else if (CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString().equals(currencyid)) {
                where.append(" and (cussent.funVerifiedAmtRpt<>0 or cussent.funVerifiedAmtRpt is not null)");
            } else {
                where.append(" and (cussent.funVerifiedAmtFor<>0 or cussent.funVerifiedAmtFor is not null)");
            }
            StringBuffer merge = new StringBuffer();
            merge.append("select ").append(selecthgoutside);
            merge.append(" leftamount").append(" as sumall");
            merge.append(",leftamount-(sum0");
            for (i2 = 1; i2 <= daylen; ++i2) {
                merge.append("+sum" + i2);
            }
            merge.append(") sumunoverdue");
            merge.append(",sum0");
            for (i2 = 1; i2 <= daylen; ++i2) {
                merge.append("+sum" + i2);
            }
            merge.append(" sumoverdue,sum0");
            for (i2 = 1; i2 <= daylen; ++i2) {
                merge.append(",sum" + i2);
            }
            merge.append(" from ");
            if (isAccountList) {
                groupby.append(",hg.fid");
            }
            if (allCurr) {
                groupby.append(",currency.fid, currency.Fname_" + loc);
            }
            if (groupby.toString().trim().startsWith(",")) {
                groupby = new StringBuffer(" group by ").append(groupby.substring(groupby.indexOf(",") + 1));
            }
            StringBuffer sqlSelect = new StringBuffer();
            sqlSelect.append("select ").append(selecthg).append(sum).append(fromTable).append(innerJoin);
            sqlSelect.append(" left join (").append(hisAgeTableSql).append(") t on cussent.fid=t.cussentid");
            sqlSelect.append(where).append(groupby);
            sum = new StringBuffer();
            selecthg = new StringBuffer();
            groupby = new StringBuffer();
            StringBuffer orderby = new StringBuffer();
            sum.append("sum(leftamount) as leftamount");
            String _whereCause = "t.sum0";
            for (i = 0; i < daylen + 1; ++i) {
                sum.append(",sum(sum" + i + ") as sum" + i);
                if (i == 0) continue;
                _whereCause = _whereCause + "+t.sum" + i;
            }
            for (i = 0; i < alTables.size(); ++i) {
                String numkey = "T" + i + "fnumber";
                String namekey = "T" + i + "fname";
                selecthg.append(",").append(numkey);
                selecthg.append(",").append(namekey);
                groupby.append(",").append(numkey);
                groupby.append(",").append(namekey);
                if (isAccountList && i != 0) continue;
                orderby.append(numkey).append(",");
                orderby.append(namekey).append(",");
            }
            if (groupby.length() > 0) {
                groupby = new StringBuffer(" group by ").append(selecthgoutside.deleteCharAt(selecthgoutside.length() - 1));
            }
            if (selecthgoutside.toString().endsWith(",")) {
                int delimiterIdx = selecthgoutside.lastIndexOf(",");
                selecthgoutside = new StringBuffer(selecthgoutside.toString().substring(0, delimiterIdx));
            }
            merge.append("(select ").append(sum).append(",").append(selecthgoutside);
            merge.append(" from (").append(sqlSelect).append(") t  group by " + selecthgoutside + ") ");
            merge.append(" tempa");
            orderby = new StringBuffer(" order by ").append(orderby);
            orderby.append(" fcurrid");
            StringBuffer totalSum = new StringBuffer();
            totalSum.append(merge);
            if (!isAccountList && !allCurr) {
                totalSum.append("\r\n union all select  ");
                for (int i5 = 0; i5 < alFields.size(); ++i5) {
                    totalSum.append(" '").append(maxChar).append("' ");
                    totalSum.append("T" + i5 + alFields.get(i5).toString());
                    totalSum.append(",");
                    totalSum.append(" N'").append(maxChar).append("' ");
                    totalSum.append("T" + i5 + "fnumber ");
                    totalSum.append(",");
                    totalSum.append(" N'").append(maxChar).append("' ");
                    totalSum.append("T" + i5 + "fname ");
                    totalSum.append(",");
                }
                if (isAccountBC && !isAccountNoBC) {
                    totalSum.append(" '").append(maxChar).append("' ");
                    totalSum.append("Taccountid");
                    totalSum.append(",");
                    totalSum.append(" N'").append(maxChar).append("' ");
                    totalSum.append("T0fnumber ");
                    totalSum.append(",");
                    totalSum.append(" N'").append(maxChar).append("' ");
                    totalSum.append("T0fname ");
                    totalSum.append(",");
                }
                totalSum.append(" '").append(maxChar).append("' fcurrid, null fcurrname, ");
                if (isAccountList) {
                    totalSum.append("'' hgid,");
                }
                StringBuffer _tempSum = new StringBuffer("sum(sum1) sum1");
                for (int i6 = 1; i6 < daylen; ++i6) {
                    _tempSum.append(",sum(sum" + (i6 + 1) + ") as sum" + (i6 + 1));
                }
                totalSum.append("sum(sumall) sumall,sum(sumunoverdue) sumunoverdue,sum(sumoverdue) sumoverdue,sum(sum0) sum0," + _tempSum + " from(");
                totalSum.append(merge);
                totalSum.append(") a group by fcurrid, fcurrname ");
            }
            totalSum.append(orderby);
            ArrayList<Object> finalParams = new ArrayList<Object>();
            finalParams.addAll(sqlParams);
            if (!isAccountList && !allCurr) {
                finalParams.addAll(sqlParams);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)PsSql.getSqlWithParams((Object)totalSum.toString(), finalParams));
            }
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)totalSum.toString(), (Object[])finalParams.toArray());
            String curreName = "";
            while (rs.next()) {
                int length;
                ArrayList<Object> line = new ArrayList<Object>();
                BalanceInfoByAge balance = new BalanceInfoByAge();
                int size = alTables.size();
                if (isAccountList && !isBizCode) {
                    size = 1;
                } else if (isBizCode && hmItems.size() != 0 && rs.getString("fcurrid").equals(maxChar)) {
                    line.add(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"35_RptAsstactGGUI", (Locale)ctx.getLocale()));
                }
                for (int i7 = 0; i7 < size; ++i7) {
                    String numkey = "T" + i7 + "fnumber";
                    String namekey = "T" + i7 + "fname";
                    if (!rs.getString("fcurrid").equals(maxChar)) continue;
                    line.add(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"35_RptAsstactGGUI", (Locale)ctx.getLocale()));
                }
                if (rs.getString("fcurrname") == null || rs.getString("fcurrname").length() == 0) {
                    if (hmItems.size() == 0 || isAccountBC) {
                        line.add(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"35_RptAsstactGGUI", (Locale)ctx.getLocale()));
                    } else {
                        line.add(curreName);
                    }
                } else {
                    curreName = rs.getString("fcurrname");
                    line.add(curreName);
                }
                line.add(rs.getBigDecimal("sumall"));
                line.add(rs.getBigDecimal("sumunoverdue"));
                BigDecimal sumoverdue = rs.getBigDecimal("sumoverdue");
                line.add(sumoverdue);
                BigDecimal[] itemBigdecimal = new BigDecimal[daylen + 1];
                for (int i8 = 0; i8 < daylen + 1; ++i8) {
                    itemBigdecimal[i8] = rs.getBigDecimal("sum" + i8);
                }
                BigDecimal zero = GlUtils.zero;
                int i9 = 0;
                int innerlength = length = itemBigdecimal.length;
                while (i9 < length) {
                    innerlength = length - 1;
                    BigDecimal tempate = itemBigdecimal[length - 1];
                    if (sumoverdue != null && tempate != null && tempate.compareTo(zero) != 0) {
                        for (int j = 0; j < innerlength; ++j) {
                            itemBigdecimal[length - 1] = j == 0 ? sumoverdue.subtract(itemBigdecimal[j]) : itemBigdecimal[length - 1].subtract(itemBigdecimal[j]);
                        }
                        break;
                    }
                    --length;
                }
                length = itemBigdecimal.length;
                for (i9 = 0; i9 < length; ++i9) {
                    line.add(itemBigdecimal[i9]);
                }
                balance.setBalance(rs.getBigDecimal("sumall"));
                balance.setUnOverDueBalance(rs.getBigDecimal("sumunoverdue"));
                balance.setOverDueBalance(sumoverdue);
                balance.setAgeBalances(itemBigdecimal);
                if (isAccountList) {
                    line.add(rs.getString("hgid"));
                    balance.setCurrentHG(rs.getString("hgid"));
                }
                try {
                    line.add(rs.getString("acct_id"));
                    line.add(rs.getString("acct_number"));
                    balance.setAcctId(rs.getString("acct_id"));
                    balance.setAcctNumber(rs.getString("acct_number"));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                balance.setAgeArea(days);
                result.add(balance);
            }
            if (tempTable == null) return result;
        }
        catch (SQLException sqle) {
            try {
                throw new SQLAccessException(sqle);
            }
            catch (Throwable throwable) {
                if (tempTable == null) throw throwable;
                TempTablePool.getInstance((Context)ctx).releaseTable(tempTable);
                throw throwable;
            }
        }
        TempTablePool.getInstance((Context)ctx).releaseTable(tempTable);
        return result;
    }

    public void setDebugModel(DebugModel debugModel) {
        this.debugModel = debugModel;
    }
}

