/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.batch.age.balanceByInterface;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.AccountAgeFacadeFactory;
import com.kingdee.eas.fi.rpt.batch.age.Age;
import com.kingdee.eas.fi.rpt.batch.age.BalanceCalcSort;
import com.kingdee.eas.fi.rpt.batch.age.balance.facade.BalanceInfoByAge;
import com.kingdee.eas.fi.rpt.batch.age.balance.facade.SimpleAssistantHG;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class QueryAgeBalanceByInterface {
    private static Logger logger = Logger.getLogger((String)QueryAgeBalanceByInterface.class.getClass().getName());

    public void exec(Context ctx, Map calMap, Collection sorts) throws EASBizException, BOSException, SQLException {
        Map result = AccountAgeFacadeFactory.getLocalInstance((Context)ctx).batchQueryAge(calMap);
        ArrayList<ArrayList> alAcResult = null;
        for (BalanceCalcSort sort : sorts) {
            List formulas = sort.getFormulas();
            alAcResult = new ArrayList<ArrayList>();
            block1: for (int i = 0; i < formulas.size(); ++i) {
                Age age = (Age)formulas.get(i);
                int[] days = age.getDays();
                int daylen = days.length;
                if (daylen == 2 && days[1] == Integer.MAX_VALUE) {
                    daylen = days.length - 1;
                }
                List<String> keys = age.getKeys();
                for (int j = 0; j < keys.size(); ++j) {
                    ArrayList entry;
                    Object rs;
                    String key = keys.get(j);
                    if (result.get(key) != null && result.get(key) instanceof String) {
                        age.setException(new Exception(EASResource.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"373_QueryAgeBalanceByInterface")));
                        continue block1;
                    }
                    if (result.get(key) != null && result.get(key) instanceof IRowSet) {
                        rs = (IRowSet)result.get(key);
                        entry = this.create_LastResult_ByAcctBal(daylen, (IRowSet)rs, days);
                        alAcResult.add(entry);
                        continue;
                    }
                    if (result.get(key) == null || !(result.get(key) instanceof List)) continue;
                    rs = (List)result.remove(key);
                    entry = this.createResultByList(daylen, (List)rs, days);
                    alAcResult.add(entry);
                }
            }
            if (alAcResult == null || alAcResult.size() <= 0) continue;
            sort.fillValue(alAcResult, formulas);
        }
    }

    private Set togetherAssistantHG(List balances) {
        BalanceInfoByAge balance = null;
        HashSet<SimpleAssistantHG> hgs = new HashSet<SimpleAssistantHG>(balances.size());
        HashMap<String, SimpleAssistantHG> noDuplicatHG = new HashMap<String, SimpleAssistantHG>();
        int size = balances.size();
        for (int i = 0; i < size; ++i) {
            balance = (BalanceInfoByAge)balances.get(i);
            if (balance.getCurrentHG() == null || balance.getCurrentHG().getHgId() == null) continue;
            if (!noDuplicatHG.containsKey(balance.getCurrentHG().getHgId())) {
                hgs.add(balance.getCurrentHG());
                noDuplicatHG.put(balance.getCurrentHG().getHgId(), balance.getCurrentHG());
                continue;
            }
            balance.setCurrentHG((SimpleAssistantHG)noDuplicatHG.get(balance.getCurrentHG().getHgId()));
        }
        return hgs;
    }

    private ArrayList create_LastResult_ByAcctBal(int daylen, IRowSet rs, int[] days) throws SQLException {
        ArrayList<BalanceInfoByAge> result = new ArrayList<BalanceInfoByAge>();
        while (rs.next()) {
            BalanceInfoByAge balance = new BalanceInfoByAge();
            BigDecimal[] itemBigdecimal = new BigDecimal[]{rs.getBigDecimal("sum0")};
            balance.setUnOverDueBalance(rs.getBigDecimal("sumunoverdue"));
            balance.setOverDueBalance(rs.getBigDecimal("sumoverdue"));
            balance.setAgeBalances(itemBigdecimal);
            balance.setAgeArea(days);
            result.add(balance);
        }
        return result;
    }

    private ArrayList createResultByList(int daylen, List rs, int[] days) throws SQLException {
        ArrayList<BalanceInfoByAge> result = new ArrayList<BalanceInfoByAge>();
        for (int i = 0; i < rs.size(); ++i) {
            Map map = (Map)rs.get(i);
            BalanceInfoByAge balance = new BalanceInfoByAge();
            BigDecimal[] itemBigdecimal = new BigDecimal[]{new BigDecimal(String.valueOf(map.get("sum0")))};
            BigDecimal sumUnoverdue = new BigDecimal(String.valueOf(map.get("sumunoverdue")));
            BigDecimal sumOverdue = new BigDecimal(String.valueOf(map.get("sumoverdue")));
            balance.setAgeBalances(itemBigdecimal);
            balance.setUnOverDueBalance(sumUnoverdue);
            balance.setOverDueBalance(sumOverdue);
            balance.setAgeArea(days);
            result.add(balance);
        }
        return result;
    }
}

