/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.batch.dyitem;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Parameter;
import com.kingdee.bos.ctrl.excel.model.util.SortedParameterArray;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.org.OrgTreeCollection;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.fi.gr.cslrpt.FiscalPeriodHelper;
import com.kingdee.eas.fi.gr.cslrpt.FormulaAdapter;
import com.kingdee.eas.fi.gr.cslrpt.RPTDate13Util;
import com.kingdee.eas.fi.gr.cslrpt.util.CSLParamUtil;
import com.kingdee.eas.fi.gr.cslrpt.util.CSLPermissionUtil;
import com.kingdee.eas.fi.gr.cslrpt.util.CslConstant;
import com.kingdee.eas.fi.gr.cslrpt.util.DataElementProvider;
import com.kingdee.eas.fi.gr.dynamic.util.MultiDynaItem;
import com.kingdee.eas.fi.gr.fast.util.FastMergeUtil;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.fi.rpt.ReportException;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.batch.AbstractFormulaInfo;
import com.kingdee.eas.fi.rpt.batch.BatchHelper;
import com.kingdee.eas.fi.rpt.batch.BatchSQLSorterRegister;
import com.kingdee.eas.fi.rpt.batch.CalculatorHelper;
import com.kingdee.eas.fi.rpt.batch.FormulaValueBackfill;
import com.kingdee.eas.fi.rpt.batch.IBatchSQLSortState;
import com.kingdee.eas.fi.rpt.batch.IBatchSQLSorterProcessor;
import com.kingdee.eas.fi.rpt.batch.IBatchSQLSorterRegister;
import com.kingdee.eas.fi.rpt.batch.IFormulaCalculator;
import com.kingdee.eas.fi.rpt.batch.dyitem.AdjustProccessor;
import com.kingdee.eas.fi.rpt.batch.dyitem.AdjustTempTableProccessor;
import com.kingdee.eas.fi.rpt.batch.dyitem.DyItemProccessor;
import com.kingdee.eas.fi.rpt.batch.dyitem.DyItemTemptableProccessor;
import com.kingdee.eas.fi.rpt.batch.dyitem.MultiDyItemProccessor;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import edu.emory.mathcs.backport.java.util.Arrays;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class DyItemCalculator {
    private Context serverContext;
    private BatchHelper batchHelper;
    private List needOrgTreeDyItemList = new ArrayList();
    private List errorList = new ArrayList();
    private Set orgTreeNumberSet;
    private Set companyNumberSet;
    private Set currencyNumberSet;
    private Set dataElementSet;
    private ICalculateContextProvider calContext;
    private boolean isIncludeUnCommit = false;
    private IBatchSQLSorterRegister dyItemRegister;
    private IBatchSQLSorterRegister dyItemBeforeAdjustRegister;
    private IBatchSQLSorterRegister adjustValueRegister;
    private IBatchSQLSorterRegister multiDyItemRegister;
    private int SQL_VARIABLS_SIZE = 500;
    private static final String BATCH_SIZE_KEY = "DyItemVariablesSize";
    public static final String CONTEXT_COMPANY = "company";
    public static final String CONTEXT_DATAELEMENT = "dataelement";
    public static final String CONTEXT_NEEDCOMMITSTATUS = "isNeedCommitStatus";
    private static final int MAX_COMANPANY_SIGN = 1;
    private static final int MAX_DATAELEMENT_SIGN = 3;
    private Map dataCollectPermCacheMap = new HashMap();
    public PeriodCollection periods = null;
    public boolean isMergeByFiscalPeriod = false;
    public boolean isSupportOtherDS = false;
    public boolean isSupport13Period = false;
    public static boolean isUserTmpTable = true;
    private boolean isUseTmpTableDebug = false;
    Map orgTreeMap;
    Map context = null;

    public DyItemCalculator(ICalculateContextProvider context, Context serverCtx) {
        Object[] cslValues;
        this.serverContext = serverCtx;
        this.calContext = context;
        this.batchHelper = new BatchHelper(context, serverCtx);
        Object isIncludeUnCommitObj = context.getReportAdapter().getReportProperty("isIncludeUnCommit");
        this.isIncludeUnCommit = isIncludeUnCommitObj != null && (Boolean)isIncludeUnCommitObj != false;
        boolean[] values = CSLParamUtil.batchGetParam((Context)serverCtx, (String[])new String[]{"GR_CSL_MergeByFiscalPeriod", "GR_CSL_Support13Period", "GR_CSL_SupportOtherDS"});
        this.isMergeByFiscalPeriod = values[0];
        this.isSupport13Period = values[1];
        this.isSupportOtherDS = values[2];
        if (this.isMergeByFiscalPeriod) {
            this.periods = FiscalPeriodHelper.initFormualFiscalPeriods((Context)this.serverContext, (ICalculateContextProvider)context);
        }
        isUserTmpTable = (cslValues = CSLParamUtil.batchGetCslParam((Context)serverCtx, (String[])new String[]{"KEY_CSLPARAM_DYITEMUSERTMPTABLE", "KEY_CSLPARAM_DYITEMUSERDEBUG"}))[0] == null ? true : cslValues[0].toString().equalsIgnoreCase("true");
        this.isUseTmpTableDebug = cslValues[1] == null ? false : cslValues[1].toString().equalsIgnoreCase("true");
    }

    public DyItemCalculator(ICalculateContextProvider context, Context serverCtx, boolean isNeedCommitStatus) {
        this(context, serverCtx);
        this.isIncludeUnCommit = !isNeedCommitStatus;
    }

    public void execute(SortedParameterArray params) {
        try {
            this.init(params);
            this.calculate();
            this.handleAllException();
        }
        catch (Exception e) {
            this.handleSysException(e);
        }
    }

    public void execute(Collection params) {
        try {
            this.init(params);
            this.calculate();
            this.handleAllException();
        }
        catch (Exception e) {
            this.handleSysException(e);
        }
    }

    private void handleSysException(Exception e) {
        this.handleException(e, this.dyItemRegister);
        this.handleException(e, this.dyItemBeforeAdjustRegister);
        this.handleException(e, this.adjustValueRegister);
        this.handleException(e, this.multiDyItemRegister);
        this.handleAllException();
    }

    private void handleAllException() {
        List sortStateList;
        if (this.dyItemRegister != null) {
            sortStateList = this.dyItemRegister.getSortStates();
            this.handleAllException(sortStateList);
        }
        if (this.multiDyItemRegister != null) {
            sortStateList = this.multiDyItemRegister.getSortStates();
            this.handleAllException(sortStateList);
        }
        if (this.errorList.size() > 0) {
            this.handleFormulaException(this.errorList);
        }
    }

    private void handleAllException(List sortStateList) {
        for (IBatchSQLSortState sortState : sortStateList) {
            List formulaList = sortState.getFormulaList();
            this.handleFormulaException(formulaList);
        }
    }

    private void handleFormulaException(List formulaList) {
        for (DyItem dyItem : formulaList) {
            if (dyItem.isException) {
                FormulaValueBackfill err = new FormulaValueBackfill(dyItem.param);
                err.setException((Throwable)dyItem.e);
                continue;
            }
            if (dyItem.param.getValue() != null) continue;
            dyItem.param.setValue((Object)CslConstant.BGZERO);
        }
    }

    private void calculate() {
        try {
            if (this.dyItemRegister != null) {
                boolean isAdjusted = false;
                for (IBatchSQLSortState sortState : this.dyItemRegister.getSortStates()) {
                    for (DyItem dyItem : sortState.getFormulaList()) {
                        if (dyItem.getParameter().getValue() != null) continue;
                        isAdjusted = dyItem.isAdjusted;
                        if (dyItem.isAdjusted) {
                            dyItem.isAdjusted = false;
                        }
                        if (this.dyItemBeforeAdjustRegister == null) {
                            this.dyItemBeforeAdjustRegister = new BatchSQLSorterRegister(this.context, "com.kingdee.eas.fi.rpt.batch.dyitem.DyItemSortState");
                        }
                        this.dyItemBeforeAdjustRegister.register(dyItem);
                        if (!isAdjusted || dyItem.int_valueType == 3) continue;
                        if (this.adjustValueRegister == null) {
                            this.adjustValueRegister = new BatchSQLSorterRegister(isUserTmpTable ? this.context : new HashMap(), "com.kingdee.eas.fi.rpt.batch.dyitem.DyItemSortState");
                        }
                        this.adjustValueRegister.register(dyItem);
                    }
                }
                if (this.dyItemBeforeAdjustRegister != null) {
                    this.batchHelper.setTempTableSchemeDebug(this.isUseTmpTableDebug && isUserTmpTable);
                    this.batchHelper.batchCalculateBigDecimalBySorter(this.getProcessor(), this.dyItemBeforeAdjustRegister);
                    this.batchHelper.setTempTableSchemeDebug(false);
                }
                if (this.adjustValueRegister != null) {
                    AdjustProccessor sqlBuilder2 = null;
                    sqlBuilder2 = isUserTmpTable ? new AdjustTempTableProccessor(this.isIncludeUnCommit) : new AdjustProccessor(this.SQL_VARIABLS_SIZE);
                    this.batchHelper.batchCalculateBigDecimalBySorter(sqlBuilder2, this.adjustValueRegister);
                }
            }
            if (this.multiDyItemRegister != null) {
                MultiDyItemProccessor sqlBuilder = new MultiDyItemProccessor(this.SQL_VARIABLS_SIZE, this.isIncludeUnCommit);
                this.batchHelper.batchCalculateBigDecimalBySorter(sqlBuilder, this.multiDyItemRegister);
            }
        }
        catch (Exception e) {
            this.handleException(e, this.dyItemRegister);
            this.handleException(e, this.dyItemBeforeAdjustRegister);
            this.handleException(e, this.adjustValueRegister);
            this.handleException(e, this.multiDyItemRegister);
        }
    }

    private IBatchSQLSorterProcessor getProcessor() {
        DyItemProccessor sqlBuilder2 = null;
        sqlBuilder2 = isUserTmpTable ? new DyItemTemptableProccessor(this.serverContext, this.isIncludeUnCommit) : new DyItemProccessor(this.serverContext, this.SQL_VARIABLS_SIZE, this.isIncludeUnCommit);
        return sqlBuilder2;
    }

    private void handleException(Exception e, IBatchSQLSorterRegister register) {
        if (register == null) {
            return;
        }
        for (IBatchSQLSortState sortState : register.getSortStates()) {
            this.handleException(sortState.getFormulaList(), e);
        }
    }

    private void init(SortedParameterArray params) throws BOSException {
        this.initBatchSize();
        this.initDyItems(Arrays.asList((Object[])params.toArray()));
    }

    private void init(Collection params) throws BOSException {
        this.initBatchSize();
        this.initDyItems(params);
    }

    private void initBatchSize() throws BOSException {
        String sql = "select FValue From T_CSL_CSLParam where FKey = ? ";
        IRowSet rowSet = DbUtil.executeQuery((Context)this.serverContext, (String)sql, (Object[])new Object[]{BATCH_SIZE_KEY});
        try {
            if (rowSet.next()) {
                String stringSize = rowSet.getString("FValue");
                this.SQL_VARIABLS_SIZE = Integer.parseInt(stringSize);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void initOrgBoundId() throws BOSException {
        HashMap<String, OrgTreeCollection> orgBoundNumber2OrgTreeCollectionMap = new HashMap<String, OrgTreeCollection>();
        if (this.orgTreeNumberSet.size() == 0) {
            return;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select Fid,FNumber,FStartDate,FEndDate from T_ORG_Tree where FNumber in \n");
        sql.append(this.batchHelper.createInSql(this.orgTreeNumberSet.iterator()));
        sql.append(" and (FStatus in (1,2))  \n");
        sql.append(" order by FstartDate desc,FendDate desc");
        IRowSet row = DbUtil.executeQuery((Context)this.serverContext, (String)sql.toString());
        try {
            while (row.next()) {
                OrgTreeInfo info = new OrgTreeInfo();
                info.setId(BOSUuid.read((String)row.getString("Fid")));
                String number = row.getString("FNumber");
                info.setNumber(number);
                info.setStartDate(row.getTimestamp("FStartDate"));
                info.setEndDate(row.getTimestamp("FEndDate"));
                OrgTreeCollection collection = (OrgTreeCollection)orgBoundNumber2OrgTreeCollectionMap.get(number);
                if (collection == null) {
                    collection = new OrgTreeCollection();
                }
                collection.add(info);
                orgBoundNumber2OrgTreeCollectionMap.put(number, collection);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        this.initOrgTreeByPeriods(orgBoundNumber2OrgTreeCollectionMap);
    }

    public void initOrgTreeByPeriods(Map orgBoundNumber2OrgTreeCollectionMap) {
        for (DyItem dyItem : this.needOrgTreeDyItemList) {
            if (dyItem.isException) continue;
            if (dyItem.int_periodType == 0) {
                dyItem.int_periodType = 3;
            }
            RptPeriodTypeEnum curPeriodType = RptPeriodTypeEnum.getEnum((int)dyItem.int_periodType);
            if (orgBoundNumber2OrgTreeCollectionMap.size() == 0 || orgBoundNumber2OrgTreeCollectionMap.get(dyItem.orgBoundNumber) == null) {
                dyItem.setException((Exception)((Object)new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"42_AcctItemCalcuter", (Locale)this.serverContext.getLocale())})));
                this.errorList.add(dyItem);
                continue;
            }
            OrgTreeCollection orgTreeCL = (OrgTreeCollection)orgBoundNumber2OrgTreeCollectionMap.get(dyItem.orgBoundNumber);
            if (orgTreeCL != null && orgTreeCL.size() > 0) {
                Date curDate;
                block1: for (int period = dyItem.endPeriod; period >= dyItem.startPeriod && (curDate = FiscalPeriodHelper.getPeriodLastDate((PeriodCollection)this.periods, (int)dyItem.startYear, (int)period, (RptPeriodTypeEnum)curPeriodType, (boolean)this.isMergeByFiscalPeriod)) != null; --period) {
                    for (int i = 0; curDate != null && i < orgTreeCL.size(); ++i) {
                        String strOrgTreeID = orgTreeCL.get(i).getId().toString();
                        Timestamp sDate = orgTreeCL.get(i).getStartDate();
                        if (sDate.compareTo(new Timestamp(curDate.getTime())) > 0) continue;
                        dyItem.orgBoundIdSet.add(strOrgTreeID);
                        continue block1;
                    }
                }
                if (dyItem.orgBoundIdSet.size() != 0) continue;
                dyItem.setException((Exception)((Object)new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"46_AdjustDataCalculator", (Locale)this.serverContext.getLocale())})));
                this.errorList.add(dyItem);
                continue;
            }
            dyItem.setException((Exception)((Object)new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"60_DyItemCalculator", (Locale)this.serverContext.getLocale())})));
            this.errorList.add(dyItem);
        }
    }

    private void handleException(List list, Exception e) {
        for (DyItem dyItem : list) {
            dyItem.setException(e);
        }
    }

    private Map queryOrgUnitID() throws BOSException {
        int i;
        HashMap<Object, Object> orgUnitMap = new HashMap<Object, Object>();
        if (this.needOrgTreeDyItemList.size() == 0) {
            return orgUnitMap;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select b.fnumber fnumber, s.funitid fid from T_ORG_Structure s join  T_ORG_BaseUnit b on s.funitid = b.fid  ");
        StringBuffer where = new StringBuffer();
        String keyStr = null;
        DyItem dyItem = null;
        HashMap<String, DyItem> dropD = new HashMap<String, DyItem>();
        for (i = 0; i < this.needOrgTreeDyItemList.size(); ++i) {
            dyItem = (DyItem)this.needOrgTreeDyItemList.get(i);
            if (dyItem.isException || dropD.containsKey(keyStr = dyItem.orgBoundIdSet.iterator().next().toString() + dyItem.orgUnitNumber)) continue;
            dropD.put(keyStr, dyItem);
        }
        if (!dropD.isEmpty()) {
            i = 0;
            for (String key : dropD.keySet()) {
                dyItem = (DyItem)dropD.get(key);
                if (i > 0) {
                    where.append(" or ");
                }
                where.append(" s.FtreeID ='").append(dyItem.orgBoundIdSet.iterator().next().toString()).append("'");
                where.append(" and b.fnumber = '").append(dyItem.orgUnitNumber).append("'");
                ++i;
            }
        }
        dropD.clear();
        if (where.length() > 0) {
            sql.append(" where ").append(where);
            IRowSet rs = DbUtil.executeQuery((Context)this.serverContext, (String)sql.toString());
            try {
                while (rs.next()) {
                    orgUnitMap.put(rs.getObject("FNumber"), rs.getObject("FId"));
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
        }
        return orgUnitMap;
    }

    private Map queryCurrencyID(Set currencyNumberSet) throws BOSException {
        HashMap<Object, Object> currencyMap = new HashMap<Object, Object>();
        if (currencyNumberSet == null || currencyNumberSet.size() <= 0) {
            return currencyMap;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select FId, Fnumber from T_BD_Currency where FNumber in  \n");
        sql.append(this.batchHelper.createInSql(currencyNumberSet.iterator()));
        IRowSet rs = DbUtil.executeQuery((Context)this.serverContext, (String)sql.toString());
        try {
            while (rs.next()) {
                currencyMap.put(rs.getObject("FNumber"), rs.getObject("FId"));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return currencyMap;
    }

    private Map queryAsstActType(Set multiDynaAsstActTypeSet) throws BOSException {
        if (multiDynaAsstActTypeSet.size() == 0) {
            return new HashMap();
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)multiDynaAsstActTypeSet, CompareType.INCLUDE));
        AsstActTypeCollection asstActTypeCollection = AsstActTypeFactory.getLocalInstance((Context)this.serverContext).getAsstActTypeCollection(view);
        HashMap<String, AsstActTypeInfo> result = new HashMap<String, AsstActTypeInfo>();
        for (int i = 0; asstActTypeCollection != null && i < asstActTypeCollection.size(); ++i) {
            result.put(asstActTypeCollection.get(i).getNumber(), asstActTypeCollection.get(i));
        }
        return result;
    }

    private void initDyItems(Collection params) throws BOSException {
        this.orgTreeNumberSet = new HashSet();
        this.companyNumberSet = new HashSet();
        this.currencyNumberSet = new HashSet();
        this.dataElementSet = new HashSet();
        this.orgTreeMap = new HashMap();
        Map adminLongNumberMap = new HashMap();
        Map costCenterLongNumberMap = new HashMap();
        Map cashFlowItemLongNumberMap = new HashMap();
        Map generalAsstActTypeLongNumberMap = new HashMap();
        HashSet multiDynaAsstActTypeSet = new HashSet();
        ArrayList<DyItem> multiDynaItemList = new ArrayList<DyItem>();
        for (Parameter param : params) {
            DyItem dyItem = new DyItem(param);
            if (dyItem.isException) {
                this.errorList.add(dyItem);
                continue;
            }
            if (dyItem.int_dataSource == 13 || dyItem.int_dataSource == 14 || dyItem.int_dataSource == 15) {
                this.companyNumberSet.add(dyItem.orgUnitNumber);
                this.dataElementSet.add(new Integer(dyItem.int_dataElement));
                if (dyItem.dynaItem != null && dyItem.dynaItem.getAsstActTypeList() != null) {
                    multiDynaAsstActTypeSet.addAll(dyItem.dynaItem.getAsstActTypeList());
                }
                multiDynaItemList.add(dyItem);
                continue;
            }
            this.companyNumberSet.add(dyItem.orgUnitNumber);
            this.currencyNumberSet.add(dyItem.currencyNumber);
            if (!StringUtils.isEmpty((String)dyItem.sourceCurrencyNumber)) {
                this.currencyNumberSet.add(dyItem.sourceCurrencyNumber);
            }
            this.needOrgTreeDyItemList.add(dyItem);
            this.orgTreeNumberSet.add(dyItem.orgBoundNumber);
            multiDynaItemList.add(dyItem);
        }
        this.initOrgBoundId();
        Map currencyMap = this.queryCurrencyID(this.currencyNumberSet);
        Map companyMap = this.queryOrgUnitID();
        Map asstActTypeMap = this.queryAsstActType(multiDynaAsstActTypeSet);
        if (multiDynaItemList != null && multiDynaItemList.size() > 0) {
            String asstItemNumberString;
            StringBuffer admin = new StringBuffer();
            StringBuffer generalAsstActType = new StringBuffer();
            StringBuffer cashFlowItem = new StringBuffer();
            StringBuffer costCenter = new StringBuffer();
            for (int i = 0; i < multiDynaItemList.size(); ++i) {
                DyItem dyItem = (DyItem)multiDynaItemList.get(i);
                if (dyItem.isException || dyItem.int_dataSource != 13 && dyItem.int_dataSource != 14 && dyItem.int_dataSource != 15 || dyItem.dynaItem == null) continue;
                MultiDynaItem dynaItemKey = dyItem.dynaItem;
                for (String typeNumber : dyItem.dynaItem.getAsstActTypeList()) {
                    AsstActTypeInfo asstActTypeInfo = (AsstActTypeInfo)asstActTypeMap.get(typeNumber);
                    if (asstActTypeInfo == null) continue;
                    this.resetLongNumberOrNumber(asstActTypeInfo, dynaItemKey, dyItem);
                    boolean isUseLongNumber = RptUtil.isUseLongNumber(asstActTypeInfo);
                    if (!isUseLongNumber || dyItem.isShortNum) continue;
                    String tableName = asstActTypeInfo.getRealtionDataObject();
                    String[] asstItemNumbers = dynaItemKey.getAsstItemNumbers(asstActTypeInfo.getNumber());
                    if (asstItemNumbers != null && asstItemNumbers.length == 2 && !asstItemNumbers[0].equals(asstItemNumbers[1])) {
                        if (tableName.equalsIgnoreCase("T_BD_GeneralAsstActType")) {
                            generalAsstActType.append("'").append(asstItemNumbers[0]).append("','").append(asstItemNumbers[1]).append("'").append(",");
                            continue;
                        }
                        if (tableName.equalsIgnoreCase("T_ORG_Admin")) {
                            admin.append("'").append(asstItemNumbers[0]).append("','").append(asstItemNumbers[1]).append("'").append(",");
                            continue;
                        }
                        if (tableName.equalsIgnoreCase("T_BD_CashFlowItem")) {
                            cashFlowItem.append("'").append(asstItemNumbers[0]).append("','").append(asstItemNumbers[1]).append("'").append(",");
                            continue;
                        }
                        if (!tableName.equalsIgnoreCase("T_ORG_CostCenter")) continue;
                        costCenter.append("'").append(asstItemNumbers[0]).append("','").append(asstItemNumbers[1]).append("'").append(",");
                        continue;
                    }
                    if (asstItemNumbers == null) continue;
                    if (tableName.equalsIgnoreCase("T_BD_GeneralAsstActType")) {
                        generalAsstActType.append("'").append(asstItemNumbers[0]).append("'").append(",");
                        continue;
                    }
                    if (tableName.equalsIgnoreCase("T_ORG_Admin")) {
                        admin.append("'").append(asstItemNumbers[0]).append("'").append(",");
                        continue;
                    }
                    if (tableName.equalsIgnoreCase("T_BD_CashFlowItem")) {
                        cashFlowItem.append("'").append(asstItemNumbers[0]).append("'").append(",");
                        continue;
                    }
                    if (!tableName.equalsIgnoreCase("T_ORG_CostCenter")) continue;
                    costCenter.append("'").append(asstItemNumbers[0]).append("'").append(",");
                }
            }
            if (generalAsstActType.length() > 0) {
                String tableName = "T_BD_GeneralAsstActType";
                asstItemNumberString = generalAsstActType.toString().substring(0, generalAsstActType.length() - 1);
                generalAsstActTypeLongNumberMap = this.instructLongNumberMap(this.serverContext, asstItemNumberString);
            }
            if (admin.length() > 0) {
                String tableName = "T_ORG_Admin";
                asstItemNumberString = admin.toString().substring(0, admin.length() - 1);
                adminLongNumberMap = this.getLongNumberFromNumber(this.serverContext, tableName, asstItemNumberString);
            }
            if (costCenter.length() > 0) {
                String tableName = "T_ORG_CostCenter";
                asstItemNumberString = costCenter.toString().substring(0, costCenter.length() - 1);
                costCenterLongNumberMap = this.getLongNumberFromNumber(this.serverContext, tableName, asstItemNumberString);
            }
            if (cashFlowItem.length() > 0) {
                String tableName = "T_BD_CashFlowItem";
                asstItemNumberString = cashFlowItem.toString().substring(0, cashFlowItem.length() - 1);
                cashFlowItemLongNumberMap = this.getLongNumberFromNumber(this.serverContext, tableName, asstItemNumberString);
            }
        }
        ArrayList<AbstractFormulaInfo> dynaFormulaList = new ArrayList<AbstractFormulaInfo>();
        for (DyItem dyItem : multiDynaItemList) {
            if (dyItem.isException) continue;
            if (dyItem.int_dataSource == 13 || dyItem.int_dataSource == 14 || dyItem.int_dataSource == 15) {
                if (dyItem.dataCollectNumber.equalsIgnoreCase("BUDGETDATA")) {
                    dyItem.setException((Exception)((Object)new ReportException(ReportException.NOT_SUPPORT_MUTI_DYNAMIC_BUDGETDATA)));
                }
                if (this.multiDyItemRegister == null) {
                    HashMap<String, Object> context = new HashMap<String, Object>();
                    if (this.companyNumberSet.size() > 1) {
                        context.put(CONTEXT_COMPANY, null);
                    }
                    if (this.dataElementSet.size() > 3) {
                        context.put(CONTEXT_DATAELEMENT, null);
                    }
                    if (!this.isIncludeUnCommit) {
                        context.put(CONTEXT_NEEDCOMMITSTATUS, null);
                    }
                    this.multiDyItemRegister = new BatchSQLSorterRegister(context, "com.kingdee.eas.fi.rpt.batch.dyitem.MultiDyItemSortState");
                }
                if (dyItem.dynaItem != null) {
                    dyItem.asstActTypeList = new ArrayList();
                    for (String typeNumber : dyItem.dynaItem.getAsstActTypeList()) {
                        AsstActTypeInfo asstActTypeInfo = (AsstActTypeInfo)asstActTypeMap.get(typeNumber);
                        if (asstActTypeInfo == null) {
                            dyItem.setException((Exception)((Object)new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{RptUtil.getReportResource("report_calc_noitemtype", this.serverContext.getLocale()) + " \"" + typeNumber + "\""})));
                            this.errorList.add(dyItem);
                            break;
                        }
                        dyItem.asstActTypeList.add(asstActTypeInfo);
                    }
                }
                if (!generalAsstActTypeLongNumberMap.isEmpty()) {
                    dyItem.generalAsstActTypeLongNumberMap = generalAsstActTypeLongNumberMap;
                }
                if (!adminLongNumberMap.isEmpty()) {
                    dyItem.adminLongNumberMap = adminLongNumberMap;
                }
                if (!costCenterLongNumberMap.isEmpty()) {
                    dyItem.costCenterLongNumberMap = costCenterLongNumberMap;
                }
                if (!cashFlowItemLongNumberMap.isEmpty()) {
                    dyItem.cashFlowItemLongNumberMap = cashFlowItemLongNumberMap;
                }
                this.multiDyItemRegister.register(dyItem);
                continue;
            }
            dyItem.currencyID = (String)currencyMap.get(dyItem.currencyNumber);
            if (dyItem.currencyID == null) {
                dyItem.setException((Exception)((Object)new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.ReportResource", (String)"report_calc_nocurrency", (Locale)this.serverContext.getLocale())})));
            }
            dyItem.sourceCurrencyID = StringUtils.isEmpty((String)dyItem.sourceCurrencyNumber) ? dyItem.currencyID : (String)currencyMap.get(dyItem.sourceCurrencyNumber);
            if (dyItem.sourceCurrencyID == null) {
                dyItem.setException((Exception)((Object)new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.ReportResource", (String)"report_calc_nocurrency", (Locale)this.serverContext.getLocale())})));
            }
            if (StringUtils.isEmpty((String)dyItem.orgUnitID) || dyItem.orgUnitID.trim().equals("")) {
                dyItem.orgUnitID = (String)companyMap.get(dyItem.orgUnitNumber);
            }
            if (dyItem.orgUnitID == null) {
                dyItem.setException((Exception)((Object)new ReportException(ReportException.FIND_COMPANY_ERROR)));
            }
            if (dyItem.isException()) {
                this.errorList.add(dyItem);
                continue;
            }
            dyItem.putAllPerporties();
            dynaFormulaList.add(dyItem);
        }
        companyMap.clear();
        currencyMap.clear();
        asstActTypeMap.clear();
        multiDynaItemList.clear();
        if (dynaFormulaList != null && !dynaFormulaList.isEmpty()) {
            List<String>[] groupProperties = CalculatorHelper.getGroupProperties(dynaFormulaList);
            this.context = new HashMap();
            this.context.put("groupProerties", groupProperties);
            for (AbstractFormulaInfo dyItem : dynaFormulaList) {
                if (this.dyItemRegister == null) {
                    this.dyItemRegister = new BatchSQLSorterRegister(this.context, "com.kingdee.eas.fi.rpt.batch.dyitem.DyItemSortState");
                }
                this.dyItemRegister.register((DyItem)dyItem);
            }
        }
    }

    private void resetLongNumberOrNumber(AsstActTypeInfo asstActTypeInfo, MultiDynaItem dynaItemKey, DyItem dyItem) {
        String tableName = asstActTypeInfo.getRealtionDataObject();
        boolean isUseLongNumber = RptUtil.isUseLongNumber(asstActTypeInfo);
        String[] asstItemNumbers = dynaItemKey.getAsstItemNumbers(asstActTypeInfo.getNumber());
        if (asstItemNumbers == null || !"T_BD_GeneralAsstActType".equalsIgnoreCase(tableName)) {
            return;
        }
        StringBuffer number = new StringBuffer();
        for (int i = 0; i < asstItemNumbers.length; ++i) {
            if (isUseLongNumber && !dyItem.isShortNum) {
                asstItemNumbers[i] = asstItemNumbers[i].replaceAll("\\.", "\\!");
                continue;
            }
            if (!dyItem.isShortNum) continue;
            int start = asstItemNumbers[i].lastIndexOf(".");
            int end = asstItemNumbers[i].length();
            if (start < 0 || end < 0 || end == start) {
                return;
            }
            asstItemNumbers[i] = asstItemNumbers[i].substring(asstItemNumbers[i].lastIndexOf(".") + 1, asstItemNumbers[i].length());
        }
        if (asstItemNumbers.length == 2 && !asstItemNumbers[0].equals(asstItemNumbers[1])) {
            number.append(asstItemNumbers[0]).append(":").append(asstItemNumbers[1]);
        } else {
            number.append(asstItemNumbers[0]);
        }
        dynaItemKey.setAsstItemNumber(asstActTypeInfo.getNumber(), number.toString());
    }

    private Map getLongNumberFromNumber(Context ctx, String tableName, String asstItemNumber) {
        StringBuffer sb = new StringBuffer();
        HashMap<String, String> map = new HashMap<String, String>();
        sb.append(" select fnumber number,flongnumber longnumber \r\n");
        sb.append(" from " + tableName + " \r\n");
        sb.append(" where fnumber in ( ").append("" + asstItemNumber + "").append(")");
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
            while (rs.next()) {
                String number = rs.getString("number");
                String longNumber = rs.getString("longnumber");
                map.put(number, longNumber);
            }
        }
        catch (BOSException e) {
            this.handleException((Exception)((Object)e), this.dyItemRegister);
        }
        catch (SQLException e) {
            this.handleException(e, this.dyItemRegister);
        }
        return map;
    }

    private Map instructLongNumberMap(Context ctx, String asstItemNumber) {
        asstItemNumber = asstItemNumber.replace("'", "");
        String[] longNumberArray = asstItemNumber.split(",");
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < longNumberArray.length; ++i) {
            if (StringUtils.isEmpty((String)longNumberArray[i]) || map.containsKey(longNumberArray[i])) continue;
            map.put(longNumberArray[i], longNumberArray[i]);
        }
        return map;
    }

    public class DyItem
    extends AbstractFormulaInfo
    implements IFormulaCalculator {
        String orgBoundNumber;
        String orgUnitNumber;
        String sourceCurrencyNumber;
        String currencyNumber;
        String itemNumber;
        String dyItemNumber;
        String rptPeriodType;
        int yearOffset;
        int startPeriodOffset;
        int endPeriodOffset;
        String dataSource;
        String dataElement;
        String valueType;
        boolean isAdjusted;
        boolean isShortNum;
        String dataCollectNumber;
        boolean isNeedCommitStatus;
        int int_periodType;
        int int_dataSource;
        int int_dataElement;
        int int_valueType;
        int startYear;
        int startPeriod;
        int endYear;
        int endPeriod;
        int int_commitStatus;
        String currencyID;
        String sourceCurrencyID;
        String orgUnitID;
        boolean dyItemNumIsNull;
        String mergeSchmNum;
        Parameter param;
        Exception e;
        boolean isException;
        Set orgBoundIdSet;
        List asstActTypeList;
        Map adminLongNumberMap;
        Map costCenterLongNumberMap;
        Map cashFlowItemLongNumberMap;
        Map generalAsstActTypeLongNumberMap;
        MultiDynaItem dynaItem;

        DyItem(Parameter param) {
            this.param = param;
            try {
                this.initParamt();
            }
            catch (Exception e) {
                this.setException(e);
            }
        }

        private void initParamt() throws Exception {
            Integer isAdjustReport;
            this.initArgs();
            this.int_dataElement = -1;
            this.int_dataElement = DyItemCalculator.this.serverContext == null ? DataElementProvider.getDataElementInnerValue((String)this.dataElement) : DataElementProvider.getDataElementInnerValue((Context)DyItemCalculator.this.serverContext, (String)this.dataElement);
            if (this.int_dataElement == -1) {
                throw new Exception(ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"50_AdjustDataCalculator", (Locale)DyItemCalculator.this.serverContext.getLocale()));
            }
            this.int_dataSource = FormulaAdapter.getDataSource((String)this.dataSource);
            if (this.int_dataSource == -1) {
                throw new Exception(ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"61_DyItemCalculator", (Locale)DyItemCalculator.this.serverContext.getLocale()));
            }
            if (this.int_dataSource == 13 || this.int_dataSource == 14 || this.int_dataSource == 15) {
                if (this.isAdjusted) {
                    throw new ReportException(ReportException.COMMON_EXCEPTION, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"62_DyItemCalculator", (Locale)DyItemCalculator.this.serverContext.getLocale())});
                }
                if (!StringUtils.isEmpty((String)this.dyItemNumber)) {
                    this.dynaItem = new MultiDynaItem(this.dyItemNumber);
                    this.asstActTypeList = new ArrayList();
                }
            } else {
                this.orgBoundIdSet = new HashSet();
            }
            if (StringUtils.isEmpty((String)this.dataCollectNumber)) {
                this.dataCollectNumber = DyItemCalculator.this.batchHelper.getDataCollectNumber();
            }
            if (DyItemCalculator.this.isSupportOtherDS) {
                CSLPermissionUtil.checkDataCollectPermissionForFormula((Context)DyItemCalculator.this.serverContext, (String)DyItemCalculator.this.serverContext.getCaller().toString(), (String)this.dataCollectNumber, (Map)DyItemCalculator.this.dataCollectPermCacheMap);
            }
            if (this.currencyNumber == null || this.currencyNumber.trim().equals("")) {
                this.currencyNumber = DyItemCalculator.this.batchHelper.getCorrect_Currency_Number();
                if (this.currencyNumber == null || this.currencyNumber.trim().equals("")) {
                    this.currencyNumber = DyItemCalculator.this.batchHelper.getCorrect_Currency_Number(this.getSheetName());
                }
            }
            if (this.sourceCurrencyNumber == null || this.sourceCurrencyNumber.trim().equals("")) {
                this.sourceCurrencyNumber = DyItemCalculator.this.batchHelper.getSource_Currency_Number();
                if (StringUtils.isEmpty((String)this.sourceCurrencyNumber)) {
                    this.sourceCurrencyNumber = this.currencyNumber;
                }
            }
            if (StringUtils.isEmpty((String)this.itemNumber)) {
                throw new ReportException(ReportException.ITEM_NOT_NULL);
            }
            this.int_periodType = this.rptPeriodType == null || this.rptPeriodType.trim().equals("") ? DyItemCalculator.this.batchHelper.getReport_PeriodType() : FormulaAdapter.getRptPeriodType((String)this.rptPeriodType);
            if (this.int_periodType == -1) {
                throw new Exception(ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"49_AdjustDataCalculator", (Locale)DyItemCalculator.this.serverContext.getLocale()));
            }
            this.int_valueType = FormulaAdapter.getValueType((String)this.valueType);
            int rptYear = DyItemCalculator.this.batchHelper.getReport_Year();
            int rptPeriod = DyItemCalculator.this.batchHelper.getReport_Period();
            int[] start = null;
            int[] end = null;
            if (DyItemCalculator.this.isSupport13Period) {
                start = RPTDate13Util.getRptYearAndPeriod((int)rptYear, (int)rptPeriod, (int)this.int_periodType, (int)this.yearOffset, (int)this.startPeriodOffset, (boolean)DyItemCalculator.this.isSupport13Period);
                end = RPTDate13Util.getRptYearAndPeriod((int)rptYear, (int)rptPeriod, (int)this.int_periodType, (int)this.yearOffset, (int)this.endPeriodOffset, (boolean)DyItemCalculator.this.isSupport13Period);
            } else {
                start = FiscalPeriodHelper.getRptFormualYearAndPeriod((PeriodCollection)DyItemCalculator.this.periods, (int)rptYear, (int)rptPeriod, (int)this.int_periodType, (int)this.yearOffset, (int)this.startPeriodOffset, (boolean)DyItemCalculator.this.isMergeByFiscalPeriod);
                end = FiscalPeriodHelper.getRptFormualYearAndPeriod((PeriodCollection)DyItemCalculator.this.periods, (int)rptYear, (int)rptPeriod, (int)this.int_periodType, (int)this.yearOffset, (int)this.endPeriodOffset, (boolean)DyItemCalculator.this.isMergeByFiscalPeriod);
            }
            if (start == null) {
                this.startYear = rptYear;
                this.startPeriod = rptPeriod;
            } else {
                this.startYear = start[0];
                this.startPeriod = start[1];
            }
            if (end == null) {
                this.endYear = rptYear;
                this.endPeriod = rptPeriod;
            } else {
                this.endYear = end[0];
                this.endPeriod = end[1];
            }
            if (this.endYear < this.startYear || this.endYear == this.startYear && this.endPeriod < this.startPeriod) {
                throw new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"335_EndPeriodLessStartPeriod", (Locale)DyItemCalculator.this.serverContext.getLocale())});
            }
            if (this.orgUnitNumber == null || this.orgUnitNumber.trim().equals("")) {
                this.orgUnitNumber = DyItemCalculator.this.batchHelper.getOrgUnit_Number();
                if (StringUtils.isEmpty((String)this.orgUnitNumber)) {
                    this.orgUnitNumber = DyItemCalculator.this.batchHelper.getCompany_Number();
                }
                if (!StringUtils.isEmpty((String)DyItemCalculator.this.batchHelper.getOrgUnit_ID()) && (StringUtils.isEmpty((String)this.orgUnitID) || this.orgUnitID.trim().equals(""))) {
                    this.orgUnitID = DyItemCalculator.this.batchHelper.getOrgUnit_ID();
                }
            }
            if (this.orgBoundNumber == null || this.orgBoundNumber.trim().equals("")) {
                this.orgBoundNumber = DyItemCalculator.this.batchHelper.getOrgTreeNumber();
                if (this.orgBoundNumber == null || this.orgBoundNumber.trim().equals("")) {
                    this.orgBoundNumber = DyItemCalculator.this.batchHelper.getOrgTreeNumber(this.startYear, this.startPeriod, this.endYear, this.endPeriod, this.int_periodType, this.orgUnitNumber, DyItemCalculator.this.orgTreeMap, DyItemCalculator.this.periods, DyItemCalculator.this.isMergeByFiscalPeriod);
                }
                if (this.orgBoundNumber == null) {
                    throw new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"42_AcctItemCalcuter", (Locale)DyItemCalculator.this.serverContext.getLocale())});
                }
            }
            if ((isAdjustReport = (Integer)DyItemCalculator.this.batchHelper.getCalCulateContext().getReportAdapter().getReportProperty("isAdjustReport")) == null || isAdjustReport != 1) {
                if (this.int_dataSource == 10 && DyItemCalculator.this.calContext.getReportAdapter().getReportProperty("CSLReport_OrgTree_Number") == null) {
                    DyItemCalculator.this.batchHelper.checkCompanyPermision(this.orgUnitNumber);
                } else {
                    if (!StringUtils.isEmpty((String)this.orgBoundNumber)) {
                        DyItemCalculator.this.batchHelper.checkOrgTreePremision(this.orgBoundNumber);
                    }
                    DyItemCalculator.this.batchHelper.checkUnitCompPermision(this.orgUnitNumber);
                }
            }
            this.int_commitStatus = 3;
            this.dyItemNumIsNull = false;
            if (StringUtils.isEmpty((String)this.dyItemNumber)) {
                this.dyItemNumIsNull = true;
            }
            boolean isFastMergeRpt = FastMergeUtil.isFastMergeRpt((int)this.int_dataSource);
            if (StringUtils.isEmpty((String)this.mergeSchmNum) && isFastMergeRpt) {
                this.mergeSchmNum = (String)DyItemCalculator.this.batchHelper.getCalCulateContext().getReportAdapter().getReportProperty("MergeSchmNum");
            }
            if (!isFastMergeRpt) {
                this.mergeSchmNum = null;
            }
            if (!this.isShortNum && !this.dyItemNumIsNull && this.dyItemNumber.indexOf("!") < 0) {
                int gradeIndex = this.dyItemNumber.indexOf(".D_");
                if (gradeIndex > 0 && this.dyItemNumber.length() > gradeIndex + 3) {
                    String tmpNumber = this.dyItemNumber.substring(gradeIndex + 3);
                    this.dyItemNumber = this.dyItemNumber.substring(0, gradeIndex + 3) + tmpNumber.replaceAll("\\.", "!");
                } else {
                    this.dyItemNumber = this.dyItemNumber.replaceAll("\\.", "!");
                }
            }
        }

        private void initArgs() {
            Object[] args = null;
            args = this.param.getArgs()[0] instanceof Object[] ? (Object[])this.param.getArgs()[0] : this.param.getArgs();
            if (args.length >= 14) {
                this.orgBoundNumber = ((Variant)args[0]).getValue() == null ? null : ((Variant)args[0]).getValue().toString();
                this.orgUnitNumber = ((Variant)args[1]).getValue() == null ? null : ((Variant)args[1]).getValue().toString();
                this.sourceCurrencyNumber = ((Variant)args[2]).getValue() == null ? null : ((Variant)args[2]).getValue().toString();
                this.currencyNumber = ((Variant)args[3]).getValue() == null ? null : ((Variant)args[3]).getValue().toString();
                this.itemNumber = ((Variant)args[4]).getValue() == null ? null : ((Variant)args[4]).getValue().toString();
                this.dyItemNumber = ((Variant)args[5]).getValue() == null ? null : ((Variant)args[5]).getValue().toString();
                this.rptPeriodType = ((Variant)args[6]).getValue() == null ? null : ((Variant)args[6]).getValue().toString();
                this.yearOffset = Integer.parseInt(((Variant)args[7]).getValue().toString());
                this.startPeriodOffset = Integer.parseInt(((Variant)args[8]).getValue().toString());
                this.endPeriodOffset = Integer.parseInt(((Variant)args[9]).getValue().toString());
                this.dataSource = ((Variant)args[10]).getValue() == null ? null : ((Variant)args[10]).getValue().toString();
                this.dataElement = ((Variant)args[11]).getValue() == null ? null : ((Variant)args[11]).getValue().toString();
                this.valueType = ((Variant)args[12]).getValue() == null ? null : ((Variant)args[12]).getValue().toString();
                this.isAdjusted = (Boolean)((Variant)args[13]).getValue();
                if (args.length >= 15) {
                    this.isShortNum = (Boolean)((Variant)args[14]).getValue();
                }
                if (args.length >= 16) {
                    String string = this.dataCollectNumber = ((Variant)args[15]).getValue() == null ? null : ((Variant)args[15]).getValue().toString();
                }
                if (args.length >= 17) {
                    String string = this.mergeSchmNum = ((Variant)args[16]).getValue() == null ? null : ((Variant)args[16]).getValue().toString();
                }
                if (args.length >= 18 && (((Variant)args[17]).getValue() != null && ((Variant)args[17]).getValue().toString().equalsIgnoreCase("true") || ((Variant)args[17]).getValue().toString().equalsIgnoreCase("false"))) {
                    if (((Variant)args[17]).getValue() instanceof Boolean) {
                        this.isNeedCommitStatus = (Boolean)((Variant)args[17]).getValue() == false;
                    } else if (((Variant)args[17]).getValue() instanceof String) {
                        this.isNeedCommitStatus = Boolean.valueOf((String)((Variant)args[17]).getValue()) == false;
                    }
                }
            } else if (args.length == 13) {
                this.orgBoundNumber = ((Variant)args[0]).getValue() == null ? null : ((Variant)args[0]).getValue().toString();
                this.orgUnitNumber = ((Variant)args[1]).getValue() == null ? null : ((Variant)args[1]).getValue().toString();
                this.currencyNumber = ((Variant)args[2]).getValue() == null ? null : ((Variant)args[2]).getValue().toString();
                this.itemNumber = ((Variant)args[3]).getValue() == null ? null : ((Variant)args[3]).getValue().toString();
                this.dyItemNumber = ((Variant)args[4]).getValue() == null ? null : ((Variant)args[4]).getValue().toString();
                this.rptPeriodType = ((Variant)args[5]).getValue() == null ? null : ((Variant)args[5]).getValue().toString();
                this.yearOffset = Integer.parseInt(((Variant)args[6]).getValue().toString());
                this.startPeriodOffset = Integer.parseInt(((Variant)args[7]).getValue().toString());
                this.endPeriodOffset = Integer.parseInt(((Variant)args[8]).getValue().toString());
                this.dataSource = ((Variant)args[9]).getValue() == null ? null : ((Variant)args[9]).getValue().toString();
                this.dataElement = ((Variant)args[10]).getValue() == null ? null : ((Variant)args[10]).getValue().toString();
                this.valueType = ((Variant)args[11]).getValue() == null ? null : ((Variant)args[11]).getValue().toString();
                this.isAdjusted = (Boolean)((Variant)args[12]).getValue();
                this.dataCollectNumber = "ACTUALDATA";
            }
        }

        @Override
        public Parameter getParameter() {
            return this.param;
        }

        @Override
        public String getSheetName() {
            return this.param.getSheetName();
        }

        public void setException(Exception e) {
            this.e = e;
            this.isException = true;
        }

        @Override
        public Exception getException() {
            return this.e;
        }

        @Override
        public boolean isException() {
            return this.isException;
        }

        @Override
        public void putAllPerporties() {
            this.putPerport("orgUnitNumber", this.orgUnitNumber);
        }
    }
}

