/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.batch.dyitem;

import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.fi.gr.dynamic.util.MultiDynaItem;
import com.kingdee.eas.fi.rpt.batch.IBatchSQLSortState;
import com.kingdee.eas.fi.rpt.batch.IFormulaCalculator;
import com.kingdee.eas.fi.rpt.batch.dyitem.DyItemCalculator;
import com.kingdee.eas.fi.rpt.util.ObjectValueComparator;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class MultiDyItemSortState
implements IBatchSQLSortState {
    private static final Logger logger = CoreUIObject.getLogger(MultiDyItemSortState.class);
    private List formulaList;
    private ObjectValueComparator comparator = new ObjectValueComparator();
    private Map context;
    private Set rangeAsstSet;
    private Set multiCompanySet;
    private Set multiDataElementSet;
    private String orgTreeNumber;
    private String sourceCurrency;
    private String currency;
    private int periodType;
    private int startYear;
    private int startPeriod;
    private int endYear;
    private int endPeriod;
    private int dataSource;
    private int valueType;
    private List asstActTypeList;
    private List asstItemList;
    private Set asstItemSign;
    private boolean isNeedCommitStatus;
    private boolean isShortNum;
    private String dataCollectNumber;
    private String companyNumber;
    private int dataElement = -257;
    public static final int INI_DATAELEMENT = -257;
    private StringBuffer temp = new StringBuffer();

    public MultiDyItemSortState() {
        this.formulaList = new LinkedList();
    }

    @Override
    public List getFormulaList() {
        return this.formulaList;
    }

    @Override
    public String generateKey() {
        this.temp.setLength(0);
        this.temp.append("[").append(this.orgTreeNumber).append("]");
        this.temp.append("[").append(this.sourceCurrency == null ? "" : this.sourceCurrency).append("]");
        this.temp.append("[").append(this.currency).append("]");
        this.temp.append("[").append(this.periodType).append("]");
        this.temp.append("[").append(this.startYear).append("]");
        this.temp.append("[").append(this.startPeriod).append("]");
        this.temp.append("[").append(this.endYear).append("]");
        this.temp.append("[").append(this.endPeriod).append("]");
        this.temp.append("[").append(this.dataSource).append("]");
        this.temp.append("[").append(this.valueType).append("]");
        this.temp.append("[").append(this.isNeedCommitStatus).append("]");
        this.temp.append("[").append(this.isShortNum).append("]");
        this.temp.append("[").append(this.companyNumber == null ? "" : this.companyNumber).append("]");
        this.temp.append("[").append(this.dataElement).append("]");
        if (this.asstActTypeList != null && this.asstActTypeList.size() > 0) {
            for (AsstActTypeInfo asstActTypeInfo : this.asstActTypeList) {
                this.temp.append("[").append(asstActTypeInfo.getNumber()).append("]");
            }
            this.temp.append("|");
            for (AsstActTypeInfo asstActTypeInfo : this.asstActTypeList) {
                if (!this.asstItemSign.contains(asstActTypeInfo.getNumber())) continue;
                this.temp.append("[").append(asstActTypeInfo.getNumber()).append("]");
            }
            this.temp.append("|");
            if (this.asstItemList != null && this.asstItemList.size() > 0) {
                for (String[] asst : this.asstItemList) {
                    this.temp.append("[").append(asst[0]).append("|").append(asst[1]).append(":").append(asst[2]).append("]");
                }
            }
        }
        this.temp.append("[").append(this.dataCollectNumber).append("]");
        return this.temp.toString();
    }

    @Override
    public void addFormula(IFormulaCalculator formula) {
        this.formulaList.add(formula);
    }

    @Override
    public Object clone() {
        MultiDyItemSortState newState = new MultiDyItemSortState();
        newState.companyNumber = this.companyNumber;
        newState.orgTreeNumber = this.orgTreeNumber;
        newState.sourceCurrency = this.sourceCurrency;
        newState.currency = this.currency;
        newState.dataElement = this.dataElement;
        newState.periodType = this.periodType;
        newState.startYear = this.startYear;
        newState.startPeriod = this.startPeriod;
        newState.endYear = this.endYear;
        newState.endPeriod = this.endPeriod;
        newState.dataSource = this.dataSource;
        newState.valueType = this.valueType;
        newState.asstActTypeList = this.asstActTypeList;
        newState.isNeedCommitStatus = this.isNeedCommitStatus;
        newState.asstItemList = this.asstItemList;
        newState.asstItemSign = this.asstItemSign;
        newState.rangeAsstSet = this.rangeAsstSet;
        newState.multiCompanySet = this.multiCompanySet;
        newState.multiDataElementSet = this.multiDataElementSet;
        newState.isShortNum = this.isShortNum;
        newState.dataCollectNumber = this.dataCollectNumber;
        return newState;
    }

    @Override
    public void reset() {
        this.companyNumber = null;
        this.orgTreeNumber = null;
        this.sourceCurrency = null;
        this.currency = null;
        this.dataElement = -257;
        this.periodType = 0;
        this.startYear = 0;
        this.startPeriod = 0;
        this.endYear = 0;
        this.endPeriod = 0;
        this.dataSource = 0;
        this.valueType = 0;
        this.asstActTypeList = null;
        this.isNeedCommitStatus = false;
        this.asstItemList = null;
        this.asstItemSign = null;
        this.rangeAsstSet = null;
        this.multiCompanySet = null;
        this.multiDataElementSet = null;
        this.dataCollectNumber = null;
        this.isShortNum = false;
    }

    @Override
    public void setState(IFormulaCalculator formula) {
        DyItemCalculator.DyItem dyItem = (DyItemCalculator.DyItem)formula;
        this.multiCompanySet = (Set)this.context.get("company");
        if (this.multiCompanySet == null) {
            this.companyNumber = dyItem.orgUnitNumber;
        }
        this.orgTreeNumber = dyItem.orgBoundNumber;
        this.sourceCurrency = StringUtils.isEmpty((String)dyItem.sourceCurrencyNumber) ? null : dyItem.sourceCurrencyNumber;
        this.currency = dyItem.currencyNumber;
        this.multiDataElementSet = (Set)this.context.get("dataelement");
        if (this.multiDataElementSet == null) {
            this.dataElement = dyItem.int_dataElement;
        }
        this.periodType = dyItem.int_periodType;
        this.startYear = dyItem.startYear;
        this.startPeriod = dyItem.startPeriod;
        this.endYear = dyItem.endYear;
        this.endPeriod = dyItem.endPeriod;
        this.dataSource = dyItem.int_dataSource;
        this.valueType = dyItem.int_valueType;
        this.isShortNum = dyItem.isShortNum;
        this.setAsstActTypeList(dyItem.asstActTypeList);
        this.isNeedCommitStatus = dyItem.isNeedCommitStatus;
        MultiDynaItem dynaItemKey = dyItem.dynaItem;
        this.asstItemSign = new HashSet();
        this.rangeAsstSet = new HashSet();
        if (dynaItemKey != null && this.asstActTypeList != null) {
            for (AsstActTypeInfo asstActTypeInfo : this.asstActTypeList) {
                Map map;
                boolean isUseLongNumber = RptUtil.isUseLongNumber(asstActTypeInfo);
                String tableName = asstActTypeInfo.getRealtionDataObject();
                String numberOrLongNumber = isUseLongNumber && !this.isShortNum ? ".FLongNumber" : ".FNumber";
                String[] asstItemNumbers = dynaItemKey.getAsstItemNumbers(asstActTypeInfo.getNumber());
                if (asstItemNumbers != null && asstItemNumbers.length == 2 && !asstItemNumbers[0].equals(asstItemNumbers[1])) {
                    if (this.asstItemList == null) {
                        this.asstItemList = new ArrayList();
                    }
                    if (isUseLongNumber && !this.isShortNum) {
                        map = new HashMap();
                        if (tableName.equalsIgnoreCase("T_BD_GeneralAsstActType")) {
                            map = dyItem.generalAsstActTypeLongNumberMap;
                        } else if (tableName.equalsIgnoreCase("T_ORG_Admin")) {
                            map = dyItem.adminLongNumberMap;
                        } else if (tableName.equalsIgnoreCase("T_BD_CashFlowItem")) {
                            map = dyItem.cashFlowItemLongNumberMap;
                        } else if (tableName.equalsIgnoreCase("T_ORG_CostCenter")) {
                            map = dyItem.costCenterLongNumberMap;
                        }
                        String asstItemLongNumberFrom = map.get(asstItemNumbers[0]).toString();
                        String asstItemLongNumberTo = map.get(asstItemNumbers[1]).toString();
                        this.asstItemList.add(new String[]{asstActTypeInfo.getNumber(), asstItemLongNumberFrom, asstItemLongNumberTo, numberOrLongNumber});
                    } else {
                        this.asstItemList.add(new String[]{asstActTypeInfo.getNumber(), asstItemNumbers[0], asstItemNumbers[1], numberOrLongNumber});
                    }
                    this.rangeAsstSet.add(asstActTypeInfo.getNumber());
                    continue;
                }
                if (asstItemNumbers == null) continue;
                if (isUseLongNumber && !this.isShortNum) {
                    map = new HashMap();
                    if (tableName.equalsIgnoreCase("T_BD_GeneralAsstActType")) {
                        map = dyItem.generalAsstActTypeLongNumberMap;
                    } else if (tableName.equalsIgnoreCase("T_ORG_Admin")) {
                        map = dyItem.adminLongNumberMap;
                    } else if (tableName.equalsIgnoreCase("T_BD_CashFlowItem")) {
                        map = dyItem.cashFlowItemLongNumberMap;
                    } else if (tableName.equalsIgnoreCase("T_ORG_CostCenter")) {
                        map = dyItem.costCenterLongNumberMap;
                    }
                    if (map != null) {
                        String asstItemLongNumber = map.get(asstItemNumbers[0]).toString();
                        dynaItemKey.setAsstItemNumber(asstActTypeInfo.getNumber(), asstItemLongNumber);
                    } else {
                        dynaItemKey.setAsstItemNumber(asstActTypeInfo.getNumber(), asstItemNumbers[0]);
                    }
                }
                this.asstItemSign.add(asstActTypeInfo.getNumber());
            }
        }
        this.dataCollectNumber = dyItem.dataCollectNumber;
    }

    @Override
    public void setContext(Map context) {
        this.context = context;
    }

    public List getAsstActTypeList() {
        return this.asstActTypeList;
    }

    public void setAsstActTypeList(List asstActTypeList) {
        if (asstActTypeList != null && asstActTypeList.size() > 0) {
            this.comparator.setFieldName("number");
            Collections.sort(asstActTypeList, this.comparator);
            this.asstActTypeList = asstActTypeList;
        }
    }

    public String getOrgTreeNumber() {
        return this.orgTreeNumber;
    }

    public void setOrgTreeNumber(String orgTreeNumber) {
        this.orgTreeNumber = orgTreeNumber;
    }

    public String getSourceCurrency() {
        return this.sourceCurrency;
    }

    public void setSourceCurrency(String sourceCurrency) {
        this.sourceCurrency = sourceCurrency;
    }

    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public boolean getIsShortNum() {
        return this.isShortNum;
    }

    public int getPeriodType() {
        return this.periodType;
    }

    public void setPeriodType(int periodType) {
        this.periodType = periodType;
    }

    public int getStartYear() {
        return this.startYear;
    }

    public void setStartYear(int startYear) {
        this.startYear = startYear;
    }

    public int getStartPeriod() {
        return this.startPeriod;
    }

    public void setStartPeriod(int startPeriod) {
        this.startPeriod = startPeriod;
    }

    public int getEndYear() {
        return this.endYear;
    }

    public void setEndYear(int endYear) {
        this.endYear = endYear;
    }

    public int getEndPeriod() {
        return this.endPeriod;
    }

    public void setEndPeriod(int endPeriod) {
        this.endPeriod = endPeriod;
    }

    public int getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(int dataSource) {
        this.dataSource = dataSource;
    }

    public int getValueType() {
        return this.valueType;
    }

    public void setValueType(int valueType) {
        this.valueType = valueType;
    }

    public List getAsstItemList() {
        return this.asstItemList;
    }

    public void setAsstItemList(List asstItemList) {
        this.asstItemList = asstItemList;
    }

    public Set getAsstItemSign() {
        return this.asstItemSign;
    }

    public void setAsstItemSign(Set asstItemSign) {
        this.asstItemSign = asstItemSign;
    }

    public boolean isNeedCommitStatus() {
        return this.isNeedCommitStatus;
    }

    public void setNeedCommitStatus(boolean isNeedCommitStatus) {
        this.isNeedCommitStatus = isNeedCommitStatus;
    }

    public String getCompanyNumber() {
        return this.companyNumber;
    }

    public void setCompanyNumber(String companyNumber) {
        this.companyNumber = companyNumber;
    }

    public int getDataElement() {
        return this.dataElement;
    }

    public void setDataElement(int dataElement) {
        this.dataElement = dataElement;
    }

    public boolean isSamePeriod() {
        return this.startYear == this.endYear && this.startPeriod == this.endPeriod;
    }

    public boolean isSameYear() {
        return this.startYear == this.endYear;
    }

    public Set getRangeAsstSet() {
        return this.rangeAsstSet;
    }

    public Set getMultiCompanySet() {
        return this.multiCompanySet;
    }

    public Set getMultiDataElementSet() {
        return this.multiDataElementSet;
    }

    public String getDataCollectNumber() {
        return this.dataCollectNumber;
    }
}

