/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.batch.iref;

import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.IAsstActType;
import com.kingdee.eas.fi.rpt.batch.iref.AsstItemInfo;
import com.kingdee.eas.fi.rpt.batch.iref.ITranslator;
import com.kingdee.eas.fi.rpt.batch.iref.LRUMap;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class AcctItemAsstTranslator
implements ITranslator {
    private Context ctx;
    private List<AsstItemInfo> asstItems = new ArrayList<AsstItemInfo>(4);
    private static LRUMap<String, AsstActTypeInfo> cache = new LRUMap(8);
    private int size = 0;
    private int cursor = 0;

    public AcctItemAsstTranslator(Context ctx) {
        this.ctx = ctx;
        cache.setMaxSize(32);
    }

    @Override
    public void translate(String asstItemTypeStr, String asstItemStr) throws Exception {
        this.asstItems.clear();
        if (asstItemTypeStr == null || StringUtils.isEmpty((String)asstItemTypeStr) || "null".equalsIgnoreCase(asstItemTypeStr)) {
            return;
        }
        String[] splitTypeStr = asstItemTypeStr.split("\\|");
        String[] splitItemScopeStr = StringUtils.isEmpty((String)asstItemStr) ? null : asstItemStr.split("\\|");
        int index = 0;
        for (String type : splitTypeStr) {
            AsstActTypeInfo asstTypeInfo;
            String[] splitItemStr;
            String startItem = null;
            String endItem = null;
            if (splitItemScopeStr != null && splitItemScopeStr.length > index && (splitItemStr = splitItemScopeStr[index].split(":")).length >= 1) {
                startItem = splitItemStr[0];
                String string = endItem = splitItemStr.length == 2 ? splitItemStr[1] : null;
            }
            if ((asstTypeInfo = this.getAsstActTypeInfo(type)) != null) {
                this.asstItems.add(new AsstItemInfo(asstTypeInfo, startItem, endItem));
            }
            ++index;
        }
        this.size = this.asstItems.size();
        this.cursor = 0;
    }

    @Override
    public void reset() {
        this.cursor = 0;
        this.size = this.asstItems.size();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        Iterator<AsstItemInfo> it = this.asstItems.iterator();
        while (it.hasNext()) {
            sb.append(it.next());
        }
        return sb.toString();
    }

    private AsstActTypeInfo getAsstActTypeInfo(String asstTypeNumber) throws Exception {
        if (cache.containsKey(asstTypeNumber)) {
            return (AsstActTypeInfo)cache.get(asstTypeNumber);
        }
        IAsstActType facade = this.ctx == null ? AsstActTypeFactory.getRemoteInstance() : AsstActTypeFactory.getLocalInstance((Context)this.ctx);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.appendFilterItem("number", (Object)asstTypeNumber);
        view.setFilter(filter);
        AsstActTypeCollection typeColl = facade.getAsstActTypeCollection(view);
        cache.put(asstTypeNumber, typeColl.get(0));
        return typeColl.get(0);
    }

    @Override
    public boolean hasNext() {
        return this.size != this.cursor;
    }

    @Override
    public AsstItemInfo next() {
        return this.asstItems.get(this.cursor++);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public static void main(String[] args) throws Exception {
        AcctItemAsstTranslator translator = new AcctItemAsstTranslator(null);
        translator.translate("002|003", "a1:a5|b1:b5");
        while (translator.hasNext()) {
            System.out.println(translator.next());
        }
        translator.translate("002|003", "|b1:b5");
        while (translator.hasNext()) {
            System.out.println(translator.next());
        }
        translator.translate("002|003", "a1:a5|b1:b5|c1:c5");
        while (translator.hasNext()) {
            System.out.println(translator.next());
        }
    }
}

