/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.batch.iref;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.fi.gr.cslrpt.ValueTypeEnum;
import com.kingdee.eas.fi.newrpt.app.SQLBuilder;
import com.kingdee.eas.fi.rpt.batch.IBatchSQLSortState;
import com.kingdee.eas.fi.rpt.batch.IBatchSQLSorterProcessor;
import com.kingdee.eas.fi.rpt.batch.IFormulaCalculator;
import com.kingdee.eas.fi.rpt.batch.IFormulaCombinationPreparedState;
import com.kingdee.eas.fi.rpt.batch.iref.AsstItemInfo;
import com.kingdee.eas.fi.rpt.batch.iref.IRef;
import com.kingdee.eas.fi.rpt.batch.iref.IRefCombineState;
import com.kingdee.eas.fi.rpt.batch.iref.IRefSortState;
import com.kingdee.eas.fi.rpt.batch.iref.ITranslator;
import com.kingdee.eas.fi.rpt.batch.iref.IntegrateSchemeHelper;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class IRefBatchSQLProcessor
implements IBatchSQLSorterProcessor {
    IRefCombineState combine;
    IRefSortState sortState;
    Context ctx;
    protected static final String[] IndexResultSetFields = new String[]{"FCurrencyNum", "FDataElement"};
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.rpt.batch.iref.IRefBatchSQLProcessor");

    public IRefBatchSQLProcessor(Context ctx) {
        this.ctx = ctx;
        this.combine = new IRefCombineState();
    }

    @Override
    public IFormulaCombinationPreparedState getCombineState() {
        return this.combine;
    }

    @Override
    public Object[][] getIndexFormulaFields(IFormulaCalculator formula) {
        Object[][] result = new Object[1][];
        ArrayList<Object> fields = new ArrayList<Object>();
        IRef ref = (IRef)formula;
        fields.add(ref.currency);
        fields.add(ref.dataelement);
        result[0] = fields.toArray();
        return result;
    }

    @Override
    public String[] getIndexResultSetFields() {
        return IndexResultSetFields;
    }

    @Override
    public int getMaxSQLVaribleSize() {
        return 200;
    }

    @Override
    public void prepareStateForCombine(IRowSet rs, IFormulaCombinationPreparedState combineState) throws SQLException {
        IRefCombineState combine = (IRefCombineState)combineState;
        combine.setValue(rs.getObject("FValue"));
    }

    @Override
    public void buildSelectPart(Set nullSet, StringBuffer sql) {
        sql.append(" select currency.Fnumber FCurrencyNum,dataElement.FInterSeq FdataElement, \n").append(this.isTxtValue() ? this.getFiled(IntegrateSchemeHelper.Fields.ftxtvalue.name()) + " FValue \n" : "sum(" + this.getFiled(IntegrateSchemeHelper.Fields.famount.name()) + ") FValue \n");
    }

    @Override
    public void buildFromPart(Set nullSet, StringBuffer sql) {
        sql.append(" from ").append(this.sortState.keys.midTableName).append(" data \n").append(" join T_BD_Currency currency on " + this.getFiled(IntegrateSchemeHelper.Fields.fcurrencynum.name()) + " = currency.Fid \n").append(" join T_CSL_DataElement dataElement on dataElement.FInterSeq = " + this.getFiled(IntegrateSchemeHelper.Fields.fdataelement.name()) + " \n").append(" join T_BD_AccountView acct on acct.Fid = " + this.getFiled(IntegrateSchemeHelper.Fields.faccountnum.name()) + " \n").append(" JOIN T_ORG_BASEUNIT unit ON unit.Fid = " + this.getFiled(IntegrateSchemeHelper.Fields.fcompanynum.name()) + " \n").append("");
    }

    @Override
    public void buildGroupByPart(Set nullSet, StringBuffer sql) {
        sql.append(")");
        if (!this.isTxtValue()) {
            sql.append(" group by currency.Fnumber,dataElement.FInterSeq ");
        } else {
            sql.append(" order by ").append(this.getFiled(IntegrateSchemeHelper.Fields.fbizdate.name())).append(" desc ");
        }
    }

    private boolean isTxtValue() {
        return this.sortState.keys.valueType == ValueTypeEnum.TXT;
    }

    @Override
    public void buildVariableWherePart(StringBuffer sql, List params, IFormulaCalculator formula) {
        IRef iref = (IRef)formula;
        sql.append(" (currency.Fnumber = ? \n");
        params.add(iref.currency);
        sql.append(" and dataElement.FInterSeq = ? ) \n");
        params.add(iref.dataelement);
    }

    @Override
    public void builderConstantWherePart(Set nullSet, StringBuffer sql, List params) {
        SQLBuilder builder = new SQLBuilder();
        builder.append("  where unit.fnumber = ? ", (Object)this.sortState.keys.company);
        builder.append(" and (").append(this.getFiled(IntegrateSchemeHelper.Fields.fbizdate.name())).append(" >= ?", (Object)this.sortState.keys.startDate);
        builder.append(" and ").append(this.getFiled(IntegrateSchemeHelper.Fields.fbizdate.name())).append(" <= ? ) \n", (Object)this.sortState.keys.endDate);
        if (StringUtils.isEmpty((String)this.sortState.keys.acctTo)) {
            builder.append(" and ").append(" acct.fnumber = ? \n", (Object)this.sortState.keys.acctFrom);
        } else {
            builder.append(" and (").append(" acct.fnumber >= ? \n", (Object)this.sortState.keys.acctFrom);
            builder.append(" and ").append(" acct.fnumber <= ?) \n", (Object)this.sortState.keys.acctTo);
        }
        builder.append(" and ").append(this.getFiled(IntegrateSchemeHelper.Fields.fvaluetype.name())).append(" = ? \n", (Object)this.sortState.keys.valueType.getValue());
        builder.append(" and ").append(this.getFiled(IntegrateSchemeHelper.Fields.forgtype.name())).append(" = ? ", (Object)this.sortState.keys.orgType.getValue());
        this.buildAsstFilter(builder, this.sortState.keys.translator);
        sql.append(builder.getSQL());
        params.addAll(Arrays.asList(builder.getParams()));
        sql.append(" AND (");
    }

    public void buildAsstFilter(SQLBuilder builder, ITranslator translator) {
        translator.reset();
        StringBuffer asstTypeSerial = new StringBuffer(20);
        boolean hasMoreOne = false;
        int columnIndex = 1;
        while (translator.hasNext()) {
            AsstItemInfo itemInfo = (AsstItemInfo)translator.next();
            if (hasMoreOne) {
                asstTypeSerial.append("|");
            }
            asstTypeSerial.append(itemInfo.getAsstType().getNumber());
            if (StringUtils.isEmpty((String)itemInfo.getEndItem()) && !StringUtils.isEmpty((String)itemInfo.getStartItem())) {
                builder.append(" and ").append(this.getFiled("fasst" + columnIndex + "_number")).append(" = ? ", (Object)itemInfo.getStartItem());
            } else if (!StringUtils.isEmpty((String)itemInfo.getEndItem()) && !StringUtils.isEmpty((String)itemInfo.getStartItem())) {
                builder.append(" and ").append(this.getFiled("fasst" + columnIndex + "_number")).append(" >= ? ", (Object)itemInfo.getStartItem());
                builder.append(" and ").append(this.getFiled("fasst" + columnIndex + "_number")).append(" <= ? ", (Object)itemInfo.getEndItem());
            }
            hasMoreOne = true;
            ++columnIndex;
        }
        if (hasMoreOne) {
            builder.append(" and ").append(this.getFiled(IntegrateSchemeHelper.Fields.fasst_number.name())).append(" = ?", (Object)asstTypeSerial.toString());
        }
    }

    @Override
    public Set getAllowedNullFields() {
        return null;
    }

    @Override
    public List getFormulaCalculators() {
        return this.sortState.getFormulaList();
    }

    @Override
    public void setSortState(IBatchSQLSortState sortState) {
        this.sortState = (IRefSortState)sortState;
    }

    public String getFiled(String fieldName) {
        return "data." + this.columnName(fieldName);
    }

    private String columnName(String fieldName) {
        try {
            return IntegrateSchemeHelper.getInstance().getTableColumnName(this.ctx, this.sortState.keys.company, fieldName, this.sortState.keys.orgType);
        }
        catch (BOSException e) {
            logger.error((Object)e);
            return fieldName;
        }
    }
}

