/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.batch.temptablescheme;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.fi.rpt.batch.temptablescheme.ITempTableField;
import com.kingdee.eas.fi.rpt.batch.temptablescheme.TempTableFieldItem;
import com.kingdee.eas.fi.rpt.batch.temptablescheme.TempTableJdbcTemplate;
import com.kingdee.eas.fi.rpt.batch.temptablescheme.TempTableValue;
import com.kingdee.eas.fi.rpt.jdbc.BatchPreparedStatementSetter;
import com.kingdee.eas.fi.rpt.jdbc.PreparedStatementCreatorFactory;
import com.kingdee.eas.fi.rpt.jdbc.PreparedStatementSetter;
import com.kingdee.eas.fi.rpt.jdbc.SqlParameter;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class TempTableValueInsertUtil {
    private static final int DEFAULT_BATCH_SIZE = 5000;
    private static final String NVARCHAR_44 = "nvarchar(44)";
    private static final String NVARCHAR_200 = "nvarchar(200)";

    public static void insertValueIntoTempTable(TempTableJdbcTemplate tempTableJdbcTemplate, ITempTableField tempTableField, String tempTableName, List valuesList) throws BOSException {
        ArrayList declaredParameters = new ArrayList();
        String insertSQL = TempTableValueInsertUtil.buildInsertTempTableSQL(tempTableName, tempTableField, declaredParameters);
        PreparedStatementCreatorFactory preparedStatementCreatorFactory = new PreparedStatementCreatorFactory(insertSQL, declaredParameters);
        TempTableValueInsertUtil.insertIntoTempTable(tempTableJdbcTemplate, insertSQL, valuesList, preparedStatementCreatorFactory);
    }

    private static String buildInsertTempTableSQL(String tempTableName, ITempTableField tempTableField, List declaredParameters) {
        StringBuffer sql = new StringBuffer();
        StringBuffer placeholder = new StringBuffer();
        sql.append("INSERT INTO ").append(tempTableName).append(" (");
        Iterator it = tempTableField.getTempTableFieldItems().iterator();
        while (it.hasNext()) {
            TempTableFieldItem tempTableFieldItem = (TempTableFieldItem)it.next();
            String tempTableFieldName = tempTableFieldItem.getTempTableField();
            sql.append(tempTableFieldName);
            placeholder.append("?");
            SqlParameter sqlParameter = tempTableFieldItem.getSqlParameter();
            if (sqlParameter == null) {
                sqlParameter = "dyItemNumber".equals(tempTableFieldName) ? new SqlParameter(tempTableFieldName, 12, NVARCHAR_200) : new SqlParameter(tempTableFieldName, 12, NVARCHAR_44);
            }
            declaredParameters.add(sqlParameter);
            if (!it.hasNext()) continue;
            sql.append(",");
            placeholder.append(",");
        }
        sql.append(") VALUES (");
        sql.append(placeholder).append(")");
        return sql.toString();
    }

    private static void insertIntoTempTable(TempTableJdbcTemplate tempTableJdbcTemplate, String sql, List valuesList, PreparedStatementCreatorFactory preparedStatementCreatorFactory) throws BOSException {
        LinkedList batchList = new LinkedList();
        Iterator it = valuesList.iterator();
        while (it.hasNext()) {
            batchList.add(it.next());
            if (batchList.size() != 5000) continue;
            TempTableValueInsertUtil.flush(tempTableJdbcTemplate, sql, batchList, preparedStatementCreatorFactory);
        }
        TempTableValueInsertUtil.flush(tempTableJdbcTemplate, sql, batchList, preparedStatementCreatorFactory);
    }

    private static void flush(TempTableJdbcTemplate tempTableJdbcTemplate, String sql, final LinkedList batchList, final PreparedStatementCreatorFactory preparedStatementCreatorFactory) throws BOSException {
        tempTableJdbcTemplate.batchUpdate(sql, new BatchPreparedStatementSetter(){

            @Override
            public int getBatchSize() {
                return batchList.size();
            }

            @Override
            public void setValues(PreparedStatement ps, int i) throws SQLException {
                TempTableValue tempTableValue = (TempTableValue)batchList.removeFirst();
                PreparedStatementSetter preparedStatementSetter = TempTableValueInsertUtil.newPreparedStatementSetter(preparedStatementCreatorFactory, tempTableValue);
                preparedStatementSetter.setValues(ps);
            }
        });
    }

    private static PreparedStatementSetter newPreparedStatementSetter(PreparedStatementCreatorFactory preparedStatementCreatorFactory, TempTableValue tempTableValue) {
        PreparedStatementSetter preparedStatementSetter = (PreparedStatementSetter)((Object)preparedStatementCreatorFactory.newPreparedStatementCreator(tempTableValue.values()));
        return preparedStatementSetter;
    }
}

