/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.batchquery;

import com.kingdee.eas.fi.rpt.batchquery.StateQueryParamerManager;
import com.kingdee.eas.fi.rpt.batchquery.sql.DynTable;
import com.kingdee.eas.fi.rpt.batchquery.sql.GroupByPart;
import com.kingdee.eas.fi.rpt.batchquery.sql.IWhereItem;
import com.kingdee.eas.fi.rpt.batchquery.sql.WhereItem;
import com.kingdee.eas.fi.rpt.batchquery.sql.WhereItems;
import com.kingdee.eas.fi.rpt.util.DebugLogger;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class HasLikeOperatorStateParamerManager
extends StateQueryParamerManager {
    private static Logger logger = Logger.getLogger(HasLikeOperatorStateParamerManager.class);
    private String selectPartSQL = null;
    private String staticFromPartSQL = null;
    private String staticWherePart = null;
    private String groupByPartSQL = null;
    ArrayList itemList = null;
    private int groupSize = 1;
    private int curIndex = 0;
    String[] groupConditionFields = null;

    public HasLikeOperatorStateParamerManager(Connection _conn, HashMap sysContext) {
        super(_conn, sysContext);
    }

    @Override
    public boolean hasMoreToQuery() {
        return this.curIndex < this.itemList.size();
    }

    @Override
    public PreparedStatement nextStatement() throws Exception {
        if (this.hasMoreToQuery()) {
            PreparedStatement ps = null;
            ps = this.itemList.size() - this.curIndex > this.groupSize ? this.bulidPreparedStatement(this.groupSize) : this.bulidPreparedStatement(this.itemList.size() - this.curIndex);
            return ps;
        }
        return null;
    }

    @Override
    public void prepareForQueryStatement() throws Exception {
        int wheresize;
        ArrayList gList;
        this.itemList = this.getSQL().getWherePart().getAutoPartList();
        if (this.itemList.size() == 0) {
            throw new Exception("Has No Auto Part");
        }
        for (int i = 0; i < this.itemList.size(); ++i) {
            ((IWhereItem)this.itemList.get(i)).setSysContext(this.getSysContext());
        }
        IWhereItem whereItem = (IWhereItem)this.itemList.get(0);
        whereItem.setSysContext(this.getSysContext());
        ArrayList condSelectFields = whereItem.generateGroupConditionFields();
        if (condSelectFields == null || condSelectFields.size() == 0) {
            throw new Exception("No Group Condition Fields");
        }
        this.groupConditionFields = this.generateConditionFieldsAndInsertConditionFieldsToSelectFields(condSelectFields);
        whereItem.insertIntoGroupByList();
        int singleSize = whereItem.size() + 5;
        this.selectPartSQL = this.getSQL().getSelectPart().toString();
        this.staticFromPartSQL = this.getSQL().getFromPartSql().toString();
        if (this.getSQL().getWherePart().getStaticWherePart() != null) {
            this.staticWherePart = this.getSQL().getWherePart().getStaticWherePart().getSqlString();
        }
        if ((gList = (ArrayList)this.getSysContext().get("GroupBy")) != null && gList.size() > 0) {
            Iterator it = gList.iterator();
            GroupByPart gp = this.getSQL().getGroupByPart();
            while (it.hasNext()) {
                gp.addGroupByItem(it.next().toString());
            }
        }
        this.groupByPartSQL = this.getSQL().getGroupByPart().toString();
        int size = 65535;
        size -= this.selectPartSQL.length();
        size -= this.staticFromPartSQL.length();
        if (this.staticWherePart != null) {
            size -= this.staticWherePart.length();
        }
        if (this.groupByPartSQL != null) {
            size -= this.groupByPartSQL.length();
        }
        this.groupSize = size / singleSize > (wheresize = this.getWhereSize()) ? wheresize : size / singleSize;
        this.curIndex = 0;
    }

    private PreparedStatement bulidPreparedStatement(int size) throws Exception {
        HashMap<String, String> someLikeFilter = new HashMap<String, String>();
        String outLineWhereItemString = null;
        HashMap dynTables = (HashMap)this.getSysContext().get("DynTables");
        if (dynTables != null) {
            for (DynTable dynTable : dynTables.values()) {
                dynTable.clearDynTableValueList();
            }
        }
        boolean isDynFromPartISNull = true;
        StringBuffer bufDynFromPart = new StringBuffer();
        boolean isbufAutoWhereItemListIsNull = true;
        StringBuffer bufAutoWhereItemList = new StringBuffer();
        IWhereItem whereItem = (IWhereItem)this.itemList.get(this.curIndex);
        boolean isDefaultMask = whereItem.isDefaultMask();
        if (isDefaultMask) {
            outLineWhereItemString = whereItem.outLineLikeItems();
        }
        dynTables = (HashMap)this.getSysContext().get("DynTables");
        bufAutoWhereItemList.append("(");
        int i = 0;
        while (i < size) {
            String keyWithoutLikeString;
            whereItem = (IWhereItem)this.itemList.get(this.curIndex);
            whereItem.setSysContext(this.getSysContext());
            IWhereItem dynTableWhereItem = whereItem.insertIntoDynTable();
            if (dynTableWhereItem != null && whereItem instanceof WhereItems) {
                if (dynTableWhereItem instanceof WhereItems) {
                    ((WhereItems)whereItem).addItems((WhereItems)dynTableWhereItem);
                } else {
                    ((WhereItems)whereItem).addItem((WhereItem)dynTableWhereItem);
                }
            }
            if ((keyWithoutLikeString = whereItem.keyWithOutLikeString()) != null && someLikeFilter.get(keyWithoutLikeString) == null) {
                isbufAutoWhereItemListIsNull = false;
                someLikeFilter.put(keyWithoutLikeString, keyWithoutLikeString);
                if (i > 0) {
                    bufAutoWhereItemList.append("OR");
                }
                bufAutoWhereItemList.append(!isDefaultMask ? whereItem.getSqlString() : whereItem.afterOutLineLikeItemsStrSQL());
            }
            ++i;
            ++this.curIndex;
        }
        bufAutoWhereItemList.append(")");
        if (dynTables != null) {
            for (DynTable dynTable : dynTables.values()) {
                bufDynFromPart.append(" INNER JOIN ");
                bufDynFromPart.append(dynTable.toString());
                isDynFromPartISNull = false;
            }
        }
        StringBuffer sqlBuf = new StringBuffer();
        sqlBuf.append(this.selectPartSQL);
        sqlBuf.append(this.staticFromPartSQL);
        if (!isDynFromPartISNull) {
            sqlBuf.append(bufDynFromPart);
        }
        if (this.staticWherePart != null || !isbufAutoWhereItemListIsNull || outLineWhereItemString != null) {
            sqlBuf.append(" WHERE ");
            boolean needAndFlag = false;
            if (this.staticWherePart != null) {
                sqlBuf.append(this.staticWherePart);
                needAndFlag = true;
            }
            if (outLineWhereItemString != null) {
                if (needAndFlag) {
                    sqlBuf.append("AND");
                }
                sqlBuf.append(outLineWhereItemString);
                needAndFlag = true;
            }
            if (!isbufAutoWhereItemListIsNull) {
                if (needAndFlag) {
                    sqlBuf.append("AND");
                }
                sqlBuf.append(bufAutoWhereItemList);
            }
        }
        if (this.groupByPartSQL != null) {
            sqlBuf.append(this.groupByPartSQL);
        }
        PreparedStatement ps = this.conn.prepareStatement(sqlBuf.toString());
        DebugLogger.info(logger, "Acct HasLikeOperatorStateParamerManager kql", sqlBuf);
        return ps;
    }

    @Override
    public String[] getGroupConditionFields() {
        return this.groupConditionFields;
    }
}

