/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.batchquery;

import com.kingdee.eas.fi.rpt.batchquery.StateQueryParamerManager;
import com.kingdee.eas.fi.rpt.batchquery.sql.GroupByPart;
import com.kingdee.eas.fi.rpt.batchquery.sql.IWhereItem;
import com.kingdee.eas.fi.rpt.batchquery.sql.PreparedStatementRef;
import com.kingdee.eas.fi.rpt.util.DebugLogger;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class NoLikeOperatorStateParamerManager
extends StateQueryParamerManager {
    private static Logger logger = Logger.getLogger(NoLikeOperatorStateParamerManager.class);
    private String firstPartSQL = null;
    private String endPartSQL = null;
    private String singleWhereItemParamSql = null;
    ArrayList itemList = null;
    private int groupSize = 1;
    private int curIndex = 0;
    String[] groupConditionFields = null;
    private HashMap context = new HashMap(1);

    public NoLikeOperatorStateParamerManager(Connection _conn, HashMap sysContext) {
        super(_conn, sysContext);
    }

    @Override
    public boolean hasMoreToQuery() {
        return this.curIndex < this.itemList.size();
    }

    @Override
    public PreparedStatement nextStatement() throws Exception {
        if (this.hasMoreToQuery()) {
            PreparedStatement ps = null;
            int size = 0;
            if (this.itemList.size() - this.curIndex > this.groupSize) {
                ps = this.bulidPreparedStatement(this.groupSize);
                size = this.groupSize;
            } else {
                ps = this.bulidPreparedStatement(this.itemList.size() - this.curIndex);
                size = this.itemList.size() - this.curIndex;
            }
            if (this.isSysRunInParamMode()) {
                PreparedStatementRef psRef = new PreparedStatementRef(ps);
                int i = 0;
                while (i < size) {
                    ((IWhereItem)this.itemList.get(this.curIndex)).loadParamToPreparedStatement(psRef);
                    ++i;
                    ++this.curIndex;
                }
            }
            return ps;
        }
        return null;
    }

    @Override
    public void prepareForQueryStatement() throws Exception {
        int wheresize;
        this.itemList = this.getSQL().getWherePart().getAutoPartList();
        if (this.itemList.size() == 0) {
            throw new Exception("Has No Auto Part");
        }
        for (int i = 0; i < this.itemList.size(); ++i) {
            ((IWhereItem)this.itemList.get(i)).setSysContext(this.getSysContext());
        }
        IWhereItem whereItem = (IWhereItem)this.itemList.get(0);
        whereItem.setSysContext(this.getSysContext());
        ArrayList condSelectFields = whereItem.generateGroupConditionFields();
        if (condSelectFields == null || condSelectFields.size() == 0) {
            throw new Exception("No Group Condition Fields");
        }
        this.groupConditionFields = this.generateConditionFieldsAndInsertConditionFieldsToSelectFields(condSelectFields);
        String selectPart = this.getSQL().getSelectPart().toString();
        whereItem.insertIntoGroupByList();
        this.singleWhereItemParamSql = whereItem.getParamedSql();
        int singleSize = whereItem.size() + 5;
        String fromPart = this.getSQL().getFromPartSql().toString();
        String staticWherePart = null;
        if (this.getSQL().getWherePart().getStaticWherePart() != null) {
            staticWherePart = this.getSQL().getWherePart().getStaticWherePart().getSqlString();
        }
        this.firstPartSQL = staticWherePart != null ? selectPart + fromPart + " WHERE " + staticWherePart + " AND " : selectPart + fromPart + " WHERE ";
        ArrayList gList = (ArrayList)this.getSysContext().get("GroupBy");
        if (gList != null && gList.size() > 0) {
            Iterator it = gList.iterator();
            GroupByPart gp = this.getSQL().getGroupByPart();
            while (it.hasNext()) {
                gp.addGroupByItem(it.next().toString());
            }
        }
        this.endPartSQL = this.getSQL().getGroupByPart().toString();
        int size = 65535;
        size -= this.firstPartSQL.length();
        if (this.endPartSQL != null) {
            size -= this.endPartSQL.length();
        }
        this.groupSize = size / singleSize > (wheresize = this.getWhereSize()) ? wheresize : size / singleSize;
        this.curIndex = 0;
    }

    private PreparedStatement bulidPreparedStatement(int size) throws Exception {
        if (this.isSysRunInParamMode()) {
            PreparedStatement ps = null;
            if (ps == null) {
                StringBuffer buf = new StringBuffer();
                buf.append(this.firstPartSQL);
                buf.append("(");
                for (int i = 0; i < size; ++i) {
                    if (i > 0) {
                        buf.append("OR");
                    }
                    buf.append(this.singleWhereItemParamSql);
                }
                buf.append(")");
                if (this.endPartSQL != null) {
                    buf.append(this.endPartSQL);
                }
                ps = this.conn.prepareStatement(buf.toString());
                this.context.put(Integer.toString(size), ps);
            }
            return ps;
        }
        StringBuffer buf = new StringBuffer();
        buf.append(this.firstPartSQL);
        buf.append("(");
        int i = 0;
        while (i < size) {
            if (i > 0) {
                buf.append("OR");
            }
            buf.append(((IWhereItem)this.itemList.get(this.curIndex)).getSqlString());
            ++i;
            ++this.curIndex;
        }
        buf.append(")");
        if (this.endPartSQL != null) {
            buf.append(this.endPartSQL);
        }
        PreparedStatement ps = this.conn.prepareStatement(buf.toString());
        DebugLogger.info(logger, "Acct NoLikeOperatorStateParamerManager kql", buf);
        return ps;
    }

    @Override
    public String[] getGroupConditionFields() {
        return this.groupConditionFields;
    }
}

