/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.batchquery.sql;

import com.kingdee.eas.fi.rpt.batchquery.sql.IWhereItem;
import com.kingdee.eas.fi.rpt.batchquery.sql.IWhereItemSQLGenerater;
import com.kingdee.eas.fi.rpt.batchquery.sql.PreparedStatementRef;
import com.kingdee.eas.fi.rpt.batchquery.sql.WhereItem;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class WhereItems
extends IWhereItem {
    private ArrayList items = new ArrayList();
    private String mask = null;
    private boolean hasLikeOperator = false;
    private boolean isDefaultMask = true;
    private WhereItems parentItems = null;

    public WhereItems() {
        super(null);
    }

    public void setParentItems(WhereItems _parent) {
        this.parentItems = _parent;
    }

    private void setHasLikeOperator() {
        this.hasLikeOperator = true;
        if (this.parentItems != null) {
            this.parentItems.setHasLikeOperator();
        }
    }

    private void setNoDefaultMask() {
        this.isDefaultMask = false;
        if (this.parentItems != null) {
            this.parentItems.setNoDefaultMask();
        }
    }

    public void addItems(WhereItems whereItems) {
        whereItems.setParentItems(this);
        if (whereItems.hasLikeOperator() && !this.hasLikeOperator) {
            this.setHasLikeOperator();
        }
        this.items.add(whereItems);
        if (!whereItems.isDefaultMask() && this.isDefaultMask) {
            this.setNoDefaultMask();
        }
    }

    public void addItem(WhereItem whereItem) {
        if (whereItem.hasLikeOperator() && !this.hasLikeOperator) {
            this.setHasLikeOperator();
        }
        this.items.add(whereItem);
    }

    public void setMask(String _mask) {
        this.mask = _mask;
        this.setNoDefaultMask();
    }

    @Override
    public String getSqlString() throws Exception {
        return this.generateSQL(false);
    }

    @Override
    public String getParamedSql() throws Exception {
        return this.generateSQL(true);
    }

    private String generateSQL(boolean isParamed) throws Exception {
        if (this.items.size() == 0) {
            throw new Exception("WhereItems is Emptity");
        }
        StringBuffer buf = new StringBuffer();
        if (this.items.size() == 1 && this.mask == null) {
            if (isParamed) {
                buf.append(((IWhereItem)this.items.get(0)).getParamedSql());
            } else {
                buf.append(((IWhereItem)this.items.get(0)).getSqlString());
            }
        } else {
            int i;
            int size;
            if (this.mask == null) {
                StringBuffer tempBuf = new StringBuffer();
                size = this.items.size();
                for (i = 0; i < size; ++i) {
                    if (i > 0) {
                        tempBuf.append("AND");
                    }
                    tempBuf.append("#");
                }
                this.mask = tempBuf.toString();
            }
            Iterator it = this.items.iterator();
            buf.append("(");
            size = this.mask.length();
            for (i = 0; i < size; ++i) {
                if (this.mask.charAt(i) == '#') {
                    if (it.hasNext()) {
                        IWhereItem item = (IWhereItem)it.next();
                        if (isParamed) {
                            buf.append(item.getParamedSql());
                            continue;
                        }
                        buf.append(item.getSqlString());
                        continue;
                    }
                    throw new Exception("Mask in WhereItems is Not march Items ");
                }
                buf.append(this.mask.charAt(i));
            }
            if (it.hasNext()) {
                throw new Exception("Mask in WhereItems is Not march Items ");
            }
            buf.append(")");
        }
        return buf.toString();
    }

    @Override
    public void setIsSupportParamerModeState(boolean _isSupportParamerMode) {
        for (IWhereItem item : this.items) {
            item.setIsSupportParamerModeState(_isSupportParamerMode);
        }
    }

    @Override
    public void loadParamToPreparedStatement(PreparedStatementRef _ps) throws SQLException {
        for (IWhereItem item : this.items) {
            item.loadParamToPreparedStatement(_ps);
        }
    }

    @Override
    public int size() throws Exception {
        if (this.items.size() == 0) {
            throw new Exception("WhereItems is Emptity");
        }
        if (this.items.size() == 1 && this.mask == null) {
            return ((IWhereItem)this.items.get(0)).size();
        }
        int size = this.mask == null ? this.items.size() * 4 : this.mask.length();
        size -= this.items.size();
        for (IWhereItem item : this.items) {
            size += item.size();
        }
        return size += 2;
    }

    @Override
    public boolean hasLikeOperator() {
        return this.hasLikeOperator;
    }

    @Override
    public void setWhereItemSQLGenerater(IWhereItemSQLGenerater generator) {
        for (IWhereItem item : this.items) {
            item.setWhereItemSQLGenerater(generator);
        }
    }

    @Override
    public ArrayList generateGroupConditionFields() {
        ArrayList list = new ArrayList();
        for (IWhereItem item : this.items) {
            ArrayList tempList = item.generateGroupConditionFields();
            if (tempList == null) continue;
            list.addAll(tempList);
        }
        if (list.size() == 0) {
            return null;
        }
        return list;
    }

    @Override
    public void setSysContext(HashMap _sysContext) {
        super.setSysContext(_sysContext);
        for (IWhereItem item : this.items) {
            item.setSysContext(_sysContext);
        }
    }

    @Override
    public IWhereItem insertIntoDynTable() {
        Iterator it = this.items.iterator();
        WhereItems whereItems = new WhereItems();
        while (it.hasNext()) {
            IWhereItem item = (IWhereItem)it.next();
            if (!item.hasLikeOperator()) continue;
            whereItems.addItem((WhereItem)item.insertIntoDynTable());
        }
        return whereItems;
    }

    @Override
    public void insertIntoGroupByList() {
        for (IWhereItem item : this.items) {
            item.insertIntoGroupByList();
        }
    }

    @Override
    public String keyString() {
        return this.keyXString(false);
    }

    @Override
    public String keyWithOutLikeString() {
        if (!this.hasLikeOperator()) {
            return this.keyString();
        }
        return this.keyXString(true);
    }

    private String keyXString(boolean isWithOutLikeString) {
        StringBuffer buf = new StringBuffer();
        boolean isNull = true;
        Iterator it = this.items.iterator();
        boolean isFirst = true;
        while (it.hasNext()) {
            IWhereItem item = (IWhereItem)it.next();
            String str = isWithOutLikeString ? item.keyWithOutLikeString() : item.keyString();
            if (str == null) continue;
            if (!isFirst) {
                buf.append("|");
            } else {
                isFirst = false;
            }
            buf.append(str);
            isNull = false;
        }
        if (isNull) {
            return null;
        }
        return buf.toString();
    }

    @Override
    public boolean isDefaultMask() {
        return this.isDefaultMask;
    }

    @Override
    public String outLineLikeItems() throws Exception {
        return this.generateXOutLineString(1);
    }

    @Override
    public String afterOutLineLikeItemsParamedSQL() throws Exception {
        return this.generateXOutLineString(2);
    }

    @Override
    public String afterOutLineLikeItemsStrSQL() throws Exception {
        return this.generateXOutLineString(3);
    }

    private String generateXOutLineString(int type) throws Exception {
        StringBuffer buf = new StringBuffer();
        boolean isNull = true;
        Iterator it = this.items.iterator();
        boolean isFirst = true;
        buf.append("(");
        while (it.hasNext()) {
            IWhereItem item = (IWhereItem)it.next();
            String str = null;
            switch (type) {
                case 1: {
                    str = item.outLineLikeItems();
                    break;
                }
                case 2: {
                    str = item.afterOutLineLikeItemsParamedSQL();
                    break;
                }
                case 3: {
                    str = item.afterOutLineLikeItemsStrSQL();
                }
            }
            if (str == null) continue;
            if (!isFirst) {
                buf.append("AND");
            } else {
                isFirst = false;
            }
            buf.append(str);
            isNull = false;
        }
        buf.append(")");
        if (isNull) {
            return null;
        }
        return buf.toString();
    }

    @Override
    public void setIsSupportGroupBy(boolean isSupport) {
        for (IWhereItem item : this.items) {
            item.setIsSupportGroupBy(isSupport);
        }
    }

    @Override
    public boolean getIsSupportConditionFiled() {
        Iterator it = this.items.iterator();
        if (it.hasNext()) {
            IWhereItem item = (IWhereItem)it.next();
            return item.getIsSupportConditionFiled();
        }
        return false;
    }

    @Override
    public void setIsSupportConditionFiled(boolean _isResultIdentifyConditionFiled) {
        for (IWhereItem item : this.items) {
            item.setIsSupportConditionFiled(_isResultIdentifyConditionFiled);
        }
    }

    public void addItem(String left, String right) {
        this.addItem(new WhereItem(left, right));
    }

    public void addItem(String left, String right, int op) {
        this.addItem(new WhereItem(left, right, op));
    }

    public void addItem(String left, int right) {
        this.addItem(new WhereItem(left, right));
    }

    public void addItem(String left, int right, int op) {
        this.addItem(new WhereItem(left, right, op));
    }
}

