/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.client;

import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.uiframe.client.GetDataDialog;
import com.kingdee.eas.base.uiframe.client.GetDataTaskAdapter;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.CompanyF7;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.rpt.AccountORMFactory;
import com.kingdee.eas.fi.rpt.AccountORMInfo;
import com.kingdee.eas.fi.rpt.client.AbstractAccountORMEditUI;
import com.kingdee.eas.fi.rpt.k3.webservice.K3WebServiceContext;
import com.kingdee.eas.fi.rpt.k3.webservice.K3WebServiceFacade;
import com.kingdee.eas.fi.rpt.k3.webservice.impl.AisInfo;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.eas.fi.rpt.util.RptUtilForClient;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.ComponentUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class AccountORMEditUI
extends AbstractAccountORMEditUI {
    private static final Logger logger = CoreUIObject.getLogger(AccountORMEditUI.class);
    private K3WebServiceContext k3WebServiceContext = new K3WebServiceContext();
    private Map aisMap = new HashMap();
    private CompanyOrgUnitInfo oldCompany;

    public void onLoad() throws Exception {
        super.onLoad();
        this.initComponent();
        this.initListener();
        if ("EDIT".equals(this.oprtState)) {
            this.oldCompany = this.editData.getCompany();
        }
    }

    @Override
    public void loadFields() {
        super.loadFields();
        if (this.getOprtState().equals("EDIT") || this.getOprtState().equals("VIEW")) {
            this.editData.setAisID(Integer.valueOf(this.txtAisId.getText()));
            this.editData.setSdsn(this.txtSdsn.getText());
        }
    }

    private void initComponent() {
        CompanyF7 treeCompany = new CompanyF7((IUIObject)this);
        treeCompany.setIsShowSub(true);
        treeCompany.setShowAssistantOrg(true);
        this.prmtCompany.setSelector((KDPromptSelector)treeCompany);
        this.txtServerAddr.setMaxLength(32);
        this.comboLoginAccount.addItem((Object)this.editData.getLoginAccount());
    }

    protected void initListener() {
        this.prmtCompany.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)e.getNewValue();
                if (company != null) {
                    AccountORMEditUI.this.txtCompanyName.setText(company.getName());
                }
            }
        });
        this.comboLoginAccount.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (!StringUtils.isEmpty((String)AccountORMEditUI.this.txtServerAddr.getText())) {
                    AccountORMEditUI.this.exeK3(true);
                    SysUtil.abort();
                }
            }
        });
        this.btnConnTest.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                AccountORMEditUI.this.verifyExeK3();
                String acct = AccountORMEditUI.this.exeK3(false);
                MsgBox.showInfo((String)(!StringUtils.isEmpty((String)acct) ? RptUtil.getResourceSince51("300connectedSuccess") : RptUtil.getResourceSince51("301userOrPwdErrpr")));
                SysUtil.abort();
            }
        });
    }

    protected IObjectValue createNewData() {
        return new AccountORMInfo();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return AccountORMFactory.getRemoteInstance();
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
        this.oldCompany = this.editData.getCompany();
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        String sdsn;
        this.verifyInput(e);
        String aisName = (String)this.comboLoginAccount.getSelectedItem();
        Integer ais = (Integer)this.aisMap.get(aisName);
        if (ais == null) {
            List list = this.queryK3Account();
            if (list == null) {
                SysUtil.abort();
            }
            this.comboLoginAccount.setSelectedItem((Object)aisName);
            ais = (Integer)this.aisMap.get(aisName);
        }
        if (StringUtils.isEmpty((String)(sdsn = this.testConnectWebService()))) {
            throw new EASBizException(new NumericExceptionSubItem("1", RptUtil.getResourceSince51("301userOrPwdErrpr")));
        }
        this.txtAisId.setText(String.valueOf(ais));
        this.txtSdsn.setText(sdsn);
        super.actionSubmit_actionPerformed(e);
    }

    private void reloadAccount() throws Exception {
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)this.prmtCompany.getValue();
        String companyId = company.getId().toString();
        AccountORMInfo info = (AccountORMInfo)this.getBizInterface().getValue("where company = '".concat(companyId).concat("'"));
        if (info != null) {
            this.comboLoginAccount.removeAllItems();
            this.comboLoginAccount.addItem((Object)info.getLoginAccount());
            this.comboLoginAccount.setSelectedIndex(0);
        }
    }

    public void actionFirst_actionPerformed(ActionEvent e) throws Exception {
        super.actionFirst_actionPerformed(e);
        this.reloadAccount();
    }

    public void actionLast_actionPerformed(ActionEvent e) throws Exception {
        super.actionLast_actionPerformed(e);
        this.reloadAccount();
    }

    public void actionNext_actionPerformed(ActionEvent e) throws Exception {
        super.actionNext_actionPerformed(e);
        this.reloadAccount();
    }

    public void actionPre_actionPerformed(ActionEvent e) throws Exception {
        super.actionPre_actionPerformed(e);
        this.reloadAccount();
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)this.prmtCompany.getValue();
        if (company == null) {
            MsgBox.showInfo((String)RptUtil.getResourceSince51("302chooseCompany"));
            SysUtil.abort();
        }
        this.verifyExeK3();
        if ("EDIT".equals(this.getOprtState())) {
            if (!this.oldCompany.getId().equals((Object)company.getId())) {
                this.isOrgRepeat(company);
            }
        } else if ("ADDNEW".equals(this.getOprtState())) {
            this.isOrgRepeat(company);
        }
    }

    private void verifyExeK3() {
        if (StringUtils.isEmpty((String)this.txtServerAddr.getText())) {
            MsgBox.showInfo((String)RptUtil.getResourceSince51("303inputServerAddr"));
            SysUtil.abort();
        }
        if (this.comboLoginAccount.getSelectedItem() == null) {
            MsgBox.showInfo((String)RptUtil.getResourceSince51("304chooseLoginAccount"));
            SysUtil.abort();
        }
        if (StringUtils.isEmpty((String)this.txtUserName.getText())) {
            MsgBox.showInfo((String)RptUtil.getResourceSince51("305inputUserName"));
            SysUtil.abort();
        }
    }

    private void isOrgRepeat(CompanyOrgUnitInfo company) throws Exception {
        String companyId = company.getId().toString();
        boolean isExist = this.getBizInterface().exists("where company = '".concat(companyId).concat("'"));
        if (isExist) {
            throw new EASBizException(new NumericExceptionSubItem("1", RptUtil.getResourceSince51("306existCompany_Account")));
        }
    }

    private String testConnectWebService() {
        String userName = this.txtUserName.getText();
        if (StringUtils.isEmpty((String)userName)) {
            return null;
        }
        String aisName = (String)this.comboLoginAccount.getSelectedItem();
        Integer ais = (Integer)this.aisMap.get(aisName);
        int aisID = ais == null ? this.editData.getAisID() : ais.intValue();
        char[] password = this.txtUserPassword.getPassword();
        StringBuilder passwd = new StringBuilder();
        for (int i = 0; i < password.length; ++i) {
            passwd.append(password[i]);
        }
        this.k3WebServiceContext.setEndPointURL(this.txtServerAddr.getText());
        this.k3WebServiceContext.setUserName(userName);
        this.k3WebServiceContext.setPassword(passwd.toString());
        this.k3WebServiceContext.setAISID(aisID);
        passwd = null;
        Arrays.fill(password, ' ');
        String result = null;
        try {
            result = K3WebServiceFacade.login(this.k3WebServiceContext);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    private List queryK3Account() {
        this.comboLoginAccount.removeAllItems();
        this.aisMap.clear();
        this.k3WebServiceContext.setEndPointURL(this.txtServerAddr.getText());
        List accList = this.queryK3Account(this.k3WebServiceContext);
        if (accList != null && accList.size() > 0) {
            for (int i = 0; i < accList.size(); ++i) {
                AisInfo ais = (AisInfo)accList.get(i);
                String aisName = ais.getAisName();
                this.aisMap.put(aisName, new Integer(ais.getAisID()));
                this.comboLoginAccount.addItem((Object)aisName);
            }
            if (this.getOprtState().equals("ADDNEW")) {
                this.comboLoginAccount.setSelectedIndex(0);
            } else {
                this.comboLoginAccount.setSelectedItem((Object)this.editData.getLoginAccount());
            }
        }
        return accList;
    }

    private List queryK3Account(K3WebServiceContext k3ctx) {
        AisInfo[] aisArr = null;
        try {
            aisArr = K3WebServiceFacade.queryAisInfo(k3ctx);
        }
        catch (Exception e) {
            MsgBox.showInfo((String)RptUtil.getResourceSince51("307toGetAccountFailed"));
            return null;
        }
        ArrayList<AisInfo> list = new ArrayList<AisInfo>();
        if (aisArr != null && aisArr.length > 0) {
            int length = aisArr.length;
            for (int i = 0; i < length; ++i) {
                list.add(aisArr[i]);
            }
        }
        return list;
    }

    private String exeK3(boolean isLoadK3) {
        GetDataDialog dlg = null;
        Window owner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        Window ownerWindow = ComponentUtil.getOwnerWindow((Component)owner);
        dlg = ownerWindow instanceof Frame ? new GetDataDialog((Frame)ownerWindow) : (ownerWindow instanceof Dialog ? new GetDataDialog((Dialog)ownerWindow) : new GetDataDialog((Frame)null));
        dlg.setTitle(isLoadK3 ? RptUtil.getResourceSince51("308gettingAccount") : RptUtil.getResourceSince51("309loginTest"));
        DataTaskAdapter dta = new DataTaskAdapter();
        dta.setIsLoadK3(isLoadK3);
        dlg.setGetDataTask((GetDataTaskAdapter)dta);
        dlg.show();
        return dta.getRetAisText();
    }

    public void onShow() throws Exception {
        super.onShow();
        RptUtilForClient.setWindowIsNotResizable(this.getUIWindow());
    }

    class DataTaskAdapter
    extends GetDataTaskAdapter {
        private String retAisText;
        private boolean isLoadK3;

        DataTaskAdapter() {
        }

        public void setIsLoadK3(boolean isLoadK3) {
            this.isLoadK3 = isLoadK3;
        }

        public String getRetAisText() {
            return this.retAisText;
        }

        public void exec() throws Exception {
            if (this.isLoadK3) {
                AccountORMEditUI.this.queryK3Account();
            } else {
                this.retAisText = AccountORMEditUI.this.testConnectWebService();
            }
        }
    }
}

