/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.cslrpt.util.CslOrgTreeUtil;
import com.kingdee.eas.fi.rpt.AccountORMFactory;
import com.kingdee.eas.fi.rpt.AccountORMInfo;
import com.kingdee.eas.fi.rpt.IAccountORM;
import com.kingdee.eas.fi.rpt.client.AbstractAccountORMListUI;
import com.kingdee.eas.fi.rpt.client.AccountORMEditUI;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.util.Set;
import org.apache.log4j.Logger;

public class AccountORMListUI
extends AbstractAccountORMListUI {
    private static final Logger logger = CoreUIObject.getLogger(AccountORMListUI.class);
    static final String resClassName = "com.kingdee.eas.basedata.assistant.client.assistantResource";

    public void onLoad() throws Exception {
        super.onLoad();
        this.tblMain.addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                AccountORMListUI.this.afterSelectLine(e);
            }
        });
        this.tblMain.getSelectManager().select(0, 0);
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        super.tblMain_tableClicked(e);
    }

    public void actionLocate_actionPerformed(ActionEvent e) throws Exception {
        super.actionLocate_actionPerformed(e);
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.ControlUnit;
    }

    protected String getKeyFieldName() {
        return super.getKeyFieldName();
    }

    protected String getEditUIName() {
        return AccountORMEditUI.class.getName();
    }

    protected String[] getLocateNames() {
        String[] locateNames = new String[]{"company.number", "company.name"};
        return locateNames;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return AccountORMFactory.getRemoteInstance();
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filter = super.getDefaultFilterForQuery();
        try {
            Set orgIDSet = CslOrgTreeUtil.getPermOrgUnitSetForClient(null, null, (String)SysContext.getSysContext().getCurrentUserInfo().getId().toString());
            FilterInfo filterCompany = new FilterInfo();
            filterCompany.getFilterItems().add(new FilterItemInfo("company.id", (Object)orgIDSet, CompareType.INCLUDE));
            filter.mergeFilter(filterCompany, "AND");
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        return filter;
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.doUnApprove();
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        this.doApprove();
    }

    private void doApprove() throws Exception {
        this.checkSelected();
        IAccountORM info = AccountORMFactory.getRemoteInstance();
        String pkid = this.getSelectedKeyValue();
        ObjectUuidPK pk = new ObjectUuidPK(pkid);
        AccountORMInfo counteryInfo = info.getAccountORMInfo((IObjectPK)pk);
        if (counteryInfo != null) {
            counteryInfo.setIsForbidden(false);
            info.update((IObjectPK)pk, counteryInfo);
            MsgBox.showInfo((String)RptUtil.getResourceSince51("310startSuccess"));
            this.btnCancel.setEnabled(true);
            this.btnCancelCancel.setEnabled(false);
        }
        this.refreshList();
    }

    private void doUnApprove() throws Exception {
        this.checkSelected();
        IAccountORM info = AccountORMFactory.getRemoteInstance();
        String pkid = this.getSelectedKeyValue();
        ObjectUuidPK pk = new ObjectUuidPK(pkid);
        AccountORMInfo counteryInfo = info.getAccountORMInfo((IObjectPK)pk);
        if (counteryInfo != null) {
            counteryInfo.setIsForbidden(true);
            info.update((IObjectPK)pk, counteryInfo);
            MsgBox.showInfo((String)RptUtil.getResourceSince51("311stopSuccess"));
            this.btnCancelCancel.setEnabled(true);
            this.btnCancel.setEnabled(false);
        }
        this.refreshList();
    }

    protected void afterSelectLine(KDTSelectEvent e) {
        KDTSelectManager sm = this.tblMain.getSelectManager();
        int blockCount = sm.size();
        if (blockCount <= 0) {
            return;
        }
        KDTSelectBlock block = sm.get(0);
        IRow row = this.tblMain.getRow(block.getTop());
        if (row == null) {
            return;
        }
        Object obj = row.getCell("isForbidden").getValue();
        if (obj instanceof Boolean && ((Boolean)obj).booleanValue()) {
            this.btnCancelCancel.setEnabled(true);
            this.btnCancel.setEnabled(false);
        } else {
            this.btnCancelCancel.setEnabled(false);
            this.btnCancel.setEnabled(true);
        }
    }
}

