/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.uiframe.client.NewMainFrame;
import com.kingdee.eas.base.uiframe.client.UIFactoryHelper;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gl.client.VoucherListUI;
import com.kingdee.eas.fi.rpt.FormulaHint;
import com.kingdee.eas.fi.rpt.ReportException;
import com.kingdee.eas.fi.rpt.TableToolkit;
import com.kingdee.eas.fi.rpt.client.FormulaStructure;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.eas.fi.rpt.util.RptUtilForClient;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.report.CommRptBaseFactory;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.SqlParams;
import com.kingdee.eas.util.StringUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Frame;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public class AcctExtFormulaStructure
extends FormulaStructure {
    String company;
    String startAccount;
    String endAccount;
    HashMap accountItem;
    String startOpposingAccount;
    String endOpposingAccount;
    HashMap opposinAccountItem;
    String selfDinfineFilter;
    String computerType;
    String currency;
    String startTime;
    String endTime;
    int levelStart = 1;
    int levelEnd = 1;
    boolean isOnlyUnion = false;
    private CurrencyInfo currencyInfo = null;

    public AcctExtFormulaStructure(String sformula) {
        super(sformula);
    }

    public AcctExtFormulaStructure(FormulaHint hint) {
        super(hint);
    }

    @Override
    public void structure() throws Exception {
        if (this.parameter == null || this.parameter.isEmpty() || this.parameter.size() != 8 && this.parameter.size() != 9) {
            MsgBox.showError((String)RptUtil.getReportResource("RPT_LEDGER_ERROR"));
            SysUtil.abort();
        }
        if (this.parameter.size() == 9 && OrgType.ProfitCenter.getName().equalsIgnoreCase((String)this.parameter.get(8))) {
            MsgBox.showError((String)RptUtil.getReportResource("442_ProfitCenterNotSupportFindLeger"));
            SysUtil.abort();
        }
        this.company = (String)this.parameter.get(0);
        if (!StringUtils.isEmpty((String)this.company) && this.company.split(";\\s*").length > 1) {
            MsgBox.showInfo((String)RptUtil.getReportResource("NOT_SUPORT_MULTICOMPANY"));
            SysUtil.abort();
        }
        if (this.company != null && this.company.trim().length() > 0) {
            this.companyOrg = RptUtilForClient.getCompanyOrgUnitInfoByNumber(this.company);
            if (this.companyOrg == null) {
                if (TableToolkit.isCellRef(this.company)) {
                    MsgBox.showError((String)RptUtil.getReportResource("RPT_NOSUPPORT_LEDGE"));
                } else {
                    MsgBox.showError((String)RptUtil.getResourceSince51("NoExistsCompany"));
                }
                SysUtil.abort();
            }
            this.company = this.companyOrg.getId().toString();
            this.isOnlyUnion = this.companyOrg.isIsOnlyUnion();
        } else {
            this.companyOrg = RptUtilForClient.getCompanyOrgUnitInfoByNumber(this.report.getCompany().getNumber());
            this.company = this.companyOrg.getId().toString();
            this.isOnlyUnion = this.companyOrg.isIsOnlyUnion();
        }
        String accountAndItem = (String)this.parameter.get(1);
        StringTokenizer accountandItemToken = new StringTokenizer(accountAndItem, "|");
        if (accountandItemToken.hasMoreElements()) {
            String account = accountandItemToken.nextToken();
            String[] subAccount = StringUtil.split((String)account, (String)":");
            if (subAccount.length == 2) {
                this.startAccount = subAccount[0];
                this.endAccount = subAccount[1];
                int start = StringUtil.split((String)this.startAccount, (String)".").length;
                int end = StringUtil.split((String)this.endAccount, (String)".").length;
                this.levelEnd = Math.max(start, end);
            } else {
                this.startAccount = account;
                this.endAccount = account;
                if (this.startAccount != null && this.startAccount.length() > 0) {
                    this.levelEnd = StringUtil.split((String)this.startAccount, (String)".").length;
                }
            }
        }
        while (accountandItemToken.hasMoreElements()) {
            String temptype = null;
            String temptypeItem = null;
            if (this.accountItem == null) {
                this.accountItem = new HashMap();
            }
            temptype = accountandItemToken.nextToken();
            if (accountandItemToken.hasMoreElements()) {
                temptypeItem = accountandItemToken.nextToken();
            }
            this.accountItem.put(temptype, temptypeItem);
        }
        String opposingAccountAndItem = (String)this.parameter.get(2);
        StringTokenizer opposingAccountandItemToken = new StringTokenizer(opposingAccountAndItem, "|");
        if (opposingAccountandItemToken.hasMoreElements()) {
            String opposingAccount = opposingAccountandItemToken.nextToken();
            String[] subOPPosingAccount = StringUtil.split((String)opposingAccount, (String)":");
            if (subOPPosingAccount.length == 2) {
                this.startOpposingAccount = subOPPosingAccount[0];
                this.endOpposingAccount = subOPPosingAccount[1];
            } else {
                this.startOpposingAccount = opposingAccount;
                this.endOpposingAccount = opposingAccount;
            }
        }
        while (opposingAccountandItemToken.hasMoreElements()) {
            String temptype = null;
            String temptypeItem = null;
            if (this.opposinAccountItem == null) {
                this.opposinAccountItem = new HashMap();
            }
            temptype = opposingAccountandItemToken.nextToken();
            if (opposingAccountandItemToken.hasMoreElements()) {
                temptypeItem = opposingAccountandItemToken.nextToken();
            }
            this.opposinAccountItem.put(temptype, temptypeItem);
        }
        this.selfDinfineFilter = (String)this.parameter.get(3);
        this.computerType = (String)this.parameter.get(4);
        this.currency = (String)this.parameter.get(5);
        if (this.currency == null || this.currency.trim().length() == 0) {
            this.currencyInfo = this.rptSheetParam.getCurrency() != null ? this.rptSheetParam.getCurrency() : this.report.getCurrency();
        } else {
            this.currencyInfo = RptUtilForClient.getCurrency(this.currency);
            if (this.currencyInfo == null) {
                MsgBox.showInfo((String)RptUtil.getResourceSince51("CurrencyOutOfPlace"));
                SysUtil.abort();
            } else {
                this.currency = this.currencyInfo.getId().toString();
            }
        }
        this.currency = this.currencyInfo == null ? null : this.currencyInfo.getId().toString();
        this.startTime = (String)this.parameter.get(6);
        if (this.startTime == null || this.startTime.trim().length() == 0) {
            if (this.rptSheetParam.getStartDate() == null) {
                if (this.report.getStartDate() == null) {
                    MsgBox.showInfo((String)RptUtil.getResourceSince51("DateIsNull"));
                    SysUtil.abort();
                }
                this.startTime = this.report.getStartDate().toString();
            } else {
                this.startTime = this.rptSheetParam.getStartDate().toString();
            }
        }
        this.endTime = (String)this.parameter.get(7);
        if (this.endTime == null || this.endTime.trim().length() == 0) {
            this.endTime = this.rptSheetParam.getEndDate() == null ? this.report.getEndDate().toString() : this.rptSheetParam.getEndDate().toString();
        }
    }

    public boolean check() throws ReportException {
        if (this.isOnlyUnion) {
            MsgBox.showInfo((String)RptUtil.getResourceSince51("VirtualOrgCannotAssn"));
            return false;
        }
        if (RptUtil.findString(this.computerType, ",C,Y,TC,TY,ZTC,ZTY,AY,TAY,ZAY,")) {
            MsgBox.showInfo((String)("acctext" + RptUtil.getResourceSince51("CannotAssnBalance")));
            return false;
        }
        if (!this.type.equals("4") && RptUtil.findString(this.computerType, ",QJF,QDF,FQJF,FQDF,JF,DF,TJF,TDF,ZJF,ZDF,")) {
            MsgBox.showInfo((String)("acctext" + RptUtil.getResourceSince51("OccurrereFetchCannotAssn")));
            return false;
        }
        if (this.currencyInfo == null || "GLC".equalsIgnoreCase(this.currencyInfo.getNumber()) || "GRC".equalsIgnoreCase(this.currencyInfo.getNumber())) {
            MsgBox.showInfo((String)RptUtil.getReportResource("RPT_LEDGER_GRC_ERROR"));
            return false;
        }
        return true;
    }

    public static int getAccuntViewLevel(String accountNumber, String companyId, String accountTableId) throws SQLException, EASBizException, BOSException {
        String sql = "select FLevel from T_BD_AccountView where FCompanyID=? and FAccountTableID=? and FNumber=?";
        SqlParams sp = new SqlParams().setString(1, companyId).setString(2, accountTableId).setString(3, accountNumber);
        RptRowSet rst = CommRptBaseFactory.getRemoteInstance().executeQuery(sql, sp, 0, -1);
        if (rst.next()) {
            return rst.getInt(0);
        }
        throw new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{RptUtil.getResourceSince51("Account") + accountNumber + " " + RptUtil.getResourceSince51("NoExists")});
    }

    @Override
    public void openUI() throws Exception {
        KDLabel msgLabel;
        CoreUI c;
        SimpleDateFormat DateFormat2;
        SimpleDateFormat simpleDateFormat = DateFormat2 = new SimpleDateFormat("yyyy-MM-dd");
        Date startDate = simpleDateFormat.parse(this.getStartTime());
        Date endDate = simpleDateFormat.parse(this.getEndTime());
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(endDate);
        if (!this.check()) {
            this.ledgerSuccess = false;
            return;
        }
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterinfo = new FilterInfo();
        StringBuffer master = new StringBuffer();
        int i = 0;
        filterinfo.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.getCompany()));
        master.append(" #" + i++);
        if (this.getStartAccount() != null && this.getEndAccount() != null) {
            filterinfo.getFilterItems().add(new FilterItemInfo("account.number", (Object)this.getStartAccount(), CompareType.GREATER_EQUALS));
            master.append(" and #" + i++);
            filterinfo.getFilterItems().add(new FilterItemInfo("account.number", (Object)(this.getEndAccount() + "z"), CompareType.LESS_EQUALS));
            master.append(" and #" + i++);
        } else if (this.getStartAccount() != null) {
            filterinfo.getFilterItems().add(new FilterItemInfo("account.number", (Object)this.getStartAccount()));
            master.append(" and #" + i++);
        }
        filterinfo.getFilterItems().add(new FilterItemInfo("currency.id", (Object)this.getCurrency()));
        master.append(" and #" + i++);
        if (this.rptSheetParam.isIsIncludingUnposted()) {
            filterinfo.getFilterItems().add(new FilterItemInfo("bizStatus", (Object)new Integer(0), CompareType.NOTEQUALS));
            filterinfo.getFilterItems().add(new FilterItemInfo("bizStatus", (Object)new Integer(2), CompareType.NOTEQUALS));
            master.append(" and #" + i++);
            master.append(" and #" + i++);
        } else {
            filterinfo.getFilterItems().add(new FilterItemInfo("bizStatus", (Object)new Integer(5), CompareType.EQUALS));
            master.append(" and #" + i++);
        }
        filterinfo.getFilterItems().add(new FilterItemInfo("bookedDate", (Object)startDate, CompareType.GREATER_EQUALS));
        master.append(" and #" + i++);
        filterinfo.getFilterItems().add(new FilterItemInfo("bookedDate", (Object)endDate, CompareType.LESS_EQUALS));
        master.append(" and #" + i++);
        filterinfo.setMaskString(master.toString());
        entityViewInfo.setFilter(filterinfo);
        UIContext context = new UIContext();
        context.put("company", this.companyOrg);
        context.put("Owner", this.getParentUI());
        IUIObject object = AcctExtFormulaStructure.showVouchers(entityViewInfo, (Map)context);
        if (object instanceof CoreUI && (c = (CoreUI)object).getMainStatusBar() != null && (msgLabel = c.getMainStatusBar().getMsgLabel()) != null) {
            msgLabel.setIcon(CoreUI.SHOW_MESSAGE_ICON_DEFAULT);
            msgLabel.setText(RptUtil.getReportResource("REPORT_QUERY_UNION") + this.companyOrg.getName() + RptUtil.getReportResource("REPORT_QUERY_VOUCHERS"));
        }
    }

    public static IUIObject showVouchers(EntityViewInfo view, Map ctx) throws Exception {
        HashMap<String, Object> dataObjects = new HashMap<String, Object>();
        dataObjects.put("mainQuery", view);
        dataObjects.put("company", ctx.get("company"));
        Frame frame = UIFactoryHelper.getMainFrame((Map)ctx);
        Object mainUI = null;
        mainUI = frame instanceof NewMainFrame ? ((NewMainFrame)frame).getMainUI() : UIFactoryHelper.getMainUIObject((Map)ctx);
        IUIObject uiObject = mainUI.getUiManager().findUIObject("com.kingdee.eas.fi.gl.client.VoucherListUI", ctx, dataObjects, OprtState.VIEW);
        if (uiObject != null) {
            mainUI.getUiManager().closeTab(uiObject);
        }
        ctx.put("JointEntityView", view);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create(VoucherListUI.class.getName(), ctx, dataObjects, OprtState.VIEW);
        uiWindow.show();
        return uiWindow.getUIObject();
    }

    public HashMap getAccountItem() {
        return this.accountItem;
    }

    public void setAccountItem(HashMap accountItem) {
        this.accountItem = accountItem;
    }

    public String getCompany() {
        return this.company;
    }

    public void setCompany(String company) {
        this.company = company;
    }

    public String getComputerType() {
        return this.computerType;
    }

    public void setComputerType(String computerType) {
        this.computerType = computerType;
    }

    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public String getEndAccount() {
        return this.endAccount;
    }

    public void setEndAccount(String endAccount) {
        this.endAccount = endAccount;
    }

    public String getEndOpposingAccount() {
        return this.endOpposingAccount;
    }

    public void setEndOpposingAccount(String endOpposingAccount) {
        this.endOpposingAccount = endOpposingAccount;
    }

    public String getEndTime() {
        return this.endTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    public HashMap getOpposinAccountItem() {
        return this.opposinAccountItem;
    }

    public void setOpposinAccountItem(HashMap opposinAccountItem) {
        this.opposinAccountItem = opposinAccountItem;
    }

    public String getSelfDinfineFilter() {
        return this.selfDinfineFilter;
    }

    public void setSelfDinfineFilter(String selfDinfineFilter) {
        this.selfDinfineFilter = selfDinfineFilter;
    }

    public String getStartAccount() {
        return this.startAccount;
    }

    public void setStartAccount(String startAccount) {
        this.startAccount = startAccount;
    }

    public String getStartOpposingAccount() {
        return this.startOpposingAccount;
    }

    public void setStartOpposingAccount(String startOpposingAccount) {
        this.startOpposingAccount = startOpposingAccount;
    }

    public String getStartTime() {
        return this.startTime;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }
}

