/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.client;

import com.google.gson.Gson;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.uiframe.client.NewWinMainUI;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.master.account.AccountException;
import com.kingdee.eas.basedata.master.account.AccountTableCollection;
import com.kingdee.eas.basedata.master.account.AccountTableFactory;
import com.kingdee.eas.basedata.master.account.AccountTableInfo;
import com.kingdee.eas.basedata.master.account.AccountTools;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.cp.eip.sso.SSOHandleFacadeFactory;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.ReportConditionGeneralLedger;
import com.kingdee.eas.fi.gl.client.ReportGeneralLedgerUI;
import com.kingdee.eas.fi.gl.rpt.GLRptSubLedgerCondition;
import com.kingdee.eas.fi.gl.rpt.client.GLRptSubLedgerUI;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.rpt.BalanceTypeEnum;
import com.kingdee.eas.fi.rpt.FormulaHint;
import com.kingdee.eas.fi.rpt.ProfitAcctFindLedgerFacadeFactory;
import com.kingdee.eas.fi.rpt.QueryGeneralLedgerInfo;
import com.kingdee.eas.fi.rpt.ReportException;
import com.kingdee.eas.fi.rpt.RptAndTempException;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.TableToolkit;
import com.kingdee.eas.fi.rpt.client.FormulaStructure;
import com.kingdee.eas.fi.rpt.util.AcctountAsstItemParser;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.eas.fi.rpt.util.RptUtilForClient;
import com.kingdee.eas.framework.report.CommRptBaseFactory;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.SqlParams;
import com.kingdee.eas.ma.pca.PcaUtils;
import com.kingdee.eas.util.StringUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.net.URLEncoder;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.JViewport;

public class AcctFormulaStructure
extends FormulaStructure {
    String company;
    String startAccount;
    String endAccount;
    HashMap items;
    int startYear;
    int endYear;
    int startFiscal;
    int endFiscal;
    String currencyId;
    String currencyName;
    String computetype;
    int levelStart = 1;
    int levelEnd = 1;
    boolean isOnlyUnion = false;
    String acctAsstItems;
    CurrencyInfo currencyInfo = null;
    boolean isProfitCenter = false;
    PeriodInfo startPeriodInfo;
    PeriodInfo endPeriodInfo;
    String racctTableNumber = null;

    public AcctFormulaStructure(String formula) {
        super(formula);
    }

    public AcctFormulaStructure(FormulaHint hint) {
        super(hint);
    }

    @Override
    public void structure() throws Exception {
        String msg;
        int maxPeriodNumber;
        boolean isRacct = "racct".equalsIgnoreCase(this.formulaType);
        if (this.parameter == null || this.parameter.isEmpty() || this.parameter.size() != 8 && this.parameter.size() != 9) {
            MsgBox.showError((String)RptUtil.getReportResource("RPT_LEDGER_ERROR"));
            SysUtil.abort();
        }
        if (!isRacct && this.parameter.size() == 9 && OrgType.ProfitCenter.getName().equalsIgnoreCase((String)this.parameter.get(8))) {
            if (!this.type.equals("2")) {
                MsgBox.showError((String)RptUtil.getReportResource("442_ProfitCenterNotSupportFindLeger"));
                SysUtil.abort();
            } else {
                this.isProfitCenter = true;
            }
        }
        this.company = (String)this.parameter.get(0);
        this.companyOrg = this.company != null && this.company.trim().length() > 0 ? (this.isProfitCenter ? ProfitAcctFindLedgerFacadeFactory.getRemoteInstance().getProfitCompanyInfo(this.company) : RptUtilForClient.getCompanyOrgUnitInfoByNumber(this.company)) : (this.isProfitCenter ? ProfitAcctFindLedgerFacadeFactory.getRemoteInstance().getProfitCompanyInfo(this.report.getCompany().getNumber()) : RptUtilForClient.getCompanyOrgUnitInfoByNumber(this.report.getCompany().getNumber()));
        if (this.companyOrg == null || this.companyOrg.isEmpty()) {
            if (TableToolkit.isCellRef(this.company)) {
                MsgBox.showError((String)RptUtil.getReportResource("RPT_NOSUPPORT_LEDGE"));
            } else if (!StringUtils.isEmpty((String)this.company) && this.company.contains(";")) {
                MsgBox.showError((String)RptUtil.getResourceSince51("NOT_SUPORT_MULTICOMPANY"));
            } else {
                throw new ReportException(ReportException.FIND_COMPANY_ERROR);
            }
            SysUtil.abort();
        }
        this.company = this.companyOrg.getId().toString();
        this.isOnlyUnion = this.companyOrg.isIsOnlyUnion();
        if (this.isProfitCenter && this.isOnlyUnion) {
            MsgBox.showInfo((String)RptUtil.getResourceSince51("VirtualOrgCannotAssn"));
            SysUtil.abort();
        }
        Integer Period_Type = new Integer(this.report.getPeriodType().getValue());
        if (isRacct) {
            this.racctTableNumber = (String)this.parameter.get(1);
        }
        String accountAndItem = (String)this.parameter.get(isRacct ? 2 : 1);
        this.parseAccountItem(accountAndItem);
        this.computetype = (String)this.parameter.get(isRacct ? 3 : 2);
        String temp = (String)this.parameter.get(isRacct ? 4 : 3);
        try {
            this.startYear = Integer.parseInt(temp);
        }
        catch (Exception e) {
            this.startYear = 0;
        }
        if (this.startYear <= 0) {
            this.startYear = this.rptSheetParam.getStartYear() + this.startYear;
            if (this.startYear <= 0) {
                this.startYear = this.report.getYear() + this.startYear;
            }
        }
        String temp2 = (String)this.parameter.get(isRacct ? 5 : 4);
        try {
            this.startFiscal = Integer.parseInt(temp2);
        }
        catch (Exception e) {
            this.startFiscal = 0;
        }
        if (this.startFiscal <= 0) {
            this.startFiscal = this.rptSheetParam.getStartPeriod() + this.startFiscal;
            if (this.startFiscal <= 0) {
                this.startFiscal = this.report.getPeriod() + this.startFiscal;
            }
            if (this.startFiscal <= 0) {
                --this.startYear;
                this.startFiscal += PeriodUtils.getMaxPeriodNumber(null, (int)this.startYear, (String)this.companyOrg.getId().toString());
            } else if (Period_Type != null && (Period_Type != 3 || this.startFiscal <= 12)) {
                Date periodLastDate = RPTDateUtil.getPeriodFirstDate((int)this.startYear, (int)this.startFiscal, (RptPeriodTypeEnum)RptPeriodTypeEnum.getEnum((int)Period_Type));
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(periodLastDate);
                this.startYear = calendar.get(1);
                this.startFiscal = calendar.get(2) + 1;
            }
        }
        String temp3 = (String)this.parameter.get(isRacct ? 6 : 5);
        try {
            this.endYear = Integer.parseInt(temp3);
        }
        catch (Exception e) {
            this.endYear = 0;
        }
        if (this.endYear <= 0) {
            this.endYear = this.rptSheetParam.getEndYear() + this.endYear;
            if (this.endYear <= 0) {
                this.endYear = this.report.getYear() + this.endYear;
            }
        }
        String temp4 = (String)this.parameter.get(isRacct ? 7 : 6);
        try {
            this.endFiscal = Integer.parseInt(temp4);
        }
        catch (Exception e) {
            this.endFiscal = 0;
        }
        if (this.endFiscal <= 0) {
            this.endFiscal = this.rptSheetParam.getEndPeriod() + this.endFiscal;
            if (this.endFiscal <= 0) {
                this.endFiscal = this.report.getPeriod() + this.endFiscal;
            }
            if (this.endFiscal <= 0) {
                --this.endYear;
                this.endFiscal += PeriodUtils.getMaxPeriodNumber(null, (int)this.startYear, (String)this.companyOrg.getId().toString());
            } else if (Period_Type != null) {
                Calendar calendar = Calendar.getInstance();
                if (Period_Type != 3 || this.endFiscal <= 12) {
                    Date periodLastDate = RPTDateUtil.getPeriodLastDate((int)this.endYear, (int)this.endFiscal, (RptPeriodTypeEnum)RptPeriodTypeEnum.getEnum((int)Period_Type));
                    calendar.setTime(periodLastDate);
                    this.endYear = calendar.get(1);
                    this.endFiscal = calendar.get(2) + 1;
                }
            }
        }
        if (this.endYear < this.startYear) {
            int t = this.startYear;
            this.startYear = this.endYear;
            this.endYear = t;
        } else if (this.endYear == this.startYear && this.endFiscal < this.startFiscal) {
            int t = this.startFiscal;
            this.startFiscal = this.endFiscal;
            this.endFiscal = t;
        }
        PeriodInfo currentPeriod = null;
        currentPeriod = this.isProfitCenter ? PcaUtils.getCurrentPeriod(null, (String)this.companyOrg.getId().toString()) : GlUtils.getCurrentPeriod(null, (String)this.companyOrg.getId().toString());
        String tempcurrency = (String)this.parameter.get(isRacct ? 8 : 7);
        this.currencyInfo = tempcurrency == null || tempcurrency.trim().length() == 0 ? (this.rptSheetParam.getCurrency() != null ? this.rptSheetParam.getCurrency() : this.report.getCurrency()) : RptUtilForClient.getCurrency(tempcurrency.toUpperCase());
        if (this.currencyInfo == null) {
            MsgBox.showInfo((String)RptUtil.getResourceSince51("CurrencyOutOfPlace"));
            SysUtil.abort();
        }
        this.currencyId = this.currencyInfo.getId().toString();
        this.currencyName = this.currencyInfo.getName();
        ProfitCenterOrgUnitInfo profitCenterOrgUnitInfo = null;
        if (this.isProfitCenter) {
            profitCenterOrgUnitInfo = ProfitCenterOrgUnitFactory.getRemoteInstance().getProfitCenterOrgUnitInfo((IObjectPK)new ObjectUuidPK(this.report.getCompany().getId().toString()));
            profitCenterOrgUnitInfo.setPcaccountPeriodType(this.companyOrg.getAccountPeriodType());
            maxPeriodNumber = PeriodUtils.getMaxPeriodNumber(null, (int)this.endYear, (ProfitCenterOrgUnitInfo)profitCenterOrgUnitInfo);
        } else {
            maxPeriodNumber = PeriodUtils.getMaxPeriodNumber(null, (int)this.endYear, (String)this.report.getCompany().getId().toString());
        }
        if (maxPeriodNumber == 13 && this.endFiscal == 12) {
            this.endFiscal = 13;
        }
        this.startPeriodInfo = this.isProfitCenter ? PeriodUtils.getPeriodInfo((int)this.startYear, (int)this.startFiscal, (ProfitCenterOrgUnitInfo)profitCenterOrgUnitInfo) : PeriodUtils.getPeriodInfo((int)this.startYear, (int)this.startFiscal, (CompanyOrgUnitInfo)this.companyOrg);
        if (this.startPeriodInfo == null) {
            msg = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.cslcommon.CSLCOMMONAutoGenerateResource", (String)"75_AcctFormulaStructure");
            MsgBox.showInfo((String)MessageFormat.format(msg, this.companyOrg.getAccountPeriodType().getName(), this.startYear, this.startFiscal));
            SysUtil.abort();
        }
        this.endPeriodInfo = this.isProfitCenter ? PeriodUtils.getPeriodInfo((int)this.endYear, (int)this.endFiscal, (ProfitCenterOrgUnitInfo)profitCenterOrgUnitInfo) : PeriodUtils.getPeriodInfo((int)this.endYear, (int)this.endFiscal, (CompanyOrgUnitInfo)this.companyOrg);
        if (this.endPeriodInfo == null) {
            msg = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.cslcommon.CSLCOMMONAutoGenerateResource", (String)"75_AcctFormulaStructure");
            MsgBox.showInfo((String)MessageFormat.format(msg, this.companyOrg.getAccountPeriodType().getName(), this.endYear, this.endFiscal));
            SysUtil.abort();
        }
    }

    public boolean check() {
        if (this.isOnlyUnion) {
            MsgBox.showInfo((String)RptUtil.getResourceSince51("VirtualOrgCannotAssn"));
            return false;
        }
        return true;
    }

    public void parseAccountItem(String accountAndItem) {
        this.acctAsstItems = accountAndItem;
        StringTokenizer accountandItemToken = new StringTokenizer(accountAndItem, "|");
        if (accountandItemToken.hasMoreElements()) {
            String account = accountandItemToken.nextToken();
            String[] subAccount = StringUtil.split((String)account, (String)":");
            if (subAccount.length == 2) {
                this.startAccount = subAccount[0];
                this.endAccount = subAccount[1];
                int start = StringUtil.split((String)this.startAccount, (String)".").length;
                int end = StringUtil.split((String)this.endAccount, (String)".").length;
                this.levelEnd = Math.max(start, end);
            } else {
                this.startAccount = account;
                this.endAccount = account;
                if (this.startAccount != null && this.startAccount.length() > 0) {
                    this.levelEnd = StringUtil.split((String)this.startAccount, (String)".").length;
                }
            }
        }
        while (accountandItemToken.hasMoreElements()) {
            String temptype = null;
            String temptypeItem = null;
            if (this.items == null) {
                this.items = new HashMap();
            }
            temptype = accountandItemToken.nextToken();
            if (accountandItemToken.hasMoreElements()) {
                temptypeItem = accountandItemToken.nextToken();
            }
            this.items.put(temptype, temptypeItem);
        }
    }

    public boolean checkIsMuliAcctount() throws Exception {
        AccountTableCollection acctTables;
        if (this.isOnlyUnion && (acctTables = AccountTools.getAllAccountTableByCU(null, (CtrlUnitInfo)this.companyOrg.getCU())).size() > 1) {
            MsgBox.showWarning((String)RptUtil.getResourceSince51("ThisCompanyExistsMultiAccountTable"));
            return false;
        }
        return true;
    }

    @Override
    public void openUI() throws Exception {
        if (this.companyOrg.getAccountTable() == null) {
            throw new AccountException(AccountException.CURRENTCOMPANYHASNOSTARTACCOUNTTABLE);
        }
        String currentAcctTable = AccountTools.getCurrentAcctTable(null, (String)this.companyOrg.getCU().getId().toString(), (String)this.companyOrg.getAccountTable().getId().toString(), (int)this.endYear, (int)this.endFiscal);
        if (!StringUtils.isEmpty((String)this.racctTableNumber) && !StringUtils.isEmpty((String)currentAcctTable)) {
            SelectorItemCollection sel = new SelectorItemCollection();
            sel.add("number");
            AccountTableInfo info = AccountTableFactory.getRemoteInstance().getAccountTableInfo((IObjectPK)new ObjectUuidPK(currentAcctTable), sel);
            if (!this.racctTableNumber.equals(info.getNumber())) {
                throw new RptAndTempException(RptAndTempException.ACCOUNTTABLECHECK);
            }
        }
        this.companyOrg.getAccountTable().setId(BOSUuid.read((String)currentAcctTable));
        CompanyOrgUnitInfo currentCompany = SysContext.getSysContext().getCurrentFIUnit();
        String companyid = null;
        if (this.isProfitCenter) {
            if (this.companyOrg.get("DELEGATED_COMPANY_ID") != null) {
                companyid = this.companyOrg.get("DELEGATED_COMPANY_ID").toString();
            }
        } else {
            companyid = this.getCompany();
        }
        this.companyOrg.setBaseCurrency(this.currencyInfo);
        this.companyOrg.setReportCurrency(this.currencyInfo);
        if ("2".equals(this.type)) {
            if (!this.check()) {
                this.ledgerSuccess = false;
                return;
            }
            this.getAccountIds(companyid, this.companyOrg.getAccountTable().getId().toString(), this.getAcctAsstItems());
            if (!this.isProfitCenter) {
                if (this.accountIdSet.isEmpty()) {
                    throw new ReportException(ReportException.ACCOUNT_NOT_FOUND);
                }
                GLRptSubLedgerCondition cond = new GLRptSubLedgerCondition();
                cond.setPeriodYearStart(this.getStartYear());
                cond.setPeriodYearEnd(this.getEndYear());
                cond.setPeriodNumberStart(this.getStartFiscal());
                cond.setPeriodNumberEnd(this.getEndFiscal());
                cond.setCurrencyID(this.getCurrencyId());
                cond.setCompany(this.companyOrg);
                cond.setCompanyId(this.getCompany());
                cond.setCurrencyName(this.getCurrencyName());
                cond.setAccountLevelStart(this.startLevel);
                cond.setAccountLevelEnd(this.endLevel);
                cond.setOptionPosting(this.rptSheetParam.isIsIncludingUnposted());
                cond.setShowDisplayAsstDetail(true);
                cond.setNotIncluePLVoucher(BalanceTypeEnum.QSL.getName().equals(this.computetype) || BalanceTypeEnum.QSY.getName().equals(this.computetype));
                cond.setAccountIdSet(this.accountIdSet);
                cond.setAccountTableId(currentAcctTable);
                cond.setOptionAmountAndBalZero(true);
                if (this.accountIdSet != null && this.accountIdSet.size() == 1 && !StringUtils.isEmpty((String)this.accountNumber)) {
                    cond.setAccountCodeStart(this.accountNumber);
                    cond.setAccountCodeEnd(this.accountNumber);
                    cond.setAccountIdSet(null);
                }
                this.uiContext.put((Object)"JoinQuery", (Object)Boolean.TRUE);
                this.uiContext.put((Object)"UIClassParam", (Object)cond.toMap().toString());
                this.uiContext.put((Object)"com.kingdee.eas.framework.report.client.CommRptBaseUI#UICONTEXT_KEY_JOINQUERY_PARAMS", (Object)cond);
                this.uiContext.put((Object)"JoinQuery_Outer_Params_asstActList", (Object)this.getAcctAsstItems());
                Object jViewport = this.getUIContext().get((Object)"Viewport");
                if (jViewport != null) {
                    GLRptSubLedgerUI acctDetailUI = (GLRptSubLedgerUI)this.getUIContext().get((Object)"detailUI");
                    if (acctDetailUI == null) {
                        acctDetailUI = new GLRptSubLedgerUI();
                    }
                    acctDetailUI.getUIContext().putAll(this.uiContext);
                    acctDetailUI.initLayout();
                    acctDetailUI.onLoad();
                    acctDetailUI.onShow();
                    ((JViewport)jViewport).add((Component)acctDetailUI, null);
                } else {
                    IUIWindow ui = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create("com.kingdee.eas.fi.gl.rpt.client.GLRptSubLedgerUI", (Map)this.uiContext, null);
                    ui.show();
                }
                return;
            }
        }
        AccountViewInfo beginAccount = AcctFormulaStructure.getAccountView(false, this.getStartAccount(), this.getEndAccount(), companyid, this.companyOrg.getAccountTable().getId().toString(), this.isProfitCenter);
        AccountViewInfo endAccount = AcctFormulaStructure.getAccountView(true, this.getStartAccount(), this.getEndAccount(), companyid, this.companyOrg.getAccountTable().getId().toString(), this.isProfitCenter);
        int level = beginAccount.getLevel();
        String beginAccountNumber = beginAccount.getNumber();
        String endAccountNumber = endAccount.getNumber();
        if (this.type.equals("1")) {
            ReportConditionGeneralLedger reportConditionBase = new ReportConditionGeneralLedger();
            reportConditionBase.setAccountCodeStart(beginAccountNumber);
            reportConditionBase.setAccountCodeEnd(endAccountNumber);
            reportConditionBase.setPeriodYearStart(this.getStartYear());
            reportConditionBase.setPeriodYearEnd(this.getEndYear());
            reportConditionBase.setPeriodNumberStart(this.getStartFiscal());
            reportConditionBase.setPeriodNumberEnd(this.getEndFiscal());
            reportConditionBase.setCurrencyID(this.getCurrencyId());
            reportConditionBase.setCompanyId(this.getCompany());
            reportConditionBase.setCurrencyName(this.getCurrencyName());
            reportConditionBase.setAccountLevelStart(level);
            reportConditionBase.setAccountLevelEnd(level);
            reportConditionBase.setOptionPosting(this.rptSheetParam.isIsIncludingUnposted());
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            entityViewInfo.put("GLFixCondition", (Object)reportConditionBase);
            ReportGeneralLedgerUI.queryByCondition((EntityViewInfo)entityViewInfo, (CoreUIObject)this.getParentUI(), (CompanyOrgUnitInfo)this.companyOrg, (!currentCompany.isIsBizUnit() ? 1 : 0) != 0);
        } else if (this.type.equals("2")) {
            if (this.isProfitCenter) {
                String json = this.getProfitCondition(beginAccount, endAccount);
                String serverURL = System.getProperty("EASPORTAL_ROOT");
                if (StringUtils.isEmpty((String)serverURL)) {
                    serverURL = "http://localhost:6888/easportal";
                }
                String toUrl = "/easweb/dynamicList.do?event=initialize&method=initalize";
                toUrl = toUrl + "&uipk=com.kingdee.eas.ma.pca.pcaRptSubLedgerPage&inwafpage=true&debug=true&linkData=" + json + "&reportlink=1";
                String url = SSOHandleFacadeFactory.getRemoteInstance().getGUItoPortalUrl(URLEncoder.encode(toUrl, "utf-8"), true, SysContext.getSysContext().getLocale().toString(), SysContext.getSysContext().getDCNumber());
                url = serverURL + "/" + url;
                url = this.replaceAllStr(url, "&", "^&");
                url = url.replace("ssoWelcome", "index2sso.jsp");
                NewWinMainUI.gotoSite((String)url);
            }
        } else if (this.type.equals("3")) {
            ReportConditionGeneralLedger reportConditionBase = new ReportConditionGeneralLedger();
            reportConditionBase.setAccountCodeStart(beginAccountNumber);
            reportConditionBase.setAccountCodeEnd(endAccountNumber);
            reportConditionBase.setPeriodYearStart(this.getStartYear());
            reportConditionBase.setPeriodYearEnd(this.getEndYear());
            reportConditionBase.setPeriodNumberStart(this.getStartFiscal());
            reportConditionBase.setPeriodNumberEnd(this.getEndFiscal());
            reportConditionBase.setCurrencyID(this.getCurrencyId());
            reportConditionBase.setCompanyId(this.getCompany());
            reportConditionBase.setCurrencyName(this.getCurrencyName());
            reportConditionBase.setAccountLevelStart(level);
            reportConditionBase.setAccountLevelEnd(level);
            reportConditionBase.setOptionPosting(this.rptSheetParam.isIsIncludingUnposted());
            reportConditionBase.setOptionShowQuantity(true);
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            entityViewInfo.put("GLFixCondition", (Object)reportConditionBase);
            ReportGeneralLedgerUI.queryByCondition((EntityViewInfo)entityViewInfo, (CoreUIObject)this.getParentUI(), (CompanyOrgUnitInfo)this.companyOrg, (!currentCompany.isIsBizUnit() ? 1 : 0) != 0);
        }
    }

    private String replaceAllStr(String strSource, String strFrom, String strTo) {
        int intPos;
        if (strFrom == null || strFrom.equals("")) {
            return strSource;
        }
        String strDest = "";
        int intFromLen = strFrom.length();
        while ((intPos = strSource.indexOf(strFrom)) != -1) {
            strDest = strDest + strSource.substring(0, intPos);
            strDest = strDest + strTo;
            strSource = strSource.substring(intPos + intFromLen);
        }
        strDest = strDest + strSource;
        return strDest;
    }

    private String getProfitCondition(AccountViewInfo beginAccount, AccountViewInfo endAccount) throws BOSException, ParseException {
        String json = null;
        QueryGeneralLedgerInfo queryGeneralLedgerInfo = new QueryGeneralLedgerInfo();
        queryGeneralLedgerInfo.setProfitCenter(this.companyOrg.getNumber());
        queryGeneralLedgerInfo.setCurrency(this.currencyInfo.getId().toString());
        queryGeneralLedgerInfo.setAccountStart(beginAccount.getNumber());
        queryGeneralLedgerInfo.setAccountEnd(endAccount.getNumber());
        if (beginAccount.getLevel() > endAccount.getLevel()) {
            queryGeneralLedgerInfo.setAccountLevel(String.valueOf(beginAccount.getLevel()));
        } else {
            queryGeneralLedgerInfo.setAccountLevel(String.valueOf(endAccount.getLevel()));
        }
        queryGeneralLedgerInfo.setAccountTable(this.companyOrg.getAccountTable().getId().toString());
        queryGeneralLedgerInfo.setPeriodType(this.companyOrg.getAccountPeriodType().getId().toString());
        queryGeneralLedgerInfo.setPeriodStart(String.valueOf(this.startPeriodInfo.getNumber()));
        queryGeneralLedgerInfo.setPeriodEnd(String.valueOf(this.endPeriodInfo.getNumber()));
        queryGeneralLedgerInfo.setShowLeafAccount(true);
        queryGeneralLedgerInfo.setOptionPosting(this.rptSheetParam.isIsIncludingUnposted());
        AcctountAsstItemParser.AccountAsstItem accountAsstItem = AcctountAsstItemParser.parse(this.getAcctAsstItems());
        AcctountAsstItemParser.AsstItem[] asstItems = accountAsstItem.asstItems;
        if (asstItems == null) {
            queryGeneralLedgerInfo.setAsstActList(null);
        } else {
            queryGeneralLedgerInfo.setShowDisplayAsstDetail(true);
            String acctAsstItems = this.getAcctAsstItems();
            if (acctAsstItems.indexOf("#") > 0) {
                queryGeneralLedgerInfo.setFilteByCatalog(true);
                queryGeneralLedgerInfo.setAsstActList(acctAsstItems.replaceAll("#", "%"));
            } else {
                queryGeneralLedgerInfo.setAsstActList(acctAsstItems);
            }
        }
        queryGeneralLedgerInfo.setCompanyDisplayMode("1");
        queryGeneralLedgerInfo.setOptionShowAccountCusAttribute(false);
        queryGeneralLedgerInfo.setEnumerateProfitCenter(this.companyOrg.getNumber());
        Gson gson = new Gson();
        json = gson.toJson((Object)queryGeneralLedgerInfo);
        return json;
    }

    public String getCompany() {
        return this.company;
    }

    public void setCompany(String company) {
        this.company = company;
    }

    public String getCurrencyId() {
        return this.currencyId;
    }

    public void setCurrencyId(String currencyId) {
        this.currencyId = currencyId;
    }

    public String getCurrencyName() {
        return this.currencyName;
    }

    public void setCurrencyName(String currencyName) {
        this.currencyName = currencyName;
    }

    public String getEndAccount() {
        return this.endAccount;
    }

    public void setEndAccount(String endAccount) {
        this.endAccount = endAccount;
    }

    public int getEndFiscal() {
        return this.endFiscal;
    }

    public void setEndFiscal(int endFiscal) {
        this.endFiscal = endFiscal;
    }

    public int getEndYear() {
        return this.endYear;
    }

    public void setEndYear(int endYear) {
        this.endYear = endYear;
    }

    public HashMap getItems() {
        return this.items;
    }

    public void setItems(HashMap items) {
        this.items = items;
    }

    public String getStartAccount() {
        return this.startAccount;
    }

    public void setStartAccount(String startAccount) {
        this.startAccount = startAccount;
    }

    public int getStartFiscal() {
        return this.startFiscal;
    }

    public void setStartFiscal(int startFiscal) {
        this.startFiscal = startFiscal;
    }

    public int getStartYear() {
        return this.startYear;
    }

    public void setStartYear(int startYear) {
        this.startYear = startYear;
    }

    public String getComputetype() {
        return this.computetype;
    }

    public void setComputetype(String computetype) {
        this.computetype = computetype;
    }

    public int getLevelEnd() {
        return this.levelEnd;
    }

    public void setLevelEnd(int levelEnd) {
        this.levelEnd = levelEnd;
    }

    public int getLevelStart() {
        return this.levelStart;
    }

    public void setLevelStart(int levelStart) {
        this.levelStart = levelStart;
    }

    public static AccountViewInfo getAccountView(boolean isend, String beginNumber, String endNumber, String companyId, String accountTableId, boolean isProfitCenter) throws SQLException, EASBizException, BOSException {
        String locale = SysContext.getSysContext().getLocale().toString();
        String sql = null;
        sql = isProfitCenter ? "select top 1 FLevel,Fid,Fnumber,Fname_" + locale + " fname from T_BD_AccountView where FCompanyID=? and FAccountTableID=? and FNumber>=? and FNumber<=? order by FNumber" : "select top 1 FLevel,Fid,Fnumber,Fname_" + locale + " fname from T_BD_AccountView where FCompanyID=? and FAccountTableID=? and FNumber>=? and FNumber<=? order by FNumber";
        if (isend) {
            sql = sql + " desc ";
        }
        SqlParams sp = new SqlParams().setString(1, companyId).setString(2, accountTableId).setString(3, beginNumber).setString(4, endNumber);
        RptRowSet rst = CommRptBaseFactory.getRemoteInstance().executeQuery(sql, sp, 0, -1);
        AccountViewInfo info = new AccountViewInfo();
        if (rst.next()) {
            info.setId(BOSUuid.read((String)rst.getString("Fid")));
            info.setNumber(rst.getString("Fnumber"));
            info.setName(rst.getString("Fname"));
            info.setLevel(rst.getInt("FLevel"));
            return info;
        }
        throw new ReportException(ReportException.ACCOUNT_NOT_FOUND);
    }

    public String getAcctAsstItems() {
        if (StringUtils.isEmpty((String)this.acctAsstItems)) {
            String account = "";
            account = this.startAccount.equals(this.endAccount) ? this.startAccount : this.startAccount + ":" + this.endAccount;
            if (this.items == null) {
                return account;
            }
            Set keyset = this.items.keySet();
            for (String key : keyset) {
                account = account + "|" + key + "|" + this.items.get(key);
            }
            return account;
        }
        return this.acctAsstItems;
    }

    public void setAcctAsstItems(String acctAsstItems) {
        this.acctAsstItems = acctAsstItems;
    }
}

