/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.basedata.master.account.AccountTableCollection;
import com.kingdee.eas.basedata.master.account.AccountTools;
import com.kingdee.eas.basedata.master.account.client.AccountPromptBox;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.rpt.client.AcctItemSelector2UI;
import com.kingdee.eas.fi.rpt.client.FormulaWizardUI;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.eas.fi.rpt.util.RptUtilForClient;
import com.kingdee.eas.util.client.MsgBox;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JDialog;
import org.apache.log4j.Logger;

public class AcctItemSelector2
extends JDialog
implements KDPromptSelector {
    private static Logger logger = Logger.getLogger(AcctItemSelector2.class);
    protected IUIWindow acctItemSelector2UI;
    protected boolean isCanceled = false;
    FormulaWizardUI formulaWizardUI = null;
    CompanyOrgUnitInfo company = null;
    String paramName = null;

    @Override
    public void show() {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"Owner", (Object)this.formulaWizardUI);
        IUIFactory uiFactory = null;
        uiContext.put((Object)"ID", null);
        try {
            uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
            this.acctItemSelector2UI = uiFactory.create("com.kingdee.eas.fi.rpt.client.AcctItemSelector2UI", (Map)uiContext, null, OprtState.VIEW);
            String companyID = this.formulaWizardUI.getParam("fiOrgUnit");
            if (companyID != null && companyID.indexOf(";") > 0) {
                companyID = companyID.substring(0, companyID.indexOf(";"));
            }
            if (this.company != null) {
                this.company = companyID != null && companyID.length() > 0 ? RptUtilForClient.getCompanyOrgUnitInfoByNumber(companyID) : RptUtilForClient.getCurrentCompany();
            }
            AcctItemSelector2UI chooser = (AcctItemSelector2UI)this.acctItemSelector2UI.getUIObject();
            chooser.acount.setSelector((KDPromptSelector)new AccountPromptBox(this.acctItemSelector2UI.getUIObject(), this.company));
            chooser.setCompany(this.company);
            chooser.setParamName(this.paramName);
            this.acctItemSelector2UI.show();
        }
        catch (BOSException ex) {
            logger.error((Object)ex.getMessage());
        }
        catch (EASBizException ex) {
            logger.error((Object)ex.getMessage());
        }
    }

    public Object getData() {
        if (this.acctItemSelector2UI == null) {
            return null;
        }
        try {
            AcctItemSelector2UI selectorUI = (AcctItemSelector2UI)this.acctItemSelector2UI.getUIObject();
            String result = selectorUI.getData();
            return result;
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean isCanceled() {
        AcctItemSelector2UI selectorUI = (AcctItemSelector2UI)this.acctItemSelector2UI.getUIObject();
        this.isCanceled = selectorUI.isCanceled();
        return this.isCanceled;
    }

    public FormulaWizardUI getFormulaWizardUI() {
        return this.formulaWizardUI;
    }

    public void setFormulaWizardUI(FormulaWizardUI wizardUI) {
        this.formulaWizardUI = wizardUI;
    }

    public void setCtrlComponent(JComponent pb) {
        this.paramName = pb.getName();
        ((KDBizPromptBox)pb).addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                boolean pass = false;
                try {
                    pass = this.checkHasMutilAccountTable();
                }
                catch (Exception x) {
                    pass = true;
                }
                if (pass) {
                    e.setCanceled(true);
                }
            }

            private boolean checkHasMutilAccountTable() throws Exception {
                AccountTableCollection acctTables;
                String companyNumber = AcctItemSelector2.this.formulaWizardUI.getParam("fiOrgUnit");
                if (companyNumber != null && companyNumber.indexOf(";") > 0) {
                    companyNumber = companyNumber.substring(0, companyNumber.indexOf(";")).trim();
                }
                if (companyNumber == null || companyNumber.trim().length() == 0) {
                    AcctItemSelector2.this.company = SysContext.getSysContext().getCurrentFIUnit();
                } else {
                    try {
                        AcctItemSelector2.this.company = RptUtilForClient.getCompanyOrgUnitInfoByNumber(companyNumber);
                        if (AcctItemSelector2.this.company == null) {
                            MsgBox.showWarning((String)RptUtil.getResourceSince51("CompanyNoExists"));
                            return true;
                        }
                    }
                    catch (Exception e) {
                        AcctItemSelector2.this.company = SysContext.getSysContext().getCurrentFIUnit();
                    }
                }
                if (AcctItemSelector2.this.company.isIsOnlyUnion() && (acctTables = AccountTools.getAllAccountTableByCU(null, (CtrlUnitInfo)AcctItemSelector2.this.company.getCU())).size() > 1) {
                    MsgBox.showWarning((String)RptUtil.getResourceSince51("ThisCompanyExistsMultiAccountTable"));
                    return true;
                }
                return false;
            }
        });
    }
}

