/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.rpt.InitDataFacadaFactory;
import com.kingdee.eas.fi.rpt.client.AbstractAcctItemSelector2UI;
import com.kingdee.eas.fi.rpt.client.FormulaWizardUI;
import com.kingdee.eas.fi.rpt.client.RptHelper;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.eas.util.client.EASResource;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.swing.Action;
import org.apache.log4j.Logger;

public class AcctItemSelector2UI
extends AbstractAcctItemSelector2UI {
    private static final Logger logger = CoreUIObject.getLogger(AcctItemSelector2UI.class);
    private CompanyOrgUnitInfo company = null;
    FormulaWizardUI formulaWizardUI = null;
    private boolean isCanceled = false;
    private String paramName = null;
    private StringBuffer sbRetItem = new StringBuffer("");
    private ItemListener myIemStateListener = new ItemListener(){

        @Override
        public void itemStateChanged(ItemEvent arg0) {
            AcctItemSelector2UI.this.item.setValue(null);
            AcctItemSelector2UI.this.updateItemControl();
        }
    };
    private DataChangeListener myDataChangeListener = new DataChangeListener(){

        public void dataChanged(DataChangeEvent eventObj) {
            AcctItemSelector2UI.this.accountChanged(eventObj.getOldValue(), eventObj.getNewValue());
        }
    };

    public AcctItemSelector2UI() throws Exception {
        this.btnCancel.setEnabled(true);
        this.btnOk.setEnabled(true);
    }

    public String getUITitle() {
        String strMsg = EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResource.FiRpt_Title_AcctItemSelectorUI");
        return strMsg;
    }

    public void initData() {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("companyid", (Object)this.getCompany().getId().toString()));
        this.acount.setEditable(false);
        this.acount.setEditFormat("$number$");
        this.acount.setDisplayFormat("$number$ - $name$");
        this.acount.setQueryInfo("com.kingdee.eas.fi.gl.app.AccountAgeAccountQuery");
        this.acount.setEntityViewInfo(view);
        this.acount.addDataChangeListener(this.myDataChangeListener);
        this.type.removeAllItems();
        this.type.addItem(null);
        this.item.setValue(null);
        this.type.addItemListener(this.myIemStateListener);
        this.updateItemControl();
    }

    private void updateItemControl() {
        AccountViewInfo acv = (AccountViewInfo)this.acount.getValue();
        AsstActTypeInfo aat = (AsstActTypeInfo)this.type.getSelectedItem();
        if (acv != null && aat != null) {
            FilterItemCollection fic;
            FilterInfo filter;
            this.item.setEnabled(true);
            this.item.setEditable(false);
            this.item.setEditable(true);
            this.item.setEditFormat("$number$");
            this.item.setDisplayFormat("$number$ - $name$");
            if (aat.getRealtionDataObject().equalsIgnoreCase("T_BD_CashFlowItem")) {
                this.item.setQueryInfo("com.kingdee.eas.fi.gl.app.VoucherCashflowItemQuery");
            } else if (aat.getRealtionDataObject().equalsIgnoreCase("T_BD_Customer")) {
                this.item.setQueryInfo("com.kingdee.eas.fi.rpt.app.F7CustomerQuery");
            } else if (aat.getRealtionDataObject().equalsIgnoreCase("T_BD_Supplier")) {
                this.item.setQueryInfo("com.kingdee.eas.fi.rpt.app.F7SupplierQuery");
            } else {
                this.item.setQueryInfo(aat.getDefaultQueryName());
            }
            EntityViewInfo view = new EntityViewInfo();
            if (aat.isIsForCompany()) {
                filter = new FilterInfo();
                view.setFilter(filter);
                fic = filter.getFilterItems();
                fic.add(new FilterItemInfo("company.id", (Object)this.getCompany().getId().toString()));
                fic.add(new FilterItemInfo("company.id", null));
                filter.setMaskString("#0 or #1");
                this.item.setEntityViewInfo(view);
                this.item.setHasCUDefaultFilter(false);
            }
            if (aat.getRealtionDataObject().equalsIgnoreCase("T_BD_GeneralAsstActType")) {
                filter = new FilterInfo();
                view.getSorter().clear();
                view.setFilter(filter);
                fic = filter.getFilterItems();
                fic.add(new FilterItemInfo("group.id", (Object)aat.getGlAsstActTypeGrp().getId().toString()));
                if (aat.getGlAsstActTypeGrp().getShareTactic().getValue() == 3) {
                    fic.add(new FilterItemInfo("creatorCompany.id", (Object)this.getCompany().getId().toString()));
                    filter.setMaskString("#0 and #1 ");
                } else if (aat.getGlAsstActTypeGrp().getShareTactic().getValue() == 4) {
                    StringTokenizer tok = new StringTokenizer(this.getCompany().getLongNumber(), "!");
                    ArrayList<String> list = new ArrayList<String>();
                    while (tok.hasMoreTokens()) {
                        list.add(tok.nextToken());
                    }
                    StringBuffer buf = new StringBuffer();
                    StringBuffer longnumber = new StringBuffer();
                    for (int i = 0; i < list.size(); ++i) {
                        if (i > 0) {
                            buf.append(" or #" + (i + 1));
                        } else {
                            buf.append("#" + (i + 1));
                        }
                        if (i > 0) {
                            longnumber.append("!");
                        }
                        longnumber.append(list.get(i).toString());
                        fic.add(new FilterItemInfo("creatorCompany.longnumber", (Object)longnumber.toString()));
                    }
                    filter.setMaskString("#0 and ( " + buf.toString() + ")");
                } else {
                    filter.setMaskString("#0 ");
                }
                this.item.setEntityViewInfo(view);
                this.item.setHasCUDefaultFilter(false);
                this.item.setEditFormat("$number$");
                this.item.setDisplayFormat("$number$ - $name$");
            } else if ("T_Org_Admin".equalsIgnoreCase(aat.getRealtionDataObject()) || "T_BD_Person".equalsIgnoreCase(aat.getRealtionDataObject()) || "T_ORG_CostCenter".equalsIgnoreCase(aat.getRealtionDataObject())) {
                try {
                    if (RptUtil.isTrue(ParamManager.getParamValue(null, (IObjectPK)new ObjectUuidPK(this.company.getId()), (String)"fi_rp_004"))) {
                        filter = new FilterInfo();
                        view.getSorter().clear();
                        view.setFilter(filter);
                        fic = filter.getFilterItems();
                        fic.add(new FilterItemInfo("CU.id", (Object)this.company.getId().toString()));
                        this.item.setEntityViewInfo(view);
                    }
                }
                catch (EASBizException e) {
                    this.handleException((Exception)((Object)e));
                    logger.debug((Object)e.getMessage());
                }
                catch (BOSException e) {
                    this.handleException((Exception)((Object)e));
                    logger.debug((Object)e.getMessage());
                }
            }
        } else {
            this.item.setValue(null);
            this.item.setEnabled(false);
            this.item.setEditable(false);
        }
    }

    private void accountChanged(Object oldValue, Object newValue) {
        this.type.removeAllItems();
        this.item.setValue(null);
        AccountViewInfo acv = (AccountViewInfo)this.acount.getValue();
        if (acv != null) {
            try {
                ArrayList list = InitDataFacadaFactory.getRemoteInstance().getAcctType(this.getCompany(), acv);
                this.type.addItems(list.toArray());
                this.type.setSelectedIndex(-1);
                this.updateItemControl();
            }
            catch (EASBizException e) {
                this.handleException((Exception)((Object)e));
                logger.debug((Object)e.getMessage());
            }
            catch (BOSException e) {
                this.handleException((Exception)((Object)e));
                logger.debug((Object)e.getMessage());
            }
        }
    }

    public String getData() {
        return this.sbRetItem.toString();
    }

    public boolean isCanceled() {
        return this.isCanceled;
    }

    public void onShow() throws Exception {
        super.onShow();
        this.initData();
        RptHelper.setEscAction((CoreUIObject)this, (Action)this.actionExitCurrent);
    }

    private FormulaWizardUI getFormulaUI() {
        if (this.formulaWizardUI != null) {
            return this.formulaWizardUI;
        }
        Object obj = this.getUIContext().get("Owner");
        if (obj != null && obj instanceof FormulaWizardUI) {
            FormulaWizardUI wizard;
            this.formulaWizardUI = wizard = (FormulaWizardUI)obj;
            return wizard;
        }
        return null;
    }

    public void setCompany(CompanyOrgUnitInfo company) {
        this.company = company;
    }

    public CompanyOrgUnitInfo getCompany() {
        if (this.company == null) {
            this.company = SysContext.getSysContext().getCurrentFIUnit();
        }
        return this.company;
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.isCanceled = true;
        this.disposeUIWindow();
    }

    @Override
    public void actionOK_actionPerformed(ActionEvent e) throws Exception {
        AccountViewInfo acountv = (AccountViewInfo)this.acount.getValue();
        AsstActTypeInfo typev = (AsstActTypeInfo)this.type.getSelectedItem();
        Object itemv = this.item.getValue();
        if (acountv == null) {
            this.disposeUIWindow();
            return;
        }
        this.sbRetItem.append(acountv.getNumber());
        if (typev == null) {
            this.disposeUIWindow();
            return;
        }
        AsstActTypeInfo aat = typev;
        this.sbRetItem.append("|" + typev.getNumber());
        if (itemv == null) {
            this.disposeUIWindow();
            return;
        }
        Method m = itemv.getClass().getMethod("getNumber", new Class[0]);
        Object fnumber = m.invoke(itemv, new Object[0]);
        this.sbRetItem.append("|" + fnumber.toString());
        this.disposeUIWindow();
    }

    public boolean destroyWindow() {
        this.isCanceled = true;
        return super.destroyWindow();
    }

    public String getParamName() {
        return this.paramName;
    }

    public void setParamName(String paramName) {
        this.paramName = paramName;
    }
}

