/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgTreeCollection;
import com.kingdee.eas.basedata.org.OrgTreeFactory;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.basedata.org.UnionVersionStatusEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.cslrpt.AdjustModeCollection;
import com.kingdee.eas.fi.gr.cslrpt.AdjustModeFactory;
import com.kingdee.eas.fi.gr.cslrpt.CSLContext;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.DataCollectConstant;
import com.kingdee.eas.fi.gr.cslrpt.IAdjustMode;
import com.kingdee.eas.fi.gr.cslrpt.ICSLContext;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.gr.cslrpt.util.CSLParamUtil;
import com.kingdee.eas.fi.newrpt.CslGradeManageUtil;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.client.AbstractAdjustCompanyFilterUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class AdjustCompanyFilterUI
extends AbstractAdjustCompanyFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(AdjustCompanyFilterUI.class);
    private boolean isSupport13Period = CSLParamUtil.isSupport13Period(null);
    private FullOrgUnitCollection fullOrgUnitCollection;

    protected ICSLContext getCSLContext() {
        if (this.cslCtx == null) {
            this.initCSLContext();
        }
        return this.cslCtx;
    }

    protected void initCSLContext() {
        this.cslCtx = new CSLContext();
    }

    protected void initForFilterUI() throws Exception {
        this.init();
    }

    protected void initBizPrmtCompany() {
    }

    public void init() throws Exception {
        super.init();
        this.dpDate.setValue((Object)CslRptUIUtil.getLastPeriodDate(null), false);
        this.dpDate.setSupportedEmpty(false);
        this.cbxPeriodType.setSelectedItem((Object)RptPeriodTypeEnum.MONTHLY);
        this.cbxPeriodType.setEnabled(true);
        this.refreshOrgBound((Date)this.dpDate.getValue());
    }

    protected CurrencyCollection getCurrencyCollection() {
        CurrencyCollection currencyCollection = null;
        try {
            ICurrency iCurrency = CurrencyFactory.getRemoteInstance();
            currencyCollection = iCurrency.getCurrencyCollection(this.getEntityViewInfo());
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        return currencyCollection;
    }

    private EntityViewInfo getEntityViewInfo() {
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("number"));
        viewInfo.getSelector().add(new SelectorItemInfo("name"));
        viewInfo.getSorter().add(new SorterItemInfo("number"));
        return viewInfo;
    }

    protected AdjustModeCollection getAdjustModeCollection() {
        AdjustModeCollection adjustModeCollection = null;
        try {
            CslGradeManageUtil.filterAdjustModeGradeManage(null, (EntityViewInfo)this.getEntityViewInfo(), null);
            IAdjustMode iAdjustMode = AdjustModeFactory.getRemoteInstance();
            adjustModeCollection = iAdjustMode.getAdjustModeCollection(this.getEntityViewInfo());
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        return adjustModeCollection;
    }

    private void refreshOrgBound(Date date) throws EASBizException, BOSException {
        OrgUnitInfo currentOrgUnitInfo;
        OrgTreeCollection orgTreeColl;
        OrgTreeCollection otc = CslRptUIUtil.getOrgTreeCollection((Date)date);
        if (otc == null) {
            return;
        }
        ArrayList<String> orgTreeIDList = new ArrayList<String>();
        OrgTreeInfo info = null;
        UserInfo user = SysContext.getSysContext().getCurrentUserInfo();
        for (int i = 0; i < otc.size(); ++i) {
            info = otc.get(i);
            if (info.isIsHide() || info.getLayerType() == OrgViewType.PROFITCENTER || UnionVersionStatusEnum.UNSTART.equals((Object)info.getStatus())) continue;
            Map fullOrgUnitIDmap = PermissionFactory.getRemoteInstance().getUnionUnits(CslRptUtil.getPK((IObjectValue)user), CslRptUtil.getPK((IObjectValue)info));
            FullOrgUnitInfo fullOrgUnitInfo = this.getOrgUnitByTreeAndUnit(info.getId().toString());
            if (fullOrgUnitInfo == null || !fullOrgUnitIDmap.containsKey(fullOrgUnitInfo.getId().toString())) continue;
            orgTreeIDList.add(info.getId().toString());
        }
        this.cbxOrgBound.removeAllItems();
        if (!orgTreeIDList.isEmpty() && (orgTreeColl = this.getOrgTreeCollectionByCompanyPK(CslRptUtil.getPK((IObjectValue)(currentOrgUnitInfo = SysContext.getSysContext().getCurrentOrgUnit())), orgTreeIDList)) != null) {
            this.cbxOrgBound.addItems(orgTreeColl.toArray());
        }
    }

    private String getOrgTreeSQLByCompanyPK(IObjectPK companyPK, ArrayList orgTreeIDList) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT tree.fid ").append("FROM T_ORG_Tree tree ").append("INNER JOIN T_ORG_STRUCTURE structure ON structure.FTreeId =tree.fid ").append("WHERE structure.FunitId='").append(companyPK).append("' and tree.FTYPE=8 ").append("and tree.fid in (").append(CslRptUtil.collection2String((Collection)orgTreeIDList, (String)",", (boolean)true)).append(")");
        return sql.toString();
    }

    private OrgTreeCollection getOrgTreeCollectionByCompanyPK(IObjectPK companyPK, ArrayList orgTreeIDList) throws BOSException {
        if (!StringUtils.isEmpty((String)companyPK.toString())) {
            String permFilterSql = this.getOrgTreeSQLByCompanyPK(companyPK, orgTreeIDList);
            OrgTreeCollection coll = OrgTreeFactory.getRemoteInstance().getOrgTreeCollection("select id,name,status,startDate,endDate,number where id in (" + permFilterSql + ")");
            return coll;
        }
        return null;
    }

    protected ArrayList getFilterInfoFromCslCtx(int formulaIndex, StringBuffer sbFormula) {
        if (this.cbxOrgBound.getSelectedItem() != null) {
            String orgBoundId = ((OrgTreeInfo)this.cbxOrgBound.getSelectedItem()).getId().toString();
            FilterItemInfo filterItemOrgBound = new FilterItemInfo("orgBound.id", (Object)orgBoundId, CompareType.EQUALS);
            this.filterInfo.getFilterItems().add(filterItemOrgBound);
            sbFormula.append(" #" + formulaIndex++);
        }
        FilterItemInfo filterItem1 = new FilterItemInfo("periodType", (Object)new Integer(((RptPeriodTypeEnum)this.cbxPeriodType.getSelectedItem()).getValue()), CompareType.EQUALS);
        FilterItemInfo filterItem2 = new FilterItemInfo("year", (Object)new Integer(this.spYear.getIntegerVlaue()), CompareType.EQUALS);
        FilterItemInfo filterItem3 = new FilterItemInfo("period", (Object)new Integer(this.spPeriod.getIntegerVlaue()), CompareType.EQUALS);
        this.filterInfo.getFilterItems().add(filterItem1);
        sbFormula.append(" and #" + formulaIndex++);
        this.filterInfo.getFilterItems().add(filterItem2);
        sbFormula.append(" and #" + formulaIndex++);
        this.filterInfo.getFilterItems().add(filterItem3);
        sbFormula.append(" and #" + formulaIndex++);
        this.getCslCtxToList();
        ArrayList<Comparable<Integer>> list = new ArrayList<Comparable<Integer>>();
        list.add(Integer.valueOf(formulaIndex));
        list.add(sbFormula);
        return list;
    }

    private void getCslCtxToList() {
        CSLContext cslContext = new CSLContext();
        cslContext.setCurOrgBound((OrgTreeInfo)this.cbxOrgBound.getSelectedItem());
        cslContext.setCurOrgGroup((OrgUnitInfo)this.getOrgUnitByTreeAndUnit(((OrgTreeInfo)this.cbxOrgBound.getSelectedItem()).getId().toString()));
        try {
            cslContext.setCurReportDate((Date)this.dpDate.getValue());
        }
        catch (BOSException e) {
            super.handUIException((Throwable)e);
        }
        cslContext.setCurRptPeriod(this.spPeriod.getIntegerVlaue().intValue());
        cslContext.setCurRptPeriodType((RptPeriodTypeEnum)this.cbxPeriodType.getSelectedItem());
        cslContext.setCurRptYear(this.spYear.getIntegerVlaue().intValue());
        cslContext.setQueryBudget(false);
        cslContext.setCurDataCollect(DataCollectConstant.getActualDC());
        this.getUIContext().put("companyCtx", cslContext);
    }

    private String getUnionSQLByCompanyPKAndTreePK(IObjectPK companyPK, IObjectPK treeID) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT unit.fid ").append("FROM T_ORG_BASEUNIT unit ").append("INNER JOIN T_ORG_STRUCTURE structure ON structure.funitid = unit.fid ").append("WHERE unit.fisunion = 1 and structure.FID in").append("(SELECT FPARENTID FROM T_ORG_Structure where FunitId='").append(companyPK).append("'").append(" AND FTreeId = '").append(treeID).append("')");
        return sql.toString();
    }

    private FullOrgUnitInfo getOrgUnitByTreeAndUnit(String treeId) {
        if (!StringUtils.isEmpty((String)treeId)) {
            try {
                String permFilterSql = this.getUnionSQLByCompanyPKAndTreePK(CslRptUtil.getPK((IObjectValue)SysContext.getSysContext().getCurrentOrgUnit()), (IObjectPK)new ObjectStringPK(treeId));
                FullOrgUnitCollection coll = FullOrgUnitFactory.getRemoteInstance().getFullOrgUnitCollection("select id,name,number where id in (" + permFilterSql + ")");
                if (coll == null) {
                    return null;
                }
                return coll.get(0);
            }
            catch (BOSException e) {
                logger.error((Object)("getOrgUnitByTreeAndUnit:" + treeId), (Throwable)e);
            }
        }
        return null;
    }

    protected void clearUIofcbxPeriodType() throws BOSException {
        this.cbxPeriodType.setSelectedItem((Object)RptPeriodTypeEnum.MONTHLY);
        this.dpDate.setValue((Object)CslRptUIUtil.getLastPeriodDate(null), false);
        this.refreshTimeInfo((Date)this.dpDate.getValue());
    }

    private void refreshTimeInfo(Date newDate) {
        RptPeriodTypeEnum p = (RptPeriodTypeEnum)this.cbxPeriodType.getSelectedItem();
        if (p == null) {
            return;
        }
        List times = RPTDateUtil.getRptPeriod((Date)newDate, (RptPeriodTypeEnum)p);
        this.spYear.setValue((Object)new Integer(times.get(0).toString()));
        this.spPeriod.setValue((Object)new Integer(times.get(1).toString()));
        this.dpDate.setValue(times.get(2));
        if (this.isSupport13Period && (Integer)this.spPeriod.getValue() == 12) {
            this.spPeriod.setEnabled(true);
            CslRptUIUtil.setSpineRange((KDSpinner)this.spPeriod, (int)0, (int)13, (boolean)true, (boolean)true);
        }
    }

    @Override
    protected void cbxPeriodType_actionPerformed(ActionEvent e) throws Exception {
        this.refreshMergeByFiscalPeriodUI();
        this.refreshTimeInfo(this.dpDate.getSqlDate());
    }

    private void refreshMergeByFiscalPeriodUI() {
        this.dpDate.setEnabled(true);
        this.spYear.setEnabled(false);
        this.spPeriod.setEnabled(false);
        this.spYear.setEditable(false);
        this.spPeriod.setEditable(false);
    }

    @Override
    protected void rptDate_dataChanged(DataChangeEvent e) throws Exception {
        if (this.dpDate.getValue() != null && this.dpDate.getValue() instanceof Date) {
            this.refreshTimeInfo(this.dpDate.getSqlDate());
            this.refreshOrgBound((Date)this.dpDate.getValue());
        }
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        this.clearUI();
        super.loadData(entityViewInfo);
        FilterItemCollection currentFilterItemCollection = entityViewInfo.getFilter() == null ? new FilterItemCollection() : entityViewInfo.getFilter().getFilterItems();
        int year = 0;
        int period = 0;
        RptPeriodTypeEnum periodTypeEnum = null;
        String orgBoundID = null;
        for (int i = 0; i < currentFilterItemCollection.size(); ++i) {
            FilterItemInfo filterItemInfo = currentFilterItemCollection.get(i);
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("orgBound.id")) {
                orgBoundID = (String)filterItemInfo.getCompareValue();
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("periodType")) {
                int periodType = (Integer)filterItemInfo.getCompareValue();
                for (int j = 0; j < this.cbxPeriodType.getItemCount(); ++j) {
                    RptPeriodTypeEnum rptPeriodTypeEnum = (RptPeriodTypeEnum)this.cbxPeriodType.getItemAt(j);
                    if (rptPeriodTypeEnum.getValue() != periodType) continue;
                    periodTypeEnum = rptPeriodTypeEnum;
                    this.cbxPeriodType.setSelectedIndex(j);
                    break;
                }
                this.cbxPeriodType.setEnabled(true);
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("year")) {
                year = (Integer)filterItemInfo.getCompareValue();
                continue;
            }
            if (!filterItemInfo.getPropertyName().equalsIgnoreCase("period")) continue;
            period = (Integer)filterItemInfo.getCompareValue();
        }
        Date curRptDate = null;
        try {
            curRptDate = RPTDateUtil.getPeriodLastDate((int)year, (int)period, periodTypeEnum);
        }
        catch (Exception e) {
            super.handUIException((Throwable)e);
        }
        if (curRptDate != null) {
            this.dpDate.setValue((Object)curRptDate, true);
            this.refreshTimeInfo((Date)this.dpDate.getValue());
        }
        for (int j = 0; j < this.cbxOrgBound.getItemCount(); ++j) {
            OrgTreeInfo orgBoundInfo = (OrgTreeInfo)this.cbxOrgBound.getItemAt(j);
            if (!orgBoundInfo.getId().toString().equals(orgBoundID)) continue;
            this.cbxOrgBound.setSelectedIndex(j);
            break;
        }
    }

    public boolean verify() {
        if (this.cbxOrgBound.getSelectedItem() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResource", (String)"Msg_NoFindOrgBound"));
            SysUtil.abort();
        }
        return true;
    }
}

