/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDScrollBar;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupFactory;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupStandardCollection;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupStandardFactory;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupStandardInfo;
import com.kingdee.eas.basedata.master.material.MaterialGroupFactory;
import com.kingdee.eas.basedata.master.material.MaterialGroupStandardCollection;
import com.kingdee.eas.basedata.master.material.MaterialGroupStandardFactory;
import com.kingdee.eas.basedata.master.material.MaterialGroupStandardInfo;
import com.kingdee.eas.fi.rpt.TableToolkit;
import com.kingdee.eas.fi.rpt.client.AbstractAsstGroupChooserUI;
import com.kingdee.eas.fi.rpt.client.ISimpleDialogListener;
import com.kingdee.eas.fi.rpt.util.AcctountAsstItemParser;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.util.StringUtils;
import java.awt.event.ActionEvent;
import javax.swing.JComboBox;
import javax.swing.JScrollBar;
import org.apache.log4j.Logger;

public class AsstGroupChooserUIForOneRow
extends AbstractAsstGroupChooserUI {
    private static final Logger logger = CoreUIObject.getLogger(AsstGroupChooserUIForOneRow.class);
    protected static final int CUSTOMER_GROUP = 1;
    protected static final int SUPPLIER_GROUP = 2;
    protected static final int MATERIAL_GROUP = 3;
    private int groupType = 1;
    private KDComboBox cbxStandard = null;
    private IObjectCollection standards;
    private IObjectCollection selectedStandard = null;
    private KDBizPromptBox groupChoosebox = new KDBizPromptBox();
    private ISimpleDialogListener _listener;

    public AsstGroupChooserUIForOneRow() throws Exception {
        this.tblGroup.checkParsed();
        this.tblGroup.getSelectManager().setSelectMode(2);
        this.tblGroup.getStyleAttributes().setLocked(true);
        this.tblGroup.getIndexColumn().getStyleAttributes().setHided(true);
        this.tblGroup.getLayoutManager().setHorizonScrollBar((JScrollBar)new KDScrollBar(0));
        this.tblGroup.getLayoutManager().setVerticalScrollBar((JScrollBar)new KDScrollBar(1));
        this.cbxStandard = new KDComboBox();
        this.tblGroup.addKDTEditListener(new KDTEditListener(){

            public void editStarting(KDTEditEvent e) {
                if (e.getColIndex() == 0) {
                    AsstGroupChooserUIForOneRow.this.cbxStandard.removeAllItems();
                    AsstGroupChooserUIForOneRow.this.cbxStandard.addItem(null);
                    for (int i = 0; i < AsstGroupChooserUIForOneRow.this.standards.size(); ++i) {
                        IObjectValue info = AsstGroupChooserUIForOneRow.this.standards.getObject(i);
                        if (info == e.getValue()) {
                            AsstGroupChooserUIForOneRow.this.cbxStandard.addItem((Object)info);
                            continue;
                        }
                        if (AsstGroupChooserUIForOneRow.this.selectedStandard.containsObject(info)) continue;
                        AsstGroupChooserUIForOneRow.this.cbxStandard.addItem((Object)info);
                    }
                } else if (e.getColIndex() >= 1) {
                    int r = AsstGroupChooserUIForOneRow.this.tblGroup.getSelectManager().getActiveRowIndex();
                    IObjectValue info = (IObjectValue)AsstGroupChooserUIForOneRow.this.tblGroup.getRow(r).getCell(0).getValue();
                    AsstGroupChooserUIForOneRow.this.setGroupFilter(info);
                }
            }

            public void editStarted(KDTEditEvent e) {
            }

            public void editValueChanged(KDTEditEvent e) {
                EntityViewInfo view = AsstGroupChooserUIForOneRow.this.groupChoosebox.getQueryAgent().getEntityViewInfo();
                String groupStandard = null;
                if (AsstGroupChooserUIForOneRow.this.groupType == 1) {
                    CSSPGroupStandardInfo CSSPGroupStandard = (CSSPGroupStandardInfo)AsstGroupChooserUIForOneRow.this.cbxStandard.getSelectedItem();
                    groupStandard = CSSPGroupStandard.getId().toString();
                } else if (AsstGroupChooserUIForOneRow.this.groupType == 2) {
                    AsstGroupChooserUIForOneRow.this.groupChoosebox.setQueryInfo("com.kingdee.eas.basedata.master.cssp.app.F7SupplierGroupQuery");
                    CSSPGroupStandardInfo CSSPGroupStandard = (CSSPGroupStandardInfo)AsstGroupChooserUIForOneRow.this.cbxStandard.getSelectedItem();
                    groupStandard = CSSPGroupStandard.getId().toString();
                } else {
                    AsstGroupChooserUIForOneRow.this.groupChoosebox.setQueryInfo("com.kingdee.eas.basedata.master.material.app.F7MaterialGroupQuery");
                    MaterialGroupStandardInfo MaterialGroupStandard = (MaterialGroupStandardInfo)AsstGroupChooserUIForOneRow.this.cbxStandard.getSelectedItem();
                    groupStandard = MaterialGroupStandard.getId().toString();
                }
                view.getFilter().appendFilterItem("groupStandard.id", (Object)groupStandard);
            }

            public void editStopping(KDTEditEvent e) {
            }

            public void editStopped(KDTEditEvent e) {
                KDTable tbl = (KDTable)e.getSource();
                IRow r = tbl.getRow(e.getRowIndex());
                int col = e.getColIndex();
                if (col == 0) {
                    if (e.getValue() == null) {
                        if (e.getOldValue() != null) {
                            AsstGroupChooserUIForOneRow.this.selectedStandard.removeObject(e.getOldValue());
                            if (tbl.getBody().size() > 1) {
                                tbl.removeRow(e.getRowIndex());
                            }
                        }
                    } else {
                        if (e.getOldValue() != null) {
                            IObjectValue IObjectValue2 = (IObjectValue)e.getOldValue();
                            AsstGroupChooserUIForOneRow.this.selectedStandard.removeObject(IObjectValue2);
                        }
                        AsstGroupChooserUIForOneRow.this.selectedStandard.addObject((IObjectValue)e.getValue());
                        if (e.getOldValue() != e.getValue()) {
                            r.getCell(1).setValue(null);
                            r.getCell(2).setValue(null);
                        }
                        r.getCell(1).getStyleAttributes().setLocked(false);
                        r.getCell(2).getStyleAttributes().setLocked(false);
                        if (e.getRowIndex() == tbl.getBody().size() - 1) {
                            // empty if block
                        }
                    }
                } else if (col == 1) {
                    if (r.getCell(2).getValue() == null) {
                        r.getCell(2).setValue(e.getValue());
                    }
                } else if (col == 2 && r.getCell(1).getValue() == null) {
                    r.getCell(1).setValue(e.getValue());
                }
            }

            public void editCanceled(KDTEditEvent e) {
            }
        });
    }

    private void setGroupFilter(IObjectValue info) {
        if (info == null) {
            return;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        FilterItemCollection fic = filter.getFilterItems();
        SorterItemInfo sorterItemInfo = new SorterItemInfo("longNumber");
        sorterItemInfo.setSortType(SortType.ASCEND);
        view.getSorter().add(sorterItemInfo);
        fic.add(new FilterItemInfo("groupStandard.id", info.get(info.getPKField())));
        this.groupChoosebox.setEntityViewInfo(view);
    }

    private IRow addGroupRow() {
        IRow r = this.tblGroup.addRow();
        r.getStyleAttributes().setLocked(false);
        r.getCell(0).setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)this.cbxStandard));
        r.getCell(1).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)this.groupChoosebox));
        r.getCell(1).getStyleAttributes().setLocked(true);
        r.getCell(2).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)this.groupChoosebox));
        r.getCell(2).getStyleAttributes().setLocked(true);
        return r;
    }

    protected void initUI(Object initData) throws Exception {
        if (this.groupType == 1) {
            this.groupChoosebox.setQueryInfo("com.kingdee.eas.basedata.master.cssp.app.F7CustomerGroupQuery");
            this.standards = CSSPGroupStandardFactory.getRemoteInstance().getCSSPGroupStandard(String.valueOf(this.groupType), false);
            this.selectedStandard = new CSSPGroupStandardCollection();
        } else if (this.groupType == 2) {
            this.groupChoosebox.setQueryInfo("com.kingdee.eas.basedata.master.cssp.app.F7SupplierGroupQuery");
            this.standards = CSSPGroupStandardFactory.getRemoteInstance().getCSSPGroupStandard(String.valueOf(this.groupType), false);
            this.selectedStandard = new CSSPGroupStandardCollection();
        } else {
            this.groupChoosebox.setQueryInfo("com.kingdee.eas.basedata.master.material.app.F7MaterialGroupQuery");
            this.standards = MaterialGroupStandardFactory.getRemoteInstance().getMaterialGroupStandardCollection();
            this.selectedStandard = new MaterialGroupStandardCollection();
        }
        this.groupChoosebox.setDisplayFormat("$number$-$name$");
        this.groupChoosebox.setCommitFormat("$number$;$name$");
        this.cbxStandard.addItem(null);
        for (int i = 0; i < this.standards.size(); ++i) {
            this.cbxStandard.addItem((Object)this.standards.getObject(i));
        }
        if (initData == null || "".equals(initData)) {
            this.addGroupRow();
            return;
        }
        AcctountAsstItemParser.AccountAsstItem dummy = TableToolkit.parseAcctItem("1001|001|" + (String)initData + "#");
        AcctountAsstItemParser.Group[] groups = dummy.asstItems[0].group;
        for (int i = 0; groups != null && i < groups.length; ++i) {
            String std = groups[i].standardNumber;
            IObjectValue info = this.getStandardByNumber(std);
            if (info == null) continue;
            this.selectedStandard.addObject(info);
            IRow r = this.addGroupRow();
            r.getCell(0).setValue((Object)info);
            IObjectValue ginfo = this.getGroupByNumber(groups[i].startNumber, info);
            r.getCell(1).setValue((Object)ginfo);
            r.getCell(1).getStyleAttributes().setLocked(false);
            if (!groups[i].startNumber.equals(groups[i].endNumber)) {
                ginfo = this.getGroupByNumber(groups[i].endNumber, info);
            }
            r.getCell(2).setValue((Object)ginfo);
            r.getCell(2).getStyleAttributes().setLocked(false);
        }
    }

    protected IObjectValue getGroupByNumber(String num, IObjectValue info) {
        try {
            if (this.groupType == 1 || this.groupType == 2) {
                CoreBaseCollection coll = CSSPGroupFactory.getRemoteInstance().getCollection("SELECT Name, Number, longNumber WHERE Number = '" + num + "' and (groupStandard.type = " + this.groupType + " or groupStandard.type =0) and groupStandard.id = '" + info.get(info.getPKField()).toString() + "'");
                if (coll == null || coll.size() < 1) {
                    return null;
                }
                return coll.get(0);
            }
            CoreBaseCollection coll = MaterialGroupFactory.getRemoteInstance().getCollection("SELECT Name, Number, longNumber WHERE Number = '" + num + "' ");
            if (coll == null || coll.size() < 1) {
                return null;
            }
            return coll.get(0);
        }
        catch (BOSException e) {
            return null;
        }
    }

    private IObjectValue getStandardByNumber(String std) {
        if (StringUtils.isEmpty((String)std) || this.standards == null || this.standards.size() < 1) {
            return null;
        }
        for (int i = 0; i < this.standards.size(); ++i) {
            IObjectValue info = this.standards.getObject(i);
            if (!info.get("Number").equals(std.trim())) continue;
            return info;
        }
        return null;
    }

    private String buildFormula() {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < this.tblGroup.getBody().size(); ++i) {
            IRow row = this.tblGroup.getRow(i);
            IObjectValue info = (IObjectValue)row.getCell(0).getValue();
            if (info == null) continue;
            IObjectValue startG = (IObjectValue)row.getCell(1).getValue();
            IObjectValue endG = (IObjectValue)row.getCell(2).getValue();
            if (startG == null && endG == null) continue;
            if (i > 0) {
                result.append('&');
            }
            result.append(info.get("Number")).append('#');
            if (startG == null) {
                result.append(endG.get("Number"));
                continue;
            }
            if (endG == null) {
                result.append(startG.get("Number"));
                continue;
            }
            if (startG.get("Number").equals(endG.get("Number"))) {
                result.append(startG.get("Number"));
                continue;
            }
            result.append(startG.get("Number")).append(':').append(endG.get("Number"));
        }
        return result.toString();
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void actionOK_actionPerformed(ActionEvent e) throws Exception {
        super.actionOK_actionPerformed(e);
        String s = this.buildFormula();
        if (this._listener != null) {
            this._listener.pilotReturnee(null, s, true);
        }
        this.destroyWindow();
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancel_actionPerformed(e);
        this.destroyWindow();
    }

    public int getGroupType() {
        return this.groupType;
    }

    public void setGroupType(int groupType) {
        this.groupType = groupType;
    }

    protected void setReturnListener(ISimpleDialogListener listener) {
        this._listener = listener;
    }
}

