/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.kdf.util.editor.EditorFactory;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.gr.cslrpt.client.SimpleNotePad;
import com.kingdee.eas.fi.rpt.IInitDataFacada;
import com.kingdee.eas.fi.rpt.InitDataFacadaFactory;
import com.kingdee.eas.fi.rpt.ReportFactory;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.RptTmpTypeEnum;
import com.kingdee.eas.fi.rpt.TemplateCollection;
import com.kingdee.eas.fi.rpt.TemplateFactory;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.fi.rpt.client.AbstractBatchAddReportUI;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.eas.fi.rpt.util.RptUtilForClient;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.PropertyContainer;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class BatchAddReportUI
extends AbstractBatchAddReportUI {
    private static final Logger logger = CoreUIObject.getLogger(BatchAddReportUI.class);
    private List allTemplates = new ArrayList();
    private List filterTemplates = new ArrayList();
    private Hashtable yearMap = new Hashtable();
    private Date currentDate = null;
    private Vector vecYear = new Vector(0);
    private boolean isSupport13Period = CslRptUtil.isSupport13Period(null);
    private SpinnerNumberModel spnYearModel = (SpinnerNumberModel)this.spnYear.getModel();
    private SpinnerNumberModel spnPeriodModel = (SpinnerNumberModel)this.spnPeriod.getModel();
    private boolean isCtrlPress = false;
    int tc = 0;
    String lasttempSort = null;
    String[] templateView = new String[]{"select", "templateType", "number", "name", "versionNumber", "***"};

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        CurrencyInfo natureCurrency;
        HashMap<String, Object> result;
        super.onLoad();
        this.kDTable1.checkParsed();
        this.setBtnEnabl(this.btnSelectAll);
        this.btnSelectAll.setIcon(EASResource.getIcon((String)"imgTbtn_selectall"));
        this.setBtnEnabl(this.btnClearAll);
        this.btnClearAll.setIcon(EASResource.getIcon((String)"imgTbtn_deleteall"));
        this.setBtnEnabl(this.btnCancel);
        this.setBtnEnabl(this.btnOK);
        this.loadAllTemplate();
        this.loadEnumToCbx(RptPeriodTypeEnum.iterator(), this.cbxPeriodType);
        this.kDTable1.getSelectManager().setSelectMode(10);
        this.kDTable1.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                if (e.getType() == 0) {
                    BatchAddReportUI.this.loadFilterTemplate(BatchAddReportUI.this.templateView[e.getColIndex()]);
                } else if (e.getType() == 1 && e.getButton() == 1 && e.getClickCount() == 1 && BatchAddReportUI.this.isCtrlPress) {
                    IRow row = BatchAddReportUI.this.kDTable1.getRow(e.getRowIndex());
                    boolean isSelect = (Boolean)row.getCell("select").getValue();
                    row.getCell("select").setValue((Object)(!isSelect ? 1 : 0));
                    BatchAddReportUI.this.kDTable1.checkParsed();
                }
            }
        });
        this.cbxPeriodType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                BatchAddReportUI.this.updatePeriodByYear();
                BatchAddReportUI.this.filterTemplate();
                BatchAddReportUI.this.setIsEnable();
            }
        });
        this.date.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                BatchAddReportUI.this.updateYearAndPeriod((Date)BatchAddReportUI.this.date.getValue());
            }
        });
        this.spnYear.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                BatchAddReportUI.this.updatePeriodByYear();
                BatchAddReportUI.this.updateDate();
            }
        });
        this.spnPeriod.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                BatchAddReportUI.this.updateDate();
            }
        });
        IInitDataFacada iInitDataFacada = InitDataFacadaFactory.getRemoteInstance();
        try {
            result = iInitDataFacada.initReportList(null);
        }
        catch (Exception e1) {
            logger.warn((Object)"", (Throwable)e1);
            result = new HashMap<String, Object>();
            result.put("CurrencyNoGLC", iInitDataFacada.getCurrencyNoGLC());
            result.put("Fiscal", iInitDataFacada.getFiscal());
            PeriodInfo natualDatePeriod = new PeriodInfo();
            int[] yearAndPeriod = RPTDateUtil.getPeriod((Date)new Date(), (RptPeriodTypeEnum)RptPeriodTypeEnum.MONTHLY);
            if (yearAndPeriod != null && yearAndPeriod.length == 2) {
                natualDatePeriod.setPeriodYear(yearAndPeriod[0]);
                natualDatePeriod.setPeriodNumber(yearAndPeriod[1]);
            }
            result.put("CurrentFiscal", natualDatePeriod);
        }
        CurrencyCollection initCurrencyCollection = (CurrencyCollection)result.get("CurrencyNoGLC");
        if (initCurrencyCollection != null && initCurrencyCollection.size() > 0) {
            this.cbxCurrency.addItems(initCurrencyCollection.toArray());
        }
        if ((natureCurrency = RptUtilForClient.getCurrenctCurrencyFromDatabase()) != null) {
            for (int i = 0; i < this.cbxCurrency.getItemCount(); ++i) {
                if (!((CurrencyInfo)this.cbxCurrency.getItemAt(i)).getId().toString().equals(natureCurrency.getId().toString())) continue;
                this.cbxCurrency.setSelectedIndex(i);
                break;
            }
        }
        PeriodCollection periodCollection = (PeriodCollection)result.get("Fiscal");
        int periods = periodCollection.size();
        ArrayList<Integer> tmp = new ArrayList<Integer>();
        if (periodCollection != null && periods > 0) {
            for (int i = 0; i < periods; ++i) {
                Vector periodVec;
                Integer year = new Integer(periodCollection.get(i).getPeriodYear());
                Integer period = new Integer(periodCollection.get(i).getPeriodNumber());
                if (!this.yearMap.containsKey(year)) {
                    periodVec = new Vector(12);
                    periodVec.addElement(period);
                    this.yearMap.put(year, periodVec);
                    tmp.add(year);
                    continue;
                }
                periodVec = (Vector)this.yearMap.get(year);
                if (periodVec == null) continue;
                periodVec.addElement(period);
            }
            Collections.sort(tmp);
            this.spnYearModel.setMaximum((Integer)tmp.get(tmp.size() - 1));
            this.spnYearModel.setMinimum((Integer)tmp.get(0));
            this.spnYear.setToolTipText(this.spnYearModel.getMinimum().toString() + "-" + this.spnYearModel.getMaximum().toString());
        } else {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResource", (String)"FiscalPeriodIsNotExist"));
            SysUtil.abort();
        }
        this.spnPeriodModel.setMinimum(new Integer(1));
        PeriodInfo periodInfo = (PeriodInfo)result.get("CurrentFiscal");
        Integer currentYear = new Integer(periodInfo.getPeriodYear());
        Integer currentPeriod = new Integer(periodInfo.getPeriodNumber());
        if (!tmp.contains(currentYear)) {
            currentYear = (Integer)tmp.get(0);
            currentPeriod = new Integer(1);
        }
        this.spnYear.setValue((Object)currentYear, false);
        this.spnPeriod.setValue((Object)currentPeriod, false);
        this.currentDate = RPTDateUtil.getPeriodLastDate((int)currentYear, (int)currentPeriod, (RptPeriodTypeEnum)RptPeriodTypeEnum.MONTHLY);
        this.cbxPeriodType.setSelectedItem((Object)RptPeriodTypeEnum.MONTHLY);
        this.btnLocation.setIcon(EASResource.getIcon((String)"imgTbtn_speedgoto"));
        this.initTxtLocation();
        CslRptUIUtil.addTableSelectedListener((KDTable)this.kDTable1, (String)"select");
        this.initTableEvent();
    }

    private void initTableEvent() {
        this.kDTable1.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 17) {
                    BatchAddReportUI.this.isCtrlPress = true;
                } else if (e.getKeyCode() == 127) {
                    SysUtil.abort();
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (BatchAddReportUI.this.isCtrlPress) {
                    BatchAddReportUI.this.isCtrlPress = false;
                }
            }
        });
    }

    private void initTxtLocation() {
        String defaultStr = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptCommonMsg", (String)"84_quickQueryInput");
        this.txtLocation.setText(defaultStr);
        CslRptUIUtil.QuickQueryHandler quickQueryHandler = new CslRptUIUtil.QuickQueryHandler(this.txtLocation);
        this.txtLocation.addFocusListener((FocusListener)quickQueryHandler);
    }

    private void setBtnEnabl(KDWorkButton b) {
        b.setEnabled(true);
        b.setVisible(true);
    }

    private void loadEnumToCbx(Iterator it, KDComboBox cb) {
        int i = 0;
        while (it.hasNext()) {
            cb.insertItemAt(it.next(), i);
            ++i;
        }
        cb.setSelectedIndex(0);
    }

    public void loadAllTemplate() throws BOSException, EASBizException {
        TemplateInfo template;
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(new FilterInfo());
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("number"));
        view.getSelector().add(new SelectorItemInfo("name"));
        view.getSelector().add(new SelectorItemInfo("templateType"));
        view.getSelector().add(new SelectorItemInfo("versionNumber"));
        view.getSelector().add(new SelectorItemInfo("periodType"));
        view.getSelector().add(new SelectorItemInfo("group"));
        String permissionContidion = PermissionFactory.getRemoteInstance().getQueryPermissionSQL((IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId()), (IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentFIUnit().getId()), "rpt_template_view");
        if (!StringUtils.isEmpty((String)permissionContidion)) {
            permissionContidion = " in ( " + permissionContidion + ")";
        }
        String companyID = SysContext.getSysContext().getCurrentFIUnit().getId().toString();
        ArrayList<RptTmpTypeEnum> templateType = new ArrayList<RptTmpTypeEnum>();
        templateType.add(RptTmpTypeEnum.COMMONREPORT);
        EntityViewInfo commonView = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isBatchReport", (Object)"true"));
        commonView.setFilter(filter);
        List ids = TemplateFactory.getRemoteInstance().getTemplateIds(null, templateType, true, true, companyID, commonView, permissionContidion);
        TemplateCollection templates = null;
        if (ids.size() > 0) {
            view.getFilter().getFilterItems().add(new FilterItemInfo("id", new HashSet(ids), CompareType.INCLUDE));
            templates = TemplateFactory.getRemoteInstance().getTemplateCollection(view);
        }
        if (templates != null && templates.size() > 0) {
            Iterator it = templates.iterator();
            while (it.hasNext()) {
                TemplateInfo template2 = (TemplateInfo)it.next();
                this.allTemplates.add(template2);
            }
        }
        TemplateCollection templateCollection = TemplateFactory.getRemoteInstance().getPublicTemplateCollection(Arrays.asList(new Integer(1)), false, false, null);
        int count = templateCollection.size();
        for (int i = 0; i < count; ++i) {
            template = templateCollection.get(i);
            this.allTemplates.add(template);
        }
        templates = TemplateFactory.getRemoteInstance().getTreeDispenseData2(SysContext.getSysContext().getCurrentFIUnit().getId().toString(), true, true, false, null, null);
        if (templates != null && templates.size() > 0) {
            Iterator it = templates.iterator();
            while (it.hasNext()) {
                template = (TemplateInfo)it.next();
                this.allTemplates.add(template);
            }
        }
    }

    private void filterTemplate() {
        this.filterTemplates.clear();
        RptPeriodTypeEnum rptPeriodTypeE = (RptPeriodTypeEnum)this.cbxPeriodType.getSelectedItem();
        for (int i = 0; i < this.allTemplates.size(); ++i) {
            TemplateInfo template = (TemplateInfo)this.allTemplates.get(i);
            if (rptPeriodTypeE != null && !rptPeriodTypeE.equals((Object)template.getPeriodType())) continue;
            this.filterTemplates.add(template);
        }
        this.loadFilterTemplate("number");
    }

    private void loadFilterTemplate(String tempFilterString) {
        if (tempFilterString != this.templateView[1] && tempFilterString != this.templateView[2] && tempFilterString != this.templateView[3]) {
            return;
        }
        this.kDTable1.removeRows();
        for (int i = 1; i < this.kDTable1.getColumnCount(); ++i) {
            IColumn column = this.kDTable1.getColumn(i);
            if (column.getKey().equalsIgnoreCase("select")) continue;
            column.getStyleAttributes().setLocked(true);
        }
        TemplateInfo template = null;
        IRow row = null;
        List list = this.sort(tempFilterString, this.filterTemplates);
        this.tc = tempFilterString.equals(this.lasttempSort) ? ++this.tc : 1;
        if (this.tc % 2 != 0) {
            for (int i = 0; i < list.size(); ++i) {
                template = (TemplateInfo)list.get(i);
                if (template.getTemplateType().equals((Object)RptTmpTypeEnum.GROUPCOMMREPORT)) {
                    template.setTemplateType(RptTmpTypeEnum.GROUPREPORT);
                }
                row = this.kDTable1.addRow();
                row.setUserObject((Object)template);
                row.getCell("select").setEditor((ICellEditor)new EditorFactory.BooleanEditor());
                row.getCell("select").setValue((Object)new Boolean(false));
                row.getCell(1).setValue((Object)template.getTemplateType());
                row.getCell(2).setValue((Object)template.getNumber());
                row.getCell(3).setValue((Object)template.getName());
                row.getCell(4).setValue((Object)template.getVersionNumber());
                row.getCell(5).setValue((Object)template.getDescription());
            }
        } else {
            for (int i = list.size() - 1; i >= 0; --i) {
                template = (TemplateInfo)list.get(i);
                if (template.getTemplateType().equals((Object)RptTmpTypeEnum.GROUPCOMMREPORT)) {
                    template.setTemplateType(RptTmpTypeEnum.GROUPREPORT);
                }
                row = this.kDTable1.addRow();
                row.setUserObject((Object)template);
                row.getCell("select").setEditor((ICellEditor)new EditorFactory.BooleanEditor());
                row.getCell("select").setValue((Object)new Boolean(false));
                row.getCell(1).setValue((Object)template.getTemplateType());
                row.getCell(2).setValue((Object)template.getNumber());
                row.getCell(3).setValue((Object)template.getName());
                row.getCell(4).setValue((Object)template.getVersionNumber());
                row.getCell(5).setValue((Object)template.getDescription());
            }
        }
        this.lasttempSort = tempFilterString;
    }

    private void updateYearAndPeriod(Date date) {
        RptPeriodTypeEnum RptPeriodTypeE = (RptPeriodTypeEnum)this.cbxPeriodType.getSelectedItem();
        int[] yp = null;
        if (date != null) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            int year = cal.get(1);
            int month = cal.get(2) + 1;
            int day = cal.get(5);
            yp = new int[]{year, RPTDateUtil.getPeriod((int)year, (int)month, (int)day, (RptPeriodTypeEnum)RptPeriodTypeE)};
        }
        if (yp != null) {
            this.spnYear.setValue((Object)new Integer((int)yp[0]), false);
            this.spnPeriod.setValue((Object)new Integer((int)yp[1]), false);
        }
        this.updateDate();
    }

    private void updateDate() {
        RptPeriodTypeEnum RptPeriodTypeE = (RptPeriodTypeEnum)this.cbxPeriodType.getSelectedItem();
        this.date.setValue((Object)RPTDateUtil.getPeriodLastDate((int)((Integer)this.spnYear.getValue()), (int)((Integer)this.spnPeriod.getValue()), (RptPeriodTypeEnum)RptPeriodTypeE), false);
    }

    private void setIsEnable() {
        RptPeriodTypeEnum RptPeriodTypeE = (RptPeriodTypeEnum)this.cbxPeriodType.getSelectedItem();
        if (RptPeriodTypeE == RptPeriodTypeEnum.DAILY || RptPeriodTypeE == RptPeriodTypeEnum.WEEKLY) {
            this.spnYear.setEnabled(false);
            this.spnPeriod.setEnabled(false);
            this.date.setEnabled(true);
            Date localDate = new Date();
            this.date.setValue((Object)localDate);
            this.updateYearAndPeriod(localDate);
        } else {
            this.spnYear.setEnabled(true);
            this.spnPeriod.setEnabled(true);
            this.date.setEnabled(false);
            this.updateYearAndPeriod(this.currentDate);
        }
    }

    private void updatePeriodByYear() {
        RptPeriodTypeEnum RptPeriodTypeE = (RptPeriodTypeEnum)this.cbxPeriodType.getSelectedItem();
        if (RptPeriodTypeE == RptPeriodTypeEnum.DAILY || RptPeriodTypeE == RptPeriodTypeEnum.WEEKLY) {
            return;
        }
        if (RptPeriodTypeE == RptPeriodTypeEnum.MONTHLY && this.yearMap.size() > 0) {
            int periods = this.getPeriods((Vector)this.yearMap.get(this.spnYear.getValue()));
            this.spnPeriodModel.setMaximum(new Integer(periods));
        } else if (RptPeriodTypeE == RptPeriodTypeEnum.QUARTERLY) {
            this.spnPeriodModel.setMaximum(new Integer(4));
        } else if (RptPeriodTypeE == RptPeriodTypeEnum.SEMIYEARLY) {
            this.spnPeriodModel.setMaximum(new Integer(2));
        } else if (RptPeriodTypeE == RptPeriodTypeEnum.YEARLY) {
            this.spnPeriodModel.setMaximum(new Integer(1));
        }
        this.spnPeriod.setToolTipText(this.spnPeriodModel.getMinimum().toString() + "-" + this.spnPeriodModel.getMaximum().toString());
    }

    private int getPeriods(Vector addPeriods) {
        Integer tmp = Integer.valueOf("13");
        if (this.isSupport13Period && addPeriods.size() < 13 && !addPeriods.contains(tmp)) {
            addPeriods.add(tmp);
        }
        return addPeriods.size();
    }

    @Override
    public void actionSA_actionPerformed(ActionEvent e) throws Exception {
        CslRptUtil.selectTable((KDTable)this.kDTable1, (String)"select", (Boolean)Boolean.TRUE);
    }

    @Override
    public void actionCA_actionPerformed(ActionEvent e) throws Exception {
        CslRptUtil.selectTable((KDTable)this.kDTable1, (String)"select", (Boolean)Boolean.FALSE);
    }

    @Override
    public void actionOK_actionPerformed(ActionEvent e) throws Exception {
        super.actionOK_actionPerformed(e);
        Date date = (Date)this.date.getValue();
        if (date == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"89_BatchNewReportUI"));
            return;
        }
        HashSet<String> templateIdSet = new HashSet<String>();
        for (int i = 0; i < this.kDTable1.getExpandedRowCount(); ++i) {
            IRow row = this.kDTable1.getRow(i);
            if (!Boolean.TRUE.equals(row.getCell("select").getValue())) continue;
            templateIdSet.add(((TemplateInfo)row.getUserObject()).getId().toString());
        }
        if (templateIdSet.size() > 0) {
            int[] yearAndPeriod = new int[]{(Integer)this.spnYear.getValue(), (Integer)this.spnPeriod.getValue()};
            String sa = ReportFactory.getRemoteInstance().batchAddNewReport(templateIdSet, RptUtilForClient.getCurrentCompany().getId().toString(), ((CurrencyInfo)this.cbxCurrency.getSelectedItem()).getId().toString(), (Object[])this.getUIContext().get("rptpath"), yearAndPeriod);
            if (sa.length() > 0) {
                UIContext uiCtx = new UIContext((Object)this);
                uiCtx.put((Object)"Title", (Object)RptUtil.getResourceSince51("RESULT"));
                uiCtx.put((Object)"ShowOpen", (Object)Boolean.FALSE);
                SimpleNotePad.showMessageByModel((UIContext)uiCtx, (String)sa.toString());
            }
        } else {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            return;
        }
        this.disposeUIWindow();
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancel_actionPerformed(e);
        this.destroyWindow();
    }

    public boolean destroyWindow() {
        return super.destroyWindow();
    }

    private List sort(String sorts, List a) {
        ArrayList temp;
        String key;
        int i;
        ArrayList retList = new ArrayList();
        if (sorts == null || sorts.trim().length() == 0 || a.size() <= 1) {
            return a;
        }
        HashMap<String, ArrayList> map = new HashMap<String, ArrayList>();
        ArrayList<String> list = new ArrayList<String>();
        for (i = 0; i < a.size(); ++i) {
            key = this.getKey(a.get(i), sorts);
            temp = (ArrayList)map.get(key);
            if (temp == null) {
                temp = new ArrayList();
                map.put(key, temp);
                list.add(key);
            }
            temp.add(a.get(i));
        }
        Collections.sort(list, new cpt());
        for (i = 0; i < list.size(); ++i) {
            key = list.get(i);
            temp = (ArrayList)map.get(key);
            if (temp == null) continue;
            retList.addAll(temp);
        }
        return retList;
    }

    private boolean needSort(String sorts, ArrayList a) {
        ArrayList<String> retList = new ArrayList<String>();
        if (sorts == null || sorts.trim().length() == 0 || a.size() <= 1) {
            return true;
        }
        for (int i = 0; i < a.size(); ++i) {
            String key = this.getKey(a.get(i), sorts);
            if (retList.size() == 0) {
                retList.add(key);
                continue;
            }
            if (!retList.contains(key)) continue;
            retList.add(key);
        }
        return retList.size() != a.size();
    }

    private String getKey(Object o, String qstr) {
        if (o == null) {
            return "";
        }
        StringTokenizer tk = new StringTokenizer(qstr, ".");
        ArrayList<String> list = new ArrayList<String>();
        while (tk.hasMoreTokens()) {
            list.add(tk.nextToken());
        }
        Object temp = o;
        for (int i = 0; i < list.size(); ++i) {
            PropertyContainer p = (PropertyContainer)temp;
            if ((temp = p.get(list.get(i).toString())) != null) continue;
            return "";
        }
        return temp.toString().toLowerCase();
    }

    @Override
    public void actionLocation_actionPerformed(ActionEvent e) throws Exception {
        super.actionLocation_actionPerformed(e);
        String defaultStr = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptCommonMsg", (String)"84_quickQueryInput");
        String search = this.txtLocation.getText();
        if (!StringUtils.isEmpty((String)search) && !search.equals(defaultStr)) {
            int colIndex1 = this.kDTable1.getColumnIndex("number");
            int colIndex2 = this.kDTable1.getColumnIndex("name");
            CslRptUIUtil.tableMainLocate((KDTable)this.kDTable1, (String)search, (int[])new int[]{colIndex1, colIndex2});
        }
    }

    @Override
    public void actionDisplayAll_actionPerformed(ActionEvent e) throws Exception {
        CslRptUIUtil.tableSelectDisplay((KDTable)this.kDTable1, (String)"select", (KDWorkButton)this.btnDisplay);
    }

    class cpt
    implements Comparator {
        cpt() {
        }

        public int compare(Object arg0, Object arg1) {
            if (arg0 == null && arg1 == null) {
                return 0;
            }
            if (arg0 == null && arg1 != null) {
                return -1;
            }
            if (arg0 != null && arg1 == null) {
                return 1;
            }
            String s1 = arg0.toString();
            String s2 = arg1.toString();
            if (s1.length() == 0 && s1.length() == 0) {
                return 0;
            }
            if (s1.length() > 0 && s1.length() == 0) {
                return 1;
            }
            if (s1.length() == 0 && s1.length() > 0) {
                return -1;
            }
            for (int i = 0; i < s1.length() && i < s2.length(); ++i) {
                int dt = s1.charAt(i) - s2.charAt(i);
                if (dt < 0) {
                    return -1;
                }
                if (dt <= 0) continue;
                return 1;
            }
            if (s1.length() == s2.length()) {
                return 0;
            }
            if (s1.length() > s1.length()) {
                return 1;
            }
            return -1;
        }
    }
}

