/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitCommonFactory;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.cslrpt.FiscalPeriodHelper;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.gr.cslrpt.client.SimpleNotePad;
import com.kingdee.eas.fi.rpt.ReportFactory;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.RptTmpTypeEnum;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.fi.rpt.client.AbstractBatchNewReportUI;
import com.kingdee.eas.fi.rpt.client.BatchTemplateSelectUI;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.eas.fi.rpt.util.RptUtilForClient;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import org.apache.log4j.Logger;

public class BatchNewReportUI
extends AbstractBatchNewReportUI {
    private static final Logger logger = CoreUIObject.getLogger(BatchNewReportUI.class);
    private CompanyOrgUnitInfo rootOrg = null;
    private HashMap existCodingRuleMap = new HashMap();
    private List allTemplate = new ArrayList();
    boolean b = true;
    ArrayList selectTemplate = new ArrayList();
    boolean isMergeByFiscalPeriod = false;
    boolean isSupport13Period = false;

    public BatchNewReportUI() throws Exception {
        this.rootOrg = OrgUnitCommonFactory.getRemoteInstance().getRootCompany();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.kDTable1.checkParsed();
        this.setUITitle(EASResource.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"88_BatchNewReportUI"));
        this.isMergeByFiscalPeriod = (Boolean)this.getUIContext().get("isMergeByFiscalPeriod");
        this.isSupport13Period = (Boolean)this.getUIContext().get("isSupport13Period");
        this.spnYear.setEditable(false);
        this.spnYear.setEnabled(false);
        this.spnPeriod.setEditable(false);
        this.spnPeriod.setEnabled(false);
        for (int i = 0; i < this.kDTable1.getColumnCount(); ++i) {
            this.kDTable1.getColumn(i).getStyleAttributes().setLocked(true);
        }
        KDComboBox cbx = (KDComboBox)this.getUIContext().get("periodType");
        this.cbxPeriodType.setModel(cbx.getModel());
        this.cbxPeriodType.setSelectedIndex(cbx.getSelectedIndex());
        cbx = (KDComboBox)this.getUIContext().get("currency");
        for (int i = 0; i < cbx.getItemCount(); ++i) {
            this.cbxCurrency.insertItemAt(cbx.getItemAt(i), i);
        }
        this.cbxCurrency.setSelectedIndex(cbx.getSelectedIndex());
        this.cbxCurrency.removeItem(null);
        if (cbx.getSelectedItem() == null) {
            this.cbxCurrency.setSelectedIndex(0);
        }
        this.date.setValue((Object)((Date)this.getUIContext().get("date")));
        this.updateYearAndPeriod();
        this.cbxPeriodType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                BatchNewReportUI.this.updateYearAndPeriod();
                BatchNewReportUI.this.filterTemplate();
            }
        });
        this.date.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                BatchNewReportUI.this.updateYearAndPeriod();
            }
        });
        this.allTemplate.addAll((ArrayList)this.getUIContext().get("select"));
        this.filterTemplate();
        this.kDTable1.getSelectManager().setSelectMode(10);
        this.btnCA.setEnabled(true);
        this.btnSA.setEnabled(true);
        this.btnCancel.setEnabled(true);
        this.btnOK.setEnabled(this.selectTemplate.size() > 0);
        this.btnCA.setIcon(EASResource.getIcon((String)"imgTbtn_upenumdel"));
        this.btnSA.setIcon(EASResource.getIcon((String)"imgTbtn_upenumnew"));
        CurrencyInfo natureCurrency = RptUtilForClient.getCurrenctCurrencyFromDatabase();
        if (natureCurrency != null) {
            for (int i = 0; i < this.cbxCurrency.getItemCount(); ++i) {
                if (!((CurrencyInfo)this.cbxCurrency.getItemAt(i)).getId().toString().equals(natureCurrency.getId().toString())) continue;
                this.cbxCurrency.setSelectedIndex(i);
                break;
            }
        }
        if (this.isMergeByFiscalPeriod) {
            FiscalPeriodHelper.refreshAndAddListeners((boolean)this.isMergeByFiscalPeriod, (KDComboBox)this.cbxPeriodType, (KDSpinner)this.spnYear, (KDSpinner)this.spnPeriod, (KDDatePicker)this.date, (PeriodCollection)((PeriodCollection)this.getUIContext().get("periodCollection")));
            this.spnYear.setValue(this.getUIContext().get("year"));
            this.spnPeriod.setValue(this.getUIContext().get("period"));
        }
    }

    private void loadTemplate(ArrayList templates) {
        this.selectTemplate = templates;
        this.kDTable1.removeRows();
        if (templates != null && templates.size() > 0) {
            for (TemplateInfo template : templates) {
                if (template.getTemplateType().equals((Object)RptTmpTypeEnum.GROUPCOMMREPORT)) {
                    template.setTemplateType(RptTmpTypeEnum.GROUPREPORT);
                }
                IRow row = this.kDTable1.addRow();
                row.setUserObject((Object)template);
                row.getCell(0).setValue((Object)template.getTemplateType());
                row.getCell(1).setValue((Object)template.getNumber());
                row.getCell(2).setValue((Object)template.getName());
                row.getCell(3).setValue((Object)template.getVersionNumber());
            }
        }
        this.btnOK.setEnabled(this.selectTemplate.size() > 0);
    }

    private ArrayList getCanAddTemplates() {
        ArrayList<TemplateInfo> list = new ArrayList<TemplateInfo>();
        ArrayList listall = (ArrayList)this.getUIContext().get("all");
        for (int i = 0; i < listall.size(); ++i) {
            TemplateInfo template = (TemplateInfo)listall.get(i);
            RptPeriodTypeEnum RptPeriodTypeE = (RptPeriodTypeEnum)this.cbxPeriodType.getSelectedItem();
            if (RptPeriodTypeE != null) {
                if (!RptPeriodTypeE.equals((Object)template.getPeriodType())) continue;
                list.add(template);
                continue;
            }
            list.add(template);
        }
        return list;
    }

    private void filterTemplate() {
        ArrayList<TemplateInfo> list = new ArrayList<TemplateInfo>();
        for (int i = 0; i < this.allTemplate.size(); ++i) {
            TemplateInfo template = (TemplateInfo)this.allTemplate.get(i);
            RptPeriodTypeEnum RptPeriodTypeE = (RptPeriodTypeEnum)this.cbxPeriodType.getSelectedItem();
            if (RptPeriodTypeE != null) {
                if (!RptPeriodTypeE.equals((Object)template.getPeriodType())) continue;
                list.add(template);
                continue;
            }
            list.add(template);
        }
        this.loadTemplate(list);
    }

    @Override
    public void actionSA_actionPerformed(ActionEvent e) throws Exception {
        super.actionSA_actionPerformed(e);
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", null);
        uiContext.put((Object)"templates", (Object)this.getCanAddTemplates());
        HashMap map = new HashMap();
        uiContext.put((Object)"result", map);
        IUIWindow w = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BatchTemplateSelectUI.class.getName(), (Map)uiContext);
        w.show();
        if ("ok".equals(map.get("btn"))) {
            ArrayList list = (ArrayList)map.get("select");
            for (int i = 0; i < list.size(); ++i) {
                if (!this.selectTemplate.contains(list.get(i))) {
                    this.selectTemplate.add(list.get(i));
                }
                if (this.allTemplate.contains(list.get(i))) continue;
                this.allTemplate.add(list.get(i));
            }
        }
        this.loadTemplate(this.selectTemplate);
    }

    @Override
    public void actionCA_actionPerformed(ActionEvent e) throws Exception {
        int i;
        super.actionCA_actionPerformed(e);
        ArrayList<Object> list = new ArrayList<Object>();
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.kDTable1);
        for (i = 0; i < selectRows.length; ++i) {
            list.add(this.kDTable1.getRow(selectRows[i]).getUserObject());
        }
        for (i = 0; i < list.size(); ++i) {
            this.selectTemplate.remove(list.get(i));
            this.allTemplate.remove(list.get(i));
        }
        this.loadTemplate(this.selectTemplate);
    }

    @Override
    public void actionOK_actionPerformed(ActionEvent e) throws Exception {
        super.actionOK_actionPerformed(e);
        Date date1 = (Date)this.date.getValue();
        if (date1 == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"89_BatchNewReportUI"));
            return;
        }
        HashSet<String> templateIdSet = new HashSet<String>();
        for (int i = 0; i < this.selectTemplate.size(); ++i) {
            templateIdSet.add(((TemplateInfo)this.selectTemplate.get(i)).getId().toString());
        }
        int[] yearAndPeriod = new int[]{(Integer)this.spnYear.getValue(), (Integer)this.spnPeriod.getValue()};
        String sa = ReportFactory.getRemoteInstance().batchAddNewReport(templateIdSet, RptUtilForClient.getCurrentCompany().getId().toString(), ((CurrencyInfo)this.cbxCurrency.getSelectedItem()).getId().toString(), (Object[])this.getUIContext().get("rptpath"), yearAndPeriod);
        if (sa.length() > 0) {
            UIContext uiCtx = new UIContext((Object)this);
            uiCtx.put((Object)"Title", (Object)RptUtil.getResourceSince51("RESULT"));
            uiCtx.put((Object)"ShowOpen", (Object)Boolean.FALSE);
            SimpleNotePad.showMessageByModel((UIContext)uiCtx, (String)sa.toString());
        }
        this.disposeUIWindow();
    }

    public ICodingRuleManager getICodingRuleManager() throws Exception {
        return CodingRuleManagerFactory.getRemoteInstance();
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancel_actionPerformed(e);
        this.disposeUIWindow();
    }

    private int[] getYearAndPeriod() {
        RptPeriodTypeEnum RptPeriodTypeE = (RptPeriodTypeEnum)this.cbxPeriodType.getSelectedItem();
        if (RptPeriodTypeE != null) {
            Date date1 = (Date)this.date.getValue();
            if (date1 != null) {
                Calendar cal = Calendar.getInstance();
                cal.setTime(date1);
                int year = cal.get(1);
                int month = cal.get(2) + 1;
                int day = cal.get(5);
                int[] yp = new int[]{year, RPTDateUtil.getPeriod((int)year, (int)month, (int)day, (RptPeriodTypeEnum)RptPeriodTypeE)};
                return yp;
            }
            return null;
        }
        return null;
    }

    private void updateYearAndPeriod() {
        RptPeriodTypeEnum periodTypeEnum;
        if (this.isMergeByFiscalPeriod && FiscalPeriodHelper.isMergeByFiscalPeriod((boolean)this.isMergeByFiscalPeriod, (RptPeriodTypeEnum)(periodTypeEnum = (RptPeriodTypeEnum)this.cbxPeriodType.getSelectedItem()))) {
            return;
        }
        if (this.b) {
            this.b = false;
            int[] yp = this.getYearAndPeriod();
            if (yp != null) {
                this.spnYear.setValue((Object)new Integer(yp[0]));
                this.spnPeriod.setValue((Object)new Integer(yp[1]));
                RptPeriodTypeEnum RptPeriodTypeE = (RptPeriodTypeEnum)this.cbxPeriodType.getSelectedItem();
                if (RptPeriodTypeE != null) {
                    this.date.setValue((Object)RPTDateUtil.getPeriodLastDate((int)yp[0], (int)yp[1], (RptPeriodTypeEnum)RptPeriodTypeE));
                }
            }
            this.b = true;
        }
        if (this.isSupport13Period) {
            periodTypeEnum = (RptPeriodTypeEnum)this.cbxPeriodType.getSelectedItem();
            Integer period = (Integer)this.spnPeriod.getValue();
            if (periodTypeEnum.equals((Object)RptPeriodTypeEnum.MONTHLY) && period == 12) {
                this.setPeriodSpinner();
            } else {
                this.spnPeriod.setEnabled(false);
            }
        } else {
            this.spnPeriod.setEnabled(false);
        }
    }

    private void setPeriodSpinner() {
        this.spnPeriod.setEnabled(true);
        Integer period = (Integer)this.spnPeriod.getValue();
        this.spnPeriod.setModel((SpinnerModel)this.getSpinnerNumberModel(period, period, 13, 1));
    }

    private SpinnerNumberModel getSpinnerNumberModel(int initValue, int minimum, int maximum, int stepSize) {
        return new SpinnerNumberModel(initValue, minimum, maximum, stepSize);
    }
}

