/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.style.Pattern;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.basedata.assistant.CashFlowItemFactory;
import com.kingdee.eas.basedata.assistant.CashFlowItemInfo;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupFactory;
import com.kingdee.eas.basedata.master.cssp.ICSSPGroup;
import com.kingdee.eas.basedata.master.material.MaterialGroupFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.dynamic.util.DynamicTemplateUtility;
import com.kingdee.eas.fi.newrpt.RptNewUIUtil;
import com.kingdee.eas.fi.rpt.ReportCaclFactory;
import com.kingdee.eas.fi.rpt.TableToolkit;
import com.kingdee.eas.fi.rpt.client.AbstractCashProjectSelectorUI;
import com.kingdee.eas.fi.rpt.client.AsstGroupChooserPrompt;
import com.kingdee.eas.fi.rpt.client.FormulaWizardUI;
import com.kingdee.eas.fi.rpt.util.AcctountAsstItemParser;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.TreeBaseInfo;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class CashProjectSelectorUI
extends AbstractCashProjectSelectorUI {
    private static final Logger logger = CoreUIObject.getLogger(CashProjectSelectorUI.class);
    public static final Color LOCKCOLOR = new Color(228, 228, 228);
    private CompanyOrgUnitInfo company = null;
    private FormulaWizardUI formulaWizardUI = null;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void setCompany(CompanyOrgUnitInfo company) {
        this.company = company;
    }

    public CompanyOrgUnitInfo getCompany() {
        if (this.company == null) {
            try {
                FormulaWizardUI wizardUI = this.getFormulaUI();
                String orgUnitNum = this.getFormulaUI().getParam("fiOrgUnit");
                if (wizardUI == null || OrgType.Company.equals((Object)wizardUI.getRptOrgType())) {
                    CompanyOrgUnitCollection companyOrgUnitCollection = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitCollection("where number = '" + orgUnitNum + "' ");
                    if (companyOrgUnitCollection != null && companyOrgUnitCollection.size() > 0) {
                        this.company = companyOrgUnitCollection.get(0);
                    }
                } else {
                    this.company = RptNewUIUtil.getDelegateCompanyByNumber(null, (OrgType)wizardUI.getRptOrgType(), (String)orgUnitNum, null);
                }
            }
            catch (BOSException e) {
                logger.error((Object)"", (Throwable)e);
                this.company = null;
            }
            catch (EASBizException e) {
                logger.error((Object)"", (Throwable)e);
                this.company = null;
            }
            if (this.company == null) {
                this.company = SysContext.getSysContext().getCurrentFIUnit();
            }
        }
        return this.company;
    }

    public void onLoad() throws Exception {
        FilterInfo ft;
        super.onLoad();
        this.btnCancel.setEnabled(true);
        this.getCompany();
        this.kDTable.checkParsed();
        this.pmtProject.setQueryInfo("com.kingdee.eas.fi.gl.app.VoucherCashflowItemQuery");
        this.pmtProject.setCommitFormat("$number$");
        this.pmtProject.setEditFormat("$number$");
        this.pmtProject.setDisplayFormat("$number$");
        EntityViewInfo view = new EntityViewInfo();
        this.pmtProject.setEntityViewInfo(view);
        view.setFilter(new FilterInfo());
        view.getFilter().getFilterItems().add(new FilterItemInfo("isFreeze", (Object)new Integer(0)));
        SorterItemInfo sor = new SorterItemInfo("longNumber");
        sor.setSortType(SortType.ASCEND);
        view.getSorter().add(sor);
        this.cbFilter.setEnabled(false);
        this.pmtProject.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                if (CashProjectSelectorUI.this.pmtProject.getValue() instanceof CashFlowItemInfo) {
                    CashFlowItemInfo cashFlowItemInfo = (CashFlowItemInfo)CashProjectSelectorUI.this.pmtProject.getValue();
                }
                CashProjectSelectorUI.this.cbFilter.setSelected(false);
                CashProjectSelectorUI.this.updateBtnState();
                CashProjectSelectorUI.this.cbFilter.setEnabled(true);
            }
        });
        EntityViewInfo vi = this.pmtProject.getEntityViewInfo();
        if (vi == null) {
            vi = new EntityViewInfo();
            this.pmtProject.setEntityViewInfo(vi);
        }
        if ((ft = vi.getFilter()) == null) {
            ft = new FilterInfo();
            vi.setFilter(ft);
        }
        FilterItemCollection ic = ft.getFilterItems();
        ic.add(new FilterItemInfo("isFreeze", (Object)Boolean.FALSE));
        this.cbFilter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                CashProjectSelectorUI.this.loadItems(null);
            }
        });
        this.updateBtnState();
        String projectcode = (String)this.getUIContext().get("cashFlowItem");
        if (projectcode == null) {
            return;
        }
        try {
            AcctountAsstItemParser.AccountAsstItem accountAsstItem = AcctountAsstItemParser.parse(projectcode);
            EntityViewInfo ev = new EntityViewInfo();
            ev.getSelector().add(new SelectorItemInfo("*"));
            ev.setFilter(new FilterInfo());
            ev.getFilter().getFilterItems().add(new FilterItemInfo("number", (Object)accountAsstItem.startNumber));
            CoreBaseCollection c = CashFlowItemFactory.getRemoteInstance().getCollection(ev);
            if (c == null || c.size() == 0) {
                return;
            }
            CashFlowItemInfo info = (CashFlowItemInfo)c.get(0);
            this.pmtProject.setValue((Object)info);
            AcctountAsstItemParser.AsstItem[] asstItems = accountAsstItem.asstItems;
            if (asstItems == null || asstItems.length == 0) {
                return;
            }
            this.cbFilter.setSelected(true);
            this.loadItems(accountAsstItem);
        }
        catch (Throwable exc) {
            this.handUIException(exc);
        }
    }

    void loadItems(AcctountAsstItemParser.AccountAsstItem accountAsstItem) {
        this.kDTable.removeRows();
        if (!this.cbFilter.isSelected()) {
            return;
        }
        if (!(this.pmtProject.getValue() instanceof CashFlowItemInfo)) {
            return;
        }
        CashFlowItemInfo info = (CashFlowItemInfo)this.pmtProject.getValue();
        boolean isCompanySeparate = false;
        try {
            isCompanySeparate = RptUtil.isTrue(ParamManager.getParamValue(null, (IObjectPK)new ObjectUuidPK(this.company.getId()), (String)"fi_rp_004"));
        }
        catch (EASBizException e1) {
            logger.error((Object)"ParamManager.getParamValue", (Throwable)e1);
        }
        catch (BOSException e1) {
            logger.error((Object)"ParamManager.getParamValue", (Throwable)e1);
        }
        if (info != null) {
            try {
                ArrayList list = ReportCaclFactory.getRemoteInstance().getAsstItems(info.getNumber());
                if (list != null) {
                    boolean needGroup = false;
                    block6: for (int i = 0; i < list.size(); ++i) {
                        Object groupTable;
                        FilterItemCollection fic;
                        FilterInfo filter;
                        HashMap item = (HashMap)list.get(i);
                        IRow row = this.kDTable.addRow();
                        row.setUserObject((Object)item);
                        row.getCell("selected").setValue((Object)Boolean.TRUE);
                        String asstType = (String)item.get("name");
                        row.getCell("type").setValue((Object)asstType);
                        String tableName = item.get("tablename").toString();
                        KDBizPromptBox bizPromptBox = new KDBizPromptBox();
                        bizPromptBox.setEditable(true);
                        bizPromptBox.setCommitFormat("$number$");
                        bizPromptBox.setEditFormat("$number$");
                        bizPromptBox.setDisplayFormat("$number$ - $name$");
                        if (tableName.equalsIgnoreCase("T_BD_CashFlowItem")) {
                            bizPromptBox.setQueryInfo("com.kingdee.eas.fi.gl.app.VoucherCashflowItemQuery");
                        } else if (tableName.equalsIgnoreCase("T_BD_Customer")) {
                            bizPromptBox.setQueryInfo("com.kingdee.eas.fi.rpt.app.F7CustomerQuery");
                        } else if (tableName.equalsIgnoreCase("T_BD_Supplier")) {
                            bizPromptBox.setQueryInfo("com.kingdee.eas.fi.rpt.app.F7SupplierQuery");
                        } else if (tableName.equalsIgnoreCase("T_BD_Material")) {
                            bizPromptBox.setQueryInfo("com.kingdee.eas.fi.rpt.app.F7MaterialQuery");
                        } else {
                            bizPromptBox.setQueryInfo((String)item.get("queryname"));
                        }
                        EntityViewInfo view = new EntityViewInfo();
                        if (item.get("isforcompany").toString().equalsIgnoreCase("1")) {
                            filter = new FilterInfo();
                            view.setFilter(filter);
                            bizPromptBox.setEntityViewInfo(view);
                            bizPromptBox.setHasCUDefaultFilter(false);
                        }
                        if (tableName.equalsIgnoreCase("T_BD_GeneralAsstActType")) {
                            String GeneralAsstActTypeGroup = item.get("asstGroupID").toString();
                            FilterInfo filter2 = DynamicTemplateUtility.getFilterForGeneral(null, (String)GeneralAsstActTypeGroup, (CompanyOrgUnitInfo)this.getCompany());
                            view.setFilter(filter2);
                            bizPromptBox.setEntityViewInfo(view);
                            bizPromptBox.setHasCUDefaultFilter(false);
                            bizPromptBox.setEditFormat("$number$");
                            bizPromptBox.setDisplayFormat("$number$ - $name$");
                        } else if ("T_Org_Admin".equalsIgnoreCase(tableName) || "T_BD_Person".equalsIgnoreCase(tableName) || "T_ORG_CostCenter".equalsIgnoreCase(tableName) || "T_BD_AccountBanks".equalsIgnoreCase(tableName)) {
                            filter = new FilterInfo();
                            if (isCompanySeparate) {
                                view.getSorter().clear();
                                view.setFilter(filter);
                                fic = filter.getFilterItems();
                                if ("T_ORG_CostCenter".equalsIgnoreCase(tableName)) {
                                    boolean isBizUnit = this.company.isIsBizUnit();
                                    String tempID = null;
                                    String longNumber = null;
                                    if (isBizUnit) {
                                        tempID = this.company.getId().toString();
                                        longNumber = this.company.getLongNumber();
                                    } else {
                                        tempID = this.company.getCU().getId().toString();
                                        longNumber = this.company.getCU().getLongNumber();
                                    }
                                    HashSet<String> tempIDs = new HashSet<String>();
                                    tempIDs.add(tempID);
                                    this.getFromCostOrgs(tempID, tempIDs);
                                    if (isBizUnit) {
                                        filter.getFilterItems().add(new FilterItemInfo("id", tempIDs, CompareType.INCLUDE));
                                    } else {
                                        filter.getFilterItems().add(new FilterItemInfo("cu.id", tempIDs, CompareType.INCLUDE));
                                    }
                                    filter.getFilterItems().add(new FilterItemInfo("longNumber", (Object)(longNumber + "!%"), CompareType.LIKE));
                                    filter.getFilterItems().add(new FilterItemInfo("isSealUp", (Object)new Integer(0)));
                                    filter.setMaskString("( #0 OR #1 ) AND #2");
                                } else if ("T_Org_Admin".equalsIgnoreCase(tableName)) {
                                    String longNumber = null;
                                    boolean isBizUnit = this.company.isIsBizUnit();
                                    if (isBizUnit) {
                                        fic.add(new FilterItemInfo("id", (Object)this.company.getId().toString()));
                                        longNumber = this.company.getLongNumber();
                                    } else {
                                        fic.add(new FilterItemInfo("CU.id", (Object)this.company.getCU().getId().toString()));
                                        longNumber = this.company.getCU().getLongNumber();
                                    }
                                    fic.add(new FilterItemInfo("longNumber", (Object)(longNumber + "!%"), CompareType.LIKE));
                                    filter.setMaskString("( #0 OR #1 )");
                                } else if ("T_BD_AccountBanks".equalsIgnoreCase(tableName)) {
                                    fic.add(new FilterItemInfo("company.id", (Object)this.company.getId().toString()));
                                    fic.add(new FilterItemInfo("company.id", null));
                                    filter.setMaskString("#0 OR #1  ");
                                } else {
                                    fic.add(new FilterItemInfo("CU.id", (Object)this.company.getCU().getId().toString()));
                                }
                            } else if ("T_ORG_CostCenter".equalsIgnoreCase(tableName)) {
                                filter.getFilterItems().add(new FilterItemInfo("isSealUp", (Object)new Integer(0)));
                            }
                            bizPromptBox.setEntityViewInfo(view);
                        } else if ("T_BD_CostObject".equalsIgnoreCase(tableName) && isCompanySeparate) {
                            filter = new FilterInfo();
                            view.getSorter().clear();
                            view.setFilter(filter);
                            fic = filter.getFilterItems();
                            fic.add(new FilterItemInfo("company.id", (Object)this.company.getId().toString()));
                            bizPromptBox.setEntityViewInfo(view);
                        }
                        if (Boolean.TRUE.equals(item.get("useLongNumber"))) {
                            bizPromptBox.setCommitFormat("$longnumber$");
                            bizPromptBox.setEditFormat("$longnumber$");
                            bizPromptBox.setDisplayFormat("$longnumber$ - $name$");
                        }
                        if ((groupTable = item.get("groupTable")) == null || groupTable.toString().trim().length() < 1) {
                            this.lockGroup(row);
                        } else {
                            needGroup = true;
                            KDBizPromptBox groupPromptBox = new KDBizPromptBox();
                            groupPromptBox.setEditable(true);
                            groupPromptBox.setEditFormat("$number$");
                            groupPromptBox.setDisplayFormat("$number$ - $name$");
                            groupPromptBox.setCommitFormat("$number$");
                            groupPromptBox.setHistoryRecordName("groupPromptBox");
                            if (tableName.equalsIgnoreCase("T_BD_Customer") || tableName.equalsIgnoreCase("T_BD_Supplier") || tableName.equalsIgnoreCase("T_BD_Material")) {
                                AsstGroupChooserPrompt prompt = new AsstGroupChooserPrompt((IUIObject)this);
                                if (tableName.equalsIgnoreCase("T_BD_Customer")) {
                                    prompt.setGroupType(1);
                                    bizPromptBox.addSelectorListener((SelectorListener)new AssItemSelectorListener(1));
                                } else if (tableName.equalsIgnoreCase("T_BD_Material")) {
                                    prompt.setGroupType(3);
                                    bizPromptBox.addSelectorListener((SelectorListener)new AssItemSelectorListener(3));
                                } else {
                                    prompt.setGroupType(2);
                                    bizPromptBox.addSelectorListener((SelectorListener)new AssItemSelectorListener(2));
                                }
                                groupPromptBox.setSelector((KDPromptSelector)prompt);
                                groupPromptBox.addSelectorListener((SelectorListener)new GroupSelectorListener(row.getCell("group")));
                            } else {
                                this.lockGroup(row);
                            }
                            KDTDefaultCellEditor groupEditor = new KDTDefaultCellEditor((IKDEditor)groupPromptBox);
                            ICell cell = row.getCell("group");
                            if (cell != null) {
                                cell.setEditor((ICellEditor)groupEditor);
                            }
                        }
                        KDTDefaultCellEditor editor = new KDTDefaultCellEditor((IKDEditor)bizPromptBox);
                        row.getCell("from").setEditor((ICellEditor)editor);
                        row.getCell("to").setEditor((ICellEditor)editor);
                        row.setUserObject((Object)item);
                        if (accountAsstItem == null || accountAsstItem.asstItems == null) continue;
                        AcctountAsstItemParser.AsstItem[] asstItems = accountAsstItem.asstItems;
                        for (int j = 0; j < asstItems.length; ++j) {
                            AcctountAsstItemParser.AsstItem itm = asstItems[j];
                            if (itm != null && itm.asstTypeNumber.equals((String)item.get("number"))) {
                                row.getCell("selected").setValue((Object)Boolean.TRUE);
                                if (groupTable != null && groupTable.toString().trim().length() >= 1 && itm.group != null) {
                                    ICell mycell = row.getCell("group");
                                    String r = "";
                                    for (int x = 0; x < itm.group.length; ++x) {
                                        r = x == 0 ? itm.group[x].toString() : r + '&' + itm.group[x].toString();
                                    }
                                    if (mycell != null) {
                                        mycell.setValue((Object)r);
                                        mycell.setUserObject((Object)itm.group);
                                    }
                                }
                                row.getCell("from").setValue((Object)itm.startNumber);
                                row.getCell("to").setValue((Object)itm.endNumber);
                                continue block6;
                            }
                            row.getCell("selected").setValue((Object)Boolean.FALSE);
                        }
                    }
                }
            }
            catch (EASBizException e) {
                this.handleException((Exception)((Object)e));
            }
            catch (BOSException e) {
                this.handleException((Exception)((Object)e));
            }
        }
    }

    private void getFromCostOrgs(String tempID, Set tempIDs) throws BOSException, EASBizException {
        OrgUnitCollection orgUnitRelationCollection = OrgUnitRelationFactory.getRemoteInstance().getFromUnit(tempID, 1, 5);
        if (orgUnitRelationCollection != null && orgUnitRelationCollection.size() > 0) {
            for (int i = 0; i < orgUnitRelationCollection.size(); ++i) {
                OrgUnitInfo orgUnitRelationInfo = orgUnitRelationCollection.get(i);
                tempIDs.add(orgUnitRelationInfo.getId().toString());
            }
        }
    }

    protected static TreeBaseInfo getTreeBaseNodeByNumber(String number, String groupTableName) throws Exception {
        ICSSPGroup treeBase = null;
        if (StringUtils.isEmpty((String)number)) {
            return null;
        }
        String string = "Select Number, LongNumber, Name Where number = '" + number + "' ";
        if (groupTableName.equalsIgnoreCase("T_BD_Customer")) {
            treeBase = CSSPGroupFactory.getRemoteInstance();
            string = string + " AND (groupStandard.type=1 or groupStandard.type=0)";
        } else if (groupTableName.equalsIgnoreCase("T_BD_Supplier")) {
            treeBase = CSSPGroupFactory.getRemoteInstance();
            string = string + " AND (groupStandard.type=2 or groupStandard.type=0)";
        } else if (groupTableName.equalsIgnoreCase("T_BD_Material")) {
            treeBase = MaterialGroupFactory.getRemoteInstance();
        } else {
            throw new Exception("No supported group.");
        }
        CoreBaseCollection colls = treeBase.getCollection(string);
        if (colls == null || colls.size() < 1) {
            return null;
        }
        return (TreeBaseInfo)colls.get(0);
    }

    private void lockGroup(IRow row) {
        StyleAttributes sa = row.getCell("group").getStyleAttributes();
        sa.setLocked(true);
        sa.setBackground(LOCKCOLOR);
        sa.setPattern(Pattern.Solid);
    }

    void updateBtnState() {
        if (this.pmtProject.getValue() == null) {
            this.btnOK.setEnabled(false);
        } else {
            this.btnOK.setEnabled(true);
        }
    }

    @Override
    public void actionOK_actionPerformed(ActionEvent e) throws Exception {
        this.getRTMap().put("CANCEL", null);
        this.getRTMap().put("DATA", this.getData());
        this.destroyWindow();
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.getRTMap().put("CANCEL", "CANCEL");
        this.destroyWindow();
    }

    public String getUITitle() {
        return EASResource.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"79_AcctCashISelectorUI");
    }

    private HashMap getRTMap() {
        return (HashMap)this.getUIContext().get("RT");
    }

    String getData() {
        StringBuffer buf = new StringBuffer();
        if (this.pmtProject.getValue() instanceof CashFlowItemInfo) {
            CashFlowItemInfo info = (CashFlowItemInfo)this.pmtProject.getValue();
            buf.append(info.getNumber());
        } else {
            buf.append(this.pmtProject.getValue().toString());
        }
        for (int i = 0; i < this.kDTable.getRowCount(); ++i) {
            IRow row = this.kDTable.getRow(i);
            Boolean b = (Boolean)row.getCell("selected").getValue();
            if (b == null || !b.booleanValue()) continue;
            HashMap map = (HashMap)row.getUserObject();
            String number = (String)map.get("number");
            buf.append("|" + number + "|");
            if (number == null) continue;
            Object startGroup = row.getCell("group").getValue();
            if (startGroup != null) {
                String startG = startGroup == null ? null : (startGroup instanceof DataBaseInfo ? ((DataBaseInfo)startGroup).getNumber() : startGroup.toString());
                buf.append(startG);
                if (!StringUtils.isEmpty((String)startG)) {
                    buf.append('#');
                }
            }
            Object value = row.getCell("from").getValue();
            String startNumber = null;
            if (value instanceof IObjectValue && Boolean.TRUE.equals(map.get("useLongNumber"))) {
                startNumber = (String)((IObjectValue)value).get("longNumber");
                startNumber = startNumber.replaceAll("\\!", ".");
            } else {
                startNumber = this.getNumber(row.getCell("from").getValue());
            }
            String endNumber = null;
            value = row.getCell("to").getValue();
            if (value instanceof IObjectValue && Boolean.TRUE.equals(map.get("useLongNumber"))) {
                endNumber = (String)((IObjectValue)value).get("longNumber");
                endNumber = endNumber.replaceAll("\\!", ".");
            } else {
                endNumber = this.getNumber(row.getCell("to").getValue());
            }
            if (startNumber != null && endNumber != null) {
                if (startNumber.equals(endNumber)) {
                    buf.append(startNumber);
                    continue;
                }
                buf.append(startNumber + ":" + endNumber);
                continue;
            }
            if (startNumber != null && endNumber == null) {
                buf.append(startNumber);
                continue;
            }
            if (startNumber != null || endNumber == null) continue;
            buf.append(endNumber);
        }
        return buf.toString();
    }

    String getNumber(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof String) {
            return obj.toString();
        }
        try {
            Method m = obj.getClass().getMethod("getNumber", new Class[0]);
            Object v = m.invoke(obj, new Object[0]);
            if (v != null) {
                return v.toString();
            }
            return null;
        }
        catch (Throwable a) {
            return null;
        }
    }

    private FormulaWizardUI getFormulaUI() {
        if (this.formulaWizardUI != null) {
            return this.formulaWizardUI;
        }
        Object obj = this.getUIContext().get("Owner");
        if (obj != null && obj instanceof FormulaWizardUI) {
            FormulaWizardUI wizard;
            this.formulaWizardUI = wizard = (FormulaWizardUI)obj;
            return wizard;
        }
        return null;
    }

    class Value {
        String number = null;

        Value() {
        }

        public String getNumber() {
            return this.number;
        }

        public String toString() {
            return this.getNumber();
        }
    }

    private final class AssItemSelectorListener
    implements SelectorListener {
        int type = -1;

        public AssItemSelectorListener(int type) {
            this.type = type;
        }

        public void willShow(SelectorEvent e) {
            IRow row = CashProjectSelectorUI.this.kDTable.getRow(CashProjectSelectorUI.this.kDTable.getSelectManager().getActiveRowIndex());
            Object startGroup = row.getCell("group").getValue();
            if (startGroup == null) {
                return;
            }
            String groups = startGroup.toString();
            KDBizPromptBox pb = (KDBizPromptBox)e.getSource();
            if (StringUtils.isEmpty((String)groups)) {
                pb.setEntityViewInfo(null);
                pb.getQueryAgent().resetRuntimeEntityView();
                return;
            }
            EntityViewInfo view = new EntityViewInfo();
            pb.setEntityViewInfo(view);
            FilterInfo filter = new FilterInfo();
            view.setFilter(filter);
            FilterItemCollection fic = filter.getFilterItems();
            pb.getQueryAgent().resetRuntimeEntityView();
            try {
                AcctountAsstItemParser.AccountAsstItem item = TableToolkit.parseAcctItem("1002|001|" + groups + "#");
                if (item == null) {
                    return;
                }
                AcctountAsstItemParser.Group[] group = item.asstItems[0].group;
                String mask = null;
                int maskIndex = 0;
                for (int i = 0; group != null && i < group.length; ++i) {
                    String endLongNumber;
                    String startLongNumber;
                    String std = group[i].standardNumber;
                    mask = i == 0 ? "(#" + maskIndex++ : mask + " or (#" + maskIndex++;
                    if (this.type == 1) {
                        fic.add(new FilterItemInfo("customerGroupDetails.CustomerGroupStandard.number", (Object)std));
                        if (!StringUtils.isEmpty((String)group[i].startNumber) && !StringUtils.isEmpty((String)group[i].endNumber)) {
                            if (group[i].startNumber.equals(group[i].endNumber)) {
                                TreeBaseInfo customerGroup = CashProjectSelectorUI.getTreeBaseNodeByNumber(group[i].startNumber, "T_BD_Customer");
                                if (customerGroup != null && !StringUtils.isEmpty((String)customerGroup.getLongNumber())) {
                                    fic.add(new FilterItemInfo("customerGroupDetails.customerGroup.longNumber", (Object)customerGroup.getLongNumber()));
                                    fic.add(new FilterItemInfo("customerGroupDetails.customerGroup.longNumber", (Object)(customerGroup.getLongNumber() + "!%"), CompareType.LIKE));
                                    mask = mask + " and (#" + maskIndex++ + " or #" + maskIndex++ + ")";
                                } else {
                                    fic.add(new FilterItemInfo("customerGroupDetails.customerGroup.number", (Object)group[i].startNumber));
                                    mask = mask + " and #" + maskIndex++;
                                }
                            } else {
                                TreeBaseInfo customerGroupStart = CashProjectSelectorUI.getTreeBaseNodeByNumber(group[i].startNumber, "T_BD_Customer");
                                TreeBaseInfo customerGroupEnd = CashProjectSelectorUI.getTreeBaseNodeByNumber(group[i].endNumber, "T_BD_Customer");
                                if (customerGroupStart != null && customerGroupEnd != null && !StringUtils.isEmpty((String)customerGroupStart.getLongNumber()) && !StringUtils.isEmpty((String)customerGroupEnd.getLongNumber())) {
                                    startLongNumber = customerGroupStart.getLongNumber();
                                    endLongNumber = customerGroupEnd.getLongNumber();
                                    fic.add(new FilterItemInfo("customerGroupDetails.customerGroup.longNumber", (Object)startLongNumber, CompareType.GREATER_EQUALS));
                                    fic.add(new FilterItemInfo("customerGroupDetails.customerGroup.longNumber", (Object)endLongNumber, CompareType.LESS_EQUALS));
                                    fic.add(new FilterItemInfo("customerGroupDetails.customerGroup.longNumber", (Object)(endLongNumber + "!%"), CompareType.LIKE));
                                    mask = mask + " and (#" + maskIndex++ + " and #" + maskIndex++ + " or #" + maskIndex++ + ")";
                                } else {
                                    fic.add(new FilterItemInfo("customerGroupDetails.customerGroup.number", (Object)group[i].startNumber));
                                    fic.add(new FilterItemInfo("customerGroupDetails.customerGroup.number", (Object)group[i].endNumber));
                                    mask = mask + " and (#" + maskIndex++ + " and #" + maskIndex++ + ")";
                                }
                            }
                        }
                    } else if (this.type == 2) {
                        fic.add(new FilterItemInfo("supplierGroupDetails.SupplierGroupStandard.number", (Object)std));
                        if (!StringUtils.isEmpty((String)group[i].startNumber) && !StringUtils.isEmpty((String)group[i].endNumber)) {
                            if (group[i].startNumber.equals(group[i].endNumber)) {
                                TreeBaseInfo supplierGroup = CashProjectSelectorUI.getTreeBaseNodeByNumber(group[i].startNumber, "T_BD_Supplier");
                                if (supplierGroup != null && !StringUtils.isEmpty((String)supplierGroup.getLongNumber())) {
                                    fic.add(new FilterItemInfo("supplierGroupDetails.supplierGroup.longNumber", (Object)supplierGroup.getLongNumber()));
                                    fic.add(new FilterItemInfo("supplierGroupDetails.supplierGroup.longNumber", (Object)(supplierGroup.getLongNumber() + "!%"), CompareType.LIKE));
                                    mask = mask + " and (#" + maskIndex++ + " or #" + maskIndex++ + ")";
                                } else {
                                    fic.add(new FilterItemInfo("supplierGroupDetails.supplierGroup.number", (Object)group[i].startNumber));
                                    mask = mask + " and #" + maskIndex++;
                                }
                            } else {
                                TreeBaseInfo supplierGroupStart = CashProjectSelectorUI.getTreeBaseNodeByNumber(group[i].startNumber, "T_BD_Supplier");
                                TreeBaseInfo supplierGroupEnd = CashProjectSelectorUI.getTreeBaseNodeByNumber(group[i].endNumber, "T_BD_Supplier");
                                if (supplierGroupStart != null && supplierGroupEnd != null && !StringUtils.isEmpty((String)supplierGroupStart.getLongNumber()) && !StringUtils.isEmpty((String)supplierGroupEnd.getLongNumber())) {
                                    startLongNumber = supplierGroupStart.getLongNumber();
                                    endLongNumber = supplierGroupEnd.getLongNumber();
                                    fic.add(new FilterItemInfo("supplierGroupDetails.supplierGroup.longNumber", (Object)startLongNumber, CompareType.GREATER_EQUALS));
                                    fic.add(new FilterItemInfo("supplierGroupDetails.supplierGroup.longNumber", (Object)endLongNumber, CompareType.LESS_EQUALS));
                                    fic.add(new FilterItemInfo("supplierGroupDetails.supplierGroup.longNumber", (Object)(endLongNumber + "!%"), CompareType.LIKE));
                                    mask = mask + " and (#" + maskIndex++ + " and #" + maskIndex++ + " or #" + maskIndex++ + ")";
                                } else {
                                    fic.add(new FilterItemInfo("supplierGroupDetails.supplierGroup.number", (Object)group[i].startNumber, CompareType.GREATER_EQUALS));
                                    fic.add(new FilterItemInfo("supplierGroupDetails.supplierGroup.number", (Object)group[i].endNumber, CompareType.LESS_EQUALS));
                                    mask = mask + " and (#" + maskIndex++ + " and #" + maskIndex++ + ")";
                                }
                            }
                        }
                    } else if (this.type == 3) {
                        fic.add(new FilterItemInfo("materialGroupDetails.MaterialGroupStandard.number", (Object)std));
                        if (!StringUtils.isEmpty((String)group[i].startNumber) && !StringUtils.isEmpty((String)group[i].endNumber)) {
                            if (group[i].startNumber.equals(group[i].endNumber)) {
                                TreeBaseInfo materialGroup = CashProjectSelectorUI.getTreeBaseNodeByNumber(group[i].startNumber, "T_BD_Material");
                                if (materialGroup != null && !StringUtils.isEmpty((String)materialGroup.getLongNumber())) {
                                    fic.add(new FilterItemInfo("materialGroupDetails.materialGroup.longNumber", (Object)materialGroup.getLongNumber()));
                                    fic.add(new FilterItemInfo("materialGroupDetails.materialGroup.longNumber", (Object)(materialGroup.getLongNumber() + "!%"), CompareType.LIKE));
                                    mask = mask + " and (#" + maskIndex++ + " or #" + maskIndex++ + ")";
                                } else {
                                    fic.add(new FilterItemInfo("materialGroupDetails.materialGroup.number", (Object)group[i].startNumber));
                                    mask = mask + " and #" + maskIndex++;
                                }
                            } else {
                                TreeBaseInfo materialGroupStart = CashProjectSelectorUI.getTreeBaseNodeByNumber(group[i].startNumber, "T_BD_Material");
                                TreeBaseInfo materialGroupEnd = CashProjectSelectorUI.getTreeBaseNodeByNumber(group[i].endNumber, "T_BD_Material");
                                if (materialGroupStart != null && materialGroupEnd != null && !StringUtils.isEmpty((String)materialGroupStart.getLongNumber()) && !StringUtils.isEmpty((String)materialGroupEnd.getLongNumber())) {
                                    startLongNumber = materialGroupStart.getLongNumber();
                                    endLongNumber = materialGroupEnd.getLongNumber();
                                    fic.add(new FilterItemInfo("materialGroupDetails.materialGroup.longNumber", (Object)startLongNumber, CompareType.GREATER_EQUALS));
                                    fic.add(new FilterItemInfo("materialGroupDetails.materialGroup.longNumber", (Object)endLongNumber, CompareType.LESS_EQUALS));
                                    fic.add(new FilterItemInfo("materialGroupDetails.materialGroup.longNumber", (Object)(endLongNumber + "!%"), CompareType.LIKE));
                                    mask = mask + " and (#" + maskIndex++ + " and #" + maskIndex++ + " or #" + maskIndex++ + ")";
                                } else {
                                    fic.add(new FilterItemInfo("materialGroupDetails.materialGroup.number", (Object)group[i].startNumber, CompareType.GREATER_EQUALS));
                                    fic.add(new FilterItemInfo("materialGroupDetails.materialGroup.number", (Object)group[i].endNumber, CompareType.LESS_EQUALS));
                                    mask = mask + " and (#" + maskIndex++ + " and #" + maskIndex++ + ")";
                                }
                            }
                        }
                    }
                    mask = mask + ")";
                }
                filter.setMaskString(mask);
            }
            catch (Exception e1) {
                CashProjectSelectorUI.this.handUIException(e1);
            }
        }
    }

    private static class GroupSelectorListener
    implements SelectorListener {
        ICell groupCell;

        public GroupSelectorListener(ICell cell) {
            this.groupCell = cell;
        }

        public void willShow(SelectorEvent e) {
            KDBizPromptBox box = (KDBizPromptBox)e.getSource();
            AsstGroupChooserPrompt prompt = (AsstGroupChooserPrompt)box.getSelector();
            prompt.setInitData(this.groupCell.getValue());
        }
    }
}

