/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.client;

import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.cslrpt.client.SimpleNotePad;
import com.kingdee.eas.fi.rpt.ReportFactory;
import com.kingdee.eas.fi.rpt.client.AbstractCheckReportUI;
import com.kingdee.eas.util.client.EASResource;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.Map;
import javax.swing.JFormattedTextField;
import javax.swing.text.NumberFormatter;
import org.apache.log4j.Logger;

public class CheckReportUI
extends AbstractCheckReportUI {
    private static final Logger logger = CoreUIObject.getLogger(CheckReportUI.class);
    private int year = 0;
    private int period = 0;

    public CheckReportUI() throws Exception {
        DecimalFormat format = new DecimalFormat("####");
        format.setMinimumFractionDigits(0);
        format.setMinimumIntegerDigits(1);
        format.setParseIntegerOnly(false);
        NumberFormatter numberFormatterYear = new NumberFormatter(format);
        numberFormatterYear.setMinimum(new BigDecimal("1900"));
        numberFormatterYear.setMaximum(new BigDecimal("2999"));
        numberFormatterYear.setAllowsInvalid(true);
        numberFormatterYear.setCommitsOnValidEdit(true);
        this.txtyear.setEditFormatter((JFormattedTextField.AbstractFormatter)numberFormatterYear);
        this.txtyear.setDisplayFormatter((JFormattedTextField.AbstractFormatter)numberFormatterYear);
        this.txtyear.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                CheckReportUI.this.txtDescription.setText(EASResource.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"298_CheckReportUI"));
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        });
        NumberFormatter numberFormatterperiod = new NumberFormatter(format);
        numberFormatterperiod.setMinimum(new BigDecimal("1"));
        numberFormatterperiod.setMaximum(new BigDecimal("99"));
        numberFormatterperiod.setAllowsInvalid(true);
        numberFormatterperiod.setCommitsOnValidEdit(true);
        this.txtperiod.setEditFormatter((JFormattedTextField.AbstractFormatter)numberFormatterperiod);
        this.txtperiod.setDisplayFormatter((JFormattedTextField.AbstractFormatter)numberFormatterperiod);
        this.txtperiod.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                CheckReportUI.this.txtDescription.setText(EASResource.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"299_CheckReportUI"));
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        });
        NumberFormatter numberFormatterMaxRow = new NumberFormatter(format);
        numberFormatterMaxRow.setMinimum(new BigDecimal("1000"));
        numberFormatterMaxRow.setMaximum(new BigDecimal("60000"));
        numberFormatterMaxRow.setAllowsInvalid(true);
        numberFormatterMaxRow.setCommitsOnValidEdit(true);
        this.txtmaxrow.setEditFormatter((JFormattedTextField.AbstractFormatter)numberFormatterMaxRow);
        this.txtmaxrow.setDisplayFormatter((JFormattedTextField.AbstractFormatter)numberFormatterMaxRow);
        this.txtmaxrow.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                CheckReportUI.this.txtDescription.setText(EASResource.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"300_CheckReportUI"));
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        });
        NumberFormatter numberFormatterMaxCol = new NumberFormatter(format);
        numberFormatterMaxCol.setMinimum(new BigDecimal("256"));
        numberFormatterMaxCol.setMaximum(new BigDecimal("25600"));
        numberFormatterMaxCol.setAllowsInvalid(true);
        numberFormatterMaxCol.setCommitsOnValidEdit(true);
        this.txtmaxcol.setEditFormatter((JFormattedTextField.AbstractFormatter)numberFormatterMaxCol);
        this.txtmaxcol.setDisplayFormatter((JFormattedTextField.AbstractFormatter)numberFormatterMaxCol);
        this.txtmaxcol.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                CheckReportUI.this.txtDescription.setText(EASResource.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"301_CheckReportUI"));
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        });
        this.setUITitle(EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResource.checkReportUITitle"));
        this.txtDescription.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                CheckReportUI.this.txtDescription.setText(EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResource.checkReportUIDescription"));
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        });
    }

    public void onLoad() throws Exception {
        Map uiCtx = this.getUIContext();
        if (uiCtx.get("year") != null && uiCtx.get("period") != null) {
            this.year = (Integer)uiCtx.get("year");
            this.period = (Integer)uiCtx.get("period");
            this.txtyear.setValue((Object)new BigDecimal(this.year));
            this.txtperiod.setValue((Object)new BigDecimal(this.period));
        }
        this.txtmaxrow.setValue((Object)new BigDecimal("5000"));
        this.txtmaxcol.setValue((Object)new BigDecimal("500"));
    }

    public void doLayout() {
        super.doLayout();
        this.txtDescription.requestFocusInWindow();
        this.txtDescription.setSelectAllOnFocus(false);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void actionFinish_actionPerformed(ActionEvent e) throws Exception {
        super.actionFinish_actionPerformed(e);
        int year = this.txtyear.getNumberValue().intValue();
        int period = this.txtperiod.getNumberValue().intValue();
        int maxRow = this.txtmaxrow.getNumberValue().intValue();
        int maxCol = this.txtmaxcol.getNumberValue().intValue();
        String result = ReportFactory.getRemoteInstance().checkReport(year, period, maxRow, maxCol);
        StringBuffer resultBuffer = new StringBuffer();
        resultBuffer.append(EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResource.checkReportUITitle")).append("\n").append(result);
        UIContext uiCtx = new UIContext((Object)this);
        uiCtx.put((Object)"ShowOpen", (Object)Boolean.FALSE);
        uiCtx.put((Object)"Title", (Object)EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResource.checkReportUITitle"));
        SimpleNotePad.showMessageByModel((UIContext)uiCtx, (String)resultBuffer.toString());
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancel_actionPerformed(e);
        this.getUIWindow().close();
    }
}

