/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTPrintManager;
import com.kingdee.bos.ctrl.kdf.table.event.KDTActiveCellEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTActiveCellListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.UnionVersionStatusEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CslParamFactory;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.client.UnionVersion2F7;
import com.kingdee.eas.fi.gr.cslrpt.util.CslOrgTreeUtil;
import com.kingdee.eas.fi.rpt.CompanyMapingDataCollection;
import com.kingdee.eas.fi.rpt.CompanyMapingDataFactory;
import com.kingdee.eas.fi.rpt.CompanyMapingDataInfo;
import com.kingdee.eas.fi.rpt.JiuQiReportTypeEnum;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.fi.rpt.client.AbstractCompanyMapingEditUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class CompanyMapingEditUI
extends AbstractCompanyMapingEditUI {
    private static final Logger logger = CoreUIObject.getLogger(CompanyMapingEditUI.class);
    private boolean isChange = false;
    private String isSupportDiffTable = null;
    private Map fullOrgUnitInfoMap = null;
    private Map companyMapingDataInfoMap = null;

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public String getUITitle() {
        return EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResource.titiName");
    }

    public void onLoad() throws Exception {
        this.isSupportDiffTable = CslParamFactory.getRemoteInstance().getParam("KEY_CSLPARAM_DIFFTABLE");
        this.btnSave.setEnabled(true);
        this.btnRemove.setEnabled(true);
        this.btnPrint.setEnabled(true);
        this.btnPrintPre.setEnabled(true);
        this.btnSave.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.btnRemove.setIcon(EASResource.getIcon((String)"imgTbtn_delete"));
        this.btnPrint.setIcon(EASResource.getIcon((String)"imgTbtn_print"));
        this.btnPrintPre.setIcon(EASResource.getIcon((String)"imgTbtn_preview"));
        UnionVersion2F7 f7 = new UnionVersion2F7();
        f7.setTitile(EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResource.jqorgt"));
        this.orgTreeF7.setSelector((KDPromptSelector)f7);
        this.orgTreeF7.setEditable(false);
        this.orgTreeF7.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                CompanyMapingEditUI.this.onCbRangeSelectChanged();
            }
        });
        final String companyLength = CslRptUtil.getCslParamToString(null, (String)"KEY_CSLPARAM_NM_COMPANYLENGTH");
        this.kDTable1.addKDTActiveCellListener(new KDTActiveCellListener(){

            public void activeCellChanged(KDTActiveCellEvent e) {
                int len = 20;
                try {
                    if (companyLength != null) {
                        len = Integer.parseInt(companyLength);
                    }
                }
                catch (NumberFormatException e1) {
                    CompanyMapingEditUI.this.handleException(e1);
                }
                if (e.getRowIndex() < 0 || e.getColumnIndex() < 0) {
                    return;
                }
                KDTextField edit = new KDTextField();
                edit.setMaxLength(len);
                ICell cell = CompanyMapingEditUI.this.kDTable1.getCell(e.getPrevRowIndex(), e.getPrevColumnIndex());
                if (cell != null && e.getPrevColumnIndex() != 4) {
                    cell.setEditor(null);
                }
                if (e.getColumnIndex() == 3) {
                    CompanyMapingEditUI.this.kDTable1.getCell(e.getRowIndex(), e.getColumnIndex()).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)edit));
                }
            }
        });
        this.kDTable1.addKDTEditListener(new KDTEditListener(){

            public void editStarting(KDTEditEvent arg0) {
            }

            public void editStarted(KDTEditEvent arg0) {
            }

            public void editValueChanged(KDTEditEvent arg0) {
                CompanyMapingEditUI.this.isChange = true;
            }

            public void editStopping(KDTEditEvent arg0) {
            }

            public void editStopped(KDTEditEvent arg0) {
            }

            public void editCanceled(KDTEditEvent arg0) {
            }
        });
        this.kDTable1.checkParsed();
    }

    private void onCbRangeSelectChanged() {
        this.checkSave();
        this.loadSelectORGSToTable();
        this.isChange = false;
    }

    private void loadSelectORGSToTable() {
        OrgTreeInfo orgTree;
        this.kDTable1.removeRows();
        if (this.fullOrgUnitInfoMap != null) {
            this.fullOrgUnitInfoMap = new HashMap();
        }
        if (this.companyMapingDataInfoMap != null) {
            this.companyMapingDataInfoMap = new HashMap();
            this.companyMapingDataInfoMap.put("orgIdSet", new TreeSet());
        }
        if ((orgTree = (OrgTreeInfo)this.orgTreeF7.getValue()) == null) {
            return;
        }
        DefaultKingdeeTreeNode treeNodeRoot = null;
        try {
            treeNodeRoot = CslOrgTreeUtil.getUnionDebtTree(null, (OrgTreeInfo)orgTree, (boolean)false);
            List typeList = JiuQiReportTypeEnum.getEnumList();
            this.buildFullOrgUnitTree(treeNodeRoot, 0, typeList);
        }
        catch (Exception e) {
            super.handUIException((Throwable)e);
            logger.debug((Object)e.getMessage());
        }
    }

    private void getFullOrgUnitInfoMap(DefaultKingdeeTreeNode node) throws BOSException {
        TreeSet orgInfoIdSet = new TreeSet();
        this.buildOrgInfoIdSet(node, orgInfoIdSet);
        if (this.fullOrgUnitInfoMap == null) {
            this.fullOrgUnitInfoMap = new HashMap();
        }
        if (!orgInfoIdSet.isEmpty()) {
            StringBuffer oql = new StringBuffer("select * where id in (");
            Iterator iter = orgInfoIdSet.iterator();
            while (iter.hasNext()) {
                oql.append("'").append(iter.next()).append("',");
            }
            oql.deleteCharAt(oql.length() - 1);
            oql.append(")");
            FullOrgUnitCollection collection = FullOrgUnitFactory.getRemoteInstance().getFullOrgUnitCollection(oql.toString());
            for (int i = 0; i < collection.size(); ++i) {
                this.fullOrgUnitInfoMap.put(collection.get(i).getId().toString(), collection.get(i));
            }
        }
    }

    private void buildOrgInfoIdSet(DefaultKingdeeTreeNode node, Set orgInfoIdSet) {
        if (orgInfoIdSet == null) {
            orgInfoIdSet = new TreeSet<String>();
        }
        if (node != null && node.getUserObject() != null) {
            orgInfoIdSet.add(((OrgStructureInfo)node.getUserObject()).getUnit().getId().toString());
            if (node.getChildCount() > 0) {
                for (int i = 0; i < node.getChildCount(); ++i) {
                    this.buildOrgInfoIdSet((DefaultKingdeeTreeNode)node.getChildAt(i), orgInfoIdSet);
                }
            }
        }
    }

    private void getCompanyMapingDataInfoMap() throws BOSException {
        if (this.companyMapingDataInfoMap == null) {
            this.companyMapingDataInfoMap = new HashMap();
            this.companyMapingDataInfoMap.put("orgIdSet", new TreeSet());
        }
        if (!this.fullOrgUnitInfoMap.isEmpty()) {
            TreeSet<String> set = new TreeSet<String>();
            Set orgIdSet = (Set)this.companyMapingDataInfoMap.get("orgIdSet");
            Iterator iter = this.fullOrgUnitInfoMap.keySet().iterator();
            FullOrgUnitInfo orgInfo = null;
            while (iter.hasNext()) {
                orgInfo = (FullOrgUnitInfo)this.fullOrgUnitInfoMap.get(iter.next());
                if (orgIdSet.contains(orgInfo.getId().toString())) continue;
                set.add(orgInfo.getId().toString());
            }
            if (!set.isEmpty()) {
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("fullOrgUnit", set, CompareType.INCLUDE));
                EntityViewInfo ev = new EntityViewInfo();
                ev.setFilter(filter);
                CompanyMapingDataCollection c = CompanyMapingDataFactory.getRemoteInstance().getCompanyMapingDataCollection(ev);
                for (int i = 0; i < c.size(); ++i) {
                    String key = c.get(i).getFullOrgUnit().getId().toString();
                    switch (c.get(i).getEasReportType().getValue()) {
                        case 1: {
                            key = key + "_" + 1;
                            break;
                        }
                        case 2: {
                            key = key + "_" + 2;
                            break;
                        }
                        case 8: {
                            key = key + "_" + 8;
                        }
                    }
                    this.companyMapingDataInfoMap.put(key, c.get(i));
                }
                orgIdSet.addAll(set);
            }
        }
    }

    private void buildFullOrgUnitTree(DefaultKingdeeTreeNode node, int level, List typeList) throws EASBizException, BOSException {
        OrgStructureInfo info = (OrgStructureInfo)node.getUserObject();
        FullOrgUnitInfo orgInfo = info.getUnit();
        if (this.fullOrgUnitInfoMap == null || !this.fullOrgUnitInfoMap.containsKey(info.getUnit().getId().toString())) {
            this.getFullOrgUnitInfoMap(node);
            this.getCompanyMapingDataInfoMap();
        }
        orgInfo = (FullOrgUnitInfo)this.fullOrgUnitInfoMap.get(info.getUnit().getId().toString());
        CompanyMapingDataInfo cif = null;
        if (orgInfo.isIsCompanyOrgUnit()) {
            IRow row1 = this.kDTable1.addRow();
            cif = (CompanyMapingDataInfo)this.companyMapingDataInfoMap.get(orgInfo.getId().toString() + "_" + 1);
            this.initRowAndfillRowData(node, level, typeList, orgInfo, row1, RptSrcTypeEnum.NORMAL, cif);
        } else {
            IRow row2 = this.kDTable1.addRow();
            cif = (CompanyMapingDataInfo)this.companyMapingDataInfoMap.get(orgInfo.getId().toString() + "_" + 2);
            this.initRowAndfillRowData(node, level, typeList, orgInfo, row2, RptSrcTypeEnum.SUM, cif);
            if ("true".equalsIgnoreCase(this.isSupportDiffTable)) {
                IRow row3 = this.kDTable1.addRow();
                cif = (CompanyMapingDataInfo)this.companyMapingDataInfoMap.get(orgInfo.getId().toString() + "_" + 8);
                this.initRowAndfillRowData(node, level, typeList, orgInfo, row3, RptSrcTypeEnum.DIFFTABLE, cif);
            }
        }
        if (node.getChildCount() > 0) {
            for (int i = 0; i < node.getChildCount(); ++i) {
                this.buildFullOrgUnitTree((DefaultKingdeeTreeNode)node.getChildAt(i), level + 1, typeList);
            }
        }
    }

    private void initRowAndfillRowData(DefaultKingdeeTreeNode node, int level, List typeList, FullOrgUnitInfo orgInfo, IRow row, RptSrcTypeEnum rpttype, CompanyMapingDataInfo cif) throws BOSException, EASBizException {
        row.setUserObject((Object)orgInfo);
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < level; ++i) {
            buf.append("  ");
        }
        row.getCell(0).setValue((Object)(buf.toString() + orgInfo.getNumber()));
        row.getCell(1).setValue((Object)orgInfo.getName());
        row.getCell(2).setValue((Object)rpttype);
        ICell typeCell = row.getCell(4);
        KDComboBox typeComBo = new KDComboBox();
        typeComBo.addItem((Object)"");
        typeComBo.addItems(typeList.toArray());
        typeCell.setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)typeComBo));
        if (cif != null) {
            row.getCell(3).setValue((Object)cif.getCompanyCode());
            row.getCell(5).setValue((Object)cif.getCompanyName());
            row.getCell(6).setValue((Object)cif.getUnitCode());
            JiuQiReportTypeEnum typeEnum = cif.getJiuQiReportType();
            if (typeEnum != null) {
                int count = typeComBo.getItemCount();
                for (int i = 1; i < count; ++i) {
                    if (!typeComBo.getItemAt(i).equals((Object)typeEnum)) continue;
                    typeComBo.setSelectedIndex(i);
                    typeCell.setValue((Object)typeEnum);
                    break;
                }
            }
            row.getCell(7).setValue((Object)cif.getUnitName());
        }
    }

    @Override
    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        if (this.kDTable1.getRowCount() <= 0) {
            return;
        }
        int rt = MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"96_CompanyMapingEditUI"));
        if (rt == 2 || rt == 1) {
            return;
        }
        OrgTreeInfo orgTree = (OrgTreeInfo)this.orgTreeF7.getValue();
        if (orgTree == null) {
            return;
        }
        this.deleteData();
        this.loadSelectORGSToTable();
        this.isChange = false;
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"97_CompanyMapingEditUI"));
    }

    private boolean deleteData() throws EASBizException, BOSException {
        IRow row;
        HashSet<String> set = new HashSet<String>();
        for (int i = 0; i < this.kDTable1.getRowCount() && (row = this.kDTable1.getRow(i)).getUserObject() != null; ++i) {
            set.add(((FullOrgUnitInfo)row.getUserObject()).getId().toString());
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("fullOrgUnit", set, CompareType.INCLUDE));
        CompanyMapingDataFactory.getRemoteInstance().delete(filter);
        return true;
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        OrgTreeInfo orgTree;
        if (!this.verify()) {
            SysUtil.abort();
        }
        if ((orgTree = (OrgTreeInfo)this.orgTreeF7.getValue()) != null) {
            IRow row;
            CompanyMapingDataCollection list = new CompanyMapingDataCollection();
            for (int i = 0; i < this.kDTable1.getRowCount() && (row = this.kDTable1.getRow(i)).getUserObject() != null; ++i) {
                CompanyMapingDataInfo cmd = new CompanyMapingDataInfo();
                cmd.setOrgTree(orgTree);
                cmd.setFullOrgUnit((FullOrgUnitInfo)row.getUserObject());
                cmd.setEasReportType((RptSrcTypeEnum)((Object)row.getCell(2).getValue()));
                cmd.setCompanyCode((String)row.getCell(3).getValue());
                Object type = row.getCell(4).getValue();
                if (type != null && type instanceof JiuQiReportTypeEnum) {
                    cmd.setJiuQiReportType((JiuQiReportTypeEnum)((Object)type));
                }
                cmd.setCompanyName((String)row.getCell(5).getValue());
                cmd.setUnitCode((String)row.getCell(6).getValue());
                cmd.setUnitName((String)row.getCell(7).getValue());
                list.add(cmd);
            }
            CompanyMapingDataFactory.getRemoteInstance().submitCollection((IObjectCollection)list);
            this.isChange = false;
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"98_CompanyMapingEditUI"));
        }
    }

    private boolean verify() {
        ArrayList<Object> companyList = new ArrayList<Object>();
        for (int i = 0; i < this.kDTable1.getRowCount(); ++i) {
            IRow row = this.kDTable1.getRow(i);
            String num = (String)row.getCell(3).getValue();
            if (num == null) {
                companyList.add(row.getCell(1).getValue());
                continue;
            }
            if (num.trim().length() <= 0 || num.trim().length() >= 9) continue;
            companyList.add(row.getCell(1).getValue());
        }
        HashMap<String, String> companyCache = new HashMap<String, String>();
        if (companyList.size() > 0) {
            StringBuffer msg = new StringBuffer();
            msg.append(EASResource.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"99_CompanyMapingEditUI"));
            msg.append("\r\n");
            for (String string : companyList) {
                if (companyCache.containsKey(string)) continue;
                msg.append(string).append("\r\n");
                companyCache.put(string, "");
            }
            return 2 != MsgBox.showConfirm3a((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"100_CompanyMapingEditUI"), (String)msg.toString().replaceAll("\\\\n", "\n").replaceAll("\\\\r", "\r"));
        }
        return true;
    }

    protected boolean checkBeforeWindowClosing() {
        this.checkSave();
        return super.checkBeforeWindowClosing();
    }

    private void checkSave() {
        if (this.isChange) {
            boolean msgYES;
            int rt = MsgBox.showConfirm3((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"101_CompanyMapingEditUI"));
            boolean msgOk = rt == 0;
            boolean bl = msgYES = rt == 0;
            if (msgOk || msgYES) {
                try {
                    this.actionSave_actionPerformed(null);
                }
                catch (Exception e) {
                    this.handUIExceptionAndAbort(e);
                }
            }
        }
    }

    @Override
    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        KDTPrintManager prm = this.kDTable1.getPrintManager();
        prm.print();
    }

    @Override
    public void actionPrintPre_actionPerformed(ActionEvent e) throws Exception {
        KDTPrintManager prm = this.kDTable1.getPrintManager();
        prm.printPreview();
    }

    class OrgTreeExInfo
    extends OrgTreeInfo {
        OrgTreeExInfo() {
        }

        public String toString() {
            if (this.getStatus().equals((Object)UnionVersionStatusEnum.ARCHIVE)) {
                return this.getName() + " -  " + this.getStartDate() + "  -  " + this.getEndDate();
            }
            return this.getName() + " -  " + this.getStartDate();
        }
    }
}

