/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.DataCollectCollection;
import com.kingdee.eas.fi.gr.cslrpt.DataCollectFactory;
import com.kingdee.eas.fi.gr.cslrpt.DataCollectInfo;
import com.kingdee.eas.fi.gr.cslrpt.FiscalPeriodHelper;
import com.kingdee.eas.fi.gr.cslrpt.ICSLContext;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.gr.cslrpt.client.CSLContextHelper;
import com.kingdee.eas.fi.gr.cslrpt.client.CslClientHelper;
import com.kingdee.eas.fi.gr.cslrpt.util.CSLPermissionUtil;
import com.kingdee.eas.fi.newrpt.RptNewUIUtil;
import com.kingdee.eas.fi.newrpt.client.rptnewui.util.context.WktbContextFactory;
import com.kingdee.eas.fi.rpt.AuditedStatusEnum;
import com.kingdee.eas.fi.rpt.CommittedStatusEnum;
import com.kingdee.eas.fi.rpt.IInitDataFacada;
import com.kingdee.eas.fi.rpt.InitDataFacadaFactory;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.fi.rpt.RptTmpTypeEnum;
import com.kingdee.eas.fi.rpt.TemplateFactory;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.fi.rpt.client.AbstractCopyRptHisDataFilterUI;
import com.kingdee.eas.fi.rpt.client.RptTemplateTreePromptBox;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.JComboBox;
import org.apache.log4j.Logger;

public class CopyRptHisDataFilterUI
extends AbstractCopyRptHisDataFilterUI {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = CoreUIObject.getLogger(CopyRptHisDataFilterUI.class);
    private String selectAll = null;
    private String resClassName = "com.kingdee.eas.fi.gr.cslrpt.RptCommonMsg";
    private Object isSupportOtherDS;
    Map dataCollectMap = new HashMap();
    private String resName = "SelectAll";
    private ICSLContext ctx = null;
    RptTemplateTreePromptBox rptTemplateTreePromptBox;
    int year = 0;
    int period = 0;
    RptPeriodTypeEnum periodType;
    private FullOrgUnitInfo companyInfo = null;
    private boolean isFromReportWorktable = false;
    private OrgType orgType = OrgType.Company;
    boolean isMergeByFiscalPeriod;
    PeriodCollection periodCollection;
    PeriodInfo periodInfo = null;

    public CopyRptHisDataFilterUI() throws Exception {
        this.initLister();
        this.isMergeByFiscalPeriod = FiscalPeriodHelper.isMergeByFiscalPeriod(null);
        this.isSupportOtherDS = CslRptUtil.getParamValue(null, null, (String)"GR_CSL_SupportOtherDS");
        this.init();
        this.comboDataCollect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataCollectInfo dataCollect = (DataCollectInfo)CopyRptHisDataFilterUI.this.comboDataCollect.getSelectedItem();
                CslRptUtil.refresh13PeriodDataCollect((RptPeriodTypeEnum)((RptPeriodTypeEnum)CopyRptHisDataFilterUI.this.comboPeriodType.getSelectedItem()), (String)(dataCollect != null ? dataCollect.getNumber() : "ACTUALDATA"), (Date)((Date)CopyRptHisDataFilterUI.this.repDate.getValue()), (KDSpinner)CopyRptHisDataFilterUI.this.spPeriod);
            }
        });
    }

    public void onLoad() throws Exception {
        super.onLoad();
        if (this.isMergeByFiscalPeriod && RptNewUIUtil.isFiOrgType((OrgType)this.orgType)) {
            IInitDataFacada iInitDataFacada = InitDataFacadaFactory.getRemoteInstance();
            this.periodCollection = iInitDataFacada.getFiscal((IObjectPK)new ObjectUuidPK(this.getCompanyInfo().getId()));
            this.periodInfo = iInitDataFacada.getCurrentFiscal((IObjectPK)new ObjectUuidPK(this.getCompanyInfo().getId()));
            FiscalPeriodHelper.refreshAndAddListeners((boolean)this.isMergeByFiscalPeriod, (KDComboBox)this.comboPeriodType, (KDSpinner)this.spYear, (KDSpinner)this.spPeriod, (KDDatePicker)this.repDate, (PeriodCollection)this.periodCollection);
            this.comboPeriodType.setSelectedItem((Object)RptPeriodTypeEnum.MONTHLY);
            this.spYear.setValue((Object)new Integer(this.periodInfo.getPeriodYear()));
            this.spPeriod.setValue((Object)new Integer(this.periodInfo.getPeriodNumber()));
        }
    }

    private void init() throws Exception {
        int i;
        this.ctx = CSLContextHelper.getCSLContext();
        this.selectAll = EASResource.getString((String)this.resClassName, (String)this.resName);
        this.comboPeriodType.removeAllItems();
        ItemListener[] itemListeners = this.comboPeriodType.getItemListeners();
        if (itemListeners != null) {
            for (i = 0; i < itemListeners.length; ++i) {
                this.comboPeriodType.removeItemListener(itemListeners[i]);
            }
        }
        this.comboPeriodType.addItems(RptPeriodTypeEnum.getEnumList().toArray());
        if (itemListeners != null) {
            for (i = 0; i < itemListeners.length; ++i) {
                this.comboPeriodType.addItemListener(itemListeners[i]);
            }
        }
        if (this.isFromReportWorktable) {
            RptPeriodTypeEnum wktype = WktbContextFactory.getInstance().getRptContext(this.orgType).getQueryPeriodType();
            if (wktype != null) {
                this.comboPeriodType.setSelectedItem((Object)wktype);
            } else {
                this.comboPeriodType.setSelectedItem((Object)RptPeriodTypeEnum.MONTHLY);
            }
        } else {
            this.comboPeriodType.setSelectedItem((Object)RptPeriodTypeEnum.MONTHLY);
        }
        this.spYear.setEnabled(false);
        this.spPeriod.setEnabled(false);
        Calendar cal = Calendar.getInstance();
        if (this.isFromReportWorktable) {
            cal.setTime(WktbContextFactory.getInstance().getRptContext(this.orgType).getQueryDate());
        }
        if (!this.isFromReportWorktable || !RptPeriodTypeEnum.MONTHLY.equals((Object)WktbContextFactory.getInstance().getRptContext(this.orgType).getQueryPeriodType()) || WktbContextFactory.getInstance().getRptContext(this.orgType).getQueryPeriod() < 13) {
            cal.add(2, -1);
        }
        int lastDay = cal.getActualMaximum(5);
        cal.set(5, lastDay);
        this.repDate.setValue((Object)cal.getTime());
        this.cbxCurrency.removeAllItems();
        CslClientHelper.initCurrencyToCombox((JComboBox)this.cbxCurrency, (boolean)true, (boolean)true);
        this.bizPrmtCompany.setValue((Object)this.getCompanyInfo());
        this.bizPrmtCompany.setEnabled(false);
        this.rptTemplateTreePromptBox = new RptTemplateTreePromptBox((IUIObject)this);
        ArrayList<RptTmpTypeEnum> tempTypelist = new ArrayList<RptTmpTypeEnum>();
        tempTypelist.add(RptTmpTypeEnum.GROUPCOMMREPORT);
        tempTypelist.add(RptTmpTypeEnum.COMMONREPORT);
        tempTypelist.add(RptTmpTypeEnum.RPTDYNAMICREPORT);
        tempTypelist.add(RptTmpTypeEnum.COMMONPUBLICTEMPLATE);
        tempTypelist.add(RptTmpTypeEnum.MULTIRPTDYNAMICREPORT);
        tempTypelist.add((RptTmpTypeEnum)this.orgType);
        this.rptTemplateTreePromptBox.setTempTypeList(tempTypelist);
        this.rptTemplateTreePromptBox.setPeriodType((RptPeriodTypeEnum)this.comboPeriodType.getSelectedItem());
        this.prmtTemplate.setSelector((KDPromptSelector)this.rptTemplateTreePromptBox);
        this.prmtTemplate.setDisplayFormat("$number$--$name$");
        this.prmtTemplate.setEditFormat("$number$");
        this.prmtTemplate.setEditable(false);
        this.comboSourceType.removeAllItems();
        this.comboSourceType.addItem((Object)RptSrcTypeEnum.COMMITREPORT);
        this.comboSourceType.addItem((Object)RptSrcTypeEnum.NORMAL);
        this.comboSourceType.addItem((Object)RptSrcTypeEnum.DYNAMICNORMALREPORT);
        this.comboSourceType.addItem((Object)RptSrcTypeEnum.MULTIDYNAMICNORMALREPORT);
        this.comboSourceType.addItem((Object)this.selectAll);
        this.comboSourceType.setSelectedIndex(0);
        this.comboAuditStatus.removeAllItems();
        this.comboAuditStatus.addItem((Object)this.selectAll);
        this.comboAuditStatus.addItem((Object)AuditedStatusEnum.AUDITED);
        this.comboAuditStatus.addItem((Object)AuditedStatusEnum.UNAUDITED);
        this.comboAuditStatus.setSelectedIndex(1);
        this.comboCommitStatus.removeAllItems();
        this.comboCommitStatus.addItem((Object)"");
        this.comboCommitStatus.addItem((Object)CommittedStatusEnum.COMMITTED);
        this.comboCommitStatus.addItem((Object)CommittedStatusEnum.UNCOMMITTED);
        this.comboCommitStatus.addItem((Object)CommittedStatusEnum.GROUPCOMMITTED);
        this.comboCommitStatus.setSelectedIndex(0);
        if ("true".equals(this.isSupportOtherDS)) {
            DataCollectCollection datacollect = DataCollectFactory.getRemoteInstance().getDataCollectCollection("select * where number in ('ACTUALDATA','BUDGETDATA')");
            this.comboDataCollect.removeAllItems();
            DataCollectInfo acDC = null;
            String curUserId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
            for (int i2 = 0; i2 < datacollect.size(); ++i2) {
                DataCollectInfo dataCollect = datacollect.get(i2);
                this.dataCollectMap.put(dataCollect.getNumber(), dataCollect);
                boolean hasPermission = CSLPermissionUtil.hasDataCollectPermission(null, (String)curUserId, (DataCollectInfo)dataCollect);
                if (!hasPermission) continue;
                this.comboDataCollect.addItem((Object)dataCollect);
                if (!dataCollect.getNumber().equals("ACTUALDATA")) continue;
                acDC = dataCollect;
            }
            if (acDC != null) {
                this.comboDataCollect.setSelectedItem(acDC);
            } else {
                this.comboDataCollect.setSelectedIndex(0);
            }
        } else {
            this.comboDataCollect.setVisible(false);
            this.contDataCollect.setVisible(false);
        }
        this.chkIncludeHisTemplateRpt.setEnabled(false);
    }

    public void initLister() {
        this.prmtTemplate.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                CopyRptHisDataFilterUI.this.prmtTemplateSele();
            }
        });
        this.prmtTemplate.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                CopyRptHisDataFilterUI.this.prmtTemplateChange();
            }
        });
    }

    private void prmtTemplateSele() {
        if (this.rptTemplateTreePromptBox != null && this.bizPrmtCompany.getData() != null) {
            this.rptTemplateTreePromptBox.setCurrCompanyId(((OrgUnitInfo)this.bizPrmtCompany.getData()).getId().toString());
        }
    }

    private void prmtTemplateChange() {
        if (this.prmtTemplate.getData() != null) {
            this.chkIncludeHisTemplateRpt.setEnabled(true);
        } else {
            this.chkIncludeHisTemplateRpt.setEnabled(false);
            this.chkIncludeHisTemplateRpt.setSelected(false);
        }
    }

    public FilterInfo getFilterInfo() {
        Object obj;
        FilterItemInfo filterItemCurrency;
        if (this.filterInfo == null) {
            this.filterInfo = new FilterInfo();
        } else {
            this.filterInfo.getFilterItems().clear();
        }
        int formulaIndex = 0;
        StringBuffer sbFormula = new StringBuffer();
        if (this.bizPrmtCompany.getData() != null) {
            String compId = ((OrgUnitInfo)this.bizPrmtCompany.getData()).getId().toString();
            FilterItemInfo companyFilterItemInfo = new FilterItemInfo("company.id", (Object)compId);
            this.filterInfo.getFilterItems().add(companyFilterItemInfo);
            if (formulaIndex == 0) {
                sbFormula.append("#" + formulaIndex++);
            } else {
                sbFormula.append(" and #" + formulaIndex++);
            }
        }
        if (this.comboPeriodType.getSelectedItem() != null) {
            this.periodType = (RptPeriodTypeEnum)this.comboPeriodType.getSelectedItem();
            FilterItemInfo filterPeriodType = new FilterItemInfo("periodType", (Object)new Integer(this.periodType.getValue()), CompareType.EQUALS);
            this.filterInfo.getFilterItems().add(filterPeriodType);
            sbFormula.append(" and #" + formulaIndex++);
        }
        if (this.spYear.getValue() != null) {
            FilterItemInfo filterYear = new FilterItemInfo("year", (Object)((Integer)this.spYear.getValue()), CompareType.EQUALS);
            this.filterInfo.getFilterItems().add(filterYear);
            sbFormula.append(" and #" + formulaIndex++);
            this.year = (Integer)this.spYear.getValue();
        }
        if (this.spPeriod.getValue() != null) {
            FilterItemInfo filterPeriod = new FilterItemInfo("period", (Object)((Integer)this.spPeriod.getValue()), CompareType.EQUALS);
            this.filterInfo.getFilterItems().add(filterPeriod);
            sbFormula.append(" and #" + formulaIndex++);
            this.period = (Integer)this.spPeriod.getValue();
        }
        if (this.cbxCurrency.getSelectedItem() != null && !this.cbxCurrency.getSelectedItem().equals(this.selectAll)) {
            filterItemCurrency = new FilterItemInfo("currency.id", (Object)((CurrencyInfo)this.cbxCurrency.getSelectedItem()).getId().toString(), CompareType.EQUALS);
            this.filterInfo.getFilterItems().add(filterItemCurrency);
            sbFormula.append(" and #" + formulaIndex++);
        } else if (this.cbxCurrency.getSelectedItem().equals(this.selectAll)) {
            filterItemCurrency = new FilterItemInfo("currency.id", (Object)this.selectAll, CompareType.NOTEQUALS);
            this.filterInfo.getFilterItems().add(filterItemCurrency);
            sbFormula.append(" and #" + formulaIndex++);
        }
        if (this.prmtTemplate.getData() != null) {
            TemplateInfo template = (TemplateInfo)this.prmtTemplate.getData();
            FilterItemInfo filterItem = null;
            if (this.chkIncludeHisTemplateRpt.isSelected()) {
                String group = template.getGroup();
                filterItem = new FilterItemInfo("template.group", (Object)group);
            } else {
                filterItem = new FilterItemInfo("template.id", (Object)template.getId().toString());
            }
            this.filterInfo.getFilterItems().add(filterItem);
            sbFormula.append(" and #" + formulaIndex++);
        }
        if (this.comboSourceType.getSelectedItem() != null) {
            obj = this.comboSourceType.getSelectedItem();
            if (obj instanceof RptSrcTypeEnum) {
                RptSrcTypeEnum srcType = (RptSrcTypeEnum)((Object)obj);
                this.filterInfo.getFilterItems().add(new FilterItemInfo("sourceType", (Object)new Integer(srcType.getValue())));
                sbFormula.append(" and #" + formulaIndex++);
            } else {
                HashSet<Integer> srcTypeSet = new HashSet<Integer>();
                srcTypeSet.add(new Integer(7));
                srcTypeSet.add(new Integer(1));
                srcTypeSet.add(new Integer(10));
                srcTypeSet.add(new Integer(13));
                this.filterInfo.getFilterItems().add(new FilterItemInfo("sourceType", srcTypeSet, CompareType.INCLUDE));
                sbFormula.append(" and #" + formulaIndex++);
            }
        }
        if (this.comboAuditStatus.getSelectedItem() != null && (obj = this.comboAuditStatus.getSelectedItem()) instanceof AuditedStatusEnum) {
            AuditedStatusEnum auditStatus = (AuditedStatusEnum)((Object)obj);
            this.filterInfo.getFilterItems().add(new FilterItemInfo("auditedStatus", (Object)new Integer(auditStatus.getValue())));
            sbFormula.append(" and #" + formulaIndex++);
        }
        if (this.comboCommitStatus.getSelectedItem() != null && (obj = this.comboCommitStatus.getSelectedItem()) instanceof CommittedStatusEnum) {
            CommittedStatusEnum commitStatus = (CommittedStatusEnum)((Object)obj);
            this.filterInfo.getFilterItems().add(new FilterItemInfo("committedStatus", (Object)new Integer(commitStatus.getValue())));
            sbFormula.append(" and #" + formulaIndex++);
        }
        if (this.comboDataCollect.getSelectedItem() != null) {
            if ("true".equals(this.isSupportOtherDS)) {
                this.filterInfo.getFilterItems().add(new FilterItemInfo("dataCollectNumber", (Object)((DataCollectInfo)this.comboDataCollect.getSelectedItem()).getNumber()));
                sbFormula.append(" and #" + formulaIndex++);
            } else {
                this.filterInfo.getFilterItems().add(new FilterItemInfo("dataCollectNumber", (Object)"ACTUALDATA"));
                sbFormula.append(" and #" + formulaIndex++);
            }
        }
        this.filterInfo.getFilterItems().add(new FilterItemInfo("orgType", (Object)this.orgType.getValue()));
        sbFormula.append(" and #" + formulaIndex++);
        this.filterInfo.setMaskString(sbFormula.toString());
        return this.filterInfo;
    }

    private void clearUI() {
        this.prmtTemplate.setData(null);
        try {
            this.init();
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    public void clear() {
        super.clear();
        this.clearUI();
        if (this.isMergeByFiscalPeriod && RptNewUIUtil.isFiOrgType((OrgType)this.orgType)) {
            FiscalPeriodHelper.refreshAndAddListeners((boolean)this.isMergeByFiscalPeriod, (KDComboBox)this.comboPeriodType, (KDSpinner)this.spYear, (KDSpinner)this.spPeriod, (KDDatePicker)this.repDate, (PeriodCollection)this.periodCollection);
            this.spYear.setValue((Object)new Integer(this.periodInfo.getPeriodYear()));
            this.spPeriod.setValue((Object)new Integer(this.periodInfo.getPeriodNumber()));
        }
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        this.clearUI();
        if (this.isMergeByFiscalPeriod) {
            FiscalPeriodHelper.refreshAndAddListeners((boolean)this.isMergeByFiscalPeriod, (KDComboBox)this.comboPeriodType, (KDSpinner)this.spYear, (KDSpinner)this.spPeriod, (KDDatePicker)this.repDate, (PeriodCollection)this.periodCollection);
        }
        super.loadData(entityViewInfo);
        FilterItemCollection currentFilterItemCollection = entityViewInfo.getFilter() == null ? new FilterItemCollection() : entityViewInfo.getFilter().getFilterItems();
        int rYear = 0;
        int rPeriod = 0;
        RptPeriodTypeEnum rPeriodType = null;
        boolean isAuditStatusSelAll = true;
        boolean isCommStatusSelAll = true;
        block6: for (int i = 0; i < currentFilterItemCollection.size(); ++i) {
            FilterItemInfo filterItemInfo = currentFilterItemCollection.get(i);
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("periodType")) {
                Integer iPeriodType = (Integer)filterItemInfo.getCompareValue();
                rPeriodType = RptPeriodTypeEnum.getEnum((int)iPeriodType);
                this.comboPeriodType.setSelectedItem((Object)rPeriodType);
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("year")) {
                Integer iYear = (Integer)filterItemInfo.getCompareValue();
                this.spYear.setValue((Object)iYear);
                rYear = iYear;
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("period")) {
                Integer iPeriod = (Integer)filterItemInfo.getCompareValue();
                this.spPeriod.setValue((Object)iPeriod);
                rPeriod = iPeriod;
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("currency.id")) {
                String currencyId = (String)filterItemInfo.getCompareValue();
                if (currencyId.equals(this.selectAll)) {
                    this.cbxCurrency.setSelectedItem((Object)this.selectAll);
                    continue;
                }
                for (int j = 1; j < this.cbxCurrency.getItemCount(); ++j) {
                    CurrencyInfo currencyInfo = (CurrencyInfo)this.cbxCurrency.getItemAt(j);
                    if (!currencyInfo.getId().toString().equals(currencyId)) continue;
                    this.cbxCurrency.setSelectedIndex(j);
                    continue block6;
                }
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("orgUnit.id")) {
                String companyId = (String)filterItemInfo.getCompareValue();
                try {
                    OrgUnitInfo companyInfo = FullOrgUnitFactory.getRemoteInstance().getOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId));
                    this.bizPrmtCompany.setData((Object)companyInfo);
                }
                catch (Exception e) {
                    this.handUIException(e);
                }
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("template.id")) {
                String templateId = (String)filterItemInfo.getCompareValue();
                if (StringUtils.isEmpty((String)templateId)) continue;
                try {
                    TemplateInfo templateInfo = TemplateFactory.getRemoteInstance().getTemplateInfo((IObjectPK)new ObjectStringPK(templateId));
                    this.prmtTemplate.setData((Object)templateInfo);
                    this.chkIncludeHisTemplateRpt.setSelected(false);
                }
                catch (Exception e) {
                    this.handUIException(e);
                }
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("template.group")) {
                String group = (String)filterItemInfo.getCompareValue();
                try {
                    TemplateInfo templateInfo = TemplateFactory.getRemoteInstance().getTemplateInfo("select * where group = '" + group + "' and versionStatus = 1");
                    this.prmtTemplate.setData((Object)templateInfo);
                    this.chkIncludeHisTemplateRpt.setSelected(true);
                }
                catch (Exception e) {
                    this.handUIException(e);
                }
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("sourceType")) {
                if (filterItemInfo.getCompareValue() instanceof Integer) {
                    Integer srcType = (Integer)filterItemInfo.getCompareValue();
                    RptSrcTypeEnum srcTypeEnum = RptSrcTypeEnum.getEnum(srcType);
                    this.comboSourceType.setSelectedItem((Object)srcTypeEnum);
                    continue;
                }
                this.comboSourceType.setSelectedItem((Object)this.selectAll);
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("auditedStatus")) {
                Integer auditStatus = (Integer)filterItemInfo.getCompareValue();
                AuditedStatusEnum auditStatusEnum = AuditedStatusEnum.getEnum(auditStatus);
                this.comboAuditStatus.setSelectedItem((Object)auditStatusEnum);
                isAuditStatusSelAll = false;
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("committedStatus")) {
                Integer commitStatus = (Integer)filterItemInfo.getCompareValue();
                CommittedStatusEnum commitStatusEnum = CommittedStatusEnum.getEnum(commitStatus);
                this.comboCommitStatus.setSelectedItem((Object)commitStatusEnum);
                isCommStatusSelAll = false;
                continue;
            }
            if (!filterItemInfo.getPropertyName().equalsIgnoreCase("dataCollectNumber")) continue;
            String dataCollectNumber = (String)filterItemInfo.getCompareValue();
            DataCollectInfo dataCollect = (DataCollectInfo)this.dataCollectMap.get(dataCollectNumber);
            this.comboDataCollect.setSelectedItem((Object)dataCollect);
        }
        if (isAuditStatusSelAll) {
            this.comboAuditStatus.setSelectedItem((Object)this.selectAll);
        }
        if (isCommStatusSelAll) {
            this.comboCommitStatus.setSelectedItem((Object)this.selectAll);
        }
        if (rPeriodType != null && rYear != 0 && rPeriod != 0) {
            this.repDate.setValue((Object)RPTDateUtil.getPeriodLastDate((int)rYear, (int)rPeriod, rPeriodType));
        }
    }

    @Override
    protected void repDate_dataChanged(DataChangeEvent e) throws Exception {
        if (e != null && e.getNewValue() instanceof Date) {
            this.refreshTimeInfo((Date)e.getNewValue());
        }
    }

    private void refreshTimeInfo(Date newDate) throws BOSException {
        Integer Period;
        RptPeriodTypeEnum p = (RptPeriodTypeEnum)this.comboPeriodType.getSelectedItem();
        if (p == null || newDate == null) {
            return;
        }
        if (this.rptTemplateTreePromptBox != null) {
            this.rptTemplateTreePromptBox.setPeriodType(p);
            this.prmtTemplate.setData(null);
        }
        if (FiscalPeriodHelper.isMergeByFiscalPeriod((boolean)this.isMergeByFiscalPeriod, (RptPeriodTypeEnum)p)) {
            return;
        }
        List times = RPTDateUtil.getRptPeriod((Date)newDate, (RptPeriodTypeEnum)p);
        newDate = (Date)times.get(2);
        this.repDate.setValue((Object)newDate);
        if (this.spPeriod.getValue() != null && (Period = (Integer)this.spPeriod.getValue()) != 13) {
            this.spPeriod.setValue((Object)new Integer(times.get(1).toString()));
        }
        this.spYear.setValue((Object)new Integer(times.get(0).toString()));
        this.setPeriodForJT13(times);
    }

    @Override
    protected void comboPeriodType_itemStateChanged(ItemEvent e) throws Exception {
        if (this.repDate.getValue() == null) {
            return;
        }
        this.refreshTimeInfo((Date)this.repDate.getValue());
    }

    public boolean verify() {
        if (this.repDate.getValue() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)CslRptUtil.getString((String)"inputRptDate"));
            return false;
        }
        return super.verify();
    }

    private void setPeriodForJT13(List times) throws BOSException {
        CslRptUtil.setPeriodForJT13((List)times, (Date)((Date)this.repDate.getValue()), (RptPeriodTypeEnum)((RptPeriodTypeEnum)this.comboPeriodType.getSelectedItem()), (KDSpinner)this.spPeriod, (int)new Integer(times.get(1).toString()));
        String dataCollectNumber = this.comboDataCollect.getSelectedItem() != null ? ((DataCollectInfo)this.comboDataCollect.getSelectedItem()).getNumber() : "ACTUALDATA";
        CslRptUtil.refresh13PeriodDataCollect((RptPeriodTypeEnum)((RptPeriodTypeEnum)this.comboPeriodType.getSelectedItem()), (String)dataCollectNumber, (Date)((Date)this.repDate.getValue()), (KDSpinner)this.spPeriod);
    }

    public FullOrgUnitInfo getCompanyInfo() {
        if (this.companyInfo == null) {
            return SysContext.getSysContext().getCurrentFIUnit().castToFullOrgUnitInfo();
        }
        return this.companyInfo;
    }

    public void setCompanyInfo(FullOrgUnitInfo companyInfo) {
        this.companyInfo = companyInfo;
    }

    public void isFromReportWorktable() {
        this.isFromReportWorktable = true;
    }

    public void setOrgType(OrgType orgType) {
        this.orgType = orgType;
    }
}

