/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetEvent;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.BizEnumValueDTO;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.DataCollectInfo;
import com.kingdee.eas.fi.gr.cslrpt.FiscalPeriodHelper;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.gr.cslrpt.client.CslClientHelper;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.gr.cslrpt.client.ShowEditorPanelUI;
import com.kingdee.eas.fi.newrpt.RptNewUIUtil;
import com.kingdee.eas.fi.newrpt.client.rptnewui.util.context.WktbContextFactory;
import com.kingdee.eas.fi.rpt.IInitDataFacada;
import com.kingdee.eas.fi.rpt.IReport;
import com.kingdee.eas.fi.rpt.ITemplate;
import com.kingdee.eas.fi.rpt.InitDataFacadaFactory;
import com.kingdee.eas.fi.rpt.ReportFactory;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.RptTmpTypeEnum;
import com.kingdee.eas.fi.rpt.TemplateFactory;
import com.kingdee.eas.fi.rpt.client.AbstractCopyRptHisDataListUI;
import com.kingdee.eas.fi.rpt.client.CopyRptHisDataFilterUI;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class CopyRptHisDataListUI
extends AbstractCopyRptHisDataListUI {
    private static final Logger logger = CoreUIObject.getLogger(CopyRptHisDataListUI.class);
    private Object isSupportOtherDS;
    boolean isMergeByFiscalPeriod;
    CommonQueryDialog conditionDialog = null;
    protected CopyRptHisDataFilterUI conditionPanel = null;
    final Map groupTempMap = new HashMap();
    final List tempTypeList = new ArrayList();
    int selectYear = 0;
    int selectPeriod = 0;
    private OrgType orgType = OrgType.Company;

    public CopyRptHisDataListUI() throws Exception {
        this.isSupportOtherDS = CslRptUtil.getParamValue(null, null, (String)"GR_CSL_SupportOtherDS");
        this.isMergeByFiscalPeriod = FiscalPeriodHelper.isMergeByFiscalPeriod(null);
        this.tblMain.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                int size = CopyRptHisDataListUI.this.tblMain.getRowCount();
                for (int rowIndex = size - 1; rowIndex >= 0; --rowIndex) {
                    IRow row = CopyRptHisDataListUI.this.tblMain.getRow(rowIndex);
                    CopyRptHisDataListUI.this.fmtPeriod(row);
                    CopyRptHisDataListUI.this.filterGroupTemplate(CopyRptHisDataListUI.this.groupTempMap, row, CopyRptHisDataListUI.this.tempTypeList);
                }
                CopyRptHisDataListUI.this.hideTableCol();
            }
        });
        this.tblMain.getDataRequestManager().setDataRequestMode(0);
    }

    private void initGroupTemplateMap(Map groupTempMap, List tempTypeList) throws EASBizException, BOSException {
        ArrayList<OrgType> typeList = new ArrayList<OrgType>(tempTypeList);
        typeList.add(this.getOrgType());
        IRowSet rowset = ((ITemplate)this.getTemplateBizInterface()).getTreeDispenseData(this.getCompanyId(), false, false, false, typeList, null);
        try {
            while (rowset.next()) {
                String templateNum = rowset.getString("TEMPLATE.NUMBER");
                groupTempMap.put(templateNum, templateNum);
            }
        }
        catch (SQLException ex) {
            this.handUIException(ex);
        }
    }

    protected ICoreBase getTemplateBizInterface() throws BOSException {
        return TemplateFactory.getRemoteInstance();
    }

    public String getCompanyId() {
        return SysContext.getSysContext().getCurrentFIUnit().getId().toString();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnSelectAll.setIcon(EASResource.getIcon((String)"imgTbtn_selectall"));
        this.btnSelectNo.setIcon(EASResource.getIcon((String)"imgTbtn_deleteall"));
        this.btnCopyCreate.setIcon(EASResource.getIcon((String)"imgTbtn_copycreate"));
    }

    public void onLoad() throws Exception {
        this.tempTypeList.add(RptTmpTypeEnum.GROUPCOMMREPORT);
        this.tempTypeList.add(RptTmpTypeEnum.RPTDYNAMICREPORT);
        this.tempTypeList.add(RptTmpTypeEnum.MULTIRPTDYNAMICREPORT);
        this.initGroupTemplateMap(this.groupTempMap, this.tempTypeList);
        this.init();
        super.onLoad();
        this.tblMain.getColumn("select").getStyleAttributes().setLocked(false);
        this.hideButton();
        this.menuBar.setVisible(false);
        this.menuBar.setEnabled(false);
        this.tblMain.checkParsed(false);
        this.initFiscalPeriod();
        if (this.actionRelationDiagram != null) {
            this.actionRelationDiagram.setVisible(false);
            this.actionRelationDiagram.setEnabled(false);
        }
    }

    private void initFiscalPeriod() throws BOSException, EASBizException {
        if (this.isMergeByFiscalPeriod && RptNewUIUtil.isFiOrgType((OrgType)this.orgType)) {
            IInitDataFacada iInitDataFacada = InitDataFacadaFactory.getRemoteInstance();
            PeriodInfo periodInfo = iInitDataFacada.getCurrentFiscal((IObjectPK)new ObjectUuidPK(this.getCompanyId()));
            FiscalPeriodHelper.refreshAndAddListeners((boolean)this.isMergeByFiscalPeriod, (KDComboBox)this.comboPeriodType, (KDSpinner)this.spnYear, (KDSpinner)this.spnPeriod, (KDDatePicker)this.pkRptDate, (PeriodCollection)iInitDataFacada.getFiscal((IObjectPK)new ObjectUuidPK(this.getCompanyId())));
            this.spnYear.setValue((Object)new Integer(periodInfo.getPeriodYear()));
            this.spnPeriod.setValue((Object)new Integer(periodInfo.getPeriodNumber()));
        }
    }

    private void init() throws Exception {
        this.comboPeriodType.removeAllItems();
        this.comboPeriodType.addItems(RptPeriodTypeEnum.getEnumList().toArray());
        this.comboPeriodType.setSelectedItem((Object)RptPeriodTypeEnum.MONTHLY);
        this.spnYear.setEnabled(false);
        this.spnPeriod.setEnabled(false);
        Calendar cal = Calendar.getInstance();
        if (RptNewUIUtil.isFromWorkTable((Map)this.getUIContext())) {
            cal.setTime(WktbContextFactory.getInstance().getRptContext(this.orgType).getQueryDate());
        }
        this.pkRptDate.setValue((Object)cal.getTime());
        if (RptNewUIUtil.isFromWorkTable((Map)this.getUIContext())) {
            this.spnPeriod.setValue((Object)WktbContextFactory.getInstance().getRptContext(this.orgType).getQueryPeriod());
        }
    }

    private void filterGroupTemplate(Map groupTempMap, IRow row, List tempTypeList) {
        Object number = row.getCell("template.number").getValue();
        BizEnumValueDTO rptTmpTypeDTO = (BizEnumValueDTO)row.getCell("template.templateType").getValue();
        RptTmpTypeEnum rptTmpType = null;
        if (rptTmpTypeDTO != null) {
            rptTmpType = RptTmpTypeEnum.getEnum(rptTmpTypeDTO.getInt());
        }
        if (number == null || rptTmpType == null) {
            return;
        }
        if (tempTypeList.contains((Object)rptTmpType) && !groupTempMap.keySet().contains(number)) {
            this.tblMain.removeRow(row.getRowIndex());
        }
    }

    private void hideTableCol() {
        this.tblMain.getColumn("id").getStyleAttributes().setHided(true);
        this.tblMain.getColumn("year").getStyleAttributes().setHided(true);
        this.tblMain.getColumn("period").getStyleAttributes().setHided(true);
        this.tblMain.getColumn("company.id").getStyleAttributes().setHided(true);
    }

    protected void tblMain_doRequestRowSet(RequestRowSetEvent e) {
        IRowSet rowSet = null;
        try {
            rowSet = ((IReport)this.getBizInterface()).getCopyReport(this.mainQuery, this.mainQueryPK, 0, Integer.MAX_VALUE);
            this.tblMain.getDataRequestManager().setDataRequestMode(0);
            this.tblMain.setRowCount(rowSet.size());
            this.processAllIdList(this.getQueryExecutor(this.mainQueryPK, this.mainQuery), rowSet);
            e.setRowSet(rowSet);
            this.onGetRowSet(rowSet);
        }
        catch (Exception ex) {
            e.setRowSet(null);
            this.setTableGetDataException(ex);
        }
    }

    public static String scrambReportPeriod(Object periodType, Object year, Object period, Object date) {
        String s = null;
        int type = -1;
        if (periodType == null) {
            return s;
        }
        if (periodType instanceof BizEnumValueInfo) {
            type = ((BizEnumValueInfo)periodType).getInt();
        } else if (periodType instanceof RptPeriodTypeEnum) {
            type = ((RptPeriodTypeEnum)periodType).getValue();
        }
        switch (type) {
            case 1: {
                int yearInt = (Integer)year;
                int periodInt = (Integer)period;
                Calendar cal = Calendar.getInstance();
                cal.set(yearInt, 0, 0);
                cal.add(5, periodInt);
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                s = sdf.format(cal.getTime());
                break;
            }
            case 2: {
                s = year.toString() + RptUtil.getResourceSince51("Yearthen") + period.toString() + RptUtil.getResourceSince51("Week");
                break;
            }
            case 3: {
                s = year.toString() + RptUtil.getResourceSince51("Yearthen") + period.toString() + RptUtil.getResourceSince51("Period");
                break;
            }
            case 4: {
                s = year.toString() + RptUtil.getResourceSince51("Yearthen") + period.toString() + RptUtil.getResourceSince51("Quarterly");
                break;
            }
            case 5: {
                s = year.toString() + RptUtil.getResourceSince51("Year") + ((Integer)period == 1 ? RptUtil.getResourceSince51("Up") : RptUtil.getResourceSince51("Down")) + RptUtil.getResourceSince51("Halfyear");
                break;
            }
            case 6: {
                s = year.toString() + RptUtil.getResourceSince51("Year");
                break;
            }
        }
        return s;
    }

    public void hideButton() {
        this.actionAddNew.setEnabled(false);
        this.actionAddNew.setVisible(false);
        this.actionView.setEnabled(false);
        this.actionView.setVisible(false);
        this.actionEdit.setEnabled(false);
        this.actionEdit.setVisible(false);
        this.actionRemove.setEnabled(false);
        this.actionRemove.setVisible(false);
        this.actionLocate.setEnabled(false);
        this.actionLocate.setVisible(false);
        this.actionPrint.setEnabled(false);
        this.actionPrint.setVisible(false);
        this.actionPrintPreview.setEnabled(false);
        this.actionPrintPreview.setVisible(false);
        this.actionPageSetup.setEnabled(false);
        this.actionPageSetup.setVisible(false);
        this.actionVoucher.setEnabled(false);
        this.actionVoucher.setVisible(false);
        this.actionVoucher.setEnabled(false);
        this.actionVoucher.setVisible(false);
        this.actionCreateTo.setEnabled(false);
        this.actionCreateTo.setVisible(false);
        this.actionCreateTo.setEnabled(false);
        this.actionCreateTo.setVisible(false);
        this.actionTraceDown.setEnabled(false);
        this.actionTraceDown.setVisible(false);
        this.actionAuditResult.setEnabled(false);
        this.actionAuditResult.setVisible(false);
        this.actionCopyTo.setEnabled(false);
        this.actionCopyTo.setVisible(false);
        this.actionDelVoucher.setVisible(false);
        this.actionDelVoucher.setEnabled(false);
        this.actionTraceUp.setVisible(false);
        this.actionTraceUp.setEnabled(false);
        this.actionNextPerson.setVisible(false);
        this.actionNextPerson.setEnabled(false);
        this.actionAttachment.setEnabled(false);
        this.actionAttachment.setVisible(false);
        this.actionNextPerson.setVisible(false);
        this.actionCopyCreate.setEnabled(true);
        this.actionSelectAll.setEnabled(true);
        this.actionSelectNo.setEnabled(true);
        this.actionRefresh.setEnabled(true);
        this.actionRefresh.setVisible(true);
        this.actionMultiapprove.setVisible(false);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
    }

    protected boolean initDefaultFilter() {
        return true;
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        this.tblMain.getDataRequestManager().setDataRequestMode(0);
        super.actionQuery_actionPerformed(e);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                RptPeriodTypeEnum periodType = null;
                try {
                    Date rptDate;
                    periodType = CopyRptHisDataListUI.this.getConditionPanel().periodType;
                    if (periodType != null) {
                        CopyRptHisDataListUI.this.comboPeriodType.setSelectedItem((Object)periodType);
                    }
                    if ((rptDate = (Date)CopyRptHisDataListUI.this.pkRptDate.getValue()) != null) {
                        CopyRptHisDataListUI.this.refreshTimeInfo(rptDate);
                    }
                }
                catch (Exception e) {
                    logger.error((Object)"actionQuery", (Throwable)e);
                }
            }
        });
        if ("true".equals(this.isSupportOtherDS)) {
            this.tblMain.getColumn("dataCollect.name").getStyleAttributes().setHided(false);
        } else {
            this.tblMain.getColumn("dataCollect.name").getStyleAttributes().setHided(true);
        }
        SorterItemCollection coll = new SorterItemCollection();
        coll = this.mainQuery.getSorter();
        if (coll == null || coll.size() == 0) {
            coll.add(new SorterItemInfo("sourceType"));
            coll.add(new SorterItemInfo("template.number"));
            this.mainQuery.setSorter(coll);
            this.tblMain.removeRows();
        }
    }

    protected boolean isAllowDefaultSolutionNull() {
        return false;
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected EntityViewInfo getInitDefaultSolution() {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("company.id", (Object)SysContext.getSysContext().getCurrentFIUnit().getId().toString(), CompareType.EQUALS));
        Calendar cal = Calendar.getInstance();
        cal.add(2, -1);
        List times = RPTDateUtil.getRptPeriod((Date)cal.getTime(), (RptPeriodTypeEnum)RptPeriodTypeEnum.MONTHLY);
        this.selectYear = (Integer)times.get(0);
        try {
            if (RPTDateUtil.isYearLastPeriod((Date)((Date)this.getConditionPanel().repDate.getValue()), (RptPeriodTypeEnum)RptPeriodTypeEnum.MONTHLY) && CslRptUtil.isSupport13Period(null)) {
                RptPeriodTypeEnum cfr_ignored_0 = this.getConditionPanel().periodType;
                this.selectPeriod = (Integer)times.get(1) + 1;
            } else {
                this.selectPeriod = (Integer)times.get(1);
            }
        }
        catch (Exception e) {
            logger.debug((Object)e.getMessage());
        }
        fic.add(new FilterItemInfo("year", (Object)new Integer(this.selectYear), CompareType.EQUALS));
        fic.add(new FilterItemInfo("period", (Object)new Integer(this.selectPeriod), CompareType.EQUALS));
        fic.add(new FilterItemInfo("periodType", (Object)new Integer(3), CompareType.EQUALS));
        CurrencyInfo naturalCurrency = CslClientHelper.getCUNaturalCurrency();
        if (naturalCurrency != null) {
            String naturalCurrencyId = naturalCurrency.getId().toString();
            fic.add(new FilterItemInfo("currency.id", (Object)naturalCurrencyId));
        }
        fic.add(new FilterItemInfo("sourceType", (Object)new Integer(7)));
        fic.add(new FilterItemInfo("auditedStatus", (Object)new Integer(2)));
        fic.add(new FilterItemInfo("dataCollectNumber", (Object)"ACTUALDATA", CompareType.EQUALS));
        fic.add(new FilterItemInfo("convertStatus", (Object)new Integer(0), CompareType.EQUALS));
        return view;
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        if (this.conditionDialog != null) {
            return this.conditionDialog;
        }
        this.conditionDialog = new CommonQueryDialog();
        this.conditionDialog.setOwner((Component)((Object)this));
        MetaDataPK mainQueryPK1 = new MetaDataPK("com.kingdee.eas.fi.rpt.app", "ReportQueryForCopyRptHisData");
        this.conditionDialog.setQueryObjectPK((IMetaDataPK)mainQueryPK1);
        this.conditionDialog.setShowFilter(false);
        this.conditionDialog.setShowSorter(true);
        this.conditionDialog.setWidth(455);
        this.conditionDialog.setHeight(360);
        this.conditionDialog.setUiObject((IUIObject)this);
        try {
            this.conditionDialog.addUserPanel((KDPanel)this.getConditionPanel());
        }
        catch (Exception e) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"No_FilterUI"));
        }
        this.conditionDialog.setParentUIClassName(this.getMetaDataPK().getFullName());
        return this.conditionDialog;
    }

    public CopyRptHisDataFilterUI getConditionPanel() throws Exception {
        if (this.conditionPanel == null) {
            this.conditionPanel = new CopyRptHisDataFilterUI();
            this.conditionPanel.setPanelName(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Title_Condition"));
        }
        return this.conditionPanel;
    }

    @Override
    public void actionSelectAll_actionPerformed(ActionEvent e) throws Exception {
        super.actionSelectAll_actionPerformed(e);
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            this.tblMain.getRow(i).getCell("select").setValue((Object)new Boolean(true));
        }
    }

    @Override
    public void actionSelectNo_actionPerformed(ActionEvent e) throws Exception {
        super.actionSelectNo_actionPerformed(e);
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            this.tblMain.getRow(i).getCell("select").setValue((Object)new Boolean(false));
        }
    }

    private String getPermissionName() {
        return OrgType.Company.equals((Object)this.getOrgType()) ? "rpt_report_addnew" : "prof_rpt_update";
    }

    @Override
    public void actionCopyCreate_actionPerformed(ActionEvent e) throws Exception {
        if (!RptUtil.hasPermission(null, this.getCompanyId(), this.getPermissionName())) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResource", (String)"no_permission"));
            SysUtil.abort();
        }
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            String id;
            Object value = this.tblMain.getRow(i).getCell("select").getValue();
            if (value == null || !value.equals(new Boolean(true)) || list.contains(id = this.tblMain.getRow(i).getCell("id").getValue().toString())) continue;
            list.add(id);
        }
        if (list.size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"chooseAtLeastOneRecord"));
            SysUtil.abort();
        }
        if (this.getConditionPanel().year != 0 && this.getConditionPanel().period != 0) {
            this.selectYear = this.getConditionPanel().year;
            this.selectPeriod = this.getConditionPanel().period;
        }
        int genYear = (Integer)this.spnYear.getValue();
        int genPeriod = (Integer)this.spnPeriod.getValue();
        if (this.selectYear == genYear && this.selectPeriod == genPeriod) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"cannotCopyCurPeriodRpt"));
            SysUtil.abort();
        }
        HashMap<String, Integer> paramMap = new HashMap<String, Integer>();
        paramMap.put("year", new Integer(genYear));
        paramMap.put("period", new Integer(genPeriod));
        paramMap.put("pathColl", (Integer)this.getUIContext().get("pathColl"));
        Map resultMap = ReportFactory.getRemoteInstance().copyHisRpt(list, paramMap);
        if (resultMap != null && !resultMap.isEmpty()) {
            boolean hasTmplMsg;
            Integer c = (Integer)resultMap.get("successCount");
            List fl = (List)resultMap.get("faultRptList");
            List tfl = (List)resultMap.get("faultTmplList");
            boolean hasDupMsg = fl != null && fl.size() > 0;
            boolean bl = hasTmplMsg = tfl != null && tfl.size() > 0;
            if (hasDupMsg || hasTmplMsg) {
                StringBuffer sb = new StringBuffer();
                if (hasDupMsg) {
                    sb.append(c);
                    sb.append(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"copyRptSuccess"));
                    if (hasDupMsg) {
                        sb.append("<br><br>");
                        sb.append(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"copyResultCslDup"));
                        sb.append("<br><br>");
                        for (String s : fl) {
                            sb.append(s);
                            sb.append("<br>");
                        }
                    }
                }
                if (hasTmplMsg) {
                    if (!hasDupMsg) {
                        sb.append(c);
                        sb.append(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"copyRptSuccess"));
                    }
                    sb.append("<br><br>");
                    sb.append(EASResource.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"389_CopyRptHisDataListUI"));
                    sb.append("<br><br>");
                    for (String s : tfl) {
                        sb.append(s);
                        sb.append("<br>");
                    }
                }
                UIContext uiCtx = new UIContext((Object)this);
                uiCtx.put((Object)"String", (Object)sb.toString());
                uiCtx.put((Object)"reportSystem", (Object)new Boolean(true));
                this.showMessage();
                if (sb.toString().length() > 0) {
                    IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(ShowEditorPanelUI.class.getName(), (Map)uiCtx, null, OprtState.VIEW);
                    ((ShowEditorPanelUI)uiWindow.getUIObject()).setUITitle(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"copyRptResultUITitle"));
                    uiWindow.show();
                }
            } else {
                String msg = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.cslcommon.CSLCOMMONAutoGenerateResource", (String)"24_CopyGroupRptHisDataListUI");
                this.setMessageText(MessageFormat.format(msg, c));
                this.showMessage();
            }
            if (c > 0) {
                this.refresh(e);
            }
        }
    }

    protected ICoreBase getBizInterface() throws Exception {
        return ReportFactory.getRemoteInstance();
    }

    protected String getEditUIName() {
        return null;
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getType() != 0 && e.getClickCount() == 2 && e.getRowIndex() > -1) {
            IRow row = this.tblMain.getRow(e.getRowIndex());
            if (row == null) {
                return;
            }
            Boolean value = (Boolean)row.getCell("select").getValue();
            this.tblMain.getRow(e.getRowIndex()).getCell("select").setValue((Object)new Boolean(value == false));
        } else {
            int i;
            ArrayList<String> listID = new ArrayList<String>();
            if (this.isOrderForClickTableHead() && e.getType() == 0 && e.getButton() == 1 && e.getClickCount() == 1) {
                for (i = 0; i < this.tblMain.getRowCount(); ++i) {
                    Object value = this.tblMain.getRow(i).getCell("select").getValue();
                    if (value == null || !value.equals(new Boolean(true))) continue;
                    String id = this.tblMain.getRow(i).getCell("id").getValue().toString();
                    listID.add(id);
                }
            }
            super.tblMain_tableClicked(e);
            if (this.isOrderForClickTableHead() && e.getType() == 0 && e.getButton() == 1 && e.getClickCount() == 1) {
                for (i = 0; i < this.tblMain.getRowCount(); ++i) {
                    String id = this.tblMain.getRow(i).getCell("id").getValue().toString();
                    if (id == null || !listID.contains(id)) continue;
                    this.tblMain.getRow(i).getCell("select").setValue((Object)true);
                }
            }
        }
    }

    public boolean destroyWindow() {
        Object owner = this.getUIContext().get("Owner");
        try {
            if (owner instanceof ListUI) {
                ((ListUI)owner).actionRefresh_actionPerformed(null);
            }
        }
        catch (Exception e) {
            super.handUIException((Throwable)e);
        }
        return super.destroyWindow();
    }

    private void fmtPeriod(IRow row) {
        ICell cell = null;
        Object value = null;
        ICell type = row.getCell("periodType");
        cell = row.getCell("yearPeriod");
        if (type == null || cell == null) {
            return;
        }
        value = type.getValue();
        if (value != null && value instanceof BizEnumValueInfo) {
            Object y = row.getCell("year").getValue();
            Object p = row.getCell("period").getValue();
            String s = CopyRptHisDataListUI.scrambReportPeriod(value, y, p, row.getCell("yearPeriod").getValue());
            cell.setValue((Object)s);
        }
    }

    @Override
    protected void pkRptDate_dataChanged(DataChangeEvent e) throws Exception {
        if (e != null && e.getNewValue() instanceof Date) {
            this.refreshTimeInfo((Date)e.getNewValue());
        }
    }

    private void refreshTimeInfo(Date newDate) throws Exception {
        RptPeriodTypeEnum p = (RptPeriodTypeEnum)this.comboPeriodType.getSelectedItem();
        if (p == null) {
            return;
        }
        if (FiscalPeriodHelper.isMergeByFiscalPeriod((boolean)this.isMergeByFiscalPeriod, (RptPeriodTypeEnum)p)) {
            return;
        }
        List times = RPTDateUtil.getRptPeriod((Date)newDate, (RptPeriodTypeEnum)p);
        Integer year = new Integer(times.get(0).toString());
        this.spnYear.setValue((Object)year);
        this.setPeriodForJT13(times);
        this.pkRptDate.setValue(times.get(2));
    }

    private void setPeriodForJT13(List times) throws BOSException {
        int minVal = 12;
        int maxVal = 13;
        int period = 0;
        RptPeriodTypeEnum rptPeriodTypeEnum = (RptPeriodTypeEnum)this.comboPeriodType.getSelectedItem();
        int periodType = rptPeriodTypeEnum == null ? 0 : rptPeriodTypeEnum.getValue();
        int periodTem = new Integer(this.spnPeriod.getValue().toString());
        int temPeriod = new Integer(times.get(1).toString());
        period = periodTem == 13 ? periodTem : temPeriod;
        boolean isActualData = true;
        try {
            String dataCollectNumber;
            if (this.getConditionPanel() != null && this.getConditionPanel().comboDataCollect != null && this.getConditionPanel().comboDataCollect.getSelectedItem() != null && (dataCollectNumber = ((DataCollectInfo)this.getConditionPanel().comboDataCollect.getSelectedItem()).getNumber()) != null && dataCollectNumber.equals("BUDGETDATA")) {
                isActualData = false;
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        boolean isSupport13Period = CslRptUtil.isSupport13Period(null);
        if (isActualData && RPTDateUtil.isYearLastPeriod((Date)((Date)this.pkRptDate.getValue()), (RptPeriodTypeEnum)RptPeriodTypeEnum.MONTHLY) && isSupport13Period && 3 == periodType) {
            this.spnPeriod.setEnabled(true);
            CslRptUIUtil.setSpineRange((KDSpinner)this.spnPeriod, (int)minVal, (int)maxVal);
            if (period == 13 || period == 12) {
                this.spnPeriod.setValue((Object)new Integer(period));
            } else {
                if (RPTDateUtil.isYearLastPeriod((Date)((Date)this.pkRptDate.getValue()), (RptPeriodTypeEnum)RptPeriodTypeEnum.MONTHLY) && isSupport13Period && 3 == periodType) {
                    this.spnPeriod.setEnabled(true);
                } else {
                    this.spnPeriod.setEnabled(false);
                }
                this.spnPeriod.setValue((Object)new Integer(times.get(1).toString()));
            }
        } else {
            this.spnPeriod.setEnabled(false);
            this.spnPeriod.setValue((Object)new Integer(times.get(1).toString()));
            CslRptUIUtil.setSpineRange((KDSpinner)this.spnPeriod, (int)0, (int)365);
        }
    }

    protected BOSObjectType getBOSObjectType() {
        return null;
    }

    public void setOrgType(OrgType orgType) {
        this.orgType = orgType;
    }

    public OrgType getOrgType() {
        return this.orgType;
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }

    protected String[] getNotOrderColumns() {
        return new String[]{"sel"};
    }
}

