/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.client;

import com.kingdee.eas.fi.rpt.client.IDataStore;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.RandomAccessFile;

public class DataStore
implements IDataStore {
    private String path = null;
    private BufferedOutputStream out = null;
    private RandomAccessFile rfile = null;
    boolean isOpen = false;
    private boolean idAppendMode;

    @Override
    public void write(String str) throws Exception {
        if (!this.isOpen) {
            this.open();
        }
        if (this.idAppendMode) {
            this.rfile.write(str.getBytes());
        } else {
            this.out.write(str.getBytes());
        }
    }

    @Override
    public void open() throws Exception {
        if (this.path == null) {
            throw new Exception(RptUtil.getResourceSince51("NeedFileName"));
        }
        if (this.idAppendMode) {
            this.rfile = new RandomAccessFile(this.path, "rw");
            this.rfile.seek(this.rfile.length());
        } else {
            this.out = new BufferedOutputStream(new FileOutputStream(new File(this.path)));
        }
        this.isOpen = true;
    }

    @Override
    public void close() throws Exception {
        if (this.idAppendMode) {
            if (this.rfile != null) {
                this.rfile.close();
            }
        } else if (this.out != null) {
            this.out.close();
        }
        this.isOpen = false;
    }

    @Override
    public void setPath(String path) {
        this.path = path;
    }

    @Override
    public void setSaveMode(boolean isAppend) {
        this.idAppendMode = isAppend;
    }
}

