/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.client;

import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.rpt.client.AbstractExportNameRuleUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ExportNameRuleUI
extends AbstractExportNameRuleUI {
    public static final int NameRuleCondition_UnitNumber = 1;
    public static final int NameRuleCondition_UnitName = 2;
    public static final int NameRuleCondition_TemplateNumber = 3;
    public static final int NameRuleCondition_TemplateName = 4;
    public static final int NameRuleCondition_ReportNumber = 5;
    public static final int NameRuleCondition_ReportName = 6;
    public static final int NameRuleCondition_RptVersion = 7;
    public static final int NameRuleCondition_Year = 8;
    public static final int NameRuleCondition_Period = 9;
    public static final int NameRuleCondition_Currency = 10;
    public static final int NameRuleCondition_Time = 11;
    public static final int NameRuleCondition_SolidValue = 12;
    private ExportNameRule nameRule;
    private List colAll = new ArrayList();
    private List colSelect = new ArrayList();
    private boolean isCancel = false;
    private boolean isExportOneFile = false;
    private NameRuleCondition unitNumber = null;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnAdd.setIcon(EASResource.getIcon((String)"imgTbtn_move_right"));
        this.btnDel.setIcon(EASResource.getIcon((String)"imgTbtn_move_left"));
        this.btnUp.setIcon(EASResource.getIcon((String)"imgTbtn_movetop"));
        this.btnDown.setIcon(EASResource.getIcon((String)"imgTbtn_movedown"));
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.txtSolid.setEnabled(false);
        this.actionAdd.setEnabled(true);
        this.actionDel.setEnabled(true);
        this.actionUp.setEnabled(true);
        this.actionDown.setEnabled(true);
        this.actionOK.setEnabled(true);
        this.actionCancel.setEnabled(true);
        this.comboOperator.addItem((Object)" ");
        this.comboOperator.addItem((Object)"-");
        this.comboOperator.addItem((Object)"_");
        this.comboOperator.addItem((Object)".");
        this.nameRule = (ExportNameRule)this.getUIContext().get("nameRule");
        if (this.nameRule == null) {
            this.nameRule = new ExportNameRule();
        }
        this.comboOperator.setSelectedItem((Object)this.nameRule.getOperator());
        this.isExportOneFile = (Boolean)this.getUIContext().get("isExportOneFile");
        this.initCondition();
        this.loadCondition();
    }

    private void initCondition() {
        HashMap<Integer, NameRuleCondition> tmpMap = new HashMap<Integer, NameRuleCondition>();
        this.unitNumber = new NameRuleCondition();
        this.unitNumber.setNumber(1);
        this.unitNumber.setName(CslRptUtil.getString((String)"UnitNumber"));
        if (this.nameRule.isHasUnitNumber()) {
            tmpMap.put(new Integer(1), this.unitNumber);
        } else {
            this.colAll.add(this.unitNumber);
        }
        NameRuleCondition condition = new NameRuleCondition();
        condition.setNumber(2);
        condition.setName(CslRptUtil.getString((String)"Unit_Name"));
        if (this.nameRule.isHasUnitName()) {
            tmpMap.put(new Integer(2), condition);
        } else {
            this.colAll.add(condition);
        }
        condition = new NameRuleCondition();
        condition.setNumber(3);
        condition.setName(CslRptUtil.getString((String)"TemplateNumber"));
        if (this.nameRule.isHasTemplateNumber()) {
            tmpMap.put(new Integer(3), condition);
        } else {
            this.colAll.add(condition);
        }
        condition = new NameRuleCondition();
        condition.setNumber(4);
        condition.setName(CslRptUtil.getString((String)"TemplateName1"));
        if (this.nameRule.isHasTemplateName()) {
            tmpMap.put(new Integer(4), condition);
        } else {
            this.colAll.add(condition);
        }
        condition = new NameRuleCondition();
        condition.setNumber(6);
        condition.setName(EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResource.rptName"));
        if (this.nameRule.isHasReportName()) {
            tmpMap.put(new Integer(6), condition);
        } else {
            this.colAll.add(condition);
        }
        condition = new NameRuleCondition();
        condition.setNumber(5);
        condition.setName(EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResource.rptNum"));
        if (this.nameRule.isHasReportNumber()) {
            tmpMap.put(new Integer(5), condition);
        } else {
            this.colAll.add(condition);
        }
        if (this.getUIContext().containsKey("isCslRpt")) {
            condition = new NameRuleCondition();
            condition.setNumber(7);
            condition.setName(EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResource.rptVersion"));
            if (this.nameRule.isHasRptVersion()) {
                tmpMap.put(new Integer(7), condition);
            } else {
                this.colAll.add(condition);
            }
        }
        condition = new NameRuleCondition();
        condition.setNumber(8);
        condition.setName(CslRptUtil.getString((String)"Year"));
        if (this.nameRule.isHasYear()) {
            tmpMap.put(new Integer(8), condition);
        } else {
            this.colAll.add(condition);
        }
        condition = new NameRuleCondition();
        condition.setNumber(9);
        condition.setName(CslRptUtil.getString((String)"Period"));
        if (this.nameRule.isHasPeriod()) {
            tmpMap.put(new Integer(9), condition);
        } else {
            this.colAll.add(condition);
        }
        condition = new NameRuleCondition();
        condition.setNumber(10);
        condition.setName(CslRptUtil.getString((String)"Currency"));
        if (this.nameRule.isHasCurrency()) {
            tmpMap.put(new Integer(10), condition);
        } else {
            this.colAll.add(condition);
        }
        condition = new NameRuleCondition();
        condition.setNumber(11);
        condition.setName(CslRptUtil.getString((String)"Systime"));
        if (this.nameRule.isHasTime()) {
            tmpMap.put(new Integer(11), condition);
        } else {
            this.colAll.add(condition);
        }
        condition = new NameRuleCondition();
        condition.setNumber(12);
        condition.setName(CslRptUtil.getString((String)"SolidValue"));
        if (this.nameRule.isHasSolidValue()) {
            tmpMap.put(new Integer(12), condition);
            this.txtSolid.setEnabled(true);
            this.txtSolid.setText(this.nameRule.getSolidValue());
        } else {
            this.colAll.add(condition);
            this.txtSolid.setEnabled(false);
            this.txtSolid.setText(null);
        }
        Map order = this.nameRule.getOrder();
        for (int i = 0; i < order.size(); ++i) {
            Integer number = (Integer)order.get(new Integer(i));
            if (tmpMap.get(number) == null) continue;
            this.colSelect.add(tmpMap.get(number));
        }
        this.handleExportOneFile();
    }

    private void handleExportOneFile() {
        if (this.isExportOneFile) {
            ArrayList<Integer> includeCols = new ArrayList<Integer>();
            includeCols.add(1);
            includeCols.add(11);
            includeCols.add(12);
            this.removeRule(includeCols, this.colAll);
            this.removeRule(includeCols, this.colSelect);
            if (this.colSelect.isEmpty()) {
                this.colSelect.add(this.unitNumber);
                this.colAll.remove(this.unitNumber);
                this.nameRule.getOrder().clear();
                this.nameRule.getOrder().put(0, this.unitNumber.getNumber());
            }
        }
    }

    private void removeRule(List<Integer> inCols, List targetList) {
        NameRuleCondition condition = null;
        for (int i = 0; i < targetList.size(); ++i) {
            condition = (NameRuleCondition)targetList.get(i);
            if (condition == null || inCols.contains(condition.getNumber())) continue;
            targetList.remove(condition);
            --i;
        }
    }

    private void loadCondition() {
        int i;
        this.lstAllWords.removeAllElements();
        this.lstSelectWords.removeAllElements();
        Collections.sort(this.colAll);
        for (i = 0; i < this.colAll.size(); ++i) {
            this.lstAllWords.addElement(this.colAll.get(i));
        }
        for (i = 0; i < this.colSelect.size(); ++i) {
            this.lstSelectWords.addElement(this.colSelect.get(i));
        }
    }

    @Override
    public void actionAdd_actionPerformed(ActionEvent e) throws Exception {
        super.actionAdd_actionPerformed(e);
        Object[] objs = this.lstAllWords.getSelectedValues();
        for (int i = 0; i < objs.length; ++i) {
            NameRuleCondition condition = (NameRuleCondition)objs[i];
            this.colAll.remove(condition);
            this.colSelect.add(condition);
            if (condition.getNumber() != 12) continue;
            this.txtSolid.setEnabled(true);
        }
        this.loadCondition();
    }

    @Override
    public void actionDel_actionPerformed(ActionEvent e) throws Exception {
        super.actionDel_actionPerformed(e);
        Object[] objs = this.lstSelectWords.getSelectedValues();
        for (int i = 0; i < objs.length; ++i) {
            NameRuleCondition condition = (NameRuleCondition)objs[i];
            this.colSelect.remove(condition);
            this.colAll.add(condition);
            if (condition.getNumber() != 12) continue;
            this.txtSolid.setEnabled(false);
        }
        this.loadCondition();
    }

    @Override
    public void actionUp_actionPerformed(ActionEvent e) throws Exception {
        super.actionUp_actionPerformed(e);
        int n = this.lstSelectWords.getElementCount();
        int selectIndex = this.lstSelectWords.getSelectedIndex();
        if (n != 0 && selectIndex > 0 && selectIndex < n) {
            Collections.swap(this.colSelect, selectIndex, selectIndex - 1);
        }
        this.loadCondition();
        if (n != 0 && selectIndex > 0 && selectIndex < n) {
            this.lstSelectWords.setSelectedIndex(selectIndex - 1);
        }
    }

    @Override
    public void actionDown_actionPerformed(ActionEvent e) throws Exception {
        super.actionDown_actionPerformed(e);
        int n = this.lstSelectWords.getElementCount();
        int selectRow = this.lstSelectWords.getSelectedIndex();
        if (n != 0 && selectRow >= 0 && selectRow < n - 1) {
            Collections.swap(this.colSelect, selectRow, selectRow + 1);
        }
        this.loadCondition();
        if (n != 0 && selectRow >= 0 && selectRow < n - 1) {
            this.lstSelectWords.setSelectedIndex(selectRow + 1);
        }
    }

    @Override
    public void actionOK_actionPerformed(ActionEvent e) throws Exception {
        super.actionOK_actionPerformed(e);
        if (this.colSelect.isEmpty()) {
            MsgBox.showWarning((Component)((Object)this), (String)CslRptUtil.getString((String)"SelectedConditionIsNull"));
            return;
        }
        this.nameRule = new ExportNameRule();
        String oper = (String)this.comboOperator.getSelectedItem();
        if (oper == null) {
            oper = " ";
        }
        this.nameRule.setOperator(oper);
        Map order = this.nameRule.getOrder();
        block14: for (int i = 0; i < this.colSelect.size(); ++i) {
            NameRuleCondition condition = (NameRuleCondition)this.colSelect.get(i);
            if (condition == null) continue;
            int number = condition.getNumber();
            order.put(new Integer(i), new Integer(number));
            switch (number) {
                case 1: {
                    this.nameRule.setHasUnitNumber(true);
                    continue block14;
                }
                case 2: {
                    this.nameRule.setHasUnitName(true);
                    continue block14;
                }
                case 3: {
                    this.nameRule.setHasTemplateNumber(true);
                    continue block14;
                }
                case 4: {
                    this.nameRule.setHasTemplateName(true);
                    continue block14;
                }
                case 5: {
                    this.nameRule.setHasReportNumber(true);
                    continue block14;
                }
                case 6: {
                    this.nameRule.setHasReportName(true);
                    continue block14;
                }
                case 8: {
                    this.nameRule.setHasYear(true);
                    continue block14;
                }
                case 9: {
                    this.nameRule.setHasPeriod(true);
                    continue block14;
                }
                case 10: {
                    this.nameRule.setHasCurrency(true);
                    continue block14;
                }
                case 11: {
                    this.nameRule.setHasTime(true);
                    continue block14;
                }
                case 12: {
                    this.nameRule.setHasSolidValue(true);
                    this.nameRule.setSolidValue(this.txtSolid.getText());
                    continue block14;
                }
                case 7: {
                    this.nameRule.setHasRptVersion(true);
                }
            }
        }
        this.destroyWindow();
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancel_actionPerformed(e);
        this.isCancel = true;
        this.destroyWindow();
    }

    public ExportNameRule getResult() {
        return this.nameRule;
    }

    public boolean isCancel() {
        return this.isCancel;
    }

    public class ExportNameRule {
        private boolean hasUnitNumber;
        private boolean hasUnitName;
        private boolean hasTemplateNumber;
        private boolean hasTemplateName;
        private boolean hasReportNumber;
        private boolean hasReportName;
        private boolean hasRptVersion;
        private boolean hasYear;
        private boolean hasPeriod;
        private boolean hasCurrency;
        private boolean hasTime;
        private boolean hasSolidValue;
        private String solidValue;
        private Map order = new HashMap();
        private String operator;

        public void clearSelected() {
            this.setHasCurrency(false);
            this.setHasPeriod(false);
            this.setHasSolidValue(false);
            this.setHasTemplateName(false);
            this.setHasReportNumber(false);
            this.setHasTemplateNumber(false);
            this.setHasTime(false);
            this.setHasUnitNumber(false);
            this.setHasUnitName(false);
            this.setHasYear(false);
            this.setHasRptVersion(false);
        }

        public boolean isHasCurrency() {
            return this.hasCurrency;
        }

        public void setHasCurrency(boolean hasCurrency) {
            this.hasCurrency = hasCurrency;
        }

        public boolean isHasPeriod() {
            return this.hasPeriod;
        }

        public void setHasPeriod(boolean hasPeriod) {
            this.hasPeriod = hasPeriod;
        }

        public boolean isHasSolidValue() {
            return this.hasSolidValue;
        }

        public void setHasSolidValue(boolean hasSolidValue) {
            this.hasSolidValue = hasSolidValue;
        }

        public boolean isHasTemplateName() {
            return this.hasTemplateName;
        }

        public boolean isHasReportName() {
            return this.hasReportName;
        }

        public boolean isHasReportNumber() {
            return this.hasReportNumber;
        }

        public void setHasTemplateName(boolean hasTemplateName) {
            this.hasTemplateName = hasTemplateName;
        }

        public void setHasReportNumber(boolean hasTemplateName) {
            this.hasReportNumber = hasTemplateName;
        }

        public void setHasReportName(boolean hasTemplateName) {
            this.hasReportName = hasTemplateName;
        }

        public boolean isHasTemplateNumber() {
            return this.hasTemplateNumber;
        }

        public void setHasTemplateNumber(boolean hasTemplateNumber) {
            this.hasTemplateNumber = hasTemplateNumber;
        }

        public boolean isHasTime() {
            return this.hasTime;
        }

        public void setHasTime(boolean hasTime) {
            this.hasTime = hasTime;
        }

        public boolean isHasUnitNumber() {
            return this.hasUnitNumber;
        }

        public void setHasUnitNumber(boolean hasUnitNumber) {
            this.hasUnitNumber = hasUnitNumber;
        }

        public boolean isHasUnitName() {
            return this.hasUnitName;
        }

        public void setHasUnitName(boolean hasUnitName) {
            this.hasUnitName = hasUnitName;
        }

        public boolean isHasYear() {
            return this.hasYear;
        }

        public void setHasYear(boolean hasYear) {
            this.hasYear = hasYear;
        }

        public String getSolidValue() {
            return this.solidValue;
        }

        public void setSolidValue(String solidValue) {
            this.solidValue = solidValue;
        }

        public Map getOrder() {
            return this.order;
        }

        public String getOperator() {
            return this.operator;
        }

        public void setOperator(String operator) {
            this.operator = operator;
        }

        public boolean isHasRptVersion() {
            return this.hasRptVersion;
        }

        public void setHasRptVersion(boolean hasRptVersion) {
            this.hasRptVersion = hasRptVersion;
        }
    }

    private class NameRuleCondition
    implements Comparable {
        private int number;
        private String name;

        private NameRuleCondition() {
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public int getNumber() {
            return this.number;
        }

        public void setNumber(int number) {
            this.number = number;
        }

        public String toString() {
            return this.name;
        }

        public int compareTo(Object o) {
            if (o == null) {
                return 1;
            }
            NameRuleCondition obj = (NameRuleCondition)o;
            return this.number - obj.getNumber();
        }
    }
}

