/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.cslrpt.CslReportFactory;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.gr.cslrpt.SumRptAddedPerportyFactory;
import com.kingdee.eas.fi.gr.cslrpt.SumRptAddedPerportyInfo;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.gr.cslrpt.client.SimpleNotePad;
import com.kingdee.eas.fi.rpt.ReportBaseInfo;
import com.kingdee.eas.fi.rpt.ReportCollection;
import com.kingdee.eas.fi.rpt.ReportFactory;
import com.kingdee.eas.fi.rpt.ReportInfo;
import com.kingdee.eas.fi.rpt.client.AbstractExportUI;
import com.kingdee.eas.fi.rpt.client.ExportNameRuleUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class ExportUI
extends AbstractExportUI {
    private static final Logger logger = CoreUIObject.getLogger(ExportUI.class);
    private static ExportNameRuleUI.ExportNameRule nameRule;
    private ExportNameRuleUI ruleUI = null;
    private int exportValueType = -1;

    public void onLoad() throws Exception {
        super.onLoad();
        this.setUITitle(EASResource.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"108_ExportUI"));
        this.kDWorkButton1.setEnabled(true);
        this.kDWorkButton2.setEnabled(true);
        this.kDWorkButton3.setEnabled(true);
        this.kDWorkButton4.setEnabled(true);
        this.kDWorkButton1.setIcon(EASResource.getIcon((String)"imgTbtn_initialize"));
        this.kDWorkButton2.setIcon(EASResource.getIcon((String)"imgTbtn_check"));
    }

    @Override
    public void actionBAmeRule_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        if (nameRule != null) {
            uiContext.put((Object)"nameRule", (Object)nameRule);
        }
        uiContext.put((Object)"isExportOneFile", (Object)this.exportOneFile.isSelected());
        if (this.getUIContext().containsKey("isCslRpt")) {
            uiContext.put((Object)"isCslRpt", (Object)((Boolean)this.getUIContext().get("isCslRpt")));
        }
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(ExportNameRuleUI.class.getName(), (Map)uiContext);
        uiWindow.show();
        this.ruleUI = (ExportNameRuleUI)uiWindow.getUIObject();
        if (!this.ruleUI.isCancel()) {
            nameRule = this.ruleUI.getResult();
        }
    }

    @Override
    public void actionBorse_actionPerformed(ActionEvent e) throws Exception {
        KDFileChooser chooser = new KDFileChooser();
        chooser.setDialogTitle(EASResource.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"109_ExportUI"));
        chooser.setFileSelectionMode(1);
        int result = chooser.showOpenDialog((Component)((Object)this));
        if (result == 0) {
            File file = chooser.getSelectedFile();
            String fileName = file.getAbsolutePath();
            this.kDTextField1.setText(fileName);
        }
    }

    @Override
    public void actionCanel_actionPerformed(ActionEvent e) throws Exception {
        this.disposeUIWindow();
    }

    @Override
    public void actionOK_actionPerformed(ActionEvent e) throws Exception {
        Map msg;
        if (nameRule == null || nameRule.getOrder() == null || nameRule.getOrder().isEmpty()) {
            MsgBox.showWarning((Component)((Object)this), (String)CslRptUtil.getString((String)"NameRuleIsNull"));
            return;
        }
        String path = this.kDTextField1.getText();
        if (StringUtils.isEmpty((String)path)) {
            MsgBox.showWarning((Component)((Object)this), (String)CslRptUtil.getString((String)"FilePathIsInvalid"));
            return;
        }
        this.exportValueType = CslRptUIUtil.getExportValueType((Object)((Object)this));
        if (this.exportValueType < 0) {
            return;
        }
        File file = new File(path);
        if (file.exists()) {
            if (!file.isDirectory()) {
                MsgBox.showWarning((Component)((Object)this), (String)CslRptUtil.getString((String)"FilePathIsInvalid"));
                return;
            }
        } else {
            file.mkdir();
        }
        StringBuffer error = new StringBuffer();
        List<ReportBaseInfo> c = this.getReports();
        int count = 0;
        Map map = msg = this.exportOneFile.isSelected() ? this.exportReportToOneFile(c) : this.exportReport(c);
        if (msg.containsKey("SuccessCount")) {
            count += ((Integer)msg.get("SuccessCount")).intValue();
        }
        if (msg.containsKey("FailMsg")) {
            error.append(msg.get("FailMsg"));
        }
        this.disposeUIWindow();
        StringBuffer msgStr = new StringBuffer(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.cslcommon.CSLCOMMONAutoGenerateResource", (String)"19_BatchExportSchemeListUI"));
        if (error.length() > 0) {
            UIContext ctx = new UIContext((Object)this);
            ctx.put((Object)"Title", (Object)EASResource.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"110_ExportUI"));
            ctx.put((Object)"ShowOpen", (Object)Boolean.FALSE);
            ctx.put((Object)"needReplace", (Object)Boolean.FALSE);
            SimpleNotePad.showMessageByModel((UIContext)ctx, (String)(MessageFormat.format(msgStr.toString(), count) + "\n\n" + error.toString()));
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)MessageFormat.format(msgStr.toString(), count));
        }
    }

    public List<ReportBaseInfo> getReports() throws BOSException {
        int i;
        ReportCollection col;
        ArrayList list = (ArrayList)this.getUIContext().get("all");
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("*"));
        view.getSelector().add(new SelectorItemInfo("company.*"));
        view.getSelector().add(new SelectorItemInfo("template.number"));
        view.getSelector().add(new SelectorItemInfo("template.name"));
        view.getSelector().add(new SelectorItemInfo("currency.name"));
        view.getSelector().add(new SelectorItemInfo("orgUnit.id"));
        view.getSelector().add(new SelectorItemInfo("orgUnit.number"));
        view.getSelector().add(new SelectorItemInfo("orgUnit.name"));
        HashSet<String> set = new HashSet<String>();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            if (list.get(i2) instanceof ReportInfo) {
                set.add(((ReportInfo)list.get(i2)).getId().toString());
                continue;
            }
            if (!(list.get(i2) instanceof String)) continue;
            set.add((String)list.get(i2));
        }
        view.setFilter(new FilterInfo());
        view.getFilter().getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
        HashMap<String, Object> reportMap = new HashMap<String, Object>();
        if (this.getUIContext().get("isCslRpt") != null && ((Boolean)this.getUIContext().get("isCslRpt")).booleanValue()) {
            col = CslReportFactory.getRemoteInstance().getCslReportCollection(view);
            for (i = 0; i < col.size(); ++i) {
                reportMap.put(col.get(i).getId().toString(), col.get(i));
            }
        } else {
            col = ReportFactory.getRemoteInstance().getReportCollection(view);
            for (i = 0; i < col.size(); ++i) {
                reportMap.put(col.get(i).getId().toString(), col.get(i));
            }
        }
        ReportBaseInfo reportInfo = null;
        String rptId = null;
        ArrayList<ReportBaseInfo> reports = new ArrayList<ReportBaseInfo>();
        for (Object curRpt : list) {
            if (curRpt instanceof ReportInfo) {
                rptId = ((ReportInfo)curRpt).getId().toString();
            } else if (curRpt instanceof String) {
                rptId = (String)curRpt;
            }
            if ((reportInfo = (ReportBaseInfo)reportMap.get(rptId)) == null) continue;
            reports.add(reportInfo);
        }
        return reports;
    }

    private Map exportReport(List<ReportBaseInfo> reports) {
        StringBuffer fail = new StringBuffer();
        int count = 0;
        HashSet<String> nameSet = new HashSet<String>();
        for (ReportBaseInfo info : reports) {
            String fileName;
            try {
                fileName = this.makeFileName(info);
            }
            catch (Exception e2) {
                this.addFailMsg(fail, info, e2.getMessage());
                continue;
            }
            File file = new File(fileName);
            if (nameSet.contains(fileName) || file.exists()) {
                String msg = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.cslcommon.CSLCOMMONAutoGenerateResource", (String)"20_BatchExportSchemeListUI");
                this.addFailMsg(fail, info, MessageFormat.format(msg, fileName));
                continue;
            }
            Book book = null;
            try {
                book = info.getBook();
            }
            catch (Exception e1) {
                this.addFailMsg(fail, info, EASResource.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"116_ExportUI"));
                continue;
            }
            if (book == null) {
                this.addFailMsg(fail, info, EASResource.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"117_ExportUI"));
                continue;
            }
            book.setCalculate(false);
            try {
                CslRptUIUtil.exportToExcel2007((Book)book, (String)fileName, (int)this.exportValueType);
                nameSet.add(fileName);
            }
            catch (Exception e) {
                logger.error((Object)"error:", (Throwable)e);
                this.addFailMsg(fail, info, EASResource.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"118_ExportUI"));
                continue;
            }
            ++count;
        }
        nameSet.clear();
        CslRptUIUtil.exportToExcel2007After();
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (fail.length() > 0) {
            map.put("FailMsg", fail.toString());
        }
        map.put("SuccessCount", new Integer(count));
        return map;
    }

    private String makeFileName(ReportBaseInfo report) throws Exception {
        Map order = nameRule.getOrder();
        String oper = nameRule.getOperator();
        StringBuffer fileName = new StringBuffer();
        String separator = File.separator;
        fileName.append(this.kDTextField1.getText()).append(separator);
        String companyNumber = report.getCompany().getNumber();
        String companyName = report.getCompany().getName();
        if (report instanceof CslReportInfo) {
            CslReportInfo cslReport = (CslReportInfo)report;
            companyNumber = cslReport.getOrgUnit().getNumber();
            companyName = cslReport.getOrgUnit().getName();
        }
        block14: for (int i = 0; i < order.size(); ++i) {
            int condNumber = (Integer)order.get(new Integer(i));
            switch (condNumber) {
                case 1: {
                    fileName.append(companyNumber);
                    if (companyNumber.indexOf("/") >= 0 || companyNumber.indexOf("\\") >= 0) {
                        throw new Exception(EASResource.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"119_ExportUI"));
                    }
                    if (companyNumber.matches(".*[\\/:*?\"<>|].*")) {
                        throw new Exception(EASResource.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"119_ExportUI"));
                    }
                    fileName.append(oper);
                    continue block14;
                }
                case 2: {
                    fileName.append(companyName);
                    if (companyName.indexOf("/") >= 0 || companyName.indexOf("\\") >= 0) {
                        throw new Exception(EASResource.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"119_ExportUI"));
                    }
                    if (companyName.matches(".*[\\/:*?\"<>|].*")) {
                        throw new Exception(EASResource.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"119_ExportUI"));
                    }
                    fileName.append(oper);
                    continue block14;
                }
                case 3: {
                    if (report.getTemplate() == null) {
                        throw new Exception(EASResource.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"120_ExportUI"));
                    }
                    if (report.getTemplate().getNumber().indexOf("/") >= 0 || report.getTemplate().getNumber().indexOf("\\") >= 0) {
                        throw new Exception(EASResource.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"119_ExportUI"));
                    }
                    if (report.getTemplate().getNumber().matches(".*[\\/:*?\"<>|].*")) {
                        throw new Exception(EASResource.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"119_ExportUI"));
                    }
                    fileName.append(report.getTemplate().getNumber());
                    fileName.append(oper);
                    continue block14;
                }
                case 4: {
                    if (report.getTemplate() == null) {
                        throw new Exception(EASResource.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"121_ExportUI"));
                    }
                    if (report.getTemplate().getName().indexOf("/") >= 0 || report.getTemplate().getName().indexOf("\\") >= 0) {
                        throw new Exception(EASResource.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"119_ExportUI"));
                    }
                    if (report.getTemplate().getName().matches(".*[\\/:*?\"<>|].*")) {
                        throw new Exception(EASResource.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"119_ExportUI"));
                    }
                    fileName.append(report.getTemplate().getName());
                    fileName.append(oper);
                    continue block14;
                }
                case 5: {
                    fileName.append(report.getNumber());
                    if (report.getNumber().indexOf("/") >= 0 || report.getNumber().indexOf("\\") >= 0) {
                        throw new Exception(EASResource.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"119_ExportUI"));
                    }
                    if (report.getNumber().matches(".*[\\/:*?\"<>|].*")) {
                        throw new Exception(EASResource.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"119_ExportUI"));
                    }
                    fileName.append(oper);
                    continue block14;
                }
                case 6: {
                    if (report.getName().indexOf("/") >= 0 || report.getName().indexOf("\\") >= 0) {
                        throw new Exception(EASResource.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"119_ExportUI"));
                    }
                    if (report.getName().matches(".*[\\/:*?\"<>|].*")) {
                        throw new Exception(EASResource.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"119_ExportUI"));
                    }
                    fileName.append(report.getName());
                    fileName.append(oper);
                    continue block14;
                }
                case 8: {
                    fileName.append(report.getYear());
                    fileName.append(oper);
                    continue block14;
                }
                case 9: {
                    fileName.append(report.getPeriod());
                    fileName.append(oper);
                    continue block14;
                }
                case 10: {
                    if (report.getCurrency().getName().indexOf("/") >= 0 || report.getCurrency().getName().indexOf("\\") >= 0) {
                        throw new Exception(EASResource.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"119_ExportUI"));
                    }
                    if (report.getCurrency().getName().matches(".*[\\/:*?\"<>|].*")) {
                        throw new Exception(EASResource.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"119_ExportUI"));
                    }
                    fileName.append(report.getCurrency().getName());
                    fileName.append(oper);
                    continue block14;
                }
                case 11: {
                    fileName.append(RPTDateUtil.formateDate((Date)new Date(), (String)"yyyy-MM-dd"));
                    fileName.append(oper);
                    continue block14;
                }
                case 12: {
                    if (nameRule.getSolidValue().indexOf("/") >= 0 || nameRule.getSolidValue().indexOf("\\") >= 0) {
                        throw new Exception(EASResource.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"119_ExportUI"));
                    }
                    if (nameRule.getSolidValue().matches(".*[\\/:*?\"<>|].*")) {
                        throw new Exception(EASResource.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"119_ExportUI"));
                    }
                    fileName.append(nameRule.getSolidValue());
                    fileName.append(oper);
                    continue block14;
                }
                case 7: {
                    String rptid = report.getId().toString();
                    SumRptAddedPerportyInfo info = SumRptAddedPerportyFactory.getRemoteInstance().getSumRptAddedPerportyInfo("select version where report = '" + rptid + "'");
                    int version = info.getVersion();
                    fileName.append(version);
                    fileName.append(oper);
                }
            }
        }
        int length = fileName.length();
        fileName.delete(length - oper.length(), length);
        fileName.append(".xlsx");
        return fileName.toString();
    }

    private void addFailMsg(StringBuffer fail, ReportBaseInfo report, String error) {
        if (report.getName() != null) {
            fail.append(report.getName()).append(" ");
        }
        if (report.getTemplate() != null) {
            fail.append(report.getTemplate().getName()).append(" ");
        }
        fail.append(report.getCompany().getName()).append(" ");
        fail.append(report.getYear()).append(EASResource.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"276_ExportUI"));
        fail.append(report.getPeriod()).append(EASResource.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"277_ExportUI"));
        fail.append(report.getPeriodType().getAlias()).append(" ");
        fail.append(report.getCurrency()).append("\n");
        fail.append(error).append("\n");
    }

    private Map exportReportToOneFile(List<ReportBaseInfo> reports) {
        StringBuffer fail = new StringBuffer();
        int reportCount = 0;
        String fileName = null;
        File file = null;
        Book book = null;
        Book curBook = null;
        for (int i = 0; i < reports.size(); ++i) {
            block12: {
                ReportBaseInfo info = reports.get(i);
                try {
                    if (i == 0) {
                        fileName = this.makeFileName(info);
                        file = new File(fileName);
                        if (file.exists()) {
                            this.addFailMsg(fail, info, EASResource.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"114_ExportUI") + fileName + EASResource.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"115_ExportUI"));
                            break;
                        }
                        book = info.getBook();
                        book.setCalculate(false);
                        if (book == null) {
                            book = Book.Manager.getNewBook(null, (int)0);
                            book.setCalculate(false);
                        }
                        break block12;
                    }
                    if (book == null) {
                        book = Book.Manager.getNewBook(null, (int)0);
                        book.setCalculate(false);
                    }
                    if ((curBook = info.getBook()) == null) break block12;
                    for (int k = 0; k < curBook.getSheetCount(); ++k) {
                        book.addSheet(curBook.getSheet(k));
                    }
                }
                catch (Exception e2) {
                    logger.error((Object)"export error", (Throwable)e2);
                    this.addFailMsg(fail, info, e2.getMessage());
                    continue;
                }
            }
            ++reportCount;
        }
        if (book != null && fileName != null) {
            try {
                CslRptUIUtil.exportToExcel2007(book, fileName, (int)this.exportValueType);
                CslRptUIUtil.exportToExcel2007After();
            }
            catch (Exception e) {
                logger.error((Object)"export error", (Throwable)e);
                fail.append(" exportToExcel error:" + e.getMessage()).append("\n\n");
            }
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (fail.length() > 0) {
            map.put("FailMsg", fail.toString());
        }
        map.put("SuccessCount", new Integer(reportCount));
        return map;
    }

    private void deleteMaxRowCol(Book book, ReportInfo info, StringBuffer fail) throws Exception {
        for (int i = 0; i < book.getSheetCount(); ++i) {
            Sheet sheet = book.getSheet(i);
            if (sheet.getMaxColIndex() > 255 || sheet.getMaxRowIndex() > 65535) {
                this.addFailMsg(fail, info, EASResource.getString((String)"com.kingdee.eas.fi.newrpt.RptMenuTextResource", (String)"excel255_65535_OK"));
                try {
                    sheet.getColRange(256, sheet.getMaxColIndex()).delete();
                    sheet.getRowRange(65536, sheet.getMaxRowIndex()).delete();
                    continue;
                }
                catch (Exception e) {
                    this.addFailMsg(fail, info, e.getCause().getMessage());
                    logger.error((Object)"deleteMaxRowCol error", (Throwable)e);
                    throw e;
                }
            }
            if (sheet.getMaxColIndex() != -1 || sheet.getMaxRowIndex() != -1) continue;
            if (book.getSheetCount() == 1) {
                book = null;
                return;
            }
            book.removeSheet(sheet);
            --i;
        }
    }

    @Override
    protected void exportOneFile_itemStateChanged(ItemEvent e) throws Exception {
        if (this.exportOneFile.isSelected()) {
            if (nameRule == null) {
                if (this.ruleUI == null) {
                    this.ruleUI = new ExportNameRuleUI();
                }
                nameRule = this.ruleUI.new ExportNameRuleUI.ExportNameRule();
            } else {
                nameRule.clearSelected();
            }
            nameRule.setOperator(" ");
            nameRule.setHasUnitNumber(true);
            nameRule.getOrder().clear();
            nameRule.getOrder().put(0, 1);
        } else if (nameRule != null) {
            nameRule.clearSelected();
            nameRule.getOrder().clear();
        }
    }
}

