/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.client;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.eas.fi.rpt.TableToolkit;
import com.kingdee.eas.fi.rpt.client.FormulaBatchFill;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.util.List;

public class FillFormulaToTable
implements FormulaBatchFill.IFormulaBatchFill {
    private KDTable table;

    public FillFormulaToTable(KDTable table) {
        this.table = table;
    }

    @Override
    public String getCurrentPoint() {
        if (this.table == null) {
            return "A1";
        }
        int curcol = this.table.getSelectManager().getActiveColumnIndex();
        int currow = this.table.getSelectManager().getActiveRowIndex();
        if (currow >= 0 && curcol >= 0) {
            return TableToolkit.xy2range(curcol, currow);
        }
        return "A1";
    }

    @Override
    public void fill(int startRow, int startCol, List matrix, int type) {
        if (this.table.getStyleAttributes().isLocked()) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResource.BatchFill_Lock_NoFill"));
            SysUtil.abort();
        }
        if (type == 1) {
            this.fill1(startRow, startCol, matrix);
        } else {
            this.fill2(startRow, startCol, matrix);
        }
    }

    private void fill1(int startRow, int startCol, List matrix) {
        for (int i = 0; i < matrix.size(); ++i) {
            IRow row = this.table.getRow(i + startRow);
            List mrow = (List)matrix.get(i);
            for (int j = 0; j < mrow.size(); ++j) {
                String value = (String)mrow.get(j);
                if (value != null && value.startsWith("=")) {
                    row.getCell(startCol + j).setValue(null);
                    row.getCell(startCol + j).setExpressions(value);
                    continue;
                }
                row.getCell(startCol + j).setExpressions(null);
                row.getCell(startCol + j).setValue((Object)value);
            }
        }
    }

    private void fill2(int startRow, int startCol, List matrix) {
        if (matrix.size() < 1) {
            return;
        }
        List list = (List)matrix.get(0);
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            IRow row = this.table.getRow(i + startRow);
            for (int j = 0; j < matrix.size(); ++j) {
                List mrow = (List)matrix.get(j);
                String value = (String)mrow.get(i);
                ICell cell = row.getCell(startCol + j);
                if (cell.getStyleAttributes().isLocked()) continue;
                if (value != null && value.startsWith("=")) {
                    cell.setValue(null);
                    cell.setExpressions(value);
                    continue;
                }
                cell.setExpressions(null);
                cell.setValue((Object)value);
            }
        }
    }
}

