/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.client;

import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.rpt.FormulaHint;
import com.kingdee.eas.fi.rpt.ReportBaseInfo;
import com.kingdee.eas.fi.rpt.ReportException;
import com.kingdee.eas.fi.rpt.RptSheetParamInfo;
import com.kingdee.eas.fi.rpt.client.AcctAcFormulaStructure;
import com.kingdee.eas.fi.rpt.client.AcctExtFormulaStructure;
import com.kingdee.eas.fi.rpt.client.AcctFormulaStructure;
import com.kingdee.eas.fi.rpt.client.CashFlowFormulaStructure;
import com.kingdee.eas.fi.rpt.client.INCashFlowFormulaStructure;
import com.kingdee.eas.fi.rpt.client.IndexFormulaStructure;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.util.StringUtils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class FormulaStructure {
    public String formulaType = null;
    public String formulaBody = null;
    public String formula = null;
    public ReportBaseInfo report = null;
    public RptSheetParamInfo rptSheetParam = null;
    public List parameter = null;
    UIContext uiContext = null;
    protected boolean isCanshow = true;
    public String type;
    public CoreUIObject parentUI;
    public CompanyOrgUnitInfo companyOrg;
    boolean ledgerSuccess = true;
    public Set<String> accountIdSet = new HashSet<String>();
    public String accountNumber = null;
    public Map<String, Map<String, String>> allAccountMap = new HashMap<String, Map<String, String>>();
    public int startLevel = -1;
    public int endLevel = -1;
    private static final Logger logger = CoreUIObject.getLogger(FormulaStructure.class);

    public void setUIContext(UIContext uiContext) {
        this.uiContext = uiContext;
    }

    public UIContext getUIContext() {
        return this.uiContext;
    }

    public FormulaStructure(String sformula) {
        this.formula = sformula;
        StringTokenizer stringTokenizer = new StringTokenizer(this.formula, "(");
        if (stringTokenizer.hasMoreElements()) {
            this.formulaType = stringTokenizer.nextToken();
        }
        if (stringTokenizer.hasMoreElements()) {
            this.formulaBody = stringTokenizer.nextToken();
        }
    }

    public FormulaStructure() {
    }

    public static FormulaStructure getFormulaInstance(FormulaHint hint) {
        FormulaStructure struct = null;
        if (hint.name.equalsIgnoreCase("acct") || hint.name.equalsIgnoreCase("racct")) {
            struct = new AcctFormulaStructure(hint);
        } else if (hint.name.equalsIgnoreCase("acctext")) {
            struct = new AcctExtFormulaStructure(hint);
        } else if (hint.name.equalsIgnoreCase("RptIndex")) {
            struct = new IndexFormulaStructure(hint);
        } else if (hint.name.equalsIgnoreCase("acctac")) {
            struct = new AcctAcFormulaStructure(hint);
        } else if (hint.name.equalsIgnoreCase("acctcash") || hint.name.equalsIgnoreCase("acctcashext")) {
            struct = new CashFlowFormulaStructure(hint);
        } else if (hint.name.equalsIgnoreCase("INcashflow")) {
            struct = new INCashFlowFormulaStructure(hint);
        } else {
            SysUtil.abort((Throwable)new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{RptUtil.getResourceSince51("PleaseChooseFormula2")}));
        }
        return struct;
    }

    public FormulaStructure(FormulaHint hint) {
        this.formulaType = hint.name;
        this.parameter = Arrays.asList(hint.params);
        this.formula = hint.toString();
    }

    public void structure() throws Exception {
    }

    public void openUI() throws Exception {
    }

    public void open() throws Exception {
        this.structure();
        this.openUI();
    }

    public String toString() {
        return this.formula;
    }

    public ReportBaseInfo getReport() {
        return this.report;
    }

    public void setReport(ReportBaseInfo report) {
        this.report = report;
    }

    public RptSheetParamInfo getRptSheetParam() {
        return this.rptSheetParam;
    }

    public void setRptSheetParam(RptSheetParamInfo rptSheetParam) {
        this.rptSheetParam = rptSheetParam;
    }

    public String getFormula() {
        return this.formula;
    }

    public void setFormula(String formula) {
        this.formula = formula;
    }

    public String getFormulaBody() {
        return this.formulaBody;
    }

    public void setFormulaBody(String formulaBody) {
        this.formulaBody = formulaBody;
    }

    public String getFormulaType() {
        return this.formulaType;
    }

    public void setFormulaType(String formulaType) {
        this.formulaType = formulaType;
    }

    public CoreUIObject getParentUI() {
        return this.parentUI;
    }

    public void setParentUI(CoreUIObject parentUI) {
        this.parentUI = parentUI;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public List getParameter() {
        return this.parameter;
    }

    public void setParameter(List parameter) {
        this.parameter = parameter;
    }

    public boolean isCanshow() {
        return this.isCanshow;
    }

    public void getAccountIds(String companyid, String accountTableID, String acctAsstItems) {
        if (StringUtils.isEmpty((String)companyid) || StringUtils.isEmpty((String)accountTableID) || StringUtils.isEmpty((String)acctAsstItems)) {
            return;
        }
        boolean isHasAsst = acctAsstItems.split("\\|").length > 1;
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.getSelector().add(new SelectorItemInfo("id"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("longnumber"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("number"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("isLeaf"));
        entityViewInfo.getSorter().add(new SorterItemInfo("number"));
        FilterInfo filter = new FilterInfo();
        entityViewInfo.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("companyID", (Object)companyid));
        filter.getFilterItems().add(new FilterItemInfo("accountTableID", (Object)accountTableID));
        HashSet<String> set = new HashSet<String>();
        boolean hasConsecutiveAccount = false;
        StringBuffer maskString = new StringBuffer();
        maskString.append(" #0 and #1 ");
        int index = 2;
        StringTokenizer st = new StringTokenizer(acctAsstItems, ";");
        int count = st.countTokens();
        int i = 0;
        while (st.hasMoreTokens()) {
            String[] consecutiveAccount = st.nextToken().split("\\|")[0].split(":");
            if (consecutiveAccount.length == 1) {
                String number = consecutiveAccount[0].split("\\|")[0];
                set.add(number);
                if (hasConsecutiveAccount && i == count - 1) {
                    maskString.append(")");
                }
            } else {
                if (!hasConsecutiveAccount) {
                    maskString.append(" and ((");
                } else {
                    maskString.append(" or (");
                }
                hasConsecutiveAccount = true;
                String beginAccountNumber = consecutiveAccount[0].split("\\|")[0];
                String endAccountNumber = consecutiveAccount[1].split("\\|")[0];
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)beginAccountNumber, CompareType.GREATER_EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)endAccountNumber, CompareType.LESS_EQUALS));
                if (isHasAsst) {
                    filter.getFilterItems().add(new FilterItemInfo("number", (Object)(endAccountNumber + "%"), CompareType.LIKE));
                    maskString.append("#" + index++ + " and #" + index++ + " or #" + index++ + ")");
                } else {
                    maskString.append("#" + index++ + " and #" + index++ + ")");
                }
                if (i == count - 1) {
                    maskString.append(")");
                }
            }
            ++i;
        }
        if (set.size() > 0) {
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)((Object)set).toString(), CompareType.INCLUDE));
            if (hasConsecutiveAccount) {
                maskString = maskString.deleteCharAt(maskString.length() - 1);
                maskString.append(" or (#" + index);
                maskString.append("))");
            } else {
                maskString.append(" and #" + index);
            }
        }
        filter.setMaskString(maskString.toString());
        try {
            AccountViewInfo accountViewInfo;
            HashSet<String> isNotLeafNumberSet = new HashSet<String>();
            AccountViewCollection accountViewCollection = AccountViewFactory.getRemoteInstance().getAccountViewCollection(entityViewInfo);
            for (int i2 = 0; i2 < accountViewCollection.size(); ++i2) {
                accountViewInfo = accountViewCollection.get(i2);
                String longNumber = accountViewInfo.getLongNumber();
                String[] split = longNumber.split("!");
                int level = split.length;
                if (level < this.startLevel || this.startLevel == -1) {
                    this.startLevel = level;
                }
                if (level > this.endLevel || this.endLevel == -1) {
                    this.endLevel = level;
                }
                this.accountIdSet.add(accountViewInfo.getId().toString());
                this.accountNumber = accountViewInfo.getNumber();
                if (accountViewInfo.isIsLeaf()) continue;
                isNotLeafNumberSet.add(accountViewInfo.getNumber());
            }
            if (this.accountIdSet != null && this.accountIdSet.size() > 1 && !isNotLeafNumberSet.isEmpty()) {
                filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("companyID", (Object)companyid));
                filter.getFilterItems().add(new FilterItemInfo("accountTableID", (Object)accountTableID));
                entityViewInfo.setFilter(filter);
                SorterItemCollection sortColl = new SorterItemCollection();
                sortColl.add(new SorterItemInfo("number"));
                entityViewInfo.setSorter(sortColl);
                accountViewCollection = AccountViewFactory.getRemoteInstance().getAccountViewCollection(entityViewInfo);
                block4: for (int i3 = 0; i3 < accountViewCollection.size(); ++i3) {
                    accountViewInfo = accountViewCollection.get(i3);
                    String number = accountViewInfo.getNumber();
                    if (!isNotLeafNumberSet.contains(number)) continue;
                    for (int x = i3 + 1; x < accountViewCollection.size(); ++x) {
                        accountViewInfo = accountViewCollection.get(x);
                        String innerNumber = accountViewInfo.getNumber();
                        if (!innerNumber.startsWith(number)) {
                            i3 = x - 1;
                            continue block4;
                        }
                        this.accountIdSet.add(accountViewInfo.getId().toString());
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"saveConsecutiveAccountId_error", (Throwable)e);
        }
    }
}

