/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.digitalstyle.Format;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gl.WSVoucherCollection;
import com.kingdee.eas.fi.gl.WSVoucherInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.DebitOrCreditEnum;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.rpt.AuditedStatusEnum;
import com.kingdee.eas.fi.rpt.IReportVoucher;
import com.kingdee.eas.fi.rpt.ReportBaseInfo;
import com.kingdee.eas.fi.rpt.ReportVoucherCollection;
import com.kingdee.eas.fi.rpt.ReportVoucherFactory;
import com.kingdee.eas.fi.rpt.ReportVoucherInfo;
import com.kingdee.eas.fi.rpt.client.GenVoucherInfoMappingUI;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.awt.Point;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class GenVoucherUtilForClient {
    private static final Logger logger = CoreUIObject.getLogger(GenVoucherInfoMappingUI.class);
    private boolean measureUnitIsName = false;
    private List<String> measureUnitList = new ArrayList<String>();

    public static GenVoucherUtilForClient getInstance() {
        return new GenVoucherUtilForClient();
    }

    public Map genVoucher(CoreBaseCollection reports) throws Exception {
        IReportVoucher reportVoucher = ReportVoucherFactory.getRemoteInstance();
        ReportVoucherCollection reportVouchers = new ReportVoucherCollection();
        StringBuffer errorMsg = new StringBuffer();
        StringBuffer amountNullMsg = new StringBuffer();
        for (int i = 0; i < reports.size(); ++i) {
            ReportBaseInfo report = (ReportBaseInfo)reports.get(i);
            List<Object> value = this.getRptVoucherInfoAndParmsFromReport(report);
            String[] glParams = reportVoucher.checkVoucherData((ReportVoucherInfo)value.get(0));
            if (glParams == null || glParams[0] != null || glParams[1] != null) {
                boolean glParam;
                boolean bl = glParams[1] == null ? Integer.parseInt(glParams[0]) == 1 : (glParam = Integer.parseInt(glParams[1]) == 1);
                if (glParam) {
                    MsgBox.showConfirm2((String)CslRptUtil.getString((String)"rptVoucherGlParam"));
                    SysUtil.abort();
                }
            }
            reportVouchers.add((ReportVoucherInfo)value.get(0));
            StringBuffer error = (StringBuffer)value.get(1);
            this.appendErrorNumbertip(error, (Map)value.get(3));
            errorMsg.append(error);
            errorMsg.append("\n");
            List amountNullList = (List)value.get(2);
            ArrayList<String> hasAppendNum = new ArrayList<String>();
            if (amountNullList.size() <= 0) continue;
            StringBuffer amountNullVCNumber = new StringBuffer();
            for (WSVoucherInfo info : amountNullList) {
                if (hasAppendNum.contains(info.getVoucherNumber()) || info.getVoucherNumber() == null || info.getVoucherNumber().trim().length() <= 0) continue;
                amountNullVCNumber.append(info.getVoucherNumber());
                hasAppendNum.add(info.getVoucherNumber());
                amountNullVCNumber.append(",");
            }
            amountNullVCNumber.deleteCharAt(amountNullVCNumber.length() - 1);
            amountNullMsg.append(MessageFormat.format(CslRptUtil.getString((String)"amountNullMsg1"), report.getName())).append("\n");
            amountNullMsg.append(amountNullVCNumber).append("\n").append(CslRptUtil.getString((String)"amountIsNull"));
        }
        if (amountNullMsg.length() > 0) {
            amountNullMsg.append(CslRptUtil.getString((String)"amountNullMsg2"));
            if (0 != MsgBox.showConfirm3((String)amountNullMsg.toString())) {
                SysUtil.abort();
            }
        }
        if (errorMsg.toString().trim().length() > 0) {
            MsgBox.showConfirm3a((String)CslRptUtil.getString((String)"rptGenVCFieldIllegal"), (String)errorMsg.toString());
            SysUtil.abort();
        }
        return reportVoucher.generateVoucher(reportVouchers);
    }

    private void appendErrorNumbertip(StringBuffer error, Map<String, String> map) {
        Set<String> keys = map.keySet();
        for (String key : keys) {
            error.append(map.get(key));
        }
    }

    public List<String> prepareGenVoucherReportColumns(KDTable table) throws Exception {
        ArrayList<String> columns = new ArrayList<String>();
        columns.add("id");
        columns.add("auditedStatus");
        List values = CslRptUIUtil.getSelectRowFieldValueForTable((KDTable)table, columns);
        ArrayList<String> rptIds = new ArrayList<String>();
        for (int i = 0; i < values.size(); ++i) {
            Map value = (Map)values.get(i);
            int auditedStatus = ((BizEnumValueInfo)value.get("auditedStatus")).getInt();
            if (auditedStatus != AuditedStatusEnum.AUDITED.getValue()) {
                MsgBox.showConfirm2((String)CslRptUtil.getString((String)"noAudieRptCannotGenVoucher"));
                SysUtil.abort();
            }
            String rptId = (String)value.get("id");
            rptIds.add(rptId);
        }
        return rptIds;
    }

    public String getGenVoucherOql(KDTable table) throws Exception {
        List<String> rptIds = this.prepareGenVoucherReportColumns(table);
        StringBuffer oql = new StringBuffer("select template.id,data,company.number,bookedDate,bizDate,currency.number,name where id in (");
        for (int i = 0; i < rptIds.size(); ++i) {
            oql.append("'");
            oql.append(rptIds.get(i));
            oql.append("'");
            oql.append(",");
        }
        oql.deleteCharAt(oql.length() - 1);
        oql.append(")");
        return oql.toString();
    }

    public List<Object> getRptVoucherInfoAndParmsFromReport(ReportBaseInfo report) throws Exception {
        int i;
        Sheet activeSheet = report.getBook().getActiveSheet();
        int rowCount = activeSheet.getRows().getMaxIntMark() + 1;
        int colCount = activeSheet.getCols().getMaxIntMark() + 1;
        Point point = new Point(0, 0);
        int lastCol = 0;
        block0: for (int i2 = 0; i2 < rowCount; ++i2) {
            for (int j = 0; j < colCount; ++j) {
                Object userObject = activeSheet.getRange(i2, j).getUserObject("fieldsCount");
                if (userObject == null) continue;
                point = new Point(j, i2);
                for (int c = colCount; c >= j; --c) {
                    if (activeSheet.getRange(point.y, j).getUserObject("fieldKey") == null && activeSheet.getRange(point.y + 1, j).getUserObject("fieldKey") == null) continue;
                    lastCol = c;
                    break block0;
                }
            }
        }
        WSVoucherCollection voucherCollection = new WSVoucherCollection();
        int rowIndex = point.y + 2;
        int colIndex = point.x;
        boolean isName = false;
        String vcFieldKey = null;
        Object vcValue = null;
        StringBuffer errorMsg = new StringBuffer();
        HashMap namesMap = new HashMap();
        ArrayList<String> nameFieldKeys = new ArrayList<String>();
        boolean voucherNumIsNull = false;
        ArrayList<WSVoucherInfo> amountNullList = new ArrayList<WSVoucherInfo>();
        HashMap<String, String> showNameMap = new HashMap<String, String>();
        for (i = rowIndex; i < rowCount; ++i) {
            WSVoucherInfo voucherInfo = new WSVoucherInfo();
            Object sheetName = null;
            StringBuffer checkFieldTypeError = null;
            for (int j = colIndex; j < lastCol; ++j) {
                Map<String, String> vcFiledNameMap;
                if (activeSheet.getRange(point.y, j).getUserObject("fieldKey") == null) {
                    if (activeSheet.getRange(point.y + 1, j).getUserObject("fieldKey") == null) continue;
                    vcFieldKey = activeSheet.getRange(point.y + 1, j).getUserObject("fieldKey").toString();
                    isName = activeSheet.getRange(point.y + 1, j).getUserObject("isName") != null;
                } else {
                    vcFieldKey = activeSheet.getRange(point.y, j).getUserObject("fieldKey").toString();
                    boolean bl = isName = activeSheet.getRange(point.y, j).getUserObject("isName") != null;
                }
                if (i == rowIndex) {
                    showNameMap.put(vcFieldKey, activeSheet.getRange(point.y, j).getValue().toString());
                }
                Object object = vcValue = activeSheet.getRange(i, j).getValue() != null ? activeSheet.getRange(i, j).getValue().getValue() : null;
                if ("sheetName".equals(vcFieldKey)) {
                    sheetName = vcValue;
                } else {
                    if (vcValue != null && vcValue.toString().length() > 0 && "measurement".equals(vcFieldKey)) {
                        this.measureUnitList.add(vcValue.toString());
                        this.measureUnitIsName = isName;
                    }
                    if (("bookedDate".equals(vcFieldKey) || "bizDate".equals(vcFieldKey)) && vcValue instanceof String) {
                        vcValue = Format.parseData((String)((String)vcValue), (boolean)true).getValue();
                    }
                    voucherInfo.put(vcFieldKey, vcValue);
                    checkFieldTypeError = this.checkFieldType(i + 1, showNameMap, voucherInfo, vcFieldKey, vcValue);
                    if (!"originalAmount".equals(vcFieldKey)) {
                        errorMsg.append(checkFieldTypeError);
                    } else if (!(checkFieldTypeError != null && checkFieldTypeError.length() != 0 || vcValue == null || "0".equals(vcValue.toString()) || vcValue.toString().trim().length() <= 0)) {
                        voucherCollection.add(voucherInfo);
                    } else {
                        amountNullList.add(voucherInfo);
                    }
                }
                if (!isName || vcValue == null) continue;
                if (!nameFieldKeys.contains(vcFieldKey)) {
                    nameFieldKeys.add(vcFieldKey);
                }
                if (vcFieldKey.startsWith("asstActNumber")) {
                    Object asstActTypeValue = voucherInfo.get("asstActType" + vcFieldKey.charAt(vcFieldKey.length() - 1));
                    if (asstActTypeValue == null) {
                        asstActTypeValue = activeSheet.getRange(i, j + 1).getValue() != null ? activeSheet.getRange(i, j + 1).getValue().getValue() : null;
                    }
                    String string = vcFieldKey = asstActTypeValue != null ? asstActTypeValue.toString() : null;
                }
                if ((vcFiledNameMap = (HashMap)namesMap.get(vcFieldKey)) == null) {
                    vcFiledNameMap = new HashMap();
                    namesMap.put(vcFieldKey, vcFiledNameMap);
                } else {
                    vcFiledNameMap = (Map)namesMap.get(vcFieldKey);
                }
                vcFiledNameMap.put(vcValue.toString(), vcValue.toString());
            }
            for (int x = 1; x <= 8; ++x) {
                Object asstActNumber = voucherInfo.get("asstActNumber" + x);
                Object asstActName = voucherInfo.get("asstActName" + x);
                if (asstActNumber == null && asstActName != null) {
                    voucherInfo.put("asstActNumber" + x, asstActName);
                    continue;
                }
                if (asstActNumber == null || asstActName != null) continue;
                voucherInfo.put("asstActName" + x, asstActNumber);
            }
            voucherNumIsNull = this.setWSVCDefaultValue(voucherInfo, sheetName, report);
            this.checkErrorWSVoucher(voucherInfo, showNameMap, errorMsg, i + 1);
            this.checkMeasureUnit(errorMsg);
            this.measureUnitList = new ArrayList<String>();
        }
        for (i = amountNullList.size() - 1; i >= 0; --i) {
            WSVoucherInfo amountNullVoucherInfo = (WSVoucherInfo)amountNullList.get(i);
            if (amountNullVoucherInfo.getVoucherNumber() == null || amountNullVoucherInfo.getVoucherNumber().trim().length() == 0) {
                amountNullList.remove(amountNullVoucherInfo);
                continue;
            }
            for (int j = 0; j < voucherCollection.size(); ++j) {
                WSVoucherInfo voucherInfo = voucherCollection.get(j);
                if (voucherInfo.getVoucherNumber() != amountNullVoucherInfo.getVoucherNumber()) continue;
                amountNullList.remove(amountNullVoucherInfo);
            }
        }
        ReportVoucherInfo rptVCInfo = new ReportVoucherInfo();
        rptVCInfo.setRptTemplateId(report.getTemplate().getId().toString());
        rptVCInfo.setReportName(report.getName());
        rptVCInfo.setCompanyNumber(report.getCompany().getNumber());
        rptVCInfo.put("companyId", report.getCompany().getId().toString());
        rptVCInfo.setYear(report.getYear());
        rptVCInfo.setPeriod(report.getPeriod());
        rptVCInfo.setSheetId(activeSheet.getID());
        rptVCInfo.setSheetName(activeSheet.getSheetName());
        rptVCInfo.setWSVoucherCollection(voucherCollection);
        HashMap errorNum = new HashMap();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("voucherNumIsNull", voucherNumIsNull);
        params.put("namesMap", namesMap);
        params.put("nameFieldKeys", nameFieldKeys);
        if (voucherNumIsNull) {
            params.put("sheetName", this.getBookSheetNames(report).remove(activeSheet.getNames()));
        }
        rptVCInfo.setParams(params);
        ArrayList<Object> value = new ArrayList<Object>();
        value.add(rptVCInfo);
        value.add(errorMsg);
        value.add(amountNullList);
        value.add(errorNum);
        return value;
    }

    private void checkMeasureUnit(StringBuffer errorMsg) throws EASBizException, BOSException {
        String hasNotData;
        if (this.measureUnitList != null && this.measureUnitList.size() > 0 && (hasNotData = ReportVoucherFactory.getRemoteInstance().getNotMeasureUnitData(this.measureUnitList, this.measureUnitIsName)) != null && hasNotData.length() > 0) {
            hasNotData = MessageFormat.format(CslRptUtil.getString((String)"964_genVoucherMeasureUnit"), hasNotData);
            errorMsg.append(hasNotData);
        }
    }

    private List<String> getBookSheetNames(ReportBaseInfo report) throws Exception {
        ArrayList<String> sheetNames = new ArrayList<String>();
        Book book = report.getBook();
        int sheetCount = book.getSheetCount();
        for (int i = 0; i < sheetCount; ++i) {
            sheetNames.add(book.getSheetName(i));
        }
        return sheetNames;
    }

    private StringBuffer checkErrorWSVoucher(WSVoucherInfo voucherInfo, Map<String, String> map, StringBuffer errorMsg, int rowIndex) {
        StringBuffer errorfieldName = new StringBuffer();
        try {
            if (voucherInfo.getOriginalAmount() == 0.0) {
                return errorMsg;
            }
            if (voucherInfo.getVoucherType() == null || voucherInfo.getVoucherType().trim().length() == 0) {
                errorfieldName.append(map.get("voucherType"));
                errorfieldName.append(",");
            }
            if (voucherInfo.getVoucherNumber() == null || voucherInfo.getVoucherNumber().trim().length() == 0) {
                if (map.get("voucherNumber") != null) {
                    errorfieldName.append(map.get("voucherNumber"));
                    errorfieldName.append("\u3001");
                }
                if (map.get("sheetName") != null) {
                    errorfieldName.append(map.get("sheetName"));
                } else {
                    errorfieldName.deleteCharAt(errorfieldName.length() - 1);
                }
                errorfieldName.append(",");
            }
            if (voucherInfo.getAccountNumber() == null || voucherInfo.getAccountNumber().trim().length() == 0) {
                errorfieldName.append(map.get("accountNumber"));
                errorfieldName.append(",");
            }
            if (voucherInfo.getEntryDC() == 0) {
                errorfieldName.append(map.get("entryDC"));
                errorfieldName.append(",");
            }
            if (errorfieldName.length() > 0) {
                errorfieldName.deleteCharAt(errorfieldName.length() - 1);
                errorMsg.append(MessageFormat.format(CslRptUtil.getString((String)"rptGenVCFieldNullDetail"), rowIndex, errorfieldName)).append("\r\n");
            }
        }
        catch (Exception e) {
            logger.info((Object)"report generate voucher data error GenVoucherUtilForClient.setWSVCDefaultValue  IllegalArgumentException");
        }
        return errorMsg;
    }

    private boolean setWSVCDefaultValue(WSVoucherInfo voucherInfo, Object sheetName, ReportBaseInfo report) {
        boolean voucherNumIsNull = false;
        try {
            if (voucherInfo.getOriginalAmount() == 0.0) {
                return voucherNumIsNull;
            }
            double value = 0.0;
            if (voucherInfo.getLocalRate() == 0.0) {
                voucherInfo.setLocalRate(1.0);
            }
            value = voucherInfo.getOriginalAmount() * voucherInfo.getLocalRate();
            if (voucherInfo.getEntryDC() == 1) {
                voucherInfo.setDebitAmount(value);
            } else if (voucherInfo.getEntryDC() == -1) {
                voucherInfo.setCreditAmount(value);
            }
            if (voucherInfo.getCompanyNumber() == null || voucherInfo.getCompanyNumber().trim().length() == 0) {
                voucherInfo.setCompanyNumber(report.getCompany().getNumber());
            }
            try {
                if (voucherInfo.getBookedDate() == null) {
                    voucherInfo.setBookedDate(report.getEndDate());
                }
            }
            catch (Exception e) {
                voucherInfo.setBookedDate(((Calendar)voucherInfo.get("bookedDate")).getTime());
            }
            try {
                if (voucherInfo.getBizDate() == null) {
                    voucherInfo.setBizDate(report.getEndDate());
                }
            }
            catch (Exception e) {
                voucherInfo.setBizDate(((Calendar)voucherInfo.get("bizDate")).getTime());
            }
            if (voucherInfo.getPeriodYear() == 0) {
                voucherInfo.setPeriodYear(DateTimeUtils.getYear((Date)voucherInfo.getBookedDate()));
            }
            if (voucherInfo.getPeriodNumber() == 0) {
                voucherInfo.setPeriodNumber(DateTimeUtils.getMonth((Date)voucherInfo.getBookedDate()));
            }
            if (voucherInfo.getCreator() == null) {
                voucherInfo.setCreator(SysContext.getSysContext().getCurrentUserInfo().getName());
            }
            if (StringUtils.isEmpty((String)voucherInfo.getVoucherNumber()) && sheetName != null && sheetName.toString().trim().length() != 0) {
                voucherInfo.setVoucherNumber(sheetName.toString());
            }
            if (voucherInfo.getDescription() == null || voucherInfo.getDescription().trim().length() == 0) {
                voucherInfo.setDescription("CSL-" + voucherInfo.getVoucherNumber());
            }
            if (voucherInfo.getCurrencyNumber() == null || voucherInfo.getCurrencyNumber().trim().length() == 0) {
                voucherInfo.setCurrencyNumber(report.getCurrency().getNumber());
            }
        }
        catch (Exception e) {
            logger.info((Object)"report generate voucher data error GenVoucherUtilForClient.setWSVCDefaultValue  IllegalArgumentException");
        }
        return voucherNumIsNull;
    }

    private StringBuffer checkFieldType(int rowIndex, Map<String, String> showNameMap, WSVoucherInfo info, String fieldName, Object value) throws SecurityException, NoSuchMethodException, IllegalAccessException, BOSException {
        StringBuffer illegalArgument = new StringBuffer();
        if (value != null && "entryDC".equals(fieldName)) {
            if (info.get("entryDC").toString().contains(DebitOrCreditEnum.getEnum((String)"DEBIT").getAlias(SysContext.getSysContext().getLocale()))) {
                info.setEntryDC(1);
            } else if (info.get("entryDC").toString().contains(DebitOrCreditEnum.getEnum((String)"CREDIT").getAlias(SysContext.getSysContext().getLocale()))) {
                info.setEntryDC(-1);
            } else {
                illegalArgument.append(MessageFormat.format(CslRptUtil.getString((String)"illegalArgument"), rowIndex, showNameMap.get(fieldName), value)).append(CslRptUtil.getString((String)"debitCredit")).append("\n");
            }
            return illegalArgument;
        }
        if (("bizDate".equals(fieldName) || "bookedDate".equals(fieldName)) && info.get(fieldName) instanceof GregorianCalendar) {
            return illegalArgument;
        }
        if ("voucherNumber".equals(fieldName) && value != null) {
            return illegalArgument;
        }
        if (value != null) {
            String fieldName1Char = fieldName.substring(0, 1).toUpperCase();
            String methodName = "get" + fieldName1Char + fieldName.substring(1);
            Method method = info.getClass().getMethod(methodName, new Class[0]);
            try {
                method.invoke((Object)info, new Object[0]);
            }
            catch (IllegalArgumentException e) {
                illegalArgument.append(MessageFormat.format(CslRptUtil.getString((String)"illegalArgument"), rowIndex, showNameMap.get(fieldName), value)).append("\n");
            }
            catch (InvocationTargetException e) {
                illegalArgument.append(MessageFormat.format(CslRptUtil.getString((String)"illegalArgument"), rowIndex, showNameMap.get(fieldName), value)).append("\n");
            }
        }
        return illegalArgument;
    }
}

