/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetEvent;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTViewManager;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.rpt.IndexItemFactory;
import com.kingdee.eas.fi.rpt.IndexItemInfo;
import com.kingdee.eas.fi.rpt.IndexStateEnum;
import com.kingdee.eas.fi.rpt.client.AbstractIndexItemListUI;
import com.kingdee.eas.fi.rpt.client.IndexItemEditUI;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;

public class IndexItemListUI
extends AbstractIndexItemListUI {
    public static final String BTN_ENABLE = "BTN_ENABLE";
    public static final String BTN_DISABLED = "BTN_DISABLED";
    public static final String ICON_ENABLE = "imgTbtn_staruse";
    public static final String ICON_DISABLED = "imgTbtn_forbid";

    public IndexItemListUI() throws Exception {
        this.setDisabledState();
        this.tblMain.addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                try {
                    IndexItemListUI.this.setSelectedState();
                }
                catch (Exception ex) {
                    IndexItemListUI.this.handleException(ex);
                }
            }
        });
        this.tblMain.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                for (int i = e.getFirstRow(); i <= e.getLastRow(); ++i) {
                    IRow row = IndexItemListUI.this.tblMain.getRow(i);
                    String templateName = (String)row.getCell("template.name").getValue();
                    String sheetName = (String)row.getCell("sheetParam.sheetName").getValue();
                    String cellName = (String)row.getCell("cell").getValue();
                    String tempVersion = (String)row.getCell("template.versionNumber").getValue();
                    row.getCell("dataSrcTemplate").setValue((Object)(templateName + "_v" + tempVersion + "|" + sheetName + "[" + cellName + "]"));
                }
            }
        });
    }

    public void onLoad() throws Exception {
        super.onLoad();
        ObjectValueRender render = new ObjectValueRender();
        render.setFormat(new IDataFormat(){

            public String format(Object object) {
                BizEnumValueInfo info = (BizEnumValueInfo)object;
                if (info.getInt() == 1) {
                    return EASResource.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"133_IndexItemListUI");
                }
                return EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResource", (String)"index_item_Disabled");
            }
        });
        this.tblMain.getColumn("state").setRenderer((IBasicRender)render);
        this.tblMain.getColumn("dataSrcTemplate").setSortable(false);
        this.tblMain.setColumnMoveable(true);
    }

    public void onShow() throws Exception {
        super.onShow();
        KDTViewManager viewmgr = this.tblMain.getViewManager();
        if (viewmgr != null && !viewmgr.isFreeze()) {
            viewmgr.setFreezeView(0, 2);
            this.tblMain.setRefresh(true);
            this.tblMain.reLayoutAndPaint();
        }
    }

    protected void tblMain_doRequestRowSet(RequestRowSetEvent e) {
        if (this.mainQuery != null) {
            FilterInfo filter = new FilterInfo();
            String templateId = (String)this.getUIContext().get("CURRENT_TEMPLATE_UUID");
            filter.getFilterItems().add(new FilterItemInfo("template.id", (Object)templateId));
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)SysContext.getSysContext().getCurrentFIUnit().getId().toString()));
            this.mainQuery.setFilter(filter);
        }
        super.tblMain_doRequestRowSet(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionEffective_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String actionCommand = e.getActionCommand();
        ICoreBase bizInterface = this.getBizInterface();
        ArrayList ids = this.getSelectedIdValues();
        RptUtil.reqDataMutex((CoreUI)this, ids, OprtState.EDIT);
        try {
            int size = ids.size();
            for (int i = 0; i < size; ++i) {
                String id = (String)ids.get(i);
                IndexItemInfo itemInfo = (IndexItemInfo)bizInterface.getValue((IObjectPK)new ObjectUuidPK(id));
                if (actionCommand.equalsIgnoreCase(BTN_ENABLE)) {
                    itemInfo.setState(IndexStateEnum.effective);
                    bizInterface.update((IObjectPK)new ObjectUuidPK(id), (CoreBaseInfo)itemInfo);
                    this.setDisabledState();
                    continue;
                }
                itemInfo.setState(IndexStateEnum.unEffective);
                bizInterface.update((IObjectPK)new ObjectUuidPK(id), (CoreBaseInfo)itemInfo);
                this.setEnableState();
            }
        }
        finally {
            RptUtil.releaseDataMutex((CoreUI)this, ids);
            this.refreshList();
        }
    }

    private void setDisabledState() {
        this.btnEffective.setEnabled(true);
        this.btnEffective.setActionCommand(BTN_DISABLED);
        this.btnEffective.setIcon(EASResource.getIcon((String)ICON_DISABLED));
        this.btnEffective.setText(EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResource", (String)"index_item_btn_disabled"));
    }

    private void setEnableState() {
        this.btnEffective.setEnabled(true);
        this.btnEffective.setActionCommand(BTN_ENABLE);
        this.btnEffective.setIcon(EASResource.getIcon((String)ICON_ENABLE));
        this.btnEffective.setText(EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResource", (String)"index_item_btn_enable"));
    }

    protected String getEditUIName() {
        return IndexItemEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return IndexItemFactory.getRemoteInstance();
    }

    private void setSelectedState() throws Exception, BOSException, EASBizException {
        ArrayList ids = this.getSelectedIdValues();
        ICoreBase bizInterface = this.getBizInterface();
        boolean isEditable = true;
        int isEnable = -1;
        int size = ids.size();
        for (int i = 0; i < size; ++i) {
            String id = (String)ids.get(i);
            IndexItemInfo itemInfo = (IndexItemInfo)bizInterface.getValue((IObjectPK)new ObjectUuidPK(id));
            IndexStateEnum indexStateEnum = itemInfo.getState();
            if (isEnable == -1) {
                if (indexStateEnum == IndexStateEnum.effective) {
                    isEnable = 2;
                    continue;
                }
                isEnable = 1;
                continue;
            }
            if ((isEnable != 1 || indexStateEnum != IndexStateEnum.effective) && (isEnable != 2 || indexStateEnum != IndexStateEnum.unEffective)) continue;
            isEnable = -1;
            break;
        }
        if (isEnable == -1) {
            this.btnEffective.setEnabled(false);
        } else if (isEnable == 2) {
            this.setDisabledState();
        } else {
            this.setEnableState();
            isEditable = false;
        }
        if (ids.size() > 1) {
            isEditable = false;
        }
        this.actionEdit.setEnabled(isEditable);
    }

    @Override
    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList ids = this.getSelectedIdValues();
        int isConfirm = MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResource", (String)"index_item_DeleteConfirm"));
        if (MsgBox.isYes((int)isConfirm)) {
            RptUtil.reqDataMutex((CoreUI)this, ids, "REMOVE");
            ICoreBase bizInterface = this.getBizInterface();
            try {
                int size = ids.size();
                for (int i = 0; i < size; ++i) {
                    String id = (String)ids.get(i);
                    bizInterface.delete((IObjectPK)new ObjectUuidPK(id));
                }
            }
            catch (ObjectNotFoundException onfe) {
                throw new EASBizException(EASBizException.CHECKEXIST);
            }
            finally {
                RptUtil.releaseDataMutex((CoreUI)this, ids);
                this.refreshList();
            }
        }
    }
}

