/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.IRPTItem;
import com.kingdee.eas.fi.gr.cslrpt.InvestDayEntryFactory;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemControlEnum;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemFactory;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemInfo;
import com.kingdee.eas.fi.gr.cslrpt.util.SaveTableColumn;
import com.kingdee.eas.fi.rpt.InvDataItemTypeEnum;
import com.kingdee.eas.fi.rpt.client.AbstractInvDataDynaItemSelectorUI;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class InvDataDynaItemSelectorUI
extends AbstractInvDataDynaItemSelectorUI {
    private static final Logger logger = CoreUIObject.getLogger(InvDataDynaItemSelectorUI.class);
    private boolean isCanceled = false;
    private RPTItemControlEnum controlAttr = RPTItemControlEnum.OWNER_EQUITY_SUM;
    private RPTItemInfo sumItem = null;

    public InvDataDynaItemSelectorUI() throws Exception {
        this.btnOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InvDataDynaItemSelectorUI.this.btnOK_actionPerformed(e);
            }
        });
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InvDataDynaItemSelectorUI.this.btnCancel_actionPerformed(e);
            }
        });
        this.kDTable1.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                if (e.getClickCount() == 2) {
                    InvDataDynaItemSelectorUI.this.endWizard(false);
                }
            }
        });
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.InitSumItem();
        this.createTable();
    }

    public void onShow() throws Exception {
        this.kDTable1.getSelectManager().setSelectMode(2);
        this.isCanceled = false;
        IUIWindow w = this.getUIWindow();
        if (w instanceof KDDialog) {
            KDDialog d = (KDDialog)w;
            d.addWindowListener((WindowListener)new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    InvDataDynaItemSelectorUI.this.endWizard(true);
                }
            });
        }
        super.onShow();
    }

    private void createTable() throws Exception {
        this.kDTable1.checkParsed();
        this.kDTable1.setRefresh(false);
        this.kDTable1.addColumns(2);
        IColumn column = this.kDTable1.getColumn(0);
        column.getStyleAttributes().setLocked(true);
        column.setWidth(250);
        column = this.kDTable1.getColumn(1);
        column.getStyleAttributes().setLocked(true);
        column.getStyleAttributes().setHided(true);
        IRow headrow = this.kDTable1.addHeadRow();
        ICell cell = headrow.getCell(0);
        cell.setValue((Object)this.getResource("ItemName"));
        cell = headrow.getCell(1);
        cell.setValue((Object)this.getResource("ItemNumber"));
        String patternString = "([\\(]*)([^\\+|^\\-|^\\(|^\\))]{1,})([\\+|\\-|\\(|\\)]*)";
        Pattern pt = Pattern.compile("([\\(]*)([^\\+|^\\-|^\\(|^\\))]{1,})([\\+|\\-|\\(|\\)]*)");
        HashMap<String, Object> uiCtx = new HashMap<String, Object>();
        uiCtx.put("sumitem", this.sumItem);
        uiCtx.put("sumValue", null);
        uiCtx.put("subItems", null);
        uiCtx.put("pt", pt);
        List list = InvestDayEntryFactory.getRemoteInstance().initFormulaData(uiCtx);
        if (list.size() == 0) {
            return;
        }
        this.fillTable(list);
        this.kDTable1.setRefresh(true);
        this.kDTable1.repaint();
    }

    private void fillTable(List list) {
        IRow row = this.kDTable1.addRow();
        ICell cell = row.getCell(0);
        cell.setValue((Object)InvDataItemTypeEnum.INVCHGMONEY.getAlias());
        cell = row.getCell(1);
        cell.setValue((Object)InvDataItemTypeEnum.INVCHGMONEY.getValue());
        row = this.kDTable1.addRow();
        cell = row.getCell(0);
        cell.setValue((Object)InvDataItemTypeEnum.INVSUMMONEY.getAlias());
        cell = row.getCell(1);
        cell.setValue((Object)InvDataItemTypeEnum.INVSUMMONEY.getValue());
        boolean isSumItem = this.sumItem.isIsSumItem();
        if (isSumItem) {
            this.fillOthOwnerItemList(list, "BF", !isSumItem);
            this.fillOthOwnerItemList(list, "AF", !isSumItem);
            this.fillOthOwnerItemList(list, "AM", !isSumItem);
        } else {
            row = this.kDTable1.addRow();
            cell = row.getCell(0);
            cell.setValue((Object)InvDataItemTypeEnum.OTHOWNCHGBEFORE.getAlias());
            cell = row.getCell(1);
            cell.setValue((Object)InvDataItemTypeEnum.OTHOWNCHGBEFORE.getValue());
            row = this.kDTable1.addRow();
            cell = row.getCell(0);
            cell.setValue((Object)InvDataItemTypeEnum.OTHOWNCHGAFTER.getAlias());
            cell = row.getCell(1);
            cell.setValue((Object)InvDataItemTypeEnum.OTHOWNCHGAFTER.getValue());
            row = this.kDTable1.addRow();
            cell = row.getCell(0);
            cell.setValue((Object)InvDataItemTypeEnum.ActualAmount.getAlias());
            cell = row.getCell(1);
            cell.setValue((Object)(this.sumItem + "AM"));
        }
        row = this.kDTable1.addRow();
        cell = row.getCell(0);
        cell.setValue((Object)InvDataItemTypeEnum.HONOR.getAlias());
        cell = row.getCell(1);
        cell.setValue((Object)InvDataItemTypeEnum.HONOR.getValue());
        row = this.kDTable1.addRow();
        cell = row.getCell(0);
        cell.setValue((Object)InvDataItemTypeEnum.HONORSUM.getAlias());
        cell = row.getCell(1);
        cell.setValue((Object)InvDataItemTypeEnum.HONORSUM.getValue());
    }

    private void fillOthOwnerItemList(List list, String Suffix, boolean isDispSumItem) {
        for (int i = 0; i < list.size(); ++i) {
            SaveTableColumn sv = (SaveTableColumn)list.get(i);
            String itemNum = (String)sv.getRptNumber();
            String itemName = (String)sv.getRptName();
            if (itemNum == null || itemNum.equals(this.sumItem.get("number")) && isDispSumItem) continue;
            itemName = this.combineName(Suffix, itemName, isDispSumItem);
            IRow row = this.kDTable1.addRow();
            ICell cell = row.getCell(0);
            cell.setValue((Object)itemName);
            cell = row.getCell(1);
            cell.setValue((Object)(sv.getRptNumber() + Suffix));
        }
    }

    private String combineName(String Suffix, String rptName, boolean isDispSumItem) {
        String sufName = "";
        sufName = Suffix.equals("AF") ? RptUtil.getReportResource("InvestAfter") : (Suffix.equals("BF") ? RptUtil.getReportResource("InvestBefore") : RptUtil.getReportResource("ActualAmount"));
        if (!isDispSumItem && !StringUtil.isEmptyString((String)rptName)) {
            return sufName + rptName.replaceAll(" ", "");
        }
        return rptName + sufName;
    }

    private void InitSumItem() throws BOSException, EASBizException {
        IRPTItem irptItem = RPTItemFactory.getRemoteInstance();
        String oql = " where control = " + this.controlAttr.getValue() + " and isFreezed = 0";
        this.sumItem = irptItem.getRPTItemInfo(oql);
    }

    protected void btnOK_actionPerformed(ActionEvent e) {
        this.endWizard(false);
    }

    protected void btnCancel_actionPerformed(ActionEvent e) {
        this.endWizard(false);
    }

    private void endWizard(boolean isCanceled) {
        this.disposeUIWindow();
        this.isCanceled = isCanceled;
    }

    public boolean isCanceled() {
        return this.isCanceled;
    }

    public String getData() {
        return this.isCanceled() ? null : this.getSelectedKeyValue();
    }

    private String getSelectedKeyValue() {
        int size = this.kDTable1.getSelectManager().size();
        if (size == 0) {
            return null;
        }
        IRow selRow = this.kDTable1.getRow(this.kDTable1.getSelectManager().getActiveRowIndex());
        if (selRow == null) {
            return null;
        }
        ICell cell = selRow.getCell(1);
        Object val = cell.getValue();
        if (val == null || ((String)val).equals("")) {
            return null;
        }
        return (String)val;
    }

    private String getResource(String key) {
        return RptUtil.getReportResource(key);
    }
}

