/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizComboboxModel;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDNumberTextField;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.cslrpt.ConvertStatusEnum;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.CyConvtSchmEntryFactory;
import com.kingdee.eas.fi.gr.cslrpt.CyConvtSchmEntryInfo;
import com.kingdee.eas.fi.gr.cslrpt.DataCollectConstant;
import com.kingdee.eas.fi.gr.cslrpt.DataCollectInfo;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemInfo;
import com.kingdee.eas.fi.gr.cslrpt.SysDataElementEnum;
import com.kingdee.eas.fi.gr.cslrpt.util.CSLPermissionUtil;
import com.kingdee.eas.fi.newrpt.RptNewUIUtil;
import com.kingdee.eas.fi.rpt.ItemDataYearInitFactory;
import com.kingdee.eas.fi.rpt.ItemDataYearInitInfo;
import com.kingdee.eas.fi.rpt.client.AbstractItemDataYearInitBaseEditUI;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class ItemDataYearInitBaseEditUI
extends AbstractItemDataYearInitBaseEditUI {
    private static final Logger logger = CoreUIObject.getLogger(ItemDataYearInitBaseEditUI.class);
    private boolean hasBgPermission;
    private boolean hasAcPermission;
    private String dataCollectNumber = "ACTUALDATA";
    private ChangeLiser l = new ChangeLiser();
    protected String COL_ITEM_NUMBER = "number";
    protected String COL_ITEM_NAME = "name";
    protected String COL_CURRENCY = "cur";
    protected String COL_SOURCECURRENCY = "srccur";
    protected String COL_YEAR = "year";
    protected String COL_PERIOD = "period";
    protected String COL_DEBITFORMULA = "jf";
    protected String COL_CREDITFORMULA = "df";
    protected String COL_DATAELEMENT = "type";
    protected String COL_CONVERTSTATUS = "st";

    public void onLoad() throws Exception {
        super.onLoad();
        this.menuTool.setVisible(false);
        this.setUITitle(EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResource.titleY"));
        this.btnSave.setEnabled(true);
        this.btnRef.setEnabled(true);
        this.year.setValue((Object)new Integer(Calendar.getInstance().get(1)));
        this.tbl.checkParsed();
        KDBizComboboxModel md = new KDBizComboboxModel(null);
        md.setNeedReQuery(false);
        md.addElement((Object)SysDataElementEnum.YTBEGIN);
        this.type.setModel((ComboBoxModel)md);
        this.type.setSelectedItem((Object)SysDataElementEnum.YTBEGIN);
        this.type.setEnabled(false);
        this.company.setEnabled(false);
        OrgUnitInfo currentFIUnit = this.getCompanyOrgUnitInfo();
        this.company.setText(currentFIUnit.getName());
        this.year.removeChangeListener((ChangeListener)this.l);
        this.year.addChangeListener((ChangeListener)this.l);
        this.currency.removeChangeListener((ChangeListener)this.l);
        this.currency.addChangeListener((ChangeListener)this.l);
        this.currency.setEditable(false);
        this.srcCurrency.removeChangeListener((ChangeListener)this.l);
        this.srcCurrency.addChangeListener((ChangeListener)this.l);
        this.srcCurrency.setEditable(false);
        this.menuView.setVisible(true);
        this.menuView.setEnabled(true);
        this.menuItemView.setVisible(true);
        this.menuItemView.setEnabled(true);
        this.menuitemSave.setVisible(true);
        this.menuitemSave.setEnabled(true);
        this.menuItemView.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.btnRef.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.menuitemSave.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.btnSave.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.type.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    ItemDataYearInitBaseEditUI.this.loadData();
                }
                catch (BOSException e) {
                    ItemDataYearInitBaseEditUI.this.handUIException(e);
                }
            }
        });
        this.cbxDataCollect.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                try {
                    ItemDataYearInitBaseEditUI.this.actionPerformed_cbxDataCollectChange(e);
                }
                catch (Exception exc) {
                    ItemDataYearInitBaseEditUI.this.handUIException(exc);
                }
            }
        });
        this.initCbxDataCollect();
        this.loadData();
        this.tbl.addKDTEditListener(new KDTEditListener(){

            public void editStarting(KDTEditEvent e) {
            }

            public void editStarted(KDTEditEvent e) {
            }

            public void editValueChanged(KDTEditEvent e) {
            }

            public void editStopping(KDTEditEvent e) {
            }

            public void editStopped(KDTEditEvent e) {
                if (e.getColIndex() == ItemDataYearInitBaseEditUI.this.tbl.getRow(e.getRowIndex()).getCell(ItemDataYearInitBaseEditUI.this.COL_DEBITFORMULA).getColumnIndex() && e.getValue() != null && e.getValue().toString().trim().length() > 0) {
                    ItemDataYearInitBaseEditUI.this.tbl.getRow(e.getRowIndex()).getCell(ItemDataYearInitBaseEditUI.this.COL_CREDITFORMULA).setValue(null);
                }
                if (e.getColIndex() == ItemDataYearInitBaseEditUI.this.tbl.getRow(e.getRowIndex()).getCell(ItemDataYearInitBaseEditUI.this.COL_CREDITFORMULA).getColumnIndex() && e.getValue() != null && e.getValue().toString().trim().length() > 0) {
                    ItemDataYearInitBaseEditUI.this.tbl.getRow(e.getRowIndex()).getCell(ItemDataYearInitBaseEditUI.this.COL_DEBITFORMULA).setValue(null);
                }
            }

            public void editCanceled(KDTEditEvent e) {
            }
        });
        Object isSupportOtherDS = CslRptUtil.getParamValue(null, null, (String)"GR_CSL_SupportOtherDS");
        if ("true".equals(isSupportOtherDS)) {
            this.tbl.getColumn("dataCollect").getStyleAttributes().setHided(false);
        } else {
            this.tbl.getColumn("dataCollect").getStyleAttributes().setHided(true);
        }
    }

    private void initCbxDataCollect() {
        try {
            this.contDataCollect.setVisible(false);
            Object isSupportOtherDC = CslRptUtil.getParamValue(null, null, (String)"GR_CSL_SupportOtherDS");
            if ("true".equals(isSupportOtherDC)) {
                this.contDataCollect.setVisible(true);
                this.hasBgPermission = CSLPermissionUtil.hasDataCollectPermission(null, (String)SysContext.getSysContext().getCurrentUserInfo().getId().toString(), (DataCollectInfo)DataCollectConstant.getBudgetDC());
                this.hasAcPermission = CSLPermissionUtil.hasDataCollectPermission(null, (String)SysContext.getSysContext().getCurrentUserInfo().getId().toString(), (DataCollectInfo)DataCollectConstant.getActualDC());
                if (this.hasAcPermission) {
                    this.cbxDataCollect.addItem((Object)DataCollectConstant.getActualDC());
                    this.dataCollectNumber = "ACTUALDATA";
                } else {
                    this.dataCollectNumber = "BUDGETDATA";
                }
                if (this.hasBgPermission) {
                    this.cbxDataCollect.addItem((Object)DataCollectConstant.getBudgetDC());
                }
            }
        }
        catch (EASBizException ease) {
            this.handUIException(ease);
        }
        catch (BOSException bose) {
            this.handUIException(bose);
        }
    }

    private void actionPerformed_cbxDataCollectChange(ItemEvent e) {
        DataCollectInfo info = (DataCollectInfo)this.cbxDataCollect.getSelectedItem();
        this.dataCollectNumber = info.getNumber();
        try {
            this.loadData();
        }
        catch (BOSException bose) {
            this.handleException((Exception)((Object)bose));
        }
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        CurrencyInfo c1 = (CurrencyInfo)this.currency.getValue();
        CurrencyInfo c2 = (CurrencyInfo)this.srcCurrency.getValue();
        if (c1 != null && c2 != null && c1.getId().equals((Object)c2.getId())) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResource.SrcCurrencyEQCurrency"));
            return;
        }
        if (c1 == null || c2 == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResource.CurencyCanNotNull"));
            return;
        }
        ArrayList<ItemDataYearInitInfo> list = new ArrayList<ItemDataYearInitInfo>();
        for (int i = 0; i < this.tbl.getRowCount(); ++i) {
            ItemDataYearInitInfo o = this.getLineData(this.tbl.getRow(i));
            if (o == null) continue;
            list.add(o);
        }
        if (list.size() == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResource.NoItemData"));
        } else {
            ItemDataYearInitFactory.getRemoteInstance().saveAll(list);
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResource.SaveSucess"));
        }
    }

    @Override
    public void actionRef_actionPerformed(ActionEvent e) throws Exception {
        super.actionRef_actionPerformed(e);
        this.loadData();
    }

    private ItemDataYearInitInfo getLineData(IRow row) {
        ItemDataYearInitInfo info = (ItemDataYearInitInfo)row.getUserObject();
        DataCollectInfo dataCollect = null;
        if ("ACTUALDATA".equals(this.dataCollectNumber)) {
            dataCollect = DataCollectConstant.getActualDC();
        } else if ("BUDGETDATA".equals(this.dataCollectNumber)) {
            dataCollect = DataCollectConstant.getBudgetDC();
        }
        if (info == null) {
            String msg;
            info = new ItemDataYearInitInfo();
            info.setItem((RPTItemInfo)row.getCell(this.COL_ITEM_NUMBER).getUserObject());
            info.setCurrency((CurrencyInfo)row.getCell(this.COL_CURRENCY).getValue());
            info.setSourceCurrency((CurrencyInfo)row.getCell(this.COL_SOURCECURRENCY).getValue());
            if (row.getCell(this.COL_CURRENCY).getValue() == null || row.getCell(this.COL_SOURCECURRENCY).getValue() == null) {
                return null;
            }
            if ((row.getCell(this.COL_DEBITFORMULA).getValue() == null || row.getCell(this.COL_DEBITFORMULA).getValue() != null && row.getCell(this.COL_DEBITFORMULA).getValue().toString().trim().length() == 0) && (row.getCell(this.COL_CREDITFORMULA).getValue() == null || row.getCell(this.COL_CREDITFORMULA).getValue() != null && row.getCell(this.COL_CREDITFORMULA).getValue().toString().trim().length() == 0)) {
                return null;
            }
            if (row.getCell(this.COL_DEBITFORMULA).getValue() != null && row.getCell(this.COL_DEBITFORMULA).getValue().toString().trim().length() > 0) {
                try {
                    BigDecimal Debit = new BigDecimal(row.getCell(this.COL_DEBITFORMULA).getValue().toString()).setScale(6, 4);
                    CslRptUtil.checkBigDecimalLength((BigDecimal)Debit);
                    info.setDebit(Debit);
                }
                catch (EASBizException e) {
                    this.handleException((Exception)((Object)e));
                    this.abort();
                }
                catch (NumberFormatException e) {
                    this.handleException(e);
                    msg = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.cslcommon.CSLCOMMONAutoGenerateResource", (String)"76_ItemDataYearInitBaseEditUI");
                    MsgBox.showInfo((Component)((Object)this), (String)MessageFormat.format(msg, row.getCell(0).getValue(), row.getCell(1).getValue()));
                    this.abort();
                }
            }
            if (row.getCell(this.COL_CREDITFORMULA).getValue() != null && row.getCell(this.COL_CREDITFORMULA).getValue().toString().trim().length() > 0) {
                try {
                    BigDecimal Credit = new BigDecimal(row.getCell(this.COL_CREDITFORMULA).getValue().toString()).setScale(6, 4);
                    CslRptUtil.checkBigDecimalLength((BigDecimal)Credit);
                    info.setCredit(Credit);
                }
                catch (EASBizException e) {
                    this.handleException((Exception)((Object)e));
                    this.abort();
                }
                catch (NumberFormatException e) {
                    logger.debug((Object)e.getMessage());
                    msg = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.cslcommon.CSLCOMMONAutoGenerateResource", (String)"77_ItemDataYearInitBaseEditUI");
                    MsgBox.showInfo((Component)((Object)this), (String)MessageFormat.format(msg, row.getCell(0).getValue(), row.getCell(1).getValue()));
                    this.abort();
                }
            }
            info.setDataElement((SysDataElementEnum)row.getCell(this.COL_DATAELEMENT).getValue());
            info.setConvertStatus((ConvertStatusEnum)row.getCell(this.COL_CONVERTSTATUS).getValue());
        } else {
            if (row.getCell(this.COL_DEBITFORMULA).getValue() != null && row.getCell(this.COL_DEBITFORMULA).getValue().toString().trim().length() > 0) {
                BigDecimal Debit = new BigDecimal(row.getCell(this.COL_DEBITFORMULA).getValue().toString()).setScale(6, 4);
                try {
                    CslRptUtil.checkBigDecimalLength((BigDecimal)Debit);
                }
                catch (EASBizException e) {
                    this.handleException((Exception)((Object)e));
                    this.abort();
                }
                info.setDebit(Debit);
            } else {
                info.setDebit(null);
            }
            if (row.getCell(this.COL_CREDITFORMULA).getValue() != null && row.getCell(this.COL_CREDITFORMULA).getValue().toString().trim().length() > 0) {
                BigDecimal Credit = new BigDecimal(row.getCell(this.COL_CREDITFORMULA).getValue().toString()).setScale(6, 4);
                try {
                    CslRptUtil.checkBigDecimalLength((BigDecimal)Credit);
                }
                catch (EASBizException e) {
                    this.handleException((Exception)((Object)e));
                    this.abort();
                }
                info.setCredit(Credit);
            } else {
                info.setCredit(null);
            }
            info.setConvertStatus((ConvertStatusEnum)row.getCell(this.COL_CONVERTSTATUS).getValue());
        }
        info.setDataCollect(dataCollect);
        info.setDataCollectNumber(this.dataCollectNumber);
        info.setCompany(this.getCompanyOrgUnitInfo().castToFullOrgUnitInfo());
        info.setYear(this.year.getIntegerVlaue());
        return info;
    }

    private void bindLineData(IRow row, ItemDataYearInitInfo info) {
        row.setUserObject((Object)info);
        row.getCell(this.COL_ITEM_NUMBER).setUserObject((Object)info.getItem());
        row.getCell(this.COL_ITEM_NUMBER).setValue((Object)info.getItem().getNumber());
        row.getCell(this.COL_ITEM_NUMBER).getStyleAttributes().setLocked(true);
        row.getCell(this.COL_ITEM_NAME).setValue((Object)info.getItem().getName());
        row.getCell(this.COL_ITEM_NAME).getStyleAttributes().setLocked(true);
        row.getCell(this.COL_CURRENCY).setValue((Object)info.getCurrency());
        row.getCell(this.COL_CURRENCY).getStyleAttributes().setLocked(true);
        row.getCell(this.COL_SOURCECURRENCY).setValue((Object)info.getSourceCurrency());
        row.getCell(this.COL_SOURCECURRENCY).getStyleAttributes().setLocked(true);
        row.getCell(this.COL_YEAR).getStyleAttributes().setLocked(true);
        row.getCell(this.COL_YEAR).getStyleAttributes().setBackground(new Color(131, 184, 188));
        row.getCell(this.COL_PERIOD).getStyleAttributes().setLocked(true);
        row.getCell(this.COL_PERIOD).getStyleAttributes().setBackground(new Color(131, 184, 188));
        row.getCell(this.COL_DEBITFORMULA).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)new KDNumberTextField(6)));
        row.getCell(this.COL_DEBITFORMULA).setValue((Object)info.getDebit());
        row.getCell(this.COL_DEBITFORMULA).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        row.getCell(this.COL_DEBITFORMULA).getStyleAttributes().setNumberFormat("#,###.00");
        row.getCell(this.COL_CREDITFORMULA).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)new KDNumberTextField(6)));
        row.getCell(this.COL_CREDITFORMULA).setValue((Object)info.getCredit());
        row.getCell(this.COL_CREDITFORMULA).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        row.getCell(this.COL_CREDITFORMULA).getStyleAttributes().setNumberFormat("#,###.00");
        row.getCell(this.COL_DATAELEMENT).setEditor((ICellEditor)new KDTDefaultCellEditor());
        row.getCell(this.COL_DATAELEMENT).setValue((Object)info.getDataElement());
        row.getCell(this.COL_DATAELEMENT).getStyleAttributes().setLocked(true);
        row.getCell(this.COL_DATAELEMENT).getStyleAttributes().setBackground(new Color(131, 184, 188));
        KDComboBox box = new KDComboBox();
        box.addItem((Object)ConvertStatusEnum.BeforeConvert);
        box.addItem((Object)ConvertStatusEnum.Converted);
        row.getCell(this.COL_CONVERTSTATUS).setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)box));
        row.getCell(this.COL_CONVERTSTATUS).setValue((Object)info.getConvertStatus());
        row.getCell(this.COL_CONVERTSTATUS).getStyleAttributes().setLocked(true);
        row.getCell("dataCollect").setValue(this.cbxDataCollect.getSelectedItem());
    }

    private void bindLineData(IRow row, RPTItemInfo item) {
        row.getCell(this.COL_ITEM_NUMBER).setUserObject((Object)item);
        row.getCell(this.COL_ITEM_NUMBER).setValue((Object)item.getNumber());
        row.getCell(this.COL_ITEM_NUMBER).getStyleAttributes().setLocked(true);
        row.getCell(this.COL_ITEM_NAME).setValue((Object)item.getName());
        row.getCell(this.COL_ITEM_NAME).getStyleAttributes().setLocked(true);
        row.getCell(this.COL_CURRENCY).setValue(this.currency.getValue());
        row.getCell(this.COL_CURRENCY).getStyleAttributes().setLocked(true);
        row.getCell(this.COL_SOURCECURRENCY).setValue(this.srcCurrency.getValue());
        row.getCell(this.COL_SOURCECURRENCY).getStyleAttributes().setLocked(true);
        row.getCell(this.COL_YEAR).getStyleAttributes().setLocked(true);
        row.getCell(this.COL_YEAR).getStyleAttributes().setBackground(new Color(131, 184, 188));
        row.getCell(this.COL_PERIOD).getStyleAttributes().setLocked(true);
        row.getCell(this.COL_PERIOD).getStyleAttributes().setBackground(new Color(131, 184, 188));
        row.getCell(this.COL_DEBITFORMULA).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)new KDNumberTextField(6)));
        row.getCell(this.COL_DEBITFORMULA).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        row.getCell(this.COL_DEBITFORMULA).getStyleAttributes().setNumberFormat("#,###.00");
        row.getCell(this.COL_CREDITFORMULA).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)new KDNumberTextField(6)));
        row.getCell(this.COL_CREDITFORMULA).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        row.getCell(this.COL_CREDITFORMULA).getStyleAttributes().setNumberFormat("#,###.00");
        row.getCell(this.COL_DATAELEMENT).setEditor((ICellEditor)new KDTDefaultCellEditor());
        row.getCell(this.COL_DATAELEMENT).setValue(this.type.getSelectedItem());
        row.getCell(this.COL_DATAELEMENT).getStyleAttributes().setLocked(true);
        row.getCell(this.COL_DATAELEMENT).getStyleAttributes().setBackground(new Color(131, 184, 188));
        KDComboBox box = new KDComboBox();
        box.addItem((Object)ConvertStatusEnum.BeforeConvert);
        box.addItem((Object)ConvertStatusEnum.Converted);
        row.getCell(this.COL_CONVERTSTATUS).setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)box));
        row.getCell(this.COL_CONVERTSTATUS).setValue((Object)ConvertStatusEnum.Converted);
        row.getCell(this.COL_CONVERTSTATUS).getStyleAttributes().setLocked(true);
        row.getCell("dataCollect").setValue(this.cbxDataCollect.getSelectedItem());
    }

    private void loadData() throws BOSException {
        this.tbl.removeRows();
        ArrayList<ItemDataYearInitInfo> allList = new ArrayList<ItemDataYearInitInfo>();
        CoreBaseCollection c = this.getAllItemDataYearInitInfos();
        HashMap<String, String> filterMap = new HashMap<String, String>();
        if (c != null && c.size() > 0) {
            for (ItemDataYearInitInfo info : c) {
                if (filterMap.get(info.getItem().getId().toString()) == null) {
                    filterMap.put(info.getItem().getId().toString(), " ");
                }
                allList.add(info);
            }
        }
        ArrayList list = this.getAllAllowedItem();
        for (RPTItemInfo info2 : list) {
            if (filterMap.get(info2.getId().toString()) != null) continue;
            filterMap.put(info2.getId().toString(), " ");
            allList.add((ItemDataYearInitInfo)info2);
        }
        Collections.sort(allList, new Comparator(){

            public int compare(Object arg0, Object arg1) {
                if (arg0 == null && arg1 == null) {
                    return 0;
                }
                if (arg0 == null) {
                    return -1;
                }
                if (arg1 == null) {
                    return 1;
                }
                if (!(arg0 instanceof ItemDataYearInitInfo) || !(arg0 instanceof RPTItemInfo)) {
                    return -1;
                }
                if (!(arg1 instanceof ItemDataYearInitInfo) || !(arg1 instanceof RPTItemInfo)) {
                    return 1;
                }
                String number1 = arg0 instanceof ItemDataYearInitInfo ? ((ItemDataYearInitInfo)arg0).getItem().getNumber() : ((RPTItemInfo)arg0).getNumber();
                String number2 = arg1 instanceof ItemDataYearInitInfo ? ((ItemDataYearInitInfo)arg1).getItem().getNumber() : ((RPTItemInfo)arg1).getNumber();
                return number1.compareTo(number2);
            }
        });
        for (Object e : allList) {
            this.bindLineData(this.tbl.addRow(), e);
        }
        this.tbl.getColumn("dataCollect").getStyleAttributes().setLocked(true);
    }

    private void bindLineData(IRow addRow, Object object) {
        if (object instanceof ItemDataYearInitInfo) {
            this.bindLineData(addRow, (ItemDataYearInitInfo)object);
        } else if (object instanceof RPTItemInfo) {
            this.bindLineData(addRow, (RPTItemInfo)object);
        }
    }

    private ArrayList getAllAllowedItem() throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("*"));
        view.getSelector().add(new SelectorItemInfo("item.*"));
        view.setFilter(new FilterInfo());
        view.getFilter().getFilterItems().add(new FilterItemInfo("convertMode", (Object)new Integer(3)));
        view.getSorter().add(new SorterItemInfo("item.number"));
        view.getFilter().getFilterItems().add(new FilterItemInfo("item.isFreezed", (Object)Boolean.FALSE));
        CoreBaseCollection collection = CyConvtSchmEntryFactory.getRemoteInstance().getCollection(view);
        HashMap<String, String> filtetMap = new HashMap<String, String>();
        ArrayList<RPTItemInfo> list = new ArrayList<RPTItemInfo>();
        if (collection != null && collection.size() > 0) {
            for (CyConvtSchmEntryInfo temp : collection) {
                if (filtetMap.get(temp.getItem().getId().toString()) != null) continue;
                filtetMap.put(temp.getItem().getId().toString(), " ");
                list.add(temp.getItem());
            }
        }
        return list;
    }

    private CoreBaseCollection getAllItemDataYearInitInfos() throws BOSException {
        CurrencyInfo cur;
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("*"));
        view.getSelector().add(new SelectorItemInfo("currency.*"));
        view.getSelector().add(new SelectorItemInfo("item.*"));
        view.getSelector().add(new SelectorItemInfo("sourceCurrency.*"));
        view.getSelector().add(new SelectorItemInfo("company.*"));
        view.setFilter(new FilterInfo());
        view.getFilter().getFilterItems().add(new FilterItemInfo("company.id", (Object)this.getCompanyOrgUnitInfo().getId().toString()));
        view.getFilter().getFilterItems().add(new FilterItemInfo("year", (Object)this.year.getIntegerVlaue()));
        view.getFilter().getFilterItems().add(new FilterItemInfo("item.isFreezed", (Object)Boolean.FALSE));
        view.getFilter().getFilterItems().add(new FilterItemInfo("dataCollectNumber", (Object)this.dataCollectNumber));
        if (this.currency.getValue() != null) {
            cur = (CurrencyInfo)this.currency.getValue();
            view.getFilter().getFilterItems().add(new FilterItemInfo("currency.id", (Object)cur.getId().toString()));
        }
        if (this.srcCurrency.getValue() != null) {
            cur = (CurrencyInfo)this.srcCurrency.getValue();
            view.getFilter().getFilterItems().add(new FilterItemInfo("sourceCurrency.id", (Object)cur.getId().toString()));
        }
        if (this.type.getSelectedItem() != null) {
            cur = (SysDataElementEnum)this.type.getSelectedItem();
            view.getFilter().getFilterItems().add(new FilterItemInfo("dataElement", (Object)new Integer(cur.getValue())));
        }
        view.getSorter().add(new SorterItemInfo("item.number"));
        return ItemDataYearInitFactory.getRemoteInstance().getCollection(view);
    }

    private OrgUnitInfo getCompanyOrgUnitInfo() {
        return RptNewUIUtil.getRptWktOrgUnitInfo((Map)this.getUIContext(), (IUIObject)this);
    }

    class ChangeLiser
    implements ChangeListener {
        ChangeLiser() {
        }

        @Override
        public void stateChanged(ChangeEvent arg0) {
            try {
                ItemDataYearInitBaseEditUI.this.loadData();
            }
            catch (BOSException e) {
                ItemDataYearInitBaseEditUI.this.handUIException(e);
            }
        }
    }
}

