/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.client;

import com.kingdee.bos.ctrl.swing.ISimpleStatusBarRenderer;
import com.kingdee.bos.ctrl.swing.KDStatusBar;
import com.kingdee.bos.ctrl.swing.SimpleStatusBarPart;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.uiframe.client.MainStatusBar;
import com.kingdee.eas.base.uiframe.client.UINewFrame;
import com.kingdee.eas.fi.rpt.client.CalculateProgressUI;
import com.kingdee.eas.framework.client.CoreUI;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JComponent;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;

public final class ProgressManager {
    public static final int DEF_CONSUMING = 5000;
    public static final int MAX_CONSUMING = 600000;
    private JProgressBar bar;
    private MainStatusBar msb;
    private javax.swing.Timer timer;
    private int count;
    private CoreUI uiBase;
    CalculateProgressUI progress = null;
    private Object mutx = new Object();

    public void setMainStatusBar(MainStatusBar mbar) {
        this.msb = mbar;
    }

    public MainStatusBar getMainStatusBar() {
        if (this.msb == null) {
            this.msb = MainStatusBar.getMainStatusBar();
        }
        return this.msb;
    }

    public static JProgressBar getProgressBar(CoreUI ui) {
        if (ui == null) {
            return null;
        }
        KDStatusBar sb = ui.getStatusBar();
        if (sb == null) {
            return null;
        }
        SimpleStatusBarPart sp = sb.getPart(0);
        if (sp == null) {
            return null;
        }
        ISimpleStatusBarRenderer sr = sp.getRenderer((Object)"ProgressBar");
        if (sr == null) {
            return null;
        }
        JComponent com = sr.getComponent(null);
        return com instanceof JProgressBar ? (JProgressBar)com : null;
    }

    public ProgressManager(CoreUI ui) {
        this.uiBase = ui;
        this.bar = null;
    }

    public ProgressManager(JProgressBar pbar) {
        this.bar = pbar;
    }

    public JProgressBar getProgressBar() {
        return this.bar;
    }

    public synchronized void setProgressBar(JProgressBar pbar) {
        if (!this.getTimer().isRunning()) {
            this.bar = pbar;
        }
    }

    public synchronized void setEstimateTime(int millisecondConsuming) {
        if (!this.getTimer().isRunning()) {
            this.getTimer().setDelay(this.getDelay(millisecondConsuming));
        }
    }

    public synchronized boolean startProcess() {
        if (this.getTimer().isRunning()) {
            return false;
        }
        this.count = 0;
        this.getTimer().start();
        return true;
    }

    public synchronized boolean stopProcess() {
        if (this.getTimer().isRunning()) {
            this.getTimer().stop();
        }
        this.count = 0;
        return false;
    }

    public void launchProcess(Runnable proc) {
        this.launchProcess(proc, 5000);
    }

    public synchronized void launchProcess(Runnable proc, int estimateTime) {
        if (proc == null || this.getTimer().isRunning()) {
            return;
        }
        this.setEstimateTime(estimateTime);
        this.startProcess();
        new ProcDelegate().start(proc);
    }

    void runProc(Runnable target) {
        if (target == null) {
            return;
        }
        target.run();
        this.stopProcess();
        this.setProcess(100);
        this.postCleaning();
    }

    public synchronized boolean setProcess(int percent) {
        if (this.bar == null) {
            return false;
        }
        if (percent < 0) {
            percent = 0;
        } else if (percent > 100) {
            percent = 100;
        }
        this.bar.setValue(percent);
        if (percent > 0) {
            this.bar.setString(percent + "%");
        } else {
            this.bar.setString("");
        }
        return true;
    }

    private javax.swing.Timer getTimer() {
        if (this.timer == null) {
            this.timer = new javax.swing.Timer(1000, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ProgressManager.this.onTimer();
                }
            });
        }
        return this.timer;
    }

    private int getDelay(int millisecondConsuming) {
        if (millisecondConsuming > 600000) {
            millisecondConsuming = 600000;
        } else if (millisecondConsuming < 0) {
            millisecondConsuming = 5000;
        }
        int res = millisecondConsuming / 100;
        return res < 10 ? 10 : (res > 100000 ? 100000 : res);
    }

    void onTimer() {
        if (this.bar == null) {
            return;
        }
        if (this.count <= 0) {
            this.bar.getModel().setMaximum(100);
            this.bar.getModel().setMinimum(0);
            this.count = 0;
        }
        if (++this.count >= 99) {
            this.count = 99;
        }
        this.bar.setValue(this.count);
        this.bar.setString(this.count + "%");
    }

    public void postCleaning() {
        this.postCleaning(1000);
    }

    public void postCleaning(int time) {
        if (time == 600000) {
            return;
        }
        if (time < 0) {
            time = 5000;
        }
        new Timer(true).schedule(new TimerTask(){

            @Override
            public void run() {
                ProgressManager.this.setProcess(0);
                if (ProgressManager.this.getMainStatusBar() != null) {
                    ProgressManager.this.getMainStatusBar().setMessage(null);
                }
            }
        }, time);
    }

    public void popMessage(String msg) {
        this.popMessage(msg, -1);
    }

    public void popMessage2(String msg, int time) {
        if (this.getTimer().isRunning()) {
            return;
        }
        if (this.getMainStatusBar() != null) {
            this.getMainStatusBar().setMessage(msg);
        } else if (this.bar != null) {
            this.bar.setString(msg);
        }
        this.postCleaning(time);
    }

    public void popMessage(String msg, int time) {
        if (this.uiBase == null) {
            this.popMessage2(msg, time);
        } else if (SwingUtilities.getWindowAncestor((Component)this.uiBase) instanceof UINewFrame) {
            if (msg == null || msg.length() < 1) {
                this.uiBase.resetMessageBgcolor();
                this.uiBase.resetMessageIcon();
                this.uiBase.resetMessageText();
                this.getMainStatusBar().setMessage(null);
                this.getMainStatusBar().setIcon(null);
            } else if (this.uiBase.getMainStatusBar() != null) {
                this.uiBase.setMessageText(msg);
                this.uiBase.showMessage();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void popupProgress(CoreUIObject uiobj) {
        Object object = this.mutx;
        synchronized (object) {
            if (this.progress == null) {
                try {
                    this.progress = CalculateProgressUI.getInstance(uiobj);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.progress != null && this.progress.getUIWindow() != null) {
                this.progress.getUIWindow().show();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeProgress() {
        Object object = this.mutx;
        synchronized (object) {
            if (this.progress != null) {
                this.progress.destroyWindow();
                this.progress = null;
            }
        }
    }

    public void launchProcess(DaemonTask proc, CoreUIObject uiObj) {
        String actionName = "Report Calculate??";
        final CoreUIObject obj = uiObj;
        final DaemonTask p = proc;
        Thread workThread = new Thread("Report Calculate"){

            @Override
            public void run() {
                obj.addJobToPool("Report Calculate??", (Thread)this);
                if (!SwingUtilities.isEventDispatchThread()) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ProgressManager.this.popupProgress(obj);
                        }
                    });
                }
                p.run();
                if (!SwingUtilities.isEventDispatchThread()) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ProgressManager.this.closeProgress();
                        }
                    });
                }
                obj.removeFromPool("Report Calculate??");
            }
        };
        workThread.start();
    }

    public static interface DaemonTask {
        public void run();
    }

    private class ProcDelegate
    extends Thread {
        public Runnable core = null;

        private ProcDelegate() {
        }

        public void start(Runnable target) {
            this.core = target;
            this.start();
        }

        @Override
        public void run() {
            ProgressManager.this.runProc(this.core);
        }
    }
}

