/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.util.file.KDF;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.AssignmentInfo;
import com.kingdee.bos.workflow.biz.BizClient;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.cslrpt.ConvertStatusEnum;
import com.kingdee.eas.fi.gr.cslrpt.DataCollectCollection;
import com.kingdee.eas.fi.gr.cslrpt.DataCollectConstant;
import com.kingdee.eas.fi.gr.cslrpt.DataCollectInfo;
import com.kingdee.eas.fi.gr.cslrpt.FiscalPeriodHelper;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.rpt.AuditedStatusEnum;
import com.kingdee.eas.fi.rpt.CommittedStatusEnum;
import com.kingdee.eas.fi.rpt.IReport;
import com.kingdee.eas.fi.rpt.InitDataFacadaFactory;
import com.kingdee.eas.fi.rpt.IsSupportGroupReportEnum;
import com.kingdee.eas.fi.rpt.PublicStatusEnum;
import com.kingdee.eas.fi.rpt.PublishedStatusEnum;
import com.kingdee.eas.fi.rpt.ReportBaseCollection;
import com.kingdee.eas.fi.rpt.ReportBaseInfo;
import com.kingdee.eas.fi.rpt.ReportFactory;
import com.kingdee.eas.fi.rpt.ReportInfo;
import com.kingdee.eas.fi.rpt.ReportTypeCollection;
import com.kingdee.eas.fi.rpt.ReportTypeEnum;
import com.kingdee.eas.fi.rpt.RptHandleStatusEnum;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.fi.rpt.RptTmpTypeEnum;
import com.kingdee.eas.fi.rpt.RptTypeRelaInfo;
import com.kingdee.eas.fi.rpt.TemplateFactory;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.fi.rpt.VirtualSheetParamInfo;
import com.kingdee.eas.fi.rpt.client.AbstractReportEditUI;
import com.kingdee.eas.fi.rpt.client.ReportMaintainUI;
import com.kingdee.eas.fi.rpt.client.RptBaseMenuStrategy;
import com.kingdee.eas.fi.rpt.client.RptComboBoxModel;
import com.kingdee.eas.fi.rpt.client.RptFindCelltReportMenuStrategy;
import com.kingdee.eas.fi.rpt.client.RptReportMenuStrategy;
import com.kingdee.eas.fi.rpt.client.RptReportProcessUI;
import com.kingdee.eas.fi.rpt.client.RptStrategyManager;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import org.apache.log4j.Logger;

public class ReportEditUI
extends AbstractReportEditUI {
    private static final Logger log = Logger.getLogger((String)ReportEditUI.class.getName());
    private boolean isFindCell = false;
    int currentsubReportNumber = 0;
    private HashMap dataCollectMap = new HashMap();
    private boolean hasBudgetedPermission = false;
    private boolean hasACPermission = false;
    private static final int RPT_PERIOD_12 = 12;
    private static final int RPT_PERIOD_13 = 13;
    boolean isMergeByFiscalPeriod;

    public ReportEditUI() throws Exception {
        this.btnSubmitUnAudit.putClientProperty((Object)"IsInArrowScope", (Object)Boolean.FALSE);
        this.btnUnSubmit.putClientProperty((Object)"IsInArrowScope", (Object)Boolean.FALSE);
    }

    @Override
    public SelectorItemCollection getSelectors() {
        return this.getSelfSelections();
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
        this.remove((Component)this.btnAdd);
        this.remove((Component)this.btnDel);
        this.ctnSubReports.addButton((JButton)this.btnAdd);
        this.ctnSubReports.addButton((JButton)this.btnDel);
    }

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        this.isMergeByFiscalPeriod = this.msgMng.getItemBooleanValue("isMergeByFiscalPeriod");
        Boolean isMultiApprove = (Boolean)this.getUIContext().get("isMultiApprove");
        if (isMultiApprove != null && isMultiApprove.booleanValue()) {
            this.lockUIComponent();
        }
        ActionListener updateListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ReportEditUI.this.updateIncludeAdjust();
                if (arg0.getSource().equals(ReportEditUI.this.cbxStartYear)) {
                    ReportEditUI.this.refresh13Period();
                }
            }
        };
        this.cbxPeriodType.addActionListener(updateListener);
        this.dpkStarDate.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                ReportEditUI.this.updateIncludeAdjust();
            }
        });
        this.cbxStartYear.addActionListener(updateListener);
        this.cbxStartPeriod.addActionListener(updateListener);
        if (this.editData.isIsSupportAdjust()) {
            this.cbIncludeAdjust.setEnabled(true);
            this.cbIncludeAdjust.setVisible(true);
            this.cbIncludeAdjust.setSelected(true);
        } else {
            this.cbIncludeAdjust.setSelected(false);
        }
        this.updateIncludeAdjust();
        this.refresh13Period();
        this.cbxDataCollect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReportEditUI.this.refresh13Period();
            }
        });
    }

    public void loadState() {
        int i;
        ActionListener[] cbxStartYear_al;
        int i2;
        ActionListener[] cbxStartPeriod_al = this.cbxStartPeriod.getActionListeners();
        if (cbxStartPeriod_al != null) {
            for (i2 = 0; i2 < cbxStartPeriod_al.length; ++i2) {
                this.cbxStartPeriod.removeActionListener(cbxStartPeriod_al[i2]);
            }
        }
        this.cbxStartPeriod.setSelectedItem((Object)new Integer(this.editData.getPeriod()));
        if (cbxStartPeriod_al != null) {
            for (i2 = 0; i2 < cbxStartPeriod_al.length; ++i2) {
                this.cbxStartPeriod.addActionListener(cbxStartPeriod_al[i2]);
            }
        }
        if ((cbxStartYear_al = this.cbxStartYear.getActionListeners()) != null) {
            for (i = 0; i < cbxStartYear_al.length; ++i) {
                this.cbxStartYear.removeActionListener(cbxStartYear_al[i]);
            }
        }
        this.cbxStartYear.setSelectedItem((Object)new Integer(this.editData.getYear()));
        if (cbxStartYear_al != null) {
            for (i = 0; i < cbxStartYear_al.length; ++i) {
                this.cbxStartYear.addActionListener(cbxStartYear_al[i]);
            }
        }
        if (this.editData.isIsSupportAdjust()) {
            this.cbIncludeAdjust.setEnabled(true);
            this.cbIncludeAdjust.setVisible(true);
            this.cbIncludeAdjust.setSelected(true);
        } else {
            this.cbIncludeAdjust.setSelected(false);
        }
        if (!StringUtils.isEmpty((String)this.editData.getNumber())) {
            this.txtNumber.setText(this.editData.getNumber());
        }
        if (this.editData.getPeriodType() != null) {
            this.isLoadState = true;
            this.cbxPeriodType.setSelectedItem((Object)RptPeriodTypeEnum.YEARLY, true);
            this.cbxPeriodType.setSelectedItem((Object)this.editData.getPeriodType(), true);
            this.cbxStartPeriod.setSelectedItem((Object)new Integer(this.editData.getPeriod()));
            this.isLoadState = false;
            System.out.println();
        }
        if (this.editData.getTemplate() != null) {
            this.cbxPeriodType.setEnabled(false);
        }
        if (this.editData.getDataCollectNumber() != null && this.dataCollectMap.containsKey(this.editData.getDataCollectNumber())) {
            this.cbxDataCollect.setSelectedItem(this.dataCollectMap.get(this.editData.getDataCollectNumber()));
        }
        this.updateIncludeAdjust();
        if (this.editData.getConvertStatus() == ConvertStatusEnum.Converted) {
            this.cbxCurrency.setEnabled(false);
        }
    }

    public void updateIncludeAdjust() {
        RptPeriodTypeEnum period = (RptPeriodTypeEnum)this.cbxPeriodType.getSelectedItem();
        if (RptPeriodTypeEnum.MONTHLY.equals((Object)period)) {
            if ("12".equals(this.cbxStartPeriod.getSelectedItem().toString().trim())) {
                this.cbIncludeAdjust.setEnabled(true);
                this.cbIncludeAdjust.setVisible(true);
                if (this.editData.isIsSupportAdjust()) {
                    this.cbIncludeAdjust.setSelected(true);
                } else {
                    this.cbIncludeAdjust.setSelected(false);
                }
            } else {
                this.cbIncludeAdjust.setSelected(false);
                this.cbIncludeAdjust.setEnabled(false);
                this.cbIncludeAdjust.setVisible(false);
            }
        } else if (RptPeriodTypeEnum.QUARTERLY.equals((Object)period)) {
            if ("4".equals(this.cbxStartPeriod.getSelectedItem().toString().trim())) {
                this.cbIncludeAdjust.setEnabled(true);
                this.cbIncludeAdjust.setVisible(true);
                if (this.editData.isIsSupportAdjust()) {
                    this.cbIncludeAdjust.setSelected(true);
                } else {
                    this.cbIncludeAdjust.setSelected(false);
                }
            } else {
                this.cbIncludeAdjust.setSelected(false);
                this.cbIncludeAdjust.setEnabled(false);
                this.cbIncludeAdjust.setVisible(false);
            }
        } else if (RptPeriodTypeEnum.SEMIYEARLY.equals((Object)period)) {
            if ("2".equals(this.cbxStartPeriod.getSelectedItem().toString().trim())) {
                this.cbIncludeAdjust.setEnabled(true);
                this.cbIncludeAdjust.setVisible(true);
                if (this.editData.isIsSupportAdjust()) {
                    this.cbIncludeAdjust.setSelected(true);
                } else {
                    this.cbIncludeAdjust.setSelected(false);
                }
            } else {
                this.cbIncludeAdjust.setSelected(false);
                this.cbIncludeAdjust.setEnabled(false);
                this.cbIncludeAdjust.setVisible(false);
            }
        } else if (RptPeriodTypeEnum.YEARLY.equals((Object)period)) {
            this.cbIncludeAdjust.setEnabled(true);
            this.cbIncludeAdjust.setVisible(true);
            if (this.editData.isIsSupportAdjust()) {
                this.cbIncludeAdjust.setSelected(true);
            } else {
                this.cbIncludeAdjust.setSelected(false);
            }
        } else if (RptPeriodTypeEnum.DAILY.equals((Object)period)) {
            Date date = (Date)this.dpkStarDate.getValue();
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            if (calendar.get(2) == 11 && calendar.get(5) == 31) {
                this.cbIncludeAdjust.setEnabled(true);
                this.cbIncludeAdjust.setVisible(true);
                if (this.editData.isIsSupportAdjust()) {
                    this.cbIncludeAdjust.setSelected(true);
                } else {
                    this.cbIncludeAdjust.setSelected(false);
                }
            } else {
                this.cbIncludeAdjust.setSelected(false);
                this.cbIncludeAdjust.setEnabled(false);
                this.cbIncludeAdjust.setVisible(false);
            }
        } else {
            this.cbIncludeAdjust.setSelected(false);
            this.cbIncludeAdjust.setEnabled(false);
            this.cbIncludeAdjust.setVisible(false);
        }
    }

    @Override
    public void initUIMenuBarLayout() {
    }

    @Override
    public void initUIToolBarLayout() {
    }

    @Override
    public void actionEditReport_actionPerformed(ActionEvent e) throws Exception {
        super.actionEditReport_actionPerformed(e);
    }

    @Override
    public void loadFields() {
        super.loadFields();
        if (this.editData.getPeriod() != this.currentPeriod.shortValue()) {
            this.currentPeriod = new Integer(this.editData.getPeriod());
        }
        if (this.editData.getYear() != this.currentYear.intValue()) {
            this.currentYear = new Integer(this.editData.getYear());
        }
        try {
            this.comboYearChange();
        }
        catch (EASBizException e1) {
            log.debug((Object)e1.getMessage());
        }
        catch (BOSException e1) {
            log.debug((Object)e1.getMessage());
        }
        this.selfLoadField();
        if (this.editData.isIsSupportAdjust()) {
            this.cbIncludeAdjust.setEnabled(true);
            this.cbIncludeAdjust.setVisible(true);
            this.cbIncludeAdjust.setSelected(true);
        } else {
            this.cbIncludeAdjust.setSelected(false);
        }
        if (this.editData.isIsOpenAutoCalc()) {
            this.chkCalculate.setSelected(true);
        } else {
            this.chkCalculate.setSelected(false);
        }
        if (this.getOprtState().equals(OprtState.ADDNEW)) {
            String param = null;
            param = this.msgMng.getItemStringValue("fi_rp_005");
            if (param != null && "true".equalsIgnoreCase(param)) {
                this.chkPublic.setSelected(true);
            } else {
                this.chkPublic.setSelected(false);
            }
        } else if (this.editData.getPublicStatus().getValue() == 2) {
            this.chkPublic.setSelected(true);
        } else {
            this.chkPublic.setSelected(false);
        }
        this.cbxPublished.setSelectedItem((Object)this.editData.getPublishedStatus());
        this.initSubReport();
        if (this.editData.getCurrency() != null) {
            String id = this.editData.getCurrency().getId().toString();
            for (int i = 0; i < this.cbxCurrency.getItemCount(); ++i) {
                CurrencyInfo info = (CurrencyInfo)this.cbxCurrency.getItemAt(i);
                if (!info.getId().toString().equals(id)) continue;
                this.cbxCurrency.setSelectedIndex(i);
            }
        }
        if (this.editData.getDataCollectNumber() != null && this.dataCollectMap.containsKey(this.editData.getDataCollectNumber())) {
            this.cbxDataCollect.setSelectedItem(this.dataCollectMap.get(this.editData.getDataCollectNumber()));
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
        this.editData.setName(this.txtName.getText());
        this.editData.setNumber(this.txtNumber.getText());
        this.editData.setCurrency((CurrencyInfo)this.cbxCurrency.getSelectedItem());
        this.editData.setTemplate((TemplateInfo)this.prmtTemplate.getData());
        this.editData.setExchangeRate(new BigDecimal("1"));
        this.editData.setPeriodType((RptPeriodTypeEnum)this.cbxPeriodType.getSelectedItem());
        this.editData.setHandleStatus(RptHandleStatusEnum.FINISHED);
        this.editData.setYear(Integer.parseInt(this.cbxStartYear.getSelectedItem().toString()));
        this.editData.setPeriod(Short.parseShort(this.cbxStartPeriod.getSelectedItem().toString()));
        DataCollectInfo dataCollectSelected = (DataCollectInfo)this.cbxDataCollect.getSelectedItem();
        this.editData.setDataCollect(dataCollectSelected);
        this.editData.setDataCollectNumber(dataCollectSelected.getNumber());
        ReportTypeCollection savePointReportTypeColl = (ReportTypeCollection)((Object)this.prmtSavePlace.getData());
        this.editData.getSavePoint().clear();
        if (savePointReportTypeColl != null && savePointReportTypeColl.size() > 0) {
            int savePointReportTypeCollSize = savePointReportTypeColl.size();
            for (int i = 0; i < savePointReportTypeCollSize; ++i) {
                RptTypeRelaInfo temp = new RptTypeRelaInfo();
                temp.setRptType(savePointReportTypeColl.get(i));
                temp.setRelaType(ReportTypeEnum.REPORT);
                this.editData.getSavePoint().add(temp);
            }
        }
        PeriodCollection periods = null;
        if (FiscalPeriodHelper.isMergeByFiscalPeriod((boolean)this.isMergeByFiscalPeriod, (RptPeriodTypeEnum)this.editData.getPeriodType())) {
            try {
                periods = InitDataFacadaFactory.getRemoteInstance().getFiscal();
            }
            catch (Exception e11) {
                periods = null;
                this.handUIException(e11);
            }
        }
        if (periods != null) {
            Date periodfirstDate = FiscalPeriodHelper.getPeriodFirstDate((int)this.editData.getYear(), (int)this.editData.getPeriod(), (RptPeriodTypeEnum)this.editData.getPeriodType(), (PeriodCollection)periods, (boolean)true);
            Date periodLastDate = FiscalPeriodHelper.getPeriodLastDate((PeriodCollection)periods, (int)this.editData.getYear(), (int)this.editData.getPeriod(), (RptPeriodTypeEnum)this.editData.getPeriodType(), (boolean)true);
            this.editData.setStartDate(periodfirstDate);
            this.editData.setEndDate(periodLastDate);
            if (this.editData.getPeriodType().getValue() == 6) {
                this.editData.setPeriod((short)1);
            }
        } else if (((RptPeriodTypeEnum)this.cbxPeriodType.getSelectedItem()).getValue() == 1) {
            this.editData.setStartDate((Date)this.dpkStarDate.getValue(Date.class));
            this.editData.setEndDate((Date)this.dpkStarDate.getValue(Date.class));
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(this.editData.getEndDate());
            short period = (short)RPTDateUtil.getPeriod((int)calendar.get(1), (int)(calendar.get(2) + 1), (int)calendar.get(5), (RptPeriodTypeEnum)RptPeriodTypeEnum.DAILY);
            this.editData.setPeriod(period);
            this.editData.setYear(calendar.get(1));
        } else if (((RptPeriodTypeEnum)this.cbxPeriodType.getSelectedItem()).getValue() == 2) {
            this.editData.setStartDate(RPTDateUtil.getPeriodFirstDate((int)this.editData.getYear(), (int)(this.editData.getPeriod() + 1 - 1), (RptPeriodTypeEnum)RptPeriodTypeEnum.WEEKLY));
            this.editData.setEndDate(RPTDateUtil.getPeriodLastDate((int)this.editData.getYear(), (int)(this.editData.getPeriod() + 1 - 1), (RptPeriodTypeEnum)RptPeriodTypeEnum.WEEKLY));
        } else if (((RptPeriodTypeEnum)this.cbxPeriodType.getSelectedItem()).getValue() == 3) {
            if (this.editData.getPeriod() == 13) {
                Calendar calendar = Calendar.getInstance();
                calendar.set(1, this.editData.getYear());
                calendar.set(2, 11);
                calendar.set(5, 31);
                Date date = new Date(calendar.getTimeInMillis());
                this.editData.setStartDate(date);
                this.editData.setEndDate(date);
            } else {
                this.editData.setStartDate(RPTDateUtil.getPeriodFirstDate((int)this.editData.getYear(), (int)(this.editData.getPeriod() + 1 - 1), (RptPeriodTypeEnum)RptPeriodTypeEnum.MONTHLY));
                this.editData.setEndDate(RPTDateUtil.getPeriodLastDate((int)this.editData.getYear(), (int)(this.editData.getPeriod() + 1 - 1), (RptPeriodTypeEnum)RptPeriodTypeEnum.MONTHLY));
            }
        } else if (((RptPeriodTypeEnum)this.cbxPeriodType.getSelectedItem()).getValue() == 4) {
            this.editData.setStartDate(RPTDateUtil.getPeriodFirstDate((int)this.editData.getYear(), (int)(this.editData.getPeriod() + 1 - 1), (RptPeriodTypeEnum)RptPeriodTypeEnum.QUARTERLY));
            this.editData.setEndDate(RPTDateUtil.getPeriodLastDate((int)this.editData.getYear(), (int)(this.editData.getPeriod() + 1 - 1), (RptPeriodTypeEnum)RptPeriodTypeEnum.QUARTERLY));
        } else if (((RptPeriodTypeEnum)this.cbxPeriodType.getSelectedItem()).getValue() == 5) {
            this.editData.setStartDate(RPTDateUtil.getPeriodFirstDate((int)this.editData.getYear(), (int)(this.editData.getPeriod() + 1 - 1), (RptPeriodTypeEnum)RptPeriodTypeEnum.SEMIYEARLY));
            this.editData.setEndDate(RPTDateUtil.getPeriodLastDate((int)this.editData.getYear(), (int)(this.editData.getPeriod() + 1 - 1), (RptPeriodTypeEnum)RptPeriodTypeEnum.SEMIYEARLY));
        } else if (((RptPeriodTypeEnum)this.cbxPeriodType.getSelectedItem()).getValue() == 6) {
            this.editData.setPeriod((short)1);
            this.editData.setStartDate(RPTDateUtil.getPeriodFirstDate((int)this.editData.getYear(), (int)(this.editData.getPeriod() + 1 - 1), (RptPeriodTypeEnum)RptPeriodTypeEnum.YEARLY));
            this.editData.setEndDate(RPTDateUtil.getPeriodLastDate((int)this.editData.getYear(), (int)(this.editData.getPeriod() + 1 - 1), (RptPeriodTypeEnum)RptPeriodTypeEnum.YEARLY));
        } else {
            this.editData.setStartDate((Date)this.dpkStarDate.getValue(Date.class));
            this.editData.setEndDate((Date)this.dpkStarDate.getValue(Date.class));
        }
        if (this.chkCalculate.getSelected() == 32) {
            this.editData.setIsOpenAutoCalc(true);
        } else {
            this.editData.setIsOpenAutoCalc(false);
        }
        if (this.chkPublic.getSelected() == 32) {
            this.editData.setPublicStatus(PublicStatusEnum.PUBLIC);
        } else {
            this.editData.setPublicStatus(PublicStatusEnum.UNPUBLIC);
        }
        this.editData.setCompany(this.getCurrCompanyOrgInfo());
        this.editData.setIsSupportAdjust(this.cbIncludeAdjust.isSelected());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public VirtualSheetParamInfo save() throws Exception {
        try {
            this.isSaving = true;
            this.selfVerifyInput();
        }
        catch (Exception e) {
            this.getUIWindow().show();
            if (this.getButtonAction() == 1) {
                this.save();
            }
            this.abort();
        }
        if (this.editData.getAuditedStatus() != null && this.editData.getAuditedStatus().getValue() == 2) {
            MsgBox.showInfo((String)RptUtil.getResourceSince51("ReportAlreadyAudited"));
            this.editData.setChgStatus(0);
            return this.editData;
        }
        this.checkAssignment((ItemAction)this.actionSubmit);
        this.storeFields();
        this.verifyInput(null);
        if (this.isVersion() && this.getOprtState().equals("EDIT")) {
            boolean msgYES;
            int isok = MsgBox.showConfirm3((String)RptUtil.getResourceSince51("PerformHistoryVersion"));
            boolean msgOk = isok == 0;
            boolean bl = msgYES = isok == 0;
            if (msgOk || msgYES) {
                ((IReport)this.getBizInterface()).reportVersion(this.editData);
            } else {
                if (isok != 2 && isok != 1) {
                    this.editData.setChgStatus(0);
                    return this.editData;
                }
                ((IReport)this.getBizInterface()).submit((CoreBaseInfo)this.editData);
            }
        } else {
            ((IReport)this.getBizInterface()).submit((CoreBaseInfo)this.editData);
        }
        this.setOprtState("EDIT");
        this.setDataObject((IObjectValue)this.getBizInterface().getValue((IObjectPK)new ObjectUuidPK(this.editData.getId()), this.getSelectors()));
        this.save = true;
        this.txtNumber.setText(this.editData.getNumber());
        return this.editData;
    }

    @Override
    public VirtualSheetParamInfo saveAs() throws Exception {
        this.selfVerifyInput();
        this.storeFields();
        this.verifyInput(null);
        String oldId = this.editData.getId().toString();
        this.editData.setAuditedStatus(AuditedStatusEnum.UNAUDITED);
        this.editData.setPublishedStatus(PublishedStatusEnum.UNPUBLISHED);
        this.editData.setAuditor(null);
        this.editData.setAuditTime(null);
        this.editData.setId(null);
        this.editData.setIsSupportGroup(IsSupportGroupReportEnum.NOTSUPPORT);
        this.editData.setCommittedStatus(CommittedStatusEnum.UNCOMMITTED);
        IObjectPK pk = ((IReport)this.getBizInterface()).submit((CoreBaseInfo)this.editData);
        this.releaseObjectLock(oldId);
        this.setOprtState("EDIT");
        this.setDataObject((IObjectValue)((IReport)this.getBizInterface()).getReportInfo(pk, this.getSelectors()));
        this.save = true;
        this.isSaveAs = true;
        this.txtNumber.setText(this.editData.getNumber());
        return this.editData;
    }

    private boolean templateVersion() throws Exception {
        if (!this.isVersion()) {
            return false;
        }
        if (this.editData.getAuditedStatus() != null && this.editData.getAuditedStatus().getValue() == 2) {
            int isok = MsgBox.showConfirm2((String)RptUtil.getResourceSince51("ReportAuditedPerformVersion"));
            if (isok == 0) {
                ((IReport)this.getBizInterface()).reportVersion(this.editData);
            }
            return true;
        }
        return false;
    }

    @Override
    public void actionUnSubmit_actionPerformed(ActionEvent e) throws Exception {
        ObjectUuidPK pk = new ObjectUuidPK(this.editData.getId());
        if ("EDIT".equals(this.getOprtState()) || "VIEW".equals(this.getOprtState())) {
            BizClient bizClient = BizClient.newInstance();
            AssignmentInfo[] assignments = bizClient.checkAssignmentInfos(this.editData.getId().toString(), SysContext.getSysContext().getCurrentUserInfo().getId().toString());
            if (assignments == null || assignments.length == 0) {
                MsgBox.showInfo((String)RptUtil.getResourceSince51("ReportNotInWorkflow"));
                SysUtil.abort();
            }
            int length = assignments.length;
            for (int i = 0; i < length; ++i) {
                String actionName = assignments[i].getBizOperation();
                if (actionName.equalsIgnoreCase("ActionUnSubmit")) {
                    this.wfContext.addToDataMap((Object)this.editData.getId().toString(), this.getValue((IObjectPK)pk));
                    ReportFactory.getRemoteInstance().unSubmit(this.editData.getId());
                    break;
                }
                if (i != length - 1) continue;
                MsgBox.showInfo((String)RptUtil.getResourceSince51("ReportHasbeenAudited"));
                SysUtil.abort();
            }
        }
    }

    @Override
    public void actionSubmitUnAudit_actionPerformed(ActionEvent e) throws Exception {
        ObjectUuidPK pk = new ObjectUuidPK(this.editData.getId());
        this.wfContext.addToDataMap((Object)this.editData.getId().toString(), this.getValue((IObjectPK)pk));
        ReportFactory.getRemoteInstance().submitUnAudite(this.editData.getId());
    }

    @Override
    public void submitWorkFlow() throws Exception {
        if (!((IReport)this.getBizInterface()).exists((IObjectPK)new ObjectUuidPK(this.editData.getId()))) {
            MsgBox.showInfo((String)RptUtil.getResourceSince51("ReportHasbeenDeleted"));
            SysUtil.abort();
        }
        if (this.getIsAudit()) {
            if (this.isPublish()) {
                MsgBox.showInfo((String)RptUtil.getResourceSince51("ReportHasbeenPublished"));
                SysUtil.abort();
            } else {
                this.btnSubmitUnAudit.doClick();
            }
        } else {
            this.actionSubmit.setEnabled(true);
            super.submitWorkFlow();
        }
    }

    public boolean isPublish() throws Exception {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("publishedStatus"));
        ReportInfo reportInfo = ((IReport)this.getBizInterface()).getReportInfo((IObjectPK)new ObjectUuidPK(this.editData.getId()), sic);
        return reportInfo.getPublishedStatus() != null && reportInfo.getPublishedStatus().getValue() == 2;
    }

    public boolean getIsAudit() throws Exception {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("auditedStatus"));
        ReportInfo reportInfo = ((IReport)this.getBizInterface()).getReportInfo((IObjectPK)new ObjectUuidPK(this.editData.getId()), sic);
        return reportInfo.getAuditedStatus() != null && reportInfo.getAuditedStatus().getValue() == 2;
    }

    @Override
    public void unSubmit() throws Exception {
        this.actionUnSubmit_actionPerformed(null);
    }

    @Override
    protected void openReport(boolean isStore, boolean isShowReport) throws Exception {
        if ("EDIT".equals(this.getOprtState()) || "VIEW".equals(this.getOprtState())) {
            BizClient bizClient = BizClient.newInstance();
            AssignmentInfo[] assignments = bizClient.checkAssignmentInfos(this.editData.getId().toString(), SysContext.getSysContext().getCurrentUserInfo().getId().toString());
            int length = assignments.length;
            for (int i = 0; i < length; ++i) {
                String actionName = assignments[i].getBizOperation();
                if (!actionName.equalsIgnoreCase("ActionUnSubmit")) continue;
                this.getRptStrategyManager();
                ((RptReportMenuStrategy)this.rptStrategyManager.getRptMenuStartegy()).setWorkflowStatus(1);
                break;
            }
        }
        super.openReport(isStore, isShowReport);
    }

    @Override
    public String getProcessUI() {
        return RptReportProcessUI.class.getName();
    }

    @Override
    public RptStrategyManager getRptStrategyManager() {
        return super.getRptStrategyManager();
    }

    public void openNewReport(KDF kdf, UIContext uiContext) throws Exception {
        this.setDataObject(this.createNewData());
        this.setOprtState("VIEW");
        this.isFindCell = true;
        this.editData.setName(RptUtil.getResourceSince51("CellAssn"));
        this.editData.setKDF(kdf);
        this.editData.setSourceType(RptSrcTypeEnum.NORMAL);
        uiContext.put((Object)"self", (Object)this);
        uiContext.put((Object)"saveUI", (Object)this.getMetaDataPK().getFullName());
        uiContext.put((Object)"ID", (Object)this.editData.getId().toString());
        this.uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(this.getProcessUI(), (Map)uiContext, null, this.getOprtState());
        this.uiWindow.show();
    }

    @Override
    public RptBaseMenuStrategy getReportMenuStrategy() {
        if (this.isFindCell) {
            return new RptFindCelltReportMenuStrategy();
        }
        return super.getReportMenuStrategy();
    }

    @Override
    public boolean destroyWindow() {
        return super.destroyWindow();
    }

    public void initSubReport() {
        this.tblSubReports.removeRows();
        if (this.editData != null && this.editData.getSubReport() != null) {
            ReportBaseCollection subReport = this.editData.getSubReport();
            int size = subReport.size();
            for (int i = 0; i < size; ++i) {
                this.addTable(subReport.get(i));
            }
        }
    }

    private void addTable(ReportBaseInfo reportInfo) {
        IRow row = this.tblSubReports.addRow();
        row.getStyleAttributes().setLocked(true);
        row.getCell("object").setValue((Object)reportInfo);
        row.getCell("number").setValue((Object)reportInfo.getNumber());
        row.getCell("name").setValue((Object)reportInfo.getName());
        row.getCell("sourceType").setValue((Object)reportInfo.getSourceType());
        row.getCell("period").setValue((Object)ReportMaintainUI.scrambReportPeriod(reportInfo.getPeriodType(), new Integer(reportInfo.getYear()), new Integer(reportInfo.getPeriod()), reportInfo.getStartDate()));
        row.getCell("auditedStatus").setValue((Object)reportInfo.getAuditedStatus());
        ++this.currentsubReportNumber;
    }

    @Override
    protected void initSelfUI() throws Exception {
        ReportInfo info;
        super.initSelfUI();
        this.tblSubReports.checkParsed();
        this.tblSubReports.getColumn(0).getStyleAttributes().setHided(true);
        this.tblSubReports.getSelectManager().setSelectMode(2);
        this.cbxStartYear.setModel((ComboBoxModel)new RptComboBoxModel(this.yearMap.keySet().toArray(), false));
        this.cbxStartYear.setSelectedItem((Object)this.currentYear);
        this.cbxStartPeriod.setModel((ComboBoxModel)new RptComboBoxModel((List)this.yearMap.get(this.currentYear)));
        this.cbxStartPeriod.setSelectedItem((Object)this.currentPeriod);
        Object isSupportOtherDS = this.msgMng.getItemValue("isSupportOtherDS");
        DataCollectCollection datacollect = new DataCollectCollection();
        datacollect.add(DataCollectConstant.getActualDC());
        datacollect.add(DataCollectConstant.getBudgetDC());
        this.dataCollectMap.clear();
        for (int i = 0; i < datacollect.size(); ++i) {
            DataCollectInfo dataCollect = datacollect.get(i);
            this.cbxDataCollect.addItem((Object)dataCollect);
            this.dataCollectMap.put(dataCollect.getNumber(), dataCollect);
        }
        this.cbxDataCollect.setSelectedItem(this.dataCollectMap.get("ACTUALDATA"));
        this.cbxDataCollect.setEnabled(false);
        if ("true".equals(isSupportOtherDS)) {
            this.labdataCollect.setVisible(true);
        } else {
            this.labdataCollect.setVisible(false);
        }
        this.hasBudgetedPermission = this.msgMng.getItemBooleanValue("hasBudgetedPermission");
        this.hasACPermission = this.msgMng.getItemBooleanValue("hasACPermission");
        if (this.isViewFromProcessUI() && this.getUIContext().get("InitDataObject") != null && (info = (ReportInfo)this.getUIContext().get("InitDataObject")).getPeriodType() != null) {
            DataCollectInfo dataCollect;
            this.cbxPeriodType.setSelectedItem((Object)info.getPeriodType());
            this.currentPeriod = new Integer(info.getPeriod());
            this.currentYear = new Integer(info.getYear());
            String dataCollectNumber = info.getDataCollectNumber();
            if (!StringUtils.isEmpty((String)dataCollectNumber) && (dataCollect = (DataCollectInfo)this.dataCollectMap.get(dataCollectNumber)) != null) {
                this.cbxDataCollect.setSelectedItem((Object)dataCollect);
            }
            this.setDataObject((IObjectValue)info);
            this.comboYearChange();
            this.cbxStartPeriod.setSelectedItem((Object)this.currentPeriod);
            this.cbxStartYear.setSelectedItem((Object)this.currentYear);
        }
    }

    @Override
    public void actionTemplateType_actionPerformed(ActionEvent e) throws Exception {
        super.actionTemplateType_actionPerformed(e);
        int templateType = this.btngTemplate.getValue();
        if (templateType == 0 || templateType == 1) {
            this.cbxDataCollect.setSelectedItem(this.dataCollectMap.get("ACTUALDATA"));
            this.cbxDataCollect.setEnabled(false);
        } else if (templateType == 2) {
            this.controlDataCollect();
        }
        this.refresh13Period();
    }

    @Override
    public void prmtTemplateChange() {
        super.prmtTemplateChange();
        try {
            TemplateInfo templateInfo;
            int templateType = this.btngTemplate.getValue();
            if (templateType == 2 && this.hasBudgetedPermission && (templateInfo = (TemplateInfo)this.prmtTemplate.getData()) != null) {
                BOSUuid id = templateInfo.getId();
                TemplateInfo template = (TemplateInfo)TemplateFactory.getRemoteInstance().getValue((IObjectPK)new ObjectUuidPK(id));
                boolean isIncludeOtherDC = template.isIncludeOtherDC();
                RptTmpTypeEnum tmpType = template.getTemplateType();
                if (!isIncludeOtherDC) {
                    if (!this.hasACPermission) {
                        this.prmtTemplate.setData(null);
                        MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResource.onlyHaveBgPermis"));
                        SysUtil.abort();
                    } else {
                        this.cbxDataCollect.setSelectedItem(this.dataCollectMap.get("ACTUALDATA"));
                        this.cbxDataCollect.setEnabled(false);
                    }
                } else if (!this.hasACPermission) {
                    this.cbxDataCollect.setEnabled(false);
                } else if (this.isMultiTemplate(tmpType)) {
                    this.cbxDataCollect.setSelectedItem(this.dataCollectMap.get("ACTUALDATA"));
                    this.cbxDataCollect.setEnabled(false);
                } else {
                    this.cbxDataCollect.setEnabled(true);
                }
            }
        }
        catch (Exception e) {
            super.handUIException((Throwable)e);
        }
    }

    protected void controlDataCollect() {
        if (this.hasBudgetedPermission && !this.hasACPermission) {
            this.cbxDataCollect.setSelectedItem(this.dataCollectMap.get("BUDGETDATA"));
            this.cbxDataCollect.setEnabled(false);
            this.rbnNoTemplate.setEnabled(false);
            this.rbnCommonTemplate.setEnabled(false);
            this.rbnGroupTemplate.setSelected(true);
            this.btngTemplate.setValue(2);
            this.templateTypeChange();
        } else if (!this.hasBudgetedPermission && this.hasACPermission) {
            this.cbxDataCollect.setSelectedItem(this.dataCollectMap.get("ACTUALDATA"));
            this.cbxDataCollect.setEnabled(false);
        } else {
            int templateType = this.btngTemplate.getValue();
            if (templateType == 0 || templateType == 1) {
                this.cbxDataCollect.setSelectedItem(this.dataCollectMap.get("ACTUALDATA"));
                this.cbxDataCollect.setEnabled(false);
            } else {
                this.cbxDataCollect.setEnabled(true);
            }
            this.rbnNoTemplate.setEnabled(true);
            this.rbnCommonTemplate.setEnabled(true);
        }
    }

    private boolean isMultiTemplate(RptTmpTypeEnum tmpType) {
        return tmpType.equals((Object)RptTmpTypeEnum.MULTIDYNAMICCSLPORT) || tmpType.equals((Object)RptTmpTypeEnum.MULTIDYNAMICCSLREPORT) || tmpType.equals((Object)RptTmpTypeEnum.MULTIDYNAMICMNSPORT) || tmpType.equals((Object)RptTmpTypeEnum.MULTIDYNAMICSUMREPORT) || tmpType.equals((Object)RptTmpTypeEnum.MULTIRPTDYNAMICREPORT);
    }

    private void refresh13Period() {
        if (this.isMergeByFiscalPeriod) {
            return;
        }
        RptPeriodTypeEnum periodType = (RptPeriodTypeEnum)this.cbxPeriodType.getSelectedItem();
        if (RptPeriodTypeEnum.MONTHLY.equals((Object)periodType)) {
            DataCollectInfo dataCollect = (DataCollectInfo)this.cbxDataCollect.getSelectedItem();
            Integer startYear = (Integer)this.cbxStartYear.getSelectedItem();
            Integer startPeriod = (Integer)this.cbxStartPeriod.getSelectedItem();
            ArrayList yearPeriods = (ArrayList)this.yearMap.get(startYear);
            if (yearPeriods == null) {
                yearPeriods = new ArrayList(0);
            }
            boolean contain13Period = yearPeriods != null && yearPeriods.size() > 12;
            int yearPeriodNum = yearPeriods.size();
            boolean isSelectedLast = false;
            while (yearPeriodNum < this.cbxStartPeriod.getItemCount()) {
                this.cbxStartPeriod.removeItemAt(yearPeriodNum);
                isSelectedLast = true;
            }
            if (dataCollect != null && dataCollect.getNumber().equals("ACTUALDATA") && this.msgMng.getItemBooleanValue("isSupport13Period")) {
                if (this.indexOfPeriod(String.valueOf(13)) < 0) {
                    int period12StartIndex = yearPeriods.indexOf(new Integer(12));
                    ++period12StartIndex;
                    while (contain13Period && yearPeriods.size() > period12StartIndex) {
                        this.cbxStartPeriod.addItem(yearPeriods.get(period12StartIndex));
                        ++period12StartIndex;
                    }
                    if (isSelectedLast && startPeriod != null && this.indexOfPeriod(startPeriod.toString()) == -1) {
                        this.cbxStartPeriod.setSelectedIndex(this.cbxStartPeriod.getItemCount() - 1);
                    }
                }
            } else {
                int postion = this.indexOfPeriod(String.valueOf(13));
                if (postion >= 0) {
                    while (this.cbxStartPeriod.getItemCount() > 12) {
                        this.cbxStartPeriod.removeItemAt(12);
                    }
                    if (isSelectedLast && startPeriod != null && this.indexOfPeriod(startPeriod.toString()) == -1) {
                        this.cbxStartPeriod.setSelectedIndex(this.cbxStartPeriod.getItemCount() - 1);
                    }
                }
            }
        }
    }
}

