/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.client;

import com.kingdee.bos.ctrl.common.util.SectionByteOutputStream;
import com.kingdee.bos.ctrl.kdf.export.ExportManager;
import com.kingdee.bos.ctrl.kdf.export.ExporterParameter;
import com.kingdee.bos.ctrl.kdf.kds.KDSBook;
import com.kingdee.bos.ctrl.kdf.kds.KDSSheet;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.file.IDObject;
import com.kingdee.bos.ctrl.kdf.util.file.KDF;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ctrl.swing.KDRadioButton;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.rpt.PostilCollection;
import com.kingdee.eas.fi.rpt.ReportCalculateErrorProvider;
import com.kingdee.eas.fi.rpt.RptOperationSchemaComp;
import com.kingdee.eas.fi.rpt.RptResourceHelper;
import com.kingdee.eas.fi.rpt.client.AbstractReportExportUI;
import com.kingdee.eas.fi.rpt.client.KRptFileFilter;
import com.kingdee.eas.fi.rpt.client.RptSheet;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.eas.ma.bg.client.ExcelFileFilter;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;
import sun.awt.shell.ShellFolder;

public class ReportExportUI
extends AbstractReportExportUI {
    private static final Logger logger = CoreUIObject.getLogger(ReportExportUI.class);
    private String currentDirectoryPath;
    private List sheets;
    private List reportKeys;
    private PostilCollection rptComments;
    private RptOperationSchemaComp schemaComp;
    private String zeroReplacer;
    private ReportCalculateErrorProvider errorProvider = null;
    boolean result = false;
    private String reportName;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.btnBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReportExportUI.this.chooseFile();
            }
        });
        this.btnOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReportExportUI.this.doOK();
            }
        });
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReportExportUI.this.doCancel();
            }
        });
        this.rdbExcel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReportExportUI.this.exportType(e);
            }
        });
        this.rdbKDF.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReportExportUI.this.exportType(e);
            }
        });
        this.rdbExcel.setSelected(true);
        this.rdbDataAndFormula.setSelected(true);
        this.cbxStyle.setSelected(true);
        this.cbxStyle.setVisible(false);
    }

    private void exportType(ActionEvent e) {
        if ("rdbExcel".equals(((KDRadioButton)e.getSource()).getName())) {
            this.rdbDataAndExcelFormula.setEnabled(true);
            this.rdbDataAndFormula.setEnabled(true);
            this.rdbOnlyData.setEnabled(true);
            this.cbxStyle.setEnabled(true);
        } else {
            this.rdbDataAndExcelFormula.setEnabled(false);
            this.rdbDataAndFormula.setEnabled(false);
            this.rdbOnlyData.setEnabled(false);
            this.cbxStyle.setEnabled(false);
        }
    }

    private void doOK() {
        String destFile = this.txtFile.getText();
        if (StringUtils.isEmpty((String)destFile)) {
            MsgBox.showWarning((String)("\" \"" + RptUtil.getReportResource("invalidFileName")));
            return;
        }
        File dest = new File(destFile);
        if (dest.getName().matches(".*[\\>|\\<|\\||\\:|\\?|\\*|\\/|\\\\|\"].*")) {
            MsgBox.showWarning((String)(dest.getName() + "\n" + RptUtil.getReportResource("invalidFileName")));
        }
        boolean export = true;
        if (dest.isFile() && MsgBox.showConfirm2((Component)((Object)this), (String)RptResourceHelper.getString("file-overwrite-confirm")) != 0) {
            export = false;
        }
        if (export) {
            String path = dest.getAbsolutePath();
            if (this.rdbExcel.isSelected()) {
                if (path.length() <= 4 || !".xls".equalsIgnoreCase(path.substring(path.length() - 4))) {
                    path = path + ".xls";
                }
                this.result = this.exportToExcel(path);
            } else {
                if (path.length() <= 4 || !".KDF".equalsIgnoreCase(path.substring(path.length() - 4))) {
                    path = path + ".KDF";
                }
                this.result = this.exportToKDF(path);
            }
        }
        if (this.result) {
            this.destroyWindow();
        }
    }

    private boolean exportToExcel(String path) {
        ExportManager man = new ExportManager();
        if (this.rdbOnlyData.isSelected()) {
            man.setExporterParmeter(ExporterParameter.EXPORT_FORMULA, (Object)"false");
        } else if (this.rdbDataAndFormula.isSelected()) {
            man.setExporterParmeter(ExporterParameter.EXPORT_FORMULA_VALUE, (Object)"true");
            man.setExporterParmeter(ExporterParameter.EXPORT_FORMULA, (Object)"true");
        } else if (this.rdbDataAndExcelFormula.isSelected()) {
            man.setExporterParmeter(ExporterParameter.EXPORT_FORMULA, (Object)"true");
            man.setExporterParmeter(ExporterParameter.EXPORT_CUSTOM_FORMULA, (Object)"false");
        }
        if (this.cbxStyle.isSelected()) {
            man.setExporterParmeter(ExporterParameter.EXPORT_FORMAT, (Object)"true");
            man.setExporterParmeter(ExporterParameter.EXPORT_STYLE, (Object)"true");
        } else {
            man.setExporterParmeter(ExporterParameter.EXPORT_FORMAT, (Object)"false");
            man.setExporterParmeter(ExporterParameter.EXPORT_STYLE, (Object)"false");
        }
        man.setExporterParmeter(ExporterParameter.EXPORT_STRING_AS_STRING, (Object)"false");
        try {
            KDSBook bk = new KDSBook(path);
            int size = this.sheets.size();
            for (int i = 0; i < size; ++i) {
                RptSheet rptSheet = (RptSheet)this.sheets.get(i);
                KDTable tb = rptSheet.getTable();
                KDSSheet ks = tb.getIOManager().saveToKDSSheet(bk, false, false, tb.getName());
                if (ks == null) continue;
                bk.addSheet(null, ks);
            }
            man.exportToExcel(bk, path);
        }
        catch (Exception e) {
            logger.debug((Object)e.getMessage());
            if (e.getMessage().equals("EXPORT_FORUMULA_TOO_LENGTH")) {
                MsgBox.showInfo((String)RptUtil.getReportResource("EXPORT_FORUMULA_TOO_LENGTH"));
            } else {
                MsgBox.showInfo((String)RptResourceHelper.getString("reportprocessui-fileexport-error"));
            }
            return false;
        }
        return true;
    }

    private void chooseFile() {
        String sf = this.txtFile.getText();
        if (StringUtils.isEmpty((String)sf)) {
            sf = this.getDefaultFilePath();
        }
        KDFileChooser cuz = new KDFileChooser(sf);
        cuz.setSelectedFile(new File(sf));
        cuz.setDialogTitle(EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResource.ReportProcessUI_Export"));
        if (this.rdbExcel.isSelected()) {
            cuz.addChoosableFileFilter((FileFilter)new ExcelFileFilter());
        } else {
            cuz.addChoosableFileFilter((FileFilter)new KRptFileFilter());
        }
        boolean flag = true;
        while (flag) {
            if (cuz.showSaveDialog((Component)((Object)this)) == 0) {
                File file = cuz.getSelectedFile();
                String name = file.getName();
                if (name.matches(".*[\\>|\\<|\\||\\:|\\?|\\*|\\/|\\\\|\"].*")) {
                    MsgBox.showWarning((String)(name + "\n" + RptUtil.getReportResource("invalidFileName")));
                    continue;
                }
                if (file != null) {
                    String path = file.getAbsolutePath();
                    FileFilter ext = cuz.getFileFilter();
                    if (ext != null && !ext.accept(file)) {
                        path = ext instanceof KRptFileFilter ? path + ".kdf" : path + ".xls";
                        file = new File(path);
                    }
                    this.currentDirectoryPath = file.getParent();
                    File apath = new File(this.currentDirectoryPath);
                    if (!apath.exists()) {
                        MsgBox.showWarning((String)(path + "\n" + RptUtil.getReportResource("pathNotExists")));
                        continue;
                    }
                    flag = false;
                }
                this.txtFile.setText(this.currentDirectoryPath + File.separatorChar + file.getName());
                continue;
            }
            flag = false;
        }
    }

    public void onShow() throws Exception {
        this.txtFile.setText(this.getDefaultFilePath());
        super.onShow();
    }

    private void doCancel() {
        this.destroyWindow();
    }

    public static IUIWindow createDialog(CoreUIObject parentUI) throws Exception {
        IUIFactory fy = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        IUIWindow wnd = fy.create(ReportExportUI.class.getName(), (Map)new UIContext((Object)parentUI));
        return wnd;
    }

    public void setCurrentDirectoryPath(String path) {
        this.currentDirectoryPath = path;
    }

    public void setSheets(List sheets) {
        this.sheets = sheets;
    }

    private boolean exportToKDF(String fileName) {
        if (fileName == null) {
            return false;
        }
        try {
            KDF kdf = new KDF();
            ArrayList<PostilCollection> sheetComments = new ArrayList<PostilCollection>();
            ArrayList<PostilCollection> cellComments = new ArrayList<PostilCollection>();
            for (int i = 0; i < this.sheets.size(); ++i) {
                RptSheet rptSheet = (RptSheet)this.sheets.get(i);
                KDTable tbl = rptSheet.getTable();
                kdf.addTable((IDObject)tbl);
                RptUtil.savePrintSetting(tbl, kdf);
                PostilCollection rptPostil = new PostilCollection();
                rptSheet.getComments(rptPostil);
                sheetComments.add(rptPostil);
                PostilCollection cellPostil = new PostilCollection();
                rptSheet.getCellsComment(cellPostil);
                cellComments.add(cellPostil);
            }
            kdf.addUserObject("reportKeys", (Object)this.reportKeys);
            kdf.addUserObject("sheetComments", sheetComments);
            kdf.addUserObject("cellComments", cellComments);
            if (this.rptComments != null) {
                kdf.addUserObject("rptComments", (Object)this.rptComments);
            }
            if (this.schemaComp != null) {
                kdf.addUserObject("operationSchemas", (Object)this.schemaComp);
            }
            if (this.zeroReplacer != null) {
                kdf.addUserObject("ZEROREPLACER", (Object)this.zeroReplacer);
            }
            if (this.errorProvider != null) {
                kdf.addUserObject("RPT_ERRORHANDLER", (Object)this.errorProvider);
            }
            SectionByteOutputStream os = new SectionByteOutputStream();
            kdf.save((OutputStream)os);
            FileOutputStream of = new FileOutputStream(fileName);
            os.writeTo((OutputStream)of);
            os.close();
            of.close();
            return true;
        }
        catch (Exception e) {
            MsgBox.showInfo((String)RptResourceHelper.getString("reportprocessui-fileexport-error"));
            logger.debug((Object)e.getMessage());
            return false;
        }
    }

    public void setReportKeys(List reportKeys) {
        this.reportKeys = reportKeys;
    }

    public ReportCalculateErrorProvider getErrorProvider() {
        return this.errorProvider;
    }

    public void setErrorProvider(ReportCalculateErrorProvider errorProvider) {
        this.errorProvider = errorProvider;
    }

    public PostilCollection getRptComments() {
        return this.rptComments;
    }

    public void setRptComments(PostilCollection rptComments) {
        this.rptComments = rptComments;
    }

    public RptOperationSchemaComp getSchemaComp() {
        return this.schemaComp;
    }

    public void setSchemaComp(RptOperationSchemaComp schemaComp) {
        this.schemaComp = schemaComp;
    }

    public String getZeroReplacer() {
        return this.zeroReplacer;
    }

    public void setZeroReplacer(String zeroReplacer) {
        this.zeroReplacer = zeroReplacer;
    }

    public List getReportKeys() {
        return this.reportKeys;
    }

    public boolean getExportResult() {
        return this.result;
    }

    public void setReportName(String reportName) {
        this.reportName = StringUtils.isEmpty((String)reportName) ? "Untitled Report" : reportName;
    }

    public String getDefaultFilePath() {
        String path = null;
        if (this.currentDirectoryPath == null) {
            File f = (File)ShellFolder.get("fileChooserDefaultFolder");
            this.currentDirectoryPath = path = f.getAbsolutePath();
        } else {
            path = this.currentDirectoryPath;
        }
        path = path + File.separatorChar + this.reportName;
        path = this.rdbExcel.isSelected() ? path + ".xls" : path + ".KDF";
        return path;
    }
}

