/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTActiveCellEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTActiveCellListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.style.LineStyle;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDScrollBar;
import com.kingdee.bos.kscript.runtime.Pair;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.uiframe.client.HelpBasicData;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.rpt.BalanceHint;
import com.kingdee.eas.fi.rpt.CellReference;
import com.kingdee.eas.fi.rpt.ConvertHint;
import com.kingdee.eas.fi.rpt.RptBalanceFullHint;
import com.kingdee.eas.fi.rpt.RptResourceHelper;
import com.kingdee.eas.fi.rpt.TableToolkit;
import com.kingdee.eas.fi.rpt.client.AbstractRptBalanceWizardUI;
import com.kingdee.eas.fi.rpt.client.ISimpleDialog;
import com.kingdee.eas.fi.rpt.client.ISimpleDialogListener;
import com.kingdee.eas.fi.rpt.client.RptHelper;
import com.kingdee.eas.fi.rpt.client.RptSheetChooseDialog;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.eas.fi.rpt.util.RptUtilForClient;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.help.CSH;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JScrollBar;

public class RptBalanceWizardUI
extends AbstractRptBalanceWizardUI
implements ISimpleDialog {
    private ArrayList listeners;
    private List sheetNames;
    private static final String[] entrys = new String[]{"rptconvertwizardui-tblhint-head-sheetname", "rptconvertwizardui-tblhint-head-region", "rptconvertwizardui-tblhint-head-operation", "rptconvertwizardui-tblhint-head-factor", "rptconvertwizardui-tblhint-head-decimal"};
    private String[] operations = new String[]{"rptconvertwizardui-tblhint-operation-division", "rptconvertwizardui-tblhint-operation-multiply"};
    private static final String DEFAULTRATE = "1.0";
    private static final String DEFAULTRANGE = "ALL";

    public static RptBalanceWizardUI getInstance(CoreUIObject parentUI) throws Exception {
        IUIFactory fy = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        UIContext uiContext = new UIContext((Object)parentUI);
        if (parentUI.getUIContext() != null && parentUI.getUIContext().containsKey("isNeedNewReport")) {
            uiContext.put((Object)"isNeedNewReport", parentUI.getUIContext().get("isNeedNewReport"));
        }
        IUIWindow wnd = fy.create(RptBalanceWizardUI.class.getName(), (Map)uiContext);
        RptBalanceWizardUI res = (RptBalanceWizardUI)wnd.getUIObject();
        res.onShow();
        return res;
    }

    public RptBalanceWizardUI() throws Exception {
        this.listeners = new ArrayList(1);
        this.initialize();
    }

    private void initialize() {
        for (int i = 0; i < this.operations.length; ++i) {
            this.operations[i] = EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResource", (String)this.operations[i]);
        }
        Object[] decimals = new Integer[7];
        for (int i = 0; i < decimals.length; ++i) {
            decimals[i] = new Integer(i);
        }
        IRow hr = this.tblBalanceHints.addHeadRow();
        for (int i = 0; i < entrys.length; ++i) {
            IColumn col = this.tblBalanceHints.addColumn(i);
            if (i == 2) {
                col.setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)new KDComboBox((Object[])this.operations)));
                col.setWidth(40);
            } else if (i == 4) {
                col.setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)new KDComboBox(decimals)));
            }
            hr.getCell(i).setValue((Object)EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResource", (String)entrys[i]));
        }
        TableActionListener tal = new TableActionListener();
        this.tblBalanceHints.addKDTEditListener((KDTEditListener)tal);
        this.tblBalanceHints.addKDTMouseListener((KDTMouseListener)tal);
        this.tblBalanceHints.getSelectManager().setSelectMode(2);
        this.tblBalanceHints.addKDTActiveCellListener(new KDTActiveCellListener(){

            public void activeCellChanged(KDTActiveCellEvent e) {
                KDTable tbl;
                KDTable kDTable = tbl = e == null ? null : (KDTable)e.getSource();
                if (tbl == null) {
                    return;
                }
                RptBalanceWizardUI.this.setCellColor(tbl.getCell(e.getPrevRowIndex(), e.getPrevColumnIndex()), Color.BLACK, LineStyle.NULL_LINE);
                RptBalanceWizardUI.this.setCellColor(tbl.getCell(e.getRowIndex(), e.getColumnIndex()), Color.BLACK, LineStyle.SINGLE_LINE);
            }
        });
        this.tblBalanceHints.getActionMap().put("CancelEdit", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (RptBalanceWizardUI.this.tblBalanceHints.getEditManager().isEditing()) {
                    RptBalanceWizardUI.this.tblBalanceHints.getEditManager().cancelEditing();
                } else {
                    RptBalanceWizardUI.this.endWizard(false);
                }
            }
        });
        this.lstBalance.setModel(new DefaultListModel());
        this.lstBalance.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    RptBalanceWizardUI.this.menuBalance.show(e.getComponent(), e.getX(), e.getY());
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    RptBalanceWizardUI.this.editBalanceExpression();
                }
            }
        });
    }

    void setCellColor(ICell cell, Color cl, LineStyle lineStyle) {
        if (cell == null) {
            return;
        }
        StyleAttributes sa = cell.getStyleAttributes();
        Styles.Position[] bds = new Styles.Position[]{Styles.Position.LEFT, Styles.Position.TOP, Styles.Position.RIGHT, Styles.Position.BOTTOM};
        for (int i = bds.length - 1; i >= 0; --i) {
            sa.setBorderColor(bds[i], cl);
            sa.setBorderLineStyle(bds[i], lineStyle);
        }
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
        this.btnAddHint.setIcon(RptResourceHelper.getIcon("imgTbtn_new"));
        this.btnDeletHint.setIcon(RptResourceHelper.getIcon("imgTbtn_delete"));
        this.conBalanceHint.addButton((JButton)this.btnAddHint);
        this.conBalanceHint.addButton((JButton)this.btnDeletHint);
        this.btnAddExpression.setIcon(RptResourceHelper.getIcon("imgTbtn_new"));
        this.btnDeletExpression.setIcon(RptResourceHelper.getIcon("imgTbtn_delete"));
        this.conBalance.addButton((JButton)this.btnAddExpression);
        this.conBalance.addButton((JButton)this.btnDeletExpression);
        this.lstBalance.removeAllElements();
    }

    public void onShow() throws Exception {
        super.onShow();
        RptHelper.setDefaultButton(this, (JButton)this.btnOk);
        RptHelper.setEscAction(this, (Action)((Object)this.actionBtnCancel));
        RptHelper.registF1Action(this, (Action)((Object)this.actionHelp));
    }

    void editBalanceExpression() {
        if (this.lstBalance.isSelectionEmpty()) {
            return;
        }
        int s = this.lstBalance.getSelectedIndex();
        DefaultListModel md = (DefaultListModel)this.lstBalance.getModel();
        Object o = md.get(s);
        Pair res = RptUtilForClient.inquireInfo(this.resHelper.getString("conBalance.title"), o.toString().trim(), this);
        String out = (String)res.second;
        if (res == null || !RptUtil.isTrue(res.first)) {
            if (o == null || o.toString().trim().length() == 0) {
                md.remove(s);
            }
            return;
        }
        if (out != null) {
            if ((out = out.trim()).length() == 0) {
                md.remove(s);
            } else {
                md.setElementAt(out, s);
            }
        }
    }

    @Override
    public void actionBtnOk_actionPerformed(ActionEvent e) throws Exception {
        super.actionBtnOk_actionPerformed(e);
        this.endWizard(true);
    }

    @Override
    public void actionBtnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionBtnCancel_actionPerformed(e);
        this.endWizard(false);
    }

    public void open(Object cookie, String title, List sheets) {
        this.fireListenersSetout();
        this.loadHints((RptBalanceFullHint)cookie);
        this.sheetNames = sheets;
        IColumn col = this.tblBalanceHints.getColumn(0);
        KDBizPromptBox sheetChooser = new KDBizPromptBox();
        sheetChooser.setSelector((KDPromptSelector)new RptSheetChooseDialog((IUIObject)this, sheets));
        sheetChooser.setEditable(true);
        col.setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)sheetChooser));
        this.tblBalanceHints.addKDTEditListener((KDTEditListener)new EditingListener());
        IUIWindow w = this.getUIWindow();
        if (w instanceof KDDialog) {
            KDDialog d = (KDDialog)w;
            if (title != null) {
                d.setTitle(title);
            }
            d.addWindowListener((WindowListener)new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    RptBalanceWizardUI.this.endWizard(false);
                }
            });
        }
        w.show();
    }

    private void loadHints(RptBalanceFullHint hint) {
        if (this.getUIContext().containsKey("isNeedNewReport")) {
            boolean isRemoveNewReport = (Boolean)this.getUIContext().get("isNeedNewReport");
            if (!isRemoveNewReport) {
                this.cbxOutput.removeItemAt(2);
            }
        } else {
            this.cbxOutput.removeItemAt(2);
        }
        if (hint == null) {
            return;
        }
        this.loadBalanceHints(hint.cvHint);
        this.loadBalanceRegionHints(hint.baHint);
        this.cbxOutput.setSelectedIndex(hint.cvMode);
    }

    private void loadBalanceRegionHints(Collection expHints) {
        if (expHints == null) {
            return;
        }
        DefaultListModel md = (DefaultListModel)this.lstBalance.getModel();
        for (BalanceHint h : expHints) {
            String exp = h.getExpression();
            if (exp == null) continue;
            md.addElement(exp);
        }
    }

    private void loadBalanceHints(Collection covHints) {
        if (covHints == null) {
            return;
        }
        int i = 0;
        for (ConvertHint h : covHints) {
            IRow row;
            if ((row = this.tblBalanceHints.getRow(i++)) == null) {
                row = this.tblBalanceHints.addRow();
            }
            if (row == null) continue;
            if (h.sheetName == null || h.sheetName.size() < 1) {
                row.getCell(0).setValue((Object)"");
            } else {
                row.getCell(0).setValue((Object)h.sheetName);
            }
            row.getCell(1).setValue((Object)(h.isAllTable ? DEFAULTRANGE : TableToolkit.xy2range(h.region)));
            row.getCell(2).setValue((Object)this.operations[h.operation]);
            row.getCell(3).setValue((Object)String.valueOf(h.rate));
            row.getCell(4).setValue((Object)String.valueOf(h.decimal));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void endWizard(boolean isOk) {
        RptBalanceFullHint res = null;
        if (isOk) {
            Collection conv = this.getBalanceRegionHints();
            if (conv == null) {
                if (this.tblBalanceHints.getRowCount() != 0) return;
                isOk = false;
            } else {
                Collection baln = this.getBalanceHints();
                if (baln == null) {
                    if (this.lstBalance.getModel().getSize() > 0) {
                        return;
                    }
                } else {
                    res = new RptBalanceFullHint();
                    res.cvHint = conv;
                    res.baHint = baln;
                    res.cvMode = this.cbxOutput.getSelectedIndex();
                }
            }
        }
        this.disposeUIWindow();
        this.fireListenersReturnee(res, isOk);
    }

    @Override
    public synchronized void addSimpleDialogListener(ISimpleDialogListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    private void fireListenersSetout() {
        for (ISimpleDialogListener l : this.listeners) {
            if (l == null) continue;
            l.pilotSetout(this);
        }
    }

    private void fireListenersReturnee(RptBalanceFullHint result, boolean isOk) {
        for (ISimpleDialogListener l : this.listeners) {
            if (l == null) continue;
            l.pilotReturnee(this, result, isOk);
        }
    }

    private List sheetNames2List(String sheets) {
        if (sheets == null || sheets.trim().length() < 1) {
            return null;
        }
        if (sheets.charAt(0) == '[' && sheets.charAt(sheets.length() - 1) == ']') {
            sheets = sheets.substring(1, sheets.length() - 1);
        }
        List<String> editingList = Arrays.asList(sheets.split(","));
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < editingList.size(); ++i) {
            String obj = editingList.get(i);
            if (!this.sheetNames.contains(obj) || result.contains(obj)) continue;
            result.add(obj);
        }
        return result;
    }

    boolean testCellReference(CellReference cellRefer) {
        boolean noRegion;
        if (cellRefer == null) {
            return false;
        }
        boolean bl = noRegion = cellRefer.region == null || cellRefer.region.x1 == -1 && cellRefer.region.x2 == -1 && cellRefer.region.y1 == -1 && cellRefer.region.y2 == -1;
        if (noRegion) {
            return false;
        }
        if (cellRefer.sheetName == null) {
            return true;
        }
        return this.sheetNames.contains(cellRefer.sheetName);
    }

    @Override
    public void actionAddExpression_actionPerformed(ActionEvent e) throws Exception {
        Object val;
        super.actionAddExpression_actionPerformed(e);
        DefaultListModel md = (DefaultListModel)this.lstBalance.getModel();
        int rct = md.getSize() - 1;
        if (rct >= 0 && ((val = md.get(rct)) == null || val.toString().trim().length() == 0)) {
            this.lstBalance.setSelectedIndex(rct);
            rct = -2;
        }
        if (rct != -2) {
            md.addElement(" ");
            this.lstBalance.setSelectedIndex(rct + 1);
        }
        this.editBalanceExpression();
    }

    @Override
    public void actionDeletExpression_actionPerformed(ActionEvent e) throws Exception {
        super.actionDeletExpression_actionPerformed(e);
        if (!this.lstBalance.isSelectionEmpty()) {
            ((DefaultListModel)this.lstBalance.getModel()).remove(this.lstBalance.getSelectedIndex());
        }
        this.lstBalance.setSelectedIndex(this.lstBalance.getFirstVisibleIndex());
    }

    @Override
    public void actionAddHint_actionPerformed(ActionEvent e) throws Exception {
        this.addNewHintEntry(-1);
    }

    void addNewHintEntry(int currentRow) {
        int rct = this.tblBalanceHints.getRowCount();
        if (currentRow >= 0) {
            Object val;
            if (rct > 0 && currentRow != rct - 1) {
                return;
            }
            if (rct > 1 && ((val = this.tblBalanceHints.getRow(currentRow - 1).getCell(1).getValue()) == null || val.toString().trim().length() == 0)) {
                this.tblBalanceHints.getSelectManager().select(currentRow, 0);
                return;
            }
        }
        IRow r = this.tblBalanceHints.addRow();
        r.getCell(1).setValue((Object)DEFAULTRANGE);
        r.getCell(3).setValue((Object)DEFAULTRATE);
        KDComboBox b = (KDComboBox)this.tblBalanceHints.getColumn(2).getEditor().getComponent();
        r.getCell(2).setValue((Object)b.getItemAt(0).toString());
        b = (KDComboBox)this.tblBalanceHints.getColumn(4).getEditor().getComponent();
        r.getCell(4).setValue((Object)b.getItemAt(0).toString());
        this.tblBalanceHints.getSelectManager().select(r.getRowIndex(), 0);
    }

    @Override
    public void actionDeletHint_actionPerformed(ActionEvent e) throws Exception {
        super.actionDeletHint_actionPerformed(e);
        this.deletHintEntry(this.tblBalanceHints.getSelectManager().getActiveRowIndex());
    }

    private void deletHintEntry(int index) {
        this.tblBalanceHints.removeRow(index);
    }

    public Collection getBalanceRegionHints() {
        ArrayList<ConvertHint> res = new ArrayList<ConvertHint>(2);
        ConvertHint ht = null;
        IRow row = null;
        int size = this.tblBalanceHints.getRowCount();
        for (int i = 0; i < size; ++i) {
            row = this.tblBalanceHints.getRow(i);
            Object val = row.getCell(1).getValue();
            CellReference cr = TableToolkit.parsePosition(val == null ? null : val.toString());
            if (cr == null) continue;
            ht = new ConvertHint();
            ht.sheetName.clear();
            if (cr.sheetName != null) {
                ht.sheetName.add(cr.sheetName);
            } else {
                Object obj = row.getCell(0).getValue();
                if (obj != null) {
                    if (obj instanceof String) {
                        ht.sheetName.add(obj);
                    } else if (obj instanceof List) {
                        ht.sheetName.addAll((List)obj);
                    }
                }
            }
            ht.region = cr.region;
            ht.isAllTable = TableToolkit.isAllTable(cr.region);
            val = row.getCell(3).getValue();
            if (val != null) {
                ht.rate = Double.parseDouble(val.toString());
            }
            if ((val = row.getCell(2).getValue()) != null) {
                int n = ht.operation = this.operations[0].equals(val.toString()) ? 0 : 1;
            }
            if ((val = row.getCell(4).getValue()) != null) {
                ht.decimal = Integer.parseInt(val.toString());
            }
            res.add(ht);
        }
        return res;
    }

    public Collection getBalanceHints() {
        ArrayList<BalanceHint> res = new ArrayList<BalanceHint>(2);
        BalanceHint ht = null;
        DefaultListModel md = (DefaultListModel)this.lstBalance.getModel();
        int size = md.size();
        for (int i = 0; i < size; ++i) {
            Object val = md.elementAt(i);
            if (val == null || !(ht = new BalanceHint()).setCondition(val.toString().trim())) continue;
            res.add(ht);
        }
        return res;
    }

    @Override
    public void open(Object cookie, String title) {
        this.open(cookie, title, null);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.tblBalanceHints.getLayoutManager().setHorizonScrollBar((JScrollBar)new KDScrollBar(0));
        this.tblBalanceHints.getLayoutManager().setVerticalScrollBar((JScrollBar)new KDScrollBar(1));
    }

    @Override
    public void actionHelp_actionPerformed(ActionEvent e) throws Exception {
        super.actionHelp_actionPerformed(e);
        CSH.setHelpIDString((Component)((Component)e.getSource()), (String)"fatempClassAttribute");
        CSH.DisplayHelpFromSource help = new CSH.DisplayHelpFromSource(HelpBasicData.getInstance().getHelpBroker());
        help.actionPerformed(e);
    }

    private class TableActionListener
    extends KDTEditAdapter
    implements KDTMouseListener {
        private TableActionListener() {
        }

        public void editStarting(KDTEditEvent e) {
        }

        public void tableClicked(KDTMouseEvent e) {
            if (e.getButton() != 1) {
                RptBalanceWizardUI.this.menuHint.show(e.getComponent(), e.getX() + 22, e.getY() + 22);
            }
        }

        public void editStopping(KDTEditEvent e) {
            String resource = "com.kingdee.eas.fi.rpt.ReportResource";
            if (e.getColIndex() == 1) {
                String value = (String)RptBalanceWizardUI.this.tblBalanceHints.getEditManager().getEditor().getValue();
                CellReference cr = TableToolkit.parsePosition(value);
                if (!RptBalanceWizardUI.this.testCellReference(cr)) {
                    MsgBox.showInfo((Component)((Object)RptBalanceWizardUI.this), (String)EASResource.getString((String)resource, (String)"rptconvertwizardui-tblhint-error-region"));
                    e.setCancel(true);
                    RptBalanceWizardUI.this.tblBalanceHints.getEditManager().getEditor().setValue((Object)"All");
                }
            } else if (e.getColIndex() == 3) {
                try {
                    String value = (String)RptBalanceWizardUI.this.tblBalanceHints.getEditManager().getEditor().getValue();
                    double val = Double.parseDouble(value);
                    if (val <= 0.0) {
                        throw new Exception();
                    }
                }
                catch (Exception ex) {
                    MsgBox.showInfo((Component)((Object)RptBalanceWizardUI.this), (String)EASResource.getString((String)resource, (String)"rptconvertwizardui-tblhint-error-factor"));
                    e.setCancel(true);
                    RptBalanceWizardUI.this.tblBalanceHints.getEditManager().getEditor().setValue((Object)RptBalanceWizardUI.DEFAULTRATE);
                }
            }
        }
    }

    private final class EditingListener
    extends KDTEditAdapter {
        private EditingListener() {
        }

        public void editStarting(KDTEditEvent e) {
            KDPromptSelector obj2;
            KDTable tbl;
            Component obj;
            super.editStarting(e);
            if (e.getColIndex() == 0 && (obj = (tbl = (KDTable)e.getSource()).getEditManager().getEditorComponent()) != null && obj instanceof KDBizPromptBox && (obj2 = ((KDBizPromptBox)obj).getSelector()) != null && obj2 instanceof RptSheetChooseDialog) {
                Object obj3 = e.getValue();
                if (obj3 != null && obj3 instanceof List) {
                    ((RptSheetChooseDialog)obj2).setSelectedSheet((List)obj3);
                } else {
                    ((RptSheetChooseDialog)obj2).setSelectedSheet(null);
                }
            }
        }

        public void editStopped(KDTEditEvent e) {
            Object sheetName;
            KDTable tbl;
            ICell cell;
            super.editStopped(e);
            if (e.getColIndex() == 0 && (cell = (tbl = (KDTable)e.getSource()).getCell(e.getRowIndex(), e.getColIndex())) != null && (sheetName = e.getValue()) != null && sheetName instanceof String) {
                cell.setValue((Object)RptBalanceWizardUI.this.sheetNames2List((String)sheetName));
            }
        }
    }
}

