/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.client;

import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDList;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.rpt.RptMultiCalculateEntry;
import com.kingdee.eas.fi.rpt.RptResourceHelper;
import com.kingdee.eas.fi.rpt.client.AbstractRptCalculateSelectorUI;
import com.kingdee.eas.fi.rpt.client.RptHelper;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JButton;

public class RptCalculateSelectorUI
extends AbstractRptCalculateSelectorUI {
    private boolean isOk;
    private boolean isDoCalculate;

    public static RptCalculateSelectorUI getInstance(CoreUIObject parentUI) throws Exception {
        IUIFactory fy = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        IUIWindow wnd = fy.create(RptCalculateSelectorUI.class.getName(), (Map)new UIContext((Object)parentUI));
        RptCalculateSelectorUI res = (RptCalculateSelectorUI)wnd.getUIObject();
        res.onShow();
        return res;
    }

    public void open(Object queue, Object sheets) {
        this.isOk = false;
        this.isDoCalculate = false;
        this.loadQueueList((ArrayList)queue, (ArrayList)sheets);
        IUIWindow w = this.getUIWindow();
        if (w instanceof KDDialog) {
            KDDialog d = (KDDialog)w;
            d.addWindowListener((WindowListener)new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    RptCalculateSelectorUI.this.endWizard(false);
                }
            });
        }
        w.show();
    }

    public boolean isOk() {
        return this.isOk;
    }

    public boolean isDoCalculate() {
        return this.isDoCalculate;
    }

    private void setDoCalculate(boolean isDoCalculate) {
        this.isDoCalculate = isDoCalculate;
    }

    private void loadQueueList(ArrayList queue, ArrayList sheets) {
        Object o;
        int i;
        int size;
        if (queue != null) {
            size = queue.size();
            for (i = 0; i < size; ++i) {
                o = queue.get(i);
                if (sheets == null || !sheets.contains(o)) continue;
                this.lstRight.addElement(o);
            }
        }
        if (sheets != null) {
            size = sheets.size();
            for (i = 0; i < size; ++i) {
                o = sheets.get(i);
                if (queue == null || queue.contains(o)) continue;
                this.lstLeft.addElement(o);
            }
        }
    }

    private void endWizard(boolean isOkey) {
        this.disposeUIWindow();
        this.isOk = isOkey;
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
        this.initializeUI();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.lstLeft.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    RptCalculateSelectorUI.this.addSheets(RptCalculateSelectorUI.this.lstLeft.getSelectedValues(), RptCalculateSelectorUI.this.lstLeft, RptCalculateSelectorUI.this.lstRight);
                }
            }
        });
        this.lstRight.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    RptCalculateSelectorUI.this.addSheets(RptCalculateSelectorUI.this.lstRight.getSelectedValues(), RptCalculateSelectorUI.this.lstRight, RptCalculateSelectorUI.this.lstLeft);
                }
            }
        });
    }

    public void onShow() throws Exception {
        super.onShow();
        RptHelper.setDefaultButton((CoreUIObject)this, (JButton)this.btnOk);
        RptHelper.setEscAction((CoreUIObject)this, (Action)((Object)this.actionBtnCancel));
    }

    private void initializeUI() {
        RptHelper.setDefaultButton((CoreUIObject)this, (JButton)this.btnOk);
        this.lstLeft.setSelectionMode(2);
        this.lstRight.setSelectionMode(2);
        this.btnAdd.setText(null);
        this.btnAddAll.setText(null);
        this.btnDelete.setText(null);
        this.btnDeleteAll.setText(null);
        this.btnUp.setText(null);
        this.btnDown.setText(null);
        this.btnAdd.setIcon(RptResourceHelper.getIcon("imgTbtn_move_right"));
        this.btnAddAll.setIcon(RptResourceHelper.getIcon("imgTbtn_moveall_right"));
        this.btnDelete.setIcon(RptResourceHelper.getIcon("imgTbtn_move_left"));
        this.btnDeleteAll.setIcon(RptResourceHelper.getIcon("imgTbtn_moveall_left"));
        this.btnUp.setIcon(RptResourceHelper.getIcon("imgTbtn_movetop"));
        this.btnDown.setIcon(RptResourceHelper.getIcon("imgTbtn_movedown"));
    }

    public ArrayList getCalculateQueue() {
        int count = this.lstRight.getElementCount();
        ArrayList<Object> res = new ArrayList<Object>(count);
        for (int i = 0; i < count; ++i) {
            res.add(this.lstRight.getElement(i));
        }
        return res;
    }

    @Override
    public void actionBtnOk_actionPerformed(ActionEvent e) throws Exception {
        super.actionBtnOk_actionPerformed(e);
        this.endWizard(true);
    }

    @Override
    public void actionBtnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionBtnCancel_actionPerformed(e);
        this.endWizard(false);
    }

    @Override
    public void actionDoCalculate_actionPerformed(ActionEvent e) throws Exception {
        super.actionDoCalculate_actionPerformed(e);
        this.endWizard(true);
        this.isDoCalculate = true;
    }

    @Override
    public void actionBtnAdd_actionPerformed(ActionEvent e) throws Exception {
        super.actionBtnAdd_actionPerformed(e);
        this.addSheets(this.lstLeft.getSelectedValues(), this.lstLeft, this.lstRight);
    }

    @Override
    public void actionBtnDel_actionPerformed(ActionEvent e) throws Exception {
        super.actionBtnDel_actionPerformed(e);
        this.addSheets(this.lstRight.getSelectedValues(), this.lstRight, this.lstLeft);
    }

    @Override
    public void actionBtnUp_actionPerformed(ActionEvent e) throws Exception {
        super.actionBtnUp_actionPerformed(e);
        this.sortUpdown(true);
    }

    @Override
    public void actionBtnDown_actionPerformed(ActionEvent e) throws Exception {
        super.actionBtnDown_actionPerformed(e);
        this.sortUpdown(false);
    }

    @Override
    public void actionBtnAddAll_actionPerformed(ActionEvent e) throws Exception {
        super.actionBtnAddAll_actionPerformed(e);
        this.addSheets(this.getAllValues(this.lstLeft), this.lstLeft, this.lstRight);
    }

    @Override
    public void actionBtnDelAll_actionPerformed(ActionEvent e) throws Exception {
        super.actionBtnDelAll_actionPerformed(e);
        this.addSheets(this.getAllValues(this.lstRight), this.lstRight, this.lstLeft);
    }

    private Object[] getAllValues(KDList list) {
        Object[] vs = new Object[list.getElementCount()];
        for (int i = 0; i < vs.length; ++i) {
            vs[i] = list.getElement(i);
        }
        return vs;
    }

    private void addSheets(Object[] vs, KDList from, KDList to) {
        if (vs == null) {
            return;
        }
        for (int i = 0; i < vs.length; ++i) {
            if (vs[i] == null) continue;
            to.addElement(vs[i]);
            from.removeElement(vs[i]);
        }
    }

    private void sortUpdown(boolean isUp) {
        int from;
        int max = this.lstRight.getElementCount() - 1;
        if (max < 0) {
            return;
        }
        int[] is = this.lstRight.getSelectedIndices();
        if (is == null || is.length < 1) {
            MsgBox.showInfo((String)RptUtil.getResourceSince51("PleaseChooseItemToMove"));
            return;
        }
        if (is.length > 1) {
            MsgBox.showInfo((String)RptUtil.getResourceSince51("NoSupportMultiChoose"));
            return;
        }
        int to = from = is[0];
        if (isUp ? --to < 0 : ++to > max) {
            return;
        }
        Object o = this.lstRight.getElement(from);
        this.lstRight.setElement(this.lstRight.getElement(to), from);
        this.lstRight.setElement(o, to);
        this.lstRight.setSelectedValue(o, true);
    }

    public RptMultiCalculateEntry getNewQueueEntry() {
        return new RptMultiCalculateEntry();
    }
}

