/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDScrollBar;
import com.kingdee.bos.ctrl.swing.KDTextArea;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.log.AppLogFactory;
import com.kingdee.eas.base.log.AppLogInfo;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.rpt.RptComment;
import com.kingdee.eas.fi.rpt.RptCommentTank;
import com.kingdee.eas.fi.rpt.RptResourceHelper;
import com.kingdee.eas.fi.rpt.client.AbstractRptCellCmtEditUI;
import com.kingdee.eas.fi.rpt.client.IControlledDialogListener;
import com.kingdee.eas.fi.rpt.client.ISimpleDialog;
import com.kingdee.eas.fi.rpt.client.ISimpleDialogListener;
import com.kingdee.eas.fi.rpt.client.RptHelper;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JScrollBar;

public class RptCellCmtEditUI
extends AbstractRptCellCmtEditUI
implements ISimpleDialog {
    private ArrayList listeners;
    private RptCommentTank comments;
    boolean isSupportNonCreatorEditAnnotations = false;

    public RptCellCmtEditUI() throws Exception {
        this.toolBar = null;
        this.menuBar = null;
        this.statusBar = null;
        this.listeners = new ArrayList(1);
        this.comments = null;
        this.tblEntrys.getLayoutManager().setHorizonScrollBar((JScrollBar)new KDScrollBar(0));
        this.tblEntrys.getLayoutManager().setVerticalScrollBar((JScrollBar)new KDScrollBar(1));
        this.initializeUI();
        this.isSupportNonCreatorEditAnnotations = CslRptUtil.getCslParam(null, (String)"KEY_CSLPARAM_SupportNonCreatorEditAnnotations");
    }

    public static RptCellCmtEditUI getInstance(CoreUIObject parentUI) throws Exception {
        IUIFactory fy = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        IUIWindow wnd = fy.create(RptCellCmtEditUI.class.getName(), (Map)new UIContext((Object)parentUI));
        RptCellCmtEditUI res = (RptCellCmtEditUI)wnd.getUIObject();
        res.onShow();
        return res;
    }

    private void initializeUI() {
        this.btnAdd.setIcon(RptResourceHelper.getIcon("imgTbtn_new"));
        this.btnDelet.setIcon(RptResourceHelper.getIcon("imgTbtn_delete"));
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
        this.btnAdd.setText(null);
        this.btnDelet.setText(null);
        this.tblEntrys.checkParsed();
        this.tblEntrys.getColumn(0).setWidth(90);
        this.tblEntrys.getColumn(1).setWidth(140);
        this.tblEntrys.getColumn(2).setWidth(128);
        this.tblEntrys.getColumn(4).setWidth(140);
        this.txtComment.setEditable(false);
        this.txtComment.setMaxLength(200);
        this.txtComment.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                ((KDTextArea)e.getSource()).selectAll();
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        });
    }

    public void onShow() throws Exception {
        super.onShow();
        RptHelper.setDefaultButton(this, (JButton)this.btnOk);
        RptHelper.setEscAction(this, (Action)((Object)this.actionBtnCancel));
        this.tblEntrys.getActionMap().remove("CancelEdit");
        RptHelper.setFocusTo((Component)this.txtComment);
    }

    @Override
    public void open(Object cookie, String title) {
        this.open(cookie, title, true);
    }

    public void onLoad() throws Exception {
        IUIWindow w = this.getUIWindow();
        if (w instanceof KDDialog) {
            KDDialog d = (KDDialog)w;
            d.addWindowListener((WindowListener)new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    RptCellCmtEditUI.this.endEditor(false);
                }
            });
        }
    }

    public void open(Object cookie, String title, boolean isEditable) {
        this.setEditMode(isEditable);
        this.fireListenersSetout();
        if (!this.loadComments((RptCommentTank)cookie)) {
            this.fireListenersReturnee(null, false);
        }
        this.setUITitle(title);
        IUIWindow w = this.getUIWindow();
        w.show();
    }

    public void setEditMode(boolean isEditable) {
        this.btnAdd.setEnabled(isEditable);
        this.btnDelet.setEnabled(isEditable);
        this.txtComment.setEditable(isEditable);
        this.btnOk.setVisible(isEditable);
        this.btnCancel.setText(this.resHelper.getString(isEditable ? "btnCancel.text" : "btnOk.text"));
    }

    private void endEditor(boolean isOk) {
        this.comments.setContent(this.tblEntrys.getSelectManager().getActiveRowIndex(), this.txtComment.getText(), isOk ? SysContext.getSysContext().getCurrentUserInfo() : null);
        this.disposeUIWindow();
        this.fireListenersReturnee(this.comments, isOk);
    }

    protected boolean loadComments(RptCommentTank cmtTank) {
        RptComment cmt;
        this.comments = new RptCommentTank();
        if (this.comments == null || !this.comments.copyFrom(cmtTank)) {
            return false;
        }
        this.comments.setTable(this.tblEntrys);
        if (this.txtComment.isEditable() && (cmt = this.comments.getFreshEntry()) == null) {
            cmt = this.createComment();
            this.comments.addEntry(cmt);
        }
        this.tblEntrys.addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                KDTSelectBlock bk = e.getPrevSelectBlock();
                if (bk != null && bk.getMode() == 2 && bk.getBeginRow() >= 0) {
                    RptCellCmtEditUI.this.comments.setContent(bk.getBeginRow(), RptCellCmtEditUI.this.txtComment.getText(), RptCellCmtEditUI.this.isSupportNonCreatorEditAnnotations ? SysContext.getSysContext().getCurrentUserInfo() : null);
                }
                if ((bk = e.getSelectBlock()) == null || bk.getMode() != 2 || bk.getBeginRow() < 0) {
                    return;
                }
                RptCellCmtEditUI.this.txtComment.setText(RptCellCmtEditUI.this.comments.getContent(bk.getBeginRow()));
                RptCellCmtEditUI.this.setEditStatus(bk.getBeginRow());
            }
        });
        this.cbxSort.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    RptCellCmtEditUI.this.comments.sort(RptCellCmtEditUI.this.cbxSort.getSelectedIndex());
                    RptCellCmtEditUI.this.tblEntrys.getSelectManager().select(RptCellCmtEditUI.this.comments.indexOf(RptCellCmtEditUI.this.comments.getFreshEntry()), 1, 2);
                }
            }
        });
        this.cbxSort.setSelectedIndex(0);
        this.comments.refresh();
        int sz = this.comments.getSize();
        if (sz > 0) {
            this.tblEntrys.getSelectManager().removeAll(true);
            this.tblEntrys.getSelectManager().select(sz - 1, sz - 1);
        } else {
            this.txtComment.setEditable(false);
        }
        return true;
    }

    private RptComment createComment() {
        return this.fireListenersNeedFreahComment();
    }

    private RptComment fireListenersNeedFreahComment() {
        IControlledDialogListener l;
        RptComment res = null;
        Iterator ls = this.listeners.iterator();
        while (ls.hasNext() && ((l = (IControlledDialogListener)ls.next()) == null || (res = (RptComment)l.getTrueController()) == null)) {
        }
        return res;
    }

    protected void fireListenersReturnee(RptCommentTank cmtTank, boolean isOk) {
        for (ISimpleDialogListener l : this.listeners) {
            if (l == null) continue;
            l.pilotReturnee(this, cmtTank, isOk);
        }
    }

    private void fireListenersSetout() {
        for (ISimpleDialogListener l : this.listeners) {
            if (l == null) continue;
            l.pilotSetout(this);
        }
    }

    @Override
    public synchronized void addSimpleDialogListener(ISimpleDialogListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    @Override
    public void actionBtnAdd_actionPerformed(ActionEvent e) throws Exception {
        super.actionBtnAdd_actionPerformed(e);
        UserInfo currentUser = SysContext.getSysContext().getCurrentUserInfo();
        boolean isExist = false;
        RptComment comment = null;
        for (int i = 0; i < this.comments.getSize(); ++i) {
            comment = this.comments.getEntry(i);
            if (comment.author != null && !comment.author.getId().toString().equals(currentUser.getId().toString())) continue;
            MsgBox.showInfo((String)RptUtil.getResourceSince51("OneUserOneReportCanAddOnlyOnePostil"));
            isExist = true;
            break;
        }
        if (!isExist) {
            comment = this.createComment();
            this.comments.addEntry(comment);
        }
        this.tblEntrys.getSelectManager().select(this.comments.indexOf(comment), 1, 2);
        RptHelper.setFocusTo((Component)this.txtComment);
    }

    @Override
    public void actionBtnDelet_actionPerformed(ActionEvent e) throws Exception {
        super.actionBtnDelet_actionPerformed(e);
        if (this.comments.deletEntry(this.tblEntrys.getSelectManager().getActiveRowIndex())) {
            this.comments.setModify(true);
            this.txtComment.setText("");
            KDTSelectBlock sb = new KDTSelectBlock();
            sb.setTop(0);
            sb.setLeft(1);
            sb.setBottom(0);
            sb.setRight(1);
            sb.setMode(2);
            sb.setTable(this.tblEntrys);
            this.tblEntrys.getSelectManager().select(sb, false);
            if (this.tblEntrys.getExpandedRowCount() > 0) {
                this.txtComment.setText(this.comments.getContent(0));
                this.setEditStatus(0);
            }
        }
    }

    private void setEditStatus(int index) {
        boolean enable;
        UserInfo cu = SysContext.getSysContext().getCurrentUserInfo();
        RptComment cmt = (RptComment)this.comments.getElementAt(index);
        BOSUuid cid = cmt.author == null ? cu.getId() : cmt.author.getId();
        boolean bl = enable = cu != null && cmt != null && cu.getId().equals((Object)cid);
        if (this.isSupportNonCreatorEditAnnotations) {
            enable = true;
        }
        this.txtComment.setEditable(enable);
        this.btnDelet.setEnabled(enable);
    }

    @Override
    public void actionBtnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionBtnCancel_actionPerformed(e);
        this.endEditor(false);
    }

    @Override
    public void actionBtnOk_actionPerformed(ActionEvent e) throws Exception {
        super.actionBtnOk_actionPerformed(e);
        this.endEditor(true);
        HashMap logDatas = new HashMap();
        this.setLogDatas(logDatas);
    }

    public void setLogDatas(HashMap logDatas) throws BOSException {
        logDatas.put("FItemName", "csl_postil_update");
        logDatas.put("FID", this.getID());
        logDatas.put("FUserID", this.getUserId());
        logDatas.put("FUserName", this.getUserName());
        logDatas.put("FClientIP", this.getClientIp());
        logDatas.put("FClientName", this.getClientName());
        logDatas.put("FOccurTime", new Timestamp(System.currentTimeMillis()));
        String locale = SysContext.getSysContext().getLocale().getDisplayLanguage();
        logDatas.put("FEntityAlias_" + locale.toUpperCase(), EASResource.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"202_RptCellCmtEditUI"));
        logDatas.put("FInstanceNo", this.getInstanceNO());
        logDatas.put("FCompanyName_" + locale.toUpperCase(), this.getCurrOrgUnit());
        AppLogFactory.getRemoteInstance().writeLog(logDatas);
    }

    private String getID() {
        AppLogInfo appLogInfo = new AppLogInfo();
        String id = BOSUuid.create((BOSObjectType)appLogInfo.getBOSType()).toString();
        return id;
    }

    private String getUserId() {
        UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
        return userInfo == null ? "" : userInfo.getId().toString();
    }

    private String getUserName() {
        UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
        return userInfo == null ? "" : userInfo.getNumber();
    }

    private String getClientIp() {
        String obj = SysContext.getSysContext().getClientIP();
        return obj == null ? "" : obj.toString();
    }

    private String getClientName() {
        String obj = SysContext.getSysContext().getClientName();
        return obj == null ? "" : obj.toString();
    }

    public String getInstanceNO() throws BOSException {
        String locale = SysContext.getSysContext().getLocale().getDisplayLanguage();
        String s = null;
        s = EASResource.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"202_RptCellCmtEditUI");
        return s;
    }

    private String getCurrOrgUnit() {
        String obj = SysContext.getSysContext().getCurrentOrgUnit().getName();
        return obj == null ? "" : obj.toString();
    }

    public RptCommentTank getComments() {
        return this.comments;
    }

    public void setComments(RptCommentTank comments) {
        this.comments = comments;
    }
}

