/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.client;

import com.kingdee.eas.fi.gr.cslrpt.FormulaCheckResultTypeEnum;
import com.kingdee.eas.fi.rpt.RptContextManager;
import com.kingdee.eas.fi.rpt.client.AbstractRptCheckExpLineEditUI;
import com.kingdee.eas.fi.rpt.client.FormulaPickerUI;
import com.kingdee.eas.fi.rpt.client.IFormulaPickerListener;
import com.kingdee.eas.util.client.EASResource;
import java.awt.event.ActionEvent;
import java.util.HashMap;

public class RptCheckExpLineEditUI
extends AbstractRptCheckExpLineEditUI {
    private HashMap insertMap;
    private boolean isK3 = false;
    private static final String formulaFilter = "exclude:formulas{BgItemM,BgItem,BgAct,Item,FpItem,DItem};exclude:categorys{fm_fp}";
    private PickerListener pickerListener = null;

    public RptCheckExpLineEditUI() throws Exception {
        this.initializeUI();
    }

    public void setK3(boolean isK3) {
        this.isK3 = isK3;
    }

    private void initializeUI() {
        this.insertMap = new HashMap(15, 0.75f);
        this.insertMap.put(this.btnOR, "OR()");
        this.insertMap.put(this.btnNOT, "NOT()");
        this.insertMap.put(this.btnPlus, "+");
        this.insertMap.put(this.btnMinus, "-");
        this.insertMap.put(this.btnMultiply, "*");
        this.insertMap.put(this.btnDivision, "/");
        this.insertMap.put(this.btnAND, "AND()");
        this.insertMap.put(this.btnBracket, "()");
        this.insertMap.put(this.btnEqual, "=");
        this.insertMap.put(this.btnGT, ">");
        this.insertMap.put(this.btnLT, "<");
        this.insertMap.put(this.btnDiff, "<>");
        this.insertMap.put(this.btnDot, ",");
        this.insertMap.put(this.btnIf, "[A]+[B]=[C]{|}");
        this.setName(EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResource.checkCondition"));
        this.initUIContentLayout();
        this.btnOR.setText("OR()");
        this.btnNOT.setText("NOT()");
        this.btnPlus.setText("+");
        this.btnMinus.setText("-");
        this.btnMultiply.setText("*");
        this.btnDivision.setText("/");
        this.btnAND.setText("AND()");
        this.btnBracket.setText("()");
        this.btnEqual.setText("=");
        this.btnGT.setText(">");
        this.btnLT.setText("<");
        this.btnDiff.setText("<>");
        this.btnDot.setText(",");
        this.btnFormula.setText(EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResource.formula"));
        this.txtExpression.setSelectAllOnFocus(false);
    }

    public String getExpression() {
        String res = this.txtExpression.getText();
        if (res != null) {
            res = res.trim();
        }
        return res;
    }

    public String getDescription() {
        String res = this.txtDescription.getText();
        if (res != null) {
            res = res.trim();
        }
        return res;
    }

    public void setExpression(String exp) {
        this.txtExpression.setText(exp);
    }

    public void setDescription(String desc) {
        this.txtDescription.setText(desc);
    }

    protected void initBtn() {
        RptContextManager ctx = (RptContextManager)this.getUIContext().get("REPORT_CONTEXT");
        if (ctx != null && ctx.get("EDIT_FORMULA") != null && !((Boolean)ctx.get("EDIT_FORMULA")).booleanValue()) {
            this.btnFormula.setEnabled(false);
            this.btnFormula.setVisible(false);
        }
    }

    @Override
    public void actionInsertOperate_actionPerformed(ActionEvent e) throws Exception {
        Object src = e.getSource();
        if (src == this.btnFormula) {
            this.insertFormula();
        } else {
            this.insertOperator((String)this.insertMap.get(src), src == this.btnBracket);
        }
    }

    public void setFocus() {
        this.txtExpression.requestFocus();
    }

    private void insertOperator(String word, boolean isBracket) {
        int pos = this.txtExpression.getCaretPosition();
        this.txtExpression.insert(word, pos);
        if (isBracket) {
            this.txtExpression.setCaretPosition(pos + 1);
        }
        this.txtExpression.requestFocus();
    }

    private void insertFormula() {
        if (this.pickerListener == null) {
            this.pickerListener = new PickerListener();
        }
        try {
            FormulaPickerUI picker = FormulaPickerUI.creatFormulaPicker(this);
            picker.setRptContext((RptContextManager)this.getUIContext().get("REPORT_CONTEXT"));
            picker.addFormulaPickerListener(this.pickerListener);
            picker.setExtendable(false);
            picker.setK3(this.isK3);
            picker.open(formulaFilter, null);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    public int getFormulaCheckResultType() {
        if (this.btnShowError.isSelected()) {
            return FormulaCheckResultTypeEnum.SHOWERROR.getValue();
        }
        if (this.btnPostil.isSelected()) {
            return FormulaCheckResultTypeEnum.HASPOSTIL.getValue();
        }
        return FormulaCheckResultTypeEnum.UNCONFIRM.getValue();
    }

    public void setFormulaCheckResultType(int formulaCheckResultType) {
        if (formulaCheckResultType > this.kDButtonGroup1.getButtonCount() || formulaCheckResultType < 1) {
            formulaCheckResultType = 1;
        }
        this.kDButtonGroup1.setValue(--formulaCheckResultType);
    }

    private class PickerListener
    implements IFormulaPickerListener {
        private PickerListener() {
        }

        @Override
        public void pickerSetout(FormulaPickerUI picker) {
        }

        @Override
        public void pickerReturnee(FormulaPickerUI picker, String formulaLine, boolean isOk) {
            if (isOk) {
                RptCheckExpLineEditUI.this.insertOperator(formulaLine, false);
            }
        }
    }
}

